def set_var_limits_and_steps(collider):

    nrj = 7000.
    scale = 23348.89927
    scmin = 0.03*7000./nrj
    qtlimitx28 = 1.0*225.0/scale
    qtlimitx15 = 1.0*205.0/scale
    qtlimit2 = 1.0*160.0/scale
    qtlimit3 = 1.0*200.0/scale
    qtlimit4 = 1.0*125.0/scale
    qtlimit5 = 1.0*120.0/scale
    qtlimit6 = 1.0*90.0/scale

    limitmcbxh =  63.5988e-6
    limitmcbxv =  67.0164e-6
    limitmcbx  =  67.0164e-6
    limitmcby  =  96.3000e-6
    limitmcb   =  80.8000e-6
    limitmcbc  =  89.8700e-6
    limitmcbw  =  80.1400e-6

    collider.vars.vary_default.update({
        'kqtf.a12b1': {'step': 1e-8, 'limits': None},
        'kqtf.a12b2': {'step': 1e-8, 'limits': None},
        'kqtd.a12b1': {'step': 1e-8, 'limits': None},
        'kqtd.a12b2': {'step': 1e-8, 'limits': None},
        'kqtf.a23b1': {'step': 1e-8, 'limits': None},
        'kqtf.a23b2': {'step': 1e-8, 'limits': None},
        'kqtd.a23b1': {'step': 1e-8, 'limits': None},
        'kqtd.a23b2': {'step': 1e-8, 'limits': None},
        'kqtf.a34b1': {'step': 1e-8, 'limits': None},
        'kqtf.a34b2': {'step': 1e-8, 'limits': None},
        'kqtd.a34b1': {'step': 1e-8, 'limits': None},
        'kqtd.a34b2': {'step': 1e-8, 'limits': None},
        'kqtf.a45b1': {'step': 1e-8, 'limits': None},
        'kqtf.a45b2': {'step': 1e-8, 'limits': None},
        'kqtd.a45b1': {'step': 1e-8, 'limits': None},
        'kqtd.a45b2': {'step': 1e-8, 'limits': None},
        'kqtf.a56b1': {'step': 1e-8, 'limits': None},
        'kqtf.a56b2': {'step': 1e-8, 'limits': None},
        'kqtd.a56b1': {'step': 1e-8, 'limits': None},
        'kqtd.a56b2': {'step': 1e-8, 'limits': None},
        'kqtf.a67b1': {'step': 1e-8, 'limits': None},
        'kqtf.a67b2': {'step': 1e-8, 'limits': None},
        'kqtd.a67b1': {'step': 1e-8, 'limits': None},
        'kqtd.a67b2': {'step': 1e-8, 'limits': None},
        'kqtf.a78b1': {'step': 1e-8, 'limits': None},
        'kqtf.a78b2': {'step': 1e-8, 'limits': None},
        'kqtd.a78b1': {'step': 1e-8, 'limits': None},
        'kqtd.a78b2': {'step': 1e-8, 'limits': None},
        'kqtf.a81b1': {'step': 1e-8, 'limits': None},
        'kqtf.a81b2': {'step': 1e-8, 'limits': None},
        'kqtd.a81b1': {'step': 1e-8, 'limits': None},
        'kqtd.a81b2': {'step': 1e-8, 'limits': None},
        'kqf.a12': {'step': 1e-10, 'limits': None},
        'kqd.a12': {'step': 1e-10, 'limits': None},
        'kqf.a23': {'step': 1e-10, 'limits': None},
        'kqd.a23': {'step': 1e-10, 'limits': None},
        'kqf.a34': {'step': 1e-10, 'limits': None},
        'kqd.a34': {'step': 1e-10, 'limits': None},
        'kqf.a45': {'step': 1e-10, 'limits': None},
        'kqd.a45': {'step': 1e-10, 'limits': None},
        'kqf.a56': {'step': 1e-10, 'limits': None},
        'kqd.a56': {'step': 1e-10, 'limits': None},
        'kqf.a67': {'step': 1e-10, 'limits': None},
        'kqd.a67': {'step': 1e-10, 'limits': None},
        'kqf.a78': {'step': 1e-10, 'limits': None},
        'kqd.a78': {'step': 1e-10, 'limits': None},
        'kqf.a81': {'step': 1e-10, 'limits': None},
        'kqd.a81': {'step': 1e-10, 'limits': None},

        'kq5.l2b1':    {'step': 1.0E-6, 'limits': ( qtlimit2*scmin, qtlimit2)},
        'kq4.l2b1':    {'step': 1.0E-6, 'limits': (-qtlimit2,       -qtlimit2*scmin)},
        'kq6.l2b1':    {'step': 1.0E-6, 'limits': (-qtlimit2,       -qtlimit2*scmin)},
        'kq7.l2b1':    {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kq8.l2b1':    {'step': 1.0E-6, 'limits': (-qtlimit3,       -qtlimit3*scmin*0.9)},
        'kq9.l2b1':    {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kq10.l2b1':    {'step': 1.0E-6, 'limits': (-qtlimit3,       -qtlimit3*scmin)},
        'kqtl11.l2b1': {'step': 1.0E-6, 'limits': (-qtlimit4,       qtlimit4)},
        'kqt12.l2b1':  {'step': 1.0E-6, 'limits': (-qtlimit5,       qtlimit5)},
        'kqt13.l2b1':  {'step': 1.0E-6, 'limits': (-qtlimit5,       qtlimit5)},
        'kq4.r2b1':    {'step': 1.0E-6, 'limits': ( qtlimit2*scmin, qtlimit2)},
        'kq5.r2b1':    {'step': 1.0E-6, 'limits': (-qtlimit2,       -qtlimit2*scmin)},
        'kq6.r2b1':    {'step': 1.0E-6, 'limits': ( qtlimit2*scmin, qtlimit2)},
        'kq7.r2b1':    {'step': 1.0E-6, 'limits': (-qtlimit3,       -qtlimit3*scmin)},
        'kq8.r2b1':    {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kq9.r2b1':    {'step': 1.0E-6, 'limits': (-qtlimit3,       -qtlimit3*scmin)},
        'kq10.r2b1':   {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kqtl11.r2b1': {'step': 1.0E-6, 'limits': (-qtlimit4,       qtlimit4)},
        'kqt12.r2b1':  {'step': 1.0E-6, 'limits': (-qtlimit5,       qtlimit5)},
        'kqt13.r2b1':  {'step': 1.0E-6, 'limits': (-qtlimit5,       qtlimit5)},
        'kqt13.l2b2':  {'step': 1.0E-6, 'limits': (-qtlimit5,       qtlimit5)},
        'kqt12.l2b2':  {'step': 1.0E-6, 'limits': (-qtlimit5,       qtlimit5)},
        'kqtl11.l2b2': {'step': 1.0E-6, 'limits': (-qtlimit4,       qtlimit4)},
        'kq10.l2b2':   {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kq9.l2b2':    {'step': 1.0E-6, 'limits': (-qtlimit3,       -qtlimit3*scmin)},
        'kq8.l2b2':    {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kq7.l2b2':    {'step': 1.0E-6, 'limits': (-qtlimit3,       -qtlimit3*scmin)},
        'kq6.l2b2':    {'step': 1.0E-6, 'limits': ( qtlimit2*scmin, qtlimit2)},
        'kq5.l2b2':    {'step': 1.0E-6, 'limits': (-qtlimit2,       -qtlimit2*scmin)},
        'kq4.l2b2':    {'step': 1.0E-6, 'limits': ( qtlimit2*scmin, qtlimit2)},
        'kq4.r2b2':    {'step': 1.0E-6, 'limits': (-qtlimit2,       -qtlimit2*scmin)},
        'kq5.r2b2':    {'step': 1.0E-6, 'limits': ( qtlimit2*scmin, qtlimit2)},
        'kq6.r2b2':    {'step': 1.0E-6, 'limits': (-qtlimit2,       -qtlimit2*scmin)},
        'kq7.r2b2':    {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kq8.r2b2':    {'step': 1.0E-6, 'limits': (-qtlimit3,       -qtlimit3*scmin)},
        'kq9.r2b2':    {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kq10.r2b2':   {'step': 1.0E-6, 'limits': (-qtlimit3,       -qtlimit3*scmin)},
        'kqtl11.r2b2': {'step': 1.0E-6, 'limits': (-qtlimit4,       qtlimit4)},
        'kqt12.r2b2':  {'step': 1.0E-6, 'limits': (-qtlimit5,       qtlimit5)},
        'kqt13.r2b2':  {'step': 1.0E-6, 'limits': (-qtlimit5,       qtlimit5)},

        'kqt13.l3b1':  {'step': 1.0E-9, 'limits': (-qtlimit5, qtlimit5)},
        'kqt12.l3b1':  {'step': 1.0E-9, 'limits': (-qtlimit5, qtlimit5)},
        'kqtl11.l3b1': {'step': 1.0E-9, 'limits': (-qtlimit4*400./550., qtlimit4*400./550.)},
        'kqtl10.l3b1': {'step': 1.0E-9, 'limits': (-qtlimit4, qtlimit4)},
        'kqtl9.l3b1':  {'step': 1.0E-9, 'limits': (-qtlimit4, qtlimit4)},
        'kqtl8.l3b1':  {'step': 1.0E-9, 'limits': (-qtlimit4*450./550., qtlimit4*450./550.)},
        'kqtl7.l3b1':  {'step': 1.0E-9, 'limits': (-qtlimit4, qtlimit4)},
        'kq6.l3b1':    {'step': 1.0E-9, 'limits': (-qtlimit6, qtlimit6)},
        'kq6.r3b1':    {'step': 1.0E-9, 'limits': (-qtlimit6, qtlimit6)},
        'kqtl7.r3b1':  {'step': 1.0E-9, 'limits': (-qtlimit4, qtlimit4)},
        'kqtl8.r3b1':  {'step': 1.0E-9, 'limits': (-qtlimit4, qtlimit4)},
        'kqtl9.r3b1':  {'step': 1.0E-9, 'limits': (-qtlimit4*500./550., qtlimit4*500./550.)},
        'kqtl10.r3b1': {'step': 1.0E-9, 'limits': (-qtlimit4*450./550., qtlimit4*450./550.)},
        'kqtl11.r3b1': {'step': 1.0E-9, 'limits': (-qtlimit4*520./550., qtlimit4*520./550.)},
        'kqt12.r3b1':  {'step': 1.0E-9, 'limits': (-qtlimit5, qtlimit5)},
        'kqt13.r3b1':  {'step': 1.0E-9, 'limits': (-qtlimit5, qtlimit5)},
        'kqt13.l3b2':  {'step': 1.0E-9, 'limits': (-qtlimit5, qtlimit5)},
        'kqt12.l3b2':  {'step': 1.0E-9, 'limits': (-qtlimit5, qtlimit5)},
        'kqtl11.l3b2': {'step': 1.0E-9, 'limits': (-qtlimit4*400./550., qtlimit4*400./550.)},
        'kqtl10.l3b2': {'step': 1.0E-9, 'limits': (-qtlimit4, qtlimit4)},
        'kqtl9.l3b2':  {'step': 1.0E-9, 'limits': (-qtlimit4, qtlimit4)},
        'kqtl8.l3b2':  {'step': 1.0E-9, 'limits': (-qtlimit4*450./550., qtlimit4*450./550.)},
        'kqtl7.l3b2':  {'step': 1.0E-9, 'limits': (-qtlimit4, qtlimit4)},
        'kq6.l3b2':    {'step': 1.0E-9, 'limits': (-qtlimit6, qtlimit6)},
        'kq6.r3b2':    {'step': 1.0E-9, 'limits': (-qtlimit6, qtlimit6)},
        'kqtl7.r3b2':  {'step': 1.0E-9, 'limits': (-qtlimit4, qtlimit4)},
        'kqtl8.r3b2':  {'step': 1.0E-9, 'limits': (-qtlimit4, qtlimit4)},
        'kqtl9.r3b2':  {'step': 1.0E-9, 'limits': (-qtlimit4*500./550., qtlimit4*500./550.)},
        'kqtl10.r3b2': {'step': 1.0E-9, 'limits': (-qtlimit4*450./550., qtlimit4*450./550.)},
        'kqtl11.r3b2': {'step': 1.0E-9, 'limits': (-qtlimit4*520./550., qtlimit4*520./550.)},
        'kqt12.r3b2':  {'step': 1.0E-9, 'limits': (-qtlimit5, qtlimit5)},
        'kqt13.r3b2':  {'step': 1.0E-9, 'limits': (-qtlimit5, qtlimit5)},

        'kqt13.l4b1':  {'step': 1.0E-6, 'limits': (-qtlimit5, qtlimit5)},
        'kqt12.l4b1':  {'step': 1.0E-6, 'limits': (-qtlimit5, qtlimit5)},
        'kqtl11.l4b1': {'step': 1.0E-6, 'limits': (-qtlimit4, qtlimit4)},
        'kq10.l4b1':   {'step': 1.0E-6, 'limits': (-qtlimit3, qtlimit3*scmin)},
        'kq9.l4b1':    {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kq8.l4b1':    {'step': 1.0E-6, 'limits': (-qtlimit3, qtlimit3*scmin)},
        'kq7.l4b1':    {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kq6.l4b1':    {'step': 1.0E-6, 'limits': (-qtlimit2, qtlimit2*scmin)},
        'kq5.l4b1':    {'step': 1.0E-6, 'limits': ( qtlimit2*scmin, qtlimit2)},
        'kq5.r4b1':    {'step': 1.0E-6, 'limits': (-qtlimit2, qtlimit2*scmin)},
        'kq6.r4b1':    {'step': 1.0E-6, 'limits': ( qtlimit2*scmin, qtlimit2)},
        'kq7.r4b1':    {'step': 1.0E-6, 'limits': (-qtlimit3, qtlimit3*scmin)},
        'kq8.r4b1':    {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kq9.r4b1':    {'step': 1.0E-6, 'limits': (-qtlimit3, qtlimit3*scmin)},
        'kq10.r4b1':   {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kqtl11.r4b1': {'step': 1.0E-6, 'limits': (-qtlimit4, qtlimit4)},
        'kqt12.r4b1':  {'step': 1.0E-6, 'limits': (-qtlimit5, qtlimit5)},
        'kqt13.r4b1':  {'step': 1.0E-6, 'limits': (-qtlimit5, qtlimit5)},
        'kqt13.l4b2':  {'step': 1.0E-6, 'limits': (-qtlimit5, qtlimit5)},
        'kqt12.l4b2':  {'step': 1.0E-6, 'limits': (-qtlimit5, qtlimit5)},
        'kqtl11.l4b2': {'step': 1.0E-6, 'limits': (-qtlimit4, qtlimit4)},
        'kq10.l4b2':   {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kq9.l4b2':    {'step': 1.0E-6, 'limits': (-qtlimit3, qtlimit3*scmin)},
        'kq8.l4b2':    {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kq7.l4b2':    {'step': 1.0E-6, 'limits': (-qtlimit3, qtlimit3*scmin)},
        'kq6.l4b2':    {'step': 1.0E-6, 'limits': ( qtlimit2*scmin, qtlimit2)},
        'kq5.l4b2':    {'step': 1.0E-6, 'limits': (-qtlimit2, qtlimit2*scmin)},
        'kq5.r4b2':    {'step': 1.0E-6, 'limits': ( qtlimit2*scmin, qtlimit2)},
        'kq6.r4b2':    {'step': 1.0E-6, 'limits': (-qtlimit2, qtlimit2*scmin)},
        'kq7.r4b2':    {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kq8.r4b2':    {'step': 1.0E-6, 'limits': (-qtlimit3, qtlimit3*scmin)},
        'kq9.r4b2':    {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kq10.r4b2':   {'step': 1.0E-6, 'limits': (-qtlimit3, qtlimit3*scmin)},
        'kqtl11.r4b2': {'step': 1.0E-6, 'limits': (-qtlimit4, qtlimit4)},
        'kqt12.r4b2':  {'step': 1.0E-6, 'limits': (-qtlimit5, qtlimit5)},
        'kqt13.r4b2':  {'step': 1.0E-6, 'limits': (-qtlimit5, qtlimit5)},

        'kqt13.l6b1':  {'step': 1.0E-6, 'limits': (-qtlimit5, qtlimit5)},
        'kqt12.l6b1':  {'step': 1.0E-6, 'limits': (-qtlimit5, qtlimit5)},
        'kqtl11.l6b1': {'step': 1.0E-6, 'limits': (-qtlimit4*400./550., qtlimit4*400./550.)},
        'kq10.l6b1':   {'step': 1.0E-6, 'limits': (-qtlimit3, qtlimit3*scmin)},
        'kq9.l6b1':    {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kq8.l6b1':    {'step': 1.0E-6, 'limits': (-qtlimit3, qtlimit3*scmin)},
        'kq5.l6b1':    {'step': 1.0E-6, 'limits': ( qtlimit2*scmin, qtlimit2*1.05)}, # 5% more (used in the nominal optics...)
        'kq4.l6b1':    {'step': 1.0E-6, 'limits': (-qtlimit2, qtlimit2*scmin)},
        'kq4.r6b1':    {'step': 1.0E-6, 'limits': ( qtlimit2*scmin, qtlimit2)},
        'kq5.r6b1':    {'step': 1.0E-6, 'limits': (-qtlimit2, qtlimit2*scmin)},
        'kq8.r6b1':    {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kq9.r6b1':    {'step': 1.0E-6, 'limits': (-qtlimit3, qtlimit3*scmin)},
        'kq10.r6b1':   {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kqtl11.r6b1': {'step': 1.0E-6, 'limits': (-qtlimit4*300./550., qtlimit4*300./550.)},
        'kqt12.r6b1':  {'step': 1.0E-6, 'limits': (-qtlimit5, qtlimit5)},
        'kqt13.r6b1':  {'step': 1.0E-6, 'limits': (-qtlimit5, qtlimit5)},
        'kqt13.l6b2':  {'step': 1.0E-6, 'limits': (-qtlimit5, qtlimit5)},
        'kqt12.l6b2':  {'step': 1.0E-6, 'limits': (-qtlimit5, qtlimit5)},
        'kqtl11.l6b2': {'step': 1.0E-6, 'limits': (-qtlimit4*400./550., qtlimit4*400./550.)},
        'kq10.l6b2':   {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kq9.l6b2':    {'step': 1.0E-6, 'limits': (-qtlimit3, qtlimit3*scmin)},
        'kq8.l6b2':    {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kq5.l6b2':    {'step': 1.0E-6, 'limits': (-qtlimit3, qtlimit3*scmin)},
        'kq4.l6b2':    {'step': 1.0E-6, 'limits': ( qtlimit2*scmin, qtlimit2)},
        'kq4.r6b2':    {'step': 1.0E-6, 'limits': (-qtlimit2, qtlimit2*scmin)},
        'kq5.r6b2':    {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kq8.r6b2':    {'step': 1.0E-6, 'limits': (-qtlimit3, qtlimit3*scmin)},
        'kq9.r6b2':    {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kq10.r6b2':   {'step': 1.0E-6, 'limits': (-qtlimit3, qtlimit3*scmin)},
        'kqtl11.r6b2': {'step': 1.0E-6, 'limits': (-qtlimit4*300./550., qtlimit4*300./550.)},
        'kqt12.r6b2':  {'step': 1.0E-6, 'limits': (-qtlimit5, qtlimit5)},
        'kqt13.r6b2':  {'step': 1.0E-6, 'limits': (-qtlimit5, qtlimit5)},

        'kqt13.l7b1':  {'step': 1.0E-9, 'limits': (-qtlimit5, qtlimit5)},
        'kqt12.l7b1':  {'step': 1.0E-9, 'limits': (-qtlimit5, qtlimit5)},
        'kqtl11.l7b1': {'step': 1.0E-9, 'limits': (-qtlimit4*300./550., qtlimit4*300./550.)},
        'kqtl10.l7b1': {'step': 1.0E-9, 'limits': (-qtlimit4*500./550., qtlimit4*500./550.)},
        'kqtl9.l7b1':  {'step': 1.0E-9, 'limits': (-qtlimit4*400./550., qtlimit4*400./550.)},
        'kqtl8.l7b1':  {'step': 1.0E-9, 'limits': (-qtlimit4*300./550., qtlimit4*300./550.)},
        'kqtl7.l7b1':  {'step': 1.0E-9, 'limits': (-qtlimit4, qtlimit4)},
        'kq6.l7b1':    {'step': 1.0E-9, 'limits': (-qtlimit6, qtlimit6)},
        'kq6.r7b1':    {'step': 1.0E-9, 'limits': (-qtlimit6, qtlimit6)},
        'kqtl7.r7b1':  {'step': 1.0E-9, 'limits': (-qtlimit4, qtlimit4)},
        'kqtl8.r7b1':  {'step': 1.0E-9, 'limits': (-qtlimit4*550./550., qtlimit4*550./550.)},
        'kqtl9.r7b1':  {'step': 1.0E-9, 'limits': (-qtlimit4*500./550., qtlimit4*500./550.)},
        'kqtl10.r7b1': {'step': 1.0E-9, 'limits': (-qtlimit4, qtlimit4)},
        'kqtl11.r7b1': {'step': 1.0E-9, 'limits': (-qtlimit4, qtlimit4)},
        'kqt12.r7b1':  {'step': 1.0E-9, 'limits': (-qtlimit5, qtlimit5)},
        'kqt13.r7b1':  {'step': 1.0E-9, 'limits': (-qtlimit5, qtlimit5)},
        'kqt13.l7b2':  {'step': 1.0E-9, 'limits': (-qtlimit5, qtlimit5)},
        'kqt12.l7b2':  {'step': 1.0E-9, 'limits': (-qtlimit5, qtlimit5)},
        'kqtl11.l7b2': {'step': 1.0E-9, 'limits': (-qtlimit4*300./550., qtlimit4*300./550.)},
        'kqtl10.l7b2': {'step': 1.0E-9, 'limits': (-qtlimit4*500./550., qtlimit4*500./550.)},
        'kqtl9.l7b2':  {'step': 1.0E-9, 'limits': (-qtlimit4*400./550., qtlimit4*400./550.)},
        'kqtl8.l7b2':  {'step': 1.0E-9, 'limits': (-qtlimit4*300./550., qtlimit4*300./550.)},
        'kqtl7.l7b2':  {'step': 1.0E-9, 'limits': (-qtlimit4, qtlimit4)},
        'kq6.l7b2':    {'step': 1.0E-9, 'limits': (-qtlimit6, qtlimit6)},
        'kq6.r7b2':    {'step': 1.0E-9, 'limits': (-qtlimit6, qtlimit6)},
        'kqtl7.r7b2':  {'step': 1.0E-9, 'limits': (-qtlimit4, qtlimit4)},
        'kqtl8.r7b2':  {'step': 1.0E-9, 'limits': (-qtlimit4*550./550., qtlimit4*550./550.)},
        'kqtl9.r7b2':  {'step': 1.0E-9, 'limits': (-qtlimit4*500./550., qtlimit4*500./550.)},
        'kqtl10.r7b2': {'step': 1.0E-9, 'limits': (-qtlimit4, qtlimit4)},
        'kqtl11.r7b2': {'step': 1.0E-9, 'limits': (-qtlimit4, qtlimit4)},
        'kqt12.r7b2':  {'step': 1.0E-9, 'limits': (-qtlimit5, qtlimit5)},
        'kqt13.r7b2':  {'step': 1.0E-9, 'limits': (-qtlimit5, qtlimit5)},

        'kq4.r8b1':    {'step': 1.0E-6, 'limits': ( qtlimit2*scmin, qtlimit2)},
        'kq5.r8b1':    {'step': 1.0E-6, 'limits': (-qtlimit2, qtlimit2*scmin)},
        'kq6.r8b1':    {'step': 1.0E-6, 'limits': ( qtlimit2*scmin, qtlimit2)},
        'kq7.r8b1':    {'step': 1.0E-6, 'limits': (-qtlimit3, qtlimit3*scmin)},
        'kq8.r8b1':    {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kq9.r8b1':    {'step': 1.0E-6, 'limits': (-qtlimit3, qtlimit3*scmin)},
        'kq10.r8b1':   {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kqtl11.r8b1': {'step': 1.0E-6, 'limits': (-qtlimit4, qtlimit4)},
        'kqt12.r8b1':  {'step': 1.0E-6, 'limits': (-qtlimit5, qtlimit5)},
        'kqt13.r8b1':  {'step': 1.0E-6, 'limits': (-qtlimit5, qtlimit5)},
        'kq4.l8b1':    {'step': 1.0E-6, 'limits': (-qtlimit2, qtlimit2*scmin)},
        'kq5.l8b1':    {'step': 1.0E-6, 'limits': ( qtlimit2*scmin, qtlimit2)},
        'kq6.l8b1':    {'step': 1.0E-6, 'limits': (-qtlimit3, qtlimit3*scmin)},
        'kq7.l8b1':    {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kq8.l8b1':    {'step': 1.0E-6, 'limits': (-qtlimit3, qtlimit3*scmin)},
        'kq9.l8b1':    {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kq10.l8b1':   {'step': 1.0E-6, 'limits': (-qtlimit3, qtlimit3*scmin)},
        'kqtl11.l8b1': {'step': 1.0E-6, 'limits': (-qtlimit4, qtlimit4)},
        'kqt12.l8b1':  {'step': 1.0E-6, 'limits': (-qtlimit5, qtlimit5)},
        'kqt13.l8b1':  {'step': 1.0E-6, 'limits': (-qtlimit5, qtlimit5)},
        'kq4.r8b2':    {'step': 1.0E-6, 'limits': (-qtlimit2, qtlimit2*scmin)},
        'kq5.r8b2':    {'step': 1.0E-6, 'limits': ( qtlimit2*scmin, qtlimit2)},
        'kq6.r8b2':    {'step': 1.0E-6, 'limits': (-qtlimit2, qtlimit2*scmin)},
        'kq7.r8b2':    {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kq8.r8b2':    {'step': 1.0E-6, 'limits': (-qtlimit3, qtlimit3*scmin)},
        'kq9.r8b2':    {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kq10.r8b2':   {'step': 1.0E-6, 'limits': (-qtlimit3, qtlimit3*scmin)},
        'kqtl11.r8b2': {'step': 1.0E-6, 'limits': (-qtlimit4, qtlimit4)},
        'kqt12.r8b2':  {'step': 1.0E-6, 'limits': (-qtlimit5, qtlimit5)},
        'kqt13.r8b2':  {'step': 1.0E-6, 'limits': (-qtlimit5, qtlimit5)},
        'kq5.l8b2':    {'step': 1.0E-6, 'limits': (-qtlimit2, qtlimit2*scmin)},
        'kq4.l8b2':    {'step': 1.0E-6, 'limits': ( qtlimit2*scmin, qtlimit2)},
        'kq6.l8b2':    {'step': 1.0E-6, 'limits': ( qtlimit2*scmin, qtlimit2)},
        'kq7.l8b2':    {'step': 1.0E-6, 'limits': (-qtlimit3, qtlimit3*scmin)},
        'kq8.l8b2':    {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kq9.l8b2':    {'step': 1.0E-6, 'limits': (-qtlimit3, qtlimit3*scmin)},
        'kq10.l8b2':   {'step': 1.0E-6, 'limits': ( qtlimit3*scmin, qtlimit3)},
        'kqtl11.l8b2': {'step': 1.0E-6, 'limits': (-qtlimit4, qtlimit4)},
        'kqt12.l8b2':  {'step': 1.0E-6, 'limits': (-qtlimit5, qtlimit5)},
        'kqt13.l8b2':  {'step': 1.0E-6, 'limits': (-qtlimit5, qtlimit5)},

        # Single beam correctors at IR2 (Q4 and Q5, H and V)
        'acbyvs4.l2b1':{'step': 1.0e-15, 'limits': (-limitmcby, limitmcby)},
        'acbyvs4.r2b2':{'step': 1.0e-15, 'limits': (-limitmcby, limitmcby)},
        'acbyvs4.l2b2':{'step': 1.0e-15, 'limits': (-limitmcby, limitmcby)},
        'acbyvs4.r2b1':{'step': 1.0e-15, 'limits': (-limitmcby, limitmcby)},
        'acbyvs5.l2b2':{'step': 1.0e-15, 'limits': (-limitmcby, limitmcby)},
        'acbyvs5.l2b1':{'step': 1.0e-15, 'limits': (-limitmcby, limitmcby)},
        'acbcvs5.r2b1':{'step': 1.0e-15, 'limits': (-limitmcbc, limitmcbc)},
        'acbcvs5.r2b2':{'step': 1.0e-15, 'limits': (-limitmcbc, limitmcbc)},
        'acbyhs4.l8b1':{'step': 1.0e-15, 'limits': (-limitmcby, limitmcby)},
        'acbyhs4.r8b2':{'step': 1.0e-15, 'limits': (-limitmcby, limitmcby)},
        'acbyhs4.l8b2':{'step': 1.0e-15, 'limits': (-limitmcby, limitmcby)},
        'acbyhs4.r8b1':{'step': 1.0e-15, 'limits': (-limitmcby, limitmcby)},
        'acbchs5.l8b2':{'step': 1.0e-15, 'limits': (-limitmcby, limitmcby)},
        'acbchs5.l8b1':{'step': 1.0e-15, 'limits': (-limitmcby, limitmcby)},
        'acbyhs5.r8b1':{'step': 1.0e-15, 'limits': (-limitmcbc, limitmcbc)},
        'acbyhs5.r8b2':{'step': 1.0e-15, 'limits': (-limitmcbc, limitmcbc)},

        # Correctors in IR8 (Q4 and Q5, and triplet)
        'acbyhs4.l8b1':{'step': 1.0e-15,'limits':(-limitmcby, limitmcby)},
        'acbyhs4.r8b2':{'step': 1.0e-15,'limits':(-limitmcby, limitmcby)},
        'acbyhs4.l8b2':{'step': 1.0e-15,'limits':(-limitmcby, limitmcby)},
        'acbyhs4.r8b1':{'step': 1.0e-15,'limits':(-limitmcby, limitmcby)},
        'acbchs5.l8b2':{'step': 1.0e-15,'limits':(-limitmcby, limitmcby)},
        'acbchs5.l8b1':{'step': 1.0e-15,'limits':(-limitmcby, limitmcby)},
        'acbyhs5.r8b1':{'step': 1.0e-15,'limits':(-limitmcbc, limitmcbc)},
        'acbyhs5.r8b2':{'step': 1.0e-15,'limits':(-limitmcbc, limitmcbc)},
        'acbxh1.l8':   {'step': 1.0e-15, 'limits':(-limitmcbx, limitmcbx)},
        'acbxh2.l8':   {'step': 1.0e-15, 'limits':(-limitmcbx, limitmcbx)},
        'acbxh3.l8':   {'step': 1.0e-15, 'limits':(-limitmcbx, limitmcbx)},
        'acbxh1.r8':   {'step': 1.0e-15, 'limits':(-limitmcbx, limitmcbx)},
        'acbxh2.r8':   {'step': 1.0e-15, 'limits':(-limitmcbx, limitmcbx)},
        'acbxh3.r8':   {'step': 1.0e-15, 'limits':(-limitmcbx, limitmcbx)},
        'acbyvs4.l8b1':{'step': 1.0e-15, 'limits':(-limitmcby, limitmcby)},
        'acbcvs5.l8b1':{'step': 1.0e-15, 'limits':(-limitmcbc, limitmcbc)},
        'acbyvs4.r8b1':{'step': 1.0e-15, 'limits':(-limitmcby, limitmcby)},
        'acbyvs5.r8b1':{'step': 1.0e-15, 'limits':(-limitmcby, limitmcby)},
        'acbyvs4.l8b2':{'step': 1.0e-15, 'limits':(-limitmcby, limitmcby)},
        'acbcvs5.l8b2':{'step': 1.0e-15, 'limits':(-limitmcbc, limitmcbc)},
        'acbyvs4.r8b2':{'step': 1.0e-15, 'limits':(-limitmcby, limitmcby)},
        'acbyvs5.r8b2':{'step': 1.0e-15, 'limits':(-limitmcby, limitmcby)},
        'acbxv1.l8':   {'step': 1.0e-15, 'limits':(-limitmcbx, limitmcbx)},
        'acbxv2.l8':   {'step': 1.0e-15, 'limits':(-limitmcbx, limitmcbx)},
        'acbxv3.l8':   {'step': 1.0e-15, 'limits':(-limitmcbx, limitmcbx)},
        'acbxv1.r8':   {'step': 1.0e-15, 'limits':(-limitmcbx, limitmcbx)},
        'acbxv2.r8':   {'step': 1.0e-15, 'limits':(-limitmcbx, limitmcbx)},
        'acbxv3.r8':   {'step': 1.0e-15, 'limits':(-limitmcbx, limitmcbx)},
    })
