# copyright ############################### #
# This file is part of the Xtrack Package.  #
# Copyright (c) CERN, 2025.                 #
# ######################################### #


# Standard particle masses in eV
ELECTRON_MASS_EV =        510998.95     # best known value:    510998.95000 ± 0.15 meV    PDG (2024)
MUON_MASS_EV     =     105658375.5      # best known value:    105658375.5 ± 2.3 eV       PDG (2024)
PION_MASS_EV     =     139570390.0      # best known value:    139570390 ± 180 eV         PDG (2024)
KAON_MASS_EV     =     493677000.0      # best known value:    493677000 ± 15 keV         PDG (2024)
PROTON_MASS_EV   =     938272088.16     # best known value:    938272088.16 ± 0.29 eV     PDG (2024)
DEUTERON_MASS_EV =    1875612945.00     # best known value:    1875612945.00 ± 0.58 eV    NIST (2024)
TRITON_MASS_EV   =    2808921136.68     # best known value:    2808921136.68 ± 0.88 eV    NIST (2024)
He3_MASS_EV      =    2808391611.12     # best known value:    2808391611.12 ± 0.88 eV    NIST (2024)
He4_MASS_EV      =    3727379411.8      # best known value:    3727379411.8 ± 1.2 eV      NIST (2024)

# Ions
U_MASS_EV        =     931494102.42     # best known value:    931494102.42 ± 0.28 eV     2018 CODATA

C10_MASS_EV      =    9330639707.0      # estimate:       10.01685322 ± 8e-8 u            => σ = 75 eV
C11_MASS_EV      =   10257084532.0      # estimate:       11.01143260 ± 6e-8 u            => σ = 56 eV
C12_MASS_EV      =   11177929229.0      # defined as 12 u                                 => σ = 3.4 eV
C13_MASS_EV      =   12112548340.8      # estimate:       13.003354835336 ± 2.52e-10 u    => σ = 3.7 eV
C14_MASS_EV      =   13043937327.9      # estimate:       14.003241989 ± 4e-9 u           => σ = 5.4 eV
C15_MASS_EV      =   13982284810.0      # estimate:       15.0105993 ± 9e-7 u             => σ = 840 eV

O14_MASS_EV      =   13048925215.0      # estimate:       14.008596706 ± 2.7e-8 u         => σ = 26 eV
O15_MASS_EV      =   13975267170.0      # estimate:       15.0030656 ± 5e-7 u             => σ = 470 eV
O16_MASS_EV      =   14899168636.6      # estimate:       15.994914619257 ± 3.19e-10 u    => σ = 4.5 eV
O17_MASS_EV      =   15834590977.0      # estimate:       16.999131755953 ± 6.92e-10 u    => σ = 4.8 eV
O18_MASS_EV      =   16766111027.3      # estimate:       17.999159612136 ± 6.90e-10 u    => σ = 5.1 eV
O19_MASS_EV      =   17701720900.0      # estimate:       19.0035780 ± 2.8e-6 u           => σ = 2.7 keV
O20_MASS_EV      =   18633678340.0      # estimate:       20.0040754 ± 9e-7 u             => σ = 840 eV

Ne19_MASS_EV     =   17700140000.0      # estimate:       19.00188091 ± 1.7e-7 u          => σ = 160 eV
Ne20_MASS_EV     =   18622840116.3      # estimate:       19.9924401753 ± 1.6e-9 u        => σ = 5.9 eV
Ne21_MASS_EV     =   19555644383.0      # estimate:       20.99384669 ± 4e-8 u            => σ = 38 eV
Ne22_MASS_EV     =   20484845538.0      # estimate:       21.991385114 ± 1.9e-8 u         => σ = 19 eV
Ne23_MASS_EV     =   21419210320.0      # estimate:       22.99446691 ± 1.1e-7 u          => σ = 110 eV
Ne24_MASS_EV     =   22349906830.0      # estimate:       23.9936106 ± 6e-7 u             => σ = 560 eV

Ar35_MASS_EV     =   32579246300.0      # estimate:       34.97525772 ± 7.3e-7 u          => σ = 680 eV
Ar36_MASS_EV     =   33503556145.0      # estimate:       35.967545106 ± 2.8e-8 u         => σ = 28 eV
Ar37_MASS_EV     =   34434334110.0      # estimate:       36.96677630 ± 2.2e-7 u          => σ = 210 eV
Ar38_MASS_EV     =   35362061070.0      # estimate:       37.96273210 ± 2.1e-7 u          => σ = 200 eV
Ar39_MASS_EV     =   36295027800.0      # estimate:       38.9643130 ± 5.4e-6 u           => σ = 5.1 keV
Ar40_MASS_EV     =   37224724197.0      # estimate:       39.9623831220 ± 2.3e-9 u        => σ = 12 eV
Ar41_MASS_EV     =   38158190689.0      # estimate:       40.96450057 ± 3.7e-7 u          => σ = 350 eV
Ar42_MASS_EV     =   39088329600.0      # estimate:       41.9630457 ± 6.2e-6 u           => σ = 5.8 keV
Ar43_MASS_EV     =   40022236600.0      # estimate:       42.9656361 ± 5.7e-6 u           => σ = 5.4 keV
Ar44_MASS_EV     =   40953067200.0      # estimate:       43.9649238 ± 1.7e-6 u           => σ = 1.6 keV
Ar45_MASS_EV     =   41887463810.0      # estimate:       44.96803973 ± 5.5e-7 u          => σ = 520 eV
Ar46_MASS_EV     =   42818957400.0      # estimate:       45.9680392 ± 2.5e-6 u           => σ = 2.4 keV
Ar47_MASS_EV     =   43754855500.0      # estimate:       46.9727671 ± 1.3e-6 u           => σ = 1.3 keV

Fe52_MASS_EV     =   48389361230.0      # estimate:       51.94811336 ± 1.9e-7 u          => σ = 180 eV
Fe53_MASS_EV     =   49318239900.0      # estimate:       52.9453056 ± 1.8e-6 u           => σ = 1.7 keV
Fe54_MASS_EV     =   50244426920.0      # estimate:       53.93960819 ± 3.7e-7 u          => σ = 350 eV
Fe55_MASS_EV     =   51174694210.0      # estimate:       54.93829116 ± 3.3e-7 u          => σ = 310 eV
Fe56_MASS_EV     =   52103062570.0      # estimate:       55.93493554 ± 2.9e-7 u          => σ = 270 eV
Fe57_MASS_EV     =   53034981820.0      # estimate:       56.93539195 ± 2.9e-7 u          => σ = 270 eV
Fe58_MASS_EV     =   53964502670.0      # estimate:       57.93327358 ± 3.4e-7 u          => σ = 320 eV
Fe59_MASS_EV     =   54897487080.0      # estimate:       58.93487349 ± 3.5e-7 u          => σ = 330 eV
Fe60_MASS_EV     =   55828232900.0      # estimate:       59.9340702 ± 3.7e-6 u           => σ = 3.5 keV
Fe61_MASS_EV     =   56762219700.0      # estimate:       60.9367462 ± 2.8e-6 u           => σ = 2.6 keV
Fe62_MASS_EV     =   57693756300.0      # estimate:       61.9367918 ± 3.0e-6 u           => σ = 2.8 keV
Fe63_MASS_EV     =   58628492800.0      # estimate:       62.9402727 ± 4.6e-6 u           => σ = 4.3 keV
Fe64_MASS_EV     =   59560653000.0      # estimate:       63.9409878 ± 5.4e-6 u           => σ = 5.1 keV

Xe112_MASS_EV    =  104267313200.0      # estimate:      111.9355591 ± 8.9e-6 u           => σ = 8.3 keV
Xe113_MASS_EV    =  105196621000.0      # estimate:      112.9332217 ± 7.3e-6 u           => σ = 6.8 keV
Xe114_MASS_EV    =  106123241000.0      # estimate:      113.927980 ± 1.2e-5 u            => σ = 12 keV
Xe115_MASS_EV    =  107053165000.0      # estimate:      114.926294 ± 1.3e-5 u            => σ = 13 keV
Xe116_MASS_EV    =  107980269000.0      # estimate:      115.921581 ± 1.4e-5 u            => σ = 13 keV
Xe117_MASS_EV    =  108910625000.0      # estimate:      116.920359 ± 1.1e-5 u            => σ = 11 keV
Xe118_MASS_EV    =  109838225000.0      # estimate:      117.916179 ± 1.1e-5 u            => σ = 11 keV
Xe119_MASS_EV    =  110769004000.0      # estimate:      118.915411 ± 1.1e-5 u            => σ = 11 keV
Xe120_MASS_EV    =  111697120000.0      # estimate:      119.911784 ± 1.3e-5 u            => σ = 13 keV
Xe121_MASS_EV    =  112628305000.0      # estimate:      120.911453 ± 1.1e-5 u            => σ = 11 keV
Xe122_MASS_EV    =  113556926000.0      # estimate:      121.908368 ± 1.2e-5 u            => σ = 12 keV
Xe123_MASS_EV    =  114488526100.0      # estimate:      122.908482 ± 1.0e-5 u            => σ = 9.3 keV
Xe124_MASS_EV    =  115417601300.0      # estimate:      123.9058852 ± 1.5e-6 u           => σ = 1.4 keV
Xe125_MASS_EV    =  116349563400.0      # estimate:      124.9063876 ± 1.5e-6 u           => σ = 1.4 keV
Xe126_MASS_EV    =  117279110518.0      # estimate:      125.9042974220 ± 6.0e-9 u        => σ = 37 eV
Xe127_MASS_EV    =  118211430100.0      # estimate:      126.9051836 ± 4.4e-6 u           => σ = 4.1 keV
Xe128_MASS_EV    =  119141384575.0      # estimate:      127.9035307534 ± 5.6e-9 u        => σ = 37 eV
Xe129_MASS_EV    =  120074043142.0      # estimate:      128.9047808574 ± 5.4e-9 u        => σ = 37 eV
Xe130_MASS_EV    =  121004352839.0      # estimate:      129.903509346 ± 1.0e-8 u         => σ = 38 eV
Xe131_MASS_EV    =  121937313842.0      # estimate:      130.9050841281 ± 5.5e-9 u        => σ = 37 eV
Xe132_MASS_EV    =  122867942545.0      # estimate:      131.9041550835 ± 5.4e-9 u        => σ = 38 eV
Xe133_MASS_EV    =  123801072000.0      # estimate:      132.9059107 ± 2.6e-6 u           => σ = 2.5 keV
Xe134_MASS_EV    =  124732083890.0      # estimate:      133.9053930300 ± 6.0e-9 u        => σ = 38 eV
Xe135_MASS_EV    =  125665290400.0      # estimate:      134.9072314 ± 3.9e-6 u           => σ = 3.7 keV
Xe136_MASS_EV    =  126596768759.0      # estimate:      135.9072144740 ± 7.0e-9 u        => σ = 39 eV
Xe137_MASS_EV    =  127532308620.0      # estimate:      136.91155777 ± 1.1e-7 u          => σ = 110 eV
Xe138_MASS_EV    =  128466214000.0      # estimate:      137.9141463 ± 3.0e-6 u           => σ = 2.8 keV
Xe139_MASS_EV    =  129402035700.0      # estimate:      138.9187922 ± 2.3e-6 u           => σ = 2.2 keV
Xe140_MASS_EV    =  130336187900.0      # estimate:      139.9216458 ± 2.5e-6 u           => σ = 2.4 keV
Xe141_MASS_EV    =  131272471200.0      # estimate:      140.9267872 ± 3.1e-6 u           => σ = 2.9 keV
Xe142_MASS_EV    =  132206932900.0      # estimate:      141.9299731 ± 2.9e-6 u           => σ = 2.7 keV

Au176_MASS_EV    =  163924444000.0      # estimate:      175.980120  ±  4.0e-5 u          => σ = 38 keV
Au177_MASS_EV    =  164852911000.0      # estimate:      176.976870  ±  1.1e-5 u          => σ = 11 keV
Au178_MASS_EV    =  165783647000.0      # estimate:      177.976057  ±  1.1e-5 u          => σ = 11 keV
Au179_MASS_EV    =  166712456000.0      # estimate:      178.973174  ±  1.3e-5 u          => σ = 13 keV
Au180_MASS_EV    =  167643312800.0      # estimate:      179.9724898  ±  5.1e-6 u         => σ = 4.8 keV
Au181_MASS_EV    =  168572561000.0      # estimate:      180.970079  ±  2.1e-5 u          => σ = 20 keV
Au182_MASS_EV    =  169503622000.0      # estimate:      181.969614  ±  2.0e-5 u          => σ = 19 keV
Au183_MASS_EV    =  170433229200.0      # estimate:      182.967588  ±  1.0e-5 u          => σ = 9.4 keV
Au184_MASS_EV    =  171364597000.0      # estimate:      183.967452  ±  2.4e-5 u          => σ = 23 keV
Au185_MASS_EV    =  172294550800.0      # estimate:      184.9657989  ±  2.8e-6 u         => σ = 2.7 keV
Au186_MASS_EV    =  173226188000.0      # estimate:      185.965953  ±  2.3e-5 u          => σ = 22 keV
Au187_MASS_EV    =  174156368000.0      # estimate:      186.964542  ±  2.4e-5 u          => σ = 23 keV
Au188_MASS_EV    =  175088520000.0      # estimate:      187.9652480  ±  2.9e-6 u         => σ = 2.7 keV
Au189_MASS_EV    =  176018803000.0      # estimate:      188.963948  ±  2.2e-5 u          => σ = 21 keV
Au190_MASS_EV    =  176951046200.0      # estimate:      189.9647520  ±  4.0e-6 u         => σ = 3.8 keV
Au191_MASS_EV    =  177881575200.0      # estimate:      190.9637160  ±  5.0e-6 u         => σ = 4.7 keV
Au192_MASS_EV    =  178814096000.0      # estimate:      191.964818  ±  1.7e-5 u          => σ = 16 keV
Au193_MASS_EV    =  179744956500.0      # estimate:      192.9641380  ±  9.0e-6 u         => σ = 8.4 keV
Au194_MASS_EV    =  180677644000.0      # estimate:      193.9654191  ±  2.3e-6 u         => σ = 2.2 keV
Au195_MASS_EV    =  181608782900.0      # estimate:      194.9650378  ±  1.2e-6 u         => σ = 1.2 keV
Au196_MASS_EV    =  182541705200.0      # estimate:      195.9665710  ±  3.0e-6 u         => σ = 2.8 keV
Au197_MASS_EV    =  183473198420.0      # estimate:      196.96657010  ±  6.0e-7 u        => σ = 570 eV
Au198_MASS_EV    =  184406251470.0      # estimate:      197.96824370  ±  6.0e-7 u        => σ = 570 eV
Au199_MASS_EV    =  185338232650.0      # estimate:      198.96876660  ±  6.0e-7 u        => σ = 570 eV
Au200_MASS_EV    =  186271581000.0      # estimate:      199.970757  ±  2.9e-5 u          => σ = 27 keV
Au201_MASS_EV    =  187203914200.0      # estimate:      200.9716580  ±  3.0e-6 u         => σ = 2.8 keV
Au202_MASS_EV    =  188137456000.0      # estimate:      201.973856  ±  2.5e-5 u          => σ = 24 keV
Au203_MASS_EV    =  189070159400.0      # estimate:      202.9751545  ±  3.3e-6 u         => σ = 3.1 keV
Au204_MASS_EV    =  190004410000.0      # estimate:      203.97811  ±  2.2e-4 u           => σ = 210 keV
Au205_MASS_EV    =  190937720000.0      # estimate:      204.98006  ±  2.2e-4 u           => σ = 210 keV
Au206_MASS_EV    =  191873600000.0      # estimate:      205.98477  ±  3.2e-4 u           => σ = 300 keV
Au207_MASS_EV    =  192808640000.0      # estimate:      206.98858  ±  3.2e-4 u           => σ = 300 keV
Au208_MASS_EV    =  193744870000.0      # estimate:      207.99366  ±  3.2e-4 u           => σ = 300 keV
Au209_MASS_EV    =  194680040000.0      # estimate:      208.99761  ±  4.3e-4 u           => σ = 410 keV
Au210_MASS_EV    =  195616440000.0      # estimate:      210.00288  ±  4.3e-4 u           => σ = 410 keV

Pb185_MASS_EV    =  172314868000.0      # estimate:      184.987610 ± 1.7e-5 u            => σ = 16 keV
Pb186_MASS_EV    =  173243222000.0      # estimate:      185.984239 ± 1.2e-5 u            => σ = 12 keV
Pb187_MASS_EV    =  174174410200.0      # estimate:      186.9839108 ± 5.5e-6 u           => σ = 5.2 keV
Pb188_MASS_EV    =  175103080000.0      # estimate:      187.980879 ± 1.1e-5 u            => σ = 11 keV
Pb189_MASS_EV    =  176034542000.0      # estimate:      188.980844 ± 1.5e-5 u            => σ = 14 keV
Pb190_MASS_EV    =  176963463000.0      # estimate:      189.978082 ± 1.3e-5 u            => σ = 13 keV
Pb191_MASS_EV    =  177895082400.0      # estimate:      190.9782165 ± 7.1e-6 u           => σ = 6.7 keV
Pb192_MASS_EV    =  178824315800.0      # estimate:      191.9757896 ± 6.1e-6 u           => σ = 5.7 keV
Pb193_MASS_EV    =  179756133000.0      # estimate:      192.976136 ± 1.1e-5 u            => σ = 11 keV
Pb194_MASS_EV    =  180685648000.0      # estimate:      193.974012 ± 1.9e-5 u            => σ = 18 keV
Pb195_MASS_EV    =  181617612000.0      # estimate:      194.9745162 ± 5.5e-6 u           => σ = 5.2 keV
Pb196_MASS_EV    =  182547495900.0      # estimate:      195.9727876 ± 8.3e-6 u           => σ = 7.8 keV
Pb197_MASS_EV    =  183479592800.0      # estimate:      196.9734347 ± 5.2e-6 u           => σ = 4.9 keV
Pb198_MASS_EV    =  184409764900.0      # estimate:      197.9720155 ± 9.4e-6 u           => σ = 8.8 keV
Pb199_MASS_EV    =  185342094600.0      # estimate:      198.9729126 ± 7.3e-6 u           => σ = 6.8 keV
Pb200_MASS_EV    =  186272570000.0      # estimate:      199.971819 ± 1.1e-5 u            => σ = 11 keV
Pb201_MASS_EV    =  187205043000.0      # estimate:      200.972870 ± 1.5e-5 u            => σ = 14 keV
Pb202_MASS_EV    =  188135868100.0      # estimate:      201.9721516 ± 4.1e-6 u           => σ = 3.9 keV
Pb203_MASS_EV    =  189068516300.0      # estimate:      202.9733906 ± 7.0e-6 u           => σ = 6.6 keV
Pb204_MASS_EV    =  189999687100.0      # estimate:      203.9730435 ± 1.2e-6 u           => σ = 1.2 keV
Pb205_MASS_EV    =  190932520900.0      # estimate:      204.9744817 ± 1.2e-6 u           => σ = 1.2 keV
Pb206_MASS_EV    =  191863999600.0      # estimate:      205.9744652 ± 1.2e-6 u           => σ = 1.2 keV
Pb207_MASS_EV    =  192796827200.0      # estimate:      206.9758968 ± 1.2e-6 u           => σ = 1.2 keV
Pb208_MASS_EV    =  193729024800.0      # estimate:      207.9766520 ± 1.2e-6 u           => σ = 1.2 keV
Pb209_MASS_EV    =  194664652900.0      # estimate:      208.9810900 ± 1.9e-6 u           => σ = 1.8 keV
Pb210_MASS_EV    =  195599033100.0      # estimate:      209.9841884 ± 1.6e-6 u           => σ = 1.5 keV
Pb211_MASS_EV    =  196534762600.0      # estimate:      210.9887353 ± 2.4e-6 u           => σ = 2.3 keV
Pb212_MASS_EV    =  197469200800.0      # estimate:      211.9918959 ± 2.0e-6 u           => σ = 1.9 keV
Pb213_MASS_EV    =  198405040200.0      # estimate:      212.9965608 ± 7.5e-6 u           => σ = 7.0 keV
Pb214_MASS_EV    =  199339554900.0      # estimate:      213.9998035 ± 2.1e-6 u           => σ = 2.0 keV
Pb215_MASS_EV    =  200275575000.0      # estimate:      215.004662 ± 5.7e-5 u            => σ = 53 keV
Pb216_MASS_EV    =  201210230000.0      # estimate:      216.00806 ± 2.2e-4 u             => σ = 210 keV
Pb217_MASS_EV    =  202146480000.0      # estimate:      217.01316 ± 3.2e-4 u             => σ = 300 keV
Pb218_MASS_EV    =  203081340000.0      # estimate:      218.01678 ± 3.2e-4 u             => σ = 300 keV
Pb219_MASS_EV    =  204017830000.0      # estimate:      219.02214 ± 4.3e-4 u             => σ = 400 keV
Pb220_MASS_EV    =  204952840000.0      # estimate:      220.02591 ± 4.3e-4 u             => σ = 400 keV


# Other particles in xpart.pdg database. Listed here for convenience (very incomplete list).
PHOTON_MASS_EV   =            0.0
PION0_MASS_EV    =    134976800.0      # best known value:    134976800 ± 500 eV         PDG (2024)
KAON0_MASS_EV    =    497611000.0      # best known value:    497611000 ± 13 keV         PDG (2024)
NEUTRON_MASS_EV  =    939565420.5      # best known value:    939565420.5 ± 0.5 eV       PDG  (2024)
