## TeleAds SDK

[![PyPi Package Version](https://img.shields.io/pypi/v/bapsdk.svg?style=flat-square)](https://pypi.python.org/pypi/bapsdk)
[![Supported python versions](https://img.shields.io/pypi/pyversions/bapsdk.svg?style=flat-square)](https://pypi.python.org/pypi/bapsdk)

This repository holds SDK related to
[TeleAds](https://teleads.pro/).

## Requirements

- Python >=3.7
- aiogram

## Installation

Install the latest version with

```bash
$ pip install teleads
```

The TeleAds SDK uses the UDP protocol for data transfer to ensure minimal SDK overhead for the user.

### Usage

See [examples](./examples)

- [Basic usage](examples/basic.py)
- [Usage with aiogram 2](examples/aiogram_bot.py)
- [Usage with aiogram 3](examples/aiogram3)

#### Interrupting control flow

At times, TeleAds may introduce telegram updates within its advertisement flow. To maintain the logical consistency of your bot, it is necessary to ignore such updates.

The `BAP.handle_update` method returns a boolean value indicating whether you should proceed with handling the request or skip it as an internal SDK request.

When the method returns `false`, it signifies that the current request should not be processed by your bot.

For manual advertisement mode (Should be turned on in settings) call following in the desired ad placements.

```python
bap.send_advertisement(update)
```

### SDK Key

The SDK Key is generated immediately after connecting your Telegram Bot in TeleAds.

You can find more information on the platform configuration [here](https://help.teleads.pro/en/articles/10493633-configure-a-platform).

## About

### Submitting bugs and feature requests

Bugs and feature request are tracked on [GitLab](https://git.teleads.pro/sdk/bots/python)

### License

Bot Advertising Platform SDK is licensed under the MIT License - see the [LICENSE](LICENSE) file for details
