# License

GPUX is open source software licensed under the MIT License.

---

## MIT License

```
MIT License

Copyright (c) 2024 GPUX Contributors

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
```

---

## What This Means

### ✅ You Can

- **Use** GPUX commercially
- **Modify** the source code
- **Distribute** the software
- **Sublicense** under compatible terms
- **Use** for private purposes

### ❌ You Cannot

- Hold the authors liable for damages
- Use contributor names for endorsement without permission

### 📋 You Must

- Include the license and copyright notice
- State changes made to the code

---

## Third-Party Licenses

GPUX depends on the following open source projects:

### Core Dependencies

- **ONNX Runtime** - MIT License
- **Typer** - MIT License
- **Pydantic** - MIT License
- **PyYAML** - MIT License
- **NumPy** - BSD License
- **Rich** - MIT License

### Optional Dependencies

- **FastAPI** - MIT License
- **Uvicorn** - BSD License
- **PyTorch** - BSD License (for model conversion)

See [pyproject.toml](https://github.com/gpux/gpux-runtime/blob/main/pyproject.toml) for complete dependency list.

---

## Questions?

For licensing questions, please:

1. Review the [MIT License FAQ](https://opensource.org/licenses/MIT)
2. Check [GitHub Issues](https://github.com/gpux/gpux-runtime/issues)
3. Contact: legal@gpux.io

---

## Contributing

By contributing to GPUX, you agree that your contributions will be licensed under the MIT License. See [Contributing Guide](contributing.md) for details.
