RFC5280 = {'PKIX1Explicit88': {'extensibility-implied': False,
                     'imports': {},
                     'tags': 'EXPLICIT',
                     'object-classes': {},
                     'object-sets': {},
                     'types': {'AdministrationDomainName': {'members': [{'name': 'numeric',
                                                                         'optional': False,
                                                                         'type': 'NumericString'},
                                                                        {'name': 'printable',
                                                                         'optional': False,
                                                                         'type': 'PrintableString'}],
                                                            'tag': {'class': 'APPLICATION',
                                                                    'number': 2},
                                                            'type': 'CHOICE'},
                               'AlgorithmIdentifier': {'members': [{'name': 'algorithm',
                                                                    'optional': False,
                                                                    'type': 'OBJECT '
                                                                            'IDENTIFIER'},
                                                                   {'choices': {},
                                                                    'name': 'parameters',
                                                                    'optional': True,
                                                                    'type': 'ANY '
                                                                            'DEFINED '
                                                                            'BY',
                                                                    'value': 'algorithm'}],
                                                       'type': 'SEQUENCE'},
                               'Attribute': {'members': [{'name': 'type',
                                                          'optional': False,
                                                          'type': 'AttributeType'},
                                                         {'element': {'type': 'AttributeValue'},
                                                          'name': 'values',
                                                          'optional': False,
                                                          'size': None,
                                                          'type': 'SET OF'}],
                                             'type': 'SEQUENCE'},
                               'AttributeType': {'type': 'OBJECT IDENTIFIER'},
                               'AttributeTypeAndValue': {'members': [{'name': 'type',
                                                                      'optional': False,
                                                                      'type': 'AttributeType'},
                                                                     {'name': 'value',
                                                                      'optional': False,
                                                                      'type': 'AttributeValue'}],
                                                         'type': 'SEQUENCE'},
                               'AttributeValue': {'type': 'ANY'},
                               'BuiltInDomainDefinedAttribute': {'members': [{'name': 'type',
                                                                              'optional': False,
                                                                              'type': 'PrintableString'},
                                                                             {'name': 'value',
                                                                              'optional': False,
                                                                              'type': 'PrintableString'}],
                                                                 'type': 'SEQUENCE'},
                               'BuiltInDomainDefinedAttributes': {'element': {'type': 'BuiltInDomainDefinedAttribute'},
                                                                  'size': [(1,
                                                                            'ub-domain-defined-attributes')],
                                                                  'type': 'SEQUENCE '
                                                                          'OF'},
                               'BuiltInStandardAttributes': {'members': [{'name': 'country-name',
                                                                          'optional': True,
                                                                          'type': 'CountryName'},
                                                                         {'name': 'administration-domain-name',
                                                                          'optional': True,
                                                                          'type': 'AdministrationDomainName'},
                                                                         {'name': 'network-address',
                                                                          'optional': True,
                                                                          'tag': {'kind': 'IMPLICIT',
                                                                                  'number': 0},
                                                                          'type': 'NetworkAddress'},
                                                                         {'name': 'terminal-identifier',
                                                                          'optional': True,
                                                                          'tag': {'kind': 'IMPLICIT',
                                                                                  'number': 1},
                                                                          'type': 'TerminalIdentifier'},
                                                                         {'name': 'private-domain-name',
                                                                          'optional': True,
                                                                          'tag': {'number': 2},
                                                                          'type': 'PrivateDomainName'},
                                                                         {'name': 'organization-name',
                                                                          'optional': True,
                                                                          'tag': {'kind': 'IMPLICIT',
                                                                                  'number': 3},
                                                                          'type': 'OrganizationName'},
                                                                         {'name': 'numeric-user-identifier',
                                                                          'optional': True,
                                                                          'tag': {'kind': 'IMPLICIT',
                                                                                  'number': 4},
                                                                          'type': 'NumericUserIdentifier'},
                                                                         {'name': 'personal-name',
                                                                          'optional': True,
                                                                          'tag': {'kind': 'IMPLICIT',
                                                                                  'number': 5},
                                                                          'type': 'PersonalName'},
                                                                         {'name': 'organizational-unit-names',
                                                                          'optional': True,
                                                                          'tag': {'kind': 'IMPLICIT',
                                                                                  'number': 6},
                                                                          'type': 'OrganizationalUnitNames'}],
                                                             'type': 'SEQUENCE'},
                               'Certificate': {'members': [{'name': 'tbsCertificate',
                                                            'optional': False,
                                                            'type': 'TBSCertificate'},
                                                           {'name': 'signatureAlgorithm',
                                                            'optional': False,
                                                            'type': 'AlgorithmIdentifier'},
                                                           {'name': 'signature',
                                                            'optional': False,
                                                            'size': None,
                                                            'type': 'BIT '
                                                                    'STRING'}],
                                               'type': 'SEQUENCE'},
                               'CertificateList': {'members': [{'name': 'tbsCertList',
                                                                'optional': False,
                                                                'type': 'TBSCertList'},
                                                               {'name': 'signatureAlgorithm',
                                                                'optional': False,
                                                                'type': 'AlgorithmIdentifier'},
                                                               {'name': 'signature',
                                                                'optional': False,
                                                                'size': None,
                                                                'type': 'BIT '
                                                                        'STRING'}],
                                                   'type': 'SEQUENCE'},
                               'CertificateSerialNumber': {'type': 'INTEGER'},
                               'CommonName': {'type': 'PrintableString'},
                               'CountryName': {'members': [{'name': 'x121-dcc-code',
                                                            'optional': False,
                                                            'type': 'NumericString'},
                                                           {'name': 'iso-3166-alpha2-code',
                                                            'optional': False,
                                                            'type': 'PrintableString'}],
                                               'tag': {'class': 'APPLICATION',
                                                       'number': 1},
                                               'type': 'CHOICE'},
                               'DirectoryString': {'members': [{'name': 'teletexString',
                                                                'optional': False,
                                                                'type': 'TeletexString'},
                                                               {'name': 'printableString',
                                                                'optional': False,
                                                                'type': 'PrintableString'},
                                                               {'name': 'universalString',
                                                                'optional': False,
                                                                'type': 'UniversalString'},
                                                               {'name': 'utf8String',
                                                                'optional': False,
                                                                'type': 'UTF8String'},
                                                               {'name': 'bmpString',
                                                                'optional': False,
                                                                'type': 'BMPString'}],
                                                   'type': 'CHOICE'},
                               'DistinguishedName': {'type': 'RDNSequence'},
                               'DomainComponent': {'type': 'IA5String'},
                               'EmailAddress': {'type': 'IA5String'},
                               'ExtendedNetworkAddress': {'members': [{'members': [{'name': 'number',
                                                                                    'optional': False,
                                                                                    'tag': {'kind': 'IMPLICIT',
                                                                                            'number': 0},
                                                                                    'type': 'NumericString'},
                                                                                   {'name': 'sub-address',
                                                                                    'optional': True,
                                                                                    'tag': {'kind': 'IMPLICIT',
                                                                                            'number': 1},
                                                                                    'type': 'NumericString'}],
                                                                       'name': 'e163-4-address',
                                                                       'optional': False,
                                                                       'type': 'SEQUENCE'},
                                                                      {'name': 'psap-address',
                                                                       'optional': False,
                                                                       'tag': {'kind': 'IMPLICIT',
                                                                               'number': 0},
                                                                       'type': 'PresentationAddress'}],
                                                          'type': 'CHOICE'},
                               'Extension': {'members': [{'name': 'extnID',
                                                          'optional': False,
                                                          'type': 'OBJECT '
                                                                  'IDENTIFIER'},
                                                         {'default': 'FALSE',
                                                          'name': 'critical',
                                                          'optional': False,
                                                          'type': 'BOOLEAN'},
                                                         {'name': 'extnValue',
                                                          'optional': False,
                                                          'size': None,
                                                          'type': 'OCTET '
                                                                  'STRING'}],
                                             'type': 'SEQUENCE'},
                               'ExtensionAttribute': {'members': [{'name': 'extension-attribute-type',
                                                                   'optional': False,
                                                                   'restricted-to': [(0,
                                                                                      'ub-extension-attributes')],
                                                                   'tag': {'kind': 'IMPLICIT',
                                                                           'number': 0},
                                                                   'type': 'INTEGER'},
                                                                  {'choices': {},
                                                                   'name': 'extension-attribute-value',
                                                                   'optional': False,
                                                                   'tag': {'number': 1},
                                                                   'type': 'ANY '
                                                                           'DEFINED '
                                                                           'BY',
                                                                   'value': 'extension-attribute-type'}],
                                                      'type': 'SEQUENCE'},
                               'ExtensionAttributes': {'element': {'type': 'ExtensionAttribute'},
                                                       'size': [(1,
                                                                 'ub-extension-attributes')],
                                                       'type': 'SET OF'},
                               'ExtensionORAddressComponents': {'type': 'PDSParameter'},
                               'ExtensionPhysicalDeliveryAddressComponents': {'type': 'PDSParameter'},
                               'Extensions': {'element': {'type': 'Extension'},
                                              'size': [(1, 'MAX')],
                                              'type': 'SEQUENCE OF'},
                               'LocalPostalAttributes': {'type': 'PDSParameter'},
                               'Name': {'members': [{'name': 'rdnSequence',
                                                     'optional': False,
                                                     'type': 'RDNSequence'}],
                                        'type': 'CHOICE'},
                               'NetworkAddress': {'type': 'X121Address'},
                               'NumericUserIdentifier': {'type': 'NumericString'},
                               'ORAddress': {'members': [{'name': 'built-in-standard-attributes',
                                                          'optional': False,
                                                          'type': 'BuiltInStandardAttributes'},
                                                         {'name': 'built-in-domain-defined-attributes',
                                                          'optional': True,
                                                          'type': 'BuiltInDomainDefinedAttributes'},
                                                         {'name': 'extension-attributes',
                                                          'optional': True,
                                                          'type': 'ExtensionAttributes'}],
                                             'type': 'SEQUENCE'},
                               'OrganizationName': {'type': 'PrintableString'},
                               'OrganizationalUnitName': {'type': 'PrintableString'},
                               'OrganizationalUnitNames': {'element': {'type': 'OrganizationalUnitName'},
                                                           'size': [(1,
                                                                     'ub-organizational-units')],
                                                           'type': 'SEQUENCE '
                                                                   'OF'},
                               'PDSName': {'type': 'PrintableString'},
                               'PDSParameter': {'members': [{'name': 'printable-string',
                                                             'optional': True,
                                                             'type': 'PrintableString'},
                                                            {'name': 'teletex-string',
                                                             'optional': True,
                                                             'type': 'TeletexString'}],
                                                'type': 'SET'},
                               'PersonalName': {'members': [{'name': 'surname',
                                                             'optional': False,
                                                             'tag': {'kind': 'IMPLICIT',
                                                                     'number': 0},
                                                             'type': 'PrintableString'},
                                                            {'name': 'given-name',
                                                             'optional': True,
                                                             'tag': {'kind': 'IMPLICIT',
                                                                     'number': 1},
                                                             'type': 'PrintableString'},
                                                            {'name': 'initials',
                                                             'optional': True,
                                                             'tag': {'kind': 'IMPLICIT',
                                                                     'number': 2},
                                                             'type': 'PrintableString'},
                                                            {'name': 'generation-qualifier',
                                                             'optional': True,
                                                             'tag': {'kind': 'IMPLICIT',
                                                                     'number': 3},
                                                             'type': 'PrintableString'}],
                                                'type': 'SET'},
                               'PhysicalDeliveryCountryName': {'members': [{'name': 'x121-dcc-code',
                                                                            'optional': False,
                                                                            'type': 'NumericString'},
                                                                           {'name': 'iso-3166-alpha2-code',
                                                                            'optional': False,
                                                                            'type': 'PrintableString'}],
                                                               'type': 'CHOICE'},
                               'PhysicalDeliveryOfficeName': {'type': 'PDSParameter'},
                               'PhysicalDeliveryOfficeNumber': {'type': 'PDSParameter'},
                               'PhysicalDeliveryOrganizationName': {'type': 'PDSParameter'},
                               'PhysicalDeliveryPersonalName': {'type': 'PDSParameter'},
                               'PostOfficeBoxAddress': {'type': 'PDSParameter'},
                               'PostalCode': {'members': [{'name': 'numeric-code',
                                                           'optional': False,
                                                           'type': 'NumericString'},
                                                          {'name': 'printable-code',
                                                           'optional': False,
                                                           'type': 'PrintableString'}],
                                              'type': 'CHOICE'},
                               'PosteRestanteAddress': {'type': 'PDSParameter'},
                               'PresentationAddress': {'members': [{'name': 'pSelector',
                                                                    'optional': True,
                                                                    'size': None,
                                                                    'tag': {'kind': 'EXPLICIT',
                                                                            'number': 0},
                                                                    'type': 'OCTET '
                                                                            'STRING'},
                                                                   {'name': 'sSelector',
                                                                    'optional': True,
                                                                    'size': None,
                                                                    'tag': {'kind': 'EXPLICIT',
                                                                            'number': 1},
                                                                    'type': 'OCTET '
                                                                            'STRING'},
                                                                   {'name': 'tSelector',
                                                                    'optional': True,
                                                                    'size': None,
                                                                    'tag': {'kind': 'EXPLICIT',
                                                                            'number': 2},
                                                                    'type': 'OCTET '
                                                                            'STRING'},
                                                                   {'element': {'size': None,
                                                                                'type': 'OCTET '
                                                                                        'STRING'},
                                                                    'name': 'nAddresses',
                                                                    'optional': False,
                                                                    'size': [(1,
                                                                              'MAX')],
                                                                    'tag': {'kind': 'EXPLICIT',
                                                                            'number': 3},
                                                                    'type': 'SET '
                                                                            'OF'}],
                                                       'type': 'SEQUENCE'},
                               'PrivateDomainName': {'members': [{'name': 'numeric',
                                                                  'optional': False,
                                                                  'type': 'NumericString'},
                                                                 {'name': 'printable',
                                                                  'optional': False,
                                                                  'type': 'PrintableString'}],
                                                     'type': 'CHOICE'},
                               'RDNSequence': {'element': {'type': 'RelativeDistinguishedName'},
                                               'size': None,
                                               'type': 'SEQUENCE OF'},
                               'RelativeDistinguishedName': {'element': {'type': 'AttributeTypeAndValue'},
                                                             'size': [(1,
                                                                       'MAX')],
                                                             'type': 'SET OF'},
                               'StreetAddress': {'type': 'PDSParameter'},
                               'SubjectPublicKeyInfo': {'members': [{'name': 'algorithm',
                                                                     'optional': False,
                                                                     'type': 'AlgorithmIdentifier'},
                                                                    {'name': 'subjectPublicKey',
                                                                     'optional': False,
                                                                     'size': None,
                                                                     'type': 'BIT '
                                                                             'STRING'}],
                                                        'type': 'SEQUENCE'},
                               'TBSCertList': {'members': [{'name': 'version',
                                                            'optional': True,
                                                            'type': 'Version'},
                                                           {'name': 'signature',
                                                            'optional': False,
                                                            'type': 'AlgorithmIdentifier'},
                                                           {'name': 'issuer',
                                                            'optional': False,
                                                            'type': 'Name'},
                                                           {'name': 'thisUpdate',
                                                            'optional': False,
                                                            'type': 'Time'},
                                                           {'name': 'nextUpdate',
                                                            'optional': True,
                                                            'type': 'Time'},
                                                           {'element': {'members': [{'name': 'userCertificate',
                                                                                     'optional': False,
                                                                                     'type': 'CertificateSerialNumber'},
                                                                                    {'name': 'revocationDate',
                                                                                     'optional': False,
                                                                                     'type': 'Time'},
                                                                                    {'name': 'crlEntryExtensions',
                                                                                     'optional': True,
                                                                                     'type': 'Extensions'}],
                                                                        'type': 'SEQUENCE'},
                                                            'name': 'revokedCertificates',
                                                            'optional': True,
                                                            'size': None,
                                                            'type': 'SEQUENCE '
                                                                    'OF'},
                                                           {'name': 'crlExtensions',
                                                            'optional': True,
                                                            'tag': {'number': 0},
                                                            'type': 'Extensions'}],
                                               'type': 'SEQUENCE'},
                               'TBSCertificate': {'members': [{'default': 'v1',
                                                               'name': 'version',
                                                               'optional': False,
                                                               'tag': {'number': 0},
                                                               'type': 'Version'},
                                                              {'name': 'serialNumber',
                                                               'optional': False,
                                                               'type': 'CertificateSerialNumber'},
                                                              {'name': 'signature',
                                                               'optional': False,
                                                               'type': 'AlgorithmIdentifier'},
                                                              {'name': 'issuer',
                                                               'optional': False,
                                                               'type': 'Name'},
                                                              {'name': 'validity',
                                                               'optional': False,
                                                               'type': 'Validity'},
                                                              {'name': 'subject',
                                                               'optional': False,
                                                               'type': 'Name'},
                                                              {'name': 'subjectPublicKeyInfo',
                                                               'optional': False,
                                                               'type': 'SubjectPublicKeyInfo'},
                                                              {'name': 'issuerUniqueID',
                                                               'optional': True,
                                                               'tag': {'kind': 'IMPLICIT',
                                                                       'number': 1},
                                                               'type': 'UniqueIdentifier'},
                                                              {'name': 'subjectUniqueID',
                                                               'optional': True,
                                                               'tag': {'kind': 'IMPLICIT',
                                                                       'number': 2},
                                                               'type': 'UniqueIdentifier'},
                                                              {'name': 'extensions',
                                                               'optional': True,
                                                               'tag': {'number': 3},
                                                               'type': 'Extensions'}],
                                                  'type': 'SEQUENCE'},
                               'TeletexCommonName': {'type': 'TeletexString'},
                               'TeletexDomainDefinedAttribute': {'members': [{'name': 'type',
                                                                              'optional': False,
                                                                              'type': 'TeletexString'},
                                                                             {'name': 'value',
                                                                              'optional': False,
                                                                              'type': 'TeletexString'}],
                                                                 'type': 'SEQUENCE'},
                               'TeletexDomainDefinedAttributes': {'element': {'type': 'TeletexDomainDefinedAttribute'},
                                                                  'size': [(1,
                                                                            'ub-domain-defined-attributes')],
                                                                  'type': 'SEQUENCE '
                                                                          'OF'},
                               'TeletexOrganizationName': {'type': 'TeletexString'},
                               'TeletexOrganizationalUnitName': {'type': 'TeletexString'},
                               'TeletexOrganizationalUnitNames': {'element': {'type': 'TeletexOrganizationalUnitName'},
                                                                  'size': [(1,
                                                                            'ub-organizational-units')],
                                                                  'type': 'SEQUENCE '
                                                                          'OF'},
                               'TeletexPersonalName': {'members': [{'name': 'surname',
                                                                    'optional': False,
                                                                    'tag': {'kind': 'IMPLICIT',
                                                                            'number': 0},
                                                                    'type': 'TeletexString'},
                                                                   {'name': 'given-name',
                                                                    'optional': True,
                                                                    'tag': {'kind': 'IMPLICIT',
                                                                            'number': 1},
                                                                    'type': 'TeletexString'},
                                                                   {'name': 'initials',
                                                                    'optional': True,
                                                                    'tag': {'kind': 'IMPLICIT',
                                                                            'number': 2},
                                                                    'type': 'TeletexString'},
                                                                   {'name': 'generation-qualifier',
                                                                    'optional': True,
                                                                    'tag': {'kind': 'IMPLICIT',
                                                                            'number': 3},
                                                                    'type': 'TeletexString'}],
                                                       'type': 'SET'},
                               'TerminalIdentifier': {'type': 'PrintableString'},
                               'TerminalType': {'type': 'INTEGER'},
                               'Time': {'members': [{'name': 'utcTime',
                                                     'optional': False,
                                                     'type': 'UTCTime'},
                                                    {'name': 'generalTime',
                                                     'optional': False,
                                                     'type': 'GeneralizedTime'}],
                                        'type': 'CHOICE'},
                               'UnformattedPostalAddress': {'members': [{'element': {'type': 'PrintableString'},
                                                                         'name': 'printable-address',
                                                                         'optional': True,
                                                                         'size': [(1,
                                                                                   'ub-pds-physical-address-lines')],
                                                                         'type': 'SEQUENCE '
                                                                                 'OF'},
                                                                        {'name': 'teletex-string',
                                                                         'optional': True,
                                                                         'type': 'TeletexString'}],
                                                            'type': 'SET'},
                               'UniqueIdentifier': {'size': None,
                                                    'type': 'BIT STRING'},
                               'UniquePostalName': {'type': 'PDSParameter'},
                               'Validity': {'members': [{'name': 'notBefore',
                                                         'optional': False,
                                                         'type': 'Time'},
                                                        {'name': 'notAfter',
                                                         'optional': False,
                                                         'type': 'Time'}],
                                            'type': 'SEQUENCE'},
                               'Version': {'type': 'INTEGER'},
                               'X121Address': {'type': 'NumericString'},
                               'X520CommonName': {'members': [{'name': 'teletexString',
                                                               'optional': False,
                                                               'type': 'TeletexString'},
                                                              {'name': 'printableString',
                                                               'optional': False,
                                                               'type': 'PrintableString'},
                                                              {'name': 'universalString',
                                                               'optional': False,
                                                               'type': 'UniversalString'},
                                                              {'name': 'utf8String',
                                                               'optional': False,
                                                               'type': 'UTF8String'},
                                                              {'name': 'bmpString',
                                                               'optional': False,
                                                               'type': 'BMPString'}],
                                                  'type': 'CHOICE'},
                               'X520LocalityName': {'members': [{'name': 'teletexString',
                                                                 'optional': False,
                                                                 'type': 'TeletexString'},
                                                                {'name': 'printableString',
                                                                 'optional': False,
                                                                 'type': 'PrintableString'},
                                                                {'name': 'universalString',
                                                                 'optional': False,
                                                                 'type': 'UniversalString'},
                                                                {'name': 'utf8String',
                                                                 'optional': False,
                                                                 'type': 'UTF8String'},
                                                                {'name': 'bmpString',
                                                                 'optional': False,
                                                                 'type': 'BMPString'}],
                                                    'type': 'CHOICE'},
                               'X520OrganizationName': {'members': [{'name': 'teletexString',
                                                                     'optional': False,
                                                                     'type': 'TeletexString'},
                                                                    {'name': 'printableString',
                                                                     'optional': False,
                                                                     'type': 'PrintableString'},
                                                                    {'name': 'universalString',
                                                                     'optional': False,
                                                                     'type': 'UniversalString'},
                                                                    {'name': 'utf8String',
                                                                     'optional': False,
                                                                     'type': 'UTF8String'},
                                                                    {'name': 'bmpString',
                                                                     'optional': False,
                                                                     'type': 'BMPString'}],
                                                        'type': 'CHOICE'},
                               'X520OrganizationalUnitName': {'members': [{'name': 'teletexString',
                                                                           'optional': False,
                                                                           'type': 'TeletexString'},
                                                                          {'name': 'printableString',
                                                                           'optional': False,
                                                                           'type': 'PrintableString'},
                                                                          {'name': 'universalString',
                                                                           'optional': False,
                                                                           'type': 'UniversalString'},
                                                                          {'name': 'utf8String',
                                                                           'optional': False,
                                                                           'type': 'UTF8String'},
                                                                          {'name': 'bmpString',
                                                                           'optional': False,
                                                                           'type': 'BMPString'}],
                                                              'type': 'CHOICE'},
                               'X520Pseudonym': {'members': [{'name': 'teletexString',
                                                              'optional': False,
                                                              'type': 'TeletexString'},
                                                             {'name': 'printableString',
                                                              'optional': False,
                                                              'type': 'PrintableString'},
                                                             {'name': 'universalString',
                                                              'optional': False,
                                                              'type': 'UniversalString'},
                                                             {'name': 'utf8String',
                                                              'optional': False,
                                                              'type': 'UTF8String'},
                                                             {'name': 'bmpString',
                                                              'optional': False,
                                                              'type': 'BMPString'}],
                                                 'type': 'CHOICE'},
                               'X520SerialNumber': {'type': 'PrintableString'},
                               'X520StateOrProvinceName': {'members': [{'name': 'teletexString',
                                                                        'optional': False,
                                                                        'type': 'TeletexString'},
                                                                       {'name': 'printableString',
                                                                        'optional': False,
                                                                        'type': 'PrintableString'},
                                                                       {'name': 'universalString',
                                                                        'optional': False,
                                                                        'type': 'UniversalString'},
                                                                       {'name': 'utf8String',
                                                                        'optional': False,
                                                                        'type': 'UTF8String'},
                                                                       {'name': 'bmpString',
                                                                        'optional': False,
                                                                        'type': 'BMPString'}],
                                                           'type': 'CHOICE'},
                               'X520Title': {'members': [{'name': 'teletexString',
                                                          'optional': False,
                                                          'type': 'TeletexString'},
                                                         {'name': 'printableString',
                                                          'optional': False,
                                                          'type': 'PrintableString'},
                                                         {'name': 'universalString',
                                                          'optional': False,
                                                          'type': 'UniversalString'},
                                                         {'name': 'utf8String',
                                                          'optional': False,
                                                          'type': 'UTF8String'},
                                                         {'name': 'bmpString',
                                                          'optional': False,
                                                          'type': 'BMPString'}],
                                             'type': 'CHOICE'},
                               'X520countryName': {'type': 'PrintableString'},
                               'X520dnQualifier': {'type': 'PrintableString'},
                               'X520name': {'members': [{'name': 'teletexString',
                                                         'optional': False,
                                                         'type': 'TeletexString'},
                                                        {'name': 'printableString',
                                                         'optional': False,
                                                         'type': 'PrintableString'},
                                                        {'name': 'universalString',
                                                         'optional': False,
                                                         'type': 'UniversalString'},
                                                        {'name': 'utf8String',
                                                         'optional': False,
                                                         'type': 'UTF8String'},
                                                        {'name': 'bmpString',
                                                         'optional': False,
                                                         'type': 'BMPString'}],
                                            'type': 'CHOICE'}},
                     'values': {'common-name': {'type': 'INTEGER', 'value': 1},
                                'extended-network-address': {'type': 'INTEGER',
                                                             'value': 22},
                                'extension-OR-address-components': {'type': 'INTEGER',
                                                                    'value': 12},
                                'extension-physical-delivery-address-components': {'type': 'INTEGER',
                                                                                   'value': 15},
                                'id-ad': {'type': 'OBJECT IDENTIFIER',
                                          'value': ['id-pkix', 48]},
                                'id-ad-caIssuers': {'type': 'OBJECT IDENTIFIER',
                                                    'value': ['id-ad', 2]},
                                'id-ad-caRepository': {'type': 'OBJECT '
                                                               'IDENTIFIER',
                                                       'value': ['id-ad', 5]},
                                'id-ad-ocsp': {'type': 'OBJECT IDENTIFIER',
                                               'value': ['id-ad', 1]},
                                'id-ad-timeStamping': {'type': 'OBJECT '
                                                               'IDENTIFIER',
                                                       'value': ['id-ad', 3]},
                                'id-at': {'type': 'OBJECT IDENTIFIER',
                                          'value': [('joint-iso-ccitt', 2),
                                                    ('ds', 5),
                                                    4]},
                                'id-at-commonName': {'type': 'AttributeType',
                                                     'value': [['id-at'],
                                                               ['3']]},
                                'id-at-countryName': {'type': 'AttributeType',
                                                      'value': [['id-at'],
                                                                ['6']]},
                                'id-at-dnQualifier': {'type': 'AttributeType',
                                                      'value': [['id-at'],
                                                                ['46']]},
                                'id-at-generationQualifier': {'type': 'AttributeType',
                                                              'value': [['id-at'],
                                                                        ['44']]},
                                'id-at-givenName': {'type': 'AttributeType',
                                                    'value': [['id-at'],
                                                              ['42']]},
                                'id-at-initials': {'type': 'AttributeType',
                                                   'value': [['id-at'],
                                                             ['43']]},
                                'id-at-localityName': {'type': 'AttributeType',
                                                       'value': [['id-at'],
                                                                 ['7']]},
                                'id-at-name': {'type': 'AttributeType',
                                               'value': [['id-at'], ['41']]},
                                'id-at-organizationName': {'type': 'AttributeType',
                                                           'value': [['id-at'],
                                                                     ['10']]},
                                'id-at-organizationalUnitName': {'type': 'AttributeType',
                                                                 'value': [['id-at'],
                                                                           ['11']]},
                                'id-at-pseudonym': {'type': 'AttributeType',
                                                    'value': [['id-at'],
                                                              ['65']]},
                                'id-at-serialNumber': {'type': 'AttributeType',
                                                       'value': [['id-at'],
                                                                 ['5']]},
                                'id-at-stateOrProvinceName': {'type': 'AttributeType',
                                                              'value': [['id-at'],
                                                                        ['8']]},
                                'id-at-surname': {'type': 'AttributeType',
                                                  'value': [['id-at'], ['4']]},
                                'id-at-title': {'type': 'AttributeType',
                                                'value': [['id-at'], ['12']]},
                                'id-domainComponent': {'type': 'AttributeType',
                                                       'value': [['0'],
                                                                 ['9'],
                                                                 ['2342'],
                                                                 ['19200300'],
                                                                 ['100'],
                                                                 ['1'],
                                                                 ['25']]},
                                'id-emailAddress': {'type': 'AttributeType',
                                                    'value': [['pkcs-9'],
                                                              ['1']]},
                                'id-kp': {'type': 'OBJECT IDENTIFIER',
                                          'value': ['id-pkix', 3]},
                                'id-pe': {'type': 'OBJECT IDENTIFIER',
                                          'value': ['id-pkix', 1]},
                                'id-pkix': {'type': 'OBJECT IDENTIFIER',
                                            'value': [('iso', 1),
                                                      ('identified-organization',
                                                       3),
                                                      ('dod', 6),
                                                      ('internet', 1),
                                                      ('security', 5),
                                                      ('mechanisms', 5),
                                                      ('pkix', 7)]},
                                'id-qt': {'type': 'OBJECT IDENTIFIER',
                                          'value': ['id-pkix', 2]},
                                'id-qt-cps': {'type': 'OBJECT IDENTIFIER',
                                              'value': ['id-qt', 1]},
                                'id-qt-unotice': {'type': 'OBJECT IDENTIFIER',
                                                  'value': ['id-qt', 2]},
                                'local-postal-attributes': {'type': 'INTEGER',
                                                            'value': 21},
                                'pds-name': {'type': 'INTEGER', 'value': 7},
                                'physical-delivery-country-name': {'type': 'INTEGER',
                                                                   'value': 8},
                                'physical-delivery-office-name': {'type': 'INTEGER',
                                                                  'value': 10},
                                'physical-delivery-office-number': {'type': 'INTEGER',
                                                                    'value': 11},
                                'physical-delivery-organization-name': {'type': 'INTEGER',
                                                                        'value': 14},
                                'physical-delivery-personal-name': {'type': 'INTEGER',
                                                                    'value': 13},
                                'pkcs-9': {'type': 'OBJECT IDENTIFIER',
                                           'value': [('iso', 1),
                                                     ('member-body', 2),
                                                     ('us', 840),
                                                     ('rsadsi', 113549),
                                                     ('pkcs', 1),
                                                     9]},
                                'post-office-box-address': {'type': 'INTEGER',
                                                            'value': 18},
                                'postal-code': {'type': 'INTEGER', 'value': 9},
                                'poste-restante-address': {'type': 'INTEGER',
                                                           'value': 19},
                                'street-address': {'type': 'INTEGER',
                                                   'value': 17},
                                'teletex-common-name': {'type': 'INTEGER',
                                                        'value': 2},
                                'teletex-domain-defined-attributes': {'type': 'INTEGER',
                                                                      'value': 6},
                                'teletex-organization-name': {'type': 'INTEGER',
                                                              'value': 3},
                                'teletex-organizational-unit-names': {'type': 'INTEGER',
                                                                      'value': 5},
                                'teletex-personal-name': {'type': 'INTEGER',
                                                          'value': 4},
                                'terminal-type': {'type': 'INTEGER',
                                                  'value': 23},
                                'ub-common-name': {'type': 'INTEGER',
                                                   'value': 64},
                                'ub-common-name-length': {'type': 'INTEGER',
                                                          'value': 64},
                                'ub-country-name-alpha-length': {'type': 'INTEGER',
                                                                 'value': 2},
                                'ub-country-name-numeric-length': {'type': 'INTEGER',
                                                                   'value': 3},
                                'ub-domain-defined-attribute-type-length': {'type': 'INTEGER',
                                                                            'value': 8},
                                'ub-domain-defined-attribute-value-length': {'type': 'INTEGER',
                                                                             'value': 128},
                                'ub-domain-defined-attributes': {'type': 'INTEGER',
                                                                 'value': 4},
                                'ub-domain-name-length': {'type': 'INTEGER',
                                                          'value': 16},
                                'ub-e163-4-number-length': {'type': 'INTEGER',
                                                            'value': 15},
                                'ub-e163-4-sub-address-length': {'type': 'INTEGER',
                                                                 'value': 40},
                                'ub-emailaddress-length': {'type': 'INTEGER',
                                                           'value': 255},
                                'ub-extension-attributes': {'type': 'INTEGER',
                                                            'value': 256},
                                'ub-generation-qualifier-length': {'type': 'INTEGER',
                                                                   'value': 3},
                                'ub-given-name-length': {'type': 'INTEGER',
                                                         'value': 16},
                                'ub-initials-length': {'type': 'INTEGER',
                                                       'value': 5},
                                'ub-integer-options': {'type': 'INTEGER',
                                                       'value': 256},
                                'ub-locality-name': {'type': 'INTEGER',
                                                     'value': 128},
                                'ub-match': {'type': 'INTEGER', 'value': 128},
                                'ub-name': {'type': 'INTEGER', 'value': 32768},
                                'ub-numeric-user-id-length': {'type': 'INTEGER',
                                                              'value': 32},
                                'ub-organization-name': {'type': 'INTEGER',
                                                         'value': 64},
                                'ub-organization-name-length': {'type': 'INTEGER',
                                                                'value': 64},
                                'ub-organizational-unit-name': {'type': 'INTEGER',
                                                                'value': 64},
                                'ub-organizational-unit-name-length': {'type': 'INTEGER',
                                                                       'value': 32},
                                'ub-organizational-units': {'type': 'INTEGER',
                                                            'value': 4},
                                'ub-pds-name-length': {'type': 'INTEGER',
                                                       'value': 16},
                                'ub-pds-parameter-length': {'type': 'INTEGER',
                                                            'value': 30},
                                'ub-pds-physical-address-lines': {'type': 'INTEGER',
                                                                  'value': 6},
                                'ub-postal-code-length': {'type': 'INTEGER',
                                                          'value': 16},
                                'ub-pseudonym': {'type': 'INTEGER',
                                                 'value': 128},
                                'ub-serial-number': {'type': 'INTEGER',
                                                     'value': 64},
                                'ub-state-name': {'type': 'INTEGER',
                                                  'value': 128},
                                'ub-surname-length': {'type': 'INTEGER',
                                                      'value': 40},
                                'ub-terminal-id-length': {'type': 'INTEGER',
                                                          'value': 24},
                                'ub-title': {'type': 'INTEGER', 'value': 64},
                                'ub-unformatted-address-length': {'type': 'INTEGER',
                                                                  'value': 180},
                                'ub-x121-address-length': {'type': 'INTEGER',
                                                           'value': 16},
                                'unformatted-postal-address': {'type': 'INTEGER',
                                                               'value': 16},
                                'unique-postal-name': {'type': 'INTEGER',
                                                       'value': 20}}},
 'PKIX1Implicit88': {'extensibility-implied': False,
                     'imports': {'PKIX1Explicit88': ['id-pe',
                                                     'id-kp',
                                                     'id-qt-unotice',
                                                     'id-qt-cps',
                                                     'BMPString',
                                                     'UTF8String',
                                                     'ORAddress',
                                                     'Name',
                                                     'RelativeDistinguishedName',
                                                     'CertificateSerialNumber',
                                                     'Attribute',
                                                     'DirectoryString']},
                     'tags': 'IMPLICIT',
                     'object-classes': {},
                     'object-sets': {},
                     'types': {'AccessDescription': {'members': [{'name': 'accessMethod',
                                                                  'optional': False,
                                                                  'type': 'OBJECT '
                                                                          'IDENTIFIER'},
                                                                 {'name': 'accessLocation',
                                                                  'optional': False,
                                                                  'type': 'GeneralName'}],
                                                     'type': 'SEQUENCE'},
                               'AnotherName': {'members': [{'name': 'type-id',
                                                            'optional': False,
                                                            'type': 'OBJECT '
                                                                    'IDENTIFIER'},
                                                           {'choices': {},
                                                            'name': 'value',
                                                            'optional': False,
                                                            'tag': {'kind': 'EXPLICIT',
                                                                    'number': 0},
                                                            'type': 'ANY '
                                                                    'DEFINED '
                                                                    'BY',
                                                            'value': 'type-id'}],
                                               'type': 'SEQUENCE'},
                               'AuthorityInfoAccessSyntax': {'element': {'type': 'AccessDescription'},
                                                             'size': [(1,
                                                                       'MAX')],
                                                             'type': 'SEQUENCE '
                                                                     'OF'},
                               'AuthorityKeyIdentifier': {'members': [{'name': 'keyIdentifier',
                                                                       'optional': True,
                                                                       'tag': {'number': 0},
                                                                       'type': 'KeyIdentifier'},
                                                                      {'name': 'authorityCertIssuer',
                                                                       'optional': True,
                                                                       'tag': {'number': 1},
                                                                       'type': 'GeneralNames'},
                                                                      {'name': 'authorityCertSerialNumber',
                                                                       'optional': True,
                                                                       'tag': {'number': 2},
                                                                       'type': 'CertificateSerialNumber'}],
                                                          'type': 'SEQUENCE'},
                               'BaseCRLNumber': {'type': 'CRLNumber'},
                               'BaseDistance': {'restricted-to': [(0, 'MAX')],
                                                'type': 'INTEGER'},
                               'BasicConstraints': {'members': [{'default': 'FALSE',
                                                                 'name': 'cA',
                                                                 'optional': False,
                                                                 'type': 'BOOLEAN'},
                                                                {'name': 'pathLenConstraint',
                                                                 'optional': True,
                                                                 'restricted-to': [(0,
                                                                                    'MAX')],
                                                                 'type': 'INTEGER'}],
                                                    'type': 'SEQUENCE'},
                               'CPSuri': {'type': 'IA5String'},
                               'CRLDistributionPoints': {'element': {'type': 'DistributionPoint'},
                                                         'size': [(1, 'MAX')],
                                                         'type': 'SEQUENCE OF'},
                               'CRLNumber': {'restricted-to': [(0, 'MAX')],
                                             'type': 'INTEGER'},
                               'CRLReason': {'type': 'ENUMERATED',
                                             'values': {0: 'unspecified',
                                                        1: 'keyCompromise',
                                                        2: 'cACompromise',
                                                        3: 'affiliationChanged',
                                                        4: 'superseded',
                                                        5: 'cessationOfOperation',
                                                        6: 'certificateHold',
                                                        8: 'removeFromCRL',
                                                        9: 'privilegeWithdrawn',
                                                        10: 'aACompromise'}},
                               'CertPolicyId': {'type': 'OBJECT IDENTIFIER'},
                               'CertificateIssuer': {'type': 'GeneralNames'},
                               'CertificatePolicies': {'element': {'type': 'PolicyInformation'},
                                                       'size': [(1, 'MAX')],
                                                       'type': 'SEQUENCE OF'},
                               'DisplayText': {'members': [{'name': 'ia5String',
                                                            'optional': False,
                                                            'type': 'IA5String'},
                                                           {'name': 'visibleString',
                                                            'optional': False,
                                                            'type': 'VisibleString'},
                                                           {'name': 'bmpString',
                                                            'optional': False,
                                                            'type': 'BMPString'},
                                                           {'name': 'utf8String',
                                                            'optional': False,
                                                            'type': 'UTF8String'}],
                                               'type': 'CHOICE'},
                               'DistributionPoint': {'members': [{'name': 'distributionPoint',
                                                                  'optional': True,
                                                                  'tag': {'number': 0},
                                                                  'type': 'DistributionPointName'},
                                                                 {'name': 'reasons',
                                                                  'optional': True,
                                                                  'tag': {'number': 1},
                                                                  'type': 'ReasonFlags'},
                                                                 {'name': 'cRLIssuer',
                                                                  'optional': True,
                                                                  'tag': {'number': 2},
                                                                  'type': 'GeneralNames'}],
                                                     'type': 'SEQUENCE'},
                               'DistributionPointName': {'members': [{'name': 'fullName',
                                                                      'optional': False,
                                                                      'tag': {'number': 0},
                                                                      'type': 'GeneralNames'},
                                                                     {'name': 'nameRelativeToCRLIssuer',
                                                                      'optional': False,
                                                                      'tag': {'number': 1},
                                                                      'type': 'RelativeDistinguishedName'}],
                                                         'type': 'CHOICE'},
                               'EDIPartyName': {'members': [{'name': 'nameAssigner',
                                                             'optional': True,
                                                             'tag': {'number': 0},
                                                             'type': 'DirectoryString'},
                                                            {'name': 'partyName',
                                                             'optional': False,
                                                             'tag': {'number': 1},
                                                             'type': 'DirectoryString'}],
                                                'type': 'SEQUENCE'},
                               'ExtKeyUsageSyntax': {'element': {'type': 'KeyPurposeId'},
                                                     'size': [(1, 'MAX')],
                                                     'type': 'SEQUENCE OF'},
                               'FreshestCRL': {'type': 'CRLDistributionPoints'},
                               'GeneralName': {'members': [{'name': 'otherName',
                                                            'optional': False,
                                                            'tag': {'number': 0},
                                                            'type': 'AnotherName'},
                                                           {'name': 'rfc822Name',
                                                            'optional': False,
                                                            'tag': {'number': 1},
                                                            'type': 'IA5String'},
                                                           {'name': 'dNSName',
                                                            'optional': False,
                                                            'tag': {'number': 2},
                                                            'type': 'IA5String'},
                                                           {'name': 'x400Address',
                                                            'optional': False,
                                                            'tag': {'number': 3},
                                                            'type': 'ORAddress'},
                                                           {'name': 'directoryName',
                                                            'optional': False,
                                                            'tag': {'number': 4},
                                                            'type': 'Name'},
                                                           {'name': 'ediPartyName',
                                                            'optional': False,
                                                            'tag': {'number': 5},
                                                            'type': 'EDIPartyName'},
                                                           {'name': 'uniformResourceIdentifier',
                                                            'optional': False,
                                                            'tag': {'number': 6},
                                                            'type': 'IA5String'},
                                                           {'name': 'iPAddress',
                                                            'optional': False,
                                                            'size': None,
                                                            'tag': {'number': 7},
                                                            'type': 'OCTET '
                                                                    'STRING'},
                                                           {'name': 'registeredID',
                                                            'optional': False,
                                                            'tag': {'number': 8},
                                                            'type': 'OBJECT '
                                                                    'IDENTIFIER'}],
                                               'type': 'CHOICE'},
                               'GeneralNames': {'element': {'type': 'GeneralName'},
                                                'size': [(1, 'MAX')],
                                                'type': 'SEQUENCE OF'},
                               'GeneralSubtree': {'members': [{'name': 'base',
                                                               'optional': False,
                                                               'type': 'GeneralName'},
                                                              {'default': 0,
                                                               'name': 'minimum',
                                                               'optional': False,
                                                               'tag': {'number': 0},
                                                               'type': 'BaseDistance'},
                                                              {'name': 'maximum',
                                                               'optional': True,
                                                               'tag': {'number': 1},
                                                               'type': 'BaseDistance'}],
                                                  'type': 'SEQUENCE'},
                               'GeneralSubtrees': {'element': {'type': 'GeneralSubtree'},
                                                   'size': [(1, 'MAX')],
                                                   'type': 'SEQUENCE OF'},
                               'HoldInstructionCode': {'type': 'OBJECT '
                                                               'IDENTIFIER'},
                               'InhibitAnyPolicy': {'type': 'SkipCerts'},
                               'InvalidityDate': {'type': 'GeneralizedTime'},
                               'IssuerAltName': {'type': 'GeneralNames'},
                               'IssuingDistributionPoint': {'members': [{'name': 'distributionPoint',
                                                                         'optional': True,
                                                                         'tag': {'number': 0},
                                                                         'type': 'DistributionPointName'},
                                                                        {'default': 'FALSE',
                                                                         'name': 'onlyContainsUserCerts',
                                                                         'optional': False,
                                                                         'tag': {'number': 1},
                                                                         'type': 'BOOLEAN'},
                                                                        {'default': 'FALSE',
                                                                         'name': 'onlyContainsCACerts',
                                                                         'optional': False,
                                                                         'tag': {'number': 2},
                                                                         'type': 'BOOLEAN'},
                                                                        {'name': 'onlySomeReasons',
                                                                         'optional': True,
                                                                         'tag': {'number': 3},
                                                                         'type': 'ReasonFlags'},
                                                                        {'default': 'FALSE',
                                                                         'name': 'indirectCRL',
                                                                         'optional': False,
                                                                         'tag': {'number': 4},
                                                                         'type': 'BOOLEAN'},
                                                                        {'default': 'FALSE',
                                                                         'name': 'onlyContainsAttributeCerts',
                                                                         'optional': False,
                                                                         'tag': {'number': 5},
                                                                         'type': 'BOOLEAN'}],
                                                            'type': 'SEQUENCE'},
                               'KeyIdentifier': {'size': None,
                                                 'type': 'OCTET STRING'},
                               'KeyPurposeId': {'type': 'OBJECT IDENTIFIER'},
                               'KeyUsage': {'size': None, 'type': 'BIT STRING'},
                               'NameConstraints': {'members': [{'name': 'permittedSubtrees',
                                                                'optional': True,
                                                                'tag': {'number': 0},
                                                                'type': 'GeneralSubtrees'},
                                                               {'name': 'excludedSubtrees',
                                                                'optional': True,
                                                                'tag': {'number': 1},
                                                                'type': 'GeneralSubtrees'}],
                                                   'type': 'SEQUENCE'},
                               'NoticeReference': {'members': [{'name': 'organization',
                                                                'optional': False,
                                                                'type': 'DisplayText'},
                                                               {'element': {'type': 'INTEGER'},
                                                                'name': 'noticeNumbers',
                                                                'optional': False,
                                                                'size': None,
                                                                'type': 'SEQUENCE '
                                                                        'OF'}],
                                                   'type': 'SEQUENCE'},
                               'PolicyConstraints': {'members': [{'name': 'requireExplicitPolicy',
                                                                  'optional': True,
                                                                  'tag': {'number': 0},
                                                                  'type': 'SkipCerts'},
                                                                 {'name': 'inhibitPolicyMapping',
                                                                  'optional': True,
                                                                  'tag': {'number': 1},
                                                                  'type': 'SkipCerts'}],
                                                     'type': 'SEQUENCE'},
                               'PolicyInformation': {'members': [{'name': 'policyIdentifier',
                                                                  'optional': False,
                                                                  'type': 'CertPolicyId'},
                                                                 {'element': {'type': 'PolicyQualifierInfo'},
                                                                  'name': 'policyQualifiers',
                                                                  'optional': True,
                                                                  'size': [(1,
                                                                            'MAX')],
                                                                  'type': 'SEQUENCE '
                                                                          'OF'}],
                                                     'type': 'SEQUENCE'},
                               'PolicyMappings': {'element': {'members': [{'name': 'issuerDomainPolicy',
                                                                           'optional': False,
                                                                           'type': 'CertPolicyId'},
                                                                          {'name': 'subjectDomainPolicy',
                                                                           'optional': False,
                                                                           'type': 'CertPolicyId'}],
                                                              'type': 'SEQUENCE'},
                                                  'size': [(1, 'MAX')],
                                                  'type': 'SEQUENCE OF'},
                               'PolicyQualifierId': {'type': 'OBJECT '
                                                             'IDENTIFIER'},
                               'PolicyQualifierInfo': {'members': [{'name': 'policyQualifierId',
                                                                    'optional': False,
                                                                    'type': 'PolicyQualifierId'},
                                                                   {'choices': {},
                                                                    'name': 'qualifier',
                                                                    'optional': False,
                                                                    'type': 'ANY '
                                                                            'DEFINED '
                                                                            'BY',
                                                                    'value': 'policyQualifierId'}],
                                                       'type': 'SEQUENCE'},
                               'PrivateKeyUsagePeriod': {'members': [{'name': 'notBefore',
                                                                      'optional': True,
                                                                      'tag': {'number': 0},
                                                                      'type': 'GeneralizedTime'},
                                                                     {'name': 'notAfter',
                                                                      'optional': True,
                                                                      'tag': {'number': 1},
                                                                      'type': 'GeneralizedTime'}],
                                                         'type': 'SEQUENCE'},
                               'ReasonFlags': {'size': None,
                                               'type': 'BIT STRING'},
                               'SkipCerts': {'restricted-to': [(0, 'MAX')],
                                             'type': 'INTEGER'},
                               'SubjectAltName': {'type': 'GeneralNames'},
                               'SubjectDirectoryAttributes': {'element': {'type': 'Attribute'},
                                                              'size': [(1,
                                                                        'MAX')],
                                                              'type': 'SEQUENCE '
                                                                      'OF'},
                               'SubjectInfoAccessSyntax': {'element': {'type': 'AccessDescription'},
                                                           'size': [(1, 'MAX')],
                                                           'type': 'SEQUENCE '
                                                                   'OF'},
                               'SubjectKeyIdentifier': {'type': 'KeyIdentifier'},
                               'UserNotice': {'members': [{'name': 'noticeRef',
                                                           'optional': True,
                                                           'type': 'NoticeReference'},
                                                          {'name': 'explicitText',
                                                           'optional': True,
                                                           'type': 'DisplayText'}],
                                              'type': 'SEQUENCE'}},
                     'values': {'anyExtendedKeyUsage': {'type': 'OBJECT '
                                                                'IDENTIFIER',
                                                        'value': ['id-ce-extKeyUsage',
                                                                  0]},
                                'anyPolicy': {'type': 'OBJECT IDENTIFIER',
                                              'value': ['id-ce-certificatePolicies',
                                                        0]},
                                'holdInstruction': {'type': 'OBJECT IDENTIFIER',
                                                    'value': [('joint-iso-itu-t',
                                                               2),
                                                              ('member-body',
                                                               2),
                                                              ('us', 840),
                                                              ('x9cm', 10040),
                                                              2]},
                                'id-ce': {'type': 'OBJECT IDENTIFIER',
                                          'value': [('joint-iso-ccitt', 2),
                                                    ('ds', 5),
                                                    29]},
                                'id-ce-authorityKeyIdentifier': {'type': 'OBJECT '
                                                                         'IDENTIFIER',
                                                                 'value': ['id-ce',
                                                                           35]},
                                'id-ce-basicConstraints': {'type': 'OBJECT '
                                                                   'IDENTIFIER',
                                                           'value': ['id-ce',
                                                                     19]},
                                'id-ce-cRLDistributionPoints': {'type': 'OBJECT '
                                                                        'IDENTIFIER',
                                                                'value': ['id-ce',
                                                                          31]},
                                'id-ce-cRLNumber': {'type': 'OBJECT IDENTIFIER',
                                                    'value': ['id-ce', 20]},
                                'id-ce-cRLReasons': {'type': 'OBJECT '
                                                             'IDENTIFIER',
                                                     'value': ['id-ce', 21]},
                                'id-ce-certificateIssuer': {'type': 'OBJECT '
                                                                    'IDENTIFIER',
                                                            'value': ['id-ce',
                                                                      29]},
                                'id-ce-certificatePolicies': {'type': 'OBJECT '
                                                                      'IDENTIFIER',
                                                              'value': ['id-ce',
                                                                        32]},
                                'id-ce-deltaCRLIndicator': {'type': 'OBJECT '
                                                                    'IDENTIFIER',
                                                            'value': ['id-ce',
                                                                      27]},
                                'id-ce-extKeyUsage': {'type': 'OBJECT '
                                                              'IDENTIFIER',
                                                      'value': ['id-ce', 37]},
                                'id-ce-freshestCRL': {'type': 'OBJECT '
                                                              'IDENTIFIER',
                                                      'value': ['id-ce', 46]},
                                'id-ce-holdInstructionCode': {'type': 'OBJECT '
                                                                      'IDENTIFIER',
                                                              'value': ['id-ce',
                                                                        23]},
                                'id-ce-inhibitAnyPolicy': {'type': 'OBJECT '
                                                                   'IDENTIFIER',
                                                           'value': ['id-ce',
                                                                     54]},
                                'id-ce-invalidityDate': {'type': 'OBJECT '
                                                                 'IDENTIFIER',
                                                         'value': ['id-ce',
                                                                   24]},
                                'id-ce-issuerAltName': {'type': 'OBJECT '
                                                                'IDENTIFIER',
                                                        'value': ['id-ce', 18]},
                                'id-ce-issuingDistributionPoint': {'type': 'OBJECT '
                                                                           'IDENTIFIER',
                                                                   'value': ['id-ce',
                                                                             28]},
                                'id-ce-keyUsage': {'type': 'OBJECT IDENTIFIER',
                                                   'value': ['id-ce', 15]},
                                'id-ce-nameConstraints': {'type': 'OBJECT '
                                                                  'IDENTIFIER',
                                                          'value': ['id-ce',
                                                                    30]},
                                'id-ce-policyConstraints': {'type': 'OBJECT '
                                                                    'IDENTIFIER',
                                                            'value': ['id-ce',
                                                                      36]},
                                'id-ce-policyMappings': {'type': 'OBJECT '
                                                                 'IDENTIFIER',
                                                         'value': ['id-ce',
                                                                   33]},
                                'id-ce-privateKeyUsagePeriod': {'type': 'OBJECT '
                                                                        'IDENTIFIER',
                                                                'value': ['id-ce',
                                                                          16]},
                                'id-ce-subjectAltName': {'type': 'OBJECT '
                                                                 'IDENTIFIER',
                                                         'value': ['id-ce',
                                                                   17]},
                                'id-ce-subjectDirectoryAttributes': {'type': 'OBJECT '
                                                                             'IDENTIFIER',
                                                                     'value': ['id-ce',
                                                                               9]},
                                'id-ce-subjectKeyIdentifier': {'type': 'OBJECT '
                                                                       'IDENTIFIER',
                                                               'value': ['id-ce',
                                                                         14]},
                                'id-holdinstruction-callissuer': {'type': 'OBJECT '
                                                                          'IDENTIFIER',
                                                                  'value': ['holdInstruction',
                                                                            2]},
                                'id-holdinstruction-none': {'type': 'OBJECT '
                                                                    'IDENTIFIER',
                                                            'value': ['holdInstruction',
                                                                      1]},
                                'id-holdinstruction-reject': {'type': 'OBJECT '
                                                                      'IDENTIFIER',
                                                              'value': ['holdInstruction',
                                                                        3]},
                                'id-kp-OCSPSigning': {'type': 'OBJECT '
                                                              'IDENTIFIER',
                                                      'value': ['id-kp', 9]},
                                'id-kp-clientAuth': {'type': 'OBJECT '
                                                             'IDENTIFIER',
                                                     'value': ['id-kp', 2]},
                                'id-kp-codeSigning': {'type': 'OBJECT '
                                                              'IDENTIFIER',
                                                      'value': ['id-kp', 3]},
                                'id-kp-emailProtection': {'type': 'OBJECT '
                                                                  'IDENTIFIER',
                                                          'value': ['id-kp',
                                                                    4]},
                                'id-kp-serverAuth': {'type': 'OBJECT '
                                                             'IDENTIFIER',
                                                     'value': ['id-kp', 1]},
                                'id-kp-timeStamping': {'type': 'OBJECT '
                                                               'IDENTIFIER',
                                                       'value': ['id-kp', 8]},
                                'id-pe-authorityInfoAccess': {'type': 'OBJECT '
                                                                      'IDENTIFIER',
                                                              'value': ['id-pe',
                                                                        1]},
                                'id-pe-subjectInfoAccess': {'type': 'OBJECT '
                                                                    'IDENTIFIER',
                                                            'value': ['id-pe',
                                                                      11]}}}}
