import { CfnResource, IAspect } from 'aws-cdk-lib';
import { IConstruct } from 'constructs';
/**
 * Properties to pass to the AddPermissionBoundary
 *
 * @interface AddPermissionBoundaryProps
 *
 */
export interface AddPermissionBoundaryProps {
    /**
     * Name of Permissions Boundary Policy to add to all IAM roles
     */
    readonly permissionsBoundaryPolicyName: string;
    /**
     * A prefix to prepend to the name of IAM Roles (Default: '').
     */
    readonly rolePrefix?: string;
    /**
     * A prefix to prepend to the name of the IAM Policies and ManagedPolicies (Default: '').
     */
    readonly policyPrefix?: string;
    /**
     * A prefix to prepend to the name of the IAM InstanceProfiles (Default: '').
     */
    readonly instanceProfilePrefix?: string;
}
/**
 * A patch for Adding Permissions Boundaries to all IAM roles
 *
 * Additional options for adding prefixes to IAM role, policy and instance profile names
 *
 * Can account for non commercial partitions (e.g. aws-gov, aws-cn)
 */
export declare class AddPermissionBoundary implements IAspect {
    private _permissionsBoundaryPolicyName;
    private _rolePrefix;
    private _policyPrefix;
    private _instanceProfilePrefix;
    constructor(props: AddPermissionBoundaryProps);
    checkAndOverride(node: CfnResource, prefix: string, length: number, cfnProp: string, cdkProp?: string): void;
    visit(node: IConstruct): void;
}
