import { IAspect } from 'aws-cdk-lib';
import { EndpointType } from 'aws-cdk-lib/aws-apigateway';
import { IConstruct } from 'constructs';
export interface SetApiGatewayEndpointConfigurationProps {
    /**
     * API Gateway endpoint type to override to. Defaults to EndpointType.REGIONAL
     *
     * @default EndpointType.REGIONAL
     */
    readonly endpointType?: EndpointType;
}
/**
 * Override RestApis to use a set endpoint configuration.
 *
 * Some regions don't support EDGE endpoints, and some enterprises require
 * specific endpoint types for RestApis
 */
export declare class SetApiGatewayEndpointConfiguration implements IAspect {
    private _endpointType;
    constructor(props?: SetApiGatewayEndpointConfigurationProps);
    visit(node: IConstruct): void;
}
