import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
/**
 *
 */
export interface ContainerConfig extends TerraformMetaArguments {
    /**
     *
     */
    readonly attach?: boolean;
    /**
     *
     */
    readonly command?: string[];
    /**
     *
     */
    readonly cpuSet?: string;
    /**
     *
     */
    readonly cpuShares?: number;
    /**
     *
     */
    readonly destroyGraceSeconds?: number;
    /**
     *
     */
    readonly dns?: string[];
    /**
     *
     */
    readonly dnsOpts?: string[];
    /**
     *
     */
    readonly dnsSearch?: string[];
    /**
     *
     */
    readonly domainname?: string;
    /**
     *
     */
    readonly entrypoint?: string[];
    /**
     *
     */
    readonly env?: string[];
    /**
     * Additional groups for the container user.
     */
    readonly groupAdd?: string[];
    /**
     *
     */
    readonly hostname?: string;
    /**
     *
     */
    readonly image: string;
    /**
     * IPC sharing mode for the container.
     */
    readonly ipcMode?: string;
    /**
     *
     */
    readonly links?: string[];
    /**
     *
     */
    readonly logDriver?: string;
    /**
     *
     */
    readonly logOpts?: {
        [key: string]: string;
    };
    /**
     *
     */
    readonly logs?: boolean;
    /**
     *
     */
    readonly maxRetryCount?: number;
    /**
     *
     */
    readonly memory?: number;
    /**
     *
     */
    readonly memorySwap?: number;
    /**
     *
     */
    readonly mustRun?: boolean;
    /**
     *
     */
    readonly name: string;
    /**
     * Set an alias for the container in all specified networks.
     */
    readonly networkAlias?: string[];
    /**
     *
     */
    readonly networkMode?: string;
    /**
     *
     */
    readonly networks?: string[];
    /**
     *
     */
    readonly pidMode?: string;
    /**
     *
     */
    readonly privileged?: boolean;
    /**
     *
     */
    readonly publishAllPorts?: boolean;
    /**
     *
     */
    readonly readOnly?: boolean;
    /**
     *
     */
    readonly restart?: string;
    /**
     *
     */
    readonly rm?: boolean;
    /**
     *
     */
    readonly shmSize?: number;
    /**
     *
     */
    readonly start?: boolean;
    /**
     *
     */
    readonly sysctls?: {
        [key: string]: string;
    };
    /**
     *
     */
    readonly tmpfs?: {
        [key: string]: string;
    };
    /**
     *
     */
    readonly user?: string;
    /**
     *
     */
    readonly usernsMode?: string;
    /**
     *
     */
    readonly workingDir?: string;
    /**
     * capabilities block.
     */
    readonly capabilities?: ContainerCapabilities[];
    /**
     * devices block.
     */
    readonly devices?: ContainerDevices[];
    /**
     * healthcheck block.
     */
    readonly healthcheck?: ContainerHealthcheck[];
    /**
     * host block.
     */
    readonly host?: ContainerHost[];
    /**
     * labels block.
     */
    readonly labels?: ContainerLabels[];
    /**
     * mounts block.
     */
    readonly mounts?: ContainerMounts[];
    /**
     * networks_advanced block.
     */
    readonly networksAdvanced?: ContainerNetworksAdvanced[];
    /**
     * ports block.
     */
    readonly ports?: ContainerPorts[];
    /**
     * ulimit block.
     */
    readonly ulimit?: ContainerUlimit[];
    /**
     * upload block.
     */
    readonly upload?: ContainerUpload[];
    /**
     * volumes block.
     */
    readonly volumes?: ContainerVolumes[];
}
/**
 *
 */
export declare class ContainerNetworkData extends ComplexComputedList {
    /**
     *
     */
    get gateway(): string;
    /**
     *
     */
    get ipAddress(): string;
    /**
     *
     */
    get ipPrefixLength(): number;
    /**
     *
     */
    get networkName(): string;
}
/**
 *
 */
export interface ContainerCapabilities {
    /**
     *
     */
    readonly add?: string[];
    /**
     *
     */
    readonly drop?: string[];
}
/**
 *
 */
export interface ContainerDevices {
    /**
     *
     */
    readonly containerPath?: string;
    /**
     *
     */
    readonly hostPath: string;
    /**
     *
     */
    readonly permissions?: string;
}
/**
 *
 */
export interface ContainerHealthcheck {
    /**
     * Time between running the check (ms|s|m|h).
     */
    readonly interval?: string;
    /**
     * Consecutive failures needed to report unhealthy.
     */
    readonly retries?: number;
    /**
     * Start period for the container to initialize before counting retries towards unstable (ms|s|m|h).
     */
    readonly startPeriod?: string;
    /**
     * The test to perform as list.
     */
    readonly test: string[];
    /**
     * Maximum time to allow one check to run (ms|s|m|h).
     */
    readonly timeout?: string;
}
/**
 *
 */
export interface ContainerHost {
    /**
     *
     */
    readonly host: string;
    /**
     *
     */
    readonly ip: string;
}
/**
 *
 */
export interface ContainerLabels {
    /**
     * Name of the label.
     */
    readonly label: string;
    /**
     * Value of the label.
     */
    readonly value: string;
}
/**
 *
 */
export interface ContainerMountsBindOptions {
    /**
     * A propagation mode with the value.
     */
    readonly propagation?: string;
}
/**
 *
 */
export interface ContainerMountsTmpfsOptions {
    /**
     * The permission mode for the tmpfs mount in an integer.
     */
    readonly mode?: number;
    /**
     * The size for the tmpfs mount in bytes.
     */
    readonly sizeBytes?: number;
}
/**
 *
 */
export interface ContainerMountsVolumeOptionsLabels {
    /**
     * Name of the label.
     */
    readonly label: string;
    /**
     * Value of the label.
     */
    readonly value: string;
}
/**
 *
 */
export interface ContainerMountsVolumeOptions {
    /**
     * Name of the driver to use to create the volume.
     */
    readonly driverName?: string;
    /**
     * key/value map of driver specific options.
     */
    readonly driverOptions?: {
        [key: string]: string;
    };
    /**
     * Populate volume with data from the target.
     */
    readonly noCopy?: boolean;
    /**
     * labels block.
     */
    readonly labels?: ContainerMountsVolumeOptionsLabels[];
}
/**
 *
 */
export interface ContainerMounts {
    /**
     * Whether the mount should be read-only.
     */
    readonly readOnly?: boolean;
    /**
     * Mount source (e.g. a volume name, a host path).
     */
    readonly source?: string;
    /**
     * Container path.
     */
    readonly target: string;
    /**
     * The mount type.
     */
    readonly type: string;
    /**
     * bind_options block.
     */
    readonly bindOptions?: ContainerMountsBindOptions[];
    /**
     * tmpfs_options block.
     */
    readonly tmpfsOptions?: ContainerMountsTmpfsOptions[];
    /**
     * volume_options block.
     */
    readonly volumeOptions?: ContainerMountsVolumeOptions[];
}
/**
 *
 */
export interface ContainerNetworksAdvanced {
    /**
     *
     */
    readonly aliases?: string[];
    /**
     *
     */
    readonly ipv4Address?: string;
    /**
     *
     */
    readonly ipv6Address?: string;
    /**
     *
     */
    readonly name: string;
}
/**
 *
 */
export interface ContainerPorts {
    /**
     *
     */
    readonly external?: number;
    /**
     *
     */
    readonly internal: number;
    /**
     *
     */
    readonly ip?: string;
    /**
     *
     */
    readonly protocol?: string;
}
/**
 *
 */
export interface ContainerUlimit {
    /**
     *
     */
    readonly hard: number;
    /**
     *
     */
    readonly name: string;
    /**
     *
     */
    readonly soft: number;
}
/**
 *
 */
export interface ContainerUpload {
    /**
     *
     */
    readonly content?: string;
    /**
     *
     */
    readonly contentBase64?: string;
    /**
     *
     */
    readonly executable?: boolean;
    /**
     *
     */
    readonly file: string;
    /**
     *
     */
    readonly source?: string;
    /**
     *
     */
    readonly sourceHash?: string;
}
/**
 *
 */
export interface ContainerVolumes {
    /**
     *
     */
    readonly containerPath?: string;
    /**
     *
     */
    readonly fromContainer?: string;
    /**
     *
     */
    readonly hostPath?: string;
    /**
     *
     */
    readonly readOnly?: boolean;
    /**
     *
     */
    readonly volumeName?: string;
}
/**
 *
 */
export declare class Container extends TerraformResource {
    /**
     *
     */
    constructor(scope: Construct, id: string, config: ContainerConfig);
    private _attach?;
    /**
     *
     */
    get attach(): boolean | undefined;
    /**
     *
     */
    set attach(value: boolean | undefined);
    /**
     *
     */
    get bridge(): string;
    private _command?;
    /**
     *
     */
    get command(): string[] | undefined;
    /**
     *
     */
    set command(value: string[] | undefined);
    /**
     *
     */
    get containerLogs(): string;
    private _cpuSet?;
    /**
     *
     */
    get cpuSet(): string | undefined;
    /**
     *
     */
    set cpuSet(value: string | undefined);
    private _cpuShares?;
    /**
     *
     */
    get cpuShares(): number | undefined;
    /**
     *
     */
    set cpuShares(value: number | undefined);
    private _destroyGraceSeconds?;
    /**
     *
     */
    get destroyGraceSeconds(): number | undefined;
    /**
     *
     */
    set destroyGraceSeconds(value: number | undefined);
    private _dns?;
    /**
     *
     */
    get dns(): string[] | undefined;
    /**
     *
     */
    set dns(value: string[] | undefined);
    private _dnsOpts?;
    /**
     *
     */
    get dnsOpts(): string[] | undefined;
    /**
     *
     */
    set dnsOpts(value: string[] | undefined);
    private _dnsSearch?;
    /**
     *
     */
    get dnsSearch(): string[] | undefined;
    /**
     *
     */
    set dnsSearch(value: string[] | undefined);
    private _domainname?;
    /**
     *
     */
    get domainname(): string | undefined;
    /**
     *
     */
    set domainname(value: string | undefined);
    private _entrypoint?;
    /**
     *
     */
    get entrypoint(): string[] | undefined;
    /**
     *
     */
    set entrypoint(value: string[] | undefined);
    private _env?;
    /**
     *
     */
    get env(): string[] | undefined;
    /**
     *
     */
    set env(value: string[] | undefined);
    /**
     *
     */
    get exitCode(): number;
    /**
     *
     */
    get gateway(): string;
    private _groupAdd?;
    /**
     *
     */
    get groupAdd(): string[] | undefined;
    /**
     *
     */
    set groupAdd(value: string[] | undefined);
    private _hostname?;
    /**
     *
     */
    get hostname(): string | undefined;
    /**
     *
     */
    set hostname(value: string | undefined);
    private _id?;
    /**
     *
     */
    get id(): string | undefined;
    /**
     *
     */
    set id(value: string | undefined);
    private _image;
    /**
     *
     */
    get image(): string;
    /**
     *
     */
    set image(value: string);
    /**
     *
     */
    get ipAddress(): string;
    /**
     *
     */
    get ipPrefixLength(): number;
    private _ipcMode?;
    /**
     *
     */
    get ipcMode(): string | undefined;
    /**
     *
     */
    set ipcMode(value: string | undefined);
    private _links?;
    /**
     *
     */
    get links(): string[] | undefined;
    /**
     *
     */
    set links(value: string[] | undefined);
    private _logDriver?;
    /**
     *
     */
    get logDriver(): string | undefined;
    /**
     *
     */
    set logDriver(value: string | undefined);
    private _logOpts?;
    /**
     *
     */
    get logOpts(): {
        [key: string]: string;
    } | undefined;
    /**
     *
     */
    set logOpts(value: {
        [key: string]: string;
    } | undefined);
    private _logs?;
    /**
     *
     */
    get logs(): boolean | undefined;
    /**
     *
     */
    set logs(value: boolean | undefined);
    private _maxRetryCount?;
    /**
     *
     */
    get maxRetryCount(): number | undefined;
    /**
     *
     */
    set maxRetryCount(value: number | undefined);
    private _memory?;
    /**
     *
     */
    get memory(): number | undefined;
    /**
     *
     */
    set memory(value: number | undefined);
    private _memorySwap?;
    /**
     *
     */
    get memorySwap(): number | undefined;
    /**
     *
     */
    set memorySwap(value: number | undefined);
    private _mustRun?;
    /**
     *
     */
    get mustRun(): boolean | undefined;
    /**
     *
     */
    set mustRun(value: boolean | undefined);
    private _name;
    /**
     *
     */
    get name(): string;
    /**
     *
     */
    set name(value: string);
    private _networkAlias?;
    /**
     *
     */
    get networkAlias(): string[] | undefined;
    /**
     *
     */
    set networkAlias(value: string[] | undefined);
    /**
     *
     */
    networkData(index: string): ContainerNetworkData;
    private _networkMode?;
    /**
     *
     */
    get networkMode(): string | undefined;
    /**
     *
     */
    set networkMode(value: string | undefined);
    private _networks?;
    /**
     *
     */
    get networks(): string[] | undefined;
    /**
     *
     */
    set networks(value: string[] | undefined);
    private _pidMode?;
    /**
     *
     */
    get pidMode(): string | undefined;
    /**
     *
     */
    set pidMode(value: string | undefined);
    private _privileged?;
    /**
     *
     */
    get privileged(): boolean | undefined;
    /**
     *
     */
    set privileged(value: boolean | undefined);
    private _publishAllPorts?;
    /**
     *
     */
    get publishAllPorts(): boolean | undefined;
    /**
     *
     */
    set publishAllPorts(value: boolean | undefined);
    private _readOnly?;
    /**
     *
     */
    get readOnly(): boolean | undefined;
    /**
     *
     */
    set readOnly(value: boolean | undefined);
    private _restart?;
    /**
     *
     */
    get restart(): string | undefined;
    /**
     *
     */
    set restart(value: string | undefined);
    private _rm?;
    /**
     *
     */
    get rm(): boolean | undefined;
    /**
     *
     */
    set rm(value: boolean | undefined);
    private _shmSize?;
    /**
     *
     */
    get shmSize(): number | undefined;
    /**
     *
     */
    set shmSize(value: number | undefined);
    private _start?;
    /**
     *
     */
    get start(): boolean | undefined;
    /**
     *
     */
    set start(value: boolean | undefined);
    private _sysctls?;
    /**
     *
     */
    get sysctls(): {
        [key: string]: string;
    } | undefined;
    /**
     *
     */
    set sysctls(value: {
        [key: string]: string;
    } | undefined);
    private _tmpfs?;
    /**
     *
     */
    get tmpfs(): {
        [key: string]: string;
    } | undefined;
    /**
     *
     */
    set tmpfs(value: {
        [key: string]: string;
    } | undefined);
    private _user?;
    /**
     *
     */
    get user(): string | undefined;
    /**
     *
     */
    set user(value: string | undefined);
    private _usernsMode?;
    /**
     *
     */
    get usernsMode(): string | undefined;
    /**
     *
     */
    set usernsMode(value: string | undefined);
    private _workingDir?;
    /**
     *
     */
    get workingDir(): string | undefined;
    /**
     *
     */
    set workingDir(value: string | undefined);
    private _capabilities?;
    /**
     *
     */
    get capabilities(): ContainerCapabilities[] | undefined;
    /**
     *
     */
    set capabilities(value: ContainerCapabilities[] | undefined);
    private _devices?;
    /**
     *
     */
    get devices(): ContainerDevices[] | undefined;
    /**
     *
     */
    set devices(value: ContainerDevices[] | undefined);
    private _healthcheck?;
    /**
     *
     */
    get healthcheck(): ContainerHealthcheck[] | undefined;
    /**
     *
     */
    set healthcheck(value: ContainerHealthcheck[] | undefined);
    private _host?;
    /**
     *
     */
    get host(): ContainerHost[] | undefined;
    /**
     *
     */
    set host(value: ContainerHost[] | undefined);
    private _labels?;
    /**
     *
     */
    get labels(): ContainerLabels[] | undefined;
    /**
     *
     */
    set labels(value: ContainerLabels[] | undefined);
    private _mounts?;
    /**
     *
     */
    get mounts(): ContainerMounts[] | undefined;
    /**
     *
     */
    set mounts(value: ContainerMounts[] | undefined);
    private _networksAdvanced?;
    /**
     *
     */
    get networksAdvanced(): ContainerNetworksAdvanced[] | undefined;
    /**
     *
     */
    set networksAdvanced(value: ContainerNetworksAdvanced[] | undefined);
    private _ports?;
    /**
     *
     */
    get ports(): ContainerPorts[] | undefined;
    /**
     *
     */
    set ports(value: ContainerPorts[] | undefined);
    private _ulimit?;
    /**
     *
     */
    get ulimit(): ContainerUlimit[] | undefined;
    /**
     *
     */
    set ulimit(value: ContainerUlimit[] | undefined);
    private _upload?;
    /**
     *
     */
    get upload(): ContainerUpload[] | undefined;
    /**
     *
     */
    set upload(value: ContainerUpload[] | undefined);
    private _volumes?;
    /**
     *
     */
    get volumes(): ContainerVolumes[] | undefined;
    /**
     *
     */
    set volumes(value: ContainerVolumes[] | undefined);
    /**
     *
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
