"use strict";
// https://www.terraform.io/docs/providers/docker/r/container.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.Container = exports.ContainerNetworkData = void 0;
const cdktf_1 = require("cdktf");
const cdktf_2 = require("cdktf");
/**
 *
 */
class ContainerNetworkData extends cdktf_2.ComplexComputedList {
    // gateway - computed: true, optional: false, required: true
    /**
     *
     */
    get gateway() {
        return this.getStringAttribute('gateway');
    }
    // ip_address - computed: true, optional: false, required: true
    /**
     *
     */
    get ipAddress() {
        return this.getStringAttribute('ip_address');
    }
    // ip_prefix_length - computed: true, optional: false, required: true
    /**
     *
     */
    get ipPrefixLength() {
        return this.getNumberAttribute('ip_prefix_length');
    }
    // network_name - computed: true, optional: false, required: true
    /**
     *
     */
    get networkName() {
        return this.getStringAttribute('network_name');
    }
}
exports.ContainerNetworkData = ContainerNetworkData;
// Resource
/**
 *
 */
class Container extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
     *
     */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'docker_container',
            terraformGeneratorMetadata: {
                providerName: 'docker'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._attach = config.attach;
        this._command = config.command;
        this._cpuSet = config.cpuSet;
        this._cpuShares = config.cpuShares;
        this._destroyGraceSeconds = config.destroyGraceSeconds;
        this._dns = config.dns;
        this._dnsOpts = config.dnsOpts;
        this._dnsSearch = config.dnsSearch;
        this._domainname = config.domainname;
        this._entrypoint = config.entrypoint;
        this._env = config.env;
        this._groupAdd = config.groupAdd;
        this._hostname = config.hostname;
        this._image = config.image;
        this._ipcMode = config.ipcMode;
        this._links = config.links;
        this._logDriver = config.logDriver;
        this._logOpts = config.logOpts;
        this._logs = config.logs;
        this._maxRetryCount = config.maxRetryCount;
        this._memory = config.memory;
        this._memorySwap = config.memorySwap;
        this._mustRun = config.mustRun;
        this._name = config.name;
        this._networkAlias = config.networkAlias;
        this._networkMode = config.networkMode;
        this._networks = config.networks;
        this._pidMode = config.pidMode;
        this._privileged = config.privileged;
        this._publishAllPorts = config.publishAllPorts;
        this._readOnly = config.readOnly;
        this._restart = config.restart;
        this._rm = config.rm;
        this._shmSize = config.shmSize;
        this._start = config.start;
        this._sysctls = config.sysctls;
        this._tmpfs = config.tmpfs;
        this._user = config.user;
        this._usernsMode = config.usernsMode;
        this._workingDir = config.workingDir;
        this._capabilities = config.capabilities;
        this._devices = config.devices;
        this._healthcheck = config.healthcheck;
        this._host = config.host;
        this._labels = config.labels;
        this._mounts = config.mounts;
        this._networksAdvanced = config.networksAdvanced;
        this._ports = config.ports;
        this._ulimit = config.ulimit;
        this._upload = config.upload;
        this._volumes = config.volumes;
    }
    /**
     *
     */
    get attach() {
        return this._attach;
    }
    /**
     *
     */
    set attach(value) {
        this._attach = value;
    }
    // bridge - computed: true, optional: false, required: true
    /**
     *
     */
    get bridge() {
        return this.getStringAttribute('bridge');
    }
    /**
     *
     */
    get command() {
        var _a;
        return (_a = this._command) !== null && _a !== void 0 ? _a : this.getListAttribute('command');
    }
    /**
     *
     */
    set command(value) {
        this._command = value;
    }
    // container_logs - computed: true, optional: false, required: true
    /**
     *
     */
    get containerLogs() {
        return this.getStringAttribute('container_logs');
    }
    /**
     *
     */
    get cpuSet() {
        return this._cpuSet;
    }
    /**
     *
     */
    set cpuSet(value) {
        this._cpuSet = value;
    }
    /**
     *
     */
    get cpuShares() {
        return this._cpuShares;
    }
    /**
     *
     */
    set cpuShares(value) {
        this._cpuShares = value;
    }
    /**
     *
     */
    get destroyGraceSeconds() {
        return this._destroyGraceSeconds;
    }
    /**
     *
     */
    set destroyGraceSeconds(value) {
        this._destroyGraceSeconds = value;
    }
    /**
     *
     */
    get dns() {
        var _a;
        return (_a = this._dns) !== null && _a !== void 0 ? _a : this.getListAttribute('dns');
    }
    /**
     *
     */
    set dns(value) {
        this._dns = value;
    }
    /**
     *
     */
    get dnsOpts() {
        var _a;
        return (_a = this._dnsOpts) !== null && _a !== void 0 ? _a : this.getListAttribute('dns_opts');
    }
    /**
     *
     */
    set dnsOpts(value) {
        this._dnsOpts = value;
    }
    /**
     *
     */
    get dnsSearch() {
        return this._dnsSearch;
    }
    /**
     *
     */
    set dnsSearch(value) {
        this._dnsSearch = value;
    }
    /**
     *
     */
    get domainname() {
        return this._domainname;
    }
    /**
     *
     */
    set domainname(value) {
        this._domainname = value;
    }
    /**
     *
     */
    get entrypoint() {
        var _a;
        return (_a = this._entrypoint) !== null && _a !== void 0 ? _a : this.getListAttribute('entrypoint');
    }
    /**
     *
     */
    set entrypoint(value) {
        this._entrypoint = value;
    }
    /**
     *
     */
    get env() {
        return this._env;
    }
    /**
     *
     */
    set env(value) {
        this._env = value;
    }
    // exit_code - computed: true, optional: false, required: true
    /**
     *
     */
    get exitCode() {
        return this.getNumberAttribute('exit_code');
    }
    // gateway - computed: true, optional: false, required: true
    /**
     *
     */
    get gateway() {
        return this.getStringAttribute('gateway');
    }
    /**
     *
     */
    get groupAdd() {
        return this._groupAdd;
    }
    /**
     *
     */
    set groupAdd(value) {
        this._groupAdd = value;
    }
    /**
     *
     */
    get hostname() {
        var _a;
        return (_a = this._hostname) !== null && _a !== void 0 ? _a : this.getStringAttribute('hostname');
    }
    /**
     *
     */
    set hostname(value) {
        this._hostname = value;
    }
    /**
     *
     */
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    /**
     *
     */
    set id(value) {
        this._id = value;
    }
    /**
     *
     */
    get image() {
        return this._image;
    }
    /**
     *
     */
    set image(value) {
        this._image = value;
    }
    // ip_address - computed: true, optional: false, required: true
    /**
     *
     */
    get ipAddress() {
        return this.getStringAttribute('ip_address');
    }
    // ip_prefix_length - computed: true, optional: false, required: true
    /**
     *
     */
    get ipPrefixLength() {
        return this.getNumberAttribute('ip_prefix_length');
    }
    /**
     *
     */
    get ipcMode() {
        var _a;
        return (_a = this._ipcMode) !== null && _a !== void 0 ? _a : this.getStringAttribute('ipc_mode');
    }
    /**
     *
     */
    set ipcMode(value) {
        this._ipcMode = value;
    }
    /**
     *
     */
    get links() {
        return this._links;
    }
    /**
     *
     */
    set links(value) {
        this._links = value;
    }
    /**
     *
     */
    get logDriver() {
        var _a;
        return (_a = this._logDriver) !== null && _a !== void 0 ? _a : this.getStringAttribute('log_driver');
    }
    /**
     *
     */
    set logDriver(value) {
        this._logDriver = value;
    }
    /**
     *
     */
    get logOpts() {
        return this._logOpts; // Getting the computed value is not yet implemented
    }
    /**
     *
     */
    set logOpts(value) {
        this._logOpts = value;
    }
    /**
     *
     */
    get logs() {
        return this._logs;
    }
    /**
     *
     */
    set logs(value) {
        this._logs = value;
    }
    /**
     *
     */
    get maxRetryCount() {
        return this._maxRetryCount;
    }
    /**
     *
     */
    set maxRetryCount(value) {
        this._maxRetryCount = value;
    }
    /**
     *
     */
    get memory() {
        return this._memory;
    }
    /**
     *
     */
    set memory(value) {
        this._memory = value;
    }
    /**
     *
     */
    get memorySwap() {
        return this._memorySwap;
    }
    /**
     *
     */
    set memorySwap(value) {
        this._memorySwap = value;
    }
    /**
     *
     */
    get mustRun() {
        return this._mustRun;
    }
    /**
     *
     */
    set mustRun(value) {
        this._mustRun = value;
    }
    /**
     *
     */
    get name() {
        return this._name;
    }
    /**
     *
     */
    set name(value) {
        this._name = value;
    }
    /**
     *
     */
    get networkAlias() {
        return this._networkAlias;
    }
    /**
     *
     */
    set networkAlias(value) {
        this._networkAlias = value;
    }
    // network_data - computed: true, optional: false, required: true
    /**
     *
     */
    networkData(index) {
        return new ContainerNetworkData(this, 'network_data', index);
    }
    /**
     *
     */
    get networkMode() {
        return this._networkMode;
    }
    /**
     *
     */
    set networkMode(value) {
        this._networkMode = value;
    }
    /**
     *
     */
    get networks() {
        return this._networks;
    }
    /**
     *
     */
    set networks(value) {
        this._networks = value;
    }
    /**
     *
     */
    get pidMode() {
        return this._pidMode;
    }
    /**
     *
     */
    set pidMode(value) {
        this._pidMode = value;
    }
    /**
     *
     */
    get privileged() {
        return this._privileged;
    }
    /**
     *
     */
    set privileged(value) {
        this._privileged = value;
    }
    /**
     *
     */
    get publishAllPorts() {
        return this._publishAllPorts;
    }
    /**
     *
     */
    set publishAllPorts(value) {
        this._publishAllPorts = value;
    }
    /**
     *
     */
    get readOnly() {
        return this._readOnly;
    }
    /**
     *
     */
    set readOnly(value) {
        this._readOnly = value;
    }
    /**
     *
     */
    get restart() {
        return this._restart;
    }
    /**
     *
     */
    set restart(value) {
        this._restart = value;
    }
    /**
     *
     */
    get rm() {
        return this._rm;
    }
    /**
     *
     */
    set rm(value) {
        this._rm = value;
    }
    /**
     *
     */
    get shmSize() {
        var _a;
        return (_a = this._shmSize) !== null && _a !== void 0 ? _a : this.getNumberAttribute('shm_size');
    }
    /**
     *
     */
    set shmSize(value) {
        this._shmSize = value;
    }
    /**
     *
     */
    get start() {
        return this._start;
    }
    /**
     *
     */
    set start(value) {
        this._start = value;
    }
    /**
     *
     */
    get sysctls() {
        return this._sysctls;
    }
    /**
     *
     */
    set sysctls(value) {
        this._sysctls = value;
    }
    /**
     *
     */
    get tmpfs() {
        return this._tmpfs;
    }
    /**
     *
     */
    set tmpfs(value) {
        this._tmpfs = value;
    }
    /**
     *
     */
    get user() {
        var _a;
        return (_a = this._user) !== null && _a !== void 0 ? _a : this.getStringAttribute('user');
    }
    /**
     *
     */
    set user(value) {
        this._user = value;
    }
    /**
     *
     */
    get usernsMode() {
        return this._usernsMode;
    }
    /**
     *
     */
    set usernsMode(value) {
        this._usernsMode = value;
    }
    /**
     *
     */
    get workingDir() {
        var _a;
        return (_a = this._workingDir) !== null && _a !== void 0 ? _a : this.getStringAttribute('working_dir');
    }
    /**
     *
     */
    set workingDir(value) {
        this._workingDir = value;
    }
    /**
     *
     */
    get capabilities() {
        return this._capabilities;
    }
    /**
     *
     */
    set capabilities(value) {
        this._capabilities = value;
    }
    /**
     *
     */
    get devices() {
        return this._devices;
    }
    /**
     *
     */
    set devices(value) {
        this._devices = value;
    }
    /**
     *
     */
    get healthcheck() {
        return this._healthcheck;
    }
    /**
     *
     */
    set healthcheck(value) {
        this._healthcheck = value;
    }
    /**
     *
     */
    get host() {
        return this._host;
    }
    /**
     *
     */
    set host(value) {
        this._host = value;
    }
    /**
     *
     */
    get labels() {
        return this._labels;
    }
    /**
     *
     */
    set labels(value) {
        this._labels = value;
    }
    /**
     *
     */
    get mounts() {
        return this._mounts;
    }
    /**
     *
     */
    set mounts(value) {
        this._mounts = value;
    }
    /**
     *
     */
    get networksAdvanced() {
        return this._networksAdvanced;
    }
    /**
     *
     */
    set networksAdvanced(value) {
        this._networksAdvanced = value;
    }
    /**
     *
     */
    get ports() {
        return this._ports;
    }
    /**
     *
     */
    set ports(value) {
        this._ports = value;
    }
    /**
     *
     */
    get ulimit() {
        return this._ulimit;
    }
    /**
     *
     */
    set ulimit(value) {
        this._ulimit = value;
    }
    /**
     *
     */
    get upload() {
        return this._upload;
    }
    /**
     *
     */
    set upload(value) {
        this._upload = value;
    }
    /**
     *
     */
    get volumes() {
        return this._volumes;
    }
    /**
     *
     */
    set volumes(value) {
        this._volumes = value;
    }
    // =========
    // SYNTHESIS
    // =========
    /**
     *
     */
    synthesizeAttributes() {
        return {
            attach: this._attach,
            command: this._command,
            cpu_set: this._cpuSet,
            cpu_shares: this._cpuShares,
            destroy_grace_seconds: this._destroyGraceSeconds,
            dns: this._dns,
            dns_opts: this._dnsOpts,
            dns_search: this._dnsSearch,
            domainname: this._domainname,
            entrypoint: this._entrypoint,
            env: this._env,
            group_add: this._groupAdd,
            hostname: this._hostname,
            image: this._image,
            ipc_mode: this._ipcMode,
            links: this._links,
            log_driver: this._logDriver,
            log_opts: this._logOpts,
            logs: this._logs,
            max_retry_count: this._maxRetryCount,
            memory: this._memory,
            memory_swap: this._memorySwap,
            must_run: this._mustRun,
            name: this._name,
            network_alias: this._networkAlias,
            network_mode: this._networkMode,
            networks: this._networks,
            pid_mode: this._pidMode,
            privileged: this._privileged,
            publish_all_ports: this._publishAllPorts,
            read_only: this._readOnly,
            restart: this._restart,
            rm: this._rm,
            shm_size: this._shmSize,
            start: this._start,
            sysctls: this._sysctls,
            tmpfs: this._tmpfs,
            user: this._user,
            userns_mode: this._usernsMode,
            working_dir: this._workingDir,
            capabilities: this._capabilities,
            devices: this._devices,
            healthcheck: this._healthcheck,
            host: this._host,
            labels: this._labels,
            mounts: this._mounts,
            networks_advanced: this._networksAdvanced,
            ports: this._ports,
            ulimit: this._ulimit,
            upload: this._upload,
            volumes: this._volumes,
        };
    }
}
exports.Container = Container;
//# sourceMappingURL=data:application/json;base64,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