import { Construct } from 'constructs';
import { TerraformProvider } from 'cdktf';
/**
 *
 */
export interface DockerProviderConfig {
    /**
     * PEM-encoded content of Docker host CA certificate.
     */
    readonly caMaterial?: string;
    /**
     * PEM-encoded content of Docker client certificate.
     */
    readonly certMaterial?: string;
    /**
     * Path to directory with Docker TLS config.
     */
    readonly certPath?: string;
    /**
     * The Docker daemon address.
     */
    readonly host?: string;
    /**
     * PEM-encoded content of Docker client private key.
     */
    readonly keyMaterial?: string;
    /**
     * Alias name.
     */
    readonly alias?: string;
    /**
     * registry_auth block.
     */
    readonly registryAuth?: DockerProviderRegistryAuth[];
}
/**
 *
 */
export interface DockerProviderRegistryAuth {
    /**
     * Address of the registry.
     */
    readonly address: string;
    /**
     * Path to docker json file for registry auth.
     */
    readonly configFile?: string;
    /**
     * Plain content of the docker json file for registry auth.
     */
    readonly configFileContent?: string;
    /**
     * Password for the registry.
     */
    readonly password?: string;
    /**
     * Username for the registry.
     */
    readonly username?: string;
}
/**
 *
 */
export declare class DockerProvider extends TerraformProvider {
    /**
     *
     */
    constructor(scope: Construct, id: string, config?: DockerProviderConfig);
    private _caMaterial?;
    /**
     *
     */
    get caMaterial(): string | undefined;
    /**
     *
     */
    set caMaterial(value: string | undefined);
    private _certMaterial?;
    /**
     *
     */
    get certMaterial(): string | undefined;
    /**
     *
     */
    set certMaterial(value: string | undefined);
    private _certPath?;
    /**
     *
     */
    get certPath(): string | undefined;
    /**
     *
     */
    set certPath(value: string | undefined);
    private _host?;
    /**
     *
     */
    get host(): string | undefined;
    /**
     *
     */
    set host(value: string | undefined);
    private _keyMaterial?;
    /**
     *
     */
    get keyMaterial(): string | undefined;
    /**
     *
     */
    set keyMaterial(value: string | undefined);
    private _alias?;
    /**
     *
     */
    get alias(): string | undefined;
    /**
     *
     */
    set alias(value: string | undefined);
    private _registryAuth?;
    /**
     *
     */
    get registryAuth(): DockerProviderRegistryAuth[] | undefined;
    /**
     *
     */
    set registryAuth(value: DockerProviderRegistryAuth[] | undefined);
    /**
     *
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
