"use strict";
// https://www.terraform.io/docs/providers/docker/r/docker_provider.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.DockerProvider = void 0;
const cdktf_1 = require("cdktf");
// Resource
/**
 *
 */
class DockerProvider extends cdktf_1.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
     *
     */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'docker',
            terraformGeneratorMetadata: {
                providerName: 'docker',
                providerVersionConstraint: '~> 2.0'
            },
            terraformProviderSource: 'terraform-providers/docker'
        });
        this._caMaterial = config.caMaterial;
        this._certMaterial = config.certMaterial;
        this._certPath = config.certPath;
        this._host = config.host;
        this._keyMaterial = config.keyMaterial;
        this._alias = config.alias;
        this._registryAuth = config.registryAuth;
    }
    /**
     *
     */
    get caMaterial() {
        return this._caMaterial;
    }
    /**
     *
     */
    set caMaterial(value) {
        this._caMaterial = value;
    }
    /**
     *
     */
    get certMaterial() {
        return this._certMaterial;
    }
    /**
     *
     */
    set certMaterial(value) {
        this._certMaterial = value;
    }
    /**
     *
     */
    get certPath() {
        return this._certPath;
    }
    /**
     *
     */
    set certPath(value) {
        this._certPath = value;
    }
    /**
     *
     */
    get host() {
        return this._host;
    }
    /**
     *
     */
    set host(value) {
        this._host = value;
    }
    /**
     *
     */
    get keyMaterial() {
        return this._keyMaterial;
    }
    /**
     *
     */
    set keyMaterial(value) {
        this._keyMaterial = value;
    }
    /**
     *
     */
    get alias() {
        return this._alias;
    }
    /**
     *
     */
    set alias(value) {
        this._alias = value;
    }
    /**
     *
     */
    get registryAuth() {
        return this._registryAuth;
    }
    /**
     *
     */
    set registryAuth(value) {
        this._registryAuth = value;
    }
    // =========
    // SYNTHESIS
    // =========
    /**
     *
     */
    synthesizeAttributes() {
        return {
            ca_material: this._caMaterial,
            cert_material: this._certMaterial,
            cert_path: this._certPath,
            host: this._host,
            key_material: this._keyMaterial,
            alias: this._alias,
            registry_auth: this._registryAuth,
        };
    }
}
exports.DockerProvider = DockerProvider;
//# sourceMappingURL=data:application/json;base64,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