import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
/**
 *
 */
export interface NetworkConfig extends TerraformMetaArguments {
    /**
     *
     */
    readonly attachable?: boolean;
    /**
     *
     */
    readonly checkDuplicate?: boolean;
    /**
     *
     */
    readonly driver?: string;
    /**
     *
     */
    readonly ingress?: boolean;
    /**
     *
     */
    readonly internal?: boolean;
    /**
     *
     */
    readonly ipamDriver?: string;
    /**
     *
     */
    readonly ipv6?: boolean;
    /**
     *
     */
    readonly name: string;
    /**
     *
     */
    readonly options?: {
        [key: string]: string;
    };
    /**
     * ipam_config block.
     */
    readonly ipamConfig?: NetworkIpamConfig[];
    /**
     * labels block.
     */
    readonly labels?: NetworkLabels[];
}
/**
 *
 */
export interface NetworkIpamConfig {
    /**
     *
     */
    readonly auxAddress?: {
        [key: string]: string;
    };
    /**
     *
     */
    readonly gateway?: string;
    /**
     *
     */
    readonly ipRange?: string;
    /**
     *
     */
    readonly subnet?: string;
}
/**
 *
 */
export interface NetworkLabels {
    /**
     * Name of the label.
     */
    readonly label: string;
    /**
     * Value of the label.
     */
    readonly value: string;
}
/**
 *
 */
export declare class Network extends TerraformResource {
    /**
     *
     */
    constructor(scope: Construct, id: string, config: NetworkConfig);
    private _attachable?;
    /**
     *
     */
    get attachable(): boolean | undefined;
    /**
     *
     */
    set attachable(value: boolean | undefined);
    private _checkDuplicate?;
    /**
     *
     */
    get checkDuplicate(): boolean | undefined;
    /**
     *
     */
    set checkDuplicate(value: boolean | undefined);
    private _driver?;
    /**
     *
     */
    get driver(): string | undefined;
    /**
     *
     */
    set driver(value: string | undefined);
    private _id?;
    /**
     *
     */
    get id(): string | undefined;
    /**
     *
     */
    set id(value: string | undefined);
    private _ingress?;
    /**
     *
     */
    get ingress(): boolean | undefined;
    /**
     *
     */
    set ingress(value: boolean | undefined);
    private _internal?;
    /**
     *
     */
    get internal(): boolean | undefined;
    /**
     *
     */
    set internal(value: boolean | undefined);
    private _ipamDriver?;
    /**
     *
     */
    get ipamDriver(): string | undefined;
    /**
     *
     */
    set ipamDriver(value: string | undefined);
    private _ipv6?;
    /**
     *
     */
    get ipv6(): boolean | undefined;
    /**
     *
     */
    set ipv6(value: boolean | undefined);
    private _name;
    /**
     *
     */
    get name(): string;
    /**
     *
     */
    set name(value: string);
    private _options?;
    /**
     *
     */
    get options(): {
        [key: string]: string;
    } | undefined;
    /**
     *
     */
    set options(value: {
        [key: string]: string;
    } | undefined);
    /**
     *
     */
    get scope(): string;
    private _ipamConfig?;
    /**
     *
     */
    get ipamConfig(): NetworkIpamConfig[] | undefined;
    /**
     *
     */
    set ipamConfig(value: NetworkIpamConfig[] | undefined);
    private _labels?;
    /**
     *
     */
    get labels(): NetworkLabels[] | undefined;
    /**
     *
     */
    set labels(value: NetworkLabels[] | undefined);
    /**
     *
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
