"use strict";
// https://www.terraform.io/docs/providers/docker/r/network.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.Network = void 0;
const cdktf_1 = require("cdktf");
// Resource
/**
 *
 */
class Network extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
     *
     */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'docker_network',
            terraformGeneratorMetadata: {
                providerName: 'docker'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._attachable = config.attachable;
        this._checkDuplicate = config.checkDuplicate;
        this._driver = config.driver;
        this._ingress = config.ingress;
        this._internal = config.internal;
        this._ipamDriver = config.ipamDriver;
        this._ipv6 = config.ipv6;
        this._name = config.name;
        this._options = config.options;
        this._ipamConfig = config.ipamConfig;
        this._labels = config.labels;
    }
    /**
     *
     */
    get attachable() {
        return this._attachable;
    }
    /**
     *
     */
    set attachable(value) {
        this._attachable = value;
    }
    /**
     *
     */
    get checkDuplicate() {
        return this._checkDuplicate;
    }
    /**
     *
     */
    set checkDuplicate(value) {
        this._checkDuplicate = value;
    }
    /**
     *
     */
    get driver() {
        var _a;
        return (_a = this._driver) !== null && _a !== void 0 ? _a : this.getStringAttribute('driver');
    }
    /**
     *
     */
    set driver(value) {
        this._driver = value;
    }
    /**
     *
     */
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    /**
     *
     */
    set id(value) {
        this._id = value;
    }
    /**
     *
     */
    get ingress() {
        return this._ingress;
    }
    /**
     *
     */
    set ingress(value) {
        this._ingress = value;
    }
    /**
     *
     */
    get internal() {
        var _a;
        return (_a = this._internal) !== null && _a !== void 0 ? _a : this.getBooleanAttribute('internal');
    }
    /**
     *
     */
    set internal(value) {
        this._internal = value;
    }
    /**
     *
     */
    get ipamDriver() {
        return this._ipamDriver;
    }
    /**
     *
     */
    set ipamDriver(value) {
        this._ipamDriver = value;
    }
    /**
     *
     */
    get ipv6() {
        return this._ipv6;
    }
    /**
     *
     */
    set ipv6(value) {
        this._ipv6 = value;
    }
    /**
     *
     */
    get name() {
        return this._name;
    }
    /**
     *
     */
    set name(value) {
        this._name = value;
    }
    /**
     *
     */
    get options() {
        return this._options; // Getting the computed value is not yet implemented
    }
    /**
     *
     */
    set options(value) {
        this._options = value;
    }
    // scope - computed: true, optional: false, required: true
    /**
     *
     */
    get scope() {
        return this.getStringAttribute('scope');
    }
    /**
     *
     */
    get ipamConfig() {
        return this._ipamConfig;
    }
    /**
     *
     */
    set ipamConfig(value) {
        this._ipamConfig = value;
    }
    /**
     *
     */
    get labels() {
        return this._labels;
    }
    /**
     *
     */
    set labels(value) {
        this._labels = value;
    }
    // =========
    // SYNTHESIS
    // =========
    /**
     *
     */
    synthesizeAttributes() {
        return {
            attachable: this._attachable,
            check_duplicate: this._checkDuplicate,
            driver: this._driver,
            ingress: this._ingress,
            internal: this._internal,
            ipam_driver: this._ipamDriver,
            ipv6: this._ipv6,
            name: this._name,
            options: this._options,
            ipam_config: this._ipamConfig,
            labels: this._labels,
        };
    }
}
exports.Network = Network;
//# sourceMappingURL=data:application/json;base64,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