import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
/**
 *
 */
export interface SecretConfig extends TerraformMetaArguments {
    /**
     * Base64-url-safe-encoded secret data.
     */
    readonly data: string;
    /**
     * User-defined name of the secret.
     */
    readonly name: string;
    /**
     * labels block.
     */
    readonly labels?: SecretLabels[];
}
/**
 *
 */
export interface SecretLabels {
    /**
     * Name of the label.
     */
    readonly label: string;
    /**
     * Value of the label.
     */
    readonly value: string;
}
/**
 *
 */
export declare class Secret extends TerraformResource {
    /**
     *
     */
    constructor(scope: Construct, id: string, config: SecretConfig);
    private _data;
    /**
     *
     */
    get data(): string;
    /**
     *
     */
    set data(value: string);
    private _id?;
    /**
     *
     */
    get id(): string | undefined;
    /**
     *
     */
    set id(value: string | undefined);
    private _name;
    /**
     *
     */
    get name(): string;
    /**
     *
     */
    set name(value: string);
    private _labels?;
    /**
     *
     */
    get labels(): SecretLabels[] | undefined;
    /**
     *
     */
    set labels(value: SecretLabels[] | undefined);
    /**
     *
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
