"use strict";
// https://www.terraform.io/docs/providers/docker/r/service.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.Service = void 0;
const cdktf_1 = require("cdktf");
// Resource
/**
 *
 */
class Service extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
     *
     */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'docker_service',
            terraformGeneratorMetadata: {
                providerName: 'docker'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._auth = config.auth;
        this._name = config.name;
        this._convergeConfig = config.convergeConfig;
        this._endpointSpec = config.endpointSpec;
        this._labels = config.labels;
        this._mode = config.mode;
        this._rollbackConfig = config.rollbackConfig;
        this._taskSpec = config.taskSpec;
        this._updateConfig = config.updateConfig;
    }
    /**
     *
     */
    get auth() {
        return this._auth;
    }
    /**
     *
     */
    set auth(value) {
        this._auth = value;
    }
    /**
     *
     */
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    /**
     *
     */
    set id(value) {
        this._id = value;
    }
    /**
     *
     */
    get name() {
        return this._name;
    }
    /**
     *
     */
    set name(value) {
        this._name = value;
    }
    /**
     *
     */
    get convergeConfig() {
        return this._convergeConfig;
    }
    /**
     *
     */
    set convergeConfig(value) {
        this._convergeConfig = value;
    }
    /**
     *
     */
    get endpointSpec() {
        return this._endpointSpec;
    }
    /**
     *
     */
    set endpointSpec(value) {
        this._endpointSpec = value;
    }
    /**
     *
     */
    get labels() {
        return this._labels;
    }
    /**
     *
     */
    set labels(value) {
        this._labels = value;
    }
    /**
     *
     */
    get mode() {
        return this._mode;
    }
    /**
     *
     */
    set mode(value) {
        this._mode = value;
    }
    /**
     *
     */
    get rollbackConfig() {
        return this._rollbackConfig;
    }
    /**
     *
     */
    set rollbackConfig(value) {
        this._rollbackConfig = value;
    }
    /**
     *
     */
    get taskSpec() {
        return this._taskSpec;
    }
    /**
     *
     */
    set taskSpec(value) {
        this._taskSpec = value;
    }
    /**
     *
     */
    get updateConfig() {
        return this._updateConfig;
    }
    /**
     *
     */
    set updateConfig(value) {
        this._updateConfig = value;
    }
    // =========
    // SYNTHESIS
    // =========
    /**
     *
     */
    synthesizeAttributes() {
        return {
            auth: this._auth,
            name: this._name,
            converge_config: this._convergeConfig,
            endpoint_spec: this._endpointSpec,
            labels: this._labels,
            mode: this._mode,
            rollback_config: this._rollbackConfig,
            task_spec: this._taskSpec,
            update_config: this._updateConfig,
        };
    }
}
exports.Service = Service;
//# sourceMappingURL=data:application/json;base64,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