import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
/**
 *
 */
export interface VolumeConfig extends TerraformMetaArguments {
    /**
     *
     */
    readonly driver?: string;
    /**
     *
     */
    readonly driverOpts?: {
        [key: string]: string;
    };
    /**
     *
     */
    readonly name?: string;
    /**
     * labels block.
     */
    readonly labels?: VolumeLabels[];
}
/**
 *
 */
export interface VolumeLabels {
    /**
     * Name of the label.
     */
    readonly label: string;
    /**
     * Value of the label.
     */
    readonly value: string;
}
/**
 *
 */
export declare class Volume extends TerraformResource {
    /**
     *
     */
    constructor(scope: Construct, id: string, config?: VolumeConfig);
    private _driver?;
    /**
     *
     */
    get driver(): string | undefined;
    /**
     *
     */
    set driver(value: string | undefined);
    private _driverOpts?;
    /**
     *
     */
    get driverOpts(): {
        [key: string]: string;
    } | undefined;
    /**
     *
     */
    set driverOpts(value: {
        [key: string]: string;
    } | undefined);
    private _id?;
    /**
     *
     */
    get id(): string | undefined;
    /**
     *
     */
    set id(value: string | undefined);
    /**
     *
     */
    get mountpoint(): string;
    private _name?;
    /**
     *
     */
    get name(): string | undefined;
    /**
     *
     */
    set name(value: string | undefined);
    private _labels?;
    /**
     *
     */
    get labels(): VolumeLabels[] | undefined;
    /**
     *
     */
    set labels(value: VolumeLabels[] | undefined);
    /**
     *
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
