#!/usr/bin/env python
from setuptools import setup


def get_version(v, full_version=''):
    if v.count('.') > 2:
        v = ".Post".join(v.rsplit('.', 1))
        # non-tagged commits should only go to testpypi
        # where the hash postfix is allowed in the version name
        if '-' in full_version:
            git_hash = full_version.split('-')[1]
            # hash is int encoded (base 36) to allow upload
            v += ".dev%d" % int(git_hash, 36)
    print("setup version = %s" % v)
    return v


version = get_version('2.9.1', '2.9.1')


setup(
    name='uda',
    version=version,
    install_requires=["pyuda==%s" % version],
    packages=['uda'],
)
