/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.frontc;

import fr.inria.frontc.TNode;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CSymbolTable {
    private final Vector scopeStack = new Vector(10);
    private final Hashtable<String, TNode> symTable = new Hashtable(533);

    public void pushScope(String s) {
        this.scopeStack.addElement(s);
    }

    public void popScope() {
        int size = this.scopeStack.size();
        if (size > 0) {
            this.scopeStack.removeElementAt(size - 1);
        }
    }

    public int nbScopes() {
        return this.scopeStack.size();
    }

    private String currentScopeAsString() {
        StringBuilder buf = new StringBuilder(100);
        boolean first = true;
        Enumeration e = this.scopeStack.elements();
        while (e.hasMoreElements()) {
            if (first) {
                first = false;
            } else {
                buf.append("::");
            }
            buf.append(e.nextElement().toString());
        }
        return buf.toString();
    }

    private String addCurrentScopeToName(String name) {
        String currScope = this.currentScopeAsString();
        return this.addScopeToName(currScope, name);
    }

    private String addScopeToName(String scope, String name) {
        if (scope == null || !scope.isEmpty()) {
            return scope + "::" + name;
        }
        return name;
    }

    private String removeOneLevelScope(String scopeName) {
        int index = scopeName.lastIndexOf("::");
        if (index > 0) {
            return scopeName.substring(0, index);
        }
        if (!scopeName.isEmpty()) {
            return "";
        }
        return null;
    }

    public TNode add(String name, TNode node) {
        return this.symTable.put(this.addCurrentScopeToName(name), node);
    }

    public TNode lookupScopedName(String scopedName) {
        return this.symTable.get(scopedName);
    }

    public TNode lookupNameInCurrentScope(String name) {
        String scope = this.currentScopeAsString();
        TNode tnode = null;
        while (tnode == null && scope != null) {
            String scopedName = this.addScopeToName(scope, name);
            tnode = this.symTable.get(scopedName);
            scope = this.removeOneLevelScope(scope);
        }
        return tnode;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder(300);
        buff.append("CSymbolTable { \nCurrentScope: ").append(this.currentScopeAsString()).append("\nDefinedSymbols:\n");
        Enumeration<String> ke = this.symTable.keys();
        Enumeration<TNode> ve = this.symTable.elements();
        while (ke.hasMoreElements()) {
            buff.append(ke.nextElement().toString()).append(" (").append(TNode.getNameForType(ve.nextElement().getType())).append(")\n");
        }
        buff.append("}\n");
        return buff.toString();
    }
}

