/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.frontc;

import antlr.BaseAST;
import antlr.CommonAST;
import antlr.Token;
import antlr.collections.AST;
import fr.inria.frontc.CToken;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;

public class TNode
extends CommonAST {
    static final long serialVersionUID = 1L;
    private static String tokenVocabulary;
    private int ttype;
    private String text;
    private int lineNum;
    private TNode defNode;
    private TNode up;
    private TNode left;
    private boolean marker;
    private Hashtable attributes;

    public static void setTokenVocabulary(String s) {
        tokenVocabulary = s;
    }

    public static void printTree(AST t) {
        if (t == null) {
            return;
        }
        TNode.printASTNode(t, 0);
        System.out.println();
    }

    private static void printASTNode(AST t, int indent) {
        AST next;
        String s;
        AST child1 = t.getFirstChild();
        System.out.println();
        for (int i = 0; i < indent; ++i) {
            System.out.print("   ");
        }
        if (child1 != null) {
            System.out.print('(');
        }
        if ((s = t.getText()) != null && !s.isEmpty()) {
            System.out.print(TNode.getNameForType(t.getType()));
            System.out.print(": \"" + s + "\"");
        } else {
            System.out.print(TNode.getNameForType(t.getType()));
        }
        if (((TNode)t).getLineNum() != 0) {
            System.out.print(" line:" + ((TNode)t).getLineNum());
        }
        Enumeration keys = ((TNode)t).getAttributesTable().keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            System.out.print(" " + key + ":" + ((TNode)t).getAttribute(key));
        }
        TNode def = ((TNode)t).getDefNode();
        if (def != null) {
            System.out.print("[" + TNode.getNameForType(def.getType()) + "]");
        }
        if (child1 != null) {
            TNode.printASTNode(child1, indent + 1);
            System.out.println();
            for (int i = 0; i < indent; ++i) {
                System.out.print("   ");
            }
            System.out.print(')');
        }
        if ((next = t.getNextSibling()) != null) {
            TNode.printASTNode(next, indent);
        }
    }

    public static String getNameForType(int t) {
        try {
            Class<?> c = Class.forName(tokenVocabulary);
            Field[] fields = c.getDeclaredFields();
            if (t - 2 < fields.length) {
                return fields[t - 2].getName();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return "unfoundtype: " + t;
    }

    @Override
    public void initialize(Token token) {
        CToken tok = (CToken)token;
        this.setText(tok.getText());
        this.setType(tok.getType());
        this.setLineNum(tok.getLine());
        this.setAttribute("source", tok.getSource());
        this.setAttribute("tokenNumber", tok.getTokenNumber());
        this.setAttribute("firstToken", tok.getTokenNumber());
        this.setAttribute("lastToken", tok.getTokenNumber());
    }

    @Override
    public void initialize(AST tr) {
        TNode t = (TNode)tr;
        this.setText(t.getText());
        this.setType(t.getType());
        this.setLineNum(t.getLineNum());
        this.setDefNode(t.getDefNode());
        this.attributes = t.getAttributesTable();
    }

    @Override
    public int getType() {
        return this.ttype;
    }

    @Override
    public void setType(int ttype_) {
        this.ttype = ttype_;
    }

    public boolean getMarker() {
        return this.marker;
    }

    public void setMarker(boolean marker_) {
        this.marker = marker_;
    }

    private Hashtable getAttributesTable() {
        if (this.attributes == null) {
            this.attributes = new Hashtable(7);
        }
        return this.attributes;
    }

    public void setAttribute(String attrName, Object value) {
        if (this.attributes == null) {
            this.attributes = new Hashtable(7);
        }
        this.attributes.put(attrName, value);
    }

    public Object getAttribute(String attrName) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(attrName);
    }

    private int getLineNum() {
        if (this.lineNum != 0) {
            return this.lineNum;
        }
        if (this.down == null) {
            return this.lineNum;
        }
        return ((TNode)this.down).getLocalLineNum();
    }

    private void setLineNum(int lineNum_) {
        this.lineNum = lineNum_;
    }

    private int getLocalLineNum() {
        if (this.lineNum != 0) {
            return this.lineNum;
        }
        if (this.down == null) {
            if (this.right == null) {
                return this.lineNum;
            }
            return ((TNode)this.right).getLocalLineNum();
        }
        return ((TNode)this.down).getLocalLineNum();
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text_) {
        this.text = text_;
    }

    public TNode getLastChild() {
        TNode down = (TNode)this.getFirstChild();
        if (down != null) {
            return down.getLastSibling();
        }
        return null;
    }

    private TNode getLastSibling() {
        TNode next = (TNode)this.getNextSibling();
        if (next != null) {
            return next.getLastSibling();
        }
        return this;
    }

    private TNode getFirstSibling() {
        TNode prev = this.left;
        if (prev != null) {
            return prev.getFirstSibling();
        }
        return this;
    }

    public TNode getParent() {
        return this.getFirstSibling().up;
    }

    public void addSibling(AST node) {
        if (node == null) {
            return;
        }
        TNode next = (TNode)this.right;
        this.right = (TNode)node;
        ((TNode)node).left = this;
        TNode nodeLastSib = ((TNode)node).getLastSibling();
        nodeLastSib.right = next;
        if (next != null) {
            next.left = nodeLastSib;
        }
    }

    public int numberOfChildren() {
        int count = 0;
        for (AST child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            ++count;
        }
        return count;
    }

    private void setFirstTokenNumber(TNode c) {
        if (c.getAttribute("firstToken") != null) {
            if (this.getAttribute("firstToken") != null) {
                Integer min = (Integer)this.getAttribute("firstToken") < (Integer)c.getAttribute("firstToken") ? (Integer)this.getAttribute("firstToken") : (Integer)c.getAttribute("firstToken");
                this.setAttribute("firstToken", min);
            } else if (this.getAttribute("tokenNumber") != null) {
                Integer min = (Integer)this.getAttribute("tokenNumber") < (Integer)c.getAttribute("firstToken") ? (Integer)this.getAttribute("tokenNumber") : (Integer)c.getAttribute("firstToken");
                this.setAttribute("firstToken", min);
            } else {
                this.setAttribute("firstToken", c.getAttribute("firstToken"));
            }
        } else if (c.getAttribute("tokenNumber") != null) {
            if (this.getAttribute("firstToken") != null) {
                Integer min = (Integer)this.getAttribute("firstToken") < (Integer)c.getAttribute("tokenNumber") ? (Integer)this.getAttribute("firstToken") : (Integer)c.getAttribute("tokenNumber");
                this.setAttribute("firstToken", min);
            } else if (this.getAttribute("tokenNumber") != null) {
                Integer min = (Integer)this.getAttribute("tokenNumber") < (Integer)c.getAttribute("tokenNumber") ? (Integer)this.getAttribute("tokenNumber") : (Integer)c.getAttribute("tokenNumber");
                this.setAttribute("firstToken", min);
            } else {
                this.setAttribute("firstToken", c.getAttribute("tokenNumber"));
            }
        }
    }

    private void setLastTokenNumber(TNode c) {
        if (c.getAttribute("lastToken") != null) {
            if (this.getAttribute("lastToken") != null) {
                Integer max = (Integer)this.getAttribute("lastToken") > (Integer)c.getAttribute("lastToken") ? (Integer)this.getAttribute("lastToken") : (Integer)c.getAttribute("lastToken");
                this.setAttribute("lastToken", max);
            } else if (this.getAttribute("tokenNumber") != null) {
                Integer max = (Integer)this.getAttribute("tokenNumber") > (Integer)c.getAttribute("lastToken") ? (Integer)this.getAttribute("tokenNumber") : (Integer)c.getAttribute("lastToken");
                this.setAttribute("lastToken", max);
            } else {
                this.setAttribute("lastToken", c.getAttribute("lastToken"));
            }
        } else if (c.getAttribute("tokenNumber") != null) {
            if (this.getAttribute("lastToken") != null) {
                Integer max = (Integer)this.getAttribute("lastToken") > (Integer)c.getAttribute("tokenNumber") ? (Integer)this.getAttribute("lastToken") : (Integer)c.getAttribute("tokenNumber");
                this.setAttribute("lastToken", max);
            } else if (this.getAttribute("tokenNumber") != null) {
                Integer max = (Integer)this.getAttribute("tokenNumber") > (Integer)c.getAttribute("tokenNumber") ? (Integer)this.getAttribute("tokenNumber") : (Integer)c.getAttribute("tokenNumber");
                this.setAttribute("lastToken", max);
            } else {
                this.setAttribute("lastToken", c.getAttribute("tokenNumber"));
            }
        }
    }

    private void setTokenNumbers(TNode c) {
        this.setFirstTokenNumber(c);
        this.setLastTokenNumber(c);
    }

    @Override
    public void setFirstChild(AST c) {
        super.setFirstChild(c);
        this.left = null;
        if (c != null) {
            ((TNode)c).up = this;
            this.setTokenNumbers((TNode)c);
            if (((TNode)c).getAttribute("source") != null) {
                this.setAttribute("source", ((TNode)c).getAttribute("source"));
            }
            for (TNode n = (TNode)c.getNextSibling(); n != null; n = (TNode)n.getNextSibling()) {
                this.setTokenNumbers(n);
                if (n.getAttribute("source") == null) continue;
                this.setAttribute("source", n.getAttribute("source"));
            }
        }
    }

    @Override
    public void setNextSibling(AST n) {
        super.setNextSibling(n);
        if (n != null) {
            ((TNode)n).left = this;
            TNode parent = this.getParent();
            if (parent != null) {
                parent.setTokenNumbers((TNode)n);
                if (((TNode)n).getAttribute("source") != null) {
                    parent.setAttribute("source", ((TNode)n).getAttribute("source"));
                }
                for (TNode c = (TNode)n.getNextSibling(); c != null; c = (TNode)c.getNextSibling()) {
                    parent.setTokenNumbers(c);
                    if (c.getAttribute("source") == null) continue;
                    parent.setAttribute("source", c.getAttribute("source"));
                }
            }
        }
    }

    @Override
    public void addChild(AST node) {
        if (node == null) {
            return;
        }
        TNode t = (TNode)this.down;
        if (t != null) {
            while (t.right != null) {
                t = (TNode)t.right;
            }
            t.right = (BaseAST)node;
            ((TNode)node).left = t;
        } else {
            this.down = (BaseAST)node;
            ((TNode)node).up = this;
        }
        this.setTokenNumbers((TNode)node);
    }

    public void removeSelf() {
        TNode parent = this.up;
        TNode prev = this.left;
        TNode next = (TNode)this.right;
        if (parent != null) {
            parent.down = next;
            if (next != null) {
                next.up = parent;
                next.left = prev;
            }
        } else {
            if (prev != null) {
                prev.right = next;
            }
            if (next != null) {
                next.left = prev;
            }
        }
    }

    private TNode getDefNode() {
        return this.defNode;
    }

    private void setDefNode(TNode n) {
        this.defNode = n;
    }

    public TNode deepCopy() {
        TNode copy = new TNode();
        copy.ttype = this.ttype;
        copy.text = this.text;
        copy.lineNum = this.lineNum;
        copy.defNode = this.defNode;
        if (this.attributes != null) {
            copy.attributes = (Hashtable)this.attributes.clone();
        }
        if (this.down != null) {
            copy.down = ((TNode)this.down).deepCopyWithRightSiblings();
        }
        copy.doubleLink();
        return copy;
    }

    private TNode deepCopyWithRightSiblings() {
        TNode copy = new TNode();
        copy.ttype = this.ttype;
        copy.text = this.text;
        copy.lineNum = this.lineNum;
        copy.defNode = this.defNode;
        if (this.attributes != null) {
            copy.attributes = (Hashtable)this.attributes.clone();
        }
        if (this.down != null) {
            copy.down = ((TNode)this.down).deepCopyWithRightSiblings();
        }
        if (this.right != null) {
            copy.right = ((TNode)this.right).deepCopyWithRightSiblings();
        }
        copy.doubleLink();
        return copy;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder(TNode.getNameForType(this.getType()) + "[" + this.getText() + ", ]");
        if (this.getLineNum() != 0) {
            str.append(" line:").append(this.getLineNum());
        }
        Enumeration keys = this.getAttributesTable().keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            str.append(" ").append(key).append(":").append(this.getAttribute(key));
        }
        return str.toString();
    }

    private void doubleLink() {
        TNode down;
        TNode right = (TNode)this.getNextSibling();
        if (right != null) {
            right.left = this;
            right.doubleLink();
        }
        if ((down = (TNode)this.getFirstChild()) != null) {
            down.up = this;
            down.doubleLink();
        }
    }

    private TNode parentOfType(int type) {
        if (this.up == null) {
            if (this.left == null) {
                return null;
            }
            return this.left.parentOfType(type);
        }
        if (this.up.getType() == type) {
            return this.up;
        }
        return this.up.parentOfType(type);
    }

    public TNode firstChildOfType(int type) {
        TNode down = (TNode)this.getFirstChild();
        if (down == null) {
            return null;
        }
        if (down.getType() == type) {
            return down;
        }
        return down.firstSiblingOfType(type);
    }

    public TNode firstSiblingOfType(int type) {
        TNode right = (TNode)this.getNextSibling();
        if (right == null) {
            return null;
        }
        if (right.getType() == type) {
            return right;
        }
        return right.firstSiblingOfType(type);
    }
}

