/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.analysis;

import fr.inria.tapenade.analysis.DataFlowAnalyzer;
import fr.inria.tapenade.analysis.DiffLivenessAnalyzer;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.BlockStorage;
import fr.inria.tapenade.representation.DiffPattern;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.utils.BoolMatrix;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.Tree;

public final class ActivityPattern {
    private Unit unit;
    private DiffPattern diffP;
    private TapList<ActivityPattern> callingPatterns;
    private BoolVector callActivity;
    private BoolVector exitActivity;
    private BoolVector callUsefulness;
    private BoolVector exitUsefulness;
    private TapTriplet<Unit, BoolVector, BoolVector>[] varFunctionADActivities;
    private BoolVector zonesOfVarsHaveDiff;
    private BoolVector zonesMPIiReceived;
    private int zonesMPIiReceivedLength;
    private boolean generalizable;
    private BlockStorage<TapList<BoolVector>> activities;
    private BlockStorage<TapList<BoolVector>> usefulnesses;
    private BlockStorage<TapList<BoolVector>> reqXs;
    private BlockStorage<TapList<BoolVector>> avlXs;
    private BoolVector entryReqX;
    private BoolVector exitReqX;
    private BoolVector entryAvlX;
    private BoolVector exitAvlX;
    private BoolMatrix reqXEffects;
    private BoolVector reqXEffectsAdded;
    private BoolVector avlXEffectsVisible;
    private BoolVector avlXEffectsAdded;
    private BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> diffLivenesses;
    private BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> diffLivenessesCkp;
    private BoolVector exitDiffLivenesses;
    private BoolVector exitDiffLivenessesOnDiffPtr;
    private BoolVector entryDiffLivenessesCkp;
    private BoolVector entryDiffLivenessesCkpOnDiffPtr;
    private BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> diffOverwrites;
    private BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> diffOverwritesCkp;
    private BoolVector exitDiffOverwrites;
    private BoolVector exitDiffOverwritesOnDiffPtr;
    private BoolVector entryDiffOverwritesCkp;
    private BoolVector entryDiffOverwritesCkpOnDiffPtr;
    private BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> tbrs;
    private BoolVector localTBR;
    private BoolVector localTBROnDiffPtr;
    private BlockStorage<TapList<TapList<Instruction>>> recomps;
    private BoolVector adTBRTopDownContext;
    private BoolVector adTBRTopDownContextOnDiffPtr;
    private BlockStorage<boolean[]> mayBeRecomputed;
    private BlockStorage<boolean[]> butRemainsInFwdSweep;
    private boolean isForcedActive;
    private boolean dontDiff;
    private boolean isContext;
    private DiffLivenessAnalyzer.Context diffLivenessTopDownContext;
    private BoolVector usefulOnExit;
    private BoolVector variedOnCall;

    public ActivityPattern(Unit unit, boolean generalizable, boolean forceActive, int diffKind) {
        this.unit = unit;
        this.generalizable = generalizable;
        this.isForcedActive = forceActive;
        this.initTypes(diffKind);
    }

    public ActivityPattern(Unit unit, DiffPattern diffP, BoolVector variedOnCall, BoolVector usefulOnExit, boolean generalizable, int diffKind) {
        this.unit = unit;
        this.diffP = diffP;
        this.variedOnCall = variedOnCall;
        this.usefulOnExit = usefulOnExit;
        this.generalizable = generalizable;
        this.initTypes(diffKind);
    }

    public ActivityPattern(Unit unit, ActivityPattern callingPattern, BoolVector variedOnCall, BoolVector usefulOnExit, boolean generalizable, int diffKind) {
        this.unit = unit;
        this.variedOnCall = variedOnCall;
        this.usefulOnExit = usefulOnExit;
        this.generalizable = generalizable;
        this.callingPatterns = new TapList<ActivityPattern>(callingPattern, null);
        this.initTypes(diffKind);
    }

    public static void walkUpToPatternOf(ActivityPattern pattern, Unit unit, TapList<ActivityPattern> collected, TapList<ActivityPattern> dejaVu) {
        if (!TapList.contains(dejaVu.tail, pattern)) {
            dejaVu.placdl(pattern);
            if (pattern.unit == unit) {
                collected.placdl(pattern);
            } else {
                TapList<ActivityPattern> inCallingPatterns = pattern.callingPatterns;
                while (inCallingPatterns != null) {
                    ActivityPattern.walkUpToPatternOf((ActivityPattern)inCallingPatterns.head, unit, collected, dejaVu);
                    inCallingPatterns = inCallingPatterns.tail;
                }
            }
        }
    }

    public static void setAnnotationForActivityPattern(Tree tree, ActivityPattern pattern, String name, Object val) {
        TapPair<ActivityPattern, Object> patternPair;
        TapPair<String, Object> annotPair = tree.getAnnotationPair(name);
        if (annotPair == null) {
            annotPair = tree.setAnnotation(name, null);
        }
        if ((patternPair = TapList.assq(pattern, (TapList)annotPair.second)) == null) {
            patternPair = new TapPair<ActivityPattern, Object>(pattern, null);
            annotPair.second = new TapList(patternPair, (TapList)annotPair.second);
        }
        patternPair.second = val;
    }

    public static void removeAnnotationForActivityPattern(Tree tree, ActivityPattern pattern, String name) {
        TapPair annotPair = tree.getAnnotationPair(name);
        if (annotPair != null) {
            TapList<Object> toPatternAList;
            TapList<Object> inPatternAList = toPatternAList = new TapList<Object>(null, (TapList)annotPair.second);
            while (inPatternAList.tail != null) {
                if (((TapPair)inPatternAList.tail.head).second == pattern) {
                    inPatternAList.tail = inPatternAList.tail.tail;
                    continue;
                }
                inPatternAList = inPatternAList.tail;
            }
            annotPair.second = toPatternAList.tail;
        }
    }

    public static Object getAnnotationForActivityPattern(Tree tree, ActivityPattern pattern, String name) {
        TapPair annotPair = tree.getAnnotationPair(name);
        if (annotPair != null) {
            return TapList.cassq(pattern, (TapList)annotPair.second);
        }
        return null;
    }

    public static void setInstructionBoolInfo(BlockStorage<boolean[]> info, Instruction instruction, boolean value) {
        Block block = instruction.block;
        if (block.rank >= 0) {
            boolean[] boolArray = info.retrieve(block);
            int rank = block.instructions.rank(instruction);
            boolArray[rank] = value;
        }
    }

    public static boolean getInstructionBoolInfo(BlockStorage<boolean[]> info, Instruction instruction) {
        Block block = instruction.block;
        if (block.rank < 0) {
            return false;
        }
        boolean[] boolArray = info.retrieve(block);
        int rank = block.instructions.rank(instruction);
        return boolArray[rank];
    }

    public Unit unit() {
        return this.unit;
    }

    public DiffPattern diffP() {
        return this.diffP;
    }

    public TapList<ActivityPattern> callingPatterns() {
        return this.callingPatterns;
    }

    public BoolVector callActivity() {
        return this.callActivity;
    }

    public void setCallActivity(BoolVector callActivity) {
        this.callActivity = callActivity;
    }

    public BoolVector exitActivity() {
        return this.exitActivity;
    }

    public void setExitActivity(BoolVector exitActivity) {
        this.exitActivity = exitActivity;
    }

    public BoolVector callUsefulness() {
        return this.callUsefulness;
    }

    public void setCallUsefulness(BoolVector callUsefulness) {
        this.callUsefulness = callUsefulness;
    }

    public BoolVector exitUsefulness() {
        return this.exitUsefulness;
    }

    public void setExitUsefulness(BoolVector exitUsefulness) {
        this.exitUsefulness = exitUsefulness;
    }

    public TapTriplet<Unit, BoolVector, BoolVector>[] varFunctionADActivities() {
        return this.varFunctionADActivities;
    }

    public BoolVector zonesOfVarsHaveDiff() {
        return this.zonesOfVarsHaveDiff;
    }

    public BoolVector zonesMPIiReceived() {
        return this.zonesMPIiReceived;
    }

    public int zonesMPIiReceivedLength() {
        return this.zonesMPIiReceivedLength;
    }

    public boolean isGeneralizable() {
        return this.generalizable;
    }

    public BlockStorage<TapList<BoolVector>> activities() {
        return this.activities;
    }

    public void setActivities(BlockStorage<TapList<BoolVector>> activities) {
        this.activities = activities;
    }

    public BlockStorage<TapList<BoolVector>> usefulnesses() {
        return this.usefulnesses;
    }

    public void setUsefulnesses(BlockStorage<TapList<BoolVector>> usefulnesses) {
        this.usefulnesses = usefulnesses;
    }

    public BlockStorage<TapList<BoolVector>> reqXs() {
        return this.reqXs;
    }

    public void setReqXs(BlockStorage<TapList<BoolVector>> reqXs) {
        this.reqXs = reqXs;
    }

    public BlockStorage<TapList<BoolVector>> avlXs() {
        return this.avlXs;
    }

    public void setAvlXs(BlockStorage<TapList<BoolVector>> avlXs) {
        this.avlXs = avlXs;
    }

    public BoolVector entryReqX() {
        return this.entryReqX;
    }

    public void setEntryReqX(BoolVector entryReqX) {
        this.entryReqX = entryReqX;
    }

    public BoolVector exitReqX() {
        return this.exitReqX;
    }

    public void setExitReqX(BoolVector exitReqX) {
        this.exitReqX = exitReqX;
    }

    public BoolVector entryAvlX() {
        return this.entryAvlX;
    }

    public void setEntryAvlX(BoolVector entryAvlX) {
        this.entryAvlX = entryAvlX;
    }

    public BoolVector exitAvlX() {
        return this.exitAvlX;
    }

    public void setExitAvlX(BoolVector exitAvlX) {
        this.exitAvlX = exitAvlX;
    }

    public BoolMatrix reqXEffects() {
        return this.reqXEffects;
    }

    public void setReqXEffects(BoolMatrix reqXEffects) {
        this.reqXEffects = reqXEffects;
    }

    public BoolVector reqXEffectsAdded() {
        return this.reqXEffectsAdded;
    }

    public void setReqXEffectsAdded(BoolVector reqXEffectsAdded) {
        this.reqXEffectsAdded = reqXEffectsAdded;
    }

    public BoolVector avlXEffectsVisible() {
        return this.avlXEffectsVisible;
    }

    public void setAvlXEffectsVisible(BoolVector avlXEffectsVisible) {
        this.avlXEffectsVisible = avlXEffectsVisible;
    }

    public BoolVector avlXEffectsAdded() {
        return this.avlXEffectsAdded;
    }

    public void setAvlXEffectsAdded(BoolVector avlXEffectsAdded) {
        this.avlXEffectsAdded = avlXEffectsAdded;
    }

    public BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> diffLivenesses() {
        return this.diffLivenesses;
    }

    public void setDiffLivenesses(BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> diffLivenesses) {
        this.diffLivenesses = diffLivenesses;
    }

    public BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> diffLivenessesCkp() {
        return this.diffLivenessesCkp;
    }

    public void setDiffLivenessesCkp(BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> diffLivenessesCkp) {
        this.diffLivenessesCkp = diffLivenessesCkp;
    }

    public BoolVector exitDiffLivenesses() {
        return this.exitDiffLivenesses;
    }

    public void setExitDiffLivenesses(BoolVector exitDiffLivenesses) {
        this.exitDiffLivenesses = exitDiffLivenesses;
    }

    public BoolVector exitDiffLivenessesOnDiffPtr() {
        return this.exitDiffLivenessesOnDiffPtr;
    }

    public void setExitDiffLivenessesOnDiffPtr(BoolVector exitDiffLivenessesOnDiffPtr) {
        this.exitDiffLivenessesOnDiffPtr = exitDiffLivenessesOnDiffPtr;
    }

    public BoolVector entryDiffLivenessesCkp() {
        return this.entryDiffLivenessesCkp;
    }

    public void setEntryDiffLivenessesCkp(BoolVector entryDiffLivenessesCkp) {
        this.entryDiffLivenessesCkp = entryDiffLivenessesCkp;
    }

    public BoolVector entryDiffLivenessesCkpOnDiffPtr() {
        return this.entryDiffLivenessesCkpOnDiffPtr;
    }

    public void setEntryDiffLivenessesCkpOnDiffPtr(BoolVector entryDiffLivenessesCkpOnDiffPtr) {
        this.entryDiffLivenessesCkpOnDiffPtr = entryDiffLivenessesCkpOnDiffPtr;
    }

    public BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> diffOverwrites() {
        return this.diffOverwrites;
    }

    public void setDiffOverwrites(BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> diffOverwrites) {
        this.diffOverwrites = diffOverwrites;
    }

    public BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> diffOverwritesCkp() {
        return this.diffOverwritesCkp;
    }

    public void setDiffOverwritesCkp(BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> diffOverwritesCkp) {
        this.diffOverwritesCkp = diffOverwritesCkp;
    }

    public BoolVector exitDiffOverwrites() {
        return this.exitDiffOverwrites;
    }

    public void setExitDiffOverwrites(BoolVector exitDiffOverwrites) {
        this.exitDiffOverwrites = exitDiffOverwrites;
    }

    public BoolVector exitDiffOverwritesOnDiffPtr() {
        return this.exitDiffOverwritesOnDiffPtr;
    }

    public void setExitDiffOverwritesOnDiffPtr(BoolVector exitDiffOverwritesOnDiffPtr) {
        this.exitDiffOverwritesOnDiffPtr = exitDiffOverwritesOnDiffPtr;
    }

    public BoolVector entryDiffOverwritesCkp() {
        return this.entryDiffOverwritesCkp;
    }

    public void setEntryDiffOverwritesCkp(BoolVector entryDiffOverwritesCkp) {
        this.entryDiffOverwritesCkp = entryDiffOverwritesCkp;
    }

    public BoolVector entryDiffOverwritesCkpOnDiffPtr() {
        return this.entryDiffOverwritesCkpOnDiffPtr;
    }

    public void setEntryDiffOverwritesCkpOnDiffPtr(BoolVector entryDiffOverwritesCkpOnDiffPtr) {
        this.entryDiffOverwritesCkpOnDiffPtr = entryDiffOverwritesCkpOnDiffPtr;
    }

    public BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> tbrs() {
        return this.tbrs;
    }

    public void setTbrs(BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> tbrs) {
        this.tbrs = tbrs;
    }

    public BoolVector localTBR() {
        return this.localTBR;
    }

    public void setLocalTBR(BoolVector localTBR) {
        this.localTBR = localTBR;
    }

    public BoolVector localTBROnDiffPtr() {
        return this.localTBROnDiffPtr;
    }

    public void setLocalTBROnDiffPtr(BoolVector localTBROnDiffPtr) {
        this.localTBROnDiffPtr = localTBROnDiffPtr;
    }

    public BlockStorage<TapList<TapList<Instruction>>> recomps() {
        return this.recomps;
    }

    public void setRecomps(BlockStorage<TapList<TapList<Instruction>>> recomps) {
        this.recomps = recomps;
    }

    public BoolVector adTBRTopDownContext() {
        return this.adTBRTopDownContext;
    }

    public void setAdTBRTopDownContext(BoolVector adTBRTopDownContext) {
        this.adTBRTopDownContext = adTBRTopDownContext;
    }

    public BoolVector adTBRTopDownContextOnDiffPtr() {
        return this.adTBRTopDownContextOnDiffPtr;
    }

    public void setAdTBRTopDownContextOnDiffPtr(BoolVector adTBRTopDownContextOnDiffPtr) {
        this.adTBRTopDownContextOnDiffPtr = adTBRTopDownContextOnDiffPtr;
    }

    public BlockStorage<boolean[]> mayBeRecomputed() {
        return this.mayBeRecomputed;
    }

    public BlockStorage<boolean[]> butRemainsInFwdSweep() {
        return this.butRemainsInFwdSweep;
    }

    public boolean isForcedActive() {
        return this.isForcedActive;
    }

    public void setForcedActive(boolean forcedActive) {
        this.isForcedActive = forcedActive;
    }

    public boolean isDontDiff() {
        return this.dontDiff;
    }

    public void setDontDiff(boolean dontDiff) {
        this.dontDiff = dontDiff;
    }

    public boolean isContext() {
        return this.isContext;
    }

    public void setContext(boolean context) {
        this.isContext = context;
    }

    public DiffLivenessAnalyzer.Context diffLivenessTopDownContext() {
        return this.diffLivenessTopDownContext;
    }

    public void setDiffLivenessTopDownContext(DiffLivenessAnalyzer.Context diffLivenessTopDownContext) {
        this.diffLivenessTopDownContext = diffLivenessTopDownContext;
    }

    public BoolVector variedOnCall() {
        return this.variedOnCall;
    }

    public BoolVector usefulOnExit() {
        return this.usefulOnExit;
    }

    private void initTypes(int diffKind) {
        if (this.unit != null && this.unit.hasParamElemsInfo()) {
            int shapeLength = this.unit.paramElemsNb();
            this.callActivity = new BoolVector(shapeLength);
            this.exitActivity = new BoolVector(shapeLength);
            if (this.unit.privateSymbolTable() != null) {
                int[] diffMap = DataFlowAnalyzer.makeMap3(this.unit.sideEffectZonesNb(diffKind), 0, this.unit.privateSymbolTable() == null ? 0 : this.unit.privateSymbolTable().declaredZonesNb(diffKind));
                this.zonesOfVarsHaveDiff = new BoolVector(DataFlowAnalyzer.mapSize(diffMap));
                this.zonesMPIiReceived = new BoolVector(DataFlowAnalyzer.mapSize(diffMap));
                this.zonesMPIiReceivedLength = DataFlowAnalyzer.mapSize(diffMap);
            }
            int nbArgs = this.unit.formalArgumentsNb();
            this.varFunctionADActivities = new TapTriplet[nbArgs];
            for (int i = nbArgs - 1; i >= 0; --i) {
                this.varFunctionADActivities[i] = null;
            }
        }
    }

    public void registerCallingActivityPattern(ActivityPattern callingPattern) {
        if (!TapList.contains(this.callingPatterns, callingPattern)) {
            this.callingPatterns = new TapList<ActivityPattern>(callingPattern, this.callingPatterns);
        }
    }

    public boolean isCalledBy(Unit caller, ActivityPattern callerActivityPattern, TapList<ActivityPattern> dejaVu) {
        TapList<ActivityPattern> inCallingPatterns = this.callingPatterns;
        boolean called = false;
        while (!called && inCallingPatterns != null) {
            ActivityPattern callingPattern = (ActivityPattern)inCallingPatterns.head;
            if (callingPattern != null && !TapList.contains(dejaVu, callingPattern)) {
                called = callingPattern == callerActivityPattern && callingPattern.unit == caller || callingPattern.isCalledBy(caller, callerActivityPattern, new TapList<ActivityPattern>(callingPattern, dejaVu));
            }
            inCallingPatterns = inCallingPatterns.tail;
        }
        return called;
    }

    public ActivityPattern getCallingActivityPattern(Unit caller, TapList<ActivityPattern> dejaVu) {
        TapList<ActivityPattern> inCallingPatterns = this.callingPatterns;
        ActivityPattern found = null;
        while (found == null && inCallingPatterns != null) {
            ActivityPattern callingPattern = (ActivityPattern)inCallingPatterns.head;
            if (callingPattern != null && !TapList.contains(dejaVu, callingPattern)) {
                found = callingPattern.unit == caller ? callingPattern : callingPattern.getCallingActivityPattern(caller, new TapList<ActivityPattern>(callingPattern, dejaVu));
            }
            inCallingPatterns = inCallingPatterns.tail;
        }
        return found;
    }

    public void initializeMayBeRecomputed() {
        this.mayBeRecomputed = new BlockStorage(this.unit);
        TapList<Block> blocks = this.unit.allBlocks();
        while (blocks != null) {
            Block block = (Block)blocks.head;
            boolean[] boolArray = new boolean[TapList.length(block.instructions)];
            for (int i = boolArray.length - 1; i >= 0; --i) {
                boolArray[i] = false;
            }
            this.mayBeRecomputed.store(block, boolArray);
            blocks = blocks.tail;
        }
    }

    public void initializeButRemainsInFwdSweep() {
        this.butRemainsInFwdSweep = new BlockStorage(this.unit);
        TapList<Block> blocks = this.unit.allBlocks();
        while (blocks != null) {
            Block block = (Block)blocks.head;
            boolean[] boolArray = new boolean[TapList.length(block.instructions)];
            for (int i = boolArray.length - 1; i >= 0; --i) {
                boolArray[i] = false;
            }
            this.butRemainsInFwdSweep.store(block, boolArray);
            blocks = blocks.tail;
        }
    }

    public boolean isDisconnected() {
        return this.diffP == null && this.callingPatterns == null;
    }

    public boolean isActive() {
        if (this.isForcedActive) {
            return true;
        }
        int shapeLength = this.unit.paramElemsNb();
        return this.callActivity != null && this.exitActivity != null && !this.callActivity.isFalse(shapeLength) && !this.exitActivity.isFalse(shapeLength) || TapEnv.reqExplicitAnalyzer() != null && TapEnv.reqExplicitAnalyzer().isPointerActiveUnit(this);
    }

    public String toString() {
        String result = "AP@" + Integer.toHexString(this.hashCode()) + " {";
        if (this.callingPatterns != null) {
            result = result + "called, ";
        }
        if (this.diffP != null) {
            result = result + "diffRoot, ";
        }
        if (this.isContext) {
            result = result + "context, ";
        }
        if (this.diffP == null && this.callingPatterns == null) {
            result = result + "not connected, ";
        }
        if (this.isForcedActive) {
            result = result + "forcedActive, ";
        }
        if (this.dontDiff) {
            result = result + "but don't diff, ";
        }
        return result + "on " + this.unit + "}";
    }
}

