/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.analysis;

import fr.inria.tapenade.analysis.DataFlowAnalyzer;
import fr.inria.tapenade.analysis.InOutAnalyzer;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.BlockStorage;
import fr.inria.tapenade.representation.CallArrow;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.HeaderBlock;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.BoolMatrix;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.Tree;

public final class DepsAnalyzer
extends DataFlowAnalyzer {
    private BlockStorage<BoolMatrix> depsIn;
    private BlockStorage<BoolMatrix> depsOut;
    private BlockStorage<BoolMatrix> depsThrough;
    private BoolMatrix tmpDep;
    private int nUDZ = -9;
    private final int[] curBlockMap = DepsAnalyzer.makeMap3(-9, 0, 0);
    private final int[] entryMap = DepsAnalyzer.makeMap3(-9, 0, 0);

    private DepsAnalyzer(CallGraph cg) {
        super(cg, "Plain dependency analysis", TapEnv.traceDeps());
    }

    public static void runAnalysis(CallGraph callGraph, TapList<Unit> rootUnits) {
        TapEnv.setDepsAnalyzer(new DepsAnalyzer(callGraph));
        TapEnv.depsAnalyzer().run(rootUnits);
    }

    private static BoolMatrix buildDefaultExternalDependencies(Unit calledUnit) {
        boolean maybeDiffAndModified;
        int i;
        BoolVector unitN = calledUnit.unitInOutN();
        BoolVector unitR = calledUnit.unitInOutPossiblyR();
        BoolVector unitW = calledUnit.unitInOutPossiblyW();
        if (!calledUnit.hasParamElemsInfo()) {
            return null;
        }
        int n = calledUnit.paramElemsNb();
        BoolMatrix result = new BoolMatrix(n, n);
        result.setIdentity();
        BoolVector depLine = new BoolVector(n);
        int returnIndex = -1;
        for (i = 0; i < n; ++i) {
            if (calledUnit.paramElemZoneInfo(i) == null || !calledUnit.paramElemZoneInfo(i).isResult()) continue;
            returnIndex = i;
        }
        for (i = 0; i < n; ++i) {
            maybeDiffAndModified = calledUnit.paramElemZoneInfo(i) != null ? calledUnit.paramElemZoneInfo((int)i).zoneNb != -1 : false;
            if (!maybeDiffAndModified || i == returnIndex || !unitR.get(i)) continue;
            depLine.set(i, true);
        }
        for (i = 0; i < n; ++i) {
            maybeDiffAndModified = calledUnit.paramElemZoneInfo(i) != null ? calledUnit.paramElemZoneInfo((int)i).zoneNb != -1 : false;
            if (!maybeDiffAndModified || !unitW.get(i)) continue;
            BoolVector depLineCopy = depLine.copy();
            if (i != returnIndex && unitN.get(i)) {
                depLineCopy.set(i, true);
            }
            result.setRow(i, depLineCopy);
        }
        return result;
    }

    protected static BoolMatrix buildDefaultIntrinsicDependencies(Unit calledUnit) {
        BoolMatrix result;
        BoolVector unitR = calledUnit.unitInOutPossiblyR();
        if (calledUnit.hasParamElemsInfo()) {
            int i;
            int n = calledUnit.paramElemsNb();
            result = new BoolMatrix(n, n);
            result.setIdentity();
            BoolVector depLine = new BoolVector(n);
            int returnIndex = -1;
            for (i = 0; i < n; ++i) {
                if (!calledUnit.paramElemZoneInfo(i).isResult()) continue;
                returnIndex = i;
            }
            for (i = 0; i < n; ++i) {
                boolean isInDep;
                boolean bl = isInDep = calledUnit.paramElemZoneInfo((int)i).zoneNb != -1;
                if (!isInDep || i == returnIndex || !unitR.get(i)) continue;
                depLine.set(i, true);
            }
            if (returnIndex != -1) {
                result.setRow(returnIndex, depLine);
            }
        } else {
            result = new BoolMatrix(0, 0);
        }
        return result;
    }

    @Override
    public void setCurUnitEtc(Unit unit) {
        super.setCurUnitEtc(unit);
        if (unit == null || unit.publicSymbolTable() == null) {
            this.nUDZ = -9;
            this.curBlockMap[1] = -9;
            this.curBlockMap[2] = -9;
            this.curBlockMap[3] = -9;
            this.entryMap[1] = -9;
            this.entryMap[2] = -9;
            this.entryMap[3] = -9;
        } else {
            this.nUDZ = unit.publicSymbolTable().declaredZonesNb(0);
            this.curBlockMap[1] = this.nSEZ;
            this.curBlockMap[2] = this.nSEZ + this.nTZ;
            this.curBlockMap[3] = -9;
            this.entryMap[1] = this.nSEZ;
            this.entryMap[2] = this.nSEZ + this.nTZ;
            this.entryMap[3] = this.nSEZ + this.nTZ + this.nUDZ;
        }
    }

    @Override
    protected Object initializeCGForUnit() {
        if (this.curUnit.isExternal() || this.curUnit.isVarFunction() || this.curUnit.isInterface() || this.curUnit.isRenamed() || this.curUnit.isModule()) {
            if (this.curUnit.unitDependencies == null) {
                this.curUnit.unitDependencies = DepsAnalyzer.buildDefaultExternalDependencies(this.curUnit);
            }
        } else if (this.curUnit.isIntrinsic()) {
            if (this.curUnit.unitDependencies == null) {
                this.curUnit.unitDependencies = DepsAnalyzer.buildDefaultIntrinsicDependencies(this.curUnit);
            }
        } else {
            this.curUnit.unitDependencies = null;
        }
        return null;
    }

    @Override
    protected void initializeUnit() {
        this.depsIn = new BlockStorage(this.curUnit);
        this.depsOut = new BlockStorage(this.curUnit);
        this.depsThrough = new BlockStorage(this.curUnit);
        if (this.traceCurAnalysis) {
            ZoneInfo zi;
            int i;
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace(" =============  PLAIN DEPS ANALYSIS ON UNIT " + this.curUnit.name + " : ============");
            this.curSymbolTable = this.curUnit.privateSymbolTable();
            if (this.curSymbolTable == null) {
                this.curSymbolTable = this.curUnit.publicSymbolTable();
            }
            this.nDZ = this.curSymbolTable.declaredZonesNb(0);
            if (this.nSEZ > 0) {
                TapEnv.printOnTrace(" SE:");
            }
            for (i = 0; i < this.nSEZ; ++i) {
                zi = this.zoneRkToZoneInfo(i, 1, 0);
                if (zi == null) continue;
                TapEnv.printOnTrace(" [" + i + "]" + zi.accessTreePrint(this.curUnit.language()));
            }
            if (this.nTZ > 0) {
                TapEnv.printOnTrace(" T: " + this.nSEZ + "->" + (this.nSEZ + this.nTZ - 1));
            }
            if (this.nDZ > 0) {
                TapEnv.printOnTrace(" D:");
            }
            for (i = 0; i < this.nDZ; ++i) {
                zi = this.zoneRkToZoneInfo(i, 3, 0);
                if (zi == null) continue;
                TapEnv.printOnTrace(" [" + i + "]" + zi.accessTreePrint(this.curUnit.language()));
            }
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace();
        }
    }

    @Override
    protected void initializeInitBlock() {
        BoolMatrix initIdentity = new BoolMatrix(this.nSEZ + this.nTZ + this.nDZ, this.nSEZ + this.nTZ + this.nDZ);
        initIdentity.setIdentity();
        this.depsOut.store(this.curBlock, initIdentity);
    }

    @Override
    protected void setCurBlockEtc(Block block) {
        super.setCurBlockEtc(block);
        this.curBlockMap[3] = block == null ? -9 : this.nSEZ + this.nTZ + this.nDZ;
    }

    @Override
    protected void initializeFGForBlock() {
        BoolMatrix deps = new BoolMatrix(this.nSEZ + this.nTZ + this.nDZ, this.nSEZ + this.nTZ + this.nDZ);
        deps.setIdentity();
        TapList<Instruction> instructions = this.curBlock.instructions;
        ToBool arrives = new ToBool(true);
        while (instructions != null) {
            this.curInstruction = (Instruction)instructions.head;
            this.depsThroughExpression(deps, this.curInstruction.tree, arrives);
            instructions = instructions.tail;
        }
        if (!arrives.get()) {
            deps = null;
        }
        this.curInstruction = null;
        this.depsThrough.store(this.curBlock, deps);
        if (this.traceCurAnalysis) {
            TapEnv.printlnOnTrace(" == Plain Deps through " + this.curBlock + " is:");
            TapEnv.dumpBoolMatrixOnTrace(deps, this.curBlockMap, this.curBlockMap);
            TapEnv.printlnOnTrace();
        }
    }

    @Override
    protected boolean accumulateValuesFromUpstream() {
        this.tmpDep = this.accumulateDepIn(this.curBlock);
        return this.tmpDep != null;
    }

    @Override
    protected boolean compareUpstreamValues() {
        BoolMatrix depOld = this.depsIn.retrieve(this.curBlock);
        if (depOld == null || !this.tmpDep.equalsBoolMatrix(depOld)) {
            this.depsIn.store(this.curBlock, this.tmpDep);
            return true;
        }
        return false;
    }

    @Override
    protected boolean propagateValuesForwardThroughBlock() {
        BoolMatrix depThrough = this.depsThrough.retrieve(this.curBlock);
        if (depThrough != null) {
            this.tmpDep.rows = depThrough.times((BoolMatrix)this.tmpDep).rows;
            return true;
        }
        this.tmpDep = null;
        return false;
    }

    @Override
    protected boolean compareDownstreamValues() {
        BoolMatrix depOld = this.depsOut.retrieve(this.curBlock);
        if (depOld == null || !this.tmpDep.equalsBoolMatrix(depOld)) {
            this.depsOut.store(this.curBlock, this.tmpDep);
            return true;
        }
        return false;
    }

    @Override
    protected boolean compareChannelZoneDataDownstream(int mpZone, Block refBlock) {
        int rowIndex = this.zoneRkToVectorIndex(mpZone, 3, 0, this.curBlockMap);
        BoolMatrix refDep = this.depsOut.retrieve(refBlock);
        BoolVector refRow = refDep.getRow(rowIndex);
        BoolVector newRow = this.tmpDep.getRow(rowIndex);
        if (!(newRow == null || refRow != null && refRow.contains(newRow, this.entryMap[3]))) {
            refDep.overwriteDeps(new TapIntList(rowIndex, null), newRow, false);
            return true;
        }
        return false;
    }

    @Override
    protected boolean terminateUnit() {
        this.tmpDep = this.accumulateDepIn(this.curUnit.exitBlock);
        this.depsIn = null;
        this.depsOut = null;
        this.depsThrough = null;
        if (this.tmpDep == null) {
            return false;
        }
        if (this.traceCurAnalysis) {
            TapEnv.printlnOnTrace(" == Plain Deps entering exit Block :");
            TapEnv.dumpBoolMatrixOnTrace(this.tmpDep, this.entryMap, this.entryMap);
            TapEnv.printlnOnTrace();
        }
        BoolVector usedInDecls = new BoolVector(this.nSEZ + this.nTZ + this.nDZ);
        usedInDecls.cumulOr(this.curUnit.zonesUsedInDeclarations, 0, 0, this.nSEZ);
        usedInDecls.cumulOr(this.curUnit.zonesUsedInDeclarations, this.nSEZ, this.nSEZ + this.nTZ, this.nDZ);
        for (int i = this.tmpDep.nRows - 1; i >= 0; --i) {
            BoolVector row = this.tmpDep.getRow(i);
            if (row == null) continue;
            row.cumulOr(usedInDecls);
            this.tmpDep.setRow(i, row);
        }
        this.tmpDep.deleteColsAndRows(this.nSEZ, this.nTZ);
        BoolMatrix unitDep = this.propagateUnitDataOutside(this.tmpDep, 0);
        BoolMatrix oldUnitDep = this.curUnit.unitDependencies;
        if (oldUnitDep != null && unitDep.equalsBoolMatrix(oldUnitDep)) {
            return false;
        }
        this.curUnit.unitDependencies = unitDep;
        if (this.traceCurAnalysis) {
            TapEnv.printlnOnTrace(" == Public Plain Deps effect stored for unit " + this.curUnit.name + " is:");
            TapEnv.dumpOnTrace(unitDep);
            TapEnv.printlnOnTrace();
        }
        return true;
    }

    private TapList depsThroughExpression(BoolMatrix deps, Tree expression, ToBool arrives) {
        switch (expression.opCode()) {
            case 13: 
            case 62: 
            case 123: 
            case 147: 
            case 185: {
                boolean totalAccess;
                TapList<BoolVector> rhsDeps = this.depsThroughExpression(deps, expression.down(2), arrives);
                if (rhsDeps == null) {
                    rhsDeps = new TapList<BoolVector>(new BoolVector(DepsAnalyzer.mapSize(this.curBlockMap)), null);
                }
                rhsDeps = this.insertDepsOnControl(rhsDeps, this.curBlock.controllersZone);
                Tree lhs = expression.down(1);
                this.depsThroughExpression(deps, lhs, arrives);
                ToBool lhsTotal = new ToBool(false);
                TapList<?> writtenZonesTree = this.curSymbolTable.treeOfZonesOfValue(lhs, lhsTotal, this.curInstruction, null);
                boolean bl = totalAccess = this.referenceIsTotal(lhsTotal.get(), writtenZonesTree) && expression.opCode() == 13 && (!this.curUnit.isFortran() || !this.inADeclaration);
                if (this.traceCurAnalysis) {
                    TapIntList rksList = this.mapExtendedDeclaredToVectorIndex(ZoneInfo.listAllZones(writtenZonesTree, true), 0, this.curBlockMap);
                    TapEnv.printlnOnTrace("Upon " + ILUtils.toString(expression) + ", " + writtenZonesTree + " (=>rks:" + rksList + ") receives (total:" + totalAccess + ") " + rhsDeps.toString(this.curBlockMap));
                }
                this.setInfoPRZVTreeToExtendedDeclaredZones(deps, this.curBlockMap, writtenZonesTree, rhsDeps, null, totalAccess, 0);
                return rhsDeps;
            }
            case 30: {
                Unit calledUnit = DepsAnalyzer.getCalledUnit(expression, this.curSymbolTable);
                BoolMatrix calleePublicDeps = this.getPublicDeps(calledUnit);
                if (calleePublicDeps == null) {
                    if (arrives != null) {
                        arrives.set(false);
                    }
                    return null;
                }
                CallArrow arrow = CallGraph.getCallArrow(this.curUnit, calledUnit);
                Tree[] actualParams = ILUtils.getArguments(expression).children();
                TapList[] paramDeps = new TapList[actualParams.length];
                for (int i = actualParams.length - 1; i >= 0; --i) {
                    paramDeps[i] = this.depsThroughExpression(deps, actualParams[i], arrives);
                }
                if (this.traceCurAnalysis) {
                    TapEnv.printlnOnTrace();
                    TapEnv.printlnOnTrace(" ---------- Plain Deps Analysis of procedure call " + ILUtils.toString(expression) + " : ----------");
                    TapEnv.printlnOnTrace("    incoming plain deps Upstream:");
                    TapEnv.dumpBoolMatrixOnTrace(deps, this.curBlockMap, this.curBlockMap);
                    TapEnv.printlnOnTrace();
                }
                BoolMatrix publicDeps = this.propagateEntryDataFwdToCallee(deps, this.curBlockMap, paramDeps, calledUnit.unitInOutPossiblyW(), arrow, actualParams, 0, true);
                if (this.traceCurAnalysis) {
                    TapEnv.printlnOnTrace("    made as incoming public:");
                    for (int i = 0; i < calledUnit.paramElemsNb(); ++i) {
                        ZoneInfo zi = calledUnit.paramElemZoneInfo(i);
                        if (zi == null) continue;
                        TapEnv.printOnTrace(" [" + i + "]" + zi.accessTreePrint(this.curUnit.language()));
                    }
                    TapEnv.printlnOnTrace();
                    TapEnv.dumpBoolMatrixOnTrace(publicDeps, null, this.curBlockMap);
                    TapEnv.printlnOnTrace();
                    TapEnv.printlnOnTrace("    composed with callee public plain Deps:");
                    TapEnv.dumpOnTrace(calleePublicDeps);
                    TapEnv.printlnOnTrace();
                }
                publicDeps = calleePublicDeps.times(publicDeps);
                if (this.traceCurAnalysis) {
                    TapEnv.printlnOnTrace("    gives outgoing public:");
                    TapEnv.dumpBoolMatrixOnTrace(publicDeps, null, this.curBlockMap);
                    TapEnv.printlnOnTrace();
                }
                TapList rrr = this.propagateExitDataFwdToCaller(publicDeps, deps, this.curBlockMap, calledUnit.unitInOutPossiblyW(), arrow, actualParams, 0);
                if (this.traceCurAnalysis) {
                    TapEnv.printlnOnTrace("    and outgoing plain deps Downstream:");
                    TapEnv.dumpBoolMatrixOnTrace(deps, this.curBlockMap, this.curBlockMap);
                    TapEnv.printlnOnTrace();
                    TapEnv.printlnOnTrace("    plus result plain Deps: " + rrr.toString(this.curBlockMap));
                    TapEnv.printlnOnTrace(" --------------------------------------------------------------------------");
                    TapEnv.printlnOnTrace();
                }
                return rrr;
            }
            case 73: {
                TapList valueDependency = this.depsThroughExpression(deps, expression.down(1), arrives);
                Object result = TapList.nth(valueDependency, ILUtils.getFieldRank(expression.down(2)));
                if (result instanceof BoolVector) {
                    return new TapList<Object>(result, null);
                }
                return (TapList)result;
            }
            case 8: {
                Tree[] indexes = expression.down(2).children();
                BoolVector indexesDep = new BoolVector(this.nSEZ + this.nTZ + this.nDZ);
                for (int i = indexes.length - 1; i >= 0; --i) {
                    DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, indexes[i], arrives), indexesDep, false);
                }
                TapList result = this.depsThroughExpression(deps, expression.down(1), arrives);
                DepsAnalyzer.orInfoPRZVTrees(indexesDep, result);
                return result;
            }
            case 10: 
            case 25: 
            case 150: {
                return null;
            }
            case 94: {
                TapList<?> zones = this.curSymbolTable.treeOfZonesOfValue(expression, null, this.curInstruction, null);
                if (zones == null) {
                    return null;
                }
                zones = TapList.copyTree(zones);
                this.includePointedElementsInTree(zones, null, null, true, false, true);
                return this.buildInfoPRZVTreeOfExtendedDeclared(zones, deps, 0, this.curBlockMap);
            }
            case 148: {
                BoolVector offsetDep = new BoolVector(this.nSEZ + this.nTZ + this.nDZ);
                DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, expression.down(2), arrives), offsetDep, false);
                DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, expression.down(1), arrives), offsetDep, false);
                TapList<?> zones = this.curSymbolTable.treeOfZonesOfValue(expression, null, this.curInstruction, null);
                if (zones == null) {
                    return null;
                }
                zones = TapList.copyTree(zones);
                this.includePointedElementsInTree(zones, null, null, true, false, true);
                TapList result = this.buildInfoPRZVTreeOfExtendedDeclared(zones, deps, 0, this.curBlockMap);
                DepsAnalyzer.orInfoPRZVTrees(offsetDep, result);
                return result;
            }
            case 2: 
            case 61: 
            case 124: 
            case 131: 
            case 152: 
            case 177: {
                return TapList.cumulWithOper(this.depsThroughExpression(deps, expression.down(1), arrives), this.depsThroughExpression(deps, expression.down(2), arrives), 91);
            }
            case 122: 
            case 137: 
            case 171: {
                return this.depsThroughExpression(deps, expression.down(1), arrives);
            }
            case 31: 
            case 132: 
            case 189: {
                return this.depsThroughExpression(deps, expression.down(2), arrives);
            }
            case 107: {
                int i;
                TapIntList writtenZonesList;
                TapList<?> writtenZonesTree;
                int zoneIO = this.curCallGraph.zoneNbOfAllIOStreams;
                String ioAction = ILUtils.getIdentString(expression.down(1));
                boolean writesInVars = ioAction.equals("read") || ioAction.equals("accept") || ioAction.equals("decode");
                BoolVector usedZones = new BoolVector(DepsAnalyzer.mapSize(this.curBlockMap));
                usedZones.setTest(this.curBlock.controllersZone, this.curBlockMap, true);
                usedZones.setDeclared(zoneIO, this.curBlockMap, true);
                BoolVector writtenZones = new BoolVector(DepsAnalyzer.mapSize(this.curBlockMap));
                writtenZones.setDeclared(zoneIO, this.curBlockMap, true);
                BoolVector totalWrittenZones = new BoolVector(DepsAnalyzer.mapSize(this.curBlockMap));
                ToBool total = new ToBool(false);
                ToBool totally = new ToBool(false);
                ToBool written = new ToBool(false);
                Tree[] ioArgs = expression.down(3).children();
                for (int i2 = ioArgs.length - 1; i2 >= 0; --i2) {
                    if (writesInVars) {
                        writtenZonesTree = this.curSymbolTable.treeOfZonesOfValue(ioArgs[i2], total, this.curInstruction, null);
                        writtenZonesList = ZoneInfo.listAllZones(writtenZonesTree, true);
                        writtenZones.setDeclared(writtenZonesList, this.curBlockMap, true);
                        if (!total.get()) continue;
                        totalWrittenZones.setDeclared(writtenZonesList, this.curBlockMap, true);
                        continue;
                    }
                    DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, ioArgs[i2], arrives), usedZones, false);
                }
                Tree[] ioSpecs = expression.down(2).children();
                for (i = ioSpecs.length - 1; i >= 0; --i) {
                    Tree ioSpecTree = InOutAnalyzer.getIOeffectOfIOspec(ioSpecs[i], i, ioAction, written, totally, this.curSymbolTable);
                    if (written.get()) {
                        writtenZonesTree = this.curSymbolTable.treeOfZonesOfValue(ioSpecTree, total, this.curInstruction, null);
                        writtenZonesList = ZoneInfo.listAllZones(writtenZonesTree, true);
                        writtenZones.setDeclared(writtenZonesList, this.curBlockMap, true);
                        if (!total.get() || !totally.get()) continue;
                        totalWrittenZones.setDeclared(writtenZonesList, this.curBlockMap, true);
                        continue;
                    }
                    DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, ioSpecTree, arrives), usedZones, false);
                }
                for (i = this.nDZ - 1; i >= 0; --i) {
                    if (!writtenZones.getDeclared(i, this.curBlockMap)) continue;
                    if (totalWrittenZones.getDeclared(i, this.curBlockMap)) {
                        deps.setExplicitZeroRow(i + this.nSEZ + this.nTZ);
                    }
                    if (deps.isImplicitIdentityRow(i + this.nSEZ + this.nTZ)) {
                        deps.setExplicitIdentityRow(i + this.nSEZ + this.nTZ);
                    }
                    deps.getRow(i + this.nSEZ + this.nTZ).cumulOr(usedZones);
                }
                return null;
            }
            case 5: 
            case 9: 
            case 11: 
            case 17: 
            case 21: 
            case 23: 
            case 41: 
            case 42: 
            case 46: 
            case 51: 
            case 67: 
            case 70: 
            case 81: 
            case 90: 
            case 93: 
            case 113: 
            case 114: 
            case 120: 
            case 135: 
            case 138: 
            case 141: 
            case 164: 
            case 202: {
                Tree[] exprs = expression.children();
                BoolVector resultDep = new BoolVector(this.nSEZ + this.nTZ + this.nDZ);
                for (int i = exprs.length - 1; i >= 0; --i) {
                    DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, exprs[i], arrives), resultDep, false);
                }
                return new TapList<BoolVector>(resultDep, null);
            }
            case 96: 
            case 179: 
            case 184: 
            case 191: 
            case 201: {
                BoolVector conditionDep = new BoolVector(this.nSEZ + this.nTZ + this.nDZ);
                DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, expression.down(1), arrives), conditionDep, false);
                int testNumber = this.curBlock.testZone;
                if (testNumber >= 0) {
                    deps.setRow(testNumber + this.nSEZ, conditionDep);
                }
                return null;
            }
            case 4: {
                return this.depsThroughExpression(deps, expression.down(2), arrives);
            }
            case 77: {
                this.depsThroughExpression(deps, expression.down(1), arrives);
                this.depsThroughExpression(deps, expression.down(2), arrives);
                this.depsThroughExpression(deps, expression.down(3), arrives);
                return null;
            }
            case 97: {
                return TapList.cumulWithOper(TapList.copyTree(this.depsThroughExpression(deps, expression.down(2), arrives)), this.depsThroughExpression(deps, expression.down(3), arrives), 91);
            }
            case 200: {
                BoolVector conditionDep = new BoolVector(this.nSEZ + this.nTZ + this.nDZ);
                DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, expression.down(1), arrives), conditionDep, false);
                int topWhereTestZone = this.curUnit.testZonesNb();
                int currentWhereTestZone = topWhereTestZone - this.curInstruction.whereMaskDepth();
                deps.setRow(currentWhereTestZone + this.nSEZ, conditionDep);
                return null;
            }
            case 181: {
                this.depsThroughExpression(deps, expression.down(2), arrives);
                return null;
            }
            case 119: {
                this.depsThroughExpression(deps, expression.down(3), arrives);
                return null;
            }
            case 78: {
                this.depsThroughExpression(deps, expression.down(1), arrives);
                this.depsThroughExpression(deps, expression.down(2), arrives);
                return null;
            }
            case 79: {
                this.depsThroughExpression(deps, expression.down(1), arrives);
                this.depsThroughExpression(deps, expression.down(2), arrives);
                return null;
            }
            case 63: 
            case 80: {
                BoolVector boundsDep = new BoolVector(DepsAnalyzer.mapSize(this.curBlockMap));
                TapIntList indexZones = this.curSymbolTable.listOfZonesOfValue(expression.down(1), null, this.curInstruction);
                DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, expression.down(2), arrives), boundsDep, false);
                DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, expression.down(3), arrives), boundsDep, false);
                DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, expression.down(4), arrives), boundsDep, false);
                TapIntList iter = indexZones;
                while (iter != null) {
                    boundsDep.setDeclared(iter.head, this.curBlockMap, true);
                    iter = iter.tail;
                }
                deps.overwriteDeps(indexZones, this.nSEZ + this.nTZ, boundsDep, true);
                int testNumber = this.curBlock.testZone;
                if (testNumber >= 0) {
                    deps.setRow(testNumber + this.nSEZ, boundsDep);
                }
                return null;
            }
            case 108: {
                BoolVector resultDep = new BoolVector(this.nSEZ + this.nTZ + this.nDZ);
                TapIntList indexZones = this.curSymbolTable.listOfZonesOfValue(expression.down(2).down(1), null, this.curInstruction);
                DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, expression.down(2).down(2), arrives), resultDep, false);
                DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, expression.down(2).down(3), arrives), resultDep, false);
                DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, expression.down(2).down(4), arrives), resultDep, false);
                deps.overwriteDeps(indexZones, this.nSEZ + this.nTZ, resultDep, true);
                DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, expression.down(1), arrives), resultDep, false);
                return new TapList<BoolVector>(resultDep, null);
            }
            case 174: {
                if (arrives != null) {
                    arrives.set(false);
                }
                return null;
            }
            case 163: {
                TapList result = null;
                this.depsThroughExpression(deps, expression.down(2), arrives);
                if (!ILUtils.isNullOrNone(expression.down(1))) {
                    String returnVarName = this.curUnit.otherReturnVar() == null ? this.curUnit.name : this.curUnit.otherReturnVar().symbol;
                    Tree assignTree = ILUtils.turnReturnIntoAssign(expression, returnVarName);
                    result = this.depsThroughExpression(deps, assignTree, arrives);
                    ILUtils.resetReturnFromAssign(expression, assignTree);
                }
                return result;
            }
            case 142: 
            case 143: {
                return null;
            }
            case 35: 
            case 45: 
            case 55: 
            case 87: {
                return null;
            }
            case 1: 
            case 3: 
            case 12: 
            case 14: 
            case 19: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 48: 
            case 50: 
            case 68: 
            case 72: 
            case 76: 
            case 92: 
            case 99: 
            case 101: 
            case 102: 
            case 104: 
            case 106: 
            case 109: 
            case 116: 
            case 127: 
            case 133: 
            case 136: 
            case 151: 
            case 155: 
            case 166: 
            case 172: 
            case 175: 
            case 176: 
            case 187: 
            case 192: 
            case 197: 
            case 199: {
                return null;
            }
            case 194: {
                Tree[] decls = expression.down(3).children();
                this.inADeclaration = true;
                for (int i = decls.length - 1; i >= 0; --i) {
                    if (decls[i].opCode() != 13) continue;
                    ILUtils.turnAssignFromInitDecl(decls[i]);
                    this.depsThroughExpression(deps, decls[i], arrives);
                    ILUtils.resetAssignFromInitDecl(decls[i]);
                }
                this.inADeclaration = false;
                return null;
            }
        }
        TapEnv.toolWarning(-1, "(Compute plain dependencies) Unexpected operator : " + expression.opName());
        return null;
    }

    private BoolMatrix accumulateDepIn(Block block) {
        BoolMatrix depIn = null;
        TapList<FGArrow> arrows = block.backFlow();
        while (arrows != null) {
            Block origin = ((FGArrow)arrows.head).origin;
            BoolMatrix depIncoming = this.depsOut.retrieve(origin);
            if (depIncoming != null) {
                if (depIn == null) {
                    depIn = new BoolMatrix(this.nSEZ + this.nTZ + this.nDZ, this.nSEZ + this.nTZ + this.nUDZ);
                }
                BoolVector saveDep = null;
                int rowIdx = -1;
                SymbolTable origSymbolTable = origin.symbolTable;
                if (block.instructions != null) {
                    TapIntList listOfZones;
                    boolean doCaseAndNotInACycle;
                    Tree expression = TapList.last(block.instructions).tree;
                    boolean bl = doCaseAndNotInACycle = block instanceof HeaderBlock && expression.opCode() == 119 && expression.down(3).opCode() == 63 && !((FGArrow)arrows.head).inACycle;
                    if (doCaseAndNotInACycle && (listOfZones = origSymbolTable.listOfZonesOfValue(expression.down(3).down(1), null, this.curInstruction)) != null) {
                        rowIdx = this.extendedDeclaredToVectorIndex(listOfZones.head, 0, DepsAnalyzer.makeMap3(this.nSEZ, this.nTZ, origSymbolTable.declaredZonesNb(0)));
                        saveDep = depIncoming.getRow(rowIdx);
                        if (saveDep != null) {
                            saveDep = saveDep.copy();
                        }
                        depIncoming.setExplicitZeroRow(rowIdx);
                    }
                }
                SymbolTable commonSymbolTable = block.symbolTable.getCommonRoot(origSymbolTable);
                depIn.cumulOr(depIncoming, true, this.nSEZ + this.nTZ + commonSymbolTable.declaredZonesNb(0));
                if (rowIdx != -1) {
                    depIncoming.setRow(rowIdx, saveDep);
                }
            }
            arrows = arrows.tail;
        }
        return depIn;
    }

    private BoolMatrix getPublicDeps(Unit calledUnit) {
        BoolMatrix unitDependency;
        if (calledUnit == null) {
            return null;
        }
        if (calledUnit.isIntrinsic()) {
            unitDependency = calledUnit.unitDependencies;
            if (unitDependency == null) {
                calledUnit.unitDependencies = unitDependency = DepsAnalyzer.buildDefaultIntrinsicDependencies(calledUnit);
            }
        } else if (calledUnit.isVarFunction()) {
            unitDependency = DepsAnalyzer.buildDefaultExternalDependencies(calledUnit);
        } else {
            unitDependency = calledUnit.unitDependencies;
            if (unitDependency == null && calledUnit.isExternal()) {
                calledUnit.unitDependencies = unitDependency = DepsAnalyzer.buildDefaultExternalDependencies(calledUnit);
            }
        }
        return unitDependency;
    }

    private TapList insertDepsOnControl(TapList deps, TapIntList controlTests) {
        if (controlTests != null) {
            BoolVector controlDeps = new BoolVector(this.nSEZ + this.nTZ + this.nDZ);
            controlDeps.setTest(controlTests, this.curBlockMap, true);
            int whereDepth = this.curInstruction.whereMaskDepth();
            int lastControlZone = this.curUnit.testZonesNb();
            for (int i = whereDepth; i > 0; --i) {
                controlDeps.setTest(lastControlZone - i, this.curBlockMap, true);
            }
            if (deps == null) {
                deps = new TapList<BoolVector>(controlDeps, null);
            } else {
                DepsAnalyzer.orInfoPRZVTrees(controlDeps, deps);
            }
        }
        return deps;
    }
}

