/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.analysis;

import fr.inria.tapenade.analysis.ADActivityAnalyzer;
import fr.inria.tapenade.analysis.ActivityPattern;
import fr.inria.tapenade.analysis.DataFlowAnalyzer;
import fr.inria.tapenade.analysis.DepsAnalyzer;
import fr.inria.tapenade.analysis.InOutAnalyzer;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.BlockStorage;
import fr.inria.tapenade.representation.CallArrow;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.HeaderBlock;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.InstructionMask;
import fr.inria.tapenade.representation.MPIcallInfo;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.BoolMatrix;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.ToInt;
import fr.inria.tapenade.utils.Tree;

public final class DiffLivenessAnalyzer
extends DataFlowAnalyzer {
    private static final int BOTTOMUP_CKP = 0;
    private static final int TOPDOWN_NOCKP = 1;
    private final ADActivityAnalyzer adActivityAnalyzer;
    private BlockStorage<TapPair<BoolVector, BoolVector>> infosDown;
    private BlockStorage<TapPair<BoolVector, BoolVector>> infosCycleDown;
    private BlockStorage<TapPair<BoolVector, BoolVector>> infosUp;
    private BlockStorage<TapPair<BoolVector, BoolVector>> infosCycleUp;
    private BoolVector infoTmp;
    private BoolVector infoTmpOnDiffPtr;
    private BoolVector infoTmpCycle;
    private BoolVector infoTmpCycleOnDiffPtr;
    private TapPair<BoolVector, BoolVector> additionalInfoPair;
    private BoolVector additionalInfo;
    private BoolVector additionalInfoOnDiffPtr;
    private BlockStorage<TapPair<BoolVector, BoolVector>> infosWDown;
    private BlockStorage<TapPair<BoolVector, BoolVector>> infosWCycleDown;
    private BlockStorage<TapPair<BoolVector, BoolVector>> infosWUp;
    private BlockStorage<TapPair<BoolVector, BoolVector>> infosWCycleUp;
    private BoolVector infoWTmp;
    private BoolVector infoWTmpOnDiffPtr;
    private BoolVector infoWTmpCycle;
    private BoolVector infoWTmpCycleOnDiffPtr;
    private TapPair<BoolVector, BoolVector> additionalInfoWPair;
    private BoolVector additionalInfoW;
    private BoolVector additionalInfoWOnDiffPtr;
    private BoolVector unitExitLiveness;
    private BoolVector unitExitLivenessOnDiffPtr;
    private BoolVector unitExitOverwrite;
    private BoolVector unitExitOverwriteOnDiffPtr;
    private BlockStorage<TapList<BoolVector>> curUnitActivities;
    private BlockStorage<TapList<BoolVector>> curUnitReqXs;
    private BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> curUnitInfos;
    private BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> curUnitInfosW;
    private int nDPZ;
    private int nSEPZ;
    private int[] vectorMap;
    private int[] vectorMapWithCtrl;
    private int[] pointerVectorMap;
    private int phase;

    private DiffLivenessAnalyzer(CallGraph cg) {
        super(cg, "Diff liveness analysis", TapEnv.traceDiffLiveness());
        this.conservativeValue = true;
        this.adActivityAnalyzer = TapEnv.adActivityAnalyzer();
    }

    public static void runAnalysis(CallGraph callGraph, TapList<Unit> rootUnits) {
        TapEnv.setDiffLivenessAnalyzer(new DiffLivenessAnalyzer(callGraph));
        TapEnv.diffLivenessAnalyzer().run(rootUnits);
    }

    public static void setTreeRequiredInDiff(ActivityPattern curActivity, Tree tree, boolean checkpoint) {
        Tree annotatedTree = tree.opCode() == 119 ? tree.down(3) : (tree.opCode() == 63 ? tree : (tree.opCode() == 30 ? ILUtils.getCalledName(tree) : (!tree.isAtom() && tree.down(1) != null ? tree.down(1) : tree)));
        if (checkpoint) {
            DiffLivenessAnalyzer.setRequiredInDiff(curActivity, annotatedTree);
        } else {
            DiffLivenessAnalyzer.setRequiredInDiffNockp(curActivity, annotatedTree);
        }
    }

    public static boolean isTreeRequiredInDiff(ActivityPattern curActivity, Tree tree, boolean checkpoint) {
        Tree annotatedTree = tree.opCode() == 119 ? tree.down(3) : (tree.opCode() == 63 ? tree : (tree.opCode() == 30 ? ILUtils.getCalledName(tree) : (!tree.isAtom() && tree.down(1) != null ? tree.down(1) : tree)));
        if (checkpoint) {
            return DiffLivenessAnalyzer.isRequiredInDiffCkp(curActivity, annotatedTree);
        }
        return DiffLivenessAnalyzer.isRequiredInDiffNockp(curActivity, annotatedTree);
    }

    public static boolean isTreeOrSubtreeRequiredInDiff(ActivityPattern curActivity, Tree tree, boolean checkpoint) {
        if (checkpoint ? DiffLivenessAnalyzer.isRequiredInDiffCkp(curActivity, tree) : DiffLivenessAnalyzer.isRequiredInDiffNockp(curActivity, tree)) {
            return true;
        }
        if (tree.isAtom()) {
            return false;
        }
        Tree[] subTrees = tree.children();
        boolean found = false;
        for (int i = subTrees.length - 1; !found && i >= 0; --i) {
            found = DiffLivenessAnalyzer.isTreeOrSubtreeRequiredInDiff(curActivity, subTrees[i], checkpoint);
        }
        return found;
    }

    public static void setRequiredInDiff(ActivityPattern curActivity, Tree tree) {
        ToInt annot = (ToInt)ActivityPattern.getAnnotationForActivityPattern(tree, curActivity, "RequiredInDiff");
        if (annot == null) {
            annot = new ToInt(0);
            ActivityPattern.setAnnotationForActivityPattern(tree, curActivity, "RequiredInDiff", annot);
        }
        annot.set(2);
    }

    private static void setNotRequiredInDiff(ActivityPattern curActivity, Tree tree) {
        ToInt annot = (ToInt)ActivityPattern.getAnnotationForActivityPattern(tree, curActivity, "RequiredInDiff");
        if (annot != null) {
            annot.set(0);
        }
    }

    private static void setRequiredInDiffNockp(ActivityPattern curActivity, Tree tree) {
        ToInt annot = (ToInt)ActivityPattern.getAnnotationForActivityPattern(tree, curActivity, "RequiredInDiff");
        if (annot == null) {
            annot = new ToInt(0);
            ActivityPattern.setAnnotationForActivityPattern(tree, curActivity, "RequiredInDiff", annot);
        }
        if (annot.get() == 0) {
            annot.set(1);
        }
    }

    private static boolean isRequiredInDiffCkp(ActivityPattern curActivity, Tree tree) {
        if (tree == null) {
            return true;
        }
        ToInt annot = (ToInt)ActivityPattern.getAnnotationForActivityPattern(tree, curActivity, "RequiredInDiff");
        return annot != null && annot.get() == 2;
    }

    private static boolean isRequiredInDiffNockp(ActivityPattern curActivity, Tree tree) {
        if (tree == null) {
            return true;
        }
        ToInt annot = (ToInt)ActivityPattern.getAnnotationForActivityPattern(tree, curActivity, "RequiredInDiff");
        return annot != null && annot.get() >= 1;
    }

    public static void copyTreeRequiredInDiff(ActivityPattern curActivity, Tree oldTree, Tree newTree) {
        Tree annotatedNewTree;
        Object annot;
        Tree annotatedOldTree = oldTree.opCode() == 119 ? oldTree.down(3) : (oldTree.opCode() == 63 ? oldTree : (!oldTree.isAtom() && oldTree.down(1) != null ? oldTree.down(1) : oldTree));
        if (annotatedOldTree != null && (annot = ActivityPattern.getAnnotationForActivityPattern(annotatedOldTree, curActivity, "RequiredInDiff")) != null && (annotatedNewTree = newTree.opCode() == 119 ? newTree.down(3) : (newTree.opCode() == 63 ? newTree : (!newTree.isAtom() && newTree.down(1) != null ? newTree.down(1) : newTree))) != null) {
            ActivityPattern.setAnnotationForActivityPattern(annotatedNewTree, curActivity, "RequiredInDiff", annot);
        }
    }

    private static boolean trivialIdentDiff(ActivityPattern curActivity, Tree tree, SymbolTable symbolTable) {
        if (tree.opCode() == 13) {
            if (tree.down(2).opCode() == 2) {
                Tree t1 = tree.down(2).down(1);
                Tree t2 = tree.down(2).down(2);
                if (tree.down(1).equalsTree(t1)) {
                    return !ADActivityAnalyzer.isAnnotatedActive(curActivity, t2, symbolTable);
                }
                if (tree.down(1).equalsTree(t2)) {
                    return !ADActivityAnalyzer.isAnnotatedActive(curActivity, t1, symbolTable);
                }
                return false;
            }
            return false;
        }
        if (tree.opCode() == 147) {
            return !ADActivityAnalyzer.isAnnotatedActive(curActivity, tree.down(2), symbolTable);
        }
        return false;
    }

    @Override
    protected void run(TapList<Unit> rootUnits) {
        String topAnalysisName = this.curAnalysisName;
        this.phase = 0;
        this.curAnalysisName = "Bottom-up (joint/CKP) diff liveness analysis";
        this.runBottomUpAnalysis(rootUnits);
        this.phase = 1;
        this.curAnalysisName = "Top-down  (split/NOCKP or TGT) diff liveness analysis";
        this.runTopDownAnalysis(rootUnits);
        this.curAnalysisName = topAnalysisName;
    }

    public void setCurUnitActivity(ActivityPattern activity) {
        this.curActivity = activity;
    }

    public void setPhaseSubGraph() {
        this.phase = 0;
    }

    @Override
    public void setCurUnitEtc(Unit unit) {
        super.setCurUnitEtc(unit);
        this.nSEPZ = this.curUnit == null ? -9 : this.curUnit.sideEffectZonesNb(3);
        this.nDPZ = this.curSymbolTable == null ? -9 : this.curSymbolTable.declaredZonesNb(3);
    }

    @Override
    protected Object initializeCGForUnit() {
        if (this.curUnit.hasParamElemsInfo()) {
            int shapeLength = this.curUnit.paramElemsNb();
            TapList<ActivityPattern> activities = this.curUnit.specificInfoAD;
            while (activities != null) {
                this.curActivity = (ActivityPattern)activities.head;
                if (this.phase == 0) {
                    this.curActivity.setDiffLivenessesCkp(null);
                    this.curActivity.setExitDiffLivenesses(new BoolVector(shapeLength));
                    this.curActivity.setExitDiffLivenessesOnDiffPtr(new BoolVector(shapeLength));
                    this.curActivity.setDiffOverwritesCkp(null);
                    this.curActivity.setExitDiffOverwrites(new BoolVector(shapeLength));
                    this.curActivity.setExitDiffOverwritesOnDiffPtr(new BoolVector(shapeLength));
                    this.curActivity.setDiffLivenessTopDownContext(new Context(shapeLength));
                } else {
                    this.curActivity.setDiffLivenesses(null);
                    this.curActivity.setDiffOverwrites(null);
                }
                activities = activities.tail;
            }
        }
        return null;
    }

    @Override
    protected void initializeCGForRootUnit() {
        TapList<ActivityPattern> activities = this.curUnit.specificInfoAD;
        while (activities != null) {
            this.curActivity = (ActivityPattern)activities.head;
            activities = activities.tail;
        }
    }

    @Override
    protected boolean analyze() {
        boolean hasChanged = false;
        if (this.curUnit.hasParamElemsInfo()) {
            int shapeLength = this.curUnit.paramElemsNb();
            TapList<ActivityPattern> activities = this.curUnit.specificInfoAD;
            while (activities != null) {
                this.curActivity = (ActivityPattern)activities.head;
                if (this.curUnit.hasSource()) {
                    TapEnv.printOnTrace(15, " (ActivityPattern @" + Integer.toHexString(this.curActivity.hashCode()) + ":)");
                }
                this.curUnitActivities = this.curActivity.activities();
                this.curUnitReqXs = this.curActivity.reqXs();
                if (this.phase == 0) {
                    String unitPublicMapName;
                    int[] unitPublicMap;
                    this.curUnitInfos = this.curActivity.diffLivenessesCkp();
                    if (this.curUnitInfos == null) {
                        this.curUnitInfos = new BlockStorage(this.curUnit);
                        this.curActivity.setDiffLivenessesCkp(this.curUnitInfos);
                    }
                    this.curUnitInfosW = this.curActivity.diffOverwritesCkp();
                    if (this.curUnitInfosW == null) {
                        this.curUnitInfosW = new BlockStorage(this.curUnit);
                        this.curActivity.setDiffOverwritesCkp(this.curUnitInfosW);
                    }
                    this.unitExitLiveness = new BoolVector(shapeLength);
                    this.unitExitLivenessOnDiffPtr = new BoolVector(shapeLength);
                    this.unitExitOverwrite = new BoolVector(shapeLength);
                    this.unitExitOverwriteOnDiffPtr = new BoolVector(shapeLength);
                    hasChanged = this.analyzeBackward(null, null, null) || hasChanged;
                    this.setCurBlockEtc(this.curUnit.entryBlock);
                    TapPair callLivenessPair = (TapPair)this.curUnitInfos.retrieve((Block)this.curUnit.entryBlock).head;
                    TapPair callOverwritePair = (TapPair)this.curUnitInfosW.retrieve((Block)this.curUnit.entryBlock).head;
                    BoolVector oldPublicResult = this.curActivity.entryDiffLivenessesCkp();
                    BoolVector newPublicResult = DiffLivenessAnalyzer.propagateUnitDataOutside((BoolVector)callLivenessPair.first, 0, this.vectorMapWithCtrl, true, this.curUnit);
                    BoolVector oldPublicResultOnDiffPtr = this.curActivity.entryDiffLivenessesCkpOnDiffPtr();
                    BoolVector newPublicResultOnDiffPtr = DiffLivenessAnalyzer.propagateUnitDataOutside((BoolVector)callLivenessPair.second, 3, this.pointerVectorMap, true, this.curUnit);
                    if (newPublicResult != null && (oldPublicResult == null || !oldPublicResult.equals(newPublicResult, shapeLength)) || newPublicResultOnDiffPtr != null && (oldPublicResultOnDiffPtr == null || !oldPublicResultOnDiffPtr.equals(newPublicResultOnDiffPtr, shapeLength))) {
                        hasChanged = true;
                        this.curActivity.setEntryDiffLivenessesCkp(newPublicResult);
                        this.curActivity.setEntryDiffLivenessesCkpOnDiffPtr(newPublicResultOnDiffPtr);
                        if (this.traceCurAnalysis) {
                            unitPublicMap = new int[]{0, shapeLength};
                            unitPublicMapName = "[x" + this.curUnit.rank() + ":a]";
                            assert (newPublicResult != null);
                            TapEnv.printlnOnTrace("  Updated input L:" + unitPublicMapName + " " + newPublicResult.toString(unitPublicMap) + " Ptr:" + newPublicResultOnDiffPtr.toString(unitPublicMap));
                        }
                    }
                    oldPublicResult = this.curActivity.entryDiffOverwritesCkp();
                    newPublicResult = DiffLivenessAnalyzer.propagateUnitDataOutside((BoolVector)callOverwritePair.first, 0, this.vectorMap, true, this.curUnit);
                    oldPublicResultOnDiffPtr = this.curActivity.entryDiffOverwritesCkpOnDiffPtr();
                    newPublicResultOnDiffPtr = DiffLivenessAnalyzer.propagateUnitDataOutside((BoolVector)callOverwritePair.second, 3, this.pointerVectorMap, true, this.curUnit);
                    if (newPublicResult != null && (oldPublicResult == null || !oldPublicResult.equals(newPublicResult, shapeLength)) || newPublicResultOnDiffPtr != null && (oldPublicResultOnDiffPtr == null || !oldPublicResultOnDiffPtr.equals(newPublicResultOnDiffPtr, shapeLength))) {
                        hasChanged = true;
                        this.curActivity.setEntryDiffOverwritesCkp(newPublicResult);
                        this.curActivity.setEntryDiffOverwritesCkpOnDiffPtr(newPublicResultOnDiffPtr);
                        if (this.traceCurAnalysis) {
                            unitPublicMap = new int[]{0, shapeLength};
                            unitPublicMapName = "[x" + this.curUnit.rank() + ":a]";
                            assert (newPublicResult != null);
                            TapEnv.printlnOnTrace("  Updated input W:" + unitPublicMapName + " " + newPublicResult.toString(unitPublicMap) + " Ptr:" + newPublicResultOnDiffPtr.toString(unitPublicMap));
                        }
                    }
                    this.setCurBlockEtc(null);
                } else {
                    Context context = this.curActivity.diffLivenessTopDownContext();
                    if (context.nockpOutOfDate) {
                        context.nockpOutOfDate = false;
                        this.curUnitInfos = this.curActivity.diffLivenesses();
                        if (this.curUnitInfos == null) {
                            this.curUnitInfos = new BlockStorage(this.curUnit);
                            this.curActivity.setDiffLivenesses(this.curUnitInfos);
                        }
                        this.curUnitInfosW = this.curActivity.diffOverwrites();
                        if (this.curUnitInfosW == null) {
                            this.curUnitInfosW = new BlockStorage(this.curUnit);
                            this.curActivity.setDiffOverwrites(this.curUnitInfosW);
                        }
                        this.unitExitLiveness = context.nockpExitLiveness;
                        this.unitExitLivenessOnDiffPtr = context.nockpExitLivenessOnDiffPtr;
                        this.unitExitOverwrite = context.nockpExitOverwrite;
                        this.unitExitOverwriteOnDiffPtr = context.nockpExitOverwriteOnDiffPtr;
                        this.analyzeBackward(null, null, null);
                    }
                }
                activities = activities.tail;
            }
        }
        return hasChanged;
    }

    public void setCurUnitActivitiesLivenessesAndOverwrites(ActivityPattern activity, boolean isJointMode) {
        this.curActivity = activity;
        if (activity != null) {
            this.curUnitActivities = this.curActivity.activities();
            this.curUnitReqXs = this.curActivity.reqXs();
            this.curUnitInfos = isJointMode ? this.curActivity.diffLivenessesCkp() : this.curActivity.diffLivenesses();
            this.curUnitInfosW = isJointMode ? this.curActivity.diffOverwritesCkp() : this.curActivity.diffOverwrites();
            Context context = this.curActivity.diffLivenessTopDownContext();
            this.unitExitLiveness = context.nockpExitLiveness;
            if (this.unitExitLiveness == null) {
                this.unitExitLiveness = new BoolVector(context.shapeLength);
            }
            this.unitExitLivenessOnDiffPtr = context.nockpExitLivenessOnDiffPtr;
            if (this.unitExitLivenessOnDiffPtr == null) {
                this.unitExitLivenessOnDiffPtr = new BoolVector(context.shapeLength);
            }
            this.unitExitOverwrite = context.nockpExitOverwrite;
            if (this.unitExitOverwrite == null) {
                this.unitExitOverwrite = new BoolVector(context.shapeLength);
            }
            this.unitExitOverwriteOnDiffPtr = context.nockpExitOverwriteOnDiffPtr;
            if (this.unitExitOverwriteOnDiffPtr == null) {
                this.unitExitOverwriteOnDiffPtr = new BoolVector(context.shapeLength);
            }
        } else {
            this.curUnitActivities = null;
            this.curUnitReqXs = null;
            this.curUnitInfos = null;
            this.curUnitInfosW = null;
            this.unitExitLiveness = null;
            this.unitExitLivenessOnDiffPtr = null;
            this.unitExitOverwrite = null;
            this.unitExitOverwriteOnDiffPtr = null;
        }
    }

    @Override
    protected void initializeUnit() {
        this.nTZ = this.curUnit.testZonesNb();
        this.infosUp = new BlockStorage(this.curUnit);
        this.infosDown = new BlockStorage(this.curUnit);
        this.infosCycleUp = new BlockStorage(this.curUnit);
        this.infosCycleDown = new BlockStorage(this.curUnit);
        this.infosWUp = new BlockStorage(this.curUnit);
        this.infosWDown = new BlockStorage(this.curUnit);
        this.infosWCycleUp = new BlockStorage(this.curUnit);
        this.infosWCycleDown = new BlockStorage(this.curUnit);
        this.curBlock = null;
        if (this.traceCurAnalysis) {
            ZoneInfo zi;
            int i;
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace(" ============== DIFF LIVENESS ANALYSIS ON UNIT " + this.curUnit.name + " : ==============");
            TapEnv.printlnOnTrace(" Activity context of this analysis: " + this.curActivity);
            this.curSymbolTable = this.curUnit.privateSymbolTable();
            if (this.curSymbolTable == null) {
                this.curSymbolTable = this.curUnit.publicSymbolTable();
            }
            int nDZloc = this.curSymbolTable.declaredZonesNb(0);
            if (this.nSEZ > 0) {
                TapEnv.printOnTrace(" SE:");
            }
            for (i = 0; i < this.nSEZ; ++i) {
                zi = this.zoneRkToZoneInfo(i, 1, 0);
                if (zi == null) continue;
                TapEnv.printOnTrace(" [" + i + "]" + zi.accessTreePrint(this.curUnit.language()));
            }
            if (this.nTZ > 0) {
                TapEnv.printOnTrace(" T: " + this.nSEZ + "->" + (this.nSEZ + this.nTZ - 1));
            }
            if (nDZloc > 0) {
                TapEnv.printOnTrace(" D:");
            }
            for (i = 0; i < nDZloc; ++i) {
                zi = this.zoneRkToZoneInfo(i, 3, 0);
                if (zi == null) continue;
                TapEnv.printOnTrace(" [" + (i + this.nSEZ + this.nTZ) + "]" + zi.accessTreePrint(this.curUnit.language()));
            }
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace();
        }
    }

    @Override
    protected void setCurBlockEtc(Block block) {
        super.setCurBlockEtc(block);
        int n = this.nDPZ = this.curSymbolTable == null ? -9 : this.curSymbolTable.declaredZonesNb(3);
        if (block != null) {
            this.vectorMap = DiffLivenessAnalyzer.makeMap3(this.nSEZ, 0, this.curSymbolTable == null ? 0 : this.nDZ);
            this.vectorMapWithCtrl = DiffLivenessAnalyzer.makeMap3(this.nSEZ, this.nTZ, this.curSymbolTable == null ? 0 : this.nDZ);
            this.pointerVectorMap = DiffLivenessAnalyzer.makeMap3(this.nSEPZ, 0, this.curSymbolTable == null ? 0 : this.nDPZ);
        }
    }

    @Override
    protected void initializeInitBlock() {
        if (this.curBlock == this.curUnit.exitBlock) {
            this.setCurBlockEtc(this.curUnit.exitBlock);
            this.infosUp.store(this.curBlock, new TapPair<BoolVector, BoolVector>(this.propagateUnitDataInside(this.unitExitLiveness, 0, this.vectorMapWithCtrl), this.propagateUnitDataInside(this.unitExitLivenessOnDiffPtr, 3, this.pointerVectorMap)));
            this.infosWUp.store(this.curBlock, new TapPair<BoolVector, BoolVector>(this.propagateUnitDataInside(this.unitExitOverwrite, 0, this.vectorMap), this.propagateUnitDataInside(this.unitExitOverwriteOnDiffPtr, 3, this.pointerVectorMap)));
            this.setCurBlockEtc(null);
        } else {
            int lenSED = this.curUnit.sideEffectZonesNb(0) + this.curBlock.symbolTable.declaredZonesNb(0);
            int lenSEDOnDiffPtr = this.curUnit.sideEffectZonesNb(3) + this.curBlock.symbolTable.declaredZonesNb(3);
            BoolVector initLive = new BoolVector(lenSED + this.curUnit.testZonesNb());
            BoolVector initLiveOnDiffPtr = new BoolVector(lenSEDOnDiffPtr);
            BoolVector initOverwr = new BoolVector(lenSED);
            BoolVector initOverwrOnDiffPtr = new BoolVector(lenSEDOnDiffPtr);
            this.infosUp.store(this.curBlock, new TapPair<BoolVector, BoolVector>(initLive, initLiveOnDiffPtr));
            this.infosWUp.store(this.curBlock, new TapPair<BoolVector, BoolVector>(initOverwr, initOverwrOnDiffPtr));
            if (DiffLivenessAnalyzer.runSpecialCycleAnalysis(this.curBlock)) {
                this.infosCycleUp.store(this.curBlock, new TapPair<BoolVector, BoolVector>(initLive.copy(), initLiveOnDiffPtr.copy()));
                this.infosWCycleUp.store(this.curBlock, new TapPair<BoolVector, BoolVector>(initOverwr.copy(), initOverwrOnDiffPtr.copy()));
            }
            if (this.curUnitInfos != null) {
                TapList<TapPair<BoolVector, BoolVector>> termBlockInfos = this.curUnitInfos.retrieve(this.curBlock);
                termBlockInfos.head = new TapPair<BoolVector, BoolVector>(initLive.copy(), initLiveOnDiffPtr.copy());
            }
            if (this.curUnitInfosW != null) {
                TapList<TapPair<BoolVector, BoolVector>> termBlockInfosW = this.curUnitInfosW.retrieve(this.curBlock);
                termBlockInfosW.head = new TapPair<BoolVector, BoolVector>(initOverwr.copy(), initOverwrOnDiffPtr.copy());
            }
        }
    }

    @Override
    protected void setEmptyCumulAndCycleValues() {
        this.infoTmp = null;
        this.infoTmpOnDiffPtr = null;
        this.infoTmpCycle = null;
        this.infoTmpCycleOnDiffPtr = null;
        this.infoWTmp = null;
        this.infoWTmpOnDiffPtr = null;
        this.infoWTmpCycle = null;
        this.infoWTmpCycleOnDiffPtr = null;
    }

    @Override
    protected boolean getValueFlowingBack() {
        Block destination = this.curArrow.destination;
        if (DiffLivenessAnalyzer.runSpecialCycleAnalysis(destination) && this.curArrow.finalCycle() == destination.enclosingLoop()) {
            this.additionalInfoPair = this.infosCycleUp.retrieve(destination);
            this.additionalInfoWPair = this.infosWCycleUp.retrieve(destination);
        } else {
            this.additionalInfoPair = this.infosUp.retrieve(destination);
            this.additionalInfoWPair = this.infosWUp.retrieve(destination);
        }
        if (this.additionalInfoPair == null) {
            return false;
        }
        this.additionalInfo = (BoolVector)this.additionalInfoPair.first;
        this.additionalInfoOnDiffPtr = (BoolVector)this.additionalInfoPair.second;
        this.additionalInfoW = (BoolVector)this.additionalInfoWPair.first;
        this.additionalInfoWOnDiffPtr = (BoolVector)this.additionalInfoWPair.second;
        if (this.curUnitActivities != null && this.checkActivityThroughArrow(this.curArrow)) {
            this.additionalInfo = this.additionalInfo.copy();
            this.setControllingLive(null, destination, this.additionalInfo, true);
        }
        if (this.traceCurAnalysis) {
            SymbolTable destSymbolTable = destination.symbolTable;
            int[] destMap = DiffLivenessAnalyzer.makeMap3(this.nSEZ, 0, destSymbolTable.declaredZonesNb(0));
            int[] destMapWithCtrl = DiffLivenessAnalyzer.makeMap3(this.nSEZ, this.nTZ, destSymbolTable.declaredZonesNb(0));
            int[] destMapOnDiffPtr = DiffLivenessAnalyzer.makeMap3(this.nSEPZ, 0, destSymbolTable.declaredZonesNb(3));
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace("   === Flowing back across " + this.curArrow);
            TapEnv.printlnOnTrace("    L:" + DiffLivenessAnalyzer.infoToStringWithDiffPtr(this.additionalInfo, destMapWithCtrl, this.additionalInfoOnDiffPtr, destMapOnDiffPtr, this.curUnit, destSymbolTable));
            TapEnv.printlnOnTrace("    W:" + DiffLivenessAnalyzer.infoToStringWithDiffPtr(this.additionalInfoW, destMap, this.additionalInfoWOnDiffPtr, destMapOnDiffPtr, this.curUnit, destSymbolTable));
        }
        return true;
    }

    @Override
    protected void initializeCumulValue() {
        this.infoTmp = new BoolVector(this.nSEZ + this.nTZ + this.nDZ);
        this.infoTmpOnDiffPtr = new BoolVector(this.nSEPZ + this.nDPZ);
        this.infoWTmp = new BoolVector(this.nSEZ + this.nDZ);
        this.infoWTmpOnDiffPtr = new BoolVector(this.nSEPZ + this.nDPZ);
    }

    @Override
    protected void cumulValueWithAdditional(SymbolTable commonSymbolTable) {
        if (this.infoTmp == null) {
            this.infoTmp = new BoolVector(this.nSEZ + this.nTZ + this.nDZ);
        }
        if (this.infoTmpOnDiffPtr == null) {
            this.infoTmpOnDiffPtr = new BoolVector(this.nSEPZ + this.nDPZ);
        }
        if (this.infoWTmp == null) {
            this.infoWTmp = new BoolVector(this.nSEZ + this.nDZ);
        }
        if (this.infoWTmpOnDiffPtr == null) {
            this.infoWTmpOnDiffPtr = new BoolVector(this.nSEPZ + this.nDPZ);
        }
        int commonLength = this.nSEZ + commonSymbolTable.declaredZonesNb(0);
        this.infoTmp.cumulOr(this.additionalInfo, commonLength + this.nTZ);
        this.infoWTmp.cumulOr(this.additionalInfoW, commonLength);
        int commonLengthOnDiffPtr = this.nSEPZ + commonSymbolTable.declaredZonesNb(3);
        this.infoTmpOnDiffPtr.cumulOr(this.additionalInfoOnDiffPtr, commonLengthOnDiffPtr);
        this.infoWTmpOnDiffPtr.cumulOr(this.additionalInfoWOnDiffPtr, commonLengthOnDiffPtr);
        if (this.phase == 1 || this.curArrow.destination != this.curUnit.exitBlock) {
            int i;
            for (i = commonLength; i < this.nSEZ + this.nDZ; ++i) {
                this.infoWTmp.set(i, true);
            }
            for (i = commonLengthOnDiffPtr; i < this.nSEPZ + this.nDPZ; ++i) {
                this.infoWTmpOnDiffPtr.set(i, true);
            }
        }
    }

    @Override
    protected void cumulCycleValueWithAdditional(SymbolTable commonSymbolTable) {
        if (this.infoTmpCycle == null) {
            this.infoTmpCycle = new BoolVector(this.nSEZ + this.nTZ + this.nDZ);
        }
        if (this.infoTmpCycleOnDiffPtr == null) {
            this.infoTmpCycleOnDiffPtr = new BoolVector(this.nSEPZ + this.nDPZ);
        }
        if (this.infoWTmpCycle == null) {
            this.infoWTmpCycle = new BoolVector(this.nSEZ + this.nDZ);
        }
        if (this.infoWTmpCycleOnDiffPtr == null) {
            this.infoWTmpCycleOnDiffPtr = new BoolVector(this.nSEPZ + this.nDPZ);
        }
        int commonLength = this.nSEZ + commonSymbolTable.declaredZonesNb(0);
        this.infoTmpCycle.cumulOr(this.additionalInfo, commonLength + this.nTZ);
        this.infoWTmpCycle.cumulOr(this.additionalInfoW, commonLength);
        int commonLengthOnDiffPtr = this.nSEPZ + commonSymbolTable.declaredZonesNb(3);
        this.infoTmpCycleOnDiffPtr.cumulOr(this.additionalInfoOnDiffPtr, commonLengthOnDiffPtr);
        this.infoWTmpCycleOnDiffPtr.cumulOr(this.additionalInfoWOnDiffPtr, commonLengthOnDiffPtr);
        if (this.phase == 1 || this.curArrow.destination != this.curUnit.exitBlock) {
            int i;
            for (i = commonLength; i < this.nSEZ + this.nDZ; ++i) {
                this.infoWTmpCycle.set(i, true);
            }
            for (i = commonLengthOnDiffPtr; i < this.nSEPZ + this.nDPZ; ++i) {
                this.infoWTmpCycleOnDiffPtr.set(i, true);
            }
        }
    }

    @Override
    protected boolean compareDownstreamValues() {
        boolean modified = this.compareWithStorage(this.infoTmp, this.infoTmpOnDiffPtr, this.infoTmpCycle, this.infoTmpCycleOnDiffPtr, DiffLivenessAnalyzer.mapSize(this.vectorMapWithCtrl), DiffLivenessAnalyzer.mapSize(this.pointerVectorMap), this.infosDown, this.infosCycleDown);
        boolean modifiedW = this.compareWithStorage(this.infoWTmp, this.infoWTmpOnDiffPtr, this.infoWTmpCycle, this.infoWTmpCycleOnDiffPtr, DiffLivenessAnalyzer.mapSize(this.vectorMap), DiffLivenessAnalyzer.mapSize(this.pointerVectorMap), this.infosWDown, this.infosWCycleDown);
        return modified || modifiedW;
    }

    @Override
    protected boolean compareUpstreamValues() {
        boolean modified = this.compareWithStorage(this.infoTmp, this.infoTmpOnDiffPtr, this.infoTmpCycle, this.infoTmpCycleOnDiffPtr, DiffLivenessAnalyzer.mapSize(this.vectorMapWithCtrl), DiffLivenessAnalyzer.mapSize(this.pointerVectorMap), this.infosUp, this.infosCycleUp);
        boolean modifiedW = this.compareWithStorage(this.infoWTmp, this.infoWTmpOnDiffPtr, this.infoWTmpCycle, this.infoWTmpCycleOnDiffPtr, DiffLivenessAnalyzer.mapSize(this.vectorMap), DiffLivenessAnalyzer.mapSize(this.pointerVectorMap), this.infosWUp, this.infosWCycleUp);
        return modified || modifiedW;
    }

    @Override
    protected boolean compareUpstreamChannelValuesWithInitial(TapList<Block> initBlocks) {
        boolean initHasIncreased = false;
        TapIntList allMessagePassingChannelZones = this.curCallGraph.getAllMessagePassingChannelZones();
        allMessagePassingChannelZones = new TapIntList(this.curCallGraph.zoneNbOfAllIOStreams, allMessagePassingChannelZones);
        while (initBlocks != null) {
            Block initBlock = (Block)initBlocks.head;
            TapIntList inAllChannelZones = allMessagePassingChannelZones;
            while (inAllChannelZones != null) {
                if (this.compareChannelZoneDataUpstream(inAllChannelZones.head, initBlock)) {
                    initHasIncreased = true;
                }
                inAllChannelZones = inAllChannelZones.tail;
            }
            initBlocks = initBlocks.tail;
        }
        return initHasIncreased;
    }

    @Override
    protected boolean compareChannelZoneDataUpstream(int mpZone, Block refBlock) {
        boolean result = false;
        BoolVector infoTmpCopy = this.infoTmp;
        if (DiffLivenessAnalyzer.runSpecialCycleAnalysis(this.curBlock)) {
            infoTmpCopy = this.infoTmp.copy();
            infoTmpCopy.cumulOr(this.infoTmpCycle);
        }
        int vectorIndex = this.zoneRkToVectorIndex(mpZone, 3, 0, this.vectorMapWithCtrl);
        BoolVector refInfo = (BoolVector)this.infosUp.retrieve((Block)refBlock).first;
        if (infoTmpCopy.get(vectorIndex) && !refInfo.get(vectorIndex)) {
            refInfo.set(vectorIndex, true);
            result = true;
        }
        return result;
    }

    @Override
    protected boolean propagateValuesBackwardThroughBlock() {
        return this.propagateAndStoreDiffLivenessThroughBlock(this.curBlock, null, null);
    }

    private boolean propagateAndStoreDiffLivenessThroughBlock(Block block, TapList<TapPair<BoolVector, BoolVector>> recordList, TapList<TapPair<BoolVector, BoolVector>> recordListW) {
        BoolVector afterReqX;
        int blockTestZone;
        if (this.traceCurAnalysis) {
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace("   === Going up through Block " + block + " ===");
        }
        boolean liveTest = (blockTestZone = block.testZone) != -1 && (this.infoTmp.getTest(blockTestZone, this.vectorMapWithCtrl) || this.infoTmpCycle != null && this.infoTmpCycle.getTest(blockTestZone, this.vectorMapWithCtrl));
        TapList<Instruction> instructions = block.instructions;
        TapList<BoolVector> blockReqXs = this.curUnitReqXs == null ? null : this.curUnitReqXs.retrieve(block);
        blockReqXs = TapList.reverse(blockReqXs);
        this.setUniqueAccessZones(block);
        Instruction initialDo = null;
        boolean runSpecialCycleAnalysis = DiffLivenessAnalyzer.runSpecialCycleAnalysis(block);
        Tree loopDoTree = null;
        ToBool arrives = new ToBool(true);
        ToBool arrivesC = new ToBool(true);
        boolean isLastInstr = true;
        if (runSpecialCycleAnalysis) {
            initialDo = (Instruction)instructions.head;
            if (initialDo != null) {
                loopDoTree = initialDo.tree;
            }
            instructions = instructions.tail;
        }
        if (this.traceCurAnalysis) {
            TapEnv.printlnOnTrace("    L:" + this.infoToStringWithDiffPtrWithCycle(this.infoTmp, this.vectorMapWithCtrl, this.infoTmpOnDiffPtr, this.pointerVectorMap, this.infoTmpCycle, this.infoTmpCycleOnDiffPtr));
            TapEnv.printlnOnTrace("    W:" + this.infoToStringWithDiffPtrWithCycle(this.infoWTmp, this.vectorMap, this.infoWTmpOnDiffPtr, this.pointerVectorMap, this.infoWTmpCycle, this.infoWTmpCycleOnDiffPtr));
        }
        if (recordList != null) {
            this.recordInfosInto(this.infoTmp, this.infoTmpCycle, this.infoTmpOnDiffPtr, this.infoTmpCycleOnDiffPtr, recordList);
        }
        if (recordListW != null) {
            this.recordInfosInto(this.infoWTmp, this.infoWTmpCycle, this.infoWTmpOnDiffPtr, this.infoWTmpCycleOnDiffPtr, recordListW);
        }
        instructions = TapList.reverse(instructions);
        while (instructions != null) {
            this.curInstruction = (Instruction)instructions.head;
            afterReqX = blockReqXs == null ? null : (BoolVector)blockReqXs.head;
            this.diffLivenessThroughExpression(this.curInstruction.tree, isLastInstr && liveTest, false, false, this.infoTmp, this.infoTmpOnDiffPtr, this.infoWTmp, this.infoWTmpOnDiffPtr, afterReqX, arrives);
            if (runSpecialCycleAnalysis && this.infoTmpCycle != null) {
                this.diffLivenessThroughExpression(this.curInstruction.tree, isLastInstr && liveTest, false, false, this.infoTmpCycle, this.infoTmpCycleOnDiffPtr, this.infoWTmpCycle, this.infoWTmpCycleOnDiffPtr, afterReqX, arrivesC);
            }
            if (this.traceCurAnalysis) {
                TapEnv.printlnOnTrace("  Now gone upstream across instruction:" + ILUtils.toString(this.curInstruction.tree));
                TapEnv.printlnOnTrace("    L:" + this.infoToStringWithDiffPtrWithCycle(this.infoTmp, this.vectorMapWithCtrl, this.infoTmpOnDiffPtr, this.pointerVectorMap, this.infoTmpCycle, this.infoTmpCycleOnDiffPtr));
                TapEnv.printlnOnTrace("    W:" + this.infoToStringWithDiffPtrWithCycle(this.infoWTmp, this.vectorMap, this.infoWTmpOnDiffPtr, this.pointerVectorMap, this.infoWTmpCycle, this.infoWTmpCycleOnDiffPtr));
            }
            if (recordList != null) {
                this.recordInfosInto(this.infoTmp, this.infoTmpCycle, this.infoTmpOnDiffPtr, this.infoTmpCycleOnDiffPtr, recordList);
            }
            if (recordListW != null) {
                this.recordInfosInto(this.infoWTmp, this.infoWTmpCycle, this.infoWTmpOnDiffPtr, this.infoWTmpCycleOnDiffPtr, recordListW);
            }
            isLastInstr = false;
            instructions = instructions.tail;
            if (blockReqXs == null) continue;
            blockReqXs = blockReqXs.tail;
        }
        BoolVector boolVector = afterReqX = blockReqXs == null ? null : (BoolVector)blockReqXs.head;
        if (initialDo != null) {
            this.curInstruction = initialDo;
            this.diffLivenessThroughExpression(loopDoTree, isLastInstr && liveTest, false, false, this.infoTmp, this.infoTmpOnDiffPtr, this.infoWTmp, this.infoWTmpOnDiffPtr, afterReqX, arrives);
            if (runSpecialCycleAnalysis && this.infoTmpCycle != null) {
                this.diffLivenessThroughExpression(loopDoTree, isLastInstr && liveTest, false, false, this.infoTmpCycle, this.infoTmpCycleOnDiffPtr, this.infoWTmpCycle, this.infoWTmpCycleOnDiffPtr, afterReqX, arrivesC);
            }
        }
        BoolVector infoTmpCycleUp = null;
        BoolVector infoTmpCycleUpOnDiffPtr = null;
        BoolVector infoWTmpCycleUp = null;
        BoolVector infoWTmpCycleUpOnDiffPtr = null;
        if (runSpecialCycleAnalysis) {
            TapIntList localizedZones = this.curSymbolTable.getDeclaredKindZones(((HeaderBlock)block).localizedZones, 0, true);
            TapIntList localizedZonesOnDiffPtr = this.curSymbolTable.getDeclaredKindZones(((HeaderBlock)block).localizedZones, 3, true);
            if (this.infoTmpCycle != null) {
                infoTmpCycleUp = this.infoTmpCycle.copy();
                infoTmpCycleUp.setDeclared(localizedZones, this.vectorMapWithCtrl, false);
            } else {
                infoTmpCycleUp = new BoolVector(DiffLivenessAnalyzer.mapSize(this.vectorMapWithCtrl));
            }
            if (this.infoTmpCycleOnDiffPtr != null) {
                infoTmpCycleUpOnDiffPtr = this.infoTmpCycleOnDiffPtr.copy();
                infoTmpCycleUpOnDiffPtr.setDeclared(localizedZonesOnDiffPtr, this.pointerVectorMap, false);
            } else {
                infoTmpCycleUpOnDiffPtr = new BoolVector(DiffLivenessAnalyzer.mapSize(this.pointerVectorMap));
            }
            if (this.infoWTmpCycle != null) {
                infoWTmpCycleUp = this.infoWTmpCycle.copy();
                infoWTmpCycleUp.setDeclared(localizedZones, this.vectorMap, false);
            } else {
                infoWTmpCycleUp = new BoolVector(DiffLivenessAnalyzer.mapSize(this.vectorMap));
            }
            if (this.infoWTmpCycleOnDiffPtr != null) {
                infoWTmpCycleUpOnDiffPtr = this.infoWTmpCycleOnDiffPtr.copy();
                infoWTmpCycleUpOnDiffPtr.setDeclared(localizedZonesOnDiffPtr, this.pointerVectorMap, false);
            } else {
                infoWTmpCycleUpOnDiffPtr = new BoolVector(DiffLivenessAnalyzer.mapSize(this.pointerVectorMap));
            }
            if (this.infoTmp != null) {
                infoTmpCycleUp.cumulOr(this.infoTmp);
            }
            if (this.infoTmpOnDiffPtr != null) {
                infoTmpCycleUpOnDiffPtr.cumulOr(this.infoTmpOnDiffPtr);
            }
            if (this.infoWTmp != null) {
                infoWTmpCycleUp.cumulOr(this.infoWTmp);
            }
            if (this.infoWTmpOnDiffPtr != null) {
                infoWTmpCycleUpOnDiffPtr.cumulOr(this.infoWTmpOnDiffPtr);
            }
            if (this.infoTmp != null) {
                if (this.infoTmpCycle == null) {
                    this.infoTmpCycle = new BoolVector(DiffLivenessAnalyzer.mapSize(this.vectorMapWithCtrl));
                }
                this.infoTmpCycle.cumulOr(this.infoTmp.and(this.directEntryExitMask((HeaderBlock)block, this.vectorMapWithCtrl, 0)));
            }
            this.infoTmp = this.infoTmpCycle;
            if (this.infoTmpOnDiffPtr != null) {
                if (this.infoTmpCycleOnDiffPtr == null) {
                    this.infoTmpCycleOnDiffPtr = new BoolVector(DiffLivenessAnalyzer.mapSize(this.pointerVectorMap));
                }
                this.infoTmpCycleOnDiffPtr.cumulOr(this.infoTmpOnDiffPtr.and(this.directEntryExitMask((HeaderBlock)block, this.pointerVectorMap, 3)));
            }
            this.infoTmpOnDiffPtr = this.infoTmpCycleOnDiffPtr;
            if (this.infoWTmp != null) {
                if (this.infoWTmpCycle == null) {
                    this.infoWTmpCycle = new BoolVector(DiffLivenessAnalyzer.mapSize(this.vectorMap));
                }
                this.infoWTmpCycle.cumulOr(this.infoWTmp.and(this.directEntryExitMask((HeaderBlock)block, this.vectorMap, 0)));
            }
            this.infoWTmp = this.infoWTmpCycle;
            if (this.infoWTmpOnDiffPtr != null) {
                if (this.infoWTmpCycleOnDiffPtr == null) {
                    this.infoWTmpCycleOnDiffPtr = new BoolVector(DiffLivenessAnalyzer.mapSize(this.pointerVectorMap));
                }
                this.infoWTmpCycleOnDiffPtr.cumulOr(this.infoWTmpOnDiffPtr.and(this.directEntryExitMask((HeaderBlock)block, this.pointerVectorMap, 3)));
            }
            this.infoWTmp = this.infoWTmpCycle;
        }
        this.infoTmpCycle = infoTmpCycleUp;
        this.infoTmpCycleOnDiffPtr = infoTmpCycleUpOnDiffPtr;
        this.infoWTmpCycle = infoWTmpCycleUp;
        this.infoWTmpCycleOnDiffPtr = infoWTmpCycleUpOnDiffPtr;
        if (initialDo != null) {
            ToBool total = new ToBool(false);
            TapIntList indexZones = this.curSymbolTable.listOfZonesOfValue(loopDoTree.down(3).down(1), total, initialDo);
            if (total.get()) {
                this.infoTmp.setDeclared(indexZones, this.vectorMapWithCtrl, false);
                if (this.infoTmpCycle != null) {
                    this.infoTmpCycle.setDeclared(indexZones, this.vectorMapWithCtrl, false);
                }
            }
            this.infoWTmp.setDeclared(indexZones, this.vectorMap, true);
            this.diffLivenessThroughExpression(loopDoTree.down(3).down(2), isLastInstr && liveTest, false, false, this.infoTmp, this.infoTmpOnDiffPtr, this.infoWTmp, this.infoWTmpOnDiffPtr, afterReqX, arrives);
            if (this.traceCurAnalysis) {
                TapEnv.printlnOnTrace("  Now gone upstream across initial DO:" + ILUtils.toString(loopDoTree));
                TapEnv.printlnOnTrace("    L:" + this.infoToStringWithDiffPtrWithCycle(this.infoTmp, this.vectorMapWithCtrl, this.infoTmpOnDiffPtr, this.pointerVectorMap, this.infoTmpCycle, this.infoTmpCycleOnDiffPtr));
                TapEnv.printlnOnTrace("    W:" + this.infoToStringWithDiffPtrWithCycle(this.infoWTmp, this.vectorMap, this.infoWTmpOnDiffPtr, this.pointerVectorMap, this.infoWTmpCycle, this.infoWTmpCycleOnDiffPtr));
            }
            if (recordList != null) {
                this.recordInfosInto(this.infoTmp, this.infoTmpCycle, this.infoTmpOnDiffPtr, this.infoTmpCycleOnDiffPtr, recordList);
            }
            if (recordListW != null) {
                this.recordInfosInto(this.infoWTmp, this.infoWTmpCycle, this.infoWTmpOnDiffPtr, this.infoWTmpCycleOnDiffPtr, recordListW);
            }
        }
        if (!TapEnv.removeDeadControl() && this.curBlock.isControl() && this.curBlock.lastInstr() != null) {
            DiffLivenessAnalyzer.setTreeRequiredInDiff(this.curActivity, this.curBlock.lastInstr().tree, this.phase == 0);
        }
        this.curInstruction = null;
        return true;
    }

    private void recordInfosInto(BoolVector info, BoolVector infoCycle, BoolVector infoOnDiffPtr, BoolVector infoCycleOnDiffPtr, TapList<TapPair<BoolVector, BoolVector>> record) {
        BoolVector recordInfo = info.copy();
        if (infoCycle != null) {
            recordInfo.cumulOr(infoCycle);
        }
        BoolVector recordInfoOnDiffPtr = infoOnDiffPtr.copy();
        if (infoCycleOnDiffPtr != null) {
            recordInfoOnDiffPtr.cumulOr(infoCycleOnDiffPtr);
        }
        record.tail = new TapList<TapPair<BoolVector, BoolVector>>(new TapPair<BoolVector, BoolVector>(recordInfo, recordInfoOnDiffPtr), record.tail);
    }

    @Override
    protected void terminateFGForBlock() {
        TapList<Object> toInfos = new TapList<Object>(null, null);
        TapList<Object> toInfosW = new TapList<Object>(null, null);
        this.infoTmp = (BoolVector)this.infosDown.retrieve((Block)this.curBlock).first;
        this.infoTmpOnDiffPtr = (BoolVector)this.infosDown.retrieve((Block)this.curBlock).second;
        this.infoWTmp = (BoolVector)this.infosWDown.retrieve((Block)this.curBlock).first;
        this.infoWTmpOnDiffPtr = (BoolVector)this.infosWDown.retrieve((Block)this.curBlock).second;
        if (this.infoTmp == null) {
            this.infoTmp = new BoolVector(DiffLivenessAnalyzer.mapSize(this.vectorMapWithCtrl));
        }
        if (this.infoTmpOnDiffPtr == null) {
            this.infoTmpOnDiffPtr = new BoolVector(DiffLivenessAnalyzer.mapSize(this.pointerVectorMap));
        }
        if (this.infoWTmp == null) {
            this.infoWTmp = new BoolVector(DiffLivenessAnalyzer.mapSize(this.vectorMap));
        }
        if (this.infoWTmpOnDiffPtr == null) {
            this.infoWTmpOnDiffPtr = new BoolVector(DiffLivenessAnalyzer.mapSize(this.pointerVectorMap));
        }
        if (DiffLivenessAnalyzer.runSpecialCycleAnalysis(this.curBlock)) {
            this.infoTmpCycle = (BoolVector)this.infosCycleDown.retrieve((Block)this.curBlock).first;
            this.infoTmpCycleOnDiffPtr = (BoolVector)this.infosCycleDown.retrieve((Block)this.curBlock).second;
            this.infoWTmpCycle = (BoolVector)this.infosWCycleDown.retrieve((Block)this.curBlock).first;
            this.infoWTmpCycleOnDiffPtr = (BoolVector)this.infosWCycleDown.retrieve((Block)this.curBlock).second;
        } else {
            this.infoTmpCycle = null;
            this.infoTmpCycleOnDiffPtr = null;
            this.infoWTmpCycle = null;
            this.infoWTmpCycleOnDiffPtr = null;
        }
        this.propagateAndStoreDiffLivenessThroughBlock(this.curBlock, toInfos, toInfosW);
        this.curUnitInfos.store(this.curBlock, toInfos.tail);
        this.curUnitInfosW.store(this.curBlock, toInfosW.tail);
    }

    @Override
    protected void terminateTermBlock() {
        TapList<TapPair<BoolVector, BoolVector>> toLastInfoW;
        TapList<TapPair<BoolVector, BoolVector>> termBlockInfosW;
        TapList<TapPair<BoolVector, BoolVector>> toLastInfo;
        boolean hasCyclingInfo = DiffLivenessAnalyzer.runSpecialCycleAnalysis(this.curBlock);
        TapList<TapPair<BoolVector, BoolVector>> termBlockInfos = this.curUnitInfos.retrieve(this.curBlock);
        if (termBlockInfos == null) {
            termBlockInfos = new TapList<Object>(null, new TapList<Object>(null, null));
            this.curUnitInfos.store(this.curBlock, termBlockInfos);
        }
        if ((toLastInfo = TapList.toLast(termBlockInfos)) != null) {
            TapPair<BoolVector, BoolVector> exitInfoPair = this.infosDown.retrieve(this.curBlock);
            BoolVector termInfo = exitInfoPair == null ? null : (BoolVector)exitInfoPair.first;
            BoolVector termInfoOnDiffPtr = exitInfoPair == null ? null : (BoolVector)exitInfoPair.second;
            termInfo = termInfo == null ? new BoolVector(DiffLivenessAnalyzer.mapSize(this.vectorMapWithCtrl)) : termInfo.copy();
            termInfoOnDiffPtr = termInfoOnDiffPtr == null ? new BoolVector(DiffLivenessAnalyzer.mapSize(this.pointerVectorMap)) : termInfoOnDiffPtr.copy();
            if (hasCyclingInfo) {
                BoolVector termCycleInfoOnDiffPtr;
                BoolVector termCycleInfo;
                exitInfoPair = this.infosCycleDown.retrieve(this.curBlock);
                BoolVector boolVector = termCycleInfo = exitInfoPair == null ? null : (BoolVector)exitInfoPair.first;
                if (termCycleInfo != null) {
                    termInfo.cumulOr(termCycleInfo);
                }
                BoolVector boolVector2 = termCycleInfoOnDiffPtr = exitInfoPair == null ? null : (BoolVector)exitInfoPair.second;
                if (termCycleInfoOnDiffPtr != null) {
                    termInfoOnDiffPtr.cumulOr(termCycleInfoOnDiffPtr);
                }
            }
            toLastInfo.head = new TapPair<BoolVector, BoolVector>(termInfo, termInfoOnDiffPtr);
        }
        if ((termBlockInfosW = this.curUnitInfosW.retrieve(this.curBlock)) == null) {
            termBlockInfosW = new TapList<Object>(null, new TapList<Object>(null, null));
            this.curUnitInfosW.store(this.curBlock, termBlockInfosW);
        }
        if ((toLastInfoW = TapList.toLast(termBlockInfosW)) != null) {
            TapPair<BoolVector, BoolVector> exitInfoWPair = this.infosWDown.retrieve(this.curBlock);
            BoolVector termInfoW = exitInfoWPair == null ? null : (BoolVector)exitInfoWPair.first;
            BoolVector termInfoWOnDiffPtr = exitInfoWPair == null ? null : (BoolVector)exitInfoWPair.second;
            termInfoW = termInfoW == null ? new BoolVector(DiffLivenessAnalyzer.mapSize(this.vectorMap)) : termInfoW.copy();
            termInfoWOnDiffPtr = termInfoWOnDiffPtr == null ? new BoolVector(DiffLivenessAnalyzer.mapSize(this.pointerVectorMap)) : termInfoWOnDiffPtr.copy();
            if (hasCyclingInfo) {
                BoolVector termCycleInfoWOnDiffPtr;
                BoolVector termCycleInfoW;
                exitInfoWPair = this.infosWCycleDown.retrieve(this.curBlock);
                BoolVector boolVector = termCycleInfoW = exitInfoWPair == null ? null : (BoolVector)exitInfoWPair.first;
                if (termCycleInfoW != null) {
                    termInfoW.cumulOr(termCycleInfoW);
                }
                BoolVector boolVector3 = termCycleInfoWOnDiffPtr = exitInfoWPair == null ? null : (BoolVector)exitInfoWPair.second;
                if (termCycleInfoWOnDiffPtr != null) {
                    termInfoWOnDiffPtr.cumulOr(termCycleInfoWOnDiffPtr);
                }
            }
            toLastInfoW.head = new TapPair<BoolVector, BoolVector>(termInfoW, termInfoWOnDiffPtr);
        }
    }

    @Override
    protected boolean terminateUnit() {
        this.curUnitInfos.store(this.curUnit.entryBlock, new TapList<TapPair<BoolVector, BoolVector>>(this.infosDown.retrieve(this.curUnit.entryBlock), null));
        this.curUnitInfos.store(this.curUnit.exitBlock, new TapList<TapPair<BoolVector, BoolVector>>(this.infosUp.retrieve(this.curUnit.exitBlock), null));
        this.curUnitInfosW.store(this.curUnit.entryBlock, new TapList<TapPair<BoolVector, BoolVector>>(this.infosWDown.retrieve(this.curUnit.entryBlock), null));
        this.curUnitInfosW.store(this.curUnit.exitBlock, new TapList<TapPair<BoolVector, BoolVector>>(this.infosWUp.retrieve(this.curUnit.exitBlock), null));
        return false;
    }

    public TapPair<BoolVector, BoolVector> getFrontierLiveness(TapList<FGArrow> frontier) {
        int resNSEZ = this.curUnit.sideEffectZonesNb(0);
        int resNSEPZ = this.curUnit.sideEffectZonesNb(3);
        int resNTZ = this.curUnit.testZonesNb();
        int resNDZ = DiffLivenessAnalyzer.commonNDZofFrontierOrigins(frontier, 0);
        int resNDPZ = DiffLivenessAnalyzer.commonNDZofFrontierOrigins(frontier, 3);
        BoolVector result = new BoolVector(resNSEZ + resNTZ + resNDZ);
        this.getFrontierInfo(frontier, this.curUnitInfos, result, resNSEZ + resNTZ, false);
        result.move(resNSEZ + resNTZ, resNSEZ, resNDZ);
        result.resize(resNSEZ + resNDZ);
        BoolVector resultOnDiffPtr = new BoolVector(resNSEPZ + resNDPZ);
        this.getFrontierInfo(frontier, this.curUnitInfos, resultOnDiffPtr, resNSEPZ, true);
        return new TapPair<BoolVector, BoolVector>(result, resultOnDiffPtr);
    }

    public TapPair<BoolVector, BoolVector> getFrontierOverwrite(TapList<FGArrow> frontier) {
        int resNSEZ = this.curUnit.sideEffectZonesNb(0);
        int resNSEPZ = this.curUnit.sideEffectZonesNb(3);
        int resNDZ = DiffLivenessAnalyzer.commonNDZofFrontierOrigins(frontier, 0);
        int resNDPZ = DiffLivenessAnalyzer.commonNDZofFrontierOrigins(frontier, 3);
        BoolVector result = new BoolVector(resNSEZ + resNDZ);
        this.getFrontierInfo(frontier, this.curUnitInfosW, result, resNSEZ, false);
        BoolVector resultOnDiffPtr = new BoolVector(resNSEPZ + resNDPZ);
        this.getFrontierInfo(frontier, this.curUnitInfosW, resultOnDiffPtr, resNSEPZ, true);
        return new TapPair<BoolVector, BoolVector>(result, resultOnDiffPtr);
    }

    private void getFrontierInfo(TapList<FGArrow> frontier, BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> infos, BoolVector result, int offset, boolean onDiffPtr) {
        while (frontier != null) {
            FGArrow arrow = (FGArrow)frontier.head;
            int commonLength = offset + arrow.commonSymbolTable().declaredZonesNb(onDiffPtr ? 3 : 0);
            TapPair infoPair = (TapPair)infos.retrieve((Block)arrow.destination).head;
            result.cumulOr(onDiffPtr ? (BoolVector)infoPair.second : (BoolVector)infoPair.first, commonLength);
            frontier = frontier.tail;
        }
    }

    private void diffLivenessThroughExpression(Tree tree, boolean needVal, boolean needLoc, boolean needDiff, BoolVector diffLives, BoolVector diffLivesOnDiffPtr, BoolVector diffOwrts, BoolVector diffOwrtsOnDiffPtr, BoolVector afterReqX, ToBool arrives) {
        WrapperTypeSpec assignedType;
        String unaryOper;
        Tree assignedTree = null;
        Tree rhsTree = null;
        if (tree.opCode() == 13 || tree.opCode() == 147 || tree.opCode() == 123) {
            assignedTree = tree.down(1);
            rhsTree = tree.down(2);
        } else if (tree.opCode() == 189 && (unaryOper = ILUtils.getIdentString(tree.down(1))) != null && (unaryOper.equals("++prefix") || unaryOper.equals("++postfix") || unaryOper.equals("--prefix") || unaryOper.equals("--postfix"))) {
            assignedTree = tree.down(2);
        }
        if (assignedTree != null && (assignedType = this.curSymbolTable.typeOf(assignedTree)) != null && assignedType.containsAPointer()) {
            TapIntList assignedZonesList = ZoneInfo.listAllZones(this.curSymbolTable.treeOfZonesOfValue(assignedTree, null, this.curInstruction, null), true);
            if (afterReqX == null || DiffLivenessAnalyzer.intersectsExtendedDeclared(afterReqX, this.vectorMap, 0, assignedZonesList, null, this.curSymbolTable, null)) {
                this.setControllingLive(this.curInstruction, this.curBlock, diffLives, true);
                this.diffLivenessThroughPointerExpression(assignedTree, diffLives, diffOwrts);
                if (rhsTree != null) {
                    this.diffLivenessThroughPointerExpression(rhsTree, diffLives, diffOwrts);
                }
            }
        }
        switch (tree.opCode()) {
            case 13: 
            case 62: 
            case 123: 
            case 147: 
            case 185: {
                boolean needDiffSon;
                Tree lhs = tree.down(1);
                ToBool lhsTotal = new ToBool(false);
                TapList<?> writtenZonesTree = this.curSymbolTable.treeOfZonesOfValue(lhs, lhsTotal, this.curInstruction, null);
                boolean totalAccess = this.referenceIsTotal(lhsTotal.get(), writtenZonesTree) && tree.opCode() == 13 && (!this.inADeclaration || !this.curUnit.isFortran());
                TapIntList writtenZonesList = ZoneInfo.listAllZones(writtenZonesTree, true);
                boolean needValSon = DiffLivenessAnalyzer.intersectsExtendedDeclared(diffLives, this.vectorMapWithCtrl, 0, writtenZonesList, null, this.curSymbolTable, null);
                if (!needValSon && tree.down(2).opCode() == 4) {
                    needValSon = true;
                }
                int[] diffVectorMap = DataFlowAnalyzer.makeMap3(this.curUnit.sideEffectZonesNb(TapEnv.diffKind()), 0, this.curSymbolTable.declaredZonesNb(TapEnv.diffKind()));
                TapIntList writtenDiffKindVectorIndices = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(writtenZonesList, TapEnv.diffKind(), diffVectorMap, this.curSymbolTable, null);
                TapList<ZoneInfo> zones = DataFlowAnalyzer.mapExtendedDeclaredToZoneInfo(writtenZonesList, this.curSymbolTable, null);
                boolean bl = needDiffSon = (ADActivityAnalyzer.isAnnotatedActive(this.curActivity, lhs, this.curSymbolTable) || writtenDiffKindVectorIndices != null && (TapEnv.dbadMode() == -1 || !TapEnv.spareDiffReinitializations() && ADActivityAnalyzer.haveDifferentiatedVariable(zones))) && (this.adActivityAnalyzer == null || !DiffLivenessAnalyzer.trivialIdentDiff(this.curActivity, tree, this.curSymbolTable));
                if (needValSon) {
                    DiffLivenessAnalyzer.setTreeRequiredInDiff(this.curActivity, tree, this.phase == 0);
                    this.setRefValue(lhs, 0, diffOwrts, this.vectorMap, true, true);
                }
                if (needValSon || needDiffSon) {
                    this.setControllingLive(this.curInstruction, this.curBlock, diffLives, true);
                }
                this.diffLivenessThroughExpression(lhs, needValSon, needLoc, needValSon || needDiffSon, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                if (needValSon && totalAccess) {
                    this.setRefValue(lhs, 0, diffLives, this.vectorMapWithCtrl, false, false);
                }
                this.diffLivenessThroughExpression(tree.down(2), needVal || needValSon, needLoc, needDiffSon, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                break;
            }
            case 163: {
                this.diffLivenessThroughExpression(tree.down(2), true, true, false, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                if (ILUtils.isNullOrNone(tree.down(1))) break;
                String returnVarName = this.curUnit.otherReturnVar() == null ? this.curUnit.name : this.curUnit.otherReturnVar().symbol;
                Tree assignTree = ILUtils.turnReturnIntoAssign(tree, returnVarName);
                boolean activeResult = ADActivityAnalyzer.isAnnotatedActive(this.curActivity, assignTree.down(2), this.curSymbolTable);
                if (activeResult) {
                    ADActivityAnalyzer.setAnnotatedActive(this.curActivity, assignTree.down(1));
                }
                this.diffLivenessThroughExpression(assignTree, false, false, activeResult, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                ILUtils.resetReturnFromAssign(tree, assignTree);
                DiffLivenessAnalyzer.copyTreeRequiredInDiff(this.curActivity, assignTree, tree);
                break;
            }
            case 2: 
            case 41: 
            case 177: {
                this.diffLivenessThroughExpression(tree.down(1), needVal, needLoc, needDiff, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                this.diffLivenessThroughExpression(tree.down(2), needVal, needLoc, needDiff, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                break;
            }
            case 124: 
            case 131: {
                boolean needValSon = needVal || needDiff && ADActivityAnalyzer.isAnnotatedActive(this.curActivity, tree.down(2), this.curSymbolTable);
                boolean needDiffSon = needDiff && ADActivityAnalyzer.isAnnotatedActive(this.curActivity, tree.down(1), this.curSymbolTable);
                this.diffLivenessThroughExpression(tree.down(1), needValSon, needLoc, needDiffSon, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                needValSon = needVal || needDiff && ADActivityAnalyzer.isAnnotatedActive(this.curActivity, tree.down(1), this.curSymbolTable);
                needDiffSon = needDiff && ADActivityAnalyzer.isAnnotatedActive(this.curActivity, tree.down(2), this.curSymbolTable);
                this.diffLivenessThroughExpression(tree.down(2), needValSon, needLoc, needDiffSon, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                break;
            }
            case 61: {
                boolean needValSon = needVal || needDiff && ADActivityAnalyzer.isAnnotatedActive(this.curActivity, tree.down(2), this.curSymbolTable);
                boolean needDiffSon = needDiff && ADActivityAnalyzer.isAnnotatedActive(this.curActivity, tree.down(1), this.curSymbolTable);
                this.diffLivenessThroughExpression(tree.down(1), needValSon, needLoc, needDiffSon, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                needValSon = needVal || needDiff && ADActivityAnalyzer.isAnnotatedActive(this.curActivity, tree, this.curSymbolTable);
                this.diffLivenessThroughExpression(tree.down(2), needValSon, needLoc, needDiff, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                break;
            }
            case 152: {
                boolean needValSon = needVal || needDiff && ADActivityAnalyzer.isAnnotatedActive(this.curActivity, tree, this.curSymbolTable);
                this.diffLivenessThroughExpression(tree.down(1), needValSon, needLoc, needDiff, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                this.diffLivenessThroughExpression(tree.down(2), needValSon, needLoc, needDiff, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                break;
            }
            case 122: 
            case 171: {
                this.diffLivenessThroughExpression(tree.down(1), needVal, needLoc, needDiff, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                break;
            }
            case 137: 
            case 184: 
            case 191: 
            case 201: {
                this.diffLivenessThroughExpression(tree.down(1), needVal, needLoc, false, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                break;
            }
            case 39: {
                diffLives.setTest(this.curBlock.testZone, this.vectorMapWithCtrl, false);
                if (needVal) {
                    DiffLivenessAnalyzer.setTreeRequiredInDiff(this.curActivity, tree, this.phase == 0);
                    this.setControllingLive(this.curInstruction, this.curBlock, diffLives, true);
                }
                this.diffLivenessThroughExpression(tree.down(2), needVal, needLoc, false, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                break;
            }
            case 92: 
            case 96: 
            case 179: 
            case 200: {
                diffLives.setTest(this.curBlock.testZone, this.vectorMapWithCtrl, false);
                if (needVal) {
                    DiffLivenessAnalyzer.setTreeRequiredInDiff(this.curActivity, tree, this.phase == 0);
                    this.setControllingLive(this.curInstruction, this.curBlock, diffLives, true);
                }
                this.diffLivenessThroughExpression(tree.down(1), needVal, needLoc, false, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                break;
            }
            case 77: {
                this.diffLivenessThroughExpression(tree.down(1), needVal, needLoc, needDiff, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                this.diffLivenessThroughExpression(tree.down(2), needVal, needLoc, needDiff, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                this.diffLivenessThroughExpression(tree.down(3), needVal, needLoc, needDiff, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                break;
            }
            case 97: {
                boolean needValSon = needVal || needDiff && ADActivityAnalyzer.isAnnotatedActive(this.curActivity, tree, this.curSymbolTable);
                this.diffLivenessThroughExpression(tree.down(1), needValSon, needLoc, false, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                this.diffLivenessThroughExpression(tree.down(2), needVal, needLoc, needDiff, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                this.diffLivenessThroughExpression(tree.down(3), needVal, needLoc, needDiff, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                break;
            }
            case 5: 
            case 17: 
            case 21: 
            case 23: 
            case 42: 
            case 67: 
            case 90: 
            case 93: 
            case 113: 
            case 114: 
            case 120: 
            case 135: 
            case 141: 
            case 164: 
            case 202: {
                this.diffLivenessThroughExpression(tree.down(1), needVal, needLoc, false, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                this.diffLivenessThroughExpression(tree.down(2), needVal, needLoc, false, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                break;
            }
            case 30: {
                TapList[] diffArgsNeeded;
                boolean diffCallPresent;
                int i;
                Context calledContext;
                BoolVector inputPublicDiffLivenessOnDiffPtr;
                BoolVector inputPublicDiffLiveness;
                boolean origCallPresent;
                ActivityPattern curCalledActivity = (ActivityPattern)ActivityPattern.getAnnotationForActivityPattern(tree, this.curActivity, "multiActivityCalleePatterns");
                Unit calledUnit = DiffLivenessAnalyzer.getCalledUnit(tree, this.curSymbolTable);
                MPIcallInfo messagePassingInfo = MPIcallInfo.getMessagePassingMPIcallInfo(calledUnit.name, tree, this.curUnit.language(), this.curBlock);
                boolean mpiOrigCallPresent = messagePassingInfo != null;
                boolean mpiDiffCallPresent = messagePassingInfo != null && messagePassingInfo.isNonBlocking();
                CallArrow arrow = CallGraph.getCallArrow(this.curUnit, calledUnit);
                Tree[] argTrees = ILUtils.getArguments(tree).children();
                BoolMatrix calleePublicDeps = calledUnit.unitDependencies;
                if (calleePublicDeps == null) {
                    calleePublicDeps = DepsAnalyzer.buildDefaultIntrinsicDependencies(calledUnit);
                }
                boolean thisCallCheckpointed = TapEnv.modeIsAdjoint() && this.curInstruction.hasDirective(12) == null && calledUnit.hasDirective(12) == null;
                BoolVector diffLivesDown = diffLives.copy();
                BoolVector outputPublicDiffLiveness = this.propagateExitDataBwdToCallee(diffLives, this.vectorMapWithCtrl, new TapList<Boolean>(needVal, null), null, arrow, argTrees, 0, true, null, false, false);
                BoolVector outputPublicDiffLivenessOnDiffPtr = this.propagateExitDataBwdToCallee(diffLivesOnDiffPtr, this.pointerVectorMap, new TapList<Boolean>(Boolean.FALSE, null), null, arrow, argTrees, 3, true, null, false, false);
                BoolVector outputPublicDiffOverwrite = this.propagateExitDataBwdToCallee(diffOwrts.copy(), this.vectorMap, new TapList<Boolean>(Boolean.FALSE, null), null, arrow, argTrees, 0, true, null, false, false);
                BoolVector outputPublicDiffOverwriteOnDiffPtr = this.propagateExitDataBwdToCallee(diffOwrtsOnDiffPtr.copy(), this.pointerVectorMap, new TapList<Boolean>(Boolean.FALSE, null), null, arrow, argTrees, 3, true, null, false, false);
                boolean bl = origCallPresent = mpiOrigCallPresent || calleePublicDeps != null && this.someOutputIsLive(outputPublicDiffLiveness, calleePublicDeps);
                if (calleePublicDeps != null) {
                    BoolVector notKilled = calledUnit.unitInOutN.or(calledUnit.unitInOutR);
                    inputPublicDiffLiveness = outputPublicDiffLiveness.and(notKilled);
                    inputPublicDiffLivenessOnDiffPtr = outputPublicDiffLivenessOnDiffPtr.and(notKilled);
                } else {
                    inputPublicDiffLiveness = new BoolVector(arrow.translator.length);
                    inputPublicDiffLivenessOnDiffPtr = new BoolVector(arrow.translator.length);
                    if (arrives != null) {
                        arrives.set(false);
                    }
                }
                TapList[] argsZones = new TapList[argTrees.length];
                for (int i2 = argTrees.length - 1; i2 >= 0; --i2) {
                    argsZones[i2] = TapList.copyTree(this.curSymbolTable.treeOfZonesOfValue(argTrees[i2], null, this.curInstruction, null));
                    this.includePointedElementsInTree(argsZones[i2], null, null, true, false, true);
                }
                Context context = calledContext = curCalledActivity == null ? null : curCalledActivity.diffLivenessTopDownContext();
                if (!thisCallCheckpointed && calledUnit.rank() >= 0 && calledUnit.hasSource() && curCalledActivity != null) {
                    if (TapList.contains(this.tracedUnits, calledUnit)) {
                        int[] calledUnitPublicMap = new int[]{0, calledUnit.paramElemsNb()};
                        String calledUnitPublicMapName = "[x" + calledUnit.rank() + ":a]";
                        TapEnv.printOnTrace(" Call to " + calledUnit + " receives new liveness:" + calledUnitPublicMapName + " " + outputPublicDiffLiveness.toString(calledUnitPublicMap) + " Ptr:" + outputPublicDiffLivenessOnDiffPtr.toString(calledUnitPublicMap));
                        TapEnv.printOnTrace("               and also receives new overwrite:" + calledUnitPublicMapName + " " + outputPublicDiffOverwrite.toString(calledUnitPublicMap) + " Ptr:" + outputPublicDiffOverwriteOnDiffPtr.toString(calledUnitPublicMap));
                    }
                    curCalledActivity.exitDiffLivenesses().cumulOr(outputPublicDiffLiveness);
                    curCalledActivity.exitDiffLivenessesOnDiffPtr().cumulOr(outputPublicDiffLivenessOnDiffPtr);
                    calledContext.addNockpExitLiveness(outputPublicDiffLiveness, outputPublicDiffLivenessOnDiffPtr);
                    curCalledActivity.exitDiffOverwrites().cumulOr(outputPublicDiffOverwrite);
                    curCalledActivity.exitDiffOverwritesOnDiffPtr().cumulOr(outputPublicDiffOverwriteOnDiffPtr);
                    calledContext.addNockpExitOverwrite(outputPublicDiffOverwrite, outputPublicDiffOverwriteOnDiffPtr);
                    if (calledContext.nockpOutOfDate) {
                        calledUnit.analysisIsOutOfDate = true;
                        this.setAllCallersOutOfDateUpto(calledUnit, this.curUnit);
                        if (calledContext.nockpExitOverwrite == null) {
                            calledContext.nockpExitOverwrite = new BoolVector(calledContext.shapeLength);
                        }
                        if (calledContext.nockpExitOverwriteOnDiffPtr == null) {
                            calledContext.nockpExitOverwriteOnDiffPtr = new BoolVector(calledContext.shapeLength);
                        }
                    }
                }
                if (origCallPresent) {
                    DiffLivenessAnalyzer.setTreeRequiredInDiff(this.curActivity, tree, this.phase == 0);
                    BoolVector functionW = new BoolVector(this.nSEZ + this.nDZ);
                    TapList[] outCallArgs = DiffLivenessAnalyzer.propagateDataToCaller(calledUnit.unitInOutPossiblyW(), null, null, argTrees.length, functionW, this.vectorMap, null, this.curInstruction, arrow, true, false, 0);
                    for (i = argTrees.length - 1; i >= 0; --i) {
                        this.setInfoBoolTreeToExtendedDeclaredZones(functionW, this.vectorMap, argsZones[i], true, outCallArgs[i], true, 0);
                    }
                    diffOwrts.cumulOr(functionW);
                    boolean takeRisks = false;
                    boolean takeSmallerRisks = true;
                    BoolVector liveDueToLiveOutputs = takeRisks ? calleePublicDeps.leftTimes(outputPublicDiffLiveness) : (!thisCallCheckpointed && calledContext != null && takeSmallerRisks ? calleePublicDeps.leftTimes(calledContext.nockpExitLiveness != null ? calledContext.nockpExitLiveness : outputPublicDiffLiveness) : calledUnit.unitInOutPossiblyR());
                    if (this.traceCurAnalysis) {
                        TapEnv.printlnOnTrace("  adding public Diff Live inputs of " + calledUnit + " because needed for Diff Live outputs:" + liveDueToLiveOutputs);
                    }
                    inputPublicDiffLiveness.cumulOr(liveDueToLiveOutputs);
                }
                boolean bl2 = diffCallPresent = mpiDiffCallPresent || ADActivityAnalyzer.isAnnotatedActive(this.curActivity, tree, this.curSymbolTable);
                if (diffCallPresent) {
                    BoolVector calleeEntryLivenessCkp;
                    BoolVector calleeDiffNeeded;
                    if (curCalledActivity == null || !calledUnit.hasSource() || calledUnit.rank() <= 0) {
                        calleeDiffNeeded = ADActivityAnalyzer.buildDefaultIntrinsicCallActivity(calledUnit, TapEnv.diffKind());
                        calleeEntryLivenessCkp = calledUnit.unitInOutPossiblyR();
                    } else {
                        calleeDiffNeeded = curCalledActivity.callActivity().or(curCalledActivity.entryReqX());
                        calleeEntryLivenessCkp = curCalledActivity.entryDiffLivenessesCkp();
                    }
                    diffArgsNeeded = DiffLivenessAnalyzer.propagateDataToCaller(calleeDiffNeeded, null, null, argTrees.length, null, null, null, this.curInstruction, arrow, true, true, TapEnv.diffKind());
                    if (!thisCallCheckpointed) {
                        DiffLivenessAnalyzer.setTreeRequiredInDiff(this.curActivity, tree, this.phase == 0);
                    }
                    if (calleeEntryLivenessCkp != null) {
                        if (this.traceCurAnalysis) {
                            TapEnv.printlnOnTrace("  adding public Diff Live inputs of " + calledUnit + " (due to internal diff computations) :" + calleeEntryLivenessCkp);
                        }
                        inputPublicDiffLiveness.cumulOr(calleeEntryLivenessCkp);
                    }
                } else {
                    diffArgsNeeded = new TapList[argTrees.length];
                    for (i = argTrees.length - 1; i >= 0; --i) {
                        diffArgsNeeded[i] = new TapList<Boolean>(Boolean.FALSE, null);
                    }
                }
                if (origCallPresent || diffCallPresent) {
                    TapList[] argLivenesses = DiffLivenessAnalyzer.propagateEntryDataBwdToCaller(inputPublicDiffLiveness, diffLives, this.vectorMapWithCtrl, this.curInstruction, arrow, argTrees, 0);
                    DiffLivenessAnalyzer.propagateEntryDataBwdToCaller(inputPublicDiffLivenessOnDiffPtr, diffLivesOnDiffPtr, this.pointerVectorMap, this.curInstruction, arrow, argTrees, 3);
                    for (int i3 = argTrees.length - 1; i3 >= 0; --i3) {
                        this.setInfoBoolTreeToExtendedDeclaredZones(diffLives, this.vectorMapWithCtrl, argsZones[i3], argLivenesses[i3], null, false, 0);
                        boolean argIsLive = TapList.oneTrue(argLivenesses[i3]);
                        if (argIsLive) {
                            DiffLivenessAnalyzer.setTreeRequiredInDiff(this.curActivity, argTrees[i3], this.phase == 0);
                        }
                        this.diffLivenessThroughExpression(argTrees[i3], argsZones[i3] == null && argIsLive, true, TapList.oneTrue(diffArgsNeeded[i3]), diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                    }
                    this.setControllingLive(this.curInstruction, this.curBlock, diffLives, true);
                    break;
                }
                diffLives.setCopy(diffLivesDown);
                for (int i4 = argTrees.length - 1; i4 >= 0; --i4) {
                    this.diffLivenessThroughExpression(argTrees[i4], false, false, false, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                }
                break;
            }
            case 107: {
                int i;
                int testZone = this.curBlock.testZone;
                if (testZone > 0 && this.curBlock.lastInstr().tree == tree) {
                    diffLives.setTest(testZone, this.vectorMapWithCtrl, false);
                }
                int zoneIO = this.curCallGraph.zoneNbOfAllIOStreams;
                String ioAction = ILUtils.getIdentString(tree.down(1));
                boolean writesInVars = ioAction.equals("read") || ioAction.equals("accept") || ioAction.equals("decode");
                boolean thisIOcallIsLive = needVal;
                if (diffLives.getDeclared(zoneIO, this.vectorMapWithCtrl)) {
                    thisIOcallIsLive = true;
                }
                ToBool total = new ToBool(false);
                ToBool totally = new ToBool(false);
                ToBool written = new ToBool(false);
                TapList<Tree> usedTrees = null;
                TapList<Tree> treesResetInDiff = null;
                Tree[] ioArgs = tree.down(3).children();
                BoolVector ioWritten = new BoolVector(DiffLivenessAnalyzer.mapSize(this.vectorMap));
                for (i = ioArgs.length - 1; i >= 0; --i) {
                    TapList<Tree> implicitDoIndices = this.collectImplicitDoIndices(ioArgs[i], null);
                    while (implicitDoIndices != null) {
                        Tree index = (Tree)implicitDoIndices.head;
                        if (DiffLivenessAnalyzer.intersectsExtendedDeclared(diffLives, this.vectorMapWithCtrl, 0, index, total, this.curInstruction, null, this.curSymbolTable, null)) {
                            thisIOcallIsLive = true;
                            if (total.get()) {
                                this.setRefValue(index, 0, diffLives, this.vectorMapWithCtrl, false, false);
                            }
                        }
                        this.setRefValue(index, 0, ioWritten, this.vectorMap, true, true);
                        implicitDoIndices = implicitDoIndices.tail;
                    }
                }
                for (i = ioArgs.length - 1; i >= 0; --i) {
                    if (writesInVars) {
                        if (DiffLivenessAnalyzer.intersectsExtendedDeclared(diffLives, this.vectorMapWithCtrl, 0, ioArgs[i], total, this.curInstruction, null, this.curSymbolTable, null)) {
                            thisIOcallIsLive = true;
                            if (total.get()) {
                                this.setRefValue(ioArgs[i], 0, diffLives, this.vectorMapWithCtrl, false, false);
                            }
                        }
                        WrapperTypeSpec argType = this.curSymbolTable.typeOf(ioArgs[i]);
                        if (ADActivityAnalyzer.hasOneAnnotatedActive(this.curActivity, ioArgs[i], this.curSymbolTable) || ILUtils.isAccessedThroughPointer(ioArgs[i]) && (argType == null || argType.wrappedType == null || argType.wrappedType.isDifferentiated(null))) {
                            treesResetInDiff = new TapList<Tree>(ioArgs[i], treesResetInDiff);
                        }
                        this.setRefValue(ioArgs[i], 0, ioWritten, this.vectorMap, true, true);
                        continue;
                    }
                    usedTrees = new TapList<Tree>(ioArgs[i], usedTrees);
                }
                Tree[] ioSpecs = tree.down(2).children();
                for (int i5 = ioSpecs.length - 1; i5 >= 0; --i5) {
                    Tree ioSpecTree = InOutAnalyzer.getIOeffectOfIOspec(ioSpecs[i5], i5, ioAction, written, totally, this.curSymbolTable);
                    if (written.get()) {
                        if (DiffLivenessAnalyzer.intersectsExtendedDeclared(diffLives, this.vectorMapWithCtrl, 0, ioSpecTree, total, this.curInstruction, null, this.curSymbolTable, null)) {
                            thisIOcallIsLive = true;
                            if (total.get() && totally.get()) {
                                this.setRefValue(ioSpecTree, 0, diffLives, this.vectorMapWithCtrl, false, false);
                            }
                        }
                        if (ADActivityAnalyzer.hasOneAnnotatedActive(this.curActivity, ioSpecTree, this.curSymbolTable)) {
                            treesResetInDiff = new TapList<Tree>(ioSpecTree, treesResetInDiff);
                        }
                        this.setRefValue(ioSpecTree, 0, ioWritten, this.vectorMap, true, true);
                        continue;
                    }
                    usedTrees = new TapList<Tree>(ioSpecTree, usedTrees);
                }
                if (thisIOcallIsLive) {
                    DiffLivenessAnalyzer.setTreeRequiredInDiff(this.curActivity, tree, this.phase == 0);
                    this.setControllingLive(this.curInstruction, this.curBlock, diffLives, true);
                    while (usedTrees != null) {
                        this.diffLivenessThroughExpression((Tree)usedTrees.head, true, false, false, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                        usedTrees = usedTrees.tail;
                    }
                    diffLives.setDeclared(zoneIO, this.vectorMapWithCtrl, true);
                    diffOwrts.cumulOr(ioWritten);
                } else if (ADActivityAnalyzer.isAnnotatedActive(this.curActivity, tree, this.curSymbolTable) || treesResetInDiff != null) {
                    this.setControllingLive(this.curInstruction, this.curBlock, diffLives, true);
                }
                while (treesResetInDiff != null) {
                    Tree toResetDiff = (Tree)treesResetInDiff.head;
                    this.diffLivenessThroughExpression(toResetDiff, false, true, false, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                    treesResetInDiff = treesResetInDiff.tail;
                }
                break;
            }
            case 108: {
                this.diffLivenessThroughExpression(tree.down(1), needVal, needLoc, needDiff, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                this.diffLivenessThroughExpression(tree.down(2), needVal, needLoc, true, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                this.setRefValue(tree.down(1), 0, diffOwrts, this.vectorMap, true, true);
                break;
            }
            case 9: 
            case 70: 
            case 81: {
                Tree[] sons = tree.children();
                for (int i = sons.length - 1; i >= 0; --i) {
                    this.diffLivenessThroughExpression(sons[i], needVal, needLoc, false, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                }
                break;
            }
            case 8: {
                if (needVal) {
                    this.setRefValue(tree, 0, diffLives, this.vectorMapWithCtrl, true, false);
                }
                this.diffLivenessThroughExpression(tree.down(1), false, needVal, needVal || needDiff, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                this.diffLivenessThroughExpression(tree.down(2), needVal || needLoc || needDiff, false, false, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                break;
            }
            case 73: {
                if (needVal) {
                    this.setRefValue(tree, 0, diffLives, this.vectorMapWithCtrl, true, false);
                }
                this.diffLivenessThroughExpression(tree.down(1), false, needVal || needLoc, needVal || needDiff, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                break;
            }
            case 148: {
                if (needVal) {
                    this.setRefValue(tree, 0, diffLives, this.vectorMapWithCtrl, true, false);
                }
                this.diffLivenessThroughExpression(tree.down(1), needVal || needLoc, false, needDiff, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                this.diffLivenessThroughExpression(tree.down(2), needVal || needLoc || needDiff, false, false, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                break;
            }
            case 94: {
                if (needVal) {
                    this.setRefValue(tree, 0, diffLives, this.vectorMapWithCtrl, true, false);
                }
                if (!needDiff) break;
                this.setRefValue(tree, 3, diffLivesOnDiffPtr, this.pointerVectorMap, true, false);
                break;
            }
            case 119: {
                if (needVal) {
                    DiffLivenessAnalyzer.setTreeRequiredInDiff(this.curActivity, tree, this.phase == 0);
                    this.setControllingLive(this.curInstruction, this.curBlock, diffLives, true);
                }
                this.diffLivenessThroughExpression(tree.down(3), needVal, false, false, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                diffLives.setTest(this.curBlock.testZone, this.vectorMapWithCtrl, false);
                break;
            }
            case 78: {
                break;
            }
            case 79: {
                this.diffLivenessThroughExpression(tree.down(1), needVal, needLoc, needDiff, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                this.diffLivenessThroughExpression(tree.down(2), needVal, needLoc, needDiff, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                break;
            }
            case 63: 
            case 80: {
                if (diffLives != null && DiffLivenessAnalyzer.intersectsExtendedDeclared(diffLives, this.vectorMapWithCtrl, 0, tree.down(1), null, this.curInstruction, null, this.curSymbolTable, null)) {
                    needVal = true;
                    if (!(this.curBlock instanceof HeaderBlock) || !this.curBlock.isACleanDoLoop()) {
                        DiffLivenessAnalyzer.setTreeRequiredInDiff(this.curActivity, tree, this.phase == 0);
                    }
                    this.setControllingLive(this.curInstruction, this.curBlock, diffLives, true);
                }
                if (needDiff) {
                    ToBool total = new ToBool(false);
                    TapIntList indexZones = this.curSymbolTable.listOfZonesOfValue(tree.down(1), total, this.curInstruction);
                    if (total.get()) {
                        diffLives.setDeclared(indexZones, this.vectorMapWithCtrl, false);
                    }
                }
                this.diffLivenessThroughExpression(tree.down(2), needVal, false, false, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                this.diffLivenessThroughExpression(tree.down(3), needVal, false, false, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                this.diffLivenessThroughExpression(tree.down(4), needVal, false, false, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                break;
            }
            case 11: {
                this.diffLivenessThroughExpression(tree.down(1), needVal, false, false, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                this.diffLivenessThroughExpression(tree.down(2), needVal, false, false, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                this.diffLivenessThroughExpression(tree.down(3), needVal, false, false, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                break;
            }
            case 29: 
            case 174: {
                DiffLivenessAnalyzer.setTreeRequiredInDiff(this.curActivity, tree, this.phase == 0);
                this.setControllingLive(this.curInstruction, this.curBlock, diffLives, true);
                if (arrives == null) break;
                arrives.set(false);
                break;
            }
            case 4: {
                this.diffLivenessThroughExpression(tree.down(1), true, false, false, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                this.diffLivenessThroughExpression(tree.down(2), true, false, false, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                DiffLivenessAnalyzer.setTreeRequiredInDiff(this.curActivity, tree, this.phase == 0);
                this.setControllingLive(this.curInstruction, this.curBlock, diffLives, true);
                TapList allocatedZones = (TapList)tree.getAnnotation("allocatedZones");
                this.setExtendedDeclared(diffOwrts, this.vectorMap, 0, ZoneInfo.listAllZones(allocatedZones, false), true);
                break;
            }
            case 51: 
            case 138: {
                Tree destinationTree = ILUtils.build(148, ILUtils.copy(tree.down(1)));
                if (!TapEnv.modeIsTangent() && !DiffLivenessAnalyzer.intersectsExtendedDeclared(diffOwrts, this.vectorMap, 0, destinationTree, null, this.curInstruction, null, this.curSymbolTable, null)) break;
                DiffLivenessAnalyzer.setTreeRequiredInDiff(this.curActivity, tree, this.phase == 0);
                if (!TapEnv.modeIsTangent() && tree.opCode() == 51 && (this.phase == 0 ? this.curUnit.mustDifferentiateJoint() : this.curUnit.mustDifferentiateSplit())) {
                    int firstZoneRkOutOfScope;
                    TapIntList freedZones = ZoneInfo.listAllZones(this.curSymbolTable.treeOfZonesOfValue(destinationTree, null, this.curInstruction, null), false);
                    int n = firstZoneRkOutOfScope = this.phase == 0 ? this.curUnit.privateSymbolTable().freeDeclaredZone(0) : this.curUnit.publicSymbolTable().firstDeclaredZone(0);
                    while (freedZones != null) {
                        ZoneInfo zone;
                        if (freedZones.head >= firstZoneRkOutOfScope && (zone = this.extendedDeclaredToZoneInfo(freedZones.head)) != null) {
                            zone.relocated = true;
                            zone.relocatedDiff = true;
                            if (freedZones.head < this.curUnit.publicSymbolTable().freeDeclaredZone(0)) {
                                TapEnv.toolError("  Problem on " + ILUtils.toString(tree) + " in " + this.curUnit.name + ": relocated info on formal argument " + ILUtils.toString(zone.accessTree) + " must be attached to its actual memory zone");
                            }
                        }
                        freedZones = freedZones.tail;
                    }
                }
                this.setControllingLive(this.curInstruction, this.curBlock, diffLives, true);
                break;
            }
            case 14: {
                if (!DiffLivenessAnalyzer.intersectsExtendedDeclared(diffLives, this.vectorMapWithCtrl, 0, tree.down(2), null, this.curInstruction, null, this.curSymbolTable, null)) break;
                DiffLivenessAnalyzer.setTreeRequiredInDiff(this.curActivity, tree, this.phase == 0);
                this.setControllingLive(this.curInstruction, this.curBlock, diffLives, true);
                this.setRefValue(tree.down(2), 0, diffLives, this.vectorMapWithCtrl, false, false);
                this.setRefValue(tree.down(2), 0, diffOwrts, this.vectorMap, true, true);
                break;
            }
            case 132: {
                this.diffLivenessThroughExpression(tree.down(2), needVal, false, false, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                break;
            }
            case 31: {
                this.diffLivenessThroughExpression(tree.down(2), needVal, needLoc, needDiff, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                break;
            }
            case 189: {
                String operName = ILUtils.getIdentString(tree.down(1));
                if (operName != null && (operName.equals("++prefix") || operName.equals("++postfix") || operName.equals("--prefix") || operName.equals("--postfix"))) {
                    boolean needValSon;
                    if (needVal) {
                        needValSon = true;
                    } else {
                        TapIntList writtenZonesList = ZoneInfo.listAllZones(this.curSymbolTable.treeOfZonesOfValue(tree.down(2), null, this.curInstruction, null), true);
                        needValSon = DiffLivenessAnalyzer.intersectsExtendedDeclared(diffLives, this.vectorMapWithCtrl, 0, writtenZonesList, null, this.curSymbolTable, null);
                    }
                    if (needValSon) {
                        DiffLivenessAnalyzer.setTreeRequiredInDiff(this.curActivity, tree, this.phase == 0);
                        this.setRefValue(tree.down(2), 0, diffOwrts, this.vectorMap, true, true);
                        this.setControllingLive(this.curInstruction, this.curBlock, diffLives, true);
                    }
                    this.diffLivenessThroughExpression(tree.down(2), needValSon, needLoc, false, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                    break;
                }
                this.diffLivenessThroughExpression(tree.down(2), needVal, needLoc, needDiff, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                break;
            }
            case 194: {
                Tree[] sons = tree.down(3).children();
                this.inADeclaration = true;
                for (int i = 0; i <= sons.length - 1; ++i) {
                    Tree declarator = sons[i];
                    if (declarator.opCode() == 13) {
                        this.diffLivenessThroughExpression(declarator, needVal, false, false, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                        ILUtils.turnAssignFromInitDecl(declarator);
                    }
                    this.diffLivenessThroughExpression(declarator, needVal, false, false, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                    if (declarator.opCode() != 13) continue;
                    ILUtils.resetAssignFromInitDecl(declarator);
                }
                this.inADeclaration = false;
            }
            case 44: 
            case 187: 
            case 197: {
                DiffLivenessAnalyzer.setTreeRequiredInDiff(this.curActivity, tree, this.phase == 0);
                this.setControllingLive(this.curInstruction, this.curBlock, diffLives, true);
                break;
            }
            case 170: {
                this.diffLivenessThroughExpression(tree.down(2), true, false, false, diffLives, diffLivesOnDiffPtr, diffOwrts, diffOwrtsOnDiffPtr, afterReqX, arrives);
                break;
            }
            case 142: 
            case 143: {
                break;
            }
            case 35: 
            case 45: 
            case 55: 
            case 87: {
                break;
            }
            case 1: 
            case 3: 
            case 10: 
            case 19: 
            case 27: 
            case 28: 
            case 34: 
            case 38: 
            case 40: 
            case 48: 
            case 50: 
            case 68: 
            case 72: 
            case 76: 
            case 83: 
            case 88: 
            case 99: 
            case 101: 
            case 102: 
            case 104: 
            case 106: 
            case 109: 
            case 116: 
            case 127: 
            case 133: 
            case 136: 
            case 150: 
            case 155: 
            case 166: 
            case 172: 
            case 175: 
            case 176: 
            case 181: 
            case 192: 
            case 199: {
                break;
            }
            default: {
                TapEnv.toolWarning(-1, "(Diff Liveness analysis) Unexpected operator: " + tree.opName());
            }
        }
    }

    private void diffLivenessThroughPointerExpression(Tree expr, BoolVector diffLives, BoolVector diffOwrts) {
        switch (expr.opCode()) {
            case 94: {
                break;
            }
            case 8: 
            case 148: {
                this.diffLivenessThroughPointerExpression(expr.down(1), diffLives, diffOwrts);
                this.setLiveAllZonesUsed(expr.down(2), diffLives);
                break;
            }
            case 3: 
            case 73: {
                this.diffLivenessThroughPointerExpression(expr.down(1), diffLives, diffOwrts);
                break;
            }
            case 31: {
                this.diffLivenessThroughPointerExpression(expr.down(2), diffLives, diffOwrts);
                break;
            }
            case 4: {
                this.diffLivenessThroughPointerExpression(expr.down(2), diffLives, diffOwrts);
                break;
            }
            default: {
                if (expr.isAtom()) break;
                Tree[] subTrees = expr.children();
                for (int i = subTrees.length - 1; i >= 0; --i) {
                    WrapperTypeSpec childType = this.curSymbolTable.typeOf(subTrees[i]);
                    if (TypeSpec.isA(childType, 6)) {
                        this.diffLivenessThroughPointerExpression(subTrees[i], diffLives, diffOwrts);
                        continue;
                    }
                    this.setLiveAllZonesUsed(subTrees[i], diffLives);
                }
            }
        }
    }

    private void setLiveAllZonesUsed(Tree tree, BoolVector diffLives) {
        BoolVector zonesUsedByExp = this.curSymbolTable.zonesUsedByExp(tree, this.curInstruction);
        diffLives.cumulOr(zonesUsedByExp, 0, 0, this.nSEZ);
        diffLives.cumulOr(zonesUsedByExp, this.nSEZ, this.nSEZ + this.nTZ, this.nDZ);
    }

    private TapList<Tree> collectImplicitDoIndices(Tree ioArg, TapList<Tree> collectList) {
        if (ioArg.opCode() == 108) {
            collectList = new TapList<Tree>(ioArg.down(2).down(1), collectList);
        } else if (ioArg.opCode() == 70) {
            Tree[] sons = ioArg.children();
            for (int i = sons.length - 1; i >= 0; --i) {
                collectList = this.collectImplicitDoIndices(sons[i], collectList);
            }
        }
        return collectList;
    }

    public void resetLivenessInfo(TapList<Block> blocks) {
        while (blocks != null) {
            Block block = (Block)blocks.head;
            TapList<Instruction> instructions = block.instructions;
            while (instructions != null) {
                this.resetTreeOrSubtreeRequirementInDiff(((Instruction)instructions.head).tree);
                instructions = instructions.tail;
            }
            blocks = blocks.tail;
        }
    }

    private void resetTreeOrSubtreeRequirementInDiff(Tree tree) {
        if (tree != null) {
            DiffLivenessAnalyzer.setNotRequiredInDiff(this.curActivity, tree);
            if (!tree.isAtom()) {
                Tree[] subTrees = tree.children();
                for (int i = subTrees.length - 1; i >= 0; --i) {
                    this.resetTreeOrSubtreeRequirementInDiff(subTrees[i]);
                }
            }
        }
    }

    private boolean checkActivityThroughArrow(FGArrow arrow) {
        if (arrow.destination == this.curUnit.exitBlock) {
            return false;
        }
        SymbolTable originSymbolTable = arrow.origin.symbolTable;
        SymbolTable commonSymbolTable = originSymbolTable.getCommonRoot(arrow.destination.symbolTable);
        int nDRZ = commonSymbolTable.declaredZonesNb(TapEnv.diffKind());
        int originnDRZ = originSymbolTable.declaredZonesNb(TapEnv.diffKind());
        BoolVector destinationEntryActiv = (BoolVector)this.curUnitActivities.retrieve((Block)arrow.destination).head;
        BoolVector originExitActiv = TapList.last(this.curUnitActivities.retrieve(arrow.origin));
        for (int i = originnDRZ - 1; i >= 0; --i) {
            int indexInActivs = i + this.curUnit.sideEffectZonesNb(TapEnv.diffKind());
            if (!originExitActiv.get(indexInActivs) || i < nDRZ && destinationEntryActiv.get(indexInActivs)) continue;
            return true;
        }
        return false;
    }

    private void setAllCallersOutOfDateUpto(Unit unit, Unit uptoUnit) {
        TapList<CallArrow> arrows = unit.callers();
        while (arrows != null) {
            Unit caller = ((CallArrow)arrows.head).origin;
            if (caller.rank() < uptoUnit.rank()) {
                caller.analysisIsOutOfDate = true;
            }
            arrows = arrows.tail;
        }
    }

    public BoolVector getPublicDiffLiveness(ActivityPattern pattern) {
        BoolVector unitDiffLiveness = null;
        if (TapEnv.dbadMode() == 0 && TapEnv.removeDeadPrimal()) {
            unitDiffLiveness = pattern.entryDiffLivenessesCkp();
        }
        unitDiffLiveness = unitDiffLiveness == null ? pattern.unit().unitInOutPossiblyR() : unitDiffLiveness.and(pattern.unit().unitInOutPossiblyR());
        return unitDiffLiveness;
    }

    public BoolVector getPublicDiffLivenessOnDiffPtr(ActivityPattern pattern) {
        BoolVector unitDiffLivenessOnDiffPtr = null;
        if (TapEnv.dbadMode() == 0 && TapEnv.removeDeadPrimal()) {
            unitDiffLivenessOnDiffPtr = pattern.entryDiffLivenessesCkpOnDiffPtr();
        }
        unitDiffLivenessOnDiffPtr = unitDiffLivenessOnDiffPtr == null ? pattern.unit().unitInOutPossiblyR() : unitDiffLivenessOnDiffPtr.and(pattern.unit().unitInOutPossiblyR());
        return unitDiffLivenessOnDiffPtr;
    }

    private boolean someOutputIsLive(BoolVector outputLiveness, BoolMatrix functionPublicDeps) {
        boolean result = false;
        int i = functionPublicDeps.nRows;
        while (!result && i > 0) {
            result = outputLiveness.get(--i) && !functionPublicDeps.isImplicitIdentityRow(i);
        }
        return result;
    }

    private void setControllingLive(Instruction instruction, Block block, BoolVector liveZones, boolean forFwdSweep) {
        if (instruction != null && instruction.getWhereMask() != null) {
            BoolVector usedZones = new BoolVector(this.nSEZ + this.nDZ);
            InstructionMask curMask = instruction.getWhereMask();
            while (curMask != null) {
                usedZones.cumulOr(block.symbolTable.zonesUsedByExp(curMask.getControlTree(), instruction));
                curMask = curMask.enclosingMask;
            }
            liveZones.cumulOr(usedZones, 0, 0, this.nSEZ);
            liveZones.cumulOr(usedZones, this.nSEZ, this.nSEZ + this.nTZ, this.nDZ);
        }
        TapList<Block> ctrBlocks = block.controllers;
        while (ctrBlocks != null) {
            Block ctrBlock = (Block)ctrBlocks.head;
            if (!(!forFwdSweep && ctrBlock instanceof HeaderBlock && ctrBlock.isACleanDoLoop() || ctrBlock.testZone >= this.nTZ)) {
                liveZones.setTest(ctrBlock.testZone, this.vectorMapWithCtrl, true);
            }
            ctrBlocks = ctrBlocks.tail;
        }
    }

    protected static class Context {
        private final int shapeLength;
        private boolean nockpOutOfDate;
        private BoolVector nockpExitLiveness;
        private BoolVector nockpExitLivenessOnDiffPtr;
        private BoolVector nockpExitOverwrite;
        private BoolVector nockpExitOverwriteOnDiffPtr;

        private Context(int shapeLength) {
            this.shapeLength = shapeLength;
        }

        private void addNockpExitLiveness(BoolVector additionalLiveness, BoolVector additionalLivenessOnDiffPtr) {
            boolean modified = false;
            if (additionalLiveness != null) {
                if (this.nockpExitLiveness == null) {
                    this.nockpExitLiveness = additionalLiveness.copy();
                    modified = true;
                } else {
                    modified = this.nockpExitLiveness.cumulOrGrows(additionalLiveness, this.shapeLength);
                }
            }
            if (additionalLivenessOnDiffPtr != null) {
                if (this.nockpExitLivenessOnDiffPtr == null) {
                    this.nockpExitLivenessOnDiffPtr = additionalLivenessOnDiffPtr.copy();
                    modified = true;
                } else {
                    modified = this.nockpExitLivenessOnDiffPtr.cumulOrGrows(additionalLivenessOnDiffPtr, this.shapeLength);
                }
            }
            if (modified) {
                this.nockpOutOfDate = true;
            }
        }

        private void addNockpExitOverwrite(BoolVector additionalOverwrite, BoolVector additionalOverwriteOnDiffPtr) {
            boolean modified = false;
            if (additionalOverwrite != null) {
                if (this.nockpExitOverwrite == null) {
                    this.nockpExitOverwrite = additionalOverwrite.copy();
                    modified = true;
                } else {
                    modified = this.nockpExitOverwrite.cumulOrGrows(additionalOverwrite, this.shapeLength);
                }
            }
            if (additionalOverwriteOnDiffPtr != null) {
                if (this.nockpExitOverwriteOnDiffPtr == null) {
                    this.nockpExitOverwriteOnDiffPtr = additionalOverwriteOnDiffPtr.copy();
                    modified = true;
                } else {
                    modified = this.nockpExitOverwriteOnDiffPtr.cumulOrGrows(additionalOverwriteOnDiffPtr, this.shapeLength);
                }
            }
            if (modified) {
                this.nockpOutOfDate = true;
            }
        }
    }
}

