/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.analysis;

import fr.inria.tapenade.analysis.DataFlowAnalyzer;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.BlockStorage;
import fr.inria.tapenade.representation.CallArrow;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.HeaderBlock;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.LoopBlock;
import fr.inria.tapenade.representation.MPIcallInfo;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.PublicInfo;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.BoolMatrix;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.Tree;

public final class InOutAnalyzer
extends DataFlowAnalyzer {
    public static final int INOUT = 1;
    public static final int OTHER = 0;
    public static final int CONSTANT = 2;
    public static final int UNUSED = 3;
    public static final int USED_UNDEF = 4;
    private int fgPhase;
    private int fgSubPhase;
    private BlockStorage<BoolVector> beforeN;
    private BlockStorage<BoolVector> beforeR;
    private BlockStorage<BoolVector> beforeW;
    private BlockStorage<BoolVector> beforeRW;
    private BlockStorage<BoolVector> beforeCycleN;
    private BlockStorage<BoolVector> beforeCycleR;
    private BlockStorage<BoolVector> beforeCycleW;
    private BlockStorage<BoolVector> beforeCycleRW;
    private BlockStorage<BoolVector> throughN;
    private BlockStorage<BoolVector> throughR;
    private BlockStorage<BoolVector> throughW;
    private BlockStorage<BoolVector> throughRW;
    private BlockStorage<BoolVector> afterN;
    private BlockStorage<BoolVector> afterR;
    private BlockStorage<BoolVector> afterW;
    private BlockStorage<BoolVector> afterRW;
    private BlockStorage<BoolVector> afterCycleN;
    private BlockStorage<BoolVector> afterCycleR;
    private BlockStorage<BoolVector> afterCycleW;
    private BlockStorage<BoolVector> afterCycleRW;
    private BlockStorage<BoolVector> beforeIZ;
    private BlockStorage<BoolVector> afterIZ;
    private BoolVector tmpN;
    private BoolVector tmpR;
    private BoolVector tmpW;
    private BoolVector tmpRW;
    private BoolVector tmpCycleN;
    private BoolVector tmpCycleR;
    private BoolVector tmpCycleW;
    private BoolVector tmpCycleRW;
    private BoolVector additionalN;
    private BoolVector additionalR;
    private BoolVector additionalW;
    private BoolVector additionalRW;
    private BoolVector tmpU;
    private BoolVector tmpC;
    private BoolVector tmpIZ;
    private BoolVector additionalU;
    private BoolVector additionalC;
    private BoolVector additionalIZ;
    private int[] vectorMap;

    public void setFgPhase(int fgPhase) {
        this.fgPhase = fgPhase;
    }

    public void setFgSubPhase(int fgSubPhase) {
        this.fgSubPhase = fgSubPhase;
    }

    private InOutAnalyzer(CallGraph cg) {
        super(cg, "In-Out analysis", TapEnv.traceInOut());
    }

    public static void runAnalysis(CallGraph callGraph, TapList<Unit> rootUnits) {
        TapEnv.setInOutAnalyzer(new InOutAnalyzer(callGraph));
        TapEnv.inOutAnalyzer().run(rootUnits);
    }

    public static void setIntrinsicDefaultInOutInfo(Unit unit) {
        int ioIndex;
        int n = unit.paramElemsNb();
        unit.unitInOutN = new BoolVector(n);
        unit.unitInOutN.setTrue();
        unit.unitInOutR = new BoolVector(n);
        unit.unitInOutR.setTrue();
        unit.unitInOutW = new BoolVector(n);
        unit.unitInOutW.setFalse();
        unit.unitInOutRW = new BoolVector(n);
        unit.unitInOutRW.setFalse();
        int returnIndex = -1;
        while (n > 0 && returnIndex == -1) {
            if (unit.paramElemZoneInfo(--n) == null || !unit.paramElemZoneInfo(n).isResult()) continue;
            returnIndex = n;
        }
        if (returnIndex != -1) {
            unit.unitInOutN.set(returnIndex, false);
            unit.unitInOutR.set(returnIndex, false);
            unit.unitInOutW.set(returnIndex, true);
            unit.unitInOutRW.set(returnIndex, false);
        }
        if ((ioIndex = TapEnv.zoneOfIO(unit)) != -1) {
            unit.unitInOutN.set(ioIndex, true);
            unit.unitInOutR.set(ioIndex, false);
            unit.unitInOutW.set(ioIndex, false);
            unit.unitInOutRW.set(ioIndex, false);
        }
    }

    public static Tree getIOeffectOfIOspec(Tree ioSpec, int i, String ioOper, ToBool written, ToBool totally, SymbolTable symbolTable) {
        String key = "";
        Tree value = ioSpec;
        written.set(false);
        totally.set(false);
        if (ioSpec.opCode() == 132) {
            key = ILUtils.getIdentString(ioSpec.down(1));
            value = ioSpec.down(2);
        } else if (i == 0) {
            if (!ioOper.equals("encode") && !ioOper.equals("decode")) {
                key = "unit";
                value = ioSpec;
            }
        } else if (i == 1) {
            key = "fmt";
        }
        if (key.equals("unit")) {
            WrapperTypeSpec typeOfTarget = null;
            String typeBaseName = null;
            if (!ILUtils.isNullOrNone(ioSpec)) {
                typeOfTarget = symbolTable.typeOf(ioSpec);
            }
            if (typeOfTarget != null) {
                typeBaseName = typeOfTarget.baseTypeName();
            }
            key = "character".equals(typeBaseName) ? "ifile" : "lunit";
        }
        if (key.equals("iostat") || key.equals("size") || ioOper.equals("inquire") && (key.equals("access") || key.equals("blank") || key.equals("carriagecontrol") || key.equals("direct") || key.equals("exist") || key.equals("form") || key.equals("formatted") || key.equals("keyed") || key.equals("name") || key.equals("named") || key.equals("nextrec") || key.equals("number") || key.equals("opened") || key.equals("organization") || key.equals("recl") || key.equals("recordtype") || key.equals("sequential") || key.equals("unformatted") || key.equals("iolength")) || key.equals("ifile") && (ioOper.equals("write") || ioOper.equals("rewrite"))) {
            written.set(true);
            totally.set(true);
        }
        if (key.equals("nml") && (ioOper.equals("read") || ioOper.equals("accept") || ioOper.equals("decode")) || i == 2 && ioOper.equals("encode")) {
            written.set(true);
            totally.set(false);
        }
        return value;
    }

    public static boolean isCheapDuplicableConstant(Tree expression, Block block, Instruction instruction) {
        int nSEZ = block.unit().sideEffectZonesNb(0);
        int nDZ = block.symbolTable.declaredZonesNb(0);
        BoolVector usedZones = block.symbolTable.zonesUsedByExp(expression, instruction);
        if (block.constantZones != null) {
            usedZones.cumulAnd(block.constantZones.not());
        }
        return usedZones.isFalse(nSEZ + nDZ);
    }

    @Override
    protected void run(TapList<Unit> rootUnits) {
        String topAnalysisName = this.curAnalysisName;
        this.fgPhase = 1;
        this.curAnalysisName = "In-Out analysis (main run)";
        this.runBottomUpAnalysis(rootUnits);
        this.fgPhase = 0;
        this.curAnalysisName = "In-Out analysis (secondary run)";
        this.runBottomUpAnalysis(rootUnits);
        this.curAnalysisName = topAnalysisName;
    }

    @Override
    public void setCurUnitEtc(Unit unit) {
        super.setCurUnitEtc(unit);
        if (unit == null) {
            this.curSymbolTable = null;
            this.vectorMap = null;
        } else {
            this.curSymbolTable = unit.privateSymbolTable();
            if (this.curSymbolTable == null) {
                this.curSymbolTable = unit.publicSymbolTable();
            }
            this.vectorMap = InOutAnalyzer.makeMap3(this.nSEZ, 0, this.curSymbolTable == null ? 0 : this.curSymbolTable.declaredZonesNb(0));
        }
    }

    @Override
    protected Object initializeCGForUnit() {
        if (this.fgPhase == 1) {
            if (this.curUnit.isExternal() || this.curUnit.isVarFunction() || this.curUnit.isInterface() || this.curUnit.isRenamed() || this.curUnit.isModule() || !this.curUnit.isIntrinsic() && !this.curUnit.hasSource()) {
                if (this.curUnit.unitInOutN() == null) {
                    this.setExternalDefaultInOutInfo(this.curUnit);
                }
            } else if (this.curUnit.isIntrinsic()) {
                if (this.curUnit.unitInOutN() == null) {
                    InOutAnalyzer.setIntrinsicDefaultInOutInfo(this.curUnit);
                }
            } else {
                this.curUnit.unitInOutN = null;
                this.curUnit.unitInOutR = null;
                this.curUnit.unitInOutW = null;
                this.curUnit.unitInOutRW = null;
            }
        }
        return null;
    }

    @Override
    protected boolean analyze() {
        if (this.fgPhase == 1) {
            return this.analyzeBackward(null, null, null);
        }
        if (this.fgPhase == 0) {
            this.fgSubPhase = 2;
            this.analyzeBackward(null, null, null);
            this.fgSubPhase = 3;
            this.analyzeBackward(null, null, null);
            this.fgSubPhase = 4;
            this.curUnit.entryBlock().symbolTable = this.curUnit.privateSymbolTable();
            this.analyzeForward(null, null, null);
            this.curUnit.entryBlock().symbolTable = this.curUnit.publicSymbolTable();
            return false;
        }
        return false;
    }

    @Override
    protected void concludeCGForUnit() {
        if (this.stoppedUnitInOut(this.curUnit, 0)) {
            TapEnv.fileWarning(15, null, "(DF06) Procedure " + this.curUnit.name + " does not terminate properly");
            this.setExternalDefaultInOutInfo(this.curUnit);
        } else if (this.erroredUnitInOut(this.curUnit)) {
            TapEnv.toolWarning(-1, "(In-out analysis) error in N R W RW status");
        }
    }

    private boolean stoppedUnitInOut(Unit unit, int zone) {
        return unit.unitInOutN() == null || !unit.unitInOutN().get(zone) && !unit.unitInOutR().get(zone) && !unit.unitInOutW().get(zone) && !unit.unitInOutRW().get(zone);
    }

    private boolean erroredUnitInOut(Unit unit) {
        if (unit.hasParamElemsInfo()) {
            int shapeLength = unit.paramElemsNb();
            return unit.unitInOutN() == null || unit.unitInOutN.isFalse(shapeLength) && unit.unitInOutR.isFalse(shapeLength) && unit.unitInOutW.isFalse(shapeLength) && unit.unitInOutRW.isFalse(shapeLength);
        }
        return false;
    }

    @Override
    protected void initializeUnit() {
        if (this.fgPhase == 1 || this.fgPhase == 0 && this.fgSubPhase == 2) {
            if (this.traceCurAnalysis) {
                TapEnv.printlnOnTrace();
                TapEnv.printOnTrace(" ===================== IN-OUT ANALYSIS ON UNIT " + this.curUnit.name + " : ==================== ");
                if (this.fgPhase == 1) {
                    TapEnv.printlnOnTrace("INOUT phase");
                } else {
                    TapEnv.printlnOnTrace("CONSTANT phase");
                }
                TapEnv.printlnOnTrace(" Map: " + InOutAnalyzer.showMap(this.vectorMap));
                for (int i = 0; i < InOutAnalyzer.mapSize(this.vectorMap); ++i) {
                    ZoneInfo zi = this.vectorIndexToZoneInfo(i, InOutAnalyzer.getMapClass(i, this.vectorMap), 0, this.vectorMap);
                    if (zi == null) continue;
                    TapEnv.printOnTrace(" [" + i + "]" + zi.accessTreePrint(this.curUnit.language()));
                }
                TapEnv.printlnOnTrace();
                TapEnv.printlnOnTrace();
            }
            this.beforeN = new BlockStorage(this.curUnit);
            this.beforeR = new BlockStorage(this.curUnit);
            this.beforeW = new BlockStorage(this.curUnit);
            this.beforeRW = new BlockStorage(this.curUnit);
            this.beforeCycleN = new BlockStorage(this.curUnit);
            this.beforeCycleR = new BlockStorage(this.curUnit);
            this.beforeCycleW = new BlockStorage(this.curUnit);
            this.beforeCycleRW = new BlockStorage(this.curUnit);
            this.throughN = new BlockStorage(this.curUnit);
            this.throughR = new BlockStorage(this.curUnit);
            this.throughW = new BlockStorage(this.curUnit);
            this.throughRW = new BlockStorage(this.curUnit);
            this.afterN = new BlockStorage(this.curUnit);
            this.afterR = new BlockStorage(this.curUnit);
            this.afterW = new BlockStorage(this.curUnit);
            this.afterRW = new BlockStorage(this.curUnit);
            this.afterCycleN = new BlockStorage(this.curUnit);
            this.afterCycleR = new BlockStorage(this.curUnit);
            this.afterCycleW = new BlockStorage(this.curUnit);
            this.afterCycleRW = new BlockStorage(this.curUnit);
            if (this.fgPhase == 0 && this.fgSubPhase == 2) {
                this.beforeIZ = new BlockStorage(this.curUnit);
                this.afterIZ = new BlockStorage(this.curUnit);
            }
        }
    }

    @Override
    protected void setCurBlockEtc(Block block) {
        super.setCurBlockEtc(block);
        if (block == null) {
            this.nDZ = -9;
            if (this.vectorMap != null) {
                this.vectorMap[3] = this.vectorMap[2];
            }
        } else {
            this.nDZ = this.curSymbolTable.declaredZonesNb(0);
            this.vectorMap = InOutAnalyzer.makeMap3(this.nSEZ, 0, this.nDZ);
        }
    }

    @Override
    protected void initializeInitBlock() {
        if (this.fgPhase == 1) {
            BoolVector tmpVect = new BoolVector(this.nSEZ + this.nDZ);
            tmpVect.setTrue();
            this.beforeN.store(this.curBlock, tmpVect);
            this.beforeR.store(this.curBlock, new BoolVector(this.nSEZ + this.nDZ));
            this.beforeW.store(this.curBlock, new BoolVector(this.nSEZ + this.nDZ));
            this.beforeRW.store(this.curBlock, new BoolVector(this.nSEZ + this.nDZ));
            if (InOutAnalyzer.runSpecialCycleAnalysis(this.curBlock)) {
                this.beforeCycleN.store(this.curBlock, this.beforeN.retrieve(this.curBlock));
                this.beforeCycleR.store(this.curBlock, this.beforeR.retrieve(this.curBlock));
                this.beforeCycleW.store(this.curBlock, this.beforeW.retrieve(this.curBlock));
                this.beforeCycleRW.store(this.curBlock, this.beforeRW.retrieve(this.curBlock));
            }
        } else if (this.fgSubPhase == 2) {
            this.curBlock.constantZones = new BoolVector(this.nSEZ + this.nDZ);
            this.curBlock.constantZones.setTrue();
        } else if (this.fgSubPhase == 3) {
            this.curBlock.unusedZones = new BoolVector(this.nSEZ + this.nDZ);
        } else if (this.fgSubPhase == 4) {
            int nDZ2 = this.curUnit.privateSymbolTable().declaredZonesNb(0);
            BoolVector afterEntryIZ = new BoolVector(this.nSEZ + nDZ2);
            afterEntryIZ.setTrue();
            for (int i = this.curUnit.publicSymbolTable().declaredZonesNb(0); i < nDZ2; ++i) {
                afterEntryIZ.setDeclared(i, this.vectorMap, false);
            }
            afterEntryIZ.setDeclared(this.curUnit.entryBlock().initializedLocalZones(), this.vectorMap, true);
            this.afterIZ.store(this.curBlock, afterEntryIZ);
        }
    }

    @Override
    protected void initializeFGForBlock() {
        if (this.fgPhase == 1 || this.fgSubPhase == 2) {
            this.tmpN = new BoolVector(this.nSEZ + this.nDZ);
            this.tmpN.setTrue();
            this.tmpR = new BoolVector(this.nSEZ + this.nDZ);
            this.tmpW = new BoolVector(this.nSEZ + this.nDZ);
            this.tmpRW = new BoolVector(this.nSEZ + this.nDZ);
            this.setUniqueAccessZones(this.curBlock);
            TapList<Instruction> instructions = this.curBlock.instructions;
            instructions = TapList.reverse(instructions);
            while (instructions != null) {
                this.curInstruction = (Instruction)instructions.head;
                Tree tree = this.curInstruction.tree;
                if (tree != null) {
                    if (this.traceCurAnalysis) {
                        TapEnv.printlnOnTrace("   init through instruction:" + tree);
                    }
                    this.inOutThroughExpression(tree, 0, true);
                    if (this.traceCurAnalysis) {
                        TapEnv.printlnOnTrace("--------------inout upstream " + tree + " :::");
                        TapEnv.printlnOnTrace("          N:" + this.tmpN + " R:" + this.tmpR + " W:" + this.tmpW + " RW:" + this.tmpRW);
                    }
                }
                instructions = instructions.tail;
            }
            this.curInstruction = null;
            this.uniqueAccessZones = null;
            this.throughN.store(this.curBlock, this.tmpN);
            this.throughR.store(this.curBlock, this.tmpR);
            this.throughW.store(this.curBlock, this.tmpW);
            this.throughRW.store(this.curBlock, this.tmpRW);
            if (this.fgPhase == 1) {
                this.checkOverwrittenLoopIndices(this.curBlock, this.tmpW.or(this.tmpRW), InOutAnalyzer.makeMap3(this.nSEZ, 0, this.nDZ));
            }
        }
        if (this.fgPhase == 0) {
            if (this.fgSubPhase == 2) {
                this.curBlock.constantZones = null;
            } else if (this.fgSubPhase == 3) {
                this.curBlock.unusedZones = null;
            }
        }
    }

    @Override
    protected boolean compareDownstreamValues() {
        if (this.fgPhase == 1) {
            this.afterN.store(this.curBlock, this.tmpN);
            this.afterR.store(this.curBlock, this.tmpR);
            this.afterW.store(this.curBlock, this.tmpW);
            this.afterRW.store(this.curBlock, this.tmpRW);
            if (InOutAnalyzer.runSpecialCycleAnalysis(this.curBlock)) {
                this.afterCycleN.store(this.curBlock, this.tmpCycleN);
                this.afterCycleR.store(this.curBlock, this.tmpCycleR);
                this.afterCycleW.store(this.curBlock, this.tmpCycleW);
                this.afterCycleRW.store(this.curBlock, this.tmpCycleRW);
            }
            return true;
        }
        if (this.fgSubPhase == 2) {
            return true;
        }
        if (this.fgSubPhase == 3) {
            return true;
        }
        if (this.fgSubPhase == 4) {
            BoolVector afterBlockIZ = this.afterIZ.retrieve(this.curBlock);
            if (afterBlockIZ == null || !this.tmpIZ.equals(afterBlockIZ, this.nSEZ + this.nDZ)) {
                this.afterIZ.store(this.curBlock, this.tmpIZ);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    protected boolean compareUpstreamValues() {
        BoolVector beforeBlockIZ;
        if (this.fgPhase == 1) {
            boolean modN = this.compareWithStorage(this.tmpN, this.tmpCycleN, this.nSEZ + this.nDZ, this.beforeN, this.beforeCycleN);
            boolean modR = this.compareWithStorage(this.tmpR, this.tmpCycleR, this.nSEZ + this.nDZ, this.beforeR, this.beforeCycleR);
            boolean modW = this.compareWithStorage(this.tmpW, this.tmpCycleW, this.nSEZ + this.nDZ, this.beforeW, this.beforeCycleW);
            boolean modRW = this.compareWithStorage(this.tmpRW, this.tmpCycleRW, this.nSEZ + this.nDZ, this.beforeRW, this.beforeCycleRW);
            return modN || modR || modW || modRW;
        }
        if (this.fgSubPhase == 2) {
            boolean blockGoesThrough;
            boolean bl = blockGoesThrough = this.throughW.retrieve(this.curBlock) != null;
            if (blockGoesThrough && (this.curBlock.constantZones == null || !this.tmpC.equals(this.curBlock.constantZones, this.nSEZ + this.nDZ))) {
                this.curBlock.constantZones = this.tmpC;
                return true;
            }
        } else if (this.fgSubPhase == 3) {
            boolean blockGoesThrough;
            boolean bl = blockGoesThrough = this.throughW.retrieve(this.curBlock) != null;
            if (blockGoesThrough && (this.curBlock.unusedZones == null || !this.tmpU.equals(this.curBlock.unusedZones, this.nSEZ + this.nDZ))) {
                this.curBlock.unusedZones = this.tmpU;
                return true;
            }
        } else if (!(this.fgSubPhase != 4 || (beforeBlockIZ = this.beforeIZ.retrieve(this.curBlock)) != null && this.tmpIZ.equals(beforeBlockIZ, this.nSEZ + this.nDZ))) {
            this.beforeIZ.store(this.curBlock, this.tmpIZ.copy());
            return true;
        }
        return false;
    }

    @Override
    protected boolean compareChannelZoneDataDownstream(int mpZone, Block refBlock) {
        return false;
    }

    @Override
    protected boolean compareChannelZoneDataUpstream(int mpZone, Block refBlock) {
        return false;
    }

    @Override
    protected boolean terminateUnit() {
        if (this.fgPhase == 1) {
            boolean hasChanged;
            BoolVector unitInOutN = null;
            BoolVector unitInOutR = null;
            BoolVector unitInOutW = null;
            BoolVector unitInOutRW = null;
            int[] vectorMap = InOutAnalyzer.makeMap3(this.curUnit, 0);
            if (this.afterN.retrieve(this.curUnit.entryBlock()) != null) {
                unitInOutN = InOutAnalyzer.propagateUnitDataOutside(this.afterN.retrieve(this.curUnit.entryBlock()), 0, vectorMap, true, this.curUnit);
                unitInOutR = InOutAnalyzer.propagateUnitDataOutside(this.afterR.retrieve(this.curUnit.entryBlock()), 0, vectorMap, true, this.curUnit);
                unitInOutW = InOutAnalyzer.propagateUnitDataOutside(this.afterW.retrieve(this.curUnit.entryBlock()), 0, vectorMap, true, this.curUnit);
                unitInOutRW = InOutAnalyzer.propagateUnitDataOutside(this.afterRW.retrieve(this.curUnit.entryBlock()), 0, vectorMap, true, this.curUnit);
            }
            if (this.curUnit.unitInOutN() == null) {
                hasChanged = unitInOutN != null;
            } else {
                assert (unitInOutN != null);
                boolean bl = hasChanged = !unitInOutN.equals(this.curUnit.unitInOutN(), this.curUnit.translator.length) || !unitInOutR.equals(this.curUnit.unitInOutR(), this.curUnit.translator.length) || !unitInOutW.equals(this.curUnit.unitInOutW(), this.curUnit.translator.length) || !unitInOutRW.equals(this.curUnit.unitInOutRW(), this.curUnit.translator.length);
            }
            if (hasChanged) {
                this.curUnit.unitInOutN = unitInOutN;
                this.curUnit.unitInOutR = unitInOutR;
                this.curUnit.unitInOutW = unitInOutW;
                this.curUnit.unitInOutRW = unitInOutRW;
            }
            if (this.traceCurAnalysis) {
                TapEnv.printlnOnTrace();
                TapEnv.printlnOnTrace("terminateUnit -> " + hasChanged + " " + this.curUnit);
                TapEnv.printlnOnTrace("N   " + this.curUnit.unitInOutN);
                TapEnv.printlnOnTrace("R   " + this.curUnit.unitInOutR);
                TapEnv.printlnOnTrace("W   " + this.curUnit.unitInOutW);
                TapEnv.printlnOnTrace("RW  " + this.curUnit.unitInOutRW);
                TapEnv.printlnOnTrace();
            }
            return hasChanged;
        }
        if (this.fgSubPhase == 2) {
            this.setCurBlockEtc(this.curUnit.entryBlock());
            this.accumulateValuesFromDownstream();
            this.curUnit.entryBlock().constantZones = this.tmpC;
            this.setCurBlockEtc(null);
            return true;
        }
        if (this.fgSubPhase == 4) {
            TapList<Block> inAllBlocks = this.curUnit.allBlocks;
            while (inAllBlocks != null) {
                this.setCurBlockEtc((Block)inAllBlocks.head);
                this.detectUsedUndef(this.curBlock, this.beforeIZ.retrieve(this.curBlock));
                inAllBlocks = inAllBlocks.tail;
            }
            this.setCurBlockEtc(null);
            this.beforeN = null;
            this.beforeR = null;
            this.beforeW = null;
            this.beforeRW = null;
            this.beforeCycleN = null;
            this.beforeCycleR = null;
            this.beforeCycleW = null;
            this.beforeCycleRW = null;
            this.throughN = null;
            this.throughR = null;
            this.throughW = null;
            this.throughRW = null;
            this.afterN = null;
            this.afterR = null;
            this.afterW = null;
            this.afterRW = null;
            this.afterCycleN = null;
            this.afterCycleR = null;
            this.afterCycleW = null;
            this.afterCycleRW = null;
            return true;
        }
        return true;
    }

    @Override
    protected boolean propagateValuesBackwardThroughBlock() {
        if (this.fgPhase == 1) {
            if (this.traceCurAnalysis) {
                TapEnv.printlnOnTrace();
                TapEnv.printlnOnTrace("   === Propagating upwards through Block " + this.curBlock + " ===");
            }
            if (InOutAnalyzer.runSpecialCycleAnalysis(this.curBlock)) {
                BoolVector thruRW;
                BoolVector thruW;
                BoolVector thruR;
                BoolVector thruN;
                BoolVector localizedZones = new BoolVector(InOutAnalyzer.mapSize(this.vectorMap));
                localizedZones.setDeclared(((HeaderBlock)this.curBlock).localizedZones, this.vectorMap, true);
                BoolVector directEntryExitMask = this.directEntryExitMask((HeaderBlock)this.curBlock, this.vectorMap, 0);
                if (this.traceCurAnalysis) {
                    TapEnv.printlnOnTrace("         OUT N:" + this.tmpN + " R:" + this.tmpR + " W:" + this.tmpW + " RW:" + this.tmpRW);
                    TapEnv.printlnOnTrace("   CYCLE OUT N:" + this.tmpCycleN + " R:" + this.tmpCycleR + " W:" + this.tmpCycleW + " RW:" + this.tmpCycleRW);
                    TapEnv.printlnOnTrace("   directEntryExitMask " + directEntryExitMask);
                    TapEnv.printlnOnTrace("   localizedZones     " + localizedZones);
                }
                BoolVector outN = this.tmpN;
                BoolVector outR = this.tmpR;
                BoolVector outW = this.tmpW;
                BoolVector outRW = this.tmpRW;
                BoolVector outCycleN = this.tmpCycleN;
                BoolVector outCycleR = this.tmpCycleR;
                BoolVector outCycleW = this.tmpCycleW;
                BoolVector outCycleRW = this.tmpCycleRW;
                TapIntList indexZones = null;
                ToBool indexTotal = new ToBool(false);
                if (this.curBlock.isACleanDoLoop()) {
                    this.curInstruction = this.curBlock.headInstr();
                    Tree doTree = this.curInstruction.tree.down(3);
                    indexZones = this.curSymbolTable.listOfZonesOfValue(doTree.down(1), indexTotal, this.curInstruction);
                    if (outN != null || outCycleN != null) {
                        this.tmpN = new BoolVector(this.nSEZ + this.nDZ);
                        this.tmpN.setTrue();
                        this.tmpR = new BoolVector(this.nSEZ + this.nDZ);
                        this.tmpW = new BoolVector(this.nSEZ + this.nDZ);
                        this.tmpRW = new BoolVector(this.nSEZ + this.nDZ);
                        this.inOutThroughExpression(doTree.down(3), -1, true);
                        if (outN != null) {
                            this.cumulThen(this.tmpN, this.tmpR, this.tmpW, this.tmpRW, outN, outR, outW, outRW);
                        }
                        if (outCycleN != null) {
                            this.cumulThen(this.tmpN, this.tmpR, this.tmpW, this.tmpRW, outCycleN, outCycleR, outCycleW, outCycleRW);
                        }
                    }
                    this.tmpN = new BoolVector(this.nSEZ + this.nDZ);
                    this.tmpN.setTrue();
                    this.tmpR = new BoolVector(this.nSEZ + this.nDZ);
                    this.tmpW = new BoolVector(this.nSEZ + this.nDZ);
                    this.tmpRW = new BoolVector(this.nSEZ + this.nDZ);
                    this.inOutThroughExpression(doTree.down(1), 1, true);
                    this.inOutThroughExpression(doTree.down(2), -1, true);
                    this.inOutThroughExpression(doTree.down(4), -1, true);
                    thruN = this.tmpN;
                    thruR = this.tmpR;
                    thruW = this.tmpW;
                    thruRW = this.tmpRW;
                    this.curInstruction = null;
                } else {
                    thruN = this.throughN.retrieve(this.curBlock);
                    thruR = this.throughR.retrieve(this.curBlock);
                    thruW = this.throughW.retrieve(this.curBlock);
                    thruRW = this.throughRW.retrieve(this.curBlock);
                }
                if (outCycleN != null) {
                    this.tmpCycleN = outCycleN.or(localizedZones);
                    this.tmpCycleR = outCycleR.minus(localizedZones);
                    this.tmpCycleW = outCycleW.minus(localizedZones);
                    this.tmpCycleRW = outCycleRW.minus(localizedZones);
                } else {
                    this.tmpCycleN = new BoolVector(this.nSEZ + this.nDZ);
                    this.tmpCycleR = new BoolVector(this.nSEZ + this.nDZ);
                    this.tmpCycleW = new BoolVector(this.nSEZ + this.nDZ);
                    this.tmpCycleRW = new BoolVector(this.nSEZ + this.nDZ);
                }
                if (outN != null) {
                    this.tmpCycleN.cumulOr(outN);
                    this.tmpCycleR.cumulOr(outR);
                    this.tmpCycleW.cumulOr(outW);
                    this.tmpCycleRW.cumulOr(outRW);
                }
                if (outCycleN != null) {
                    this.tmpN = outCycleN;
                    this.tmpR = outCycleR;
                    this.tmpW = outCycleW;
                    this.tmpRW = outCycleRW;
                } else {
                    this.tmpN = new BoolVector(this.nSEZ + this.nDZ);
                    this.tmpR = new BoolVector(this.nSEZ + this.nDZ);
                    this.tmpW = new BoolVector(this.nSEZ + this.nDZ);
                    this.tmpRW = new BoolVector(this.nSEZ + this.nDZ);
                }
                if (outN != null) {
                    this.tmpN.cumulOr(outN.and(directEntryExitMask));
                    this.tmpR.cumulOr(outR.and(directEntryExitMask));
                    this.tmpW.cumulOr(outW.and(directEntryExitMask));
                    this.tmpRW.cumulOr(outRW.and(directEntryExitMask));
                }
                if (this.traceCurAnalysis) {
                    TapEnv.printlnOnTrace("     THROUGH N:" + thruN + " R:" + thruR + " W:" + thruW + " RW:" + thruRW);
                }
                this.cumulThen(thruN, thruR, thruW, thruRW, this.tmpCycleN, this.tmpCycleR, this.tmpCycleW, this.tmpCycleRW);
                if (indexZones != null) {
                    this.setExtendedDeclaredZonesRead(indexZones, this.tmpCycleN, this.tmpCycleR, this.tmpCycleW, this.tmpCycleRW, indexTotal.get());
                }
                this.cumulThen(thruN, thruR, thruW, thruRW, this.tmpN, this.tmpR, this.tmpW, this.tmpRW);
                if (this.traceCurAnalysis) {
                    TapEnv.printlnOnTrace("          IN N:" + this.tmpN + " R:" + this.tmpR + " W:" + this.tmpW + " RW:" + this.tmpRW);
                    TapEnv.printlnOnTrace("   CYCLE  IN N:" + this.tmpCycleN + " R:" + this.tmpCycleR + " W:" + this.tmpCycleW + " RW:" + this.tmpCycleRW);
                }
                return true;
            }
            if (this.throughN.retrieve(this.curBlock) == null) {
                if (this.traceCurAnalysis) {
                    TapEnv.printlnOnTrace("    NO THROUGH!");
                }
                this.tmpRW = null;
                this.tmpW = null;
                this.tmpR = null;
                this.tmpN = null;
                return false;
            }
            if (this.traceCurAnalysis) {
                TapEnv.printlnOnTrace("         OUT N:" + this.tmpN + " R:" + this.tmpR + " W:" + this.tmpW + " RW:" + this.tmpRW);
                TapEnv.printlnOnTrace("     THROUGH N:" + this.throughN.retrieve(this.curBlock) + " R:" + this.throughR.retrieve(this.curBlock) + " W:" + this.throughW.retrieve(this.curBlock) + " RW:" + this.throughRW.retrieve(this.curBlock));
            }
            this.cumulThen(this.throughN.retrieve(this.curBlock), this.throughR.retrieve(this.curBlock), this.throughW.retrieve(this.curBlock), this.throughRW.retrieve(this.curBlock), this.tmpN, this.tmpR, this.tmpW, this.tmpRW);
            if (this.traceCurAnalysis) {
                TapEnv.printlnOnTrace("          IN N:" + this.tmpN + " R:" + this.tmpR + " W:" + this.tmpW + " RW:" + this.tmpRW);
            }
            return true;
        }
        if (this.fgSubPhase == 2) {
            BoolVector blockPW = this.throughW.retrieve(this.curBlock);
            if (blockPW != null) {
                blockPW = blockPW.or(this.throughRW.retrieve(this.curBlock));
                if (this.traceCurAnalysis) {
                    TapEnv.printlnOnTrace("   === Propagating constants upwards through Block " + this.curBlock + " ===");
                    TapEnv.printOnTrace("      " + this.tmpC + " throughW:" + blockPW);
                }
                this.tmpC.cumulMinus(blockPW);
                if (this.traceCurAnalysis) {
                    TapEnv.printlnOnTrace(" ==> " + this.tmpC);
                }
                return true;
            }
        } else if (this.fgSubPhase == 3) {
            BoolVector blockN = this.throughN.retrieve(this.curBlock);
            BoolVector blockR = this.throughR.retrieve(this.curBlock);
            BoolVector blockRW = this.throughRW.retrieve(this.curBlock);
            if (blockN != null) {
                this.tmpU.cumulOr(blockN.not());
                this.tmpU.cumulMinus(blockR.or(blockRW));
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean propagateValuesForwardThroughBlock() {
        if (this.fgSubPhase == 4) {
            BoolVector blockW = this.throughW.retrieve(this.curBlock);
            BoolVector blockRW = this.throughRW.retrieve(this.curBlock);
            if (this.traceCurAnalysis) {
                TapEnv.printlnOnTrace("   === Propagating initialized zones downwards through Block " + this.curBlock + " ===");
                TapEnv.printlnOnTrace("      " + this.tmpIZ + " plus " + blockW + " plus " + blockRW);
            }
            if (blockW != null) {
                this.tmpIZ.cumulOr(blockW);
                this.tmpIZ.cumulOr(blockRW);
                return true;
            }
        }
        return false;
    }

    private void inOutThroughExpression(Tree expression, int act, boolean total) {
        block0 : switch (expression.opCode()) {
            case 30: {
                MPIcallInfo messagePassingInfo;
                Unit calledUnit = InOutAnalyzer.getCalledUnit(expression, this.curSymbolTable);
                if (calledUnit == null) {
                    TapEnv.toolError("Could not find called Unit for main InOut analysis on " + expression);
                    break;
                }
                CallArrow callArrow = CallGraph.getCallArrow(this.curUnit, calledUnit);
                if (callArrow == null) {
                    TapEnv.toolError("Could not find call arrow from " + this.curUnit + " to " + calledUnit);
                    break;
                }
                Tree[] actualParams = ILUtils.getArguments(expression).children();
                int nbActualParams = actualParams.length;
                if (this.traceCurAnalysis) {
                    TapEnv.printlnOnTrace();
                    TapEnv.printlnOnTrace(" ---------- In-Out Analysis of procedure call " + ILUtils.toString(expression) + " : ----------");
                    TapEnv.printlnOnTrace("    downcoming In-Out       : N:" + this.tmpN + "  R:" + this.tmpR);
                    TapEnv.printlnOnTrace("                              W:" + this.tmpW + " RW:" + this.tmpRW);
                    TapEnv.printlnOnTrace("    Called unit public In-Out info:");
                    for (int i = 0; i < calledUnit.paramElemsNb(); ++i) {
                        ZoneInfo zi = calledUnit.paramElemZoneInfo(i);
                        if (zi == null) continue;
                        TapEnv.printOnTrace(" [" + i + "]" + zi.accessTreePrint(this.curUnit.language()));
                    }
                    TapEnv.printlnOnTrace();
                    TapEnv.printlnOnTrace("         N:" + calledUnit.unitInOutN + "  R:" + calledUnit.unitInOutR);
                    TapEnv.printlnOnTrace("         W:" + calledUnit.unitInOutW + " RW:" + calledUnit.unitInOutRW);
                }
                if (calledUnit.unitInOutN == null && (calledUnit.isVarFunction() || calledUnit.isInterface())) {
                    this.setExternalDefaultInOutInfo(calledUnit);
                }
                if (calledUnit.unitInOutN != null) {
                    int i;
                    this.detectAliasing(callArrow, actualParams, expression);
                    this.detectSegmentationFaults(callArrow, actualParams);
                    TapList<Object> resultDataN = new TapList<Object>(null, null);
                    BoolVector unitN = new BoolVector(this.nSEZ + this.nDZ);
                    unitN.setTrue();
                    TapList[] paramsN = InOutAnalyzer.propagateDataToCaller(calledUnit.unitInOutN, null, null, nbActualParams, unitN, this.vectorMap, resultDataN, this.curInstruction, callArrow, false, true, 0);
                    TapList<Object> resultDataR = new TapList<Object>(null, null);
                    BoolVector unitR = new BoolVector(this.nSEZ + this.nDZ);
                    TapList[] paramsR = InOutAnalyzer.propagateDataToCaller(calledUnit.unitInOutR, null, null, nbActualParams, unitR, this.vectorMap, resultDataR, this.curInstruction, callArrow, true, true, 0);
                    TapList<Object> resultDataW = new TapList<Object>(null, null);
                    BoolVector unitW = new BoolVector(this.nSEZ + this.nDZ);
                    TapList[] paramsW = InOutAnalyzer.propagateDataToCaller(calledUnit.unitInOutW, null, null, nbActualParams, unitW, this.vectorMap, resultDataW, this.curInstruction, callArrow, true, true, 0);
                    TapList<Object> resultDataRW = new TapList<Object>(null, null);
                    BoolVector unitRW = new BoolVector(this.nSEZ + this.nDZ);
                    TapList[] paramsRW = InOutAnalyzer.propagateDataToCaller(calledUnit.unitInOutRW, null, null, nbActualParams, unitRW, this.vectorMap, resultDataRW, this.curInstruction, callArrow, true, true, 0);
                    if (this.traceCurAnalysis) {
                        TapEnv.printlnOnTrace("     made private for the caller:");
                        TapEnv.printlnOnTrace("         N:" + unitN + "  R:" + unitR);
                        TapEnv.printlnOnTrace("         W:" + unitW + " RW:" + unitRW);
                    }
                    TapList[] actualParamZoneTrees = new TapList[nbActualParams];
                    boolean[] actualParamTotals = new boolean[nbActualParams];
                    ToBool paramTotal = new ToBool();
                    for (i = nbActualParams - 1; i >= 0; --i) {
                        paramTotal.set(false);
                        actualParamZoneTrees[i] = this.curSymbolTable.treeOfZonesOfValue(actualParams[i], paramTotal, this.curInstruction, null);
                        if (actualParamZoneTrees[i] != null) {
                            actualParamZoneTrees[i] = TapList.copyTree(actualParamZoneTrees[i]);
                            InOutAnalyzer.includePointedElementsInTree(actualParamZoneTrees[i], paramTotal, null, true, this.curSymbolTable, this.curInstruction, callArrow.destination, true, true);
                            actualParamTotals[i] = paramTotal.get();
                            if (calledUnit.passesByValue(i + 1, this.curUnit.language())) {
                                if (this.traceCurAnalysis) {
                                    TapEnv.printlnOnTrace(" .. passedByValue " + i + ':' + ILUtils.toString(actualParams[i]) + " (total:" + actualParamTotals[i] + ") zones:" + actualParamZoneTrees[i] + "  N:" + paramsN[i] + " R:" + paramsR[i] + " W:" + paramsW[i] + " RW:" + paramsRW[i]);
                                }
                                this.modifyByValueInfo(paramsN[i], paramsW[i]);
                                this.modifyByValueInfo(paramsR[i], paramsRW[i]);
                            }
                            this.modifyPointersRead(paramsR[i], paramsW[i], paramsRW[i]);
                            if (this.traceCurAnalysis) {
                                TapEnv.printlnOnTrace("     for argument " + i + ':' + ILUtils.toString(actualParams[i]) + " (total:" + actualParamTotals[i] + ") zones:" + actualParamZoneTrees[i] + "  N:" + paramsN[i] + " R:" + paramsR[i] + " W:" + paramsW[i] + " RW:" + paramsRW[i]);
                            }
                            this.setZoneTreeInOut(actualParamZoneTrees[i], this.tmpN, this.tmpR, this.tmpW, this.tmpRW, paramsN[i], paramsR[i], paramsW[i], paramsRW[i], actualParamTotals[i], 1, new TapList<Object>(null, null));
                            continue;
                        }
                        if (calledUnit.sameLanguage(this.curUnit.language()) || !calledUnit.isFortran()) continue;
                        TapIntList zones = ZoneInfo.listAllZones(calledUnit.argsPublicRankTrees[i + 1], true);
                        while (zones != null) {
                            ZoneInfo zoneInfo = calledUnit.paramElemZoneInfo(zones.head);
                            SymbolDecl symbolDecl = zoneInfo.ownerSymbolDecl;
                            if (symbolDecl instanceof VariableDecl) {
                                symbolDecl.addExtraInfo(new TapList<String>("value", null));
                            }
                            zones = zones.tail;
                        }
                    }
                    if (this.traceCurAnalysis) {
                        TapEnv.printlnOnTrace("    ==> before cumulThen N:" + this.tmpN + "  R:" + this.tmpR);
                        TapEnv.printlnOnTrace("                         W:" + this.tmpW + " RW:" + this.tmpRW);
                    }
                    this.cumulThen(unitN, unitR, unitW, unitRW, this.tmpN, this.tmpR, this.tmpW, this.tmpRW);
                    if (this.traceCurAnalysis) {
                        TapEnv.printlnOnTrace("    ==> after cumulThen  N:" + this.tmpN + "  R:" + this.tmpR);
                        TapEnv.printlnOnTrace("                         W:" + this.tmpW + " RW:" + this.tmpRW);
                    }
                    for (i = nbActualParams - 1; i >= 0; --i) {
                        if (actualParamZoneTrees[i] != null) {
                            this.setZoneTreeInOut(actualParamZoneTrees[i], this.tmpN, this.tmpR, this.tmpW, this.tmpRW, paramsN[i], paramsR[i], paramsW[i], paramsRW[i], actualParamTotals[i], -1, new TapList<Object>(null, null));
                            this.inOutThroughExpression(actualParams[i], 0, actualParamTotals[i]);
                            continue;
                        }
                        boolean paramRead = TapList.oneTrue(paramsR[i]) || TapList.oneTrue(paramsRW[i]);
                        this.inOutThroughExpression(actualParams[i], paramRead ? -1 : 0, actualParamTotals[i]);
                    }
                }
                if ((messagePassingInfo = MPIcallInfo.getMessagePassingMPIcallInfo(calledUnit.name, expression, this.curUnit.language(), this.curBlock)) != null && messagePassingInfo.isPointToPoint()) {
                    TapIntList messagePassingChannels = messagePassingInfo.findMessagePassingChannelZones(this.curCallGraph);
                    this.setExtendedDeclaredZonesWritten(messagePassingChannels, this.tmpN, this.tmpR, this.tmpW, this.tmpRW, false);
                    this.setExtendedDeclaredZonesRead(messagePassingChannels, this.tmpN, this.tmpR, this.tmpW, this.tmpRW, false);
                }
                if (!this.traceCurAnalysis) break;
                TapEnv.printlnOnTrace("    ==> final            N:" + this.tmpN + "  R:" + this.tmpR);
                TapEnv.printlnOnTrace("                         W:" + this.tmpW + " RW:" + this.tmpRW);
                break;
            }
            case 13: 
            case 62: 
            case 123: 
            case 147: 
            case 149: 
            case 185: {
                if (this.inADeclaration && this.curUnit.isFortran()) {
                    total = false;
                }
                this.inOutThroughExpression(expression.down(1), 1, total);
                this.inOutThroughExpression(expression.down(2), -1, total);
                break;
            }
            case 189: {
                String operName = ILUtils.getIdentString(expression.down(1));
                if (operName != null && (operName.equals("++prefix") || operName.equals("++postfix") || operName.equals("--prefix") || operName.equals("--postfix"))) {
                    ToBool expTotal = new ToBool(false);
                    TapList<?> valueZonesTree = this.curSymbolTable.treeOfZonesOfValue(expression.down(2), expTotal, this.curInstruction, null);
                    boolean totalAcccess = total && this.referenceIsTotal(expTotal.get(), valueZonesTree);
                    TapIntList valueZones = ZoneInfo.listAllZones(valueZonesTree, true);
                    this.setExtendedDeclaredZonesWritten(valueZones, this.tmpN, this.tmpR, this.tmpW, this.tmpRW, totalAcccess);
                    this.setExtendedDeclaredZonesRead(valueZones, this.tmpN, this.tmpR, this.tmpW, this.tmpRW, totalAcccess);
                    this.inOutThroughExpression(expression.down(2), 0, total);
                    break;
                }
                this.inOutThroughExpression(expression.down(2), -1, total);
                break;
            }
            case 8: 
            case 73: 
            case 94: 
            case 148: {
                if (act != 0) {
                    ToBool expTotal = new ToBool(false);
                    TapList valueZonesTree = this.curSymbolTable.treeOfZonesOfValue(expression, expTotal, this.curInstruction, null);
                    if (this.curUnit.isFortran() && TypeSpec.isA(this.curSymbolTable.typeOf(expression), 21)) {
                        valueZonesTree = this.curSymbolTable.includePointedElementsInZonesTree(valueZonesTree, this.curInstruction, null, true);
                    }
                    boolean totalAcccess = total && this.referenceIsTotal(expTotal.get(), valueZonesTree);
                    TapIntList valueZones = ZoneInfo.listAllZones(valueZonesTree, true);
                    if (this.traceCurAnalysis) {
                        TapEnv.printlnOnTrace("    detecting a " + (totalAcccess ? "total" : "partial") + (act == 1 ? " write" : " read") + " of zones " + valueZonesTree + " of expression " + expression + " => vectorIndices:" + this.mapExtendedDeclaredToVectorIndex(valueZones, 0, this.vectorMap));
                    }
                    if (act == 1) {
                        this.setExtendedDeclaredZonesWritten(valueZones, this.tmpN, this.tmpR, this.tmpW, this.tmpRW, totalAcccess);
                    } else {
                        this.setExtendedDeclaredZonesRead(valueZones, this.tmpN, this.tmpR, this.tmpW, this.tmpRW, totalAcccess);
                    }
                }
                switch (expression.opCode()) {
                    case 8: {
                        this.inOutThroughExpression(expression.down(1), 0, false);
                        Tree[] indexes = expression.down(2).children();
                        for (int i = indexes.length - 1; i >= 0; --i) {
                            this.inOutThroughExpression(indexes[i], -1, true);
                        }
                        break block0;
                    }
                    case 73: {
                        this.inOutThroughExpression(expression.down(1), 0, total);
                        break;
                    }
                    case 148: {
                        this.inOutThroughExpression(expression.down(1), -1, true);
                        this.inOutThroughExpression(expression.down(2), -1, true);
                        break;
                    }
                }
                break;
            }
            case 3: {
                this.inOutThroughExpression(expression.down(1), 0, total);
                break;
            }
            case 2: 
            case 5: 
            case 17: 
            case 21: 
            case 23: 
            case 41: 
            case 42: 
            case 58: 
            case 61: 
            case 67: 
            case 90: 
            case 93: 
            case 113: 
            case 114: 
            case 120: 
            case 124: 
            case 131: 
            case 135: 
            case 141: 
            case 152: 
            case 164: 
            case 177: 
            case 202: {
                this.inOutThroughExpression(expression.down(2), act, total);
                this.inOutThroughExpression(expression.down(1), act, total);
                break;
            }
            case 16: {
                this.inOutThroughExpression(expression.down(3), act, total);
                this.inOutThroughExpression(expression.down(1), act, total);
                break;
            }
            case 11: {
                this.inOutThroughExpression(expression.down(3), -1, total);
                this.inOutThroughExpression(expression.down(2), -1, total);
                this.inOutThroughExpression(expression.down(1), -1, total);
                break;
            }
            case 122: 
            case 137: {
                this.inOutThroughExpression(expression.down(1), act, total);
                break;
            }
            case 31: {
                this.inOutThroughExpression(expression.down(2), -1, total);
                break;
            }
            case 96: 
            case 179: 
            case 184: 
            case 191: 
            case 200: 
            case 201: {
                this.inOutThroughExpression(expression.down(1), -1, total);
                break;
            }
            case 97: {
                this.inOutThroughExpression(expression.down(3), act, total);
                this.inOutThroughExpression(expression.down(2), act, total);
                this.inOutThroughExpression(expression.down(1), -1, total);
                break;
            }
            case 132: {
                this.inOutThroughExpression(expression.down(2), -1, total);
                break;
            }
            case 142: 
            case 143: {
                break;
            }
            case 119: {
                this.inOutThroughExpression(expression.down(3), 0, total);
                break;
            }
            case 107: {
                String ioOper = ILUtils.getIdentString(expression.down(1));
                Tree[] ioSpecs = expression.down(2).children();
                ToBool written = new ToBool(false);
                ToBool totally = new ToBool(false);
                for (int i = ioSpecs.length - 1; i >= 0; --i) {
                    Tree targets = InOutAnalyzer.getIOeffectOfIOspec(ioSpecs[i], i, ioOper, written, totally, this.curSymbolTable);
                    act = written.get() ? 1 : -1;
                    this.inOutThroughExpression(targets, act, totally.get());
                }
                this.inOutThroughExpression(expression.down(3), ILUtils.isIORead(expression) ? 1 : -1, true);
                int zoneIO = this.curCallGraph.zoneNbOfAllIOStreams;
                this.tmpR.setDeclared(zoneIO, this.vectorMap, true);
                this.tmpW.setDeclared(zoneIO, this.vectorMap, true);
                break;
            }
            case 46: {
                Tree[] args = expression.down(3).children();
                for (int i = args.length - 1; i >= 0; --i) {
                    this.inOutThroughExpression(args[i], -1, true);
                }
                break;
            }
            case 108: {
                this.inOutThroughExpression(expression.down(1), act, total);
                this.inOutThroughExpression(expression.down(2), -1, true);
                break;
            }
            case 7: 
            case 59: 
            case 70: 
            case 81: {
                Tree[] exprs = expression.children();
                for (int i = exprs.length - 1; i >= 0; --i) {
                    this.inOutThroughExpression(exprs[i], act, total);
                }
                break;
            }
            case 9: {
                Tree[] exprs = expression.children();
                for (int i = exprs.length - 1; i >= 0; --i) {
                    this.inOutThroughExpression(exprs[i], -1, total);
                }
                break;
            }
            case 78: {
                this.inOutThroughExpression(expression.down(2), act, total);
                this.inOutThroughExpression(expression.down(1), act, total);
                break;
            }
            case 63: 
            case 80: {
                this.inOutThroughExpression(expression.down(1), 1, total);
                this.inOutThroughExpression(expression.down(2), -1, total);
                this.inOutThroughExpression(expression.down(3), -1, total);
                this.inOutThroughExpression(expression.down(4), -1, total);
                break;
            }
            case 79: {
                this.inOutThroughExpression(expression.down(2), -1, total);
                this.inOutThroughExpression(expression.down(1), -1, total);
                break;
            }
            case 77: {
                this.inOutThroughExpression(expression.down(3), 1, total);
                this.inOutThroughExpression(expression.down(2), -1, total);
                this.inOutThroughExpression(expression.down(1), -1, total);
                break;
            }
            case 163: {
                this.inOutThroughExpression(expression.down(2), -1, total);
                if (ILUtils.isNullOrNone(expression.down(1))) break;
                String returnName = this.curUnit.name;
                if (this.curUnit.otherReturnVar() != null) {
                    returnName = this.curUnit.otherReturnVar().symbol;
                }
                Tree returnTree = ILUtils.build(94, returnName);
                this.inOutThroughExpression(returnTree, 1, total);
                this.inOutThroughExpression(expression.down(1), -1, total);
                break;
            }
            case 174: {
                this.tmpN = new BoolVector(this.nSEZ + this.nDZ);
                this.tmpN.setTrue();
                this.tmpR = new BoolVector(this.nSEZ + this.nDZ);
                this.tmpW = new BoolVector(this.nSEZ + this.nDZ);
                this.tmpRW = new BoolVector(this.nSEZ + this.nDZ);
                break;
            }
            case 51: 
            case 138: {
                this.inOutThroughExpression(expression.down(1), 1, total);
                break;
            }
            case 14: 
            case 19: 
            case 27: 
            case 29: 
            case 39: 
            case 83: 
            case 92: 
            case 101: 
            case 109: 
            case 116: 
            case 136: 
            case 155: 
            case 172: 
            case 175: 
            case 176: {
                break;
            }
            case 194: {
                Tree[] exprs = expression.down(3).children();
                for (int i = exprs.length - 1; i >= 0; --i) {
                    Tree declarator = exprs[i];
                    if (declarator.opCode() == 13) {
                        ILUtils.turnAssignFromInitDecl(declarator);
                    }
                    this.inOutThroughExpression(declarator, 0, total);
                    if (declarator.opCode() != 13) continue;
                    ILUtils.resetAssignFromInitDecl(declarator);
                }
                break;
            }
            case 50: {
                this.inOutThroughExpression(expression.down(1), 1, false);
                break;
            }
            case 4: {
                break;
            }
            case 171: {
                this.inOutThroughExpression(expression.down(1), -1, total);
                break;
            }
            case 150: {
                this.inOutThroughExpression(expression.down(1), act, total);
                break;
            }
            case 88: 
            case 170: {
                this.inOutThroughExpression(expression.down(1), act, total);
                this.inOutThroughExpression(expression.down(2), -1, total);
                break;
            }
            case 10: {
                if (act == 1 && this.curUnit.isC()) {
                    Tree access = ILUtils.build(148, ILUtils.copy(expression.down(1)));
                    this.inOutThroughExpression(access, 1, true);
                }
                if (this.curUnit.isC() && !ILUtils.isNullOrNoneOrEmptyList(expression.down(2))) {
                    this.inOutThroughExpression(expression.down(1), 1, true);
                } else {
                    this.inOutThroughExpression(expression.down(1), act, true);
                }
                this.inOutThroughExpression(expression.down(2), -1, false);
                break;
            }
            case 35: 
            case 45: 
            case 55: 
            case 87: {
                break;
            }
            case 1: 
            case 12: 
            case 28: 
            case 34: 
            case 38: 
            case 40: 
            case 44: 
            case 48: 
            case 66: 
            case 68: 
            case 72: 
            case 76: 
            case 89: 
            case 99: 
            case 102: 
            case 104: 
            case 106: 
            case 127: 
            case 133: 
            case 151: 
            case 156: 
            case 166: 
            case 187: 
            case 190: 
            case 192: 
            case 197: 
            case 199: {
                break;
            }
            default: {
                TapEnv.toolWarning(-1, "(In-out analysis) Unexpected operator: " + expression.opName());
            }
        }
    }

    private void setExtendedDeclaredZonesRead(TapIntList allZones, BoolVector tmpN, BoolVector tmpR, BoolVector tmpW, BoolVector tmpRW, boolean totalAccess) {
        while (allZones != null) {
            int z = this.extendedDeclaredToVectorIndex(allZones.head, 0, this.vectorMap);
            if (z > 0 && tmpN.get(z)) {
                tmpR.set(z, true);
                if (totalAccess) {
                    tmpN.set(z, false);
                }
            }
            if (z > 0 && tmpW.get(z)) {
                tmpRW.set(z, true);
                if (totalAccess) {
                    tmpW.set(z, false);
                }
            }
            allZones = allZones.tail;
        }
    }

    private void setExtendedDeclaredZonesWritten(TapIntList allZones, BoolVector tmpN, BoolVector tmpR, BoolVector tmpW, BoolVector tmpRW, boolean totalAccess) {
        while (allZones != null) {
            int z = this.extendedDeclaredToVectorIndex(allZones.head, 0, this.vectorMap);
            tmpW.set(z, true);
            if (totalAccess) {
                tmpN.set(z, false);
                tmpR.set(z, false);
                tmpRW.set(z, false);
            }
            allZones = allZones.tail;
        }
    }

    private void setZoneTreeInOut(TapList zonesTree, BoolVector tmpN, BoolVector tmpR, BoolVector tmpW, BoolVector tmpRW, TapList treeN, TapList treeR, TapList treeW, TapList treeRW, boolean total, int action, TapList<TapList> dejaVu) {
        while (zonesTree != null) {
            if (TapList.contains(dejaVu.tail, zonesTree)) {
                zonesTree = new TapList<TapIntList>(ZoneInfo.listAllZones(zonesTree, true), null);
            } else {
                dejaVu.placdl(zonesTree);
            }
            if (zonesTree.head instanceof TapList) {
                this.setZoneTreeInOut((TapList)zonesTree.head, tmpN, tmpR, tmpW, tmpRW, treeN != null && treeN.head instanceof TapList ? (TapList)treeN.head : treeN, treeR != null && treeR.head instanceof TapList ? (TapList)treeR.head : treeR, treeW != null && treeW.head instanceof TapList ? (TapList)treeW.head : treeW, treeRW != null && treeRW.head instanceof TapList ? (TapList)treeRW.head : treeRW, total, action, dejaVu);
            } else {
                boolean oneN = TapList.oneTrueInHead(treeN);
                boolean oneR = TapList.oneTrueInHead(treeR);
                boolean oneW = TapList.oneTrueInHead(treeW);
                boolean oneRW = TapList.oneTrueInHead(treeRW);
                if (action == 1) {
                    if (oneW || oneRW) {
                        this.setExtendedDeclaredZonesWritten((TapIntList)zonesTree.head, tmpN, tmpR, tmpW, tmpRW, total && !oneN && !oneR);
                    }
                } else if (oneR || oneRW) {
                    this.setExtendedDeclaredZonesRead((TapIntList)zonesTree.head, tmpN, tmpR, tmpW, tmpRW, total && !oneN && !oneW);
                }
            }
            zonesTree = zonesTree.tail;
            if (treeN != null) {
                treeN = treeN.tail;
            }
            if (treeR != null) {
                treeR = treeR.tail;
            }
            if (treeW != null) {
                treeW = treeW.tail;
            }
            if (treeRW == null) continue;
            treeRW = treeRW.tail;
        }
    }

    private void modifyByValueInfo(TapList paramWithoutWrite, TapList paramWithWrite) {
        while (paramWithoutWrite != null && paramWithWrite != null) {
            if (paramWithoutWrite.head instanceof TapList && paramWithWrite.head instanceof TapList) {
                this.modifyByValueInfo((TapList)paramWithoutWrite.head, (TapList)paramWithWrite.head);
                paramWithoutWrite = paramWithoutWrite.tail;
                paramWithWrite = paramWithWrite.tail;
                continue;
            }
            if (!(paramWithoutWrite.head instanceof Boolean) || !(paramWithWrite.head instanceof Boolean)) continue;
            if (((Boolean)paramWithWrite.head).booleanValue()) {
                paramWithWrite.head = Boolean.FALSE;
                paramWithoutWrite.head = Boolean.TRUE;
            }
            paramWithoutWrite = null;
            paramWithWrite = null;
        }
    }

    private void modifyPointersRead(TapList paramR, TapList paramW, TapList paramRW) {
        if (paramR.head instanceof TapList) {
            while (paramR != null) {
                this.modifyPointersRead((TapList)paramR.head, (TapList)paramW.head, (TapList)paramRW.head);
                paramR = paramR.tail;
                paramW = paramW.tail;
                paramRW = paramRW.tail;
            }
        } else if (TapList.oneTrue(paramR.tail) || TapList.oneTrue(paramW.tail) || TapList.oneTrue(paramRW.tail)) {
            paramR.head = Boolean.TRUE;
        }
    }

    @Override
    protected void cumulValueWithAdditional(SymbolTable commonSymbolTable) {
        int commonLength = this.nSEZ + commonSymbolTable.declaredZonesNb(0);
        if (this.fgPhase == 1) {
            if (this.tmpN == null) {
                this.tmpN = new BoolVector(this.nSEZ + this.nDZ);
            }
            if (this.additionalN != null) {
                this.tmpN.cumulOr(this.additionalN, commonLength);
            }
            if (this.tmpR == null) {
                this.tmpR = new BoolVector(this.nSEZ + this.nDZ);
            }
            if (this.additionalR != null) {
                this.tmpR.cumulOr(this.additionalR, commonLength);
            }
            if (this.tmpW == null) {
                this.tmpW = new BoolVector(this.nSEZ + this.nDZ);
            }
            if (this.additionalW != null) {
                this.tmpW.cumulOr(this.additionalW, commonLength);
            }
            if (this.tmpRW == null) {
                this.tmpRW = new BoolVector(this.nSEZ + this.nDZ);
            }
            if (this.additionalRW != null) {
                this.tmpRW.cumulOr(this.additionalRW, commonLength);
            }
        } else if (this.fgSubPhase == 2) {
            if (this.tmpC == null) {
                this.tmpC = new BoolVector(this.nSEZ + this.nDZ);
                this.tmpC.setTrue();
            }
            this.tmpC.cumulAnd(this.additionalC, commonLength);
        } else if (this.fgSubPhase == 3) {
            if (this.tmpU == null) {
                this.tmpU = new BoolVector(this.nSEZ + this.nDZ);
                this.tmpU.setTrue();
            }
            this.tmpU.cumulAnd(this.additionalU, commonLength);
        } else if (this.fgSubPhase == 4) {
            if (this.tmpIZ == null) {
                this.tmpIZ = new BoolVector(this.nSEZ + this.nDZ);
            }
            this.tmpIZ.cumulOr(this.additionalIZ, commonLength);
        }
    }

    @Override
    protected void cumulCycleValueWithAdditional(SymbolTable commonSymbolTable) {
        int commonLength = this.nSEZ + commonSymbolTable.declaredZonesNb(0);
        if (this.fgPhase == 1) {
            if (this.traceCurAnalysis) {
                TapEnv.printlnOnTrace("cumulCycleValueWithAdditional");
                TapEnv.printlnOnTrace(" tmpCycle    N:" + this.tmpCycleN + " R:" + this.tmpCycleR + " W:" + this.tmpCycleW + " RW:" + this.tmpCycleRW);
                TapEnv.printlnOnTrace(" addit       N:" + this.additionalN + " R:" + this.additionalR + " W:" + this.additionalW + " RW:" + this.additionalRW);
            }
            if (this.tmpCycleN == null) {
                this.tmpCycleN = new BoolVector(this.nSEZ + this.nDZ);
            }
            if (this.additionalN != null) {
                this.tmpCycleN.cumulOr(this.additionalN, commonLength);
            }
            if (this.tmpCycleR == null) {
                this.tmpCycleR = new BoolVector(this.nSEZ + this.nDZ);
            }
            if (this.additionalR != null) {
                this.tmpCycleR.cumulOr(this.additionalR, commonLength);
            }
            if (this.tmpCycleW == null) {
                this.tmpCycleW = new BoolVector(this.nSEZ + this.nDZ);
            }
            if (this.additionalW != null) {
                this.tmpCycleW.cumulOr(this.additionalW, commonLength);
            }
            if (this.tmpCycleRW == null) {
                this.tmpCycleRW = new BoolVector(this.nSEZ + this.nDZ);
            }
            if (this.additionalRW != null) {
                this.tmpCycleRW.cumulOr(this.additionalRW, commonLength);
            }
            if (this.traceCurAnalysis) {
                TapEnv.printlnOnTrace("cumulCycleValueWithAdditional-->");
                TapEnv.printlnOnTrace(" tmpCycl>>   N:" + this.tmpCycleN + " R:" + this.tmpCycleR + " W:" + this.tmpCycleW + " RW:" + this.tmpCycleRW);
            }
        } else {
            this.cumulValueWithAdditional(commonSymbolTable);
        }
    }

    private void cumulThen(BoolVector addedN, BoolVector addedR, BoolVector addedW, BoolVector addedRW, BoolVector cumulN, BoolVector cumulR, BoolVector cumulW, BoolVector cumulRW) {
        BoolVector tmpVect = addedR.or(addedN);
        cumulRW.cumulAnd(tmpVect);
        cumulRW.cumulOr(addedR.and(cumulW));
        cumulRW.cumulOr(addedRW);
        cumulW.cumulAnd(addedN);
        cumulW.cumulOr(addedW);
        cumulR.cumulAnd(tmpVect);
        cumulR.cumulOr(addedR.and(cumulN));
        cumulN.cumulAnd(addedN);
    }

    @Override
    protected void setEmptyCumulAndCycleValues() {
        if (this.fgPhase == 1) {
            this.tmpRW = null;
            this.tmpW = null;
            this.tmpR = null;
            this.tmpN = null;
            this.tmpCycleRW = null;
            this.tmpCycleW = null;
            this.tmpCycleR = null;
            this.tmpCycleN = null;
        } else if (this.fgSubPhase == 2) {
            this.tmpC = null;
        } else if (this.fgSubPhase == 3) {
            this.tmpU = null;
        } else if (this.fgSubPhase == 4) {
            this.tmpIZ = null;
        }
    }

    @Override
    protected boolean getValueFlowingBack() {
        Block destination = this.curArrow.destination;
        if (this.fgPhase == 1) {
            boolean result;
            if (InOutAnalyzer.runSpecialCycleAnalysis(destination) && this.curArrow.finalCycle() == destination.enclosingLoop()) {
                this.additionalN = this.beforeCycleN.retrieve(destination);
                if (this.additionalN != null) {
                    this.additionalR = this.beforeCycleR.retrieve(destination);
                    this.additionalW = this.beforeCycleW.retrieve(destination);
                    this.additionalRW = this.beforeCycleRW.retrieve(destination);
                    result = true;
                } else {
                    result = false;
                }
            } else {
                this.additionalN = this.beforeN.retrieve(destination);
                if (this.additionalN != null) {
                    this.additionalR = this.beforeR.retrieve(destination);
                    this.additionalW = this.beforeW.retrieve(destination);
                    this.additionalRW = this.beforeRW.retrieve(destination);
                    result = true;
                } else {
                    result = false;
                }
            }
            if (this.traceCurAnalysis) {
                TapEnv.printlnOnTrace();
                TapEnv.printOnTrace("   === Flowing across " + this.curArrow + " (cycle:" + (InOutAnalyzer.runSpecialCycleAnalysis(destination) && this.curArrow.finalCycle() == destination.enclosingLoop()) + "): ");
                if (result) {
                    TapEnv.printOnTrace("N:" + this.additionalN + " R:" + this.additionalR + " W:" + this.additionalW + " RW:" + this.additionalRW);
                } else {
                    TapEnv.printOnTrace("null");
                }
                TapEnv.printlnOnTrace();
            }
            return result;
        }
        if (this.fgSubPhase == 2) {
            this.additionalC = destination.constantZones;
            return this.additionalC != null;
        }
        if (this.fgSubPhase == 3) {
            this.additionalU = destination.unusedZones;
            return this.additionalU != null;
        }
        return false;
    }

    @Override
    protected boolean getValueFlowingThrough() {
        Block origin = this.curArrow.origin;
        if (this.fgSubPhase == 4) {
            this.additionalIZ = this.afterIZ.retrieve(origin);
            return this.additionalIZ != null;
        }
        return false;
    }

    @Override
    protected void initializeCumulValue() {
        if (this.fgPhase == 1) {
            this.tmpN = new BoolVector(this.nSEZ + this.nDZ);
            this.tmpR = new BoolVector(this.nSEZ + this.nDZ);
            this.tmpW = new BoolVector(this.nSEZ + this.nDZ);
            this.tmpRW = new BoolVector(this.nSEZ + this.nDZ);
        } else if (this.fgSubPhase == 2) {
            this.tmpC = new BoolVector(this.nSEZ + this.nDZ);
        } else if (this.fgSubPhase == 3) {
            this.tmpU = new BoolVector(this.nSEZ + this.nDZ);
        } else if (this.fgSubPhase == 4) {
            this.tmpIZ = new BoolVector(this.nSEZ + this.nDZ);
        }
    }

    private void setExternalDefaultInOutInfo(Unit unit) {
        int systemZone;
        int ioIndex;
        int n = unit.paramElemsNb();
        unit.unitInOutN = new BoolVector(n);
        unit.unitInOutN.setTrue();
        unit.unitInOutR = new BoolVector(n);
        unit.unitInOutR.setTrue();
        unit.unitInOutW = new BoolVector(n);
        unit.unitInOutW.setTrue();
        unit.unitInOutRW = new BoolVector(n);
        unit.unitInOutRW.setTrue();
        int returnIndex = -1;
        while (n > 0 && returnIndex == -1) {
            if (unit.paramElemZoneInfo(--n) == null || !unit.paramElemZoneInfo(n).isResult()) continue;
            returnIndex = n;
        }
        if (returnIndex != -1) {
            unit.unitInOutN.set(returnIndex, false);
            unit.unitInOutR.set(returnIndex, false);
            unit.unitInOutW.set(returnIndex, true);
            unit.unitInOutRW.set(returnIndex, false);
        }
        if ((ioIndex = TapEnv.zoneOfIO(unit)) != -1) {
            unit.unitInOutN.set(ioIndex, true);
            unit.unitInOutR.set(ioIndex, false);
            unit.unitInOutW.set(ioIndex, false);
            unit.unitInOutRW.set(ioIndex, false);
        }
        SymbolTable rootSymbolTable = unit.callGraph().languageRootSymbolTable(unit.language());
        TapIntList systemPredefinedZones = rootSymbolTable.systemPredefinedZones();
        while (systemPredefinedZones != null) {
            systemZone = systemPredefinedZones.head;
            unit.unitInOutN.set(systemZone, true);
            unit.unitInOutR.set(systemZone, false);
            unit.unitInOutW.set(systemZone, false);
            unit.unitInOutRW.set(systemZone, false);
            systemPredefinedZones = systemPredefinedZones.tail;
        }
        if (unit.callGraph().cRootSymbolTable() != null) {
            TapIntList globalConstantZones = unit.callGraph().cRootSymbolTable().constantZones();
            while (globalConstantZones != null) {
                systemZone = globalConstantZones.head;
                unit.unitInOutN.set(systemZone, true);
                unit.unitInOutR.set(systemZone, true);
                unit.unitInOutW.set(systemZone, false);
                unit.unitInOutRW.set(systemZone, false);
                globalConstantZones = globalConstantZones.tail;
            }
        }
        if (unit.callersThatCall() != null) {
            String unitSort = unit.isInterface() ? "Interface " : "External routine ";
            TapEnv.fileWarning(15, null, "(DF05) " + unitSort + unit.name + ", called by " + unit.callerUnitNamesThatCall() + ", is assumed default In:" + unit.unitInOutR.or(unit.unitInOutRW).toString(unit.paramElemsNb()) + " and Out:" + unit.unitInOutW.or(unit.unitInOutRW).toString(unit.paramElemsNb()));
        }
    }

    private void detectUsedUndef(Block block, BoolVector beforeBlockIZ) {
        if (beforeBlockIZ != null) {
            TapList<Instruction> instructions = block.instructions;
            this.curSymbolTable = block.symbolTable;
            while (instructions != null) {
                Tree tree = ((Instruction)instructions.head).tree;
                if (tree != null) {
                    this.curInstruction = (Instruction)instructions.head;
                    this.usedUndefThroughExpression(tree, beforeBlockIZ, 0);
                    this.curInstruction = null;
                }
                instructions = instructions.tail;
            }
        }
    }

    private void usedUndefThroughExpression(Tree expression, BoolVector beforeExprIZ, int act) {
        switch (expression.opCode()) {
            case 30: {
                Unit calledUnit = InOutAnalyzer.getCalledUnit(expression, this.curSymbolTable);
                if (calledUnit == null) {
                    TapEnv.toolError("Could not find called Unit for usedUndef InOut analysis on " + expression);
                    break;
                }
                CallArrow callArrow = CallGraph.getCallArrow(this.curUnit, calledUnit);
                Tree[] actualParams = ILUtils.getArguments(expression).children();
                int nbArgs = actualParams.length;
                if (callArrow == null || calledUnit.unitInOutN() == null) break;
                BoolVector unitCR = calledUnit.unitInOutCertainlyR();
                BoolVector unitPW = calledUnit.unitInOutPossiblyW();
                BoolVector callCR = new BoolVector(this.nSEZ + this.nDZ);
                TapList[] paramsCR = InOutAnalyzer.propagateDataToCaller(unitCR, null, null, nbArgs, callCR, this.vectorMap, null, this.curInstruction, callArrow, true, true, 0);
                BoolVector callPW = new BoolVector(this.nSEZ + this.nDZ);
                TapList[] paramsPW = InOutAnalyzer.propagateDataToCaller(unitPW, null, null, nbArgs, callPW, this.vectorMap, null, this.curInstruction, callArrow, true, false, 0);
                if (this.traceCurAnalysis) {
                    TapEnv.printlnOnTrace();
                    TapEnv.printlnOnTrace(" Unit called " + calledUnit);
                    TapEnv.printlnOnTrace("    Unit Certainly Read   " + unitCR);
                    TapEnv.printlnOnTrace("    Unit Possibly Written " + unitPW);
                }
                for (int i = 0; i < nbArgs; ++i) {
                    this.usedUndefThroughExpression(actualParams[i], beforeExprIZ, 0);
                    TapList<?> argZones = this.curSymbolTable.treeOfZonesOfValue(actualParams[i], null, this.curInstruction, null);
                    this.usedUndefThroughArgZonesTree(argZones, paramsCR[i], paramsPW[i], beforeExprIZ, actualParams[i]);
                }
                for (int dz = this.nDZ - 1; dz > 0; --dz) {
                    if (beforeExprIZ.getDeclared(dz, this.vectorMap) || !callCR.getDeclared(dz, this.vectorMap)) continue;
                    ZoneInfo zoneInfo = this.curBlock.symbolTable.declaredZoneInfo(dz, 0);
                    TapEnv.fileWarning(15, expression, "(DF03) variable " + zoneInfo.publicName() + " is used before initialized");
                }
                for (int sez = this.nSEZ - 1; sez > 0; --sez) {
                    if (beforeExprIZ.getSideEffect(sez) || !callCR.getSideEffect(sez)) continue;
                    ZoneInfo zoneInfo = this.curUnit.sideEffectZoneInfo(sez, 0);
                    TapEnv.fileWarning(15, expression, "(DF03) variable " + zoneInfo.publicName() + " is used before initialized");
                }
                beforeExprIZ.cumulOr(callPW);
                if (!this.traceCurAnalysis) break;
                TapEnv.printlnOnTrace(" beforeExprIZ " + beforeExprIZ);
                break;
            }
            case 13: 
            case 62: 
            case 123: 
            case 147: 
            case 185: {
                this.usedUndefThroughExpression(expression.down(2), beforeExprIZ, -1);
                this.usedUndefThroughExpression(expression.down(1), beforeExprIZ, 1);
                break;
            }
            case 189: {
                this.usedUndefThroughExpression(expression.down(2), beforeExprIZ, -1);
                break;
            }
            case 8: 
            case 73: 
            case 94: 
            case 148: {
                switch (expression.opCode()) {
                    case 8: {
                        Tree[] indexes = expression.down(2).children();
                        for (int i = indexes.length - 1; i >= 0; --i) {
                            this.usedUndefThroughExpression(indexes[i], beforeExprIZ, -1);
                        }
                        this.usedUndefThroughExpression(expression.down(1), beforeExprIZ, 0);
                        break;
                    }
                    case 73: {
                        this.usedUndefThroughExpression(expression.down(1), beforeExprIZ, 0);
                        break;
                    }
                    case 148: {
                        this.usedUndefThroughExpression(expression.down(1), beforeExprIZ, -1);
                        this.usedUndefThroughExpression(expression.down(2), beforeExprIZ, -1);
                        break;
                    }
                }
                if (act == 0) break;
                TapIntList valueZonesList = ZoneInfo.listAllZones(this.curSymbolTable.treeOfZonesOfValue(expression, null, this.curInstruction, null), true);
                if (act == -1) {
                    if (valueZonesList == null) break;
                    if (valueZonesList.head == -3 && valueZonesList.tail == null) {
                        TapEnv.fileWarning(15, expression, "(DF03) expression " + ILUtils.toString(expression, this.curUnit.language()) + " derefs a NULL pointer");
                        break;
                    }
                    if (valueZonesList.head == -2 && valueZonesList.tail == null) {
                        TapEnv.fileWarning(15, expression, "(DF03) expression " + ILUtils.toString(expression, this.curUnit.language()) + " is undefined");
                        break;
                    }
                    if (InOutAnalyzer.intersectsExtendedDeclared(beforeExprIZ, InOutAnalyzer.makeMap3(this.nSEZ, 0, this.nDZ), 0, valueZonesList, null, this.curSymbolTable, null)) break;
                    TapEnv.fileWarning(15, expression, "(DF03) variable " + ILUtils.toString(expression, this.curUnit.language()) + " is used before initialized");
                    break;
                }
                if (act != 1) break;
                this.setExtendedDeclared(beforeExprIZ, InOutAnalyzer.makeMap3(this.nSEZ, 0, this.nDZ), 0, valueZonesList, true);
                break;
            }
            case 2: 
            case 5: 
            case 17: 
            case 21: 
            case 23: 
            case 41: 
            case 42: 
            case 58: 
            case 61: 
            case 67: 
            case 90: 
            case 93: 
            case 113: 
            case 114: 
            case 120: 
            case 124: 
            case 131: 
            case 135: 
            case 141: 
            case 152: 
            case 164: 
            case 177: 
            case 202: {
                this.usedUndefThroughExpression(expression.down(1), beforeExprIZ, -1);
                this.usedUndefThroughExpression(expression.down(2), beforeExprIZ, -1);
                break;
            }
            case 16: {
                this.usedUndefThroughExpression(expression.down(2), beforeExprIZ, -1);
                this.usedUndefThroughExpression(expression.down(3), beforeExprIZ, -1);
                break;
            }
            case 11: {
                this.usedUndefThroughExpression(expression.down(1), beforeExprIZ, -1);
                this.usedUndefThroughExpression(expression.down(2), beforeExprIZ, -1);
                this.usedUndefThroughExpression(expression.down(3), beforeExprIZ, -1);
                break;
            }
            case 122: 
            case 137: {
                this.usedUndefThroughExpression(expression.down(1), beforeExprIZ, -1);
                break;
            }
            case 96: 
            case 179: 
            case 184: 
            case 191: 
            case 200: 
            case 201: {
                this.usedUndefThroughExpression(expression.down(1), beforeExprIZ, -1);
                break;
            }
            case 97: {
                this.usedUndefThroughExpression(expression.down(1), beforeExprIZ, -1);
                this.usedUndefThroughExpression(expression.down(2), beforeExprIZ, act);
                this.usedUndefThroughExpression(expression.down(3), beforeExprIZ, act);
                break;
            }
            case 31: 
            case 132: {
                this.usedUndefThroughExpression(expression.down(2), beforeExprIZ, act);
                break;
            }
            case 142: 
            case 143: {
                break;
            }
            case 119: {
                this.usedUndefThroughExpression(expression.down(3), beforeExprIZ, 0);
                break;
            }
            case 107: {
                String ioOper = ILUtils.getIdentString(expression.down(1));
                Tree[] ioSpecs = expression.down(2).children();
                ToBool written = new ToBool(false);
                ToBool totally = new ToBool(false);
                for (int i = ioSpecs.length - 1; i >= 0; --i) {
                    Tree targets = InOutAnalyzer.getIOeffectOfIOspec(ioSpecs[i], i, ioOper, written, totally, this.curSymbolTable);
                    act = written.get() ? 1 : -1;
                    this.usedUndefThroughExpression(targets, beforeExprIZ, act);
                }
                this.usedUndefThroughExpression(expression.down(3), beforeExprIZ, ILUtils.isIORead(expression) ? 1 : -1);
                break;
            }
            case 46: {
                Tree[] args = expression.down(3).children();
                for (int i = args.length - 1; i >= 0; --i) {
                    this.usedUndefThroughExpression(args[i], beforeExprIZ, -1);
                }
                break;
            }
            case 108: {
                this.usedUndefThroughExpression(expression.down(2), beforeExprIZ, -1);
                this.usedUndefThroughExpression(expression.down(1), beforeExprIZ, act);
                break;
            }
            case 7: 
            case 59: 
            case 70: 
            case 81: {
                Tree[] exprs = expression.children();
                for (int i = exprs.length - 1; i >= 0; --i) {
                    this.usedUndefThroughExpression(exprs[i], beforeExprIZ, act);
                }
                break;
            }
            case 9: {
                Tree[] exprs = expression.children();
                for (int i = exprs.length - 1; i >= 0; --i) {
                    this.usedUndefThroughExpression(exprs[i], beforeExprIZ, -1);
                }
                break;
            }
            case 78: {
                this.usedUndefThroughExpression(expression.down(1), beforeExprIZ, act);
                this.usedUndefThroughExpression(expression.down(2), beforeExprIZ, act);
                break;
            }
            case 63: 
            case 80: {
                this.usedUndefThroughExpression(expression.down(2), beforeExprIZ, -1);
                this.usedUndefThroughExpression(expression.down(3), beforeExprIZ, -1);
                this.usedUndefThroughExpression(expression.down(4), beforeExprIZ, -1);
                this.usedUndefThroughExpression(expression.down(1), beforeExprIZ, 1);
                break;
            }
            case 79: {
                this.usedUndefThroughExpression(expression.down(1), beforeExprIZ, -1);
                this.usedUndefThroughExpression(expression.down(2), beforeExprIZ, -1);
                break;
            }
            case 77: {
                this.usedUndefThroughExpression(expression.down(1), beforeExprIZ, -1);
                this.usedUndefThroughExpression(expression.down(2), beforeExprIZ, -1);
                this.usedUndefThroughExpression(expression.down(3), beforeExprIZ, 1);
                break;
            }
            case 163: {
                this.usedUndefThroughExpression(expression.down(1), beforeExprIZ, -1);
                this.usedUndefThroughExpression(expression.down(2), beforeExprIZ, -1);
                break;
            }
            case 150: {
                this.usedUndefThroughExpression(expression.down(1), beforeExprIZ, act);
                break;
            }
            case 88: 
            case 170: {
                this.usedUndefThroughExpression(expression.down(1), beforeExprIZ, act);
                this.usedUndefThroughExpression(expression.down(2), beforeExprIZ, -1);
                break;
            }
            case 10: {
                this.usedUndefThroughExpression(expression.down(2), beforeExprIZ, -1);
                if (this.curUnit.isC() && !ILUtils.isNullOrNoneOrEmptyList(expression.down(2))) {
                    this.usedUndefThroughExpression(expression.down(1), beforeExprIZ, 1);
                } else {
                    this.usedUndefThroughExpression(expression.down(1), beforeExprIZ, act);
                }
                if (act != 1 || !this.curUnit.isC()) break;
                Tree access = ILUtils.build(148, ILUtils.copy(expression.down(1)));
                this.usedUndefThroughExpression(access, beforeExprIZ, 1);
                break;
            }
            case 3: 
            case 14: 
            case 19: 
            case 27: 
            case 29: 
            case 39: 
            case 83: 
            case 92: 
            case 101: 
            case 109: 
            case 116: 
            case 136: 
            case 138: 
            case 155: 
            case 172: 
            case 174: 
            case 175: 
            case 176: {
                break;
            }
            case 4: {
                TapList annot = (TapList)expression.getAnnotation("allocatedZones");
                beforeExprIZ.setDeclared(ZoneInfo.listAllZones(annot, true), this.vectorMap, false);
                this.initializeArrayPointers(annot, beforeExprIZ);
                break;
            }
            case 51: {
                this.usedUndefThroughExpression(expression.down(1), beforeExprIZ, 1);
                break;
            }
            case 171: {
                this.usedUndefThroughExpression(expression.down(1), beforeExprIZ, -1);
                break;
            }
            case 194: {
                Tree[] exprs = expression.down(3).children();
                for (int i = exprs.length - 1; i >= 0; --i) {
                    Tree declarator = exprs[i];
                    if (declarator.opCode() == 13) {
                        ILUtils.turnAssignFromInitDecl(declarator);
                    }
                    this.usedUndefThroughExpression(declarator, beforeExprIZ, 0);
                    if (declarator.opCode() != 13) continue;
                    ILUtils.resetAssignFromInitDecl(declarator);
                }
                break;
            }
            case 35: 
            case 45: 
            case 55: 
            case 87: {
                break;
            }
            case 1: 
            case 12: 
            case 28: 
            case 34: 
            case 38: 
            case 40: 
            case 44: 
            case 48: 
            case 50: 
            case 66: 
            case 68: 
            case 72: 
            case 76: 
            case 89: 
            case 99: 
            case 102: 
            case 104: 
            case 106: 
            case 127: 
            case 133: 
            case 151: 
            case 156: 
            case 166: 
            case 187: 
            case 190: 
            case 192: 
            case 197: 
            case 199: {
                break;
            }
            default: {
                TapEnv.toolWarning(-1, "(Use-Def analysis) Unexpected operator: " + expression.opName());
            }
        }
    }

    private void initializeArrayPointers(TapList zones, BoolVector beforeExprIZ) {
        while (zones != null) {
            if (zones.head != null) {
                if (zones.head instanceof TapList) {
                    this.initializeArrayPointers((TapList)zones.head, beforeExprIZ);
                } else {
                    TapIntList intZones = (TapIntList)zones.head;
                    while (intZones != null) {
                        ZoneInfo zoneInfo = this.extendedDeclaredToZoneInfo(intZones.head);
                        if (zoneInfo.type != null && TypeSpec.isA(zoneInfo.type.wrappedType, 6) && ((PointerTypeSpec)zoneInfo.type.wrappedType).isInFactArray()) {
                            int index = this.zoneInfoToVectorIndex(zoneInfo, 3, 0, this.vectorMap);
                            beforeExprIZ.set(index, true);
                        }
                        intZones = intZones.tail;
                    }
                }
            }
            zones = zones.tail;
        }
    }

    private void usedUndefThroughArgZonesTree(TapList valueZones, TapList valueCR, TapList valuePW, BoolVector beforeExprIZ, Tree argTree) {
        while (valueZones != null) {
            boolean boolPW;
            boolean boolCR;
            TapIntList valueZonesList;
            if (valueCR != null && valueCR.head instanceof TapList) {
                if (valueZones.head instanceof TapList) {
                    this.usedUndefThroughArgZonesTree((TapList)valueZones.head, (TapList)valueCR.head, (TapList)valuePW.head, beforeExprIZ, argTree);
                } else {
                    valueZonesList = (TapIntList)valueZones.head;
                    boolCR = TapList.oneTrue((TapList)valueCR.head);
                    boolPW = TapList.oneTrue((TapList)valuePW.head);
                    if (boolCR && valueZonesList != null && !InOutAnalyzer.intersectsExtendedDeclared(beforeExprIZ, InOutAnalyzer.makeMap3(this.nSEZ, 0, this.nDZ), 0, valueZonesList, null, this.curSymbolTable, null)) {
                        TapEnv.fileWarning(15, argTree, "(DF03) variable " + ILUtils.toString(argTree) + " is used before initialized");
                    }
                    if (boolPW) {
                        this.setExtendedDeclared(beforeExprIZ, InOutAnalyzer.makeMap3(this.nSEZ, 0, this.nDZ), 0, valueZonesList, true);
                    }
                }
            } else {
                valueZonesList = valueZones.head instanceof TapList ? ZoneInfo.listAllZones((TapList)valueZones.head, true) : (TapIntList)valueZones.head;
                boolCR = false;
                boolPW = false;
                if (valueCR != null && valueCR.head != null) {
                    boolCR = (Boolean)valueCR.head;
                }
                if (valuePW != null && valuePW.head != null) {
                    boolPW = (Boolean)valuePW.head;
                }
                if (boolCR && valueZonesList != null && !InOutAnalyzer.intersectsExtendedDeclared(beforeExprIZ, InOutAnalyzer.makeMap3(this.nSEZ, 0, this.nDZ), 0, valueZonesList, null, this.curSymbolTable, null)) {
                    TapEnv.fileWarning(15, argTree, "(DF03) variable " + ILUtils.toString(argTree) + " is used before initialized");
                }
                if (boolPW) {
                    this.setExtendedDeclared(beforeExprIZ, InOutAnalyzer.makeMap3(this.nSEZ, 0, this.nDZ), 0, valueZonesList, true);
                }
            }
            valueZones = valueZones.tail;
            if (valueCR != null) {
                valueCR = valueCR.tail;
            }
            if (valuePW == null) continue;
            valuePW = valuePW.tail;
        }
    }

    public TapPair<BoolVector, BoolVector> getInOutOfRegion(TapTriplet<TapList<FGArrow>, TapList<Block>, TapList<FGArrow>> frontier, Unit unit) {
        this.setCurUnitEtc(unit);
        this.fgPhase = 1;
        this.analyzeBackward((TapList)frontier.first, (TapList)frontier.second, (TapList)frontier.third);
        BoolVector readVars = this.getFrontierInZones((TapList)frontier.first);
        this.fgPhase = 0;
        this.fgSubPhase = 2;
        this.analyzeBackward((TapList)frontier.first, (TapList)frontier.second, (TapList)frontier.third);
        BoolVector modifiedVars = this.getFrontierModifiedZones((TapList)frontier.first);
        this.fgPhase = 1;
        this.analyzeBackward(null, null, null);
        this.fgPhase = 0;
        this.fgSubPhase = 2;
        this.analyzeBackward(null, null, null);
        this.setCurUnitEtc(null);
        return new TapPair<BoolVector, BoolVector>(readVars, modifiedVars);
    }

    public BoolVector getFrontierInZones(TapList<FGArrow> frontier) {
        int resNDZ = InOutAnalyzer.commonNDZofFrontierOrigins(frontier, 0);
        BoolVector result = new BoolVector(this.nSEZ + resNDZ);
        while (frontier != null) {
            FGArrow arrow = (FGArrow)frontier.head;
            int commonLength = this.nSEZ + arrow.commonSymbolTable().declaredZonesNb(0);
            result.cumulOr(this.beforeR.retrieve(arrow.destination), commonLength);
            result.cumulOr(this.beforeRW.retrieve(arrow.destination), commonLength);
            frontier = frontier.tail;
        }
        return result;
    }

    public BoolVector getFrontierModifiedZones(TapList<FGArrow> frontier) {
        int resNDZ = InOutAnalyzer.commonNDZofFrontierOrigins(frontier, 0);
        BoolVector result = new BoolVector(this.nSEZ + resNDZ);
        while (frontier != null) {
            FGArrow arrow = (FGArrow)frontier.head;
            int commonLength = this.nSEZ + arrow.commonSymbolTable().declaredZonesNb(0);
            result.cumulOr(arrow.destination.constantZones.not(), commonLength);
            frontier = frontier.tail;
        }
        return result;
    }

    public BoolVector getFrontierUnusedZones(TapList<FGArrow> frontier) {
        int resNDZ = InOutAnalyzer.commonNDZofFrontierOrigins(frontier, 0);
        BoolVector result = new BoolVector(this.nSEZ + resNDZ);
        result.setTrue();
        while (frontier != null) {
            FGArrow arrow = (FGArrow)frontier.head;
            int commonLength = this.nSEZ + arrow.commonSymbolTable().declaredZonesNb(0);
            result.cumulAnd(arrow.destination.unusedZones, commonLength);
            frontier = frontier.tail;
        }
        return result;
    }

    private void detectAliasing(CallArrow callArrow, Tree[] actualParams, Tree expression) {
        int nPubZones = callArrow.translator.length;
        BoolMatrix accessorPubZones = new BoolMatrix(this.nDZ, nPubZones);
        accessorPubZones.setExplicitZero();
        for (int i = 0; i < nPubZones; ++i) {
            PublicInfo rankInfo = callArrow.translator[i];
            if (rankInfo == null || rankInfo.kind() != 8) continue;
            TapIntList ldz = rankInfo.ranks(0);
            while (ldz != null) {
                accessorPubZones.set(ldz.head, i, true);
                ldz = ldz.tail;
            }
        }
        Unit calledUnit = callArrow.destination;
        for (int i = actualParams.length - 1; i >= 0; --i) {
            if (i + 1 >= calledUnit.argsPublicRankTrees.length) continue;
            TapList formalZones = calledUnit.argsPublicRankTrees[i + 1];
            TapList<?> actualZones = this.curSymbolTable.treeOfZonesOfValue(actualParams[i], null, this.curInstruction, null);
            this.setInfoBoolMatrixAtRowsColumns(accessorPubZones, actualZones, 0, formalZones, 0);
        }
        TapList<Object> toConflicts = new TapList<Object>(null, null);
        for (int i = 0; i < this.nDZ; ++i) {
            TapIntList aliasRanksUsed;
            BoolVector aliasRanks = accessorPubZones.getRow(i);
            if (!aliasRanks.intersects(calledUnit.unitInOutPossiblyW(), nPubZones) || TapIntList.length(aliasRanksUsed = aliasRanks.and(calledUnit.unitInOutPossiblyRorW()).trueIndexList(nPubZones)) < 2) continue;
            TapList<Object> inConflicts = toConflicts;
            while (inConflicts.tail != null && aliasRanksUsed != null) {
                if (TapIntList.contains((TapIntList)inConflicts.tail.head, aliasRanksUsed)) {
                    aliasRanksUsed = null;
                    continue;
                }
                if (TapIntList.contains(aliasRanksUsed, (TapIntList)inConflicts.tail.head)) {
                    inConflicts.tail = inConflicts.tail.tail;
                    continue;
                }
                inConflicts = inConflicts.tail;
            }
            if (inConflicts.tail != null || aliasRanksUsed == null) continue;
            inConflicts.tail = new TapList<TapIntList>(aliasRanksUsed, null);
        }
        toConflicts = toConflicts.tail;
        while (toConflicts != null) {
            TapIntList conflict = (TapIntList)toConflicts.head;
            TapIntList conflictParams = new TapIntList(-1, null);
            TapList<String> conflictGlobals = null;
            while (conflict != null) {
                ZoneInfo zoneInfo = calledUnit.paramElemZoneInfo(conflict.head);
                switch (zoneInfo.kind()) {
                    case 7: {
                        TapIntList.addIntoSorted(conflictParams, zoneInfo.index);
                        break;
                    }
                    case 11: {
                        conflictGlobals = new TapList<String>("common" + zoneInfo.commonName + ILUtils.toString(zoneInfo.accessTree), conflictGlobals);
                        break;
                    }
                    case 12: 
                    case 13: {
                        conflictGlobals = new TapList<String>(zoneInfo.publicName(), conflictGlobals);
                        break;
                    }
                }
                conflict = conflict.tail;
            }
            conflictParams = conflictParams.tail;
            int firstParam = conflictParams == null ? actualParams.length : conflictParams.head;
            String conflictArgsString = "";
            while (conflictParams != null) {
                conflictArgsString = conflictArgsString + ' ' + conflictParams.head;
                conflictParams = conflictParams.tail;
            }
            if (conflictGlobals != null) {
                conflictArgsString = conflictArgsString + " and";
            }
            while (conflictGlobals != null) {
                conflictArgsString = conflictArgsString + ' ' + (String)conflictGlobals.head;
                conflictGlobals = conflictGlobals.tail;
            }
            TapEnv.fileWarning(15, firstParam < actualParams.length ? actualParams[firstParam] : expression, "(DF02) Potential aliasing in calling function " + calledUnit.name + ", between arguments" + conflictArgsString);
            toConflicts = toConflicts.tail;
        }
    }

    private void detectSegmentationFaults(CallArrow callArrow, Tree[] actualParams) {
        Unit calledUnit = callArrow.destination;
        BoolVector certainlyWrittenZones = calledUnit.unitInOutCertainlyW();
        boolean[] certainlyWrittenParams = new boolean[actualParams.length + 1];
        for (int i = calledUnit.paramElemsNb() - 1; i >= 0; --i) {
            ZoneInfo zoneInfo = calledUnit.paramElemZoneInfo(i);
            if (zoneInfo == null || zoneInfo.kind() != 7 || zoneInfo.index > actualParams.length || !certainlyWrittenZones.get(i)) continue;
            certainlyWrittenParams[zoneInfo.index] = true;
        }
        for (int i = 0; i < actualParams.length; ++i) {
            TapIntList argZones;
            if (ILUtils.isNullOrNone(actualParams[i]) || actualParams[i].opCode() == 132 || (argZones = this.curSymbolTable.listOfZonesOfValue(actualParams[i], null, this.curInstruction)) != null || !certainlyWrittenParams[i + 1] || calledUnit.passesByValue(i + 1, callArrow.origin.language())) continue;
            TapEnv.fileWarning(15, actualParams[i], "(DF01) Illegal non-reference value for output argument " + (i + 1) + " of procedure " + calledUnit.name);
        }
    }

    private void checkOverwrittenLoopIndices(Block block, BoolVector writtenZones, int[] vectorMap) {
        if (writtenZones != null) {
            for (LoopBlock enclosingLoopBlock = block.enclosingLoop(); enclosingLoopBlock != null; enclosingLoopBlock = enclosingLoopBlock.enclosingLoop()) {
                HeaderBlock enclosingLoopHeader = enclosingLoopBlock.header();
                if (enclosingLoopHeader == block || !enclosingLoopHeader.isADoLoop()) continue;
                Instruction doInstruction = (Instruction)enclosingLoopHeader.instructions.head;
                Tree indexTree = doInstruction.tree.down(3).down(1);
                TapIntList indexZonesList = ZoneInfo.listAllZones(this.curSymbolTable.treeOfZonesOfValue(indexTree, null, doInstruction, null), true);
                if (!InOutAnalyzer.intersectsExtendedDeclared(writtenZones, vectorMap, 0, indexZonesList, null, this.curSymbolTable, null)) continue;
                enclosingLoopHeader.dirtyOverwrittenIndex = true;
            }
        }
    }
}

