/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.analysis;

import fr.inria.tapenade.analysis.DataFlowAnalyzer;
import fr.inria.tapenade.analysis.InOutAnalyzer;
import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.ArrayTypeSpec;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.BlockStorage;
import fr.inria.tapenade.representation.CallArrow;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.CompositeTypeSpec;
import fr.inria.tapenade.representation.HeaderBlock;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.LoopBlock;
import fr.inria.tapenade.representation.PublicInfo;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.Tree;

public final class LoopArrayAccessAnalyzer
extends DataFlowAnalyzer {
    public static final int NOACT = 0;
    public static final int WRITE = 1;
    public static final int READ = -1;
    private BlockStorage<TapList<TapTriplet<Tree, Instruction, TapList<LoopBlock>>>[]> accesses;
    private BlockStorage<BoolVector> writtenZones;

    public LoopArrayAccessAnalyzer(CallGraph cg) {
        super(cg, "Analysis of array accesses in loops", null);
    }

    public static void runAnalysis(CallGraph callGraph, TapList<Unit> rootUnits) {
        new LoopArrayAccessAnalyzer(callGraph).run(rootUnits);
    }

    @Override
    public void run(TapList<Unit> rootUnits) {
        this.runBottomUpAnalysis(rootUnits);
    }

    @Override
    protected Object initializeCGForUnit() {
        return null;
    }

    @Override
    public boolean analyze() {
        TapList<TapTriplet<Tree, Instruction, TapList<LoopBlock>>>[] thisLoopAccesses;
        TapIntList loopIndexZones;
        Tree loopIndex;
        TapList<Block> inAllBlocks = this.curUnit.allBlocks;
        this.accesses = new BlockStorage(this.curUnit);
        this.writtenZones = new BlockStorage(this.curUnit);
        while (inAllBlocks != null) {
            this.curBlock = (Block)inAllBlocks.head;
            if (this.curBlock instanceof HeaderBlock && this.curBlock.isACleanDoLoop()) {
                this.nDZ = this.curBlock.symbolTable.declaredZonesNb(0);
                this.accesses.store(this.curBlock, new TapList[this.nDZ]);
                this.writtenZones.store(this.curBlock, new BoolVector(this.nSEZ + this.nDZ));
            }
            inAllBlocks = inAllBlocks.tail;
        }
        inAllBlocks = this.curUnit.allBlocks;
        while (inAllBlocks != null) {
            this.setCurBlockEtc((Block)inAllBlocks.head);
            this.collectAccesses();
            inAllBlocks = inAllBlocks.tail;
        }
        inAllBlocks = this.curUnit.allBlocks;
        while (inAllBlocks != null) {
            this.setCurBlockEtc((Block)inAllBlocks.head);
            if (this.curBlock instanceof HeaderBlock) {
                TapIntList localizedZones = null;
                if (this.curBlock.isACleanDoLoop()) {
                    int[] vectorMap = LoopArrayAccessAnalyzer.makeMap3(this.nSEZ, 0, this.nDZ);
                    loopIndex = this.curBlock.headInstr().tree.down(3).down(1);
                    loopIndexZones = this.curSymbolTable.listOfZonesOfValue(loopIndex, null, this.curBlock.headInstr());
                    BoolVector allWrittenZones = this.writtenZones.retrieve(this.curBlock);
                    boolean loopIndexIsDirty = LoopArrayAccessAnalyzer.intersectsExtendedDeclared(allWrittenZones, vectorMap, 0, loopIndexZones, null, this.curSymbolTable, null);
                    if (!loopIndexIsDirty) {
                        thisLoopAccesses = this.accesses.retrieve(this.curBlock);
                        for (int i = this.nDZ - 1; i >= 0; --i) {
                            if (!this.isLocalizedZone(loopIndex, thisLoopAccesses[i], allWrittenZones, this.curSymbolTable)) continue;
                            localizedZones = new TapIntList(i, localizedZones);
                        }
                    }
                }
                ((HeaderBlock)this.curBlock).localizedZones = localizedZones;
            }
            inAllBlocks = inAllBlocks.tail;
        }
        inAllBlocks = this.curUnit.allBlocks;
        while (inAllBlocks != null) {
            Block block = (Block)inAllBlocks.head;
            if (block instanceof HeaderBlock) {
                this.setCurBlockEtc(block);
                TapIntList uniqueAccessZones = null;
                TapList<Tree> uniqueAccessTrees = null;
                if (block.enclosingLoop().enclosingLoop() != null) {
                    uniqueAccessZones = block.enclosingLoop().enclosingLoop().header().uniqueAccessZones;
                    uniqueAccessTrees = block.enclosingLoop().enclosingLoop().header().uniqueAccessTrees;
                }
                TapIntList topUniqueAccessZones = null;
                TapIntList loopCompleteZones = null;
                if (block.isACleanDoLoop()) {
                    thisLoopAccesses = this.accesses.retrieve(block);
                    BoolVector thisLoopWrittenZones = this.writtenZones.retrieve(block);
                    int[] vectorMap = LoopArrayAccessAnalyzer.makeMap3(this.nSEZ, 0, this.nDZ);
                    for (int i = this.nDZ - 1; i >= 0; --i) {
                        if (TapIntList.contains(uniqueAccessZones, i)) continue;
                        TapList<HeaderBlock> commonLocalized = this.getCommonCleanLocalizedHeaders(thisLoopAccesses[i], (HeaderBlock)block, i);
                        BoolVector loopConstantZones = thisLoopWrittenZones.not();
                        boolean accumulateInside = true;
                        TapList<HeaderBlock> headersInside = null;
                        while (commonLocalized != null) {
                            HeaderBlock headerBlockAround = (HeaderBlock)commonLocalized.head;
                            if (accumulateInside) {
                                headersInside = new TapList<HeaderBlock>(headerBlockAround, headersInside);
                            }
                            if (headerBlockAround == block) {
                                accumulateInside = false;
                            }
                            if ((loopIndexZones = headerBlockAround.symbolTable.listOfZonesOfValue(loopIndex = headerBlockAround.headInstr().tree.down(3).down(1), null, headerBlockAround.headInstr())) != null && loopIndexZones.tail == null) {
                                this.setExtendedDeclared(loopConstantZones, vectorMap, 0, loopIndexZones.head, true);
                            }
                            commonLocalized = commonLocalized.tail;
                        }
                        Tree uniqueAccess = null;
                        boolean isUniqueAccess = true;
                        TapList<TapTriplet<Tree, Instruction, TapList<LoopBlock>>> zoneAccesses = thisLoopAccesses[i];
                        while (isUniqueAccess && zoneAccesses != null) {
                            Tree oneAccess = (Tree)((TapTriplet)zoneAccesses.head).first;
                            if (uniqueAccess == null) {
                                uniqueAccess = oneAccess;
                            } else {
                                isUniqueAccess = this.sameAccessTree(oneAccess, uniqueAccess);
                            }
                            zoneAccesses = zoneAccesses.tail;
                        }
                        if (!isUniqueAccess || uniqueAccess == null || !this.isIndexedAccess(uniqueAccess) || !this.allIndicesConstant(uniqueAccess, loopConstantZones, this.curSymbolTable, block.headInstr(), vectorMap)) continue;
                        uniqueAccessZones = new TapIntList(i, uniqueAccessZones);
                        uniqueAccessTrees = new TapList<Tree>(uniqueAccess, uniqueAccessTrees);
                        topUniqueAccessZones = new TapIntList(i, topUniqueAccessZones);
                        TapPair<Object, TapList<HeaderBlock>> context = new TapPair<Object, TapList<HeaderBlock>>(null, headersInside);
                        if (!this.isCompleteAccess(uniqueAccess, context, this.curSymbolTable) || context.first == null || ((WrapperTypeSpec)context.first).getAllDimensions() != null) continue;
                        loopCompleteZones = new TapIntList(i, loopCompleteZones);
                    }
                }
                ((HeaderBlock)block).uniqueAccessZones = uniqueAccessZones;
                ((HeaderBlock)block).uniqueAccessTrees = uniqueAccessTrees;
                ((HeaderBlock)block).topUniqueAccessZones = topUniqueAccessZones;
                ((HeaderBlock)block).loopCompleteZones = loopCompleteZones;
            }
            inAllBlocks = inAllBlocks.tail;
        }
        this.setCurBlockEtc(null);
        return false;
    }

    private void collectAccesses() {
        TapList<LoopBlock> enclosingLoops = this.curBlock.enclosingLoops();
        if (enclosingLoops != null && ((LoopBlock)enclosingLoops.head).header() == this.curBlock && this.curBlock.isACleanDoLoop()) {
            enclosingLoops = enclosingLoops.tail;
        }
        if (enclosingLoops != null) {
            TapList<Instruction> instructions = this.curBlock.instructions;
            while (instructions != null) {
                Instruction instruction = (Instruction)instructions.head;
                this.collectAccessesInTree(instruction.tree, 0, instruction, enclosingLoops, this.curSymbolTable);
                instructions = instructions.tail;
            }
        }
    }

    private void collectAccessesInTree(Tree expr, int act, Instruction instruction, TapList<LoopBlock> enclosingLoops, SymbolTable symbolTable) {
        switch (expr.opCode()) {
            case 13: {
                this.collectAccessesInTree(expr.down(2), -1, instruction, enclosingLoops, symbolTable);
                this.collectAccessesInTree(expr.down(1), 1, instruction, enclosingLoops, symbolTable);
                break;
            }
            case 62: 
            case 123: 
            case 147: 
            case 185: {
                this.collectAccessesInTree(expr.down(2), -1, instruction, enclosingLoops, symbolTable);
                this.collectAccessesInTree(expr.down(1), 1, instruction, enclosingLoops, symbolTable);
                break;
            }
            case 30: {
                CallArrow callArrow;
                Unit calledUnit = LoopArrayAccessAnalyzer.getCalledUnit(expr, symbolTable);
                Tree[] args = ILUtils.getArguments(expr).children();
                for (int i = args.length - 1; i >= 0; --i) {
                    this.collectAccessesInTree(args[i], 1, instruction, enclosingLoops, symbolTable);
                }
                if (calledUnit == null || (callArrow = CallGraph.getCallArrow(this.curUnit, calledUnit)) == null || callArrow.translator() == null) break;
                PublicInfo[] translator = callArrow.translator();
                for (int i = translator.length - 1; i >= 0; --i) {
                    PublicInfo rankInfo = translator[i];
                    if (rankInfo == null || rankInfo.kind() != 8) continue;
                    this.collectOneAccessForZones(expr, rankInfo.ranks(0), 1, enclosingLoops, instruction);
                }
                break;
            }
            case 46: {
                Tree[] args = expr.down(3).children();
                for (int i = args.length - 1; i >= 0; --i) {
                    this.collectAccessesInTree(args[i], -1, instruction, enclosingLoops, symbolTable);
                }
                break;
            }
            case 189: {
                this.collectAccessesInTree(expr.down(2), -1, instruction, enclosingLoops, symbolTable);
                break;
            }
            case 8: 
            case 10: {
                Tree[] indexes = expr.down(2).children();
                for (int i = indexes.length - 1; i >= 0; --i) {
                    this.collectAccessesInTree(indexes[i], -1, instruction, enclosingLoops, symbolTable);
                }
            }
            case 73: {
                this.collectAccessesInTree(expr.down(1), 0, instruction, enclosingLoops, symbolTable);
            }
            case 94: {
                if (act == 0) break;
                this.collectOneAccess(expr, act, instruction, enclosingLoops, symbolTable);
                break;
            }
            case 148: {
                this.collectAccessesInTree(expr.down(2), -1, instruction, enclosingLoops, symbolTable);
                this.collectAccessesInTree(expr.down(1), -1, instruction, enclosingLoops, symbolTable);
                if (act == 0) break;
                this.collectOneAccess(expr, act, instruction, enclosingLoops, symbolTable);
                break;
            }
            case 2: 
            case 5: 
            case 17: 
            case 21: 
            case 23: 
            case 41: 
            case 42: 
            case 58: 
            case 61: 
            case 67: 
            case 90: 
            case 93: 
            case 113: 
            case 114: 
            case 120: 
            case 124: 
            case 131: 
            case 135: 
            case 141: 
            case 152: 
            case 163: 
            case 164: 
            case 177: 
            case 202: {
                this.collectAccessesInTree(expr.down(1), -1, instruction, enclosingLoops, symbolTable);
                this.collectAccessesInTree(expr.down(2), -1, instruction, enclosingLoops, symbolTable);
                break;
            }
            case 11: 
            case 97: {
                this.collectAccessesInTree(expr.down(1), -1, instruction, enclosingLoops, symbolTable);
                this.collectAccessesInTree(expr.down(2), -1, instruction, enclosingLoops, symbolTable);
                this.collectAccessesInTree(expr.down(3), -1, instruction, enclosingLoops, symbolTable);
                break;
            }
            case 96: 
            case 122: 
            case 137: 
            case 179: 
            case 184: 
            case 191: 
            case 200: 
            case 201: {
                this.collectAccessesInTree(expr.down(1), -1, instruction, enclosingLoops, symbolTable);
                break;
            }
            case 132: {
                this.collectAccessesInTree(expr.down(2), act, instruction, enclosingLoops, symbolTable);
                break;
            }
            case 31: {
                this.collectAccessesInTree(expr.down(2), -1, instruction, enclosingLoops, symbolTable);
                break;
            }
            case 51: 
            case 138: {
                this.collectAccessesInTree(expr.down(1), 1, instruction, enclosingLoops, symbolTable);
                break;
            }
            case 142: 
            case 143: {
                break;
            }
            case 119: {
                this.collectAccessesInTree(expr.down(3), -1, instruction, enclosingLoops, symbolTable);
                break;
            }
            case 107: {
                String ioOper = ILUtils.getIdentString(expr.down(1));
                Tree[] ioSpecs = expr.down(2).children();
                ToBool written = new ToBool(false);
                ToBool totally = new ToBool(false);
                for (int i = ioSpecs.length - 1; i >= 0; --i) {
                    Tree targets = InOutAnalyzer.getIOeffectOfIOspec(ioSpecs[i], i, ioOper, written, totally, symbolTable);
                    this.collectAccessesInTree(targets, written.get() ? 1 : -1, instruction, enclosingLoops, symbolTable);
                }
                this.collectAccessesInTree(expr.down(3), ILUtils.isIORead(expr) ? 1 : -1, instruction, enclosingLoops, symbolTable);
                break;
            }
            case 108: {
                this.collectAccessesInTree(expr.down(2), -1, instruction, enclosingLoops, symbolTable);
                this.collectAccessesInTree(expr.down(1), act, instruction, enclosingLoops, symbolTable);
                break;
            }
            case 70: 
            case 81: {
                Tree[] exprs = expr.children();
                for (int i = exprs.length - 1; i >= 0; --i) {
                    this.collectAccessesInTree(exprs[i], act, instruction, enclosingLoops, symbolTable);
                }
                break;
            }
            case 9: {
                Tree[] exprs = expr.children();
                for (int i = exprs.length - 1; i >= 0; --i) {
                    this.collectAccessesInTree(exprs[i], -1, instruction, enclosingLoops, symbolTable);
                }
                break;
            }
            case 78: {
                this.collectAccessesInTree(expr.down(1), -1, instruction, enclosingLoops, symbolTable);
                this.collectAccessesInTree(expr.down(2), -1, instruction, enclosingLoops, symbolTable);
                break;
            }
            case 63: 
            case 80: {
                this.collectAccessesInTree(expr.down(2), -1, instruction, enclosingLoops, symbolTable);
                this.collectAccessesInTree(expr.down(3), -1, instruction, enclosingLoops, symbolTable);
                this.collectAccessesInTree(expr.down(4), -1, instruction, enclosingLoops, symbolTable);
                this.collectAccessesInTree(expr.down(1), 1, instruction, enclosingLoops, symbolTable);
                break;
            }
            case 79: {
                this.collectAccessesInTree(expr.down(1), -1, instruction, enclosingLoops, symbolTable);
                this.collectAccessesInTree(expr.down(2), -1, instruction, enclosingLoops, symbolTable);
                break;
            }
            case 77: {
                this.collectAccessesInTree(expr.down(1), -1, instruction, enclosingLoops, symbolTable);
                this.collectAccessesInTree(expr.down(2), -1, instruction, enclosingLoops, symbolTable);
                this.collectAccessesInTree(expr.down(3), 1, instruction, enclosingLoops, symbolTable);
                break;
            }
            case 194: {
                for (int i = 1; i <= expr.down(3).length(); ++i) {
                    Tree decl = expr.down(3).down(i);
                    this.collectAccessesInTree(decl, -1, instruction, enclosingLoops, symbolTable);
                }
                break;
            }
            case 150: {
                this.collectAccessesInTree(expr.down(1), act, instruction, enclosingLoops, symbolTable);
                break;
            }
            case 3: 
            case 4: 
            case 14: 
            case 19: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 39: 
            case 40: 
            case 48: 
            case 76: 
            case 83: 
            case 92: 
            case 101: 
            case 102: 
            case 109: 
            case 116: 
            case 127: 
            case 136: 
            case 151: 
            case 155: 
            case 171: 
            case 172: 
            case 174: 
            case 175: 
            case 176: 
            case 199: {
                break;
            }
            default: {
                TapEnv.toolWarning(-1, "(Localized zones analysis) Unexpected operator: " + expr.opName());
            }
        }
    }

    private void collectOneAccess(Tree ref, int act, Instruction instruction, TapList<LoopBlock> enclosingLoops, SymbolTable symbolTable) {
        this.collectOneAccessForZones(ref, symbolTable.listOfZonesOfValue(ref, null, instruction), act, enclosingLoops, instruction);
    }

    private void collectOneAccessForZones(Tree ref, TapIntList zones, int act, TapList<LoopBlock> enclosingLoops, Instruction instruction) {
        TapTriplet<Tree, Instruction, TapList<LoopBlock>> refAndLoops = new TapTriplet<Tree, Instruction, TapList<LoopBlock>>(ref, instruction, enclosingLoops);
        int[] vectorMap = LoopArrayAccessAnalyzer.makeMap3(this.nSEZ, 0, this.nDZ);
        while (enclosingLoops != null) {
            HeaderBlock enclosingHeader = ((LoopBlock)enclosingLoops.head).header();
            if (enclosingHeader.isACleanDoLoop()) {
                BoolVector allWrittenZones;
                TapIntList inZones;
                TapList<TapTriplet<Tree, Instruction, TapList<LoopBlock>>>[] thisLoopAccesses = this.accesses.retrieve(enclosingHeader);
                if (thisLoopAccesses != null) {
                    inZones = zones;
                    while (inZones != null) {
                        if (inZones.head < enclosingHeader.symbolTable.declaredZonesNb(0)) {
                            thisLoopAccesses[inZones.head] = new TapList<TapTriplet<Tree, Instruction, TapList<LoopBlock>>>(refAndLoops, thisLoopAccesses[inZones.head]);
                        }
                        inZones = inZones.tail;
                    }
                }
                if (act == 1 && (allWrittenZones = this.writtenZones.retrieve(enclosingHeader)) != null) {
                    inZones = zones;
                    while (inZones != null) {
                        if (inZones.head < enclosingHeader.symbolTable.declaredZonesNb(0)) {
                            this.setExtendedDeclared(allWrittenZones, vectorMap, 0, inZones.head, true);
                        }
                        inZones = inZones.tail;
                    }
                }
            }
            enclosingLoops = enclosingLoops.tail;
        }
    }

    private boolean isLocalizedZone(Tree index, TapList<TapTriplet<Tree, Instruction, TapList<LoopBlock>>> accesses, BoolVector allWrittenZones, SymbolTable symbolTable) {
        TapPair<Object, Object> referencePair = new TapPair<Object, Object>(null, null);
        TapIntList referenceRk = new TapIntList(-1, null);
        TapPair<Object, Object> thisPair = new TapPair<Object, Object>(null, null);
        TapIntList thisRk = new TapIntList(-1, null);
        boolean cleanAccesses = true;
        while (cleanAccesses && accesses != null) {
            thisPair.first = null;
            thisPair.second = null;
            thisRk.head = -1;
            TapTriplet refAndLoops = (TapTriplet)accesses.head;
            cleanAccesses = this.canBeLocalizedAccess((Tree)refAndLoops.first, (Instruction)refAndLoops.second, index, thisPair, thisRk, 0, allWrittenZones, symbolTable);
            boolean bl = cleanAccesses = cleanAccesses && thisRk.head != -1;
            if (cleanAccesses) {
                if (referenceRk.head == -1) {
                    referenceRk.head = thisRk.head;
                    referencePair.first = thisPair.first;
                    referencePair.second = thisPair.second;
                } else {
                    cleanAccesses = referenceRk.head == thisRk.head && ((Tree)referencePair.first).equalsTree((Tree)thisPair.first) && this.isSameIndexExpr((Tree)referencePair.second, (Tree)thisPair.second);
                }
            }
            accesses = accesses.tail;
        }
        return cleanAccesses && referenceRk.head != -1;
    }

    private boolean canBeLocalizedAccess(Tree access, Instruction accessInstr, Tree index, TapPair<Tree, Tree> resultPair, TapIntList resultRk, int rk, BoolVector allWrittenZones, SymbolTable symbolTable) {
        switch (access.opCode()) {
            case 94: {
                resultPair.first = access;
                return true;
            }
            case 8: {
                Tree[] indexes = access.down(2).children();
                if (resultPair.second == null) {
                    for (int i = indexes.length - 1; i >= 0; --i) {
                        if (!this.isRegularIndexUse(indexes[i], accessInstr, index, allWrittenZones, symbolTable)) continue;
                        resultPair.second = indexes[i];
                        resultRk.head = rk + i;
                    }
                }
                return this.canBeLocalizedAccess(access.down(1), accessInstr, index, resultPair, resultRk, rk + indexes.length, allWrittenZones, symbolTable);
            }
            case 73: {
                return this.canBeLocalizedAccess(access.down(1), accessInstr, index, resultPair, resultRk, rk, allWrittenZones, symbolTable);
            }
        }
        return false;
    }

    private boolean isRegularIndexUse(Tree index, Instruction accessInstr, Tree loopIndex, BoolVector allWrittenZones, SymbolTable symbolTable) {
        TapPair<Object, Object> factorAndConstant = new TapPair<Object, Object>(null, null);
        this.matchLinearForm(index, loopIndex, factorAndConstant);
        Tree factor = (Tree)factorAndConstant.first;
        Tree constant = (Tree)factorAndConstant.second;
        boolean regular = false;
        if (!ILUtils.evalsToZero(factor)) {
            int[] vectorMap = LoopArrayAccessAnalyzer.makeMap3(this.nSEZ, 0, this.nDZ);
            TapIntList loopIndexZones = symbolTable.listOfZonesOfValue(loopIndex, null, null);
            BoolVector factorZones = symbolTable.zonesUsedByExp(factor, accessInstr);
            boolean bl = regular = !LoopArrayAccessAnalyzer.intersectsExtendedDeclared(factorZones, vectorMap, 0, loopIndexZones, null, symbolTable, null) && !factorZones.intersects(allWrittenZones, vectorMap[3]);
            if (regular && constant != null) {
                BoolVector constantZones = symbolTable.zonesUsedByExp(constant, accessInstr);
                regular = !LoopArrayAccessAnalyzer.intersectsExtendedDeclared(constantZones, vectorMap, 0, loopIndexZones, null, symbolTable, null) && !constantZones.intersects(allWrittenZones, vectorMap[3]);
            }
        }
        return regular;
    }

    private void matchLinearForm(Tree expr, Tree variable, TapPair<Tree, Tree> factorAndConstant) {
        switch (expr.opCode()) {
            case 131: {
                Tree tmpTree;
                TapPair<Object, Object> factorAndConstant1 = new TapPair<Object, Object>(null, null);
                this.matchLinearForm(expr.down(1), variable, factorAndConstant1);
                TapPair<Object, Object> factorAndConstant2 = new TapPair<Object, Object>(null, null);
                this.matchLinearForm(expr.down(2), variable, factorAndConstant2);
                if (factorAndConstant1.first != null) {
                    if (factorAndConstant2.first != null) {
                        tmpTree = ILUtils.buildSmartMulDiv((Tree)factorAndConstant1.first, 1, (Tree)factorAndConstant2.first);
                        tmpTree = ILUtils.build(131, ILUtils.copy(variable), tmpTree);
                        factorAndConstant.first = ILUtils.buildSmartAddSub((Tree)factorAndConstant.first, 1, tmpTree);
                    }
                    if (factorAndConstant2.second != null) {
                        tmpTree = ILUtils.buildSmartMulDiv((Tree)factorAndConstant1.first, 1, (Tree)factorAndConstant2.second);
                        factorAndConstant.first = ILUtils.buildSmartAddSub((Tree)factorAndConstant.first, 1, tmpTree);
                    }
                }
                if (factorAndConstant1.second == null) break;
                if (factorAndConstant2.first != null) {
                    tmpTree = ILUtils.buildSmartMulDiv((Tree)factorAndConstant1.second, 1, (Tree)factorAndConstant2.first);
                    factorAndConstant.first = ILUtils.buildSmartAddSub((Tree)factorAndConstant.first, 1, tmpTree);
                }
                if (factorAndConstant2.second == null) break;
                factorAndConstant.second = ILUtils.buildSmartMulDiv((Tree)factorAndConstant1.second, 1, (Tree)factorAndConstant2.second);
                break;
            }
            case 2: {
                this.matchLinearForm(expr.down(1), variable, factorAndConstant);
                TapPair<Object, Object> factorAndConstant2 = new TapPair<Object, Object>(null, null);
                this.matchLinearForm(expr.down(2), variable, factorAndConstant2);
                factorAndConstant.first = ILUtils.buildSmartAddSub((Tree)factorAndConstant.first, 1, (Tree)factorAndConstant2.first);
                factorAndConstant.second = ILUtils.buildSmartAddSub((Tree)factorAndConstant.second, 1, (Tree)factorAndConstant2.second);
                break;
            }
            case 177: {
                this.matchLinearForm(expr.down(1), variable, factorAndConstant);
                TapPair<Object, Object> factorAndConstant2 = new TapPair<Object, Object>(null, null);
                this.matchLinearForm(expr.down(2), variable, factorAndConstant2);
                factorAndConstant.first = ILUtils.buildSmartAddSub((Tree)factorAndConstant.first, -1, (Tree)factorAndConstant2.first);
                factorAndConstant.second = ILUtils.buildSmartAddSub((Tree)factorAndConstant.second, -1, (Tree)factorAndConstant2.second);
                break;
            }
            case 122: {
                this.matchLinearForm(expr.down(1), variable, factorAndConstant);
                if (factorAndConstant.first != null) {
                    factorAndConstant.first = ILUtils.minusTree((Tree)factorAndConstant.first);
                }
                if (factorAndConstant.second == null) break;
                factorAndConstant.second = ILUtils.minusTree((Tree)factorAndConstant.second);
                break;
            }
            default: {
                if (expr.equalsTree(variable)) {
                    factorAndConstant.first = ILUtils.build(101, 1);
                    break;
                }
                factorAndConstant.second = ILUtils.copy(expr);
            }
        }
    }

    private boolean isSameIndexExpr(Tree index1, Tree index2) {
        return ILUtils.evalsToZero(ILUtils.subTree(index1, index2));
    }

    private TapList<HeaderBlock> getCommonCleanLocalizedHeaders(TapList<TapTriplet<Tree, Instruction, TapList<LoopBlock>>> refs, HeaderBlock containerHeader, int arrayZone) {
        TapList<Object> hdResult;
        if (refs == null) {
            return null;
        }
        TapList commonLoops = (TapList)((TapTriplet)refs.head).third;
        refs = refs.tail;
        while (refs != null) {
            TapList newLoops = (TapList)((TapTriplet)refs.head).third;
            while (newLoops != null && !TapList.contains(commonLoops, newLoops.head)) {
                newLoops = newLoops.tail;
            }
            commonLoops = newLoops;
            refs = refs.tail;
        }
        TapList<Object> tlResult = hdResult = new TapList<Object>(null, null);
        boolean outsideContainer = false;
        while (commonLoops != null) {
            HeaderBlock commonHeader = ((LoopBlock)commonLoops.head).header();
            if (commonHeader.isACleanDoLoop() && (outsideContainer || TapIntList.contains(commonHeader.localizedZones, arrayZone))) {
                tlResult = tlResult.placdl(commonHeader);
            } else {
                hdResult = tlResult;
            }
            if (commonHeader == containerHeader) {
                outsideContainer = true;
            }
            commonLoops = commonLoops.tail;
        }
        return hdResult.tail;
    }

    private boolean sameAccessTree(Tree expr, Tree expr2) {
        switch (expr.opCode()) {
            case 94: {
                return expr.equalsTree(expr2);
            }
            case 8: {
                boolean same;
                boolean bl = same = expr2.opCode() == 8 && this.sameAccessTree(expr.down(1), expr2.down(1));
                if (same) {
                    int len;
                    Tree[] sons = expr.down(2).children();
                    Tree[] sons2 = expr2.down(2).children();
                    same = sons2.length == (len = sons.length);
                    if (same) {
                        for (int i = len - 1; same && i >= 0; --i) {
                            same = this.isSameIndexExpr(sons[i], sons2[i]);
                        }
                    }
                }
                return same;
            }
            case 73: {
                return expr2.opCode() == 73 && expr.down(2).equalsTree(expr2.down(2)) && this.sameAccessTree(expr.down(1), expr2.down(1));
            }
        }
        return false;
    }

    private boolean isIndexedAccess(Tree expr) {
        switch (expr.opCode()) {
            case 94: {
                return false;
            }
            case 8: {
                return true;
            }
            case 73: {
                return this.isIndexedAccess(expr.down(1));
            }
        }
        return false;
    }

    private boolean allIndicesConstant(Tree expr, BoolVector loopConstantZones, SymbolTable symbolTable, Instruction headerInstr, int[] vectorMap) {
        switch (expr.opCode()) {
            case 94: {
                return true;
            }
            case 8: {
                boolean allConstant = this.allIndicesConstant(expr.down(1), loopConstantZones, symbolTable, headerInstr, vectorMap);
                Tree[] indexes = expr.down(2).children();
                for (int i = indexes.length - 1; i >= 0; --i) {
                    allConstant = allConstant && this.indexIsConstant(indexes[i], loopConstantZones, symbolTable, headerInstr, vectorMap);
                }
                return allConstant;
            }
            case 73: {
                return this.allIndicesConstant(expr.down(1), loopConstantZones, symbolTable, headerInstr, vectorMap);
            }
        }
        return false;
    }

    private boolean indexIsConstant(Tree expr, BoolVector loopConstantZones, SymbolTable symbolTable, Instruction headerInstr, int[] vectorMap) {
        BoolVector exprZones = symbolTable.zonesUsedByExp(expr, headerInstr);
        return loopConstantZones.contains(exprZones, vectorMap[3]);
    }

    private boolean isCompleteAccess(Tree expr, TapPair<WrapperTypeSpec, TapList<HeaderBlock>> context, SymbolTable symbolTable) {
        switch (expr.opCode()) {
            case 94: {
                context.first = symbolTable.typeOf(expr);
                return true;
            }
            case 8: {
                boolean isComplete = this.isCompleteAccess(expr.down(1), context, symbolTable);
                WrapperTypeSpec type = (WrapperTypeSpec)context.first;
                Tree[] indexes = expr.down(2).children();
                if (isComplete && TypeSpec.isA(type, 2)) {
                    ArrayTypeSpec arrayType = (ArrayTypeSpec)type.wrappedType;
                    int len = arrayType.dimensions().length;
                    if (indexes.length == len) {
                        for (int i = len - 1; i >= 0; --i) {
                            isComplete = isComplete && this.indexIsComplete(indexes[i], arrayType.dimensions()[i], context);
                        }
                    }
                    context.first = arrayType.elementType();
                    return isComplete;
                }
                return false;
            }
            case 73: {
                boolean isComplete = this.isCompleteAccess(expr.down(1), context, symbolTable);
                WrapperTypeSpec type = (WrapperTypeSpec)context.first;
                if (isComplete && TypeSpec.isA(type, 21)) {
                    context.first = ((CompositeTypeSpec)type.wrappedType).getFieldType(expr.down(2));
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private boolean indexIsComplete(Tree expr, ArrayDim dimension, TapPair<WrapperTypeSpec, TapList<HeaderBlock>> context) {
        boolean foundLoop = false;
        boolean result = false;
        if (dimension.tree() == null || dimension.tree().opCode() != 58) {
            return false;
        }
        Tree dimFrom = ILUtils.copy(dimension.tree().down(1));
        Tree dimTo = ILUtils.copy(dimension.tree().down(2));
        if (ILUtils.isNullOrNone(dimFrom)) {
            dimFrom = ILUtils.build(101, 1);
        }
        if (ILUtils.isNullOrNone(dimTo) || dimTo.opCode() == 172) {
            return false;
        }
        while (!foundLoop && context.second != null) {
            HeaderBlock headerBlock = (HeaderBlock)((TapList)context.second).head;
            Tree loopIndex = headerBlock.headInstr().tree.down(3).down(1);
            Tree loopFrom = headerBlock.headInstr().tree.down(3).down(2);
            Tree loopTo = headerBlock.headInstr().tree.down(3).down(3);
            Tree loopStride = headerBlock.headInstr().tree.down(3).down(4);
            TapPair<Object, Object> factorAndConstant = new TapPair<Object, Object>(null, null);
            this.matchLinearForm(expr, loopIndex, factorAndConstant);
            if (factorAndConstant.first != null) {
                Tree db2;
                Tree db1;
                int istride;
                foundLoop = true;
                context.second = ((TapList)context.second).tail;
                Tree coeff = (Tree)factorAndConstant.first;
                int icoeff = ILUtils.evalsToOne(coeff) ? 1 : (ILUtils.evalsToMinusOne(coeff) ? -1 : 0);
                if (icoeff == 0 || (istride = ILUtils.isNullOrNone(loopStride) || ILUtils.evalsToOne(loopStride) ? 1 : (ILUtils.evalsToMinusOne(loopStride) ? -1 : 0)) == 0) continue;
                Tree offset = (Tree)factorAndConstant.second;
                dimFrom = ILUtils.subTree(dimFrom, ILUtils.copy(offset));
                dimTo = ILUtils.subTree(dimTo, ILUtils.copy(offset));
                if (icoeff == 1) {
                    if (istride == 1) {
                        db1 = ILUtils.subTree(ILUtils.copy(loopFrom), dimFrom);
                        db2 = ILUtils.subTree(ILUtils.copy(loopTo), dimTo);
                    } else {
                        db1 = ILUtils.subTree(ILUtils.copy(loopTo), dimFrom);
                        db2 = ILUtils.subTree(ILUtils.copy(loopFrom), dimTo);
                    }
                } else if (istride == 1) {
                    db1 = ILUtils.addTree(ILUtils.copy(loopTo), dimFrom);
                    db2 = ILUtils.addTree(ILUtils.copy(loopFrom), dimTo);
                } else {
                    db1 = ILUtils.addTree(ILUtils.copy(loopFrom), dimFrom);
                    db2 = ILUtils.addTree(ILUtils.copy(loopTo), dimTo);
                }
                result = ILUtils.evalsToZero(db1) && ILUtils.evalsToZero(db2);
                continue;
            }
            context.second = ((TapList)context.second).tail;
        }
        return result;
    }
}

