/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.analysis;

import fr.inria.tapenade.analysis.DataFlowAnalyzer;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.BlockStorage;
import fr.inria.tapenade.representation.CallArrow;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.UnitStorage;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.Tree;

public final class OmpClauseAnalyzer
extends DataFlowAnalyzer {
    private UnitStorage<BlockStorage<OmpInfoOfBlock>> computedOmpInfos = null;
    private OmpInfoOfBlock entryFrontierOMPInfo = null;
    private BlockStorage<OmpInfoOfBlock> unitBlocksOMPInfos;

    public OmpClauseAnalyzer(CallGraph cg) {
        super(cg, "Analysis of OpenMP clauses", null);
    }

    public static void runAnalysis(CallGraph callGraph) {
        OmpClauseAnalyzer analyzer = new OmpClauseAnalyzer(callGraph);
        TapEnv.setOmpClauseAnalyzer(analyzer);
        analyzer.run();
    }

    public void run() {
        this.computedOmpInfos = new UnitStorage(this.curCallGraph);
        this.runTopDownAnalysis(null);
    }

    public BoolVector getSharedZonesOfBlock(Block block) {
        Unit unit = block.unit();
        BlockStorage<OmpInfoOfBlock> unitResults = this.computedOmpInfos.retrieve(unit);
        assert (unitResults != null);
        OmpInfoOfBlock blockResults = unitResults.retrieve(block);
        return blockResults.sharedVariables;
    }

    @Override
    protected Object initializeCGForUnit() {
        this.computedOmpInfos.store(this.curUnit, new BlockStorage(this.curUnit));
        return new OmpInfoOfUnit(this.curUnit);
    }

    @Override
    protected void initializeCGForRootUnit() {
    }

    @Override
    protected boolean analyze() {
        return this.analyzeStructured(null, null);
    }

    @Override
    protected void concludeCGForUnit() {
    }

    private boolean analyzeStructured(TapList<FGArrow> entryArrows, TapList<FGArrow> exitArrows) {
        if (this.curUnit.hasSource()) {
            TapList<Block> insideBlocks;
            this.initializeUnit();
            this.setCurBlockEtc(this.curUnit.entryBlock());
            this.initializeInitBlock();
            TapList<Block> blockS = insideBlocks = this.curUnit.allBlocks;
            while (blockS != null) {
                this.setCurBlockEtc((Block)blockS.head);
                this.analyzeBlock();
                blockS = blockS.tail;
            }
            this.setCurBlockEtc(null);
        }
        return false;
    }

    @Override
    protected void initializeUnit() {
        this.unitBlocksOMPInfos = this.computedOmpInfos.retrieve(this.curUnit);
    }

    @Override
    protected void initializeInitBlock() {
        this.unitBlocksOMPInfos.store(this.curBlock, this.curBlock == this.curUnit.entryBlock() ? this.unitOmpInfoToEntryBlockInfo(this.curUnit) : this.entryFrontierOMPInfo);
    }

    private OmpInfoOfBlock unitOmpInfoToEntryBlockInfo(Unit unit) {
        OmpInfoOfUnit unitOmpInfo = (OmpInfoOfUnit)this.topDownContext(unit);
        int[] entryMap = OmpClauseAnalyzer.makeMap3(this.nSEZ, 0, this.curSymbolTable.declaredZonesNb(0));
        BoolVector entrySharedVariables = this.propagateUnitDataInside(unitOmpInfo.sharedVariables, 0, entryMap);
        return new OmpInfoOfBlock(unitOmpInfo.inParallelContext, entrySharedVariables);
    }

    private void analyzeBlock() {
        OmpInfoOfBlock controllerOmpInfo;
        Block parallelControllerBlock = this.curBlock.parallelControls == null ? null : ((Instruction)this.curBlock.parallelControls.head).block;
        SymbolTable controllerScope = this.curBlock.symbolTable;
        if (controllerScope.declarationsBlock == this.curBlock) {
            controllerScope = controllerScope.basisSymbolTable();
        }
        Block scopeControllerBlock = controllerScope == this.curUnit.publicSymbolTable() ? this.curUnit.entryBlock() : controllerScope.declarationsBlock;
        Block controllerBlock = parallelControllerBlock != null && parallelControllerBlock.symbolTable.nestedIn(controllerScope) ? parallelControllerBlock : scopeControllerBlock;
        OmpInfoOfBlock currentOmpInfo = controllerOmpInfo = this.unitBlocksOMPInfos.retrieve(controllerBlock);
        if (this.curBlock.isParallelController()) {
            currentOmpInfo = controllerOmpInfo.copy();
            currentOmpInfo.addClauses(this.curBlock.headInstr().tree);
        } else if (this.curBlock == this.curBlock.symbolTable.declarationsBlock) {
            currentOmpInfo = controllerOmpInfo.copy();
            currentOmpInfo.addScope(this.curBlock.symbolTable);
        }
        this.unitBlocksOMPInfos.store(this.curBlock, currentOmpInfo);
        TapList<Instruction> instrs = this.curBlock.instructions;
        while (instrs != null) {
            this.curInstruction = (Instruction)instrs.head;
            Tree instrTree = this.curInstruction.tree;
            int opCode = instrTree.opCode();
            if (opCode == 30) {
                this.addBlockOmpInfoIntoCalledUnitInfo(currentOmpInfo, instrTree);
            } else if (opCode == 13 && instrTree.down(2).opCode() == 30) {
                this.addBlockOmpInfoIntoCalledUnitInfo(currentOmpInfo, instrTree.down(2));
            }
            instrs = instrs.tail;
        }
    }

    private void addBlockOmpInfoIntoCalledUnitInfo(OmpInfoOfBlock blockOmpInfo, Tree callTree) {
        Unit calledUnit = OmpClauseAnalyzer.getCalledUnit(callTree, this.curSymbolTable);
        assert (calledUnit != null);
        if (!calledUnit.isIntrinsic()) {
            CallArrow callArrow = CallGraph.getCallArrow(this.curUnit, calledUnit);
            int[] callerMap = OmpClauseAnalyzer.makeMap3(this.nSEZ, 0, this.curSymbolTable.declaredZonesNb(0));
            Tree[] actualParams = ILUtils.getArguments(callTree).children();
            int nbArgs = actualParams.length;
            TapList[] argsZones = new TapList[nbArgs + 1];
            TapList[] argsOmpInfo = new TapList[nbArgs];
            for (int i = nbArgs - 1; i >= 0; --i) {
                Tree argTree = actualParams[i];
                argsZones[i] = this.curSymbolTable.treeOfZonesOfValue(argTree, null, this.curInstruction, null);
                argsZones[i] = TapList.copyTree(argsZones[i]);
                OmpClauseAnalyzer.includePointedElementsInTree(argsZones[i], null, null, true, this.curSymbolTable, this.curInstruction, calledUnit, true, true);
                argsOmpInfo[i] = OmpClauseAnalyzer.buildInfoBoolTreeOfDeclaredZones(argsZones[i], blockOmpInfo.sharedVariables, callerMap, null, 0, this.curSymbolTable);
            }
            BoolVector calleeNewSharedVariables = this.propagateEntryDataFwdToCallee(blockOmpInfo.sharedVariables, callerMap, argsOmpInfo, null, callArrow, null, 0, false);
            OmpInfoOfUnit calledUnitOmpInfo = (OmpInfoOfUnit)this.topDownContext(calledUnit);
            if (blockOmpInfo.inParallelContext && !calledUnitOmpInfo.inParallelContext) {
                calledUnitOmpInfo.inParallelContext = true;
                calledUnit.analysisIsOutOfDate = true;
            }
            if (calledUnitOmpInfo.sharedVariables.cumulOrGrows(calleeNewSharedVariables, calledUnit.paramElemsNb())) {
                calledUnit.analysisIsOutOfDate = true;
            }
        }
    }

    private class OmpInfoOfBlock {
        private boolean inParallelContext;
        private BoolVector sharedVariables;

        private OmpInfoOfBlock(boolean inParall, BoolVector sharedVars) {
            this.inParallelContext = inParall;
            this.sharedVariables = sharedVars;
        }

        private OmpInfoOfBlock copy() {
            return new OmpInfoOfBlock(this.inParallelContext, this.sharedVariables.copy());
        }

        private void addClauses(Tree ompPragma) {
            if (!this.inParallelContext) {
                this.inParallelContext = true;
                this.sharedVariables.setTrue();
            }
            Tree[] clauses = ompPragma.down(2).children();
            block3: for (int i = clauses.length - 1; i >= 0; --i) {
                Tree clause = clauses[i];
                switch (clause.opCode()) {
                    case 75: 
                    case 112: 
                    case 153: 
                    case 157: {
                        Tree[] privateIdents = clause.down(1).children();
                        if (privateIdents == null) continue block3;
                        for (int j = privateIdents.length - 1; j >= 0; --j) {
                            VariableDecl variableDecl = OmpClauseAnalyzer.this.curSymbolTable.getVariableDecl(ILUtils.getIdentString(privateIdents[j]));
                            TapIntList variableZones = ZoneInfo.listAllZones(variableDecl == null ? null : variableDecl.zones(), true);
                            this.sharedVariables.set(variableZones, false);
                        }
                        continue block3;
                    }
                }
            }
            TapList additionalPrivates = (TapList)ompPragma.getAnnotation("futurePrivatesFwd");
            while (additionalPrivates != null) {
                NewSymbolHolder nsh = (NewSymbolHolder)additionalPrivates.head;
                if (nsh.newSolvedVariableDecl != null) {
                    TapIntList variableZones = ZoneInfo.listAllZones(nsh.newSolvedVariableDecl.zones(), true);
                    this.sharedVariables.set(variableZones, false);
                }
                additionalPrivates = additionalPrivates.tail;
            }
        }

        private void addScope(SymbolTable symbolTable) {
            int[] scopeMap = DataFlowAnalyzer.makeMap3(OmpClauseAnalyzer.this.nSEZ, 0, symbolTable.declaredZonesNb(0));
            BoolVector newSharedVariables = new BoolVector(DataFlowAnalyzer.mapSize(scopeMap));
            newSharedVariables.setCopy(this.sharedVariables);
            this.sharedVariables = newSharedVariables;
        }
    }

    private static class OmpInfoOfUnit {
        private boolean inParallelContext = false;
        private BoolVector sharedVariables;

        private OmpInfoOfUnit(Unit unit) {
            int shapeLength = unit.paramElemsNb();
            this.sharedVariables = new BoolVector(shapeLength);
        }
    }
}

