/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.analysis;

import fr.inria.tapenade.analysis.DataFlowAnalyzer;
import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.ArrayTypeSpec;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.BlockStorage;
import fr.inria.tapenade.representation.CallArrow;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.HeaderBlock;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.PublicInfo;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.UnitStorage;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.BoolMatrix;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.Tree;

public final class PointerAnalyzer
extends DataFlowAnalyzer {
    public static final int N_NPZ = 2;
    private static final int UNDEFINED_PTR_DEST = -2;
    private BlockStorage<BoolMatrix> beforeDests;
    private BlockStorage<BoolMatrix> afterDests;
    private BlockStorage<BoolMatrix> throughDests;
    private BlockStorage<BoolMatrix> beforeDestsCycle;
    private BlockStorage<BoolMatrix> afterDestsCycle;
    private final UnitStorage publicReturnTrees;
    private TapList returnedZoneTree;
    private int nDPZ;
    private int nSEPZ;
    private final int[] curRowMap = PointerAnalyzer.makeMap3(-9, 0, 0);
    private final int[] curColMap = PointerAnalyzer.makeMap3(-9, 0, 0);
    private boolean terminatingUnit;
    private BoolMatrix tmpDests;
    private BoolMatrix tmpDestsCycle;
    private BoolMatrix additionalDests;

    private PointerAnalyzer(CallGraph callGraph) {
        super(callGraph, "Pointer Destinations analysis", TapEnv.tracePointer());
        this.publicReturnTrees = new UnitStorage(callGraph);
    }

    public static void runAnalysis(CallGraph callgraph, TapList<Unit> rootUnits) {
        TapEnv.setPointerAnalyzer(new PointerAnalyzer(callgraph));
        TapEnv.pointerAnalyzer().run(rootUnits);
    }

    public static BoolVector buildExplicitIdentityDestsRow(int rowIndex, SymbolTable symbolTable) {
        int nbSEPZ = symbolTable.unit.sideEffectZonesNb(3);
        ZoneInfo pZI = null;
        int[] varMap = PointerAnalyzer.makeMap3(symbolTable.unit.sideEffectZonesNb(0), 2, symbolTable.declaredZonesNb(0));
        BoolVector result = new BoolVector(symbolTable.unit.hasTooManyZones(), PointerAnalyzer.mapSize(varMap));
        if (rowIndex < nbSEPZ) {
            pZI = symbolTable.unit.sideEffectZoneInfo(rowIndex, 3);
        } else if (rowIndex < nbSEPZ + symbolTable.declaredZonesNb(3)) {
            pZI = symbolTable.declaredZoneInfo(rowIndex - nbSEPZ, 3);
        } else {
            TapEnv.toolWarning(-1, "Missing called unit at P4");
        }
        if (pZI != null) {
            TapIntList targets = ZoneInfo.listAllZones(pZI.targetZonesTree, true);
            while (targets != null) {
                int rank1;
                int rank = rank1 = PointerAnalyzer.extendedDeclaredToVectorIndex(targets.head, 0, varMap, symbolTable, null);
                result.set(rank, true);
                targets = targets.tail;
            }
        }
        return result;
    }

    @Override
    protected Object initializeCGForUnit() {
        if (this.curUnit.isExternal()) {
            int nbPubz = this.curUnit.paramElemsNb();
            this.curUnit.pointerEffect = new BoolMatrix(this.curUnit.hasTooManyZones(), nbPubz, nbPubz + 2);
            this.curUnit.pointerEffect.setIdentity();
        }
        return null;
    }

    @Override
    protected void concludeCGForUnit() {
        if (TapEnv.modeIsNoDiff() && !TapEnv.isDistribVersion() && this.curUnit.hasSource()) {
            this.placePointerDebugComments();
        }
        this.beforeDests = null;
        this.afterDests = null;
        this.beforeDestsCycle = null;
        this.afterDestsCycle = null;
        this.throughDests = null;
        this.tmpDests = null;
        this.tmpDestsCycle = null;
    }

    @Override
    public void setCurUnitEtc(Unit unit) {
        super.setCurUnitEtc(unit);
        this.nSEPZ = this.curUnit == null ? -9 : this.curUnit.sideEffectZonesNb(3);
        this.nDPZ = this.curSymbolTable == null ? -9 : this.curSymbolTable.declaredZonesNb(3);
        this.curRowMap[1] = this.nSEPZ;
        this.curRowMap[2] = this.nSEPZ;
        this.curRowMap[3] = this.nSEPZ + this.nDPZ;
        this.curColMap[1] = this.nSEZ;
        this.curColMap[2] = this.nSEZ + 2;
        this.curColMap[3] = this.nSEZ + 2 + this.nDZ;
    }

    @Override
    protected void initializeUnit() {
        this.nSEPZ = this.curUnit.sideEffectZonesNb(3);
        this.beforeDests = new BlockStorage(this.curUnit);
        this.afterDests = new BlockStorage(this.curUnit);
        this.beforeDestsCycle = new BlockStorage(this.curUnit);
        this.afterDestsCycle = new BlockStorage(this.curUnit);
        this.throughDests = new BlockStorage(this.curUnit);
        this.returnedZoneTree = null;
        if (this.traceCurAnalysis) {
            ZoneInfo zi;
            int i;
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace(" ============== POINTER ANALYSIS ON UNIT " + this.curUnit.name + " : ==============");
            this.curSymbolTable = this.curUnit.bodySymbolTable();
            if (this.curSymbolTable == null) {
                this.curSymbolTable = this.curUnit.publicSymbolTable();
            }
            this.nDZ = this.curSymbolTable.declaredZonesNb(0);
            if (this.nSEZ > 0) {
                TapEnv.printOnTrace(" SE:");
            }
            for (i = 0; i < this.nSEZ; ++i) {
                zi = this.zoneRkToZoneInfo(i, 1, 0);
                if (zi == null) continue;
                TapEnv.printOnTrace(" [" + i + (zi.ptrZoneNb != -1 ? Integer.valueOf(58 + zi.ptrZoneNb) : ": ") + ']' + zi.accessTreePrint(this.curUnit.language()));
            }
            if (this.nDZ > 0) {
                TapEnv.printOnTrace(" D:");
            }
            for (i = 0; i < this.nDZ; ++i) {
                zi = this.zoneRkToZoneInfo(i, 3, 0);
                if (zi == null) continue;
                TapEnv.printOnTrace(" [" + i + (zi.ptrZoneNb != -1 ? Integer.valueOf(58 + zi.ptrZoneNb) : ": ") + ']' + zi.accessTreePrint(this.curUnit.language()));
            }
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace();
        }
    }

    @Override
    protected void setCurBlockEtc(Block block) {
        super.setCurBlockEtc(block);
        this.nDPZ = this.curSymbolTable == null ? -9 : this.curSymbolTable.declaredZonesNb(3);
        this.curRowMap[3] = this.nSEPZ + this.nDPZ;
        this.curColMap[3] = this.nSEZ + 2 + this.nDZ;
    }

    @Override
    protected void initializeInitBlock() {
        this.afterDests.store(this.curBlock, this.identityPrivatePointerMatrix());
    }

    @Override
    protected void initializeFGForBlock() {
        this.tmpDests = this.identityPrivatePointerMatrix();
        this.tmpDestsCycle = null;
        boolean arrives = this.propagateDestsThroughBlock(this.curBlock, true, false);
        if (!arrives) {
            this.tmpDests = null;
        }
        this.throughDests.store(this.curBlock, this.tmpDests);
        if (this.traceCurAnalysis) {
            TapEnv.printlnOnTrace(" == Dests through " + this.curBlock + " is:");
            TapEnv.dumpBoolMatrixOnTrace(this.tmpDests, this.curRowMap, this.curColMap);
            TapEnv.printlnOnTrace();
        }
    }

    @Override
    protected boolean compareUpstreamValues() {
        return this.compareWithStorage(this.tmpDests, this.tmpDestsCycle, this.beforeDests, this.beforeDestsCycle);
    }

    @Override
    protected boolean compareDownstreamValues() {
        return this.compareWithStorage(this.tmpDests, this.tmpDestsCycle, this.afterDests, this.afterDestsCycle);
    }

    @Override
    protected boolean compareChannelZoneDataDownstream(int mpZone, Block refBlock) {
        return false;
    }

    @Override
    protected boolean propagateValuesForwardThroughBlock() {
        return this.propagateDestsThroughBlock(this.curBlock, false, false);
    }

    @Override
    protected void terminateFGForBlock() {
        this.terminatingUnit = true;
        this.accumulateValuesFromUpstream();
        this.tmpDests = this.beforeDests.retrieve(this.curBlock);
        this.tmpDestsCycle = this.beforeDestsCycle.retrieve(this.curBlock);
        this.propagateDestsThroughBlock(this.curBlock, false, true);
        this.terminatingUnit = false;
    }

    @Override
    protected boolean terminateUnit() {
        BoolMatrix unitPrivateDests;
        TapList<Tree> comments;
        this.terminatingUnit = true;
        this.setCurBlockEtc(this.curUnit.entryBlock);
        this.curBlock.pointerInfosIn = this.afterDests.retrieve(this.curBlock);
        this.setCurBlockEtc(this.curUnit.exitBlock);
        this.accumulateValuesFromUpstream();
        this.curUnit.exitBlock.pointerInfosIn = this.beforeDests.retrieve(this.curUnit.exitBlock);
        if (this.traceCurAnalysis) {
            TapEnv.printlnOnTrace(" == Dests entering exit Block :");
            TapEnv.dumpBoolMatrixOnTrace(this.curUnit.exitBlock.pointerInfosIn, this.curRowMap, this.curColMap);
            TapEnv.printlnOnTrace();
        }
        if (TapEnv.modeIsNoDiff() && !TapEnv.isDistribVersion() && (comments = this.buildCommentsForPointerDests(this.findDestsChangesAfterFlowMerge(this.curBlock))) != null) {
            this.curUnit.exitBlock.setPointerComments(comments);
        }
        if ((unitPrivateDests = this.beforeDests.retrieve(this.curUnit.exitBlock)) == null) {
            return false;
        }
        BoolMatrix transferPtr = this.curUnit.makeTransferMatrix(3, false);
        BoolVector notImplicitPublicRows = transferPtr.times(unitPrivateDests.notImplicitRows());
        BoolMatrix unitPublicDests = transferPtr.times(unitPrivateDests).timesTransposed(this.curUnit.makeTransferMatrix(0, true));
        for (int i = transferPtr.nRows - 1; i >= 0; --i) {
            if (notImplicitPublicRows.get(i)) continue;
            unitPublicDests.setIdentityRow(i);
        }
        this.replaceLeavesPrivateByPublicZones(this.returnedZoneTree, this.curUnit, null);
        this.publicReturnTrees.store(this.curUnit, this.returnedZoneTree);
        this.setCurBlockEtc(null);
        BoolMatrix oldUnitPublicDests = this.curUnit.pointerEffect;
        this.terminatingUnit = false;
        if (oldUnitPublicDests != null && unitPublicDests.equalsBoolMatrix(oldUnitPublicDests)) {
            return false;
        }
        this.curUnit.pointerEffect = unitPublicDests;
        if (this.traceCurAnalysis) {
            TapEnv.printlnOnTrace(" == Public dests effect stored for unit " + this.curUnit.name + " is:");
            TapEnv.dumpOnTrace(unitPublicDests);
            TapEnv.printlnOnTrace(" Result: " + this.returnedZoneTree);
            TapEnv.printlnOnTrace();
        }
        return true;
    }

    @Override
    protected void setEmptyCumulAndCycleValues() {
        this.tmpDests = null;
        this.tmpDestsCycle = null;
    }

    @Override
    protected boolean getValueFlowingThrough() {
        Block origin = this.curArrow.origin;
        this.additionalDests = PointerAnalyzer.runSpecialCycleAnalysis(origin) && this.curArrow.containsCase(1) ? this.afterDestsCycle.retrieve(origin) : this.afterDests.retrieve(origin);
        this.additionalDests = this.removeDanglingPointers(this.additionalDests, this.curArrow);
        return this.additionalDests != null;
    }

    @Override
    protected void initializeCumulValue() {
        this.tmpDests = this.zeroPrivatePointerMatrix();
    }

    @Override
    protected void cumulValueWithAdditional(SymbolTable commonSymbolTable) {
        if (this.tmpDests == null) {
            this.tmpDests = this.zeroPrivatePointerMatrix();
        }
        this.accumulateNewDestsInto(this.additionalDests, this.tmpDests, this.nSEPZ + commonSymbolTable.declaredZonesNb(3), this.nSEZ + 2 + commonSymbolTable.declaredZonesNb(0));
    }

    @Override
    protected void cumulCycleValueWithAdditional(SymbolTable commonSymbolTable) {
        if (this.tmpDestsCycle == null) {
            this.tmpDestsCycle = this.zeroPrivatePointerMatrix();
        }
        this.accumulateNewDestsInto(this.additionalDests, this.tmpDestsCycle, this.nSEPZ + commonSymbolTable.declaredZonesNb(3), this.nSEZ + 2 + commonSymbolTable.declaredZonesNb(0));
    }

    private boolean compareWithStorage(BoolMatrix newInfo, BoolMatrix newInfoCycle, BlockStorage<BoolMatrix> storedInfos, BlockStorage<BoolMatrix> storedInfosCycle) {
        boolean modified = false;
        BoolMatrix oldInfo = storedInfos.retrieve(this.curBlock);
        if (!(newInfo == null || oldInfo != null && newInfo.equalsBoolMatrix(oldInfo))) {
            modified = true;
            storedInfos.store(this.curBlock, newInfo.copy());
        }
        if (PointerAnalyzer.runSpecialCycleAnalysis(this.curBlock)) {
            oldInfo = storedInfosCycle.retrieve(this.curBlock);
            if (!(newInfoCycle == null || oldInfo != null && newInfoCycle.equalsBoolMatrix(oldInfo))) {
                modified = true;
                storedInfosCycle.store(this.curBlock, newInfoCycle.copy());
            }
        }
        return modified;
    }

    private void accumulateNewDestsInto(BoolMatrix newDests, BoolMatrix cumulDests, int commonRows, int commonCols) {
        int i;
        boolean firstAccumulation = false;
        int undefColumn = this.curColMap[2] - 1;
        int cumulLength = PointerAnalyzer.mapSize(this.curColMap);
        if (cumulDests.rows == null) {
            firstAccumulation = true;
            cumulDests.rows = new BoolVector[cumulDests.nRows];
        }
        for (i = 0; i < commonRows; ++i) {
            if (firstAccumulation) {
                if (newDests.rows[i] == null) {
                    cumulDests.rows[i] = null;
                    continue;
                }
                cumulDests.rows[i] = newDests.rows[i].copy(commonCols, cumulLength);
                continue;
            }
            if (cumulDests.rows[i] == null) {
                if (newDests.rows[i] == null) continue;
                cumulDests.rows[i] = newDests.rows[i].copy(commonCols, cumulLength);
                cumulDests.rows[i].set(this.identityColumnRanks(i, this.curRowMap, this.curColMap), true);
                continue;
            }
            if (newDests.rows[i] == null) {
                cumulDests.rows[i].set(this.identityColumnRanks(i, this.curRowMap, this.curColMap), true);
                continue;
            }
            cumulDests.rows[i].cumulOr(newDests.rows[i], commonCols);
        }
        for (i = cumulDests.nRows - 1; i >= commonRows; --i) {
            if (firstAccumulation) {
                cumulDests.rows[i] = new BoolVector(this.curUnit.hasTooManyZones(), cumulDests.nCols);
            } else if (cumulDests.rows[i] == null) {
                cumulDests.rows[i] = new BoolVector(this.curUnit.hasTooManyZones(), cumulDests.nCols);
                cumulDests.rows[i].set(this.identityColumnRanks(i, this.curRowMap, this.curColMap), true);
            }
            ZoneInfo pointerZoneInfo = this.vectorIndexToZoneInfo(i, 3, 3, this.curRowMap);
            if (pointerZoneInfo != null && ((PointerTypeSpec)pointerZoneInfo.type.wrappedType).offsetLength != null) {
                TapIntList colRks = this.mapZoneRkToVectorIndex(ZoneInfo.listAllZones(pointerZoneInfo.targetZonesTree, true), 3, 0, this.curColMap);
                cumulDests.rows[i].set(colRks, true);
                continue;
            }
            cumulDests.rows[i].set(undefColumn, true);
        }
    }

    private boolean propagateDestsThroughBlock(Block block, boolean init, boolean terminate) {
        TapList<Tree> comments;
        BoolMatrix currentDests;
        boolean specialCycle = PointerAnalyzer.runSpecialCycleAnalysis(block);
        if (this.nDPZ == 0 && this.nSEPZ == 0) {
            return true;
        }
        if (!(specialCycle || init || terminate)) {
            BoolMatrix blockPrivateEffect = this.throughDests.retrieve(block);
            if (blockPrivateEffect == null) {
                return false;
            }
            if (this.traceCurAnalysis) {
                TapEnv.printlnOnTrace(" == Dests entering " + block + " :");
                TapEnv.dumpBoolMatrixOnTrace(this.tmpDests, this.curRowMap, this.curColMap);
                TapEnv.printlnOnTrace();
                TapEnv.printlnOnTrace("   == Composed with :");
                TapEnv.dumpBoolMatrixOnTrace(blockPrivateEffect, this.curRowMap, this.curColMap);
                TapEnv.printlnOnTrace();
            }
            if (this.tmpDests != null) {
                this.tmpDests = this.composePointerDests(this.tmpDests, this.pointerDestsClosure(this.tmpDests), blockPrivateEffect, this.curRowMap, this.curColMap, null, null, null);
            }
            if (this.traceCurAnalysis) {
                TapEnv.printlnOnTrace(" == Dests exiting " + block + " :");
                TapEnv.dumpBoolMatrixOnTrace(this.tmpDests, this.curRowMap, this.curColMap);
                TapEnv.printlnOnTrace();
            }
            return true;
        }
        TapList<Instruction> instructions = block.instructions;
        this.setUniqueAccessZones(block);
        BoolMatrix previousDests = null;
        if (specialCycle) {
            this.curInstruction = (Instruction)instructions.head;
            Tree doTree = this.curInstruction.tree.down(3);
            if (this.tmpDests != null) {
                this.pointersThroughExpression(ILUtils.buildInitAssign(doTree), this.tmpDests, null, null);
            }
            if (this.tmpDestsCycle != null) {
                BoolMatrix tmpDestsCycleMemo = this.tmpDestsCycle.copy();
                TapIntList localizedZones = ((HeaderBlock)block).localizedZones;
                this.mapExplicitZeroDeclAllkZoneRk(this.tmpDestsCycle, localizedZones);
                if (this.tmpDests != null) {
                    this.explicitIdentitiesBeforeCumulOr(this.tmpDestsCycle, this.tmpDests, this.curRowMap, this.curColMap);
                    this.tmpDestsCycle.cumulOr(this.tmpDests, false, -1);
                    TapIntList entryToExitMask = this.declaredZonesNotFromEntryToExit((HeaderBlock)block, 0);
                    this.mapExplicitZeroDeclAllkZoneRk(this.tmpDests, entryToExitMask);
                    this.explicitIdentitiesBeforeCumulOr(tmpDestsCycleMemo, this.tmpDests, this.curRowMap, this.curColMap);
                    tmpDestsCycleMemo.cumulOr(this.tmpDests, false, -1);
                }
                this.tmpDests = tmpDestsCycleMemo;
            } else {
                this.tmpDestsCycle = this.tmpDests == null ? null : this.tmpDests.copy();
            }
        }
        ToBool arrives = new ToBool(true);
        ToBool arrivesC = new ToBool(true);
        if (terminate) {
            BoolMatrix boolMatrix = currentDests = this.tmpDests == null ? null : this.tmpDests.copy();
            if (this.tmpDestsCycle != null) {
                assert (currentDests != null);
                this.explicitIdentitiesBeforeCumulOr(currentDests, this.tmpDestsCycle, this.curRowMap, this.curColMap);
                assert (currentDests != null);
                currentDests.cumulOr(this.tmpDestsCycle, false, -1);
            }
            block.pointerInfosIn = currentDests;
            previousDests = currentDests;
            if (TapEnv.modeIsNoDiff() && !TapEnv.isDistribVersion() && (comments = this.buildCommentsForPointerDests(this.findDestsChangesAfterFlowMerge(block))) != null && block.instructions != null) {
                this.tempAttachPreComments(block.headInstr(), comments);
            }
        }
        while (instructions != null) {
            this.curInstruction = (Instruction)instructions.head;
            if (this.tmpDests != null) {
                this.pointersThroughExpression(this.curInstruction.tree, this.tmpDests, null, arrives);
            }
            if (this.tmpDestsCycle != null) {
                this.pointersThroughExpression(this.curInstruction.tree, this.tmpDestsCycle, null, arrivesC);
            }
            if (terminate) {
                BoolMatrix boolMatrix = currentDests = this.tmpDests == null ? null : this.tmpDests.copy();
                if (this.tmpDestsCycle != null) {
                    assert (currentDests != null);
                    this.explicitIdentitiesBeforeCumulOr(currentDests, this.tmpDestsCycle, this.curRowMap, this.curColMap);
                    assert (currentDests != null);
                    currentDests.cumulOr(this.tmpDestsCycle, false, -1);
                }
                this.curInstruction.pointerDestsChanges = this.findDestsChangesAfterInstruction(previousDests, currentDests);
                previousDests = currentDests;
                if (TapEnv.modeIsNoDiff() && !TapEnv.isDistribVersion() && (comments = this.buildCommentsForPointerDests(this.curInstruction.pointerDestsChanges)) != null) {
                    this.tempAttachPostComments(this.curInstruction, comments);
                }
            }
            instructions = instructions.tail;
        }
        this.uniqueAccessZones = null;
        this.curInstruction = null;
        return arrives.get() && arrivesC.get();
    }

    private TapList pointersThroughExpression(Tree expression, BoolMatrix dests, ToBool total, ToBool arrives) {
        switch (expression.opCode()) {
            case 13: {
                boolean totalAccess;
                Integer rhsIntVal;
                ToBool lhsTotal = new ToBool(false);
                TapList<Object> rhsZones = this.pointersThroughExpression(expression.down(2), dests, null, arrives);
                if (rhsZones != null && rhsZones.tail != null && rhsZones.tail.head instanceof TapIntList && ((TapIntList)rhsZones.tail.head).head == -2) {
                    rhsZones = null;
                }
                if (rhsZones != null) {
                    rhsZones = TapList.copyTree(rhsZones);
                    this.includePointedElementsInTree(rhsZones, null, dests, false, true, true);
                }
                TapList lhsZones = this.pointersThroughExpression(expression.down(1), dests, lhsTotal, arrives);
                boolean isPointerAssign = TypeSpec.isA(this.curSymbolTable.typeOf(expression.down(1)), 6);
                if (!isPointerAssign && expression.down(2).opCode() == 4) {
                    TapEnv.fileWarning(15, expression, "(DF10) No allocation allowed for " + ILUtils.toString(expression.down(1)));
                    return null;
                }
                if (isPointerAssign && rhsZones == null && this.curUnit.isC() && (rhsIntVal = this.curSymbolTable.computeIntConstant(expression.down(2))) != null && rhsIntVal == 0) {
                    rhsZones = new TapList<TapIntList>(null, new TapList<TapIntList>(new TapIntList(-3, null), null));
                }
                if (this.inADeclaration && rhsZones == null) {
                    TapIntList lhsZonesList = ZoneInfo.listAllZones(lhsZones, false);
                    while (lhsZonesList != null) {
                        ZoneInfo pointerZone = this.extendedDeclaredToZoneInfo(lhsZonesList.head);
                        if (pointerZone != null && pointerZone.ptrZoneNb != -1) {
                            rhsZones = TapList.cumulWithOper(rhsZones, pointerZone.targetZonesTree, 91);
                        }
                        lhsZonesList = lhsZonesList.tail;
                    }
                    if (rhsZones != null) {
                        rhsZones = new TapList<Object>(null, rhsZones);
                    }
                }
                boolean bl = totalAccess = this.referenceIsTotal(lhsTotal.get(), lhsZones) && (!this.inADeclaration || !this.curUnit.isFortran());
                if (this.traceCurAnalysis) {
                    TapEnv.printlnOnTrace(" ASSIGNMENT " + expression + " : " + lhsZones + " RECEIVES (total:" + totalAccess + ") " + rhsZones);
                }
                if (expression.down(1).opCode() == 94 && (ILUtils.getIdentString(expression.down(1)).equals(this.curUnit.name) || this.curUnit.otherReturnVar() != null && ILUtils.getIdentString(expression.down(1)).equals(this.curUnit.otherReturnVar().symbol))) {
                    this.returnedZoneTree = TapList.cumulWithOper(this.returnedZoneTree, rhsZones, 91);
                }
                return this.pointerAssignmentRec(dests, lhsZones, rhsZones, totalAccess, null);
            }
            case 30: {
                int nbFormalElemArgsP;
                int nbFormalElemArgs;
                Unit calledUnit = PointerAnalyzer.getCalledUnit(expression, this.curSymbolTable);
                if (calledUnit == null) {
                    TapEnv.toolError("Could not find called Unit for Pointer analysis on " + expression);
                    return null;
                }
                BoolMatrix calleePublicEffect = calledUnit.pointerEffect;
                if (calleePublicEffect == null) {
                    if (arrives != null && calledUnit.rank() >= 0) {
                        arrives.set(false);
                    }
                    if (calledUnit.isFortran() && calledUnit.name.equals("null")) {
                        return new TapList<TapIntList>(null, new TapList<TapIntList>(new TapIntList(-3, null), null));
                    }
                    return null;
                }
                CallArrow arrow = CallGraph.getCallArrow(this.curUnit, calledUnit);
                if (arrow == null || arrow.translator == null) {
                    TapEnv.toolError("Could not find CallArrow from " + this.curUnit + " to " + calledUnit + " on " + expression);
                    return null;
                }
                Tree[] actualParams = ILUtils.getArguments(expression).children();
                ToBool paramTotal = new ToBool(false);
                boolean[] paramTotals = new boolean[actualParams.length];
                TapList[] paramZones = new TapList[actualParams.length];
                for (int i = actualParams.length - 1; i >= 0; --i) {
                    paramZones[i] = this.pointersThroughExpression(actualParams[i], dests, paramTotal, arrives);
                    paramTotals[i] = paramTotal.get();
                    if (paramZones[i] != null) {
                        paramZones[i] = TapList.copyTree(paramZones[i]);
                        this.includePointedElementsInTree(paramZones[i], null, dests, true, true, true);
                        continue;
                    }
                    paramZones[i] = new TapList<Object>(null, null);
                }
                this.curCalledUnit = calledUnit;
                if (this.curCalledUnit.isExternal()) {
                    nbFormalElemArgs = 0;
                    nbFormalElemArgsP = 0;
                    for (int i = this.curCalledUnit.paramElemsNb() - 1; i >= 0; --i) {
                        ZoneInfo shapeElem = this.curCalledUnit.paramElemZoneInfo(i);
                        if (!shapeElem.isParameter() && !shapeElem.isResult()) continue;
                        ++nbFormalElemArgs;
                        if (shapeElem.ptrZoneNb == -1) continue;
                        ++nbFormalElemArgsP;
                    }
                } else {
                    SymbolTable paramsST = this.curCalledUnit.publicSymbolTable();
                    nbFormalElemArgs = paramsST.freeDeclaredZone(0) - paramsST.firstDeclaredZone(0);
                    nbFormalElemArgsP = paramsST.freeDeclaredZone(3) - paramsST.firstDeclaredZone(3);
                }
                int[] resultRowMap = PointerAnalyzer.makeMap4(this.nSEPZ, 0, this.nDPZ, nbFormalElemArgsP);
                int[] resultColMap = PointerAnalyzer.makeMap4(this.nSEZ, 2, this.nDZ, nbFormalElemArgs);
                TapIntList[] elemParamFolders = new TapIntList[nbFormalElemArgs];
                TapIntList[] ptrElemParamFolders = new TapIntList[nbFormalElemArgsP];
                TapList<?> functionResultDestsTree = (TapList<?>)this.publicReturnTrees.retrieve(this.curCalledUnit);
                if (functionResultDestsTree != null) {
                    functionResultDestsTree = TapList.copyTree(functionResultDestsTree);
                }
                BoolMatrix callDests = this.makePrivatePlusParamsInCaller(calleePublicEffect, resultRowMap, resultColMap, arrow);
                BoolMatrix destsClosedPlusParams = this.completeWithParams(this.pointerDestsClosure(dests), paramZones, elemParamFolders, ptrElemParamFolders, resultRowMap, resultColMap);
                this.privatizeTreeOfPublicZones(functionResultDestsTree, paramZones, arrow, null);
                if (this.traceCurAnalysis) {
                    int i;
                    TapEnv.printlnOnTrace();
                    TapEnv.printlnOnTrace(" -------------- Analysis of procedure call " + expression + " : --------------");
                    if (nbFormalElemArgs > 0) {
                        TapEnv.printOnTrace(" PARAMS:");
                    }
                    for (i = 0; i < nbFormalElemArgs; ++i) {
                        int firstFormalArgRk = this.curCalledUnit.publicSymbolTable() != null ? this.curCalledUnit.publicSymbolTable().firstDeclaredZone(0) : this.curCalledUnit.externalSymbolTable().freeDeclaredZone(0);
                        ZoneInfo zi = this.zoneRkToZoneInfo(i + firstFormalArgRk, 4, 0);
                        assert (zi != null);
                        TapEnv.printOnTrace(" [" + i + (zi.ptrZoneNb != -1 ? Integer.valueOf(58 + zi.ptrZoneNb) : ": ") + ']' + zi.accessTreePrint(this.curUnit.language()));
                    }
                    TapEnv.printlnOnTrace();
                    TapEnv.printlnOnTrace("    incoming closed and extended :");
                    TapEnv.dumpBoolMatrixOnTrace(destsClosedPlusParams, resultRowMap, resultColMap);
                    TapEnv.printlnOnTrace();
                    TapEnv.printlnOnTrace("    composed with privatized callee :");
                    TapEnv.dumpBoolMatrixOnTrace(callDests, resultRowMap, resultColMap);
                    TapEnv.printlnOnTrace();
                    for (i = 0; i < nbFormalElemArgs; ++i) {
                        TapEnv.printlnOnTrace("  elemParamFolders[" + i + "] =" + elemParamFolders[i]);
                    }
                    for (i = 0; i < nbFormalElemArgsP; ++i) {
                        TapEnv.printlnOnTrace("  ptrElemParamFolders[" + i + "] =" + ptrElemParamFolders[i]);
                    }
                }
                BoolMatrix destsAfterCall = this.composePointerDests(dests, destsClosedPlusParams, callDests, resultRowMap, resultColMap, ptrElemParamFolders, elemParamFolders, paramTotals);
                if (this.traceCurAnalysis) {
                    TapEnv.printlnOnTrace("    returns extended outgoing, folded :");
                    TapEnv.dumpBoolMatrixOnTrace(destsAfterCall, resultRowMap, resultColMap);
                    TapEnv.printlnOnTrace();
                }
                if (functionResultDestsTree != null) {
                    this.includePointedElementsInTree(functionResultDestsTree, null, destsAfterCall, true, true, false);
                }
                if (resultRowMap[3] >= 0) {
                    System.arraycopy(destsAfterCall.rows, 0, dests.rows, 0, resultRowMap[3]);
                }
                if (this.traceCurAnalysis) {
                    TapEnv.printlnOnTrace("    plus result : " + functionResultDestsTree);
                    TapEnv.printlnOnTrace(" --------------------------------------------------------------------------");
                    TapEnv.printlnOnTrace();
                }
                if (total != null) {
                    total.set(false);
                }
                this.curCalledUnit = null;
                return functionResultDestsTree;
            }
            case 73: {
                TapList zt = this.pointersThroughExpression(expression.down(1), dests, total, arrives);
                int fieldRank = ILUtils.getFieldRank(expression.down(2));
                if (fieldRank != -1 && TapList.nth(zt, fieldRank) instanceof TapList) {
                    return (TapList)TapList.nth(zt, fieldRank);
                }
                if (total != null) {
                    total.set(false);
                }
                return zt;
            }
            case 8: {
                TapList zt = this.pointersThroughExpression(expression.down(1), dests, total, arrives);
                WrapperTypeSpec typeSpec = this.curSymbolTable.typeOf(expression.down(1));
                ArrayDim[] dims = null;
                if (TypeSpec.isA(typeSpec, 2)) {
                    dims = ((ArrayTypeSpec)typeSpec.wrappedType).dimensions();
                }
                Tree[] indexes = expression.down(2).children();
                boolean tot = total != null && total.get() && dims != null && dims.length == indexes.length;
                for (int i = indexes.length - 1; i >= 0; --i) {
                    this.pointersThroughExpression(indexes[i], dests, null, arrives);
                    tot = tot && dims[i] != null && dims[i].fullArrayTriplet(indexes[i]);
                }
                if (total != null) {
                    total.set(tot);
                }
                return zt;
            }
            case 148: {
                TapList res = this.curSymbolTable.zonesOfDestination(this.pointersThroughExpression(expression.down(1), dests, total, arrives), this.curSymbolTable.typeOf(expression.down(1)), this.curInstruction, dests);
                if (total != null) {
                    total.set(false);
                }
                return res;
            }
            case 3: {
                return new TapList<Object>(null, this.pointersThroughExpression(expression.down(1), dests, total, arrives));
            }
            case 94: {
                VariableDecl variableDecl;
                if (total != null) {
                    total.set(true);
                }
                return (variableDecl = this.curSymbolTable.getVariableDecl(ILUtils.getIdentString(expression))) == null ? null : variableDecl.zones();
            }
            case 194: {
                Tree[] expressions = expression.down(3).children();
                this.inADeclaration = true;
                for (int i = expressions.length - 1; i >= 0; --i) {
                    if (expressions[i].opCode() != 13) continue;
                    ILUtils.turnAssignFromInitDecl(expressions[i]);
                    this.pointersThroughExpression(expressions[i], dests, null, arrives);
                    ILUtils.resetAssignFromInitDecl(expressions[i]);
                }
                this.inADeclaration = false;
                return null;
            }
            case 4: {
                TapList allocatedZones = (TapList)expression.getAnnotation("allocatedZones");
                TapIntList subPointerRows = this.mapZoneRkToVectorIndex(this.curSymbolTable.getDeclaredKindZones(ZoneInfo.listAllZones(allocatedZones, false), 3, true), 3, 3, this.curRowMap);
                while (subPointerRows != null) {
                    int subPtrRowIndex = subPointerRows.head;
                    BoolVector subPtrRow = dests.getRow(subPtrRowIndex);
                    if (subPtrRow == null) {
                        subPtrRow = new BoolVector(this.curUnit.hasTooManyZones(), dests.nCols);
                        subPtrRow.set(this.identityColumnRanks(subPtrRowIndex, this.curRowMap, this.curColMap), true);
                        dests.setRow(subPtrRowIndex, subPtrRow);
                    }
                    subPtrRow.set(this.curColMap[2] - 1, true);
                    subPointerRows = subPointerRows.tail;
                }
                return new TapList<Object>(null, allocatedZones);
            }
            case 51: {
                Tree variable = expression.down(1);
                WrapperTypeSpec variableType = this.curSymbolTable.typeOf(variable);
                if (!TypeSpec.isA(variableType, 6)) {
                    TapEnv.fileWarning(15, expression, "(DF10) No deallocation allowed for " + ILUtils.toString(variable));
                } else {
                    ToBool expTotal = new ToBool(false);
                    TapList<?> addressOfVariable = this.curSymbolTable.treeOfZonesOfValue(variable, expTotal, null, dests);
                    TapIntList deallocZones = ZoneInfo.listAllZones(addressOfVariable, false);
                    boolean totalDealloc = this.curInstruction.getWhereMask() == null && !this.oneZoneIsMultiple(deallocZones) && expTotal.get() && deallocZones != null && deallocZones.tail == null;
                    deallocZones = this.mapExtendedDeclaredToVectorIndex(deallocZones, 3, this.curRowMap);
                    while (deallocZones != null) {
                        int ptrRowIndex = deallocZones.head;
                        ZoneInfo ptrZ = this.vectorIndexToZoneInfo(ptrRowIndex, PointerAnalyzer.getMapClass(ptrRowIndex, this.curRowMap), 3, this.curRowMap);
                        BoolVector ptrRow = dests.getRow(ptrRowIndex);
                        if (!totalDealloc || ptrZ.multiple) {
                            if (ptrRow == null) {
                                ptrRow = new BoolVector(this.curUnit.hasTooManyZones(), dests.nCols);
                                ptrRow.set(this.identityColumnRanks(ptrRowIndex, this.curRowMap, this.curColMap), true);
                                dests.setRow(ptrRowIndex, ptrRow);
                            }
                        } else if (ptrRow == null) {
                            ptrRow = new BoolVector(this.curUnit.hasTooManyZones(), dests.nCols);
                            dests.setRow(ptrRowIndex, ptrRow);
                        } else {
                            ptrRow.setFalse();
                        }
                        ptrRow.set(this.curColMap[2] - 1, true);
                        deallocZones = deallocZones.tail;
                    }
                }
                return null;
            }
            case 138: {
                Tree[] expressions = expression.children();
                ToBool totalNullify = new ToBool(false);
                for (Tree tree : expressions) {
                    TapList expZones = this.pointersThroughExpression(tree, dests, totalNullify, arrives);
                    TapIntList expPZones = ZoneInfo.listAllZones(expZones, false);
                    TapIntList expPRanks = this.mapExtendedDeclaredToVectorIndex(expPZones, 3, this.curRowMap);
                    while (expPRanks != null) {
                        int ptrRowIndex = expPRanks.head;
                        ZoneInfo ptrZ = this.vectorIndexToZoneInfo(ptrRowIndex, PointerAnalyzer.getMapClass(ptrRowIndex, this.curRowMap), 3, this.curRowMap);
                        BoolVector ptrRow = dests.getRow(ptrRowIndex);
                        if (!totalNullify.get() || ptrZ.multiple) {
                            if (ptrRow == null) {
                                ptrRow = new BoolVector(this.curUnit.hasTooManyZones(), dests.nCols);
                                ptrRow.set(this.identityColumnRanks(ptrRowIndex, this.curRowMap, this.curColMap), true);
                                dests.setRow(ptrRowIndex, ptrRow);
                            }
                        } else if (ptrRow == null) {
                            ptrRow = new BoolVector(this.curUnit.hasTooManyZones(), dests.nCols);
                            dests.setRow(ptrRowIndex, ptrRow);
                        } else {
                            ptrRow.setFalse();
                        }
                        ptrRow.set(this.curColMap[2] - 2, true);
                        if (this.traceCurAnalysis) {
                            TapEnv.printlnOnTrace(" NULLIFY " + tree + " : " + expPZones + " TO " + ptrRow);
                        }
                        expPRanks = expPRanks.tail;
                    }
                }
                return null;
            }
            case 107: {
                return null;
            }
            case 96: 
            case 122: 
            case 137: 
            case 179: 
            case 184: 
            case 191: 
            case 200: 
            case 201: {
                this.pointersThroughExpression(expression.down(1), dests, null, arrives);
                return null;
            }
            case 5: 
            case 17: 
            case 21: 
            case 23: 
            case 41: 
            case 42: 
            case 61: 
            case 67: 
            case 78: 
            case 79: 
            case 90: 
            case 93: 
            case 108: 
            case 113: 
            case 114: 
            case 120: 
            case 124: 
            case 131: 
            case 135: 
            case 141: 
            case 152: 
            case 164: 
            case 202: {
                this.pointersThroughExpression(expression.down(1), dests, null, arrives);
                this.pointersThroughExpression(expression.down(2), dests, null, arrives);
                return null;
            }
            case 16: {
                this.pointersThroughExpression(expression.down(1), dests, null, arrives);
                this.pointersThroughExpression(expression.down(3), dests, null, arrives);
                return null;
            }
            case 2: 
            case 177: {
                TapList zt1 = this.pointersThroughExpression(expression.down(1), dests, null, arrives);
                TapList zt2 = this.pointersThroughExpression(expression.down(2), dests, null, arrives);
                if (total != null) {
                    total.set(false);
                }
                if (zt1 != null && zt1.head instanceof TapIntList && this.zoneIsPointer(((TapIntList)zt1.head).head)) {
                    return zt1;
                }
                if (zt2 != null && zt2.head instanceof TapIntList && this.zoneIsPointer(((TapIntList)zt2.head).head)) {
                    return zt2;
                }
                return null;
            }
            case 62: 
            case 123: 
            case 147: 
            case 185: {
                this.pointersThroughExpression(expression.down(2), dests, null, arrives);
                TapList zt = this.pointersThroughExpression(expression.down(1), dests, null, arrives);
                if (total != null) {
                    total.set(false);
                }
                return zt;
            }
            case 31: 
            case 126: 
            case 132: 
            case 189: {
                return this.pointersThroughExpression(expression.down(2), dests, total, arrives);
            }
            case 11: 
            case 77: {
                this.pointersThroughExpression(expression.down(1), dests, null, arrives);
                this.pointersThroughExpression(expression.down(2), dests, null, arrives);
                this.pointersThroughExpression(expression.down(3), dests, null, arrives);
                return null;
            }
            case 97: {
                this.pointersThroughExpression(expression.down(1), dests, null, arrives);
                TapList<?> zt = TapList.copyTree(this.pointersThroughExpression(expression.down(2), dests, null, arrives));
                zt = TapList.cumulWithOper(zt, this.pointersThroughExpression(expression.down(3), dests, null, arrives), 91);
                if (total != null) {
                    total.set(false);
                }
                return zt;
            }
            case 9: 
            case 81: {
                Tree[] expressions = expression.children();
                for (int i = expressions.length - 1; i >= 0; --i) {
                    this.pointersThroughExpression(expressions[i], dests, null, arrives);
                }
                return null;
            }
            case 46: {
                return this.pointersThroughExpression(expression.down(2), dests, null, arrives);
            }
            case 70: {
                Tree[] expressions = expression.children();
                TapList lastExprZones = null;
                for (Tree tree : expressions) {
                    lastExprZones = this.pointersThroughExpression(tree, dests, total, arrives);
                }
                return lastExprZones;
            }
            case 181: {
                this.pointersThroughExpression(expression.down(2), dests, null, arrives);
                return null;
            }
            case 1: 
            case 14: 
            case 19: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 48: 
            case 50: 
            case 68: 
            case 72: 
            case 76: 
            case 92: 
            case 99: 
            case 101: 
            case 102: 
            case 104: 
            case 106: 
            case 109: 
            case 116: 
            case 127: 
            case 133: 
            case 136: 
            case 142: 
            case 143: 
            case 151: 
            case 155: 
            case 166: 
            case 171: 
            case 172: 
            case 175: 
            case 176: 
            case 187: 
            case 192: 
            case 197: 
            case 199: {
                return null;
            }
            case 119: {
                this.pointersThroughExpression(expression.down(3), dests, null, arrives);
                return null;
            }
            case 63: 
            case 80: {
                this.pointersThroughExpression(expression.down(3), dests, null, arrives);
                this.pointersThroughExpression(expression.down(4), dests, null, arrives);
                return null;
            }
            case 174: {
                if (arrives != null) {
                    arrives.set(false);
                }
                return null;
            }
            case 163: {
                TapList result = null;
                if (!ILUtils.isNullOrNone(expression.down(1))) {
                    Tree assignTree = ILUtils.turnReturnIntoAssign(expression, this.curUnit.name);
                    result = this.pointersThroughExpression(assignTree, dests, null, arrives);
                    ILUtils.resetReturnFromAssign(expression, assignTree);
                }
                return result;
            }
            case 10: 
            case 88: 
            case 150: {
                return this.pointersThroughExpression(expression.down(1), dests, total, arrives);
            }
            case 35: 
            case 45: 
            case 55: 
            case 87: {
                return null;
            }
        }
        TapEnv.toolWarning(-1, "(Compute pointer destinations) Unexpected operator : " + expression.opName());
        return null;
    }

    private TapList pointerAssignmentRec(BoolMatrix dests, TapList lhsZones, TapList rhsZones, boolean lhsTotal, TapList<TapList> dejaVu) {
        if (lhsZones != null && !TapList.contains(dejaVu, lhsZones)) {
            if (lhsZones.head instanceof TapList) {
                dejaVu = new TapList<TapList>(lhsZones, dejaVu);
                return new TapList<TapList>(this.pointerAssignmentRec(dests, (TapList)lhsZones.head, rhsZones != null && rhsZones.head instanceof TapList ? (TapList)rhsZones.head : null, lhsTotal, dejaVu), this.pointerAssignmentRec(dests, lhsZones.tail, rhsZones != null ? rhsZones.tail : null, lhsTotal, dejaVu));
            }
            TapIntList assignedZones = this.getPointerZones((TapIntList)lhsZones.head);
            if (assignedZones != null) {
                TapIntList valueZones;
                TapIntList inAssignedZones = assignedZones;
                if (inAssignedZones.tail != null) {
                    lhsTotal = false;
                }
                TapIntList tapIntList = valueZones = rhsZones == null ? null : ZoneInfo.listAllZones(rhsZones.tail, false);
                if (valueZones == null) {
                    valueZones = new TapIntList(-2, null);
                }
                while (inAssignedZones != null) {
                    int assignedZone = inAssignedZones.head;
                    ZoneInfo ptrZone = this.extendedDeclaredToZoneInfo(assignedZone);
                    int ptrRowIndex = this.extendedDeclaredToVectorIndex(assignedZone, 3, this.curRowMap);
                    if (ptrRowIndex >= 0) {
                        boolean totalAssign = this.curInstruction.getWhereMask() == null && !ptrZone.multiple && (lhsTotal || this.uniqueAccessZones != null && assignedZone >= 0 && this.uniqueAccessZones.get(assignedZone));
                        BoolVector ptrRow = dests.getRow(ptrRowIndex);
                        if (ptrRow == null) {
                            ptrRow = new BoolVector(this.curUnit.hasTooManyZones(), dests.nCols);
                            dests.setRow(ptrRowIndex, ptrRow);
                            if (!totalAssign) {
                                ptrRow.set(this.identityColumnRanks(ptrRowIndex, this.curRowMap, this.curColMap), true);
                            }
                        } else if (totalAssign) {
                            ptrRow.setFalse();
                        }
                        ptrRow.set(this.mapExtendedDeclaredToVectorIndex(valueZones, 0, this.curColMap), true);
                    }
                    inAssignedZones = inAssignedZones.tail;
                }
            }
            return new TapList<TapIntList>(assignedZones, rhsZones == null ? new TapList((TapIntList)new TapIntList(-2, null), null) : rhsZones.tail);
        }
        if (rhsZones == null) {
            return new TapList<TapIntList>(null, new TapList<TapIntList>(new TapIntList(-2, null), null));
        }
        return new TapList<Object>(null, rhsZones.tail);
    }

    private BoolMatrix makePrivatePlusParamsInCaller(BoolMatrix publicDests, int[] resultRowMap, int[] resultColMap, CallArrow arrow) {
        BoolMatrix result = new BoolMatrix(this.curUnit.hasTooManyZones(), PointerAnalyzer.mapSize(resultRowMap), PointerAnalyzer.mapSize(resultColMap));
        result.setIdentity();
        int privateRowLength = result.nRows;
        BoolVector addIdentity = new BoolVector(this.curUnit.hasTooManyZones(), privateRowLength);
        BoolMatrix transferRight = new BoolMatrix(this.curUnit.hasTooManyZones(), publicDests.nCols, result.nCols);
        transferRight.setExplicitZero();
        transferRight.set(publicDests.nCols - 2, resultColMap[2] - 2, true);
        transferRight.set(publicDests.nCols - 1, resultColMap[2] - 1, true);
        for (int publici = arrow.translator.length - 1; publici >= 0; --publici) {
            TapIntList privateColsOfPublici;
            TapIntList privateRowsOfPublici;
            PublicInfo publicInfo = arrow.translator[publici];
            if (publicInfo == null) continue;
            if (publicInfo.kind() == 7 && publicInfo.getParamRank() != 0 || publicInfo.kind() == 10) {
                privateRowsOfPublici = new TapIntList(this.zoneRkToVectorIndex(publicInfo.zone.ptrZoneNb, 4, 3, resultRowMap), null);
                privateColsOfPublici = new TapIntList(this.zoneRkToVectorIndex(publicInfo.zone.zoneNb, 4, 0, resultColMap), null);
            } else {
                int mapClass = publicInfo.kind() == 9 ? 1 : 3;
                privateRowsOfPublici = this.mapZoneRkToVectorIndex(publicInfo.ranks(3), mapClass, 3, resultRowMap);
                privateColsOfPublici = this.mapZoneRkToVectorIndex(publicInfo.ranks(0), mapClass, 0, resultColMap);
            }
            BoolVector publicDestsRow = publicDests.getRow(publici);
            int copyLength = Math.min(result.nCols, publicDests.nCols);
            while (privateRowsOfPublici != null) {
                int rowi = privateRowsOfPublici.head;
                if (publicDestsRow == null) {
                    addIdentity.set(rowi, true);
                } else {
                    BoolVector existingRow = result.getRow(rowi);
                    if (existingRow != null) {
                        existingRow.cumulOr(publicDestsRow, copyLength);
                    } else {
                        result.setRow(rowi, publicDestsRow.copy(copyLength, result.nCols));
                    }
                }
                privateRowsOfPublici = privateRowsOfPublici.tail;
            }
            while (privateColsOfPublici != null) {
                transferRight.set(publici, privateColsOfPublici.head, true);
                privateColsOfPublici = privateColsOfPublici.tail;
            }
        }
        TapIntList implicitIdentityRows = result.getImplicitIdentityIndices();
        result.rows = result.times((BoolMatrix)transferRight).rows;
        while (implicitIdentityRows != null) {
            result.setIdentityRow(implicitIdentityRows.head);
            implicitIdentityRows = implicitIdentityRows.tail;
        }
        for (int i = privateRowLength - 1; i >= 0; --i) {
            if (result.getRow(i) == null || !addIdentity.get(i)) continue;
            result.getRow(i).set(this.identityColumnRanks(i, resultRowMap, resultColMap), true);
        }
        return result;
    }

    private BoolMatrix completeWithParams(BoolMatrix dests, TapList[] paramZones, TapIntList[] elemParamFolders, TapIntList[] ptrElemParamFolders, int[] resultRowMap, int[] resultColMap) {
        BoolMatrix result = new BoolMatrix(this.curUnit.hasTooManyZones(), PointerAnalyzer.mapSize(resultRowMap), PointerAnalyzer.mapSize(resultColMap));
        result.setIdentity();
        int destsColLength = dests.nCols;
        for (int i = dests.nRows - 1; i >= 0; --i) {
            BoolVector origRow = dests.getRow(i);
            if (origRow == null) continue;
            result.setExplicitZeroRow(i);
            result.getRow(i).cumulOr(origRow, destsColLength);
        }
        int firstFormalArgRk = this.curCalledUnit.publicSymbolTable() != null ? this.curCalledUnit.publicSymbolTable().firstDeclaredZone(0) : this.curCalledUnit.externalSymbolTable().freeDeclaredZone(0);
        for (int i = elemParamFolders.length - 1; i >= 0; --i) {
            ZoneInfo elemArgZoneInfo = this.zoneRkToZoneInfo(i + firstFormalArgRk, 4, 0);
            if (elemArgZoneInfo == null) {
                elemParamFolders[i] = null;
                continue;
            }
            int rowi = -1;
            if (elemArgZoneInfo.ptrZoneNb != -1) {
                rowi = this.zoneRkToVectorIndex(elemArgZoneInfo.ptrZoneNb, 4, 3, resultRowMap);
            }
            if (rowi >= 0) {
                result.setExplicitZeroRow(rowi);
            }
            if (elemArgZoneInfo.kind() == 7 && elemArgZoneInfo.index <= paramZones.length) {
                TapList<?> elemArgZones = TapList.getSetFieldLocation(paramZones[elemArgZoneInfo.index - 1], elemArgZoneInfo.accessTree, false);
                TapIntList elemArgDests = ZoneInfo.listAllZones(elemArgZones, false);
                if (rowi >= 0) {
                    ptrElemParamFolders[rowi - resultRowMap[3]] = elemArgZoneInfo.passesByValue(this.curCalledUnit, this.curUnit.language()) && elemArgZoneInfo.targetZoneOf == null ? null : this.mapExtendedDeclaredToVectorIndex(elemArgDests, 3, resultRowMap);
                }
                if (elemArgDests == null) {
                    elemArgDests = new TapIntList(-2, null);
                }
                elemParamFolders[i] = elemArgZoneInfo.passesByValue(this.curCalledUnit, this.curUnit.language()) && elemArgZoneInfo.targetZoneOf == null ? null : this.mapExtendedDeclaredToVectorIndex(elemArgDests, 0, resultColMap);
                if (rowi < 0) continue;
                TapIntList tapIntList = elemArgDests = elemArgZones == null ? null : ZoneInfo.listAllZones(elemArgZones.tail, false);
                if (elemArgDests == null) {
                    elemArgDests = new TapIntList(-2, null);
                }
                while (elemArgDests != null) {
                    int j = this.extendedDeclaredToVectorIndex(elemArgDests.head, 0, resultColMap);
                    if (j >= 0) {
                        result.set(rowi, j, true);
                    }
                    elemArgDests = elemArgDests.tail;
                }
                continue;
            }
            elemParamFolders[i] = null;
        }
        return result;
    }

    private void privatizeTreeOfPublicZones(TapList functionResultDestsTree, TapList[] paramZones, CallArrow arrow, TapList<TapList> dejaVu) {
        if (functionResultDestsTree != null && !TapList.contains(dejaVu, functionResultDestsTree)) {
            dejaVu = new TapList<TapList>(functionResultDestsTree, dejaVu);
            if (functionResultDestsTree.head instanceof TapList) {
                this.privatizeTreeOfPublicZones((TapList)functionResultDestsTree.head, paramZones, arrow, dejaVu);
            } else if (functionResultDestsTree.head instanceof TapIntList) {
                TapIntList pubZs = (TapIntList)functionResultDestsTree.head;
                TapIntList privZs = null;
                while (pubZs != null) {
                    PublicInfo publicInfo = arrow.translator[pubZs.head];
                    if (publicInfo != null) {
                        if (publicInfo.kind() == 7 && publicInfo.zone != null) {
                            ZoneInfo zoneInfo = publicInfo.zone;
                            TapList<?> elemArgZones = TapList.getSetFieldLocation(paramZones[zoneInfo.index - 1], zoneInfo.accessTree, false);
                            TapIntList newElemZones = ZoneInfo.listAllZones(elemArgZones, false);
                            privZs = TapIntList.quickUnion(privZs, TapIntList.reverse(newElemZones));
                        } else if (publicInfo.kind() != 10) {
                            int mapClass = publicInfo.kind() == 9 ? 1 : 3;
                            TapIntList ranks = publicInfo.ranks(0);
                            while (ranks != null) {
                                int privi = this.zoneRkToExtendedDeclared(ranks.head, mapClass, 0);
                                if (privi != -1) {
                                    privZs = new TapIntList(privi, privZs);
                                }
                                ranks = ranks.tail;
                            }
                        }
                    }
                    pubZs = pubZs.tail;
                }
                functionResultDestsTree.head = privZs;
            }
            this.privatizeTreeOfPublicZones(functionResultDestsTree.tail, paramZones, arrow, dejaVu);
        }
    }

    private void replaceLeavesPrivateByPublicZones(TapList returnedZoneTree, Unit unit, TapList<TapList> dejaVu) {
        if (returnedZoneTree != null && !TapList.contains(dejaVu, returnedZoneTree)) {
            dejaVu = new TapList<TapList>(returnedZoneTree, dejaVu);
            if (returnedZoneTree.head instanceof TapList) {
                this.replaceLeavesPrivateByPublicZones((TapList)returnedZoneTree.head, unit, dejaVu);
            } else if (returnedZoneTree.head instanceof TapIntList) {
                TapIntList privZs = (TapIntList)returnedZoneTree.head;
                TapIntList pubZs = null;
                while (privZs != null) {
                    int pubi;
                    int privi = privZs.head;
                    ZoneInfo zoneInfo = PointerAnalyzer.extendedDeclaredToZoneInfo(privi, unit.privateSymbolTable(), unit);
                    for (pubi = unit.paramElemsNb() - 1; pubi >= 0 && !ZoneInfo.eqOrCopyOfEq(unit.paramElemZoneInfo(pubi), zoneInfo); --pubi) {
                    }
                    if (pubi >= 0) {
                        pubZs = new TapIntList(pubi, pubZs);
                    }
                    privZs = privZs.tail;
                }
                returnedZoneTree.head = pubZs;
            }
            this.replaceLeavesPrivateByPublicZones(returnedZoneTree.tail, unit, dejaVu);
        }
    }

    private BoolMatrix pointerDestsClosure(BoolMatrix dests) {
        BoolMatrix closure = new BoolMatrix(this.curUnit.hasTooManyZones(), this.nSEPZ + this.nDPZ, this.nSEZ + 2 + this.nDZ);
        closure.setIdentity();
        int rowNb = dests.nRows;
        BoolVector closureRowComputed = new BoolVector(rowNb);
        for (int rowIndex = rowNb - 1; rowIndex >= 0; --rowIndex) {
            this.pointerDestsClosureRec(closure, rowIndex, closureRowComputed, dests);
        }
        return closure;
    }

    private void pointerDestsClosureRec(BoolMatrix closure, int rowIndex, BoolVector closureRowComputed, BoolMatrix dests) {
        if (!closureRowComputed.get(rowIndex)) {
            int[] ptrMap = this.curRowMap;
            closureRowComputed.set(rowIndex, true);
            int mapClass = PointerAnalyzer.getMapClass(rowIndex, ptrMap);
            ZoneInfo pointerInfo = this.vectorIndexToZoneInfo(rowIndex, mapClass, 3, ptrMap);
            if (pointerInfo != null) {
                ZoneInfo subPointerInfo = pointerInfo.targetZoneOf;
                BoolVector closedRow = null;
                if (subPointerInfo == null) {
                    if (dests.getRow(rowIndex) != null) {
                        closedRow = dests.getRow(rowIndex).copy();
                    }
                } else {
                    int subIndex = this.zoneInfoToVectorIndex(subPointerInfo, mapClass, 3, ptrMap);
                    this.pointerDestsClosureRec(closure, subIndex, closureRowComputed, dests);
                    closedRow = new BoolVector(this.curUnit.hasTooManyZones(), dests.nCols);
                    TapIntList aliases = this.aliasesOfPointedZoneInfo(pointerInfo, closure, mapClass, this.curRowMap, this.curColMap);
                    while (aliases != null) {
                        int rowi = this.extendedDeclaredToVectorIndex(aliases.head, 3, ptrMap);
                        if (rowi >= 0) {
                            BoolVector newRow = dests.getRow(rowi);
                            if (newRow != null) {
                                closedRow.cumulOr(newRow);
                            } else {
                                closedRow.set(this.identityColumnRanks(rowi, ptrMap, this.curColMap), true);
                            }
                        }
                        aliases = aliases.tail;
                    }
                }
                closure.setRow(rowIndex, closedRow);
            }
        }
    }

    private BoolMatrix composePointerDests(BoolMatrix preDests, BoolMatrix preDestsClosed, BoolMatrix newDests, int[] newRowMap, int[] newColMap, TapIntList[] ptrElemParamFolders, TapIntList[] elemParamFolders, boolean[] paramTotals) {
        BoolVector newRow;
        int j;
        int mapClass;
        int[] newRowMap2 = new int[newRowMap.length];
        System.arraycopy(newRowMap, 0, newRowMap2, 0, newRowMap.length);
        int[] newColMap2 = new int[newColMap.length];
        System.arraycopy(newColMap, 0, newColMap2, 0, newColMap.length);
        BoolMatrix result = new BoolMatrix(this.curUnit.hasTooManyZones(), PointerAnalyzer.mapSize(newRowMap2), PointerAnalyzer.mapSize(newColMap2));
        result.setIdentity();
        int rowNb = newDests.nRows;
        BoolVector resultInitialized = new BoolVector(rowNb);
        BoolVector resultHasIdentity = new BoolVector(rowNb);
        resultHasIdentity.setTrue();
        for (mapClass = newRowMap.length - 1; mapClass > 0; --mapClass) {
            for (j = newRowMap[mapClass] - 1; j >= newRowMap[mapClass - 1]; --j) {
                TapIntList aliases;
                ZoneInfo pointerInfo;
                newRow = newDests.getRow(j);
                if (newRow == null || (pointerInfo = this.vectorIndexToZoneInfo(j, mapClass, 3, newRowMap)) == null) continue;
                if (mapClass == 4) {
                    result.setRow(j, newRow.copy(newDests.nCols, result.nCols));
                    aliases = j - newRowMap[3] >= ptrElemParamFolders.length || pointerInfo.index <= 0 || pointerInfo.index > paramTotals.length ? null : ptrElemParamFolders[j - newRowMap[3]];
                } else {
                    aliases = this.getRowsAliasedThroughSubpointer(pointerInfo, j, mapClass, preDestsClosed, newRowMap, newColMap);
                }
                if (aliases == null) continue;
                this.cumulOrDestsRowAtTargetIndices(newRow, pointerInfo, newColMap, mapClass, mapClass != 4 || paramTotals[pointerInfo.index - 1], aliases, result, resultInitialized, resultHasIdentity, null);
            }
        }
        for (j = rowNb - 1; j >= 0; --j) {
            BoolVector resultRow;
            BoolVector preDestsRow;
            newRow = result.getRow(j);
            if (newRow == null) {
                BoolVector boolVector = preDestsRow = j < preDests.nRows ? preDests.getRow(j) : preDestsClosed.getRow(j);
                resultRow = preDestsRow == null ? null : preDestsRow.copy(preDests.nCols, result.nCols);
            } else {
                resultRow = new BoolVector(this.curUnit.hasTooManyZones(), result.nCols);
                for (mapClass = newColMap.length - 1; mapClass > 0; --mapClass) {
                    for (int i = newColMap[mapClass] - 1; i >= newColMap[mapClass - 1]; --i) {
                        ZoneInfo destinationInfo;
                        if (!newRow.get(i)) continue;
                        if (mapClass == 4) {
                            newRow.set(i, false);
                            newRow.set(elemParamFolders[i - newColMap[3]], true);
                            continue;
                        }
                        ZoneInfo zoneInfo = destinationInfo = mapClass == 2 ? null : this.vectorIndexToZoneInfo(i, mapClass, 0, newColMap);
                        if (destinationInfo == null || destinationInfo.targetZoneOf == null) {
                            resultRow.set(i, true);
                            continue;
                        }
                        TapIntList destDests = this.aliasesOfPointedZoneInfo(destinationInfo, preDestsClosed, mapClass, newRowMap, newColMap);
                        while (destDests != null) {
                            int rk = this.extendedDeclaredToVectorIndex(destDests.head, 0, newColMap);
                            if (rk > 0) {
                                resultRow.set(rk, true);
                            }
                            destDests = destDests.tail;
                        }
                    }
                }
                if (j < newRowMap[3] && resultInitialized.get(j) && resultHasIdentity.get(j)) {
                    preDestsRow = preDestsClosed.getRow(j);
                    if (preDestsRow != null) {
                        resultRow.cumulOr(preDestsRow);
                    } else {
                        resultRow.set(this.identityColumnRanks(j, newRowMap, newColMap), true);
                    }
                }
            }
            result.setRow(j, resultRow);
        }
        return result;
    }

    private void cumulOrDestsRowAtTargetIndices(BoolVector newRow, ZoneInfo pointerZoneInfo, int[] varMap, int mapClass, boolean total, TapIntList targetRowIndices, BoolMatrix target, BoolVector initializedRows, BoolVector withIdRows, BoolVector chIdRows) {
        TapIntList identityColumns = this.mapZoneRkToVectorIndex(ZoneInfo.listAllZones(pointerZoneInfo.targetZonesTree, true), mapClass, 0, varMap);
        boolean newRowHasId = newRow.intersects(identityColumns);
        if (newRowHasId) {
            newRow = newRow.copy();
            newRow.set(identityColumns, false);
        }
        if (!total || targetRowIndices.tail != null) {
            newRowHasId = true;
        }
        while (targetRowIndices != null) {
            int targetRowIndex = targetRowIndices.head;
            BoolVector targetRow = target.getRow(targetRowIndex);
            if (targetRow == null || !initializedRows.get(targetRowIndex)) {
                target.setRow(targetRowIndex, newRow.copy());
                if (!newRowHasId) {
                    withIdRows.set(targetRowIndex, false);
                } else if (chIdRows != null) {
                    chIdRows.set(targetRowIndex, true);
                }
                initializedRows.set(targetRowIndex, true);
            } else {
                targetRow.cumulOr(newRow);
                if (!newRowHasId) {
                    withIdRows.set(targetRowIndex, false);
                    if (chIdRows != null) {
                        chIdRows.set(targetRowIndex, true);
                    }
                }
            }
            targetRowIndices = targetRowIndices.tail;
        }
    }

    private TapIntList getRowsAliasedThroughSubpointer(ZoneInfo pointerInfo, int rowIndex, int zoneClass, BoolMatrix preDestsClosed, int[] preDestsClosedRowMap, int[] preDestsClosedColMap) {
        if (pointerInfo.targetZoneOf == null) {
            return new TapIntList(rowIndex, null);
        }
        if (zoneClass == 4) {
            return new TapIntList(rowIndex, null);
        }
        TapIntList pointedDestsList = this.aliasesOfPointedZoneInfo(pointerInfo, preDestsClosed, zoneClass, preDestsClosedRowMap, preDestsClosedColMap);
        if (pointedDestsList != null && pointedDestsList.tail == null && pointedDestsList.head == this.zoneInfoToExtendedDeclared(pointerInfo, zoneClass)) {
            return new TapIntList(rowIndex, null);
        }
        return this.mapExtendedDeclaredToVectorIndex(pointedDestsList, 3, preDestsClosedRowMap);
    }

    private TapIntList aliasesOfPointedZoneInfo(ZoneInfo pointerInfo, BoolMatrix destsClosed, int zoneClass, int[] destsClosedRowMap, int[] destsClosedColMap) {
        ZoneInfo rootPointerInfo = pointerInfo.targetZoneOf;
        BoolVector rootPointerDestsRow = destsClosed.getRow(this.zoneInfoToVectorIndex(rootPointerInfo, zoneClass, 3, destsClosedRowMap));
        if (rootPointerDestsRow == null) {
            int indexAsDeclared = this.zoneInfoToExtendedDeclared(pointerInfo, zoneClass);
            return new TapIntList(indexAsDeclared, null);
        }
        TapList pointedDestsTree = this.curSymbolTable.subTreeOfPointedZones(rootPointerDestsRow, destsClosedColMap, rootPointerInfo.pointerDestType(), ILUtils.pathFromPointerAccess(pointerInfo.accessTree));
        return ZoneInfo.listAllZones(pointedDestsTree, true);
    }

    private BoolMatrix identityPrivatePointerMatrix() {
        BoolMatrix result = this.zeroPrivatePointerMatrix();
        result.setIdentity();
        return result;
    }

    private BoolMatrix zeroPrivatePointerMatrix() {
        return new BoolMatrix(this.curUnit.hasTooManyZones(), this.nSEPZ + this.nDPZ, this.nSEZ + 2 + this.nDZ);
    }

    private void mapExplicitZeroDeclAllkZoneRk(BoolMatrix dests, TapIntList declZones) {
        while (declZones != null) {
            int rowIndex;
            ZoneInfo rowZoneInfo = this.zoneRkToZoneInfo(declZones.head, 3, 0);
            if (rowZoneInfo != null && (rowIndex = this.zoneInfoToVectorIndex(rowZoneInfo, 3, 3, this.curRowMap)) >= 0) {
                dests.setExplicitZeroRow(rowIndex);
            }
            declZones = declZones.tail;
        }
    }

    public TapIntList identityColumnRanks(int rowIndex, int[] ptrMap, int[] varMap) {
        int mapClass = PointerAnalyzer.getMapClass(rowIndex, ptrMap);
        ZoneInfo pointerInfo = this.vectorIndexToZoneInfo(rowIndex, mapClass, 3, ptrMap);
        if (pointerInfo == null) {
            return null;
        }
        return this.mapZoneRkToVectorIndex(ZoneInfo.listAllZones(pointerInfo.targetZonesTree, true), mapClass, 0, varMap);
    }

    private TapIntList getPointerZones(TapIntList zones) {
        TapIntList result = null;
        while (zones != null) {
            if (this.zoneIsPointer(zones.head)) {
                result = new TapIntList(zones.head, result);
            }
            zones = zones.tail;
        }
        return result;
    }

    private BoolMatrix removeDanglingPointers(BoolMatrix dests, FGArrow arrow) {
        BoolMatrix destsWithoutDangling = null;
        Block origBlock = arrow.origin;
        Block destBlock = arrow.destination;
        SymbolTable origSymbolTable = origBlock.symbolTable;
        SymbolTable commonSymbolTable = destBlock.symbolTable.getCommonRoot(origSymbolTable);
        if (dests != null && commonSymbolTable != origSymbolTable && commonSymbolTable.declaredZonesNb(0) < origSymbolTable.declaredZonesNb(0)) {
            Instruction headInstr = destBlock.headInstr();
            Tree attachTree = headInstr == null ? null : headInstr.tree;
            int[] origRowMap = PointerAnalyzer.makeMap3(this.nSEPZ, 0, origSymbolTable.declaredZonesNb(3));
            int[] origColMap = PointerAnalyzer.makeMap3(this.nSEZ, 2, origSymbolTable.declaredZonesNb(0));
            int cutRow = origRowMap[2] + commonSymbolTable.declaredZonesNb(3);
            int cutCol = origColMap[2] + commonSymbolTable.declaredZonesNb(0);
            for (int irow = cutRow - 1; irow >= 0; --irow) {
                ZoneInfo zoneInfo;
                int icol;
                boolean mayNotDangle = false;
                for (icol = cutCol - 1; icol >= 0; --icol) {
                    if (icol == origColMap[2] - 1 || !dests.get(irow, icol)) continue;
                    mayNotDangle = true;
                }
                String dangleTo = "";
                for (icol = origColMap[3] - 1; icol >= cutCol; --icol) {
                    if (!dests.get(irow, icol)) continue;
                    if (destsWithoutDangling == null) {
                        destsWithoutDangling = dests.copy();
                    }
                    destsWithoutDangling.set(irow, origColMap[2] - 1, true);
                    if (!this.terminatingUnit || (zoneInfo = PointerAnalyzer.vectorIndexToZoneInfo(icol, 3, 0, origColMap, origSymbolTable)) == null) continue;
                    if (!dangleTo.isEmpty()) {
                        dangleTo = " or " + dangleTo;
                    }
                    dangleTo = zoneInfo.accessTreePrint(this.curUnit.language()) + dangleTo;
                }
                if (!this.terminatingUnit || dangleTo.isEmpty()) continue;
                zoneInfo = this.vectorIndexToZoneInfo(irow, PointerAnalyzer.getMapClass(irow, origRowMap), 3, origRowMap);
                if (mayNotDangle) {
                    TapEnv.fileWarning(30, attachTree, "(DF12) Pointer " + zoneInfo.accessTreePrint(this.curUnit.language()) + " may be dangling, pointing to " + dangleTo);
                    continue;
                }
                TapEnv.fileWarning(15, attachTree, "(DF12) Pointer " + zoneInfo.accessTreePrint(this.curUnit.language()) + " is dangling, pointing to " + dangleTo);
            }
        }
        return destsWithoutDangling != null ? destsWithoutDangling : dests;
    }

    private TapList<TapPair<TapIntList, BoolVector>> findDestsChangesAfterFlowMerge(Block block) {
        int j;
        BoolMatrix destsAfter = block.pointerInfosIn;
        if (destsAfter == null) {
            return null;
        }
        int[] rowMap = this.curRowMap;
        int nColsAfter = destsAfter.nCols;
        BoolVector changedRows = new BoolVector(destsAfter.nRows);
        TapList<FGArrow> arrows = block.backFlow();
        while (arrows != null) {
            Block origBlock = ((FGArrow)arrows.head).origin;
            BoolMatrix destsBefore = this.afterDests.retrieve(origBlock);
            if (destsBefore != null) {
                SymbolTable origSymbolTable = origBlock.symbolTable;
                BoolMatrix destsBeforeCycle = this.afterDestsCycle.retrieve(origBlock);
                if (destsBeforeCycle != null) {
                    this.explicitIdentitiesBeforeCumulOr(destsBefore, destsBeforeCycle, PointerAnalyzer.makeMap3(this.nSEPZ, 0, origSymbolTable.declaredZonesNb(3)), PointerAnalyzer.makeMap3(this.nSEZ, 2, origSymbolTable.declaredZonesNb(0)));
                    destsBefore.cumulOr(destsBeforeCycle, false, -1);
                }
                int nColsBefore = destsBefore.nCols;
                int nCols = Math.min(nColsBefore, nColsAfter);
                SymbolTable commonSymbolTable = this.curSymbolTable.getCommonRoot(origSymbolTable);
                int commonSize = rowMap[2] + commonSymbolTable.declaredZonesNb(3);
                for (j = destsAfter.nRows - 1; j >= commonSize; --j) {
                    changedRows.set(j, true);
                }
                for (j = commonSize - 1; j >= 0; --j) {
                    BoolVector rowBefore = destsBefore.getRow(j);
                    BoolVector rowAfter = destsAfter.getRow(j);
                    if (rowAfter == null || rowBefore != null && rowAfter.equals(rowBefore, nCols)) continue;
                    changedRows.set(j, true);
                }
            }
            arrows = arrows.tail;
        }
        TapList<TapPair<TapIntList, BoolVector>> destsChanges = null;
        for (j = destsAfter.nRows - 1; j >= 0; --j) {
            if (!changedRows.get(j)) continue;
            destsChanges = new TapList<TapPair<TapIntList, BoolVector>>(new TapPair<TapIntList, BoolVector>(new TapIntList(j, null), destsAfter.getRow(j)), destsChanges);
        }
        return destsChanges;
    }

    private void explicitIdentitiesBeforeCumulOr(BoolMatrix cumulMatrix, BoolMatrix orMatrix, int[] cumulMatrixRowMap, int[] cumulMatrixColMap) {
        if (!orMatrix.isImplicitZero()) {
            int numi = Math.min(cumulMatrix.nRows, orMatrix.nRows);
            boolean cumulWasImplicitZero = cumulMatrix.isImplicitZero();
            if (cumulWasImplicitZero) {
                cumulMatrix.setExplicitZero();
            }
            for (int i = numi - 1; i >= 0; --i) {
                BoolVector cumulRow = cumulMatrix.rows[i];
                if ((cumulRow != null || cumulWasImplicitZero || orMatrix.rows[i] == null) && (cumulRow == null || orMatrix.rows[i] != null)) continue;
                if (cumulRow == null) {
                    cumulRow = cumulMatrix.rows[i] = new BoolVector(this.curUnit.hasTooManyZones(), cumulMatrix.nCols);
                }
                cumulRow.set(this.identityColumnRanks(i, cumulMatrixRowMap, cumulMatrixColMap), true);
            }
        }
    }

    private TapList<TapPair<TapIntList, BoolVector>> findDestsChangesAfterInstruction(BoolMatrix destsBefore, BoolMatrix destsAfter) {
        if (destsBefore == null || destsAfter == null) {
            return null;
        }
        int nCols = destsAfter.nCols;
        TapList<TapPair<TapIntList, BoolVector>> destsChanges = null;
        for (int j = destsAfter.nRows - 1; j >= 0; --j) {
            BoolVector rowBefore = destsBefore.getRow(j);
            BoolVector rowAfter = destsAfter.getRow(j);
            if (rowAfter == null || rowBefore != null && rowAfter.equals(rowBefore, nCols)) continue;
            destsChanges = new TapList<TapPair<TapIntList, BoolVector>>(new TapPair<TapIntList, BoolVector>(new TapIntList(j, null), rowAfter), destsChanges);
        }
        return destsChanges;
    }

    private TapList<Tree> buildCommentsForPointerDests(TapList<TapPair<TapIntList, BoolVector>> destsList) {
        TapList<Object> hdResult;
        if (destsList == null || this.curBlock.pointerInfosIn == null) {
            return null;
        }
        TapList<Object> tlResult = hdResult = new TapList<Object>(null, null);
        TapList<Tree> pointedExpressions = null;
        ToBool toNull = new ToBool(false);
        ToBool toUndef = new ToBool(false);
        ToBool toUnknown = new ToBool(false);
        while (destsList != null) {
            int rowIndex = ((TapIntList)((TapPair)destsList.head).first).head;
            BoolVector destinations = (BoolVector)((TapPair)destsList.head).second;
            ZoneInfo zoneInfo = this.vectorIndexToZoneInfo(rowIndex, PointerAnalyzer.getMapClass(rowIndex, this.curRowMap), 3, this.curRowMap);
            String line = zoneInfo != null ? "     " + zoneInfo.accessTreePrint(this.curUnit.language()) + " points to " : "";
            if (zoneInfo != null) {
                pointedExpressions = this.curSymbolTable.listOfPointedTrees(destinations, this.curColMap, zoneInfo.pointerDestType(), toNull, toUndef, toUnknown);
            }
            boolean firstDest = true;
            while (pointedExpressions != null) {
                line = line + (firstDest ? "" : " or ") + ILUtils.toString((Tree)pointedExpressions.head, this.curUnit.language());
                firstDest = false;
                pointedExpressions = pointedExpressions.tail;
            }
            if (toNull.get()) {
                line = line + (firstDest ? "" : " or ") + "NULL";
                firstDest = false;
            }
            if (toUndef.get()) {
                line = line + (firstDest ? "" : " or ") + "Undef";
                firstDest = false;
            }
            if (toUnknown.get()) {
                line = line + (firstDest ? "" : " or ") + "Unknown";
                firstDest = false;
            }
            tlResult = tlResult.placdl(ILUtils.build(175, line));
            destsList = destsList.tail;
        }
        return hdResult.tail;
    }

    private void placePointerDebugComments() {
        TapList<Tree> comments;
        TapList<Block> blocks = this.curUnit.allBlocks;
        this.setCurBlockEtc(this.curUnit.entryBlock);
        this.curInstruction = this.curBlock.headInstr();
        if (this.curInstruction != null) {
            comments = this.detachPreComments(this.curInstruction);
            this.curInstruction.appendPreComments(comments);
        }
        while (blocks != null) {
            this.setCurBlockEtc((Block)blocks.head);
            this.curInstruction = this.curBlock.headInstr();
            if (this.curInstruction != null) {
                comments = this.detachPreComments(this.curInstruction);
                if (this.curBlock instanceof HeaderBlock) {
                    this.curInstruction.appendPostComments(comments);
                } else {
                    this.curInstruction.appendPreComments(comments);
                }
            }
            TapList<Instruction> instructions = this.curBlock.instructions;
            while (instructions != null) {
                this.curInstruction = (Instruction)instructions.head;
                comments = this.detachPostComments(this.curInstruction);
                this.curInstruction.appendPostComments(comments);
                instructions = instructions.tail;
            }
            blocks = blocks.tail;
        }
        this.setCurBlockEtc(this.curUnit.exitBlock);
        this.curUnit.appendPostComments(this.curUnit.exitBlock.pointerComments());
        this.curUnit.exitBlock.setPointerComments(null);
        this.setCurBlockEtc(null);
    }

    private void tempAttachPreComments(Instruction instruction, TapList<Tree> ptrComments) {
        if (instruction.tree != null) {
            instruction.tree.setAnnotation("ptrPreComments", ptrComments);
        }
    }

    private void tempAttachPostComments(Instruction instruction, TapList<Tree> ptrComments) {
        if (instruction.tree != null) {
            instruction.tree.setAnnotation("ptrPostComments", ptrComments);
        }
    }

    private TapList<Tree> detachPreComments(Instruction instruction) {
        if (instruction.tree == null) {
            return null;
        }
        TapList result = (TapList)instruction.tree.getAnnotation("ptrPreComments");
        instruction.tree.removeAnnotation("ptrPreComments");
        return result;
    }

    private TapList<Tree> detachPostComments(Instruction instruction) {
        if (instruction.tree == null) {
            return null;
        }
        TapList result = (TapList)instruction.tree.getAnnotation("ptrPostComments");
        instruction.tree.removeAnnotation("ptrPostComments");
        return result;
    }
}

