/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.differentiation;

import fr.inria.tapenade.analysis.ADActivityAnalyzer;
import fr.inria.tapenade.analysis.ActivityPattern;
import fr.inria.tapenade.analysis.ReqExplicit;
import fr.inria.tapenade.differentiation.BlockDifferentiator;
import fr.inria.tapenade.differentiation.DifferentiationEnv;
import fr.inria.tapenade.differentiation.FlowGraphDifferentiator;
import fr.inria.tapenade.differentiation.ProcedureCallDifferentiator;
import fr.inria.tapenade.differentiation.UnitDiffInfo;
import fr.inria.tapenade.differentiation.VarRefDifferentiator;
import fr.inria.tapenade.representation.AlignmentBoundary;
import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.BasicBlock;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.CallArrow;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.Directive;
import fr.inria.tapenade.representation.EntryBlock;
import fr.inria.tapenade.representation.ExitBlock;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.FunctionTypeSpec;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.InterfaceDecl;
import fr.inria.tapenade.representation.MPIcallInfo;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.PrimitiveTypeSpec;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeDecl;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.UnitStorage;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.VoidTypeSpec;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.Chrono;
import fr.inria.tapenade.utils.Int2ZoneInfo;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.Tree;

public class CallGraphDifferentiator {
    private final DifferentiationEnv adEnv;
    private CallGraph srcCallGraph;
    private CallGraph diffCallGraph;
    private Unit curUnit;
    private Unit curDiffUnit;
    private final UnitStorage<UnitDiffInfo> unitDiffInfos;
    private TapList<TapPair<Unit, UnitDiffInfo>> intrinsicUnitDiffInfos;
    private TapList<Unit> calledPrimalFormUnits;
    protected UnitStorage<Boolean> unitsHavePrimal;
    protected UnitStorage<Boolean> unitsHaveDiff;
    protected final Chrono unitDiffTimer = new Chrono();

    private FlowGraphDifferentiator flowGraphDifferentiator() {
        return this.adEnv.flowGraphDifferentiator;
    }

    private BlockDifferentiator blockDifferentiator() {
        return this.adEnv.blockDifferentiator;
    }

    private ProcedureCallDifferentiator procedureCallDifferentiator() {
        return this.adEnv.procedureCallDifferentiator;
    }

    private VarRefDifferentiator varRefDifferentiator() {
        return this.adEnv.varRefDifferentiator;
    }

    private boolean multiDirMode() {
        return this.adEnv.multiDirMode;
    }

    private String[][] suffixes() {
        return this.adEnv.suffixes;
    }

    private ADActivityAnalyzer activityAnalyzer() {
        return TapEnv.adActivityAnalyzer();
    }

    private void setCurUnitEtc(Unit unit) {
        this.curUnit = unit;
        TapEnv.setRelatedUnit(unit);
        this.adEnv.setCurUnitEtc(unit);
    }

    private void setCurDiffUnit(Unit diffUnit) {
        this.curDiffUnit = diffUnit;
        this.adEnv.curDiffUnit = diffUnit;
    }

    private int curDiffUnitSort() {
        return this.adEnv.curDiffUnitSort;
    }

    protected CallGraphDifferentiator(DifferentiationEnv adEnv) {
        this.adEnv = adEnv;
        this.unitDiffInfos = new UnitStorage(adEnv.srcCallGraph());
        for (int i = adEnv.srcCallGraph().nbUnits() - 1; i >= 0; --i) {
            Unit unit = adEnv.srcCallGraph().sortedUnit(i);
            assert (unit != null);
            this.unitDiffInfos.store(unit, new UnitDiffInfo(unit, adEnv));
        }
        TapList<Unit> intrinsicUnits = adEnv.srcCallGraph().intrinsicUnits();
        while (intrinsicUnits != null) {
            this.intrinsicUnitDiffInfos = new TapList<TapPair<Unit, UnitDiffInfo>>(new TapPair(intrinsicUnits.head, new UnitDiffInfo((Unit)intrinsicUnits.head, adEnv)), this.intrinsicUnitDiffInfos);
            intrinsicUnits = intrinsicUnits.tail;
        }
    }

    public static CallGraph run(CallGraph origCallGraph, TapList<Unit> rootUnits, String[][] suffixes) {
        DifferentiationEnv newAdEnv = new DifferentiationEnv(origCallGraph, suffixes);
        newAdEnv.callGraphDifferentiator.differentiateDownFrom(rootUnits);
        return newAdEnv.diffCallGraph();
    }

    private void differentiateDownFrom(TapList<Unit> rootUnits) {
        TapList<Unit> diffUnits;
        TapList<ActivityPattern> activityPatterns;
        Chrono diffTimer = new Chrono();
        this.srcCallGraph = this.adEnv.srcCallGraph();
        for (int i = this.srcCallGraph.nbUnits() - 1; i >= 0; --i) {
            this.setCurUnitEtc(this.srcCallGraph.sortedUnit(i));
            activityPatterns = this.curUnit.specificInfoAD;
            while (activityPatterns != null) {
                this.adEnv.setCurActivity((ActivityPattern)activityPatterns.head);
                this.computeCommonActivities(this.adEnv.curActivity());
                if (!this.curUnit.hasSource()) {
                    BoolVector unitCallActive = this.adEnv.curActivity().callActivity();
                    BoolVector unitExitActive = this.adEnv.curActivity().exitActivity();
                    if (unitCallActive != null && unitExitActive != null) {
                        this.augmentExternalEntryExitActivities(unitCallActive, unitExitActive);
                    }
                }
                activityPatterns = activityPatterns.tail;
            }
            if (!this.curUnit.isModule()) continue;
            this.computeModuleCommonActivities(this.curUnit);
        }
        this.adEnv.setCurActivity(null);
        this.setCurUnitEtc(null);
        boolean codeContainsSomethingActive = false;
        TapList<Unit> orderedUnitsRootSTFirst = this.srcCallGraph.buildSortedUnitsList(0, -1, 1);
        this.diffCallGraph = new CallGraph("Differentiation of " + this.srcCallGraph.name() + " under " + rootUnits);
        this.adEnv.setDiffCallGraph(this.diffCallGraph);
        this.diffCallGraph.createRootSymbolTables();
        this.adEnv.setDiffCallGraphAndRootUnits(this.diffCallGraph, rootUnits);
        this.diffCallGraph.setBindFortranCType(this.srcCallGraph.bindFortranCType());
        for (int i = this.srcCallGraph.nbUnits() - 1; i >= 0; --i) {
            this.setCurUnitEtc(this.srcCallGraph.sortedUnit(i));
            if (this.curUnit == null || this.curUnit.rank() < 0 || this.curUnit.isModule()) continue;
            activityPatterns = this.curUnit.specificInfoAD;
            if ((this.adEnv.traceCurDifferentiation || TapEnv.traceActivity() != null) && activityPatterns != null) {
                TapEnv.printlnOnTrace(" Precompute formalArgsActivity for each activityPattern of Unit " + this.curUnit + ':' + this.curUnit.headTree());
            }
            UnitDiffInfo diffInfo = this.getUnitDiffInfo(this.curUnit);
            while (activityPatterns != null) {
                this.adEnv.setCurActivity((ActivityPattern)activityPatterns.head);
                boolean[] formalArgsActivity = ADActivityAnalyzer.formalArgsActivity(this.adEnv.curActivity());
                diffInfo.setUnitFormalArgsActivityS(this.adEnv.curActivity(), formalArgsActivity);
                if (this.adEnv.traceCurDifferentiation || TapEnv.traceActivity() != null) {
                    TapEnv.printOnTrace(" - for activity " + this.adEnv.curActivity() + ", formalArgsActivity is ");
                    if (formalArgsActivity == null) {
                        TapEnv.printOnTrace("null");
                    } else {
                        TapEnv.printOnTrace("[");
                        int nbArgs = Math.min(this.curUnit.formalArgumentsNb(), formalArgsActivity.length - 1);
                        for (int j = 0; j < formalArgsActivity.length; ++j) {
                            TapEnv.printOnTrace("" + formalArgsActivity[j]);
                            if (j + 1 >= formalArgsActivity.length) continue;
                            TapEnv.printOnTrace(j + 1 == nbArgs ? "->" : ", ");
                        }
                        TapEnv.printlnOnTrace("]");
                    }
                }
                if (TapEnv.doActivity() && this.adEnv.curActivity().callingPatterns() != null && (!this.activityAnalyzer().isActiveUnit(this.adEnv.curActivity()) || TapEnv.mustAdjoint() && this.curUnit.mustDifferentiateJoint())) {
                    this.calledPrimalFormUnits = TapList.addUnlessPresent(this.calledPrimalFormUnits, this.curUnit);
                }
                activityPatterns = activityPatterns.tail;
            }
        }
        this.adEnv.setCurActivity(null);
        this.setCurUnitEtc(null);
        if (TapEnv.doActivity() && this.calledPrimalFormUnits != null) {
            this.calledPrimalFormUnits = Unit.allCalleesMulti(this.calledPrimalFormUnits);
        }
        TapList<Unit> userUnitsRootSTLast = null;
        TapList<Unit> units = orderedUnitsRootSTFirst;
        while (units != null) {
            Unit userUnit = (Unit)units.head;
            if (!userUnit.isOutside()) {
                userUnitsRootSTLast = new TapList<Unit>(userUnit, userUnitsRootSTLast);
            }
            units = units.tail;
        }
        this.takeCopyUnitDecisions(userUnitsRootSTLast, this.calledPrimalFormUnits);
        TapList<Unit> inRootUnits = rootUnits;
        while (inRootUnits != null) {
            Unit rootUnit = (Unit)inRootUnits.head;
            if (!rootUnit.mustDifferentiateSplit() && !rootUnit.mustDifferentiateJoint()) {
                rootUnit.maybeCheckpointed = true;
            }
            inRootUnits = inRootUnits.tail;
        }
        for (int i = this.srcCallGraph.nbUnits() - 1; i >= 0; --i) {
            BoolVector unitPublicZonesUsed;
            BoolVector unitPublicZonesWritten;
            boolean unitHasInOut;
            this.setCurUnitEtc(this.srcCallGraph.sortedUnit(i));
            boolean bl = unitHasInOut = this.curUnit.unitInOutR() != null;
            if (unitHasInOut) {
                unitPublicZonesWritten = this.curUnit.unitInOutPossiblyW();
                unitPublicZonesUsed = this.curUnit.unitInOutPossiblyRorW();
            } else {
                unitPublicZonesWritten = new BoolVector(this.curUnit.paramElemsNb());
                unitPublicZonesWritten.setTrue();
                unitPublicZonesUsed = new BoolVector(this.curUnit.paramElemsNb());
                unitPublicZonesUsed.setTrue();
            }
            UnitDiffInfo diffInfo = this.getUnitDiffInfo(this.curUnit);
            activityPatterns = this.curUnit.specificInfoAD;
            while (activityPatterns != null) {
                this.adEnv.setCurActivity((ActivityPattern)activityPatterns.head);
                if (this.activityAnalyzer().isActiveUnit(this.adEnv.curActivity()) || !TapEnv.doActivity()) {
                    BoolVector unitPublicZonesWithDiff = this.adEnv.curActivity().callActivity().or(this.adEnv.curActivity().exitActivity());
                    if (unitHasInOut && this.adEnv.curActivity().entryReqX() != null) {
                        unitPublicZonesWithDiff.cumulOr(this.adEnv.curActivity().entryReqX().and(this.curUnit.unitInOutPossiblyR()));
                        unitPublicZonesWithDiff.cumulOr(this.adEnv.curActivity().entryAvlX().or(this.adEnv.curActivity().exitReqX()).and(unitPublicZonesWritten));
                    }
                    int nbFormalArgs = this.curUnit.functionTypeSpec().argumentsTypes != null ? 1 + this.curUnit.functionTypeSpec().argumentsTypes.length : 1;
                    boolean[] diffArgsByValueNeedOverwrite = new boolean[nbFormalArgs];
                    boolean[] diffArgsByValueNeedOnlyIncrement = new boolean[nbFormalArgs];
                    for (int j = nbFormalArgs - 1; j >= 0; --j) {
                        diffArgsByValueNeedOverwrite[j] = false;
                        diffArgsByValueNeedOnlyIncrement[j] = true;
                        if (j != 0 && !this.curUnit.passesByValue(j, this.curUnit.language())) continue;
                        this.fillPassByValueInfos(this.curUnit.argsPublicRankTrees[j], j, this.curUnit, unitPublicZonesUsed, unitPublicZonesWritten, unitPublicZonesWithDiff, diffArgsByValueNeedOverwrite, diffArgsByValueNeedOnlyIncrement);
                    }
                    diffInfo.setUnitDiffArgsByValueNeedOverwriteInfoS(this.adEnv.curActivity(), diffArgsByValueNeedOverwrite);
                    diffInfo.setUnitDiffArgsByValueNeedOnlyIncrementInfoS(this.adEnv.curActivity(), diffArgsByValueNeedOnlyIncrement);
                }
                activityPatterns = activityPatterns.tail;
            }
        }
        this.adEnv.setCurActivity(null);
        this.setCurUnitEtc(null);
        TapEnv.printlnOnTrace(40, "A");
        this.diffCallGraph.topBlock = new BasicBlock(this.diffCallGraph.globalRootSymbolTable(), null, null);
        this.diffCallGraph.topBlock.copyInstructions(this.srcCallGraph.topBlock, this.adEnv.copiedIncludes);
        if (this.srcCallGraph.nbUnits() > 0) {
            Unit topUnit = this.srcCallGraph.sortedUnit(0);
            assert (topUnit != null);
            if (!topUnit.isFortran()) {
                this.diffCallGraph.topPreComments = this.srcCallGraph.topPreComments == null ? null : this.srcCallGraph.topPreComments.copy();
                this.diffCallGraph.topPostComments = this.srcCallGraph.topPostComments == null ? null : this.srcCallGraph.topPostComments.copy();
                this.diffCallGraph.topPreCommentsBlock = this.srcCallGraph.topPreCommentsBlock == null ? null : this.srcCallGraph.topPreCommentsBlock.copy();
                this.diffCallGraph.topPostCommentsBlock = this.srcCallGraph.topPostCommentsBlock == null ? null : this.srcCallGraph.topPostCommentsBlock.copy();
            }
        }
        units = orderedUnitsRootSTFirst;
        while (units != null) {
            this.setCurUnitEtc((Unit)units.head);
            UnitDiffInfo diffInfo = this.getUnitDiffInfo(this.curUnit);
            if (this.curUnit.isPackage() && !this.curUnit.isUndefined()) {
                Unit enclosingUnit = this.curUnit.upperLevelUnit();
                Unit diffEnclosingUnitOfDiff = null;
                if (enclosingUnit != null) {
                    diffEnclosingUnitOfDiff = this.getUnitDiffInfo(enclosingUnit).getDiff();
                }
                Unit diffPackage = this.curUnit.copyUnitExceptSymbolTables(this.diffCallGraph, diffEnclosingUnitOfDiff, null);
                this.initializeDiffUnit(diffPackage, this.curUnit, -1);
                if (this.adEnv.traceCurDifferentiation || TapEnv.traceActivity() != null) {
                    TapEnv.printlnOnTrace(" =Prepared diff package for " + this.curUnit + " => " + diffPackage + ", contained in " + diffPackage.upperLevelUnit());
                }
                diffInfo.setDiff(diffPackage);
                if (this.curUnit.isPredefinedModuleOrTranslationUnit()) {
                    diffPackage.name = this.curUnit.name;
                    diffPackage.setPredefinedModuleOrTranslationUnit();
                } else if (this.unitsHaveDiff.retrieve(this.curUnit) == Boolean.FALSE && this.unitsHavePrimal.retrieve(this.curUnit) == Boolean.FALSE) {
                    diffPackage.name = this.curUnit.name;
                    diffPackage.setIsDiffPackage(!TapEnv.get().stripPrimalModules);
                } else {
                    diffPackage.setIsDiffPackage(true);
                }
                if (this.adEnv.traceCurDifferentiation) {
                    TapEnv.printlnOnTrace(" ---> " + this.curUnit + " => " + diffPackage + " isDiffPackage?:" + diffPackage.isDiffPackage());
                }
            }
            units = units.tail;
        }
        units = orderedUnitsRootSTFirst;
        while (units != null) {
            this.setCurUnitEtc((Unit)units.head);
            UnitDiffInfo diffInfo = this.getUnitDiffInfo(this.curUnit);
            if (!this.curUnit.isPackage() && this.unitsHavePrimal.retrieve(this.curUnit) == Boolean.TRUE) {
                TapList<Unit> diffsOfContainer;
                Unit principalDiffContainer;
                Unit container = this.curUnit.upperLevelUnit();
                Unit containerOfInterface = this.curUnit.enclosingUnitOfInterface;
                Unit unit = container == null ? null : (principalDiffContainer = container.isPackage() ? this.getUnitDiffInfo(container).getDiff() : diffInfo.getAnyContainingDiffUnit(this.curUnit, container));
                Unit principalDiffInterface = containerOfInterface == null ? null : (containerOfInterface.isPackage() ? this.getUnitDiffInfo(containerOfInterface).getDiff() : diffInfo.getAnyContainingDiffUnit(this.curUnit, containerOfInterface));
                Unit copiedUnit = this.curUnit.copyUnitExceptSymbolTables(this.diffCallGraph, principalDiffContainer, principalDiffInterface);
                copiedUnit.origUnit = this.curUnit;
                copiedUnit.setKind(this.curUnit);
                int n = copiedUnit.arrayDimMin = this.curUnit.isFortran() ? 1 : 0;
                if (this.adEnv.traceCurDifferentiation || TapEnv.traceActivity() != null) {
                    TapEnv.printlnOnTrace(" =Prepared copied unit for " + this.curUnit + " => " + copiedUnit + ", contained in " + copiedUnit.upperLevelUnit());
                }
                this.adEnv.copiedUnits.store(this.curUnit, copiedUnit);
                this.adEnv.copiedUnitsBack.store(copiedUnit, this.curUnit);
                TapList<Unit> tapList = diffsOfContainer = container == null ? null : this.getUnitDiffInfo(container).getAllDiffsPlusCopy();
                while (diffsOfContainer != null) {
                    Unit diffContainer = (Unit)diffsOfContainer.head;
                    if (diffContainer != principalDiffContainer) {
                        diffContainer.addLowerLevelUnit(copiedUnit);
                        CallGraph.addCallArrow(diffContainer, 3, copiedUnit);
                    }
                    diffsOfContainer = diffsOfContainer.tail;
                }
            } else {
                this.curUnit.origUnit = this.curUnit;
            }
            if (this.curUnit.isProcedure() || this.curUnit.isVarFunction() || this.curUnit.isInterface()) {
                activityPatterns = this.curUnit.specificInfoAD;
                if (activityPatterns == null && this.unitsHaveDiff.retrieve(this.curUnit) == Boolean.TRUE) {
                    ActivityPattern dummyActivityPattern = new ActivityPattern(this.curUnit, true, false, this.adEnv.diffKind);
                    int nbArgs = this.curUnit.functionTypeSpec().argumentsTypes.length;
                    boolean[] allFalseActivity = new boolean[nbArgs + 1];
                    for (int i = nbArgs; i >= 0; --i) {
                        allFalseActivity[i] = false;
                    }
                    diffInfo.setUnitFormalArgsActivityS(dummyActivityPattern, allFalseActivity);
                    activityPatterns = this.curUnit.specificInfoAD = new TapList<ActivityPattern>(dummyActivityPattern, null);
                }
                while (activityPatterns != null) {
                    this.adEnv.setCurActivity((ActivityPattern)activityPatterns.head);
                    if (this.patternCreatesDiffCode(this.adEnv.curActivity(), this.curUnit)) {
                        this.createDiffUnits(this.curUnit, this.adEnv.curActivity());
                        codeContainsSomethingActive = true;
                    }
                    activityPatterns = activityPatterns.tail;
                }
                this.adEnv.setCurActivity(null);
            }
            units = units.tail;
        }
        if (this.srcCallGraph.intrinsicUnits() != null) {
            for (Unit intrinsicUnit : this.srcCallGraph.intrinsicUnits()) {
                if (intrinsicUnit.hasPredefinedDerivatives()) continue;
                this.setCurUnitEtc(intrinsicUnit);
                activityPatterns = this.curUnit.specificInfoAD;
                while (activityPatterns != null) {
                    this.createDiffUnits(this.curUnit, (ActivityPattern)activityPatterns.head);
                    activityPatterns = activityPatterns.tail;
                }
            }
        }
        TapEnv.printlnOnTrace(40, "B");
        units = this.srcCallGraph.units();
        while (units != null) {
            this.setCurUnitEtc((Unit)units.head);
            if (this.curUnit.rank() >= 0) {
                Unit diffDestUnit;
                CallArrow origCallArrow;
                TapList<CallArrow> arrows;
                UnitDiffInfo origDiffInfo = this.getUnitDiffInfo(this.curUnit);
                diffUnits = origDiffInfo.getAllDiffsPlusCopy();
                while (diffUnits != null) {
                    this.setCurDiffUnit((Unit)diffUnits.head);
                    boolean diffOrigIsCopy = this.curDiffUnit == this.adEnv.getPrimalCopyOfOrigUnit(this.curUnit);
                    arrows = this.curUnit.callees();
                    while (arrows != null) {
                        origCallArrow = (CallArrow)arrows.head;
                        Unit destUnit = origCallArrow.destination;
                        if ((origCallArrow.isImport() || origCallArrow.isContain()) && destUnit.rank() >= 0) {
                            UnitDiffInfo destDiffInfo = this.getUnitDiffInfo(destUnit);
                            TapList<Unit> destDiffUnits = destDiffInfo.getAllDiffsPlusCopy();
                            while (destDiffUnits != null) {
                                boolean diffDestIsCopy;
                                diffDestUnit = (Unit)destDiffUnits.head;
                                boolean bl = diffDestIsCopy = diffDestUnit == this.adEnv.getPrimalCopyOfOrigUnit(destUnit);
                                if (!diffOrigIsCopy || diffDestIsCopy || origCallArrow.isImport()) {
                                    CallArrow newCallArrow = CallGraph.addCallArrow(this.curDiffUnit, -1, diffDestUnit);
                                    if (origCallArrow.isImport()) {
                                        newCallArrow.setImport(true);
                                    }
                                    if (origCallArrow.isContain()) {
                                        newCallArrow.setContain(true);
                                    }
                                }
                                destDiffUnits = destDiffUnits.tail;
                            }
                        }
                        arrows = arrows.tail;
                    }
                    diffUnits = diffUnits.tail;
                }
                this.setCurDiffUnit(this.adEnv.getPrimalCopyOfOrigUnit(this.curUnit));
                if (this.curDiffUnit != null) {
                    arrows = this.curUnit.callees();
                    while (arrows != null) {
                        origCallArrow = (CallArrow)arrows.head;
                        Unit destUnit = origCallArrow.destination;
                        if (origCallArrow.isCall() && destUnit.rank() >= 0) {
                            diffDestUnit = this.adEnv.getPrimalCopyOfOrigUnit(destUnit);
                            if (diffDestUnit == null) {
                                diffDestUnit = destUnit;
                                TapEnv.printlnOnTrace(40, "ADDING CALLARROW FROM PRIMAL COPY " + this.curDiffUnit + " TO ORIG " + diffDestUnit);
                            } else {
                                TapEnv.printlnOnTrace(40, "ADDING CALLARROW FROM PRIMAL COPY " + this.curDiffUnit + " TO PRIMAL COPY " + diffDestUnit);
                            }
                            CallGraph.addCallArrow(this.curDiffUnit, 1, diffDestUnit);
                        }
                        arrows = arrows.tail;
                    }
                }
            }
            units = units.tail;
        }
        TapEnv.printlnOnTrace(40, "C");
        TapList<Object> rootAssociationsST = new TapList<Object>(null, null);
        this.diffCallGraph.setGlobalRootSymbolTable(this.srcCallGraph.globalRootSymbolTable().smartCopy(rootAssociationsST, this.diffCallGraph, this.diffCallGraph, this.adEnv.copiedUnits));
        this.diffCallGraph.topBlock.symbolTable = this.diffCallGraph.globalRootSymbolTable();
        this.diffCallGraph.globalRootSymbolTable().declarationsBlock = this.diffCallGraph.topBlock;
        this.diffCallGraph.setFortranRootSymbolTable(this.srcCallGraph.fortranRootSymbolTable().smartCopy(rootAssociationsST, this.diffCallGraph, this.diffCallGraph, this.adEnv.copiedUnits));
        this.diffCallGraph.fortranRootSymbolTable().declarationsBlock = new BasicBlock(this.diffCallGraph.fortranRootSymbolTable(), null, null);
        this.diffCallGraph.fortranRootSymbolTable().declarationsBlock.copyInstructions(this.srcCallGraph.fortranRootSymbolTable().declarationsBlock, this.adEnv.copiedIncludes);
        this.diffCallGraph.setcRootSymbolTable(this.srcCallGraph.cRootSymbolTable().smartCopy(rootAssociationsST, this.diffCallGraph, this.diffCallGraph, this.adEnv.copiedUnits));
        this.diffCallGraph.cRootSymbolTable().declarationsBlock = new BasicBlock(this.diffCallGraph.cRootSymbolTable(), null, null);
        this.diffCallGraph.cRootSymbolTable().declarationsBlock.copyInstructions(this.srcCallGraph.cRootSymbolTable().declarationsBlock, this.adEnv.copiedIncludes);
        this.diffCallGraph.setcPlusPlusRootSymbolTable(this.srcCallGraph.cPlusPlusRootSymbolTable().smartCopy(rootAssociationsST, this.diffCallGraph, this.diffCallGraph, this.adEnv.copiedUnits));
        this.diffCallGraph.cPlusPlusRootSymbolTable().declarationsBlock = new BasicBlock(this.diffCallGraph.cPlusPlusRootSymbolTable(), null, null);
        this.diffCallGraph.cPlusPlusRootSymbolTable().declarationsBlock.copyInstructions(this.srcCallGraph.cPlusPlusRootSymbolTable().declarationsBlock, this.adEnv.copiedIncludes);
        TapList<Unit> topUnits = this.srcCallGraph.topUnits();
        while (topUnits != null) {
            Unit topUnit = (Unit)topUnits.head;
            if (topUnit.isTranslationUnit()) {
                SymbolTable tuST = topUnit.publicSymbolTable();
                SymbolTable diffTUST = tuST.smartCopy(rootAssociationsST, this.getUnitDiffInfo(topUnit).getDiff(), this.diffCallGraph, this.adEnv.copiedUnits);
                diffTUST.containerFileName = tuST.containerFileName + TapEnv.get().diffFileSuffix;
                diffTUST.setShortName("SymbolTable of Translation Unit (i.e. file) " + diffTUST.containerFileName);
                this.diffCallGraph.addTranslationUnitSymbolTable(diffTUST);
                Unit diffTopUnit = this.getUnitDiffInfo(topUnit).getDiff();
                diffTopUnit.setTranslationUnitSymbolTable(diffTUST);
                diffTopUnit.setPublicSymbolTable(diffTUST);
                diffTopUnit.setOtherName(topUnit);
                topUnit.setOtherName(diffTopUnit);
            }
            topUnits = topUnits.tail;
        }
        if (this.srcCallGraph.nbUnits() > 0 && TapEnv.associationByAddress()) {
            Unit topUnit = this.srcCallGraph.sortedUnit(0);
            assert (topUnit != null);
            int aaUnitLang = topUnit.language();
            if (topUnit.isFortran()) {
                aaUnitLang = 3;
            }
            this.createAssocAddressDiffTypesUnit(aaUnitLang);
            if (TapEnv.inputLanguage() == 100) {
                if (topUnit.isFortran()) {
                    this.createAssocAddressDiffTypesUnit(4);
                } else {
                    this.createAssocAddressDiffTypesUnit(3);
                }
            }
        }
        units = orderedUnitsRootSTFirst;
        while (units != null) {
            this.setCurUnitEtc((Unit)units.head);
            UnitDiffInfo diffInfo = this.getUnitDiffInfo(this.curUnit);
            diffUnits = diffInfo.getAllDiffsPlusCopy();
            while (diffUnits != null) {
                this.setCurDiffUnit((Unit)diffUnits.head);
                if (this.curUnit.translationUnitSymbolTable() != null) {
                    this.curDiffUnit.setTranslationUnitSymbolTable(this.curUnit.translationUnitSymbolTable().getExistingCopy(rootAssociationsST));
                }
                this.createDiffUnitSymbolTables(rootAssociationsST);
                this.curDiffUnit.orig2copiedBlocks = null;
                this.curDiffUnit.origPublicSTDeclarationBlock = null;
                this.curDiffUnit.copyPublicSTDeclarationBlock = null;
                if (this.curUnit.isStandard() || this.curUnit.isInterface()) {
                    TapList<SymbolTable> localSymbolTables = this.curUnit.symbolTablesBottomUp();
                    while (localSymbolTables != null) {
                        ((SymbolTable)localSymbolTables.head).cleanCopySymbolDecls();
                        localSymbolTables = localSymbolTables.tail;
                    }
                }
                diffUnits = diffUnits.tail;
            }
            units = units.tail;
        }
        if (TapEnv.inputLanguage() == 4) {
            this.srcCallGraph.cRootSymbolTable().cleanCopySymbolDecls();
        } else if (TapEnv.inputLanguage() != 100) {
            this.srcCallGraph.fortranRootSymbolTable().cleanCopySymbolDecls();
        } else {
            this.srcCallGraph.globalRootSymbolTable().cleanCopySymbolDecls();
            this.srcCallGraph.fortranRootSymbolTable().cleanCopySymbolDecls();
            this.srcCallGraph.cRootSymbolTable().cleanCopySymbolDecls();
        }
        if (this.srcCallGraph.bindFortranCFunctions() != null) {
            this.diffCallGraph.setBindCFortranCFunctions(this.srcCallGraph.bindFortranCFunctions());
        }
        for (int i = this.srcCallGraph.nbUnits() - 1; i >= 0; --i) {
            this.setCurUnitEtc(this.srcCallGraph.sortedUnit(i));
            TapList<SymbolTable> localSymbolTables = this.curUnit.symbolTablesBottomUp();
            while (localSymbolTables != null) {
                ((SymbolTable)localSymbolTables.head).cleanCopySymbolDecls();
                localSymbolTables = localSymbolTables.tail;
            }
        }
        this.setCurUnitEtc(null);
        if (!codeContainsSomethingActive) {
            String rootNames = null;
            inRootUnits = this.adEnv.rootUnits;
            while (inRootUnits != null) {
                rootNames = rootNames == null ? ((Unit)inRootUnits.head).name : rootNames + ' ' + ((Unit)inRootUnits.head).name;
                inRootUnits = inRootUnits.tail;
            }
            TapEnv.fileWarning(5, -1, "(AD06) Differentiation root procedures (" + rootNames + ") have no active input nor output");
        }
        if (TapEnv.modeIsOverloading()) {
            CallGraphDifferentiator.solveNewSymbolHoldersOfUnits(this.diffCallGraph.topUnits(), this.adEnv.emptyCopiedUnitSuffix);
            this.blockDifferentiator().differentiateDeclarationsOfBlock(this.diffCallGraph.topBlock, 1, null, this.srcCallGraph.cRootSymbolTable(), this.diffCallGraph.cRootSymbolTable(), 4, false);
            CallGraphDifferentiator.solveNewSymbolHoldersOfCallGraphTop(this.diffCallGraph, this.adEnv.emptyCopiedUnitSuffix);
        }
        TapEnv.printlnOnTrace(40, "D");
        if (this.multiDirMode()) {
            this.initializeMultiDirNumberMax(this.diffCallGraph.globalRootSymbolTable());
        }
        for (int i = this.srcCallGraph.nbUnits() - 1; i >= 0; --i) {
            this.setCurUnitEtc(this.srcCallGraph.sortedUnit(i));
            if (!this.curUnit.isStandard() && !this.curUnit.isVarFunction() && !this.curUnit.isInterface() && !this.curUnit.isOutside()) continue;
            this.buildFunctionTypeSpecOfDiffUnits();
            if (!TapEnv.associationByAddress() || !this.curUnit.isStandard()) continue;
            this.buildFunctionTypeSpecOfCopyUnit();
        }
        if (this.srcCallGraph.intrinsicUnits() != null) {
            for (Unit intrinsicUnit : this.srcCallGraph.intrinsicUnits()) {
                this.setCurUnitEtc(intrinsicUnit);
                if (intrinsicUnit.hasPredefinedDerivatives()) continue;
                this.buildFunctionTypeSpecOfDiffUnits();
                activityPatterns = this.curUnit.specificInfoAD;
                while (activityPatterns != null) {
                    this.adEnv.setCurActivity((ActivityPattern)activityPatterns.head);
                    diffUnits = this.getUnitDiffInfo(this.curUnit).getAllDiffs(this.adEnv.curActivity());
                    while (diffUnits != null) {
                        this.setCurDiffUnit((Unit)diffUnits.head);
                        this.differentiateExternalUnit(this.adEnv.curActivity());
                        diffUnits = diffUnits.tail;
                    }
                    activityPatterns = activityPatterns.tail;
                }
            }
            this.adEnv.setCurActivity(null);
        }
        TapEnv.printlnOnTrace(40, "E");
        for (int i = this.srcCallGraph.nbUnits() - 1; i >= 0; --i) {
            this.setCurUnitEtc(this.srcCallGraph.sortedUnit(i));
            Unit copiedUnit = this.adEnv.getPrimalCopyOfOrigUnit(this.curUnit);
            if (!this.curUnit.isPackage() && copiedUnit != null) {
                TapList<Instruction> origNonFlow = this.curUnit.nonFlowInstructions;
                while (origNonFlow != null) {
                    Unit copySubUnit;
                    UnitDiffInfo subUnitDiffInfo;
                    Unit definedSrcUnit = (Unit)((Instruction)origNonFlow.head).tree.getAnnotation("Unit");
                    if (definedSrcUnit != null && (subUnitDiffInfo = this.getUnitDiffInfo(definedSrcUnit)) != null && (copySubUnit = subUnitDiffInfo.getCopyForDiff()) != null) {
                        copiedUnit.nonFlowInstructions = TapList.addLast(copiedUnit.nonFlowInstructions, Instruction.createUnitDefinitionStub(copySubUnit, null));
                    }
                    origNonFlow = origNonFlow.tail;
                }
                TapList<Block> blocks = copiedUnit.allBlocks();
                while (blocks != null) {
                    Block block = (Block)blocks.head;
                    TapList<Instruction> instructions = block.instructions;
                    while (instructions != null) {
                        Unit copySubUnit;
                        UnitDiffInfo subUnitDiffInfo;
                        Instruction instr = (Instruction)instructions.head;
                        Unit definedSrcUnit = instr.isUnitDefinitionStub();
                        if (definedSrcUnit != null && (subUnitDiffInfo = this.getUnitDiffInfo(definedSrcUnit)) != null && (copySubUnit = subUnitDiffInfo.getCopyForDiff()) != null) {
                            instr.updateUnitDefinitionStub(copySubUnit);
                        }
                        instructions = instructions.tail;
                    }
                    blocks = blocks.tail;
                }
            }
            if (this.curUnit.isStandard() && TapEnv.dbadMode() != 0) {
                this.placeDebugMidPointIfNone(this.curUnit);
            }
            activityPatterns = this.curUnit.specificInfoAD;
            while (activityPatterns != null) {
                this.adEnv.setCurActivity((ActivityPattern)activityPatterns.head);
                this.adEnv.curUnitIsActiveUnit = this.patternCreatesDiffCode(this.adEnv.curActivity(), this.curUnit);
                this.adEnv.curUnitIsContext = this.adEnv.curActivity().isContext();
                if (this.curUnit.isInterface() || this.unitsHaveDiff.retrieve(this.curUnit) == Boolean.TRUE) {
                    if (this.curUnit.isStandard()) {
                        if (this.patternCreatesDiffCode(this.adEnv.curActivity(), this.curUnit)) {
                            this.flowGraphDifferentiator().differentiateProcedure();
                        }
                    } else if (this.curUnit.isExternal()) {
                        this.differentiateExternalUnit(this.adEnv.curActivity());
                    } else if (this.curUnit.isVarFunction()) {
                        this.differentiateVarFunctionUnit(this.adEnv.curActivity());
                    } else if (this.curUnit.isInterface() && codeContainsSomethingActive) {
                        this.differentiateInterface();
                    } else {
                        TapEnv.fileWarning(15, null, "Unit not differentiated: " + this.curUnit);
                    }
                }
                activityPatterns = activityPatterns.tail;
            }
            this.adEnv.setCurActivity(null);
            this.adEnv.curUnitIsActiveUnit = false;
            this.adEnv.curUnitIsContext = false;
            if (!this.curUnit.isPackage()) continue;
            this.differentiatePackage(this.curUnit, rootAssociationsST);
        }
        this.setCurDiffUnit(null);
        this.setCurUnitEtc(null);
        if (TapEnv.get().oldContext) {
            this.differentiateAllocateInCopiedUnits();
        }
        if (!TapEnv.modeIsOverloading()) {
            CallGraphDifferentiator.solveNewSymbolHoldersOfUnits(this.diffCallGraph.topUnits(), this.adEnv.emptyCopiedUnitSuffix);
            int topBlockMode = TapEnv.mustTangent() ? 1 : (TapEnv.mustAdjoint() ? 2 : 0);
            this.adEnv.pushCurDiffSorts(topBlockMode, topBlockMode);
            if (this.diffCallGraph.topBlock != null && TapList.length(this.diffCallGraph.topBlock.instructions) != 0) {
                if (this.adEnv.traceCurDifferentiation) {
                    TapEnv.printlnOnTrace("");
                    TapEnv.printlnOnTrace("*** NOW Differentiating declarations of " + this.srcCallGraph.cRootSymbolTable().shortName());
                }
                TapEnv.setRelatedLanguage(4);
                this.blockDifferentiator().differentiateDeclarationsOfBlock(this.diffCallGraph.topBlock, topBlockMode, null, this.srcCallGraph.cRootSymbolTable(), this.diffCallGraph.cRootSymbolTable(), 4, false);
                TapEnv.setRelatedLanguage(null);
            }
            TapEnv.setRelatedLanguage(null);
            CallGraphDifferentiator.solveNewSymbolHoldersOfCallGraphTop(this.diffCallGraph, this.adEnv.emptyCopiedUnitSuffix);
            if (TapEnv.associationByAddress() && TapEnv.assocAddressDiffTypesUnit(3) != null) {
                TapEnv.assocAddressDiffTypesUnit(3).publicSymbolTable().solveNewSymbolHolders(this.adEnv.emptyCopiedUnitSuffix);
            }
            this.adEnv.popCurDiffSorts();
        }
        units = this.srcCallGraph.units();
        while (units != null) {
            this.setCurUnitEtc((Unit)units.head);
            for (int diffSort = 0; diffSort < 5; ++diffSort) {
                diffUnits = this.getUnitDiffInfo(this.curUnit).getAllDiffs(diffSort);
                if (this.curUnit.isModule()) {
                    Unit diffModule = this.getUnitDiffInfo(this.curUnit).getDiff();
                    diffUnits = new TapList<Unit>(diffModule, null);
                }
                while (diffUnits != null) {
                    Instruction hdInstr;
                    this.setCurDiffUnit((Unit)diffUnits.head);
                    if (this.curDiffUnit.isInterface() && this.curDiffUnit.entryBlock() != null && (hdInstr = this.curDiffUnit.entryBlock().headInstr()) != null && hdInstr.tree != null) {
                        this.curDiffUnit.name = ILUtils.getCallFunctionNameString(hdInstr.tree);
                    }
                    if (this.curUnit.otherName() == null || this.curUnit.otherName().equals(this.curUnit)) {
                        this.curUnit.setOtherName(this.curDiffUnit);
                    }
                    this.curDiffUnit.setOtherName(this.curUnit);
                    if (this.curDiffUnit.isStandard() || this.curDiffUnit.isInterface()) {
                        if (diffSort == 0) {
                            this.updateModulesAndCopiedUnitsInCopiedUnit(this.curDiffUnit.privateSymbolTable());
                            this.updateModulesAndCopiedUnitsInCopiedUnit(this.curDiffUnit.publicSymbolTable());
                        }
                        this.updateRenamedTypeDecl(this.curDiffUnit);
                    }
                    this.flowGraphDifferentiator().differentiateSaveList(this.curDiffUnit.privateSymbolTable());
                    CallGraphDifferentiator.solveNewSymbolHoldersOfUnit(this.curDiffUnit, this.adEnv.emptyCopiedUnitSuffix);
                    diffUnits = diffUnits.tail;
                }
            }
            units = units.tail;
        }
        this.setCurDiffUnit(null);
        this.setCurUnitEtc(null);
        CallGraphDifferentiator.solveNewSymbolHoldersOfUnits(this.diffCallGraph.topUnits(), this.adEnv.emptyCopiedUnitSuffix);
        CallGraphDifferentiator.solveNewSymbolHoldersOfCallGraphTop(this.diffCallGraph, this.adEnv.emptyCopiedUnitSuffix);
        this.setCurUnitEtc(null);
        topUnits = this.diffCallGraph.topUnits();
        while (topUnits != null) {
            Unit topUnit = (Unit)topUnits.head;
            if (topUnit.isTranslationUnit() && topUnit.isCorMore() && topUnit.allBlocks() != null) {
                Block topBlock = (Block)topUnit.allBlocks().head;
                if (TapEnv.dbadMode() != 0) {
                    topBlock.addInstructionAt(ILUtils.build(99, "<adDebug.h>"), 0);
                } else if (TapEnv.mustContext()) {
                    topBlock.addInstructionAt(ILUtils.build(99, "<adContext.h>"), 0);
                }
                if (this.adEnv.usesADMM) {
                    topBlock.addInstructionAt(ILUtils.build(99, "<admm.h>"), 0);
                }
                if (TapEnv.mustAdjoint()) {
                    topBlock.addInstructionAt(ILUtils.build(99, "<adBuffer.h>"), 0);
                }
                if (TapEnv.associationByAddress() && !"AATypes.h".equals(topUnit.name)) {
                    String aaTypesUnitName = "AATypes" + TapEnv.get().diffFileSuffix + ".c";
                    topBlock.addInstructionAt(ILUtils.build(99, "\"" + aaTypesUnitName + "\""), 0);
                }
            }
            topUnits = topUnits.tail;
        }
        this.updateCopiedUnits(false);
        this.updateCopiedUnits(true);
        if (TapEnv.associationByAddress()) {
            this.updateAAInCopiedUnits();
        }
        units = this.srcCallGraph.units();
        while (units != null) {
            this.setCurUnitEtc((Unit)units.head);
            diffUnits = this.getUnitDiffInfo(this.curUnit).getAllDiffsPlusCopy();
            while (diffUnits != null) {
                this.setCurDiffUnit((Unit)diffUnits.head);
                if (this.curUnit.publicSymbolTable() != null && this.curDiffUnit.publicSymbolTable() != null) {
                    this.updateCopiedInterfaceAndExternalDecls(this.curUnit, this.curUnit.publicSymbolTable().getAllTopFunctionDecls(), true);
                }
                if (this.curUnit.privateSymbolTable() != null && this.curDiffUnit.privateSymbolTable() != null) {
                    this.updateCopiedInterfaceAndExternalDecls(this.curUnit, this.curUnit.privateSymbolTable().getAllTopFunctionDecls(), false);
                }
                diffUnits = diffUnits.tail;
            }
            units = units.tail;
        }
        this.updateCopiedExternalDecls(this.srcCallGraph.cRootSymbolTable().getAllTopFunctionDecls(), this.srcCallGraph.cRootSymbolTable(), this.diffCallGraph.cRootSymbolTable());
        TapList<SymbolTable> srcTuSymbolTables = this.srcCallGraph.getTranslationUnitSymbolTables();
        while (srcTuSymbolTables != null) {
            this.updateCopiedExternalDecls(((SymbolTable)srcTuSymbolTables.head).getAllTopFunctionDecls(), (SymbolTable)srcTuSymbolTables.head, ((SymbolTable)srcTuSymbolTables.head).getExistingCopy(rootAssociationsST));
            srcTuSymbolTables = srcTuSymbolTables.tail;
        }
        units = this.srcCallGraph.units();
        while (units != null) {
            this.setCurUnitEtc((Unit)units.head);
            if (this.curUnit.functionTypeSpec() != null && this.curUnit.isAFunction() && (this.curUnit.otherReturnVar() == null || this.curUnit.otherReturnVar().symbol.equals(this.curUnit.name))) {
                String returnName = this.curUnit.name;
                for (int diffSort = 0; diffSort < 5; ++diffSort) {
                    diffUnits = this.getUnitDiffInfo(this.curUnit).getAllDiffs(diffSort);
                    if (diffSort != 0) continue;
                    while (diffUnits != null) {
                        SymbolTable pubST;
                        VariableDecl oldReturnDecl;
                        Unit copiedUnit = (Unit)diffUnits.head;
                        if (copiedUnit != null && !copiedUnit.name.equals(returnName) && (oldReturnDecl = (pubST = copiedUnit.publicSymbolTable()).getTopVariableDecl(returnName)) != null) {
                            pubST.removeDecl(returnName, 1, true);
                        }
                        diffUnits = diffUnits.tail;
                    }
                }
            }
            units = units.tail;
        }
        this.setCurUnitEtc(null);
        TapEnv.resetRelatedUnit();
        this.buildDifferentiationAssociations();
        TapEnv.printlnOnTrace(7, "@@ Differentiation total time " + diffTimer.elapsed() + " s");
    }

    private void createAssocAddressDiffTypesUnit(int aaUnitLang) {
        Unit aaTUUnit = this.diffCallGraph.createNewUnit(null, aaUnitLang);
        String suffixLang = ".f03";
        if (aaUnitLang == 4) {
            suffixLang = ".h";
        }
        aaTUUnit.setTranslationUnit("AATypes" + suffixLang);
        SymbolTable tuST = new SymbolTable(this.diffCallGraph.languageRootSymbolTable(aaUnitLang));
        aaTUUnit.setTranslationUnitSymbolTable(tuST);
        aaTUUnit.setPublicSymbolTable(tuST);
        tuST.containerFileName = "AATypes";
        tuST.unit = aaTUUnit;
        tuST.setShortName("AssocByAddress public tuST");
        BasicBlock declBlock = new BasicBlock(tuST, null, null);
        tuST.declarationsBlock = declBlock;
        aaTUUnit.setEntryBlock(new EntryBlock(tuST));
        aaTUUnit.setExitBlock(new ExitBlock(tuST));
        this.diffCallGraph.addTranslationUnitSymbolTable(tuST);
        new FGArrow((Block)aaTUUnit.entryBlock(), -1, 1, (Block)declBlock);
        new FGArrow((Block)declBlock, 0, 0, (Block)aaTUUnit.exitBlock());
        TapList<Block> allBlocks = new TapList<Block>(declBlock, null);
        if (aaUnitLang == 4 || aaUnitLang == 5) {
            declBlock.instructions = new TapList<Instruction>(new Instruction(ILUtils.build(136)), null);
            aaTUUnit.makeFlowGraph(aaTUUnit.entryBlock(), allBlocks, aaTUUnit.exitBlock(), false);
            TapEnv.setAssocAddressDiffTypesUnit(aaTUUnit);
        } else {
            Unit aaDiffTypeUnit = this.diffCallGraph.createNewUnit(aaTUUnit, aaUnitLang);
            declBlock.instructions = new TapList<Instruction>(Instruction.createUnitDefinitionStub(aaDiffTypeUnit, declBlock), null);
            aaTUUnit.makeFlowGraph(aaTUUnit.entryBlock(), allBlocks, aaTUUnit.exitBlock(), false);
            TapEnv.setAssocAddressDiffTypesUnit(aaDiffTypeUnit);
            aaDiffTypeUnit.name = "AATypes";
            aaDiffTypeUnit.setTranslationUnitSymbolTable(tuST);
            SymbolTable st = new SymbolTable(tuST);
            st.setShortName("AssocByAddress public ST");
            st.unit = aaDiffTypeUnit;
            aaDiffTypeUnit.setPublicSymbolTable(st);
            st = new SymbolTable(st);
            st.setShortName("AssocByAddress private ST");
            st.unit = aaDiffTypeUnit;
            aaDiffTypeUnit.setPrivateSymbolTable(st);
            aaDiffTypeUnit.setModule();
            BasicBlock declBlockModule = new BasicBlock(aaDiffTypeUnit.publicSymbolTable(), null, null);
            declBlockModule.instructions = new TapList<Instruction>(new Instruction(ILUtils.build(192, ILUtils.build(94, "ISO_C_BINDING"), ILUtils.build(161))), null);
            aaDiffTypeUnit.setEntryBlock(new EntryBlock(aaDiffTypeUnit.publicSymbolTable()));
            aaDiffTypeUnit.setExitBlock(new ExitBlock(aaDiffTypeUnit.publicSymbolTable()));
            aaDiffTypeUnit.publicSymbolTable().declarationsBlock = declBlockModule;
            new FGArrow((Block)aaDiffTypeUnit.entryBlock(), -1, 1, (Block)declBlockModule);
            new FGArrow((Block)declBlockModule, 0, 0, (Block)aaDiffTypeUnit.exitBlock());
            allBlocks = new TapList<BasicBlock>(declBlockModule, null);
            aaDiffTypeUnit.makeFlowGraph(aaDiffTypeUnit.entryBlock(), allBlocks, aaDiffTypeUnit.exitBlock(), false);
            aaTUUnit.lowerLevelUnits = new TapList<Unit>(aaDiffTypeUnit, null);
            CallGraph.addCallArrow(aaTUUnit, 3, aaDiffTypeUnit);
        }
    }

    private void buildDifferentiationAssociations() {
        this.diffCallGraph.backAssociations = null;
        TapList<Unit> units = this.srcCallGraph.units();
        while (units != null) {
            Unit unit = (Unit)units.head;
            if (unit.rank() >= 0) {
                UnitDiffInfo diffInfo = this.getUnitDiffInfo(unit);
                TapList<Unit> orderedDiffUnits = diffInfo.getAllDiffs();
                Unit copyUnit = this.adEnv.getPrimalCopyOfOrigUnit(unit);
                if (copyUnit != null && !TapList.contains(orderedDiffUnits, copyUnit)) {
                    orderedDiffUnits = TapList.addLast(orderedDiffUnits, copyUnit);
                }
                this.diffCallGraph.backAssociations = new TapList<TapPair<Unit, TapList<Unit>>>(new TapPair<Unit, TapList<Unit>>(unit, orderedDiffUnits), this.diffCallGraph.backAssociations);
            }
            units = units.tail;
        }
    }

    protected UnitDiffInfo getUnitDiffInfo(Unit unit) {
        if (unit.isIntrinsic()) {
            return (UnitDiffInfo)TapList.cassq(unit, this.intrinsicUnitDiffInfos);
        }
        return this.unitDiffInfos.retrieve(unit);
    }

    private void buildFunctionTypeSpecOfDiffUnits() {
        for (int mode = 4; mode > 0; --mode) {
            TapList<ActivityPattern> activityPatterns = this.curUnit.specificInfoAD;
            while (activityPatterns != null) {
                this.adEnv.setCurActivity((ActivityPattern)activityPatterns.head);
                this.setCurDiffUnit(this.adEnv.getDiffOfUnit(this.curUnit, this.adEnv.curActivity(), mode));
                if (this.curDiffUnit != null) {
                    boolean isMainProcedure;
                    if (this.multiDirMode()) {
                        this.flowGraphDifferentiator().initializeMultiDirNumberMax();
                    }
                    FunctionTypeSpec diffTypeSpec = this.curUnit.functionTypeSpec();
                    boolean bl = isMainProcedure = this.curUnit == this.srcCallGraph.getMainUnit();
                    if (!(mode != 1 && mode != 2 && mode != 4 || isMainProcedure)) {
                        diffTypeSpec = this.differentiateFunctionTypeSpec(this.adEnv.curActivity(), this.curDiffUnit.publicSymbolTable(), mode);
                    }
                    this.curDiffUnit.setFunctionTypeSpec(diffTypeSpec);
                    if (isMainProcedure && this.curDiffUnit.isCorMore()) {
                        this.curDiffUnit.publicSymbolTable().removeDecl("main", 0, true);
                    }
                }
                activityPatterns = activityPatterns.tail;
            }
        }
        this.adEnv.setCurActivity(null);
    }

    private void buildFunctionTypeSpecOfCopyUnit() {
        Unit copiedUnit = this.adEnv.copiedUnits.retrieve(this.curUnit);
        if (copiedUnit != null) {
            WrapperTypeSpec returnType;
            FunctionTypeSpec diffTypeSpec = copiedUnit.functionTypeSpec();
            WrapperTypeSpec[] paramsTypes = diffTypeSpec.argumentsTypes;
            TapList<ActivityPattern> activityPatterns = this.curUnit.specificInfoAD;
            UnitDiffInfo unitDiffInfo = this.getUnitDiffInfo(this.curUnit);
            WrapperTypeSpec diffReturnType = returnType = diffTypeSpec.returnType;
            TapList<WrapperTypeSpec> diffArgTypes = null;
            while (activityPatterns != null) {
                this.adEnv.setCurActivity((ActivityPattern)activityPatterns.head);
                boolean[] formalArgsActivity = unitDiffInfo.getUnitFormalArgsActivityS(this.adEnv.curActivity());
                boolean[] formalArgsPointerActivity = ReqExplicit.formalArgsPointerActivity(this.adEnv.curActivity(), paramsTypes.length);
                if (formalArgsActivity != null) {
                    if (this.curUnit.isAFunction()) {
                        diffReturnType = returnType.checkDiffTypeSpec(copiedUnit.publicSymbolTable(), this.curUnit.publicSymbolTable(), this.curDiffUnitSort(), this.suffixes()[1][3], false, this.multiDirMode(), this.varRefDifferentiator().getMultiDirDimensionMax(), null, this.curUnit.name, this.curUnit.name, null, null);
                    }
                    for (int i = paramsTypes.length - 1; i >= 0; --i) {
                        WrapperTypeSpec diffParamType;
                        WrapperTypeSpec paramType = paramsTypes[i];
                        if (formalArgsActivity[i] || formalArgsPointerActivity[i]) {
                            diffParamType = paramType.checkDiffTypeSpec(copiedUnit.publicSymbolTable(), this.curUnit.publicSymbolTable(), this.curDiffUnitSort(), this.suffixes()[1][3], false, this.multiDirMode(), this.varRefDifferentiator().getMultiDirDimensionMax(), null, this.curUnit.name + "'s arg" + (i + 1), this.curUnit.name + "_arg" + (i + 1), null, null);
                            if (diffParamType == null) {
                                diffParamType = paramType;
                            } else if (diffParamType.equalsLiterally(paramType)) {
                                diffParamType = paramType;
                            }
                        } else {
                            diffParamType = paramType;
                        }
                        diffArgTypes = new TapList<WrapperTypeSpec>(diffParamType, diffArgTypes);
                    }
                    diffTypeSpec = new FunctionTypeSpec(diffReturnType, diffArgTypes);
                    copiedUnit.setFunctionTypeSpec(diffTypeSpec);
                }
                activityPatterns = activityPatterns.tail;
            }
        }
    }

    private void augmentExternalEntryExitActivities(BoolVector unitCallActive, BoolVector unitExitActive) {
        if (TapEnv.modeIsAdjoint()) {
            unitExitActive.cumulOr(unitCallActive);
        } else {
            unitCallActive.cumulOr(unitExitActive);
            TapIntList resultRks = this.curUnit.publicRankOfResult();
            while (resultRks != null) {
                unitCallActive.set(resultRks.head, false);
                resultRks = resultRks.tail;
            }
        }
    }

    private void takeCopyUnitDecisions(TapList<Unit> unitsRootSTLast, TapList<Unit> calledPrimalFormUnits) {
        TapList<CallArrow> importingArrows;
        Unit unit;
        boolean traceDDDD = false;
        if (traceDDDD) {
            TapEnv.printlnOnTrace(" DDDD Units called in Primal form:" + calledPrimalFormUnits);
        }
        Unit importedUnit = null;
        this.unitsHavePrimal = new UnitStorage(this.srcCallGraph);
        this.unitsHaveDiff = new UnitStorage(this.srcCallGraph);
        UnitStorage<Boolean> unitsImportActive = new UnitStorage<Boolean>(this.srcCallGraph);
        UnitStorage<Boolean> unitsImportPrimal = new UnitStorage<Boolean>(this.srcCallGraph);
        TapList<Unit> inUnits = unitsRootSTLast;
        while (inUnits != null) {
            unit = (Unit)inUnits.head;
            this.unitsHavePrimal.store(unit, Boolean.FALSE);
            this.unitsHaveDiff.store(unit, Boolean.FALSE);
            unitsImportActive.store(unit, Boolean.FALSE);
            unitsImportPrimal.store(unit, Boolean.FALSE);
            inUnits = inUnits.tail;
        }
        inUnits = unitsRootSTLast;
        while (inUnits != null) {
            SymbolDecl activeSymbol;
            unit = (Unit)inUnits.head;
            boolean isActive = false;
            if (unit.isModule() || unit.isClass()) {
                activeSymbol = this.symbolTableContainsActiveSymbolDecl(unit.publicSymbolTable());
                if (activeSymbol == null && unit.protectedSymbolTable() != null) {
                    activeSymbol = this.symbolTableContainsActiveSymbolDecl(unit.protectedSymbolTable());
                }
                if (activeSymbol == null) {
                    activeSymbol = this.symbolTableContainsActiveSymbolDecl(unit.privateSymbolTable());
                }
                boolean bl = isActive = activeSymbol != null;
                if (traceDDDD && isActive) {
                    TapEnv.printlnOnTrace(" DDDD package " + unit + " must have Diff because it contains active object " + activeSymbol);
                }
            } else if (unit.isTranslationUnit()) {
                activeSymbol = this.symbolTableContainsActiveSymbolDecl(unit.publicSymbolTable());
                boolean bl = isActive = activeSymbol != null;
                if (traceDDDD && isActive) {
                    TapEnv.printlnOnTrace(" DDDD file " + unit + " must have Diff because it contains an active object " + activeSymbol);
                }
            } else {
                TapList<ActivityPattern> activityPatterns = unit.specificInfoAD;
                while (!isActive && activityPatterns != null) {
                    boolean bl = isActive = ((ActivityPattern)activityPatterns.head).isContext() || this.activityAnalyzer().isActiveUnit((ActivityPattern)activityPatterns.head) || TapEnv.reqExplicitAnalyzer() != null && TapEnv.reqExplicitAnalyzer().isPointerActiveUnit((ActivityPattern)activityPatterns.head);
                    if (traceDDDD && isActive) {
                        TapEnv.printlnOnTrace(" DDDD Unit " + unit + " must have Diff because it is context or active or pointerActive");
                    }
                    activityPatterns = activityPatterns.tail;
                }
            }
            if (isActive) {
                this.unitsHaveDiff.store(unit, Boolean.TRUE);
                while ((unit = unit.upperLevelUnit()) != null) {
                    this.unitsHaveDiff.store(unit, Boolean.TRUE);
                    if (!traceDDDD) continue;
                    TapEnv.printlnOnTrace(" DDDD " + unit + " must have Diff because it contains the previous one");
                }
            }
            inUnits = inUnits.tail;
        }
        boolean stabilized = false;
        while (!stabilized) {
            stabilized = true;
            inUnits = unitsRootSTLast;
            while (inUnits != null) {
                unit = (Unit)inUnits.head;
                if (unitsImportActive.retrieve(unit) == Boolean.FALSE) {
                    importingArrows = unit.callees();
                    boolean refersToActiveOrImporting = false;
                    while (importingArrows != null && !refersToActiveOrImporting) {
                        if (((CallArrow)importingArrows.head).isImport()) {
                            importedUnit = ((CallArrow)importingArrows.head).destination;
                            boolean bl = refersToActiveOrImporting = this.unitsHaveDiff.retrieve(importedUnit) == Boolean.TRUE || unitsImportActive.retrieve(importedUnit) == Boolean.TRUE;
                            if (traceDDDD && refersToActiveOrImporting) {
                                TapEnv.printlnOnTrace(" DDDD Unit " + unit + " imports active because imports " + importedUnit);
                            }
                        }
                        importingArrows = importingArrows.tail;
                    }
                    if (refersToActiveOrImporting) {
                        unitsImportActive.store(unit, Boolean.TRUE);
                        while ((unit = unit.upperLevelUnit()) != null) {
                            unitsImportActive.store(unit, Boolean.TRUE);
                            if (!traceDDDD) continue;
                            TapEnv.printlnOnTrace(" DDDD Unit " + unit + " imports active because it contains the previous one");
                        }
                        stabilized = false;
                    }
                }
                inUnits = inUnits.tail;
            }
        }
        inUnits = unitsRootSTLast;
        while (inUnits != null) {
            unit = (Unit)inUnits.head;
            if (unit.isPackage()) {
                if (unitsImportActive.retrieve(unit) == Boolean.TRUE) {
                    this.unitsHaveDiff.store(unit, Boolean.TRUE);
                    if (traceDDDD) {
                        TapEnv.printlnOnTrace(" DDDD package " + unit + " must have Diff because it imports active");
                    }
                }
                if (!(unit.isTranslationUnit() || TapEnv.get().stripPrimalModules && this.unitsHaveDiff.retrieve(unit) != Boolean.TRUE || this.unitsHavePrimal.retrieve(unit) == Boolean.TRUE)) {
                    this.unitsHavePrimal.store(unit, Boolean.TRUE);
                    if (traceDDDD) {
                        TapEnv.printlnOnTrace(" DDDD package " + unit + " must have Primal because " + (TapEnv.get().stripPrimalModules ? "it must have Diff" : "-nooptim stripprimalmodules"));
                    }
                    this.setAllContainedHavePrimalRec(unit, traceDDDD, unit);
                }
            }
            inUnits = inUnits.tail;
        }
        inUnits = unitsRootSTLast;
        while (inUnits != null) {
            unit = (Unit)inUnits.head;
            if (!unit.isPackage() && this.unitsHavePrimal.retrieve(unit) != Boolean.TRUE) {
                Unit topContainer;
                for (topContainer = unit.upperLevelUnit(); topContainer != null && !topContainer.isTopInFile(); topContainer = topContainer.upperLevelUnit()) {
                }
                if (traceDDDD && TapEnv.get().stripPrimalCode && TapEnv.get().stripPrimalEvenIfImportsActive && unitsImportActive.retrieve(unit) == Boolean.TRUE) {
                    TapEnv.printlnOnTrace(" DDDD NOTE: non-package " + unit + " should have primal because imports active, but option disables this");
                }
                if (!TapEnv.get().stripPrimalCode || unitsImportActive.retrieve(unit) == Boolean.TRUE && !TapEnv.get().stripPrimalEvenIfImportsActive || TapList.contains(calledPrimalFormUnits, unit) && (unit.isCorMore() || unit.isFortran2003() && unit.getNameFromBindC() != null && topContainer != null) || topContainer != null && this.unitsHaveDiff.retrieve(topContainer) == Boolean.TRUE) {
                    if (traceDDDD) {
                        TapEnv.printlnOnTrace(" DDDD non-package " + unit + " must have Primal because " + (!TapEnv.get().stripPrimalCode ? "-nooptim stripprimalcode" : "imports active OR contains called in Primal form OR is contained in must Have Primal"));
                    }
                    this.unitsHavePrimal.store(unit, Boolean.TRUE);
                }
            }
            inUnits = inUnits.tail;
        }
        stabilized = false;
        while (!stabilized) {
            stabilized = true;
            inUnits = unitsRootSTLast;
            while (inUnits != null) {
                unit = (Unit)inUnits.head;
                if (unitsImportPrimal.retrieve(unit) == Boolean.FALSE) {
                    importingArrows = unit.callees();
                    boolean refersToOrCallsPrimalOrImporting = false;
                    if (TapEnv.get().stripPrimalEvenIfImportsActive) {
                        importingArrows = null;
                    }
                    while (importingArrows != null && !refersToOrCallsPrimalOrImporting) {
                        if (((CallArrow)importingArrows.head).isImport()) {
                            importedUnit = ((CallArrow)importingArrows.head).destination;
                            boolean bl = refersToOrCallsPrimalOrImporting = this.unitsHavePrimal.retrieve(importedUnit) == Boolean.TRUE || unitsImportPrimal.retrieve(importedUnit) == Boolean.TRUE;
                        }
                        if (traceDDDD && refersToOrCallsPrimalOrImporting) {
                            TapEnv.printlnOnTrace(" DDDD " + unit + " must have Primal because imports " + importedUnit + (this.unitsHavePrimal.retrieve(importedUnit) != false ? " that must have Primal" : " that imports Primal"));
                        }
                        importingArrows = importingArrows.tail;
                    }
                    if (!refersToOrCallsPrimalOrImporting) {
                        TapList allCallers = unit.allCallers().tail;
                        boolean primalCaller = TapList.contains(calledPrimalFormUnits, unit);
                        Unit callerUnit = null;
                        Unit calleeUnit = null;
                        while (!primalCaller && allCallers != null) {
                            callerUnit = (Unit)allCallers.head;
                            primalCaller = this.unitsHavePrimal.retrieve(callerUnit) == Boolean.TRUE || unitsImportPrimal.retrieve(callerUnit) == Boolean.TRUE || TapList.contains(calledPrimalFormUnits, callerUnit);
                            allCallers = allCallers.tail;
                        }
                        if (primalCaller) {
                            TapList allCallees = unit.allCallees().tail;
                            boolean primalCallee = false;
                            while (!primalCallee && allCallees != null) {
                                calleeUnit = (Unit)allCallees.head;
                                primalCallee = this.unitsHavePrimal.retrieve(calleeUnit) == Boolean.TRUE || unitsImportPrimal.retrieve(calleeUnit) == Boolean.TRUE;
                                allCallees = allCallees.tail;
                            }
                            if (primalCallee) {
                                refersToOrCallsPrimalOrImporting = true;
                                if (traceDDDD) {
                                    TapEnv.printlnOnTrace(" DDDD " + unit + " must have Primal because " + (callerUnit == null ? "it is itself a called in Primal form" : "it is called by Primal (or called in Primal form) " + callerUnit) + " and it calls Primal " + calleeUnit);
                                }
                            }
                        }
                    }
                    if (refersToOrCallsPrimalOrImporting) {
                        unitsImportPrimal.store(unit, Boolean.TRUE);
                        this.setAllContainedHavePrimalRec(unit, traceDDDD, unit);
                        for (unit = unit.upperLevelUnit(); unit != null && !unit.isTranslationUnit(); unit = unit.upperLevelUnit()) {
                            unitsImportPrimal.store(unit, Boolean.TRUE);
                            if (!traceDDDD) continue;
                            TapEnv.printlnOnTrace(" DDDD " + unit + " must have Primal because it contains the previous one");
                        }
                        stabilized = false;
                    }
                }
                inUnits = inUnits.tail;
            }
        }
        inUnits = unitsRootSTLast;
        while (inUnits != null) {
            unit = (Unit)inUnits.head;
            if (unitsImportPrimal.retrieve(unit) == Boolean.TRUE) {
                this.unitsHavePrimal.store(unit, Boolean.TRUE);
            }
            inUnits = inUnits.tail;
        }
        if (traceDDDD) {
            inUnits = unitsRootSTLast;
            while (inUnits != null) {
                unit = (Unit)inUnits.head;
                TapEnv.printlnOnTrace(" DDDD Summary: " + unit + " must have Primal:" + this.unitsHavePrimal.retrieve(unit) + " must have Diff:" + this.unitsHaveDiff.retrieve(unit));
                inUnits = inUnits.tail;
            }
        }
    }

    private void setAllContainedHavePrimalRec(Unit unit, boolean trace, Unit containerUnit) {
        TapList<Unit> insideUnits = unit.lowerLevelUnits;
        while (insideUnits != null) {
            this.unitsHavePrimal.store((Unit)insideUnits.head, Boolean.TRUE);
            if (trace) {
                TapEnv.printlnOnTrace(" DDDD " + insideUnits.head + " must have Primal because it is contained in " + containerUnit + ", which must have Primal");
            }
            this.setAllContainedHavePrimalRec((Unit)insideUnits.head, trace, containerUnit);
            insideUnits = insideUnits.tail;
        }
    }

    private SymbolDecl symbolTableContainsActiveSymbolDecl(SymbolTable symbolTable) {
        boolean result = false;
        SymbolDecl symbolDecl = null;
        TapList<SymbolDecl> symbolDecls = symbolTable.getAllTopSymbolDecls();
        while (symbolDecls != null && !result) {
            Unit unit;
            symbolDecl = (SymbolDecl)symbolDecls.head;
            result = symbolDecl.isA(3) ? this.unitsHaveDiff.retrieve(unit = ((FunctionDecl)symbolDecl).unit()) == Boolean.TRUE : symbolDecl.isActive();
            symbolDecls = symbolDecls.tail;
        }
        return result ? symbolDecl : null;
    }

    private void updateCopiedUnits(boolean updateInterfaceUnits) {
        TapList<Unit> units = this.srcCallGraph.units();
        while (units != null) {
            this.setCurUnitEtc((Unit)units.head);
            Unit origUnitOfInterface = this.curUnit.getOrigUnitOfInterface(this.srcCallGraph);
            if ((!updateInterfaceUnits && !this.curUnit.isInterface() || updateInterfaceUnits && this.curUnit.isInterface()) && this.curUnit.functionTypeSpec() != null && (this.curUnit.isTopInFile() || this.curUnit.isInterface() && (origUnitOfInterface != null && origUnitOfInterface.importedModules() != null && origUnitOfInterface.isTopInFile() || this.curUnit.getUnitOfInterface() == this.curUnit && this.curUnit.importedModules() != null))) {
                Unit origCopyUnit = this.adEnv.copiedUnits.retrieve(this.curUnit);
                TapEnv.printlnOnTrace(40, "UPDATECOPIEDUNITS FOR " + this.curUnit + " COPIEDAS origCopyUnit:" + origCopyUnit);
                if (origCopyUnit != null) {
                    String oldUnitName = this.curUnit.name;
                    String newUnitName = origCopyUnit.name;
                    String oldUnitNameInOrig = null;
                    String newUnitNameInOrig = null;
                    if (oldUnitName.equals(newUnitName)) {
                        Unit diffTopUnit;
                        boolean origCopyUnitNameIsSet = false;
                        if (origUnitOfInterface != null && (origUnitOfInterface.isTopInFile() || origUnitOfInterface.importedModules() != null) && (diffTopUnit = this.adEnv.copiedUnits.retrieve(origUnitOfInterface)) != null) {
                            origCopyUnit.name = diffTopUnit.name;
                            origCopyUnitNameIsSet = true;
                        }
                        if (!origCopyUnitNameIsSet) {
                            Tree callTree = ILUtils.build(30, ILUtils.build(94, oldUnitName));
                            Tree newUnitNameTree = this.varRefDifferentiator().diffSymbolName(null, oldUnitName, origCopyUnit.publicSymbolTable(), false, true, false, callTree, null, false, 0, 0, 1, null);
                            NewSymbolHolder newSymbolHolder = NewSymbolHolder.getNewSymbolHolder(newUnitNameTree);
                            if (newSymbolHolder != null && newSymbolHolder.hasNewFunctionDecl()) {
                                newSymbolHolder.newFunctionDecl().setUnit(origCopyUnit);
                            }
                            for (SymbolTable upperSymbolTable = origCopyUnit.publicSymbolTable(); upperSymbolTable != null; upperSymbolTable = upperSymbolTable.basisSymbolTable()) {
                                upperSymbolTable.solveNewSymbolHolders(this.adEnv.emptyCopiedUnitSuffix);
                            }
                            origCopyUnit.name = newUnitName = ILUtils.getIdentString(newUnitNameTree);
                            this.curUnit.setOtherName(origCopyUnit);
                            origCopyUnit.setOtherName(this.curUnit);
                        }
                    }
                    if (origCopyUnit.isAFunction()) {
                        origCopyUnit.setOtherReturnVar(origCopyUnit.publicSymbolTable().getTopVariableDecl(this.curUnit.otherReturnVar() != null ? this.curUnit.otherReturnVar().symbol : oldUnitName));
                    }
                    TapList<CallArrow> arrows = this.curUnit.callers();
                    while (arrows != null) {
                        UnitDiffInfo origDiffInfo = this.getUnitDiffInfo(((CallArrow)arrows.head).origin);
                        TapList<Unit> diffUnits = origDiffInfo.getAllDiffsPlusCopy();
                        while (diffUnits != null) {
                            Unit callerUnit = (Unit)diffUnits.head;
                            this.updateAllUsages(callerUnit, oldUnitName, origCopyUnit);
                            if (!((CallArrow)arrows.head).origin().sameLanguage(((CallArrow)arrows.head).destination.language())) {
                                oldUnitNameInOrig = this.srcCallGraph.getOtherLanguageName(oldUnitName, ((CallArrow)arrows.head).destination().language(), ((CallArrow)arrows.head).origin().language());
                                newUnitNameInOrig = this.diffCallGraph.getOtherLanguageName(newUnitName, ((CallArrow)arrows.head).destination().language(), ((CallArrow)arrows.head).origin().language());
                                this.updateFunctionDeclName(origCopyUnit, oldUnitNameInOrig, newUnitNameInOrig, callerUnit.translationUnitSymbolTable());
                            } else {
                                this.updateFunctionDeclName(origCopyUnit, oldUnitName, newUnitName, callerUnit.translationUnitSymbolTable());
                            }
                            if (((CallArrow)arrows.head).isContain() && callerUnit.isModule()) {
                                this.updateAllAccessDecls(callerUnit.publicSymbolTable().declarationsBlock.instructions, oldUnitName, origCopyUnit);
                                this.updateAllAccessDecls(callerUnit.privateSymbolTable().declarationsBlock.instructions, oldUnitName, origCopyUnit);
                            }
                            diffUnits = diffUnits.tail;
                        }
                        arrows = arrows.tail;
                    }
                    this.updateAllUsagesInBlock(this.diffCallGraph.topBlock, oldUnitName, origCopyUnit, origCopyUnit.name);
                    TapList<SymbolTable> diffTUSTs = this.diffCallGraph.getTranslationUnitSymbolTables();
                    while (diffTUSTs != null) {
                        this.updateAllUsagesInBlock(((SymbolTable)diffTUSTs.head).declarationsBlock, oldUnitName, origCopyUnit, origCopyUnit.name);
                        if (oldUnitNameInOrig != null) {
                            this.updateAllUsagesInBlock(((SymbolTable)diffTUSTs.head).declarationsBlock, oldUnitNameInOrig, origCopyUnit, newUnitNameInOrig);
                        }
                        diffTUSTs = diffTUSTs.tail;
                    }
                    TapList<Unit> importedModules = this.curUnit.importedModules();
                    TapEnv.printlnOnTrace(40, "IMPORTEDMODULES of " + this.curUnit + " are " + importedModules);
                    while (importedModules != null) {
                        Unit importedModule = (Unit)importedModules.head;
                        Unit diffImportedModule = this.getUnitDiffInfo(importedModule).getDiff();
                        if (diffImportedModule != null) {
                            TapEnv.printlnOnTrace(40, "UPDATEALLUSAGES OF " + importedModule.name + " -> " + diffImportedModule + " IN " + origCopyUnit);
                            this.updateAllUsages(origCopyUnit, importedModule.name, diffImportedModule);
                        }
                        importedModules = importedModules.tail;
                    }
                    this.updateFunctionDeclName(origCopyUnit, oldUnitName, newUnitName, this.diffCallGraph.languageRootSymbolTable(this.curUnit.language()));
                    this.updateFunctionDeclName(origCopyUnit, oldUnitName, newUnitName, origCopyUnit.translationUnitSymbolTable());
                }
            }
            units = units.tail;
        }
        this.setCurUnitEtc(null);
    }

    private void updateFunctionDeclName(Unit origCopyUnit, String oldUnitName, String newUnitName, SymbolTable symbolTable) {
        if (symbolTable != null && oldUnitName != null) {
            SymbolDecl oldSymbolDecl;
            FunctionDecl funcDecl;
            TapList<FunctionDecl> funcDecls = symbolTable.getFunctionDecl(oldUnitName, null, null, false);
            FunctionDecl functionDecl = funcDecl = funcDecls == null ? null : (FunctionDecl)funcDecls.head;
            if (funcDecl != null && (oldSymbolDecl = symbolTable.getDecl(funcDecl.symbol, funcDecl.kind, true)) != null) {
                Tree treeName = ILUtils.build(94, newUnitName);
                FunctionDecl newFunDecl = new FunctionDecl(treeName, origCopyUnit);
                newFunDecl.setInstruction(oldSymbolDecl);
                symbolTable.removeDecl(funcDecl.symbol, funcDecl.kind, true);
                if (funcDecl.unit().enclosingUnitOfInterface != null) {
                    newFunDecl.unit().enclosingUnitOfInterface = funcDecl.unit().enclosingUnitOfInterface;
                }
                symbolTable.addSymbolDecl(newFunDecl);
            }
        }
    }

    private void differentiateAllocateInCopiedUnits() {
        TapList<Unit> units = this.srcCallGraph.units();
        while (units != null) {
            this.setCurUnitEtc((Unit)units.head);
            if (!this.curUnit.isOutside() && !this.curUnit.isInterface()) {
                this.setCurDiffUnit(this.adEnv.getPrimalCopyOfOrigUnit(this.curUnit));
                boolean needInitMultiDirMode = this.multiDirMode();
                if (this.curDiffUnit != null) {
                    TapList<Block> allBlocks = this.curDiffUnit.allBlocks();
                    while (allBlocks != null) {
                        TapList<Object> hdCopiedInstrs;
                        Block block = (Block)allBlocks.head;
                        TapList<Instruction> instructions = block.instructions;
                        TapList<Object> tlCopiedInstrs = hdCopiedInstrs = new TapList<Object>(null, null);
                        boolean modified = false;
                        while (instructions != null) {
                            Instruction diffInstr;
                            Tree diffVarTree;
                            Instruction instr = (Instruction)instructions.head;
                            Tree tree = instr.tree;
                            if (tree.opCode() == 13 && tree.down(2).opCode() == 4 && CallGraphDifferentiator.hasActiveGlobalVarDecl(ILUtils.baseName(tree.down(1)), block.symbolTable, this.curDiffUnit.publicSymbolTable().basisSymbolTable())) {
                                modified = true;
                                if (needInitMultiDirMode) {
                                    this.flowGraphDifferentiator().initializeMultiDirMode();
                                    needInitMultiDirMode = false;
                                }
                                diffVarTree = this.varRefDifferentiator().diffVarRef(null, tree.down(1), block.symbolTable, false, tree, this.multiDirMode(), true, null);
                                Tree diffRhs = this.varRefDifferentiator().diffVarRef(null, tree.down(2), block.symbolTable, false, tree, this.multiDirMode(), true, null);
                                diffInstr = new Instruction(ILUtils.build(13, diffVarTree, diffRhs));
                                tlCopiedInstrs = tlCopiedInstrs.placdl(diffInstr);
                            } else if (tree.opCode() == 51 && CallGraphDifferentiator.hasActiveGlobalVarDecl(ILUtils.baseName(tree.down(1)), block.symbolTable, this.curDiffUnit.publicSymbolTable().basisSymbolTable())) {
                                modified = true;
                                if (needInitMultiDirMode) {
                                    this.flowGraphDifferentiator().initializeMultiDirMode();
                                    needInitMultiDirMode = false;
                                }
                                diffVarTree = this.varRefDifferentiator().diffVarRef(null, tree.down(1), block.symbolTable, false, tree, this.multiDirMode(), true, null);
                                diffInstr = new Instruction(ILUtils.build(51, diffVarTree, ILUtils.copy(tree.down(2))));
                                tlCopiedInstrs = tlCopiedInstrs.placdl(diffInstr);
                            }
                            tlCopiedInstrs = tlCopiedInstrs.placdl(instr);
                            instructions = instructions.tail;
                        }
                        if (modified) {
                            block.instructions = hdCopiedInstrs.tail;
                        }
                        allBlocks = allBlocks.tail;
                    }
                }
            }
            units = units.tail;
        }
        this.setCurUnitEtc(null);
        this.setCurDiffUnit(null);
    }

    private static boolean hasActiveGlobalVarDecl(String name, SymbolTable localST, SymbolTable globalST) {
        VariableDecl varDecl = localST.getVariableDecl(name);
        if (varDecl == null || !varDecl.isActiveSymbolDecl()) {
            return false;
        }
        VariableDecl globalVarDecl = globalST.getVariableDecl(name);
        return varDecl == globalVarDecl;
    }

    private void updateCopiedInterfaceAndExternalDecls(Unit unit, TapList<SymbolDecl> functionDecls, boolean inPublicSymbolTable) {
        while (functionDecls != null) {
            boolean change;
            FunctionDecl functionDecl = (FunctionDecl)functionDecls.head;
            Unit copiedFunctionUnit = this.adEnv.copiedUnits.retrieve(functionDecl.unit());
            String copiedUnitName = functionDecl.unit().name;
            if (copiedFunctionUnit != null) {
                copiedUnitName = copiedFunctionUnit.name;
            }
            boolean bl = change = !copiedUnitName.equals(functionDecl.unit().name);
            if (change) {
                SymbolTable searchInSymbolTable = inPublicSymbolTable ? unit.publicSymbolTable() : unit.privateSymbolTable();
                if (!functionDecl.hasInterfaceInstruction() && functionDecl.isExternalDeclared(this.curDiffUnit.publicSymbolTable().declarationsBlock.instructions)) {
                    Instruction varDecl;
                    Instruction externalDecl = this.curDiffUnit.publicSymbolTable().declarationsBlock.getOperatorDeclarationInstruction(functionDecl, 72, searchInSymbolTable);
                    if (externalDecl != null) {
                        ILUtils.replaceAllIdentsNamed(externalDecl.tree, functionDecl.symbol, copiedUnitName);
                    }
                    if ((varDecl = this.curDiffUnit.publicSymbolTable().declarationsBlock.getOperatorDeclarationInstruction(functionDecl, 194, searchInSymbolTable)) != null) {
                        ILUtils.replaceAllIdentsNamed(varDecl.tree, functionDecl.symbol, copiedUnitName);
                        varDecl.isDifferentiated = true;
                    }
                }
                TapList<Block> blocks = this.curDiffUnit.allBlocks();
                while (blocks != null) {
                    Block block = (Block)blocks.head;
                    TapList<Instruction> instructions = block.instructions;
                    while (instructions != null) {
                        Instruction instruction = (Instruction)instructions.head;
                        ILUtils.replaceAllCallName(instruction.tree, functionDecl.symbol, copiedUnitName);
                        instructions = instructions.tail;
                    }
                    blocks = blocks.tail;
                }
            }
            functionDecls = functionDecls.tail;
        }
    }

    private void updateCopiedExternalDecls(TapList<SymbolDecl> functionDecls, SymbolTable srcSymbolTable, SymbolTable diffSymbolTable) {
        while (functionDecls != null) {
            boolean change;
            FunctionDecl functionDecl = (FunctionDecl)functionDecls.head;
            Unit copiedFunctionUnit = this.adEnv.copiedUnits.retrieve(functionDecl.unit());
            String copiedUnitName = functionDecl.unit().name;
            if (copiedFunctionUnit != null) {
                copiedUnitName = copiedFunctionUnit.name;
                if (functionDecl.unit().language() != 4) {
                    copiedUnitName = (String)this.diffCallGraph.getMixedLanguageFunctionName((String)copiedUnitName, (int)1, (int)4).first;
                }
            }
            boolean bl = change = !copiedUnitName.equals(functionDecl.unit().name);
            if (change && functionDecl.isExternalDeclared(srcSymbolTable.declarationsBlock.instructions)) {
                this.updateExternalDecl(functionDecl, srcSymbolTable, diffSymbolTable, copiedUnitName);
            }
            functionDecls = functionDecls.tail;
        }
    }

    private void updateExternalDecl(FunctionDecl functionDecl, SymbolTable srcSymbolTable, SymbolTable diffSymbolTable, String copiedUnitName) {
        Instruction externalDecl = diffSymbolTable.declarationsBlock.getOperatorDeclarationInstruction(functionDecl, 72, srcSymbolTable);
        if (externalDecl == null) {
            externalDecl = diffSymbolTable.declarationsBlock.getOperatorDeclarationInstruction(functionDecl, 194, srcSymbolTable);
        }
        if (externalDecl != null) {
            ILUtils.replaceAllIdentsNamed(externalDecl.tree, functionDecl.symbol, copiedUnitName);
        }
    }

    private void fillPassByValueInfos(TapList publicRanksTree, int argIndex, Unit unit, BoolVector unitPublicZonesUsed, BoolVector unitPublicZonesWritten, BoolVector unitPublicZonesWithDiff, boolean[] diffArgsByValueNeedOverwrite, boolean[] diffArgsByValueNeedOnlyIncrement) {
        block10: {
            if (publicRanksTree == null) break block10;
            if (publicRanksTree.head instanceof TapList) {
                while (publicRanksTree != null) {
                    this.fillPassByValueInfos((TapList)publicRanksTree.head, argIndex, unit, unitPublicZonesUsed, unitPublicZonesWritten, unitPublicZonesWithDiff, diffArgsByValueNeedOverwrite, diffArgsByValueNeedOnlyIncrement);
                    publicRanksTree = publicRanksTree.tail;
                }
            } else {
                TapIntList publicRanks = (TapIntList)publicRanksTree.head;
                while (publicRanks != null) {
                    int publicRank = publicRanks.head;
                    if (unitPublicZonesWithDiff.get(publicRank)) {
                        if (TypeSpec.isA(unit.paramElemZoneInfo((int)publicRank).type, 6)) {
                            if (argIndex == 0) {
                                diffArgsByValueNeedOverwrite[argIndex] = true;
                            }
                        } else {
                            if (unitPublicZonesUsed.get(publicRank)) {
                                diffArgsByValueNeedOverwrite[argIndex] = true;
                            }
                            if (unitPublicZonesWritten.get(publicRank)) {
                                diffArgsByValueNeedOnlyIncrement[argIndex] = false;
                            }
                        }
                    }
                    publicRanks = publicRanks.tail;
                }
            }
        }
    }

    private void createDiffUnits(Unit unit, ActivityPattern pattern) {
        Unit enclosingUnit = unit.upperLevelUnit();
        UnitDiffInfo unitDiffInfo = this.getUnitDiffInfo(unit);
        Unit diffEnclosingUnitOfTangent = null;
        Unit diffEnclosingUnitOfAdjoint = null;
        if (enclosingUnit != null) {
            UnitDiffInfo enclosingDiffInfo = this.getUnitDiffInfo(enclosingUnit);
            if (enclosingUnit.isPackage()) {
                diffEnclosingUnitOfAdjoint = diffEnclosingUnitOfTangent = enclosingDiffInfo.getDiff();
            } else if (enclosingUnit.specificInfoAD == null) {
                diffEnclosingUnitOfAdjoint = diffEnclosingUnitOfTangent = this.adEnv.getPrimalCopyOfOrigUnit(enclosingUnit);
            } else {
                ActivityPattern enclosingPattern = pattern.getCallingActivityPattern(enclosingUnit, new TapList<ActivityPattern>(pattern, null));
                if (TapEnv.mustTangent()) {
                    diffEnclosingUnitOfTangent = enclosingDiffInfo.getTangent(enclosingPattern);
                }
                if (TapEnv.mustAdjoint() && (diffEnclosingUnitOfAdjoint = enclosingDiffInfo.getAdjoint(enclosingPattern)) == null) {
                    diffEnclosingUnitOfAdjoint = enclosingDiffInfo.getSplitBackward(enclosingPattern);
                }
            }
        }
        if (TapEnv.mustTangent()) {
            this.initializeDiffUnit(this.diffCallGraph.createNewUnit(diffEnclosingUnitOfTangent, unit.language()), unit, -4);
            if (this.adEnv.traceCurDifferentiation || TapEnv.traceActivity() != null) {
                TapEnv.printlnOnTrace(" =Prepared tangent unit for " + unit + " for activity " + pattern + " => " + this.curDiffUnit + ", contained in " + this.curDiffUnit.upperLevelUnit());
            }
            unitDiffInfo.setTangent(pattern, this.curDiffUnit);
        }
        if (!unit.isModule() && TapEnv.mustAdjoint()) {
            if (unit.mustDifferentiateJoint() || !unit.mustDifferentiateSplit() || pattern.isContext()) {
                this.initializeDiffUnit(this.diffCallGraph.createNewUnit(diffEnclosingUnitOfAdjoint, unit.language()), unit, -3);
                if (this.adEnv.traceCurDifferentiation || TapEnv.traceActivity() != null) {
                    TapEnv.printlnOnTrace(" =Prepared" + (pattern.isContext() ? " context" : "") + " adjoint unit for " + unit + " => " + this.curDiffUnit + ", contained in " + this.curDiffUnit.upperLevelUnit());
                }
                unitDiffInfo.setAdjoint(pattern, this.curDiffUnit);
            }
            if (unit.mustDifferentiateSplit() && !pattern.isContext()) {
                this.initializeDiffUnit(this.diffCallGraph.createNewUnit(diffEnclosingUnitOfAdjoint, unit.language()), unit, -2);
                if (this.adEnv.traceCurDifferentiation || TapEnv.traceActivity() != null) {
                    TapEnv.printlnOnTrace(" =Prepared forward split adjoint unit for " + unit + " => " + this.curDiffUnit + ", contained in " + this.curDiffUnit.upperLevelUnit());
                }
                unitDiffInfo.setSplitForward(pattern, this.curDiffUnit);
                this.initializeDiffUnit(this.diffCallGraph.createNewUnit(diffEnclosingUnitOfAdjoint, unit.language()), unit, -1);
                if (this.adEnv.traceCurDifferentiation || TapEnv.traceActivity() != null) {
                    TapEnv.printlnOnTrace(" =Prepared backward split adjoint unit for " + unit + " => " + this.curDiffUnit + ", contained in " + this.curDiffUnit.upperLevelUnit());
                }
                unitDiffInfo.setSplitBackward(pattern, this.curDiffUnit);
            }
        }
    }

    private void initializeDiffUnit(Unit createdDiffUnit, Unit unit, int orderOffset) {
        this.setCurDiffUnit(createdDiffUnit);
        this.curDiffUnit.setKind(unit);
        this.curDiffUnit.origUnit = unit;
        int n = this.curDiffUnit.arrayDimMin = unit.isFortran() ? 1 : 0;
        if (unit == this.srcCallGraph.getMainUnit()) {
            this.diffCallGraph.setMainUnit(this.curDiffUnit);
        }
        this.curDiffUnit.userHelp = new TapList<Object>(null, unit.userHelp.tail);
        this.curDiffUnit.formats = unit.formats;
        if (unit.isCalledFromOtherLanguage()) {
            this.curDiffUnit.setCalledFromOtherLanguage();
        }
        if (ILUtils.isNullOrEmptyList(unit.modifiers)) {
            this.curDiffUnit.modifiers = ILUtils.copy(unit.modifiers);
        } else if (unit.modifiers.opCode() == 1) {
            this.curDiffUnit.modifiers = ILUtils.copy(unit.modifiers);
            this.diffCallGraph.addBindFortranCDiffUnit(this.curDiffUnit);
        } else {
            Tree[] origModifiers = unit.modifiers.children();
            TapList<Tree> newModifiers = null;
            for (int i = origModifiers.length - 1; i >= 0; --i) {
                if (origModifiers[i] == null || ILUtils.getIdentString(origModifiers[i]).equals("pure")) continue;
                newModifiers = new TapList<Tree>(ILUtils.copy(origModifiers[i]), newModifiers);
            }
            this.curDiffUnit.modifiers = ILUtils.build(128, newModifiers);
        }
        this.curDiffUnit.setLanguage(unit.language());
        this.curDiffUnit.setLostComments(unit.lostComments());
        this.curDiffUnit.position = unit.getPosition() + orderOffset;
        this.curDiffUnit.preComments = unit.preComments == null ? null : unit.preComments.copy();
        this.curDiffUnit.postComments = unit.postComments == null ? null : unit.postComments.copy();
        this.curDiffUnit.preCommentsBlock = unit.preCommentsBlock == null ? null : unit.preCommentsBlock.copy();
        Tree tree = this.curDiffUnit.postCommentsBlock = unit.postCommentsBlock == null ? null : unit.postCommentsBlock.copy();
        if (unit.isInterface()) {
            this.curDiffUnit.setEntryBlock(new EntryBlock(null));
            this.curDiffUnit.setExitBlock(new ExitBlock(null));
        }
        if (unit.hasArrayNotation()) {
            this.curDiffUnit.setHasArrayNotation();
        }
    }

    private boolean patternCreatesDiffCode(ActivityPattern activityPattern, Unit srcUnit) {
        return !activityPattern.isDontDiff() && !MPIcallInfo.isMessagePassingFunction(srcUnit.name, srcUnit.language()) && (CallGraphDifferentiator.isOrContainsActingPattern(srcUnit, activityPattern, this.activityAnalyzer(), TapEnv.reqExplicitAnalyzer()) || TapEnv.mustContext() && TapList.contains(this.adEnv.rootUnits, srcUnit) || activityPattern.isContext() && TapList.contains(this.adEnv.callersOfRootUnits, srcUnit));
    }

    private static boolean isOrContainsActingPattern(Unit unit, ActivityPattern activityPattern, ADActivityAnalyzer activityAnalyzer, ReqExplicit reqExplicitAnalyzer) {
        boolean active = CallGraphDifferentiator.isActingPattern(activityPattern, activityAnalyzer, reqExplicitAnalyzer);
        if (!active) {
            TapList<Unit> containedUnits = unit.collectContainedUnits(null);
            while (!active && containedUnits != null) {
                Unit containedUnit = (Unit)containedUnits.head;
                TapList<ActivityPattern> containedUnitActivityPatterns = containedUnit.specificInfoAD;
                while (!active && containedUnitActivityPatterns != null) {
                    ActivityPattern containedUnitActivityPattern = (ActivityPattern)containedUnitActivityPatterns.head;
                    if (CallGraphDifferentiator.isActingPattern(containedUnitActivityPattern, activityAnalyzer, reqExplicitAnalyzer) && (activityPattern.isDisconnected() || containedUnitActivityPattern.isCalledBy(unit, activityPattern, new TapList<ActivityPattern>(containedUnitActivityPattern, null)))) {
                        active = true;
                    }
                    containedUnitActivityPatterns = containedUnitActivityPatterns.tail;
                }
                containedUnits = containedUnits.tail;
            }
        }
        return active;
    }

    private static boolean isActingPattern(ActivityPattern activity, ADActivityAnalyzer activityAnalyzer, ReqExplicit reqExplicitAnalyzer) {
        boolean isActing = false;
        if (activity != null) {
            isActing = activityAnalyzer.isActiveUnit(activity) || reqExplicitAnalyzer != null && reqExplicitAnalyzer.isPointerActiveUnit(activity);
        }
        return isActing;
    }

    private void createDiffUnitSymbolTables(TapList<TapPair<SymbolTable, SymbolTable>> contextAssociationsST) {
        if (this.curUnit.isStandard() || this.curUnit.isPackage() || this.curUnit.isInterface() || this.curUnit.isExternal() || this.curUnit.isVarFunction() && this.curUnit.publicSymbolTable() != null) {
            TapList<TapPair<SymbolTable, SymbolTable>> localAssociationsST = contextAssociationsST;
            if (!this.curUnit.isPackage()) {
                localAssociationsST = this.buildLocalAssociationsST(contextAssociationsST);
            }
            SymbolTable diffPublicSymbolTable = null;
            if (this.curUnit.publicSymbolTable() != null) {
                diffPublicSymbolTable = this.curUnit.publicSymbolTable().smartCopy(localAssociationsST, this.curDiffUnit, this.diffCallGraph, this.adEnv.copiedUnits);
                if (this.curUnit.isProcedure() || this.curUnit.isVarFunction()) {
                    diffPublicSymbolTable.declareFormalParamsLevel();
                }
                this.curDiffUnit.setPublicSymbolTable(diffPublicSymbolTable);
                CallGraphDifferentiator.declareDiffSymbolTableIfNew(this.curDiffUnit, diffPublicSymbolTable);
            }
            if (this.curUnit.privateSymbolTable() != null) {
                SymbolTable diffPrivateSymbolTable = this.curUnit.privateSymbolTable().smartCopy(localAssociationsST, this.curDiffUnit, this.diffCallGraph, this.adEnv.copiedUnits);
                this.curDiffUnit.setPrivateSymbolTable(diffPrivateSymbolTable);
                CallGraphDifferentiator.declareDiffSymbolTableIfNew(this.curDiffUnit, diffPrivateSymbolTable);
                diffPrivateSymbolTable.saveList = this.curUnit.privateSymbolTable().saveList;
                diffPrivateSymbolTable.nameListList = this.curUnit.privateSymbolTable().nameListList;
            }
            if (this.curDiffUnit.entryBlock() != null) {
                this.curDiffUnit.entryBlock().symbolTable = diffPublicSymbolTable;
            }
            if (this.curDiffUnit.exitBlock() != null) {
                this.curDiffUnit.exitBlock().symbolTable = diffPublicSymbolTable;
            }
            if (this.curUnit.isStandard() || this.curUnit.isInterface() || this.curUnit.isPackage()) {
                TapList<Block> copyBodyBlocks = this.curDiffUnit.allBlocks();
                while (copyBodyBlocks != null) {
                    Block copyBodyBlock = (Block)copyBodyBlocks.head;
                    copyBodyBlock.symbolTable = copyBodyBlock.symbolTable.smartCopy(localAssociationsST, this.curDiffUnit, this.diffCallGraph, this.adEnv.copiedUnits);
                    CallGraphDifferentiator.declareDiffSymbolTableIfNew(this.curDiffUnit, copyBodyBlock.symbolTable);
                    copyBodyBlocks = copyBodyBlocks.tail;
                }
            }
            TapList<SymbolTable> newDiffSymbolTablesTopDown = TapList.reverse(this.curDiffUnit.symbolTablesBottomUp());
            while (newDiffSymbolTablesTopDown != null) {
                SymbolTable newDiffSymbolTable = (SymbolTable)newDiffSymbolTablesTopDown.head;
                if (newDiffSymbolTable.declarationsBlock != null) {
                    newDiffSymbolTable.declarationsBlock.symbolTable = newDiffSymbolTable;
                }
                newDiffSymbolTablesTopDown = newDiffSymbolTablesTopDown.tail;
            }
        }
    }

    private TapList<TapPair<SymbolTable, SymbolTable>> buildLocalAssociationsST(TapList<TapPair<SymbolTable, SymbolTable>> contextAssociationsST) {
        SymbolTable origContextST;
        TapList<Object> localAssociationsST = new TapList<Object>(null, null);
        for (origContextST = this.curUnit.externalSymbolTable(); origContextST != null && origContextST.usedModule != null; origContextST = origContextST.basisSymbolTable()) {
            Unit diffUsedModule = this.getUnitDiffInfo(origContextST.usedModule).getDiff();
            localAssociationsST.placdl(new TapPair<SymbolTable, SymbolTable>(origContextST.usedModule.publicSymbolTable(), diffUsedModule.publicSymbolTable()));
        }
        Unit diffContextUnit = this.curDiffUnit.upperLevelUnit();
        SymbolTable differentiatedContextST = diffContextUnit != null ? diffContextUnit.bodySymbolTable() : (origContextST == this.curUnit.translationUnitSymbolTable() ? this.curUnit.translationUnitSymbolTable().getExistingCopy(contextAssociationsST) : this.diffCallGraph.languageRootSymbolTable(this.curUnit.language()));
        localAssociationsST.placdl(new TapPair<SymbolTable, SymbolTable>(origContextST, differentiatedContextST));
        return localAssociationsST;
    }

    private static void solveNewSymbolHoldersOfCallGraphTop(CallGraph diffCallGraph, boolean emptyCopiedUnitSuffix) {
        TapEnv.printlnOnTrace(40, "SOLVE NSHs OF CG TOPs");
        TapList<SymbolTable> tuSTs = diffCallGraph.getTranslationUnitSymbolTables();
        while (tuSTs != null) {
            ((SymbolTable)tuSTs.head).solveNewSymbolHolders(emptyCopiedUnitSuffix);
            tuSTs = tuSTs.tail;
        }
        diffCallGraph.cRootSymbolTable().solveNewSymbolHolders(emptyCopiedUnitSuffix);
        diffCallGraph.fortranRootSymbolTable().solveNewSymbolHolders(emptyCopiedUnitSuffix);
        diffCallGraph.globalRootSymbolTable().solveNewSymbolHolders(emptyCopiedUnitSuffix);
        if (TapEnv.associationByAddress()) {
            diffCallGraph.globalRootSymbolTable().solveNewSymbolHolders(emptyCopiedUnitSuffix);
        }
    }

    private static void solveNewSymbolHoldersOfUnits(TapList<Unit> units, boolean emptyCopiedUnitSuffix) {
        while (units != null) {
            if (((Unit)units.head).isTranslationUnit()) {
                CallGraphDifferentiator.solveNewSymbolHoldersOfUnits(((Unit)units.head).lowerLevelUnits, emptyCopiedUnitSuffix);
            }
            CallGraphDifferentiator.solveNewSymbolHoldersOfUnit((Unit)units.head, emptyCopiedUnitSuffix);
            units = units.tail;
        }
    }

    protected static void solveNewSymbolHoldersOfUnit(Unit unit, boolean emptyCopiedUnitSuffix) {
        TapEnv.printlnOnTrace(999, "SOLVE NSHs OF UNIT:" + unit);
        boolean dirNumberMaxSymbolHolderIsUsed = unit.dirNumberMaxSymbolHolder != null && unit.dirNumberMaxSymbolHolder.isUsed();
        TapList<SymbolTable> listST = unit.symbolTablesBottomUp();
        while (listST != null) {
            ((SymbolTable)listST.head).solveNewSymbolHolders(emptyCopiedUnitSuffix);
            listST = listST.tail;
        }
        if (unit.publicSymbolTable() != null) {
            for (SymbolTable importedST = unit.publicSymbolTable().basisSymbolTable(); importedST != null && importedST.usedModule != null; importedST = importedST.basisSymbolTable()) {
                importedST.solveNewSymbolHolders(emptyCopiedUnitSuffix);
            }
        }
        if (dirNumberMaxSymbolHolderIsUsed) {
            unit.dirNumberMaxSymbolHolder.solve(unit.publicSymbolTable(), emptyCopiedUnitSuffix);
            String nbDirsMaxVarName = unit.dirNumberMaxSymbolHolder.finalName();
            if (unit.isFortran() != unit.isTranslationUnit()) {
                TapEnv.pushRelatedUnit(unit);
                TapEnv.fileWarning(15, null, "(AD10) User help requested: constant " + nbDirsMaxVarName + " must hold the maximum number of differentiation directions");
                TapEnv.popRelatedUnit();
                String msg = "the maximum number of differentiation directions";
                unit.userHelp.placdl(new TapPair<String, String>(msg, nbDirsMaxVarName));
            }
        }
    }

    private void computeCommonActivities(ActivityPattern activity) {
        BoolVector diffFormalRequired;
        Unit unit = activity.unit();
        if (unit.hasParamElemsInfo() && (diffFormalRequired = ADActivityAnalyzer.functionDiffFormalRequired(activity, this.adEnv.diffKind, true)) != null) {
            for (int i = unit.paramElemsNb() - 1; i >= 0; --i) {
                ZoneInfo zoneInfo = unit.paramElemZoneInfo(i);
                if (zoneInfo == null || zoneInfo.kind() != 11 || !diffFormalRequired.get(i)) continue;
                this.adEnv.commonActivityMemoryMap.getSetCommon(zoneInfo.commonName);
                TapList<AlignmentBoundary> activeBoundaries = this.adEnv.commonActivityMemoryMap.addCommonInterval(zoneInfo.commonName, zoneInfo.startOffset, zoneInfo.endOffset, zoneInfo.infiniteEndOffset, new WrapperTypeSpec(null));
                while (activeBoundaries != null) {
                    ((AlignmentBoundary)activeBoundaries.head).setActive();
                    activeBoundaries = activeBoundaries.tail;
                }
                TapList<String> varNames = zoneInfo.variableNames();
                while (varNames != null) {
                    SymbolDecl varDecl = null;
                    if (unit.privateSymbolTable() != null) {
                        varDecl = unit.privateSymbolTable().getVariableDecl((String)varNames.head);
                    }
                    if (varDecl != null) {
                        varDecl.setActive();
                    }
                    varNames = varNames.tail;
                }
            }
        }
    }

    private void computeModuleCommonActivities(Unit unit) {
        TapList<Int2ZoneInfo> zoneInfos = unit.publicSymbolTable().getAdditionalDuplicatedDeclaredZoneInfos()[0];
        while (zoneInfos != null) {
            Int2ZoneInfo iZoneInfo = (Int2ZoneInfo)zoneInfos.head;
            ZoneInfo zoneInfo = iZoneInfo.getZoneInfo();
            if (zoneInfo != null && zoneInfo.kind() == 13 && zoneInfo.commonName != null) {
                this.adEnv.commonActivityMemoryMap.getSetCommon(zoneInfo.commonName);
                TapList<AlignmentBoundary> activeBoundaries = this.adEnv.commonActivityMemoryMap.addCommonInterval(zoneInfo.commonName, zoneInfo.startOffset, zoneInfo.endOffset, zoneInfo.infiniteEndOffset, new WrapperTypeSpec(null));
                while (activeBoundaries != null) {
                    ((AlignmentBoundary)activeBoundaries.head).setActive();
                    activeBoundaries = activeBoundaries.tail;
                }
                TapList<String> varNames = zoneInfo.variableNames();
                while (varNames != null) {
                    SymbolDecl varDecl = null;
                    if (unit.privateSymbolTable() != null) {
                        varDecl = unit.privateSymbolTable().getVariableDecl((String)varNames.head);
                    }
                    if (varDecl != null) {
                        varDecl.setActive();
                    }
                    varNames = varNames.tail;
                }
            }
            zoneInfos = zoneInfos.tail;
        }
    }

    private FunctionTypeSpec differentiateFunctionTypeSpec(ActivityPattern pattern, SymbolTable diffUnitST, int mode) {
        WrapperTypeSpec diffReturnType;
        Unit origUnit = pattern.unit();
        UnitDiffInfo unitDiffInfo = this.getUnitDiffInfo(origUnit);
        FunctionTypeSpec functionTypeSpec = origUnit.functionTypeSpec();
        WrapperTypeSpec[] paramsTypes = functionTypeSpec.argumentsTypes;
        if (paramsTypes == null) {
            return new FunctionTypeSpec(new WrapperTypeSpec(new VoidTypeSpec()), new WrapperTypeSpec[0]);
        }
        WrapperTypeSpec returnType = functionTypeSpec.returnType;
        boolean[] formalArgsActivity = unitDiffInfo.getUnitFormalArgsActivityS(pattern);
        boolean[] formalArgsPointerActivity = ReqExplicit.formalArgsPointerActivity(pattern, paramsTypes.length);
        boolean[] diffArgsByValueNeedOverwrite = null;
        if (mode == 2 || mode == 4) {
            diffArgsByValueNeedOverwrite = unitDiffInfo.getUnitDiffArgsByValueNeedOverwriteInfoS(pattern);
        }
        TapList<WrapperTypeSpec> diffArgTypes = null;
        if (this.multiDirMode()) {
            diffArgTypes = new TapList<WrapperTypeSpec>(new WrapperTypeSpec(new PrimitiveTypeSpec("integer")), diffArgTypes);
        }
        if (!WrapperTypeSpec.isNullOrVoid(returnType) && (formalArgsActivity == null || formalArgsActivity[paramsTypes.length] || formalArgsPointerActivity[paramsTypes.length])) {
            diffReturnType = returnType.checkDiffTypeSpec(diffUnitST, origUnit.publicSymbolTable(), this.curDiffUnitSort(), this.suffixes()[1][3], false, this.multiDirMode(), this.varRefDifferentiator().getMultiDirDimensionMax(), null, origUnit.name + "'s result", origUnit.name + "_res", null, null);
            if (diffReturnType == null) {
                diffReturnType = returnType;
            } else if (mode == 2 && pattern.isContext()) {
                diffReturnType = returnType;
            } else if (diffReturnType.equalsCompilDep(returnType)) {
                diffReturnType = returnType;
            }
            if (WrapperTypeSpec.isNullOrVoid(diffReturnType)) {
                diffReturnType = new WrapperTypeSpec(new VoidTypeSpec());
            } else if (!(pattern.isContext() || !this.multiDirMode() && mode != 2 && mode != 4 && this.varRefDifferentiator().diffFunctionIsFunction(origUnit))) {
                if (mode != 2 && mode != 4 && origUnit.passesByValue(-1, this.curUnit.language())) {
                    diffReturnType = new WrapperTypeSpec(new PointerTypeSpec(diffReturnType, null));
                }
                diffArgTypes = new TapList<WrapperTypeSpec>(diffReturnType, diffArgTypes);
                diffReturnType = new WrapperTypeSpec(new VoidTypeSpec());
            }
        } else {
            diffReturnType = pattern.isContext() ? returnType : new WrapperTypeSpec(new VoidTypeSpec());
        }
        if (mode != 2 && mode != 4 && !WrapperTypeSpec.isNullOrVoid(returnType) && !TapEnv.associationByAddress()) {
            if (origUnit.passesByValue(-1, this.curUnit.language())) {
                returnType = new WrapperTypeSpec(new PointerTypeSpec(returnType, null));
            }
            diffArgTypes = new TapList<WrapperTypeSpec>(returnType, diffArgTypes);
        }
        if (formalArgsActivity != null) {
            for (int i = paramsTypes.length - 1; i >= 0; --i) {
                WrapperTypeSpec paramType = paramsTypes[i];
                if (formalArgsActivity[i] || formalArgsPointerActivity[i]) {
                    WrapperTypeSpec diffParamType = paramType.checkDiffTypeSpec(diffUnitST, origUnit.publicSymbolTable(), this.curDiffUnitSort(), this.suffixes()[1][3], false, this.multiDirMode(), this.varRefDifferentiator().getMultiDirDimensionMax(), null, origUnit.name + "'s arg" + (i + 1), origUnit.name + "_arg" + (i + 1), null, null);
                    if (diffParamType == null) {
                        diffParamType = paramType;
                    } else if (diffParamType.equalsLiterally(paramType)) {
                        diffParamType = paramType;
                    }
                    if (this.multiDirMode() && !TypeSpec.isA(diffParamType, 3) && (mode == 2 || mode == 4) && diffArgsByValueNeedOverwrite[i + 1] && origUnit.passesByValue(i + 1, this.curUnit.language())) {
                        diffParamType = new WrapperTypeSpec(new PointerTypeSpec(diffParamType, null));
                    }
                    diffArgTypes = new TapList<WrapperTypeSpec>(diffParamType, diffArgTypes);
                }
                if (TapEnv.associationByAddress() && (formalArgsActivity[i] || formalArgsPointerActivity[i])) continue;
                diffArgTypes = new TapList<WrapperTypeSpec>(paramType, diffArgTypes);
            }
        }
        return new FunctionTypeSpec(diffReturnType, diffArgTypes);
    }

    private void differentiateExternalUnit(ActivityPattern activity) {
        TapList<FunctionDecl> origFuncDecls;
        FunctionDecl origFuncDecl;
        FunctionDecl diffFuncDecl;
        String unitName = this.curUnit.name;
        Tree functionNameTree = ILUtils.build(94, unitName);
        TapList<FunctionDecl> diffFuncDecls = this.diffCallGraph.languageRootSymbolTable(this.curUnit.language()).getFunctionDecl(unitName, null, null, false);
        FunctionDecl functionDecl = diffFuncDecl = diffFuncDecls == null ? null : (FunctionDecl)diffFuncDecls.head;
        if (diffFuncDecl == null) {
            diffFuncDecl = new FunctionDecl(functionNameTree, this.curUnit);
            this.diffCallGraph.languageRootSymbolTable(this.curUnit.language()).addSymbolDecl(diffFuncDecl);
        }
        FunctionDecl functionDecl2 = origFuncDecl = (origFuncDecls = this.srcCallGraph.languageRootSymbolTable(this.curUnit.language()).getFunctionDecl(unitName, null, null, false)) == null ? null : (FunctionDecl)origFuncDecls.head;
        if (origFuncDecl != null) {
            diffFuncDecl.setInstruction(origFuncDecl);
        } else {
            diffFuncDecl.setExternalInstr(true);
        }
        UnitDiffInfo unitDiffInfo = this.getUnitDiffInfo(this.curUnit);
        for (int mode = 4; mode > 0; --mode) {
            Unit oneDiffUnit = unitDiffInfo.getDiffForModeAndActivity(mode, activity);
            if (oneDiffUnit == null) continue;
            this.setCurDiffUnit(oneDiffUnit);
            this.curDiffUnit.setExternal();
            this.flowGraphDifferentiator().initializeMultiDirMode();
            FunctionTypeSpec diffFunctionTypeSpec = this.differentiateFunctionTypeSpec(activity, this.curDiffUnit.publicSymbolTable(), mode);
            this.curDiffUnit.setFunctionTypeSpec(diffFunctionTypeSpec);
        }
    }

    private void differentiateVarFunctionUnit(ActivityPattern activity) {
        Unit sourceUnit = activity.unit();
        UnitDiffInfo sourceDiffInfo = this.getUnitDiffInfo(sourceUnit);
        TapList<Unit> diffUnits = sourceDiffInfo.getAllDiffs(activity);
        while (diffUnits != null) {
            this.setCurDiffUnit((Unit)diffUnits.head);
            this.curDiffUnit.setVarFunction();
            this.flowGraphDifferentiator().initializeMultiDirMode();
            if (this.curDiffUnit == sourceDiffInfo.getAdjoint(activity)) {
                this.curDiffUnit.functionTypeSpec().returnType = new WrapperTypeSpec(new VoidTypeSpec());
            }
            diffUnits = diffUnits.tail;
        }
    }

    private void differentiatePackage(Unit sourceUnit, TapList<TapPair<SymbolTable, SymbolTable>> rootAssociationsST) {
        this.setCurDiffUnit(this.getUnitDiffInfo(sourceUnit).getDiff());
        if (this.curDiffUnit.isDiffPackage().booleanValue()) {
            String sourceName = sourceUnit.name;
            this.unitDiffTimer.reset();
            if (sourceUnit.isFortran() && sourceUnit.isModule()) {
                TapEnv.printOnTrace(10, "@@ Differentiation of module: " + sourceName);
            } else {
                TapEnv.printOnTrace(10, "@@ Differentiation of package: " + sourceName);
            }
            this.flowGraphDifferentiator().initializeMultiDirMode();
            int sort = TapEnv.mustTangent() ? 1 : (TapEnv.mustAdjoint() ? 2 : 0);
            this.adEnv.setCurDiffSorts(sort, sort);
            if (sourceUnit.isTranslationUnit()) {
                this.curDiffUnit.name = sourceName;
            } else {
                this.curDiffUnit.parametersOrModuleNameTree = this.varRefDifferentiator().diffSymbolName(null, sourceName, this.curDiffUnit.publicSymbolTable(), false, false, true, null, null, true, 1, 1, 2, null);
                this.curDiffUnit.publicSymbolTable().saveList = sourceUnit.publicSymbolTable().saveList;
                this.flowGraphDifferentiator().diffMemoryMap(sourceUnit, this.curDiffUnit);
                this.flowGraphDifferentiator().differentiateSaveList(this.curDiffUnit.privateSymbolTable());
                this.flowGraphDifferentiator().differentiateSaveList(this.curDiffUnit.protectedSymbolTable());
                this.flowGraphDifferentiator().differentiateSaveList(this.curDiffUnit.publicSymbolTable());
            }
            TapList<Block> diffBlocks = this.curDiffUnit.allBlocks();
            while (diffBlocks != null) {
                Block diffBlock = (Block)diffBlocks.head;
                if (this.adEnv.traceCurDifferentiation) {
                    TapEnv.printlnOnTrace("----------- Differentiation of " + sourceName + " package's Block: " + diffBlock.instructions);
                }
                SymbolTable diffST = diffBlock.symbolTable;
                SymbolTable origST = diffST.getExistingOrig(rootAssociationsST);
                this.blockDifferentiator().differentiateDeclarationsOfBlock(diffBlock, this.curDiffUnitSort() == 1 ? 1 : -1, sourceUnit, origST, diffST, sourceUnit.language(), false);
                diffBlocks = diffBlocks.tail;
            }
            CallGraphDifferentiator.solveNewSymbolHoldersOfUnit(this.curDiffUnit, this.adEnv.emptyCopiedUnitSuffix);
            TapEnv.printlnOnTrace(10, ", time " + this.unitDiffTimer.elapsed() + " s");
        } else {
            TapEnv.printlnOnTrace(10, "@@ " + (sourceUnit.isClass() ? "Class " : (sourceUnit.isModule() ? "Module " : "File ")) + sourceUnit.name + " not differentiated");
            this.diffCallGraph.deleteUnit(this.curDiffUnit);
        }
    }

    private void differentiateInterface() {
        String unitName = this.curUnit.name;
        TapEnv.printlnOnTrace(10, "@@ Differentiation of interface: " + unitName);
        Tree origCallTree = this.curUnit.headTree();
        for (int mode = 4; mode > 0; --mode) {
            int dSort = mode == 1 ? 1 : 2;
            this.adEnv.setCurDiffSorts(dSort, dSort);
            TapList<ActivityPattern> activityPatterns = this.curUnit.specificInfoAD;
            while (activityPatterns != null) {
                ActivityPattern pattern = (ActivityPattern)activityPatterns.head;
                this.setCurDiffUnit(this.adEnv.getDiffOfUnit(this.curUnit, pattern, mode));
                if (this.curDiffUnit != null) {
                    VariableDecl returnVarNameDecl;
                    this.curDiffUnit.setInterface();
                    this.flowGraphDifferentiator().initializeMultiDirMode();
                    SymbolTable diffPublicSymbolTable = this.curDiffUnit.publicSymbolTable();
                    Tree diffCallTree = this.procedureCallDifferentiator().differentiateProcedureHeader(origCallTree, null, null, this.curDiffUnit.publicSymbolTable(), this.curUnit.publicSymbolTable(), mode, null);
                    Instruction diffInstruction = new Instruction(diffCallTree);
                    diffInstruction.setPosition(this.curUnit.entryBlock().headInstr());
                    this.curDiffUnit.entryBlock().addInstrTl(diffInstruction);
                    this.curDiffUnit.parametersOrModuleNameTree = ILUtils.getArguments(diffCallTree);
                    this.flowGraphDifferentiator().diffMemoryMap(this.curUnit, this.curDiffUnit);
                    if (mode == 2 && this.curUnit.isAFunction() && !this.curUnit.isAContext()) {
                        this.curDiffUnit.functionTypeSpec().returnType = new WrapperTypeSpec(new VoidTypeSpec());
                    }
                    if (!this.multiDirMode() && (returnVarNameDecl = diffPublicSymbolTable.getTopVariableDecl(this.curUnit.name)) == null && this.curUnit.otherReturnVar() != null) {
                        String otherReturnVarName = this.curUnit.otherReturnVar().symbol;
                        returnVarNameDecl = diffPublicSymbolTable.getTopVariableDecl(otherReturnVarName);
                        this.flowGraphDifferentiator().declareDiffIsReturnVar(returnVarNameDecl, this.curUnit, this.curDiffUnit);
                    }
                    Block diffBlock0 = diffPublicSymbolTable.declarationsBlock;
                    diffBlock0.rank = 0;
                    this.curDiffUnit.addBlock(diffBlock0);
                    BasicBlock tmpBlock = new BasicBlock(null, null, null);
                    tmpBlock.copyInstructions((Block)this.curUnit.allBlocks().head, this.adEnv.copiedIncludes);
                    diffBlock0.addInstrDeclTl(tmpBlock.instructions);
                    if (this.curUnit.publicSymbolTable().declarationsBlock.instructions != null) {
                        tmpBlock = new BasicBlock(null, null, null);
                        tmpBlock.copyInstructions(this.curUnit.publicSymbolTable().declarationsBlock, this.adEnv.copiedIncludes);
                        diffBlock0.addInstrDeclTl(tmpBlock.instructions);
                    }
                    this.blockDifferentiator().differentiateDeclarationsOfBlock(diffBlock0, this.curDiffUnitSort() == 1 ? 1 : -1, this.curUnit, this.curUnit.publicSymbolTable(), this.curDiffUnit.privateSymbolTable(), this.curUnit.language(), false);
                    new FGArrow((Block)this.curDiffUnit.entryBlock(), 0, null, (Block)this.curDiffUnit.allBlocks().head, false);
                }
                activityPatterns = activityPatterns.tail;
            }
        }
    }

    protected void collectDiffSubUnits(Unit srcSubUnit, int differentiationMode, TapList<Unit> toDiffSubUnitsFwd, TapList<Unit> toDiffSubUnitsBwd) {
        Unit copySubUnit;
        if (this.adEnv.curUnitIsContext) {
            toDiffSubUnitsBwd = toDiffSubUnitsFwd;
        }
        UnitDiffInfo subUnitDiffInfo = this.getUnitDiffInfo(srcSubUnit);
        Unit unit = copySubUnit = this.unitsHavePrimal.retrieve(srcSubUnit) == Boolean.TRUE ? this.adEnv.getPrimalCopyOfOrigUnit(srcSubUnit) : null;
        if (differentiationMode == 1) {
            toDiffSubUnitsFwd.tail = TapList.union(toDiffSubUnitsFwd.tail, subUnitDiffInfo.getAllDiffs(1));
            if (copySubUnit != null) {
                toDiffSubUnitsFwd.tail = TapList.addLast(toDiffSubUnitsFwd.tail, copySubUnit);
            }
        } else if (differentiationMode == -1) {
            toDiffSubUnitsBwd.tail = TapList.union(toDiffSubUnitsBwd.tail, subUnitDiffInfo.getAllDiffs(2));
            toDiffSubUnitsBwd.tail = TapList.union(toDiffSubUnitsBwd.tail, subUnitDiffInfo.getAllDiffs(3));
            toDiffSubUnitsBwd.tail = TapList.union(toDiffSubUnitsBwd.tail, subUnitDiffInfo.getAllDiffs(4));
            if (copySubUnit != null) {
                toDiffSubUnitsBwd.tail = TapList.addLast(toDiffSubUnitsBwd.tail, copySubUnit);
            }
        } else if (differentiationMode == -2) {
            toDiffSubUnitsFwd.tail = TapList.union(toDiffSubUnitsFwd.tail, subUnitDiffInfo.getAllDiffs(3));
            if (copySubUnit != null) {
                toDiffSubUnitsFwd.tail = TapList.addLast(toDiffSubUnitsFwd.tail, copySubUnit);
            }
            toDiffSubUnitsBwd.tail = TapList.union(toDiffSubUnitsBwd.tail, subUnitDiffInfo.getAllDiffs(2));
            toDiffSubUnitsBwd.tail = TapList.union(toDiffSubUnitsBwd.tail, subUnitDiffInfo.getAllDiffs(4));
        }
    }

    private void initializeMultiDirNumberMax(SymbolTable diffRootST) {
        int arrayDimMin;
        int n = arrayDimMin = TapEnv.relatedLanguageIsC() ? 0 : 1;
        if (TapEnv.get().nbdirsmaxString != null) {
            this.varRefDifferentiator().multiDirDimensionMax = new ArrayDim(ILUtils.buildDimColon(arrayDimMin, ILUtils.build(94, TapEnv.get().nbdirsmaxString)), null, null, null, -1, 0, 0);
        } else if (this.varRefDifferentiator().dirNumberMaxSymbolHolder == null) {
            this.varRefDifferentiator().dirNumberMaxSymbolHolder = new NewSymbolHolder("NBDirsMax");
            this.varRefDifferentiator().dirNumberMaxSymbolHolder.setAsConstantVariable(this.adEnv.integerTypeSpec, null, ILUtils.build(94, "TO_BE_DEFINED"));
            this.varRefDifferentiator().dirNumberMaxSymbolHolder.declarationLevelMustInclude(diffRootST);
            this.varRefDifferentiator().dirNumberMaxSymbolHolder.declare = false;
            this.varRefDifferentiator().multiDirDimensionMax = new ArrayDim(ILUtils.buildDimColon(arrayDimMin, this.varRefDifferentiator().dirNumberMaxSymbolHolder.makeNewRef(diffRootST)), null, null, null, -1, 0, 0);
        }
    }

    protected static void declareDiffSymbolTableIfNew(Unit diffUnit, SymbolTable diffSymbolTable) {
        if (!TapList.contains(diffUnit.symbolTablesBottomUp(), diffSymbolTable)) {
            diffUnit.addDerivedSymbolTable(diffSymbolTable);
        }
    }

    private void updateAllUsages(Unit unit, String oldUnitName, Unit diffUnit) {
        InterfaceDecl newIntfDecl;
        TapList<Block> blocks = unit.allBlocks();
        String diffFuncName = diffUnit.name;
        if (!unit.sameLanguage(diffUnit.language()) && this.diffCallGraph.getOtherLangFunctionDeclFromBindC(oldUnitName, 1) == null) {
            diffFuncName = (String)this.diffCallGraph.getMixedLanguageFunctionName((String)diffFuncName, (int)diffUnit.language(), (int)unit.language()).first;
            oldUnitName = (String)this.diffCallGraph.getMixedLanguageFunctionName((String)oldUnitName, (int)diffUnit.language(), (int)unit.language()).first;
        }
        if (unit.entryBlock() != null && unit.entryBlock().instructions != null) {
            Instruction instruction = (Instruction)unit.entryBlock().instructions.head;
            ILUtils.replaceAllIdentsNamed(ILUtils.getArguments(instruction.tree), oldUnitName, diffFuncName);
        }
        while (blocks != null) {
            Block block = (Block)blocks.head;
            this.updateAllUsagesInBlock(block, oldUnitName, diffUnit, diffFuncName);
            blocks = blocks.tail;
        }
        SymbolTable funCInPrivateOrPublicST = unit.bodySymbolTable();
        SymbolTable intfInPrivateOrPublicST = unit.bodySymbolTable();
        TapList<FunctionDecl> funDecls = funCInPrivateOrPublicST.getTopFunctionDecl(oldUnitName, null, null, false);
        FunctionDecl funDecl = funDecls == null ? null : (FunctionDecl)funDecls.head;
        InterfaceDecl intfDecl = intfInPrivateOrPublicST.getTopInterfaceDecl(oldUnitName);
        if (funDecl == null) {
            funCInPrivateOrPublicST = unit.publicSymbolTable();
            funDecls = funCInPrivateOrPublicST.getTopFunctionDecl(oldUnitName, null, null, false);
            FunctionDecl functionDecl = funDecl = funDecls == null ? null : (FunctionDecl)funDecls.head;
        }
        if (intfDecl == null) {
            intfInPrivateOrPublicST = unit.publicSymbolTable();
            intfDecl = intfInPrivateOrPublicST.getTopInterfaceDecl(oldUnitName);
        }
        Tree treeName = ILUtils.build(94, diffFuncName);
        FunctionDecl newFunDecl = new FunctionDecl(treeName, diffUnit);
        if (funDecl != null) {
            if (funDecl.unit().enclosingUnitOfInterface != null) {
                newFunDecl.unit().enclosingUnitOfInterface = funDecl.unit().enclosingUnitOfInterface;
            }
            TapList<String> extraInfo = funDecl.extraInfo();
            newFunDecl.setInstruction(funDecl);
            funCInPrivateOrPublicST.removeDecl(oldUnitName, funDecl.kind, true);
            funCInPrivateOrPublicST.addSymbolDecl(newFunDecl);
            newFunDecl.setExtraInfo(extraInfo);
        }
        if (intfDecl != null && (newIntfDecl = intfInPrivateOrPublicST.getTopInterfaceDecl(diffUnit.name)) != null) {
            intfInPrivateOrPublicST.removeInterfaceDecl(oldUnitName, intfDecl.kind, true);
        }
    }

    private void updateAllUsagesInBlock(Block block, String oldUnitName, Unit diffUnit, String diffUnitCallName) {
        TapList<Instruction> instructions = block.instructions;
        while (instructions != null) {
            Instruction instruction = (Instruction)instructions.head;
            if (instruction.tree.opCode() == 192) {
                ILUtils.replaceAllIdentsNamed(instruction.tree.down(1), oldUnitName, diffUnitCallName);
            } else if (instruction.tree.opCode() == 194) {
                ILUtils.replaceAllIdentsNamed(instruction.tree.down(3), oldUnitName, diffUnitCallName);
            } else if (instruction.tree.opCode() == 72) {
                ILUtils.replaceAllIdentsNamed(instruction.tree, oldUnitName, diffUnitCallName);
            } else if (instruction.tree.opCode() == 104) {
                Tree interfaces = instruction.tree.down(2);
                for (int i = 1; i <= interfaces.length(); ++i) {
                    Tree oneInterface = interfaces.down(i).down(1);
                    if (oneInterface.opCode() == 87) {
                        if (ILUtils.getIdentString(oneInterface.down(4)).equals(oldUnitName)) {
                            oneInterface.down(4).setValue(diffUnitCallName);
                            if (!diffUnit.isAFunction()) continue;
                            oneInterface.down(4).setAnnotation("explicitReturnVar", ILUtils.build(94, oldUnitName));
                            continue;
                        }
                        if (ILUtils.getIdentString(oneInterface.down(4)).equals(diffUnitCallName)) continue;
                        ILUtils.replaceAllIdentsNamed(oneInterface, oldUnitName, diffUnitCallName);
                        continue;
                    }
                    ILUtils.replaceAllIdentsNamed(oneInterface, oldUnitName, diffUnitCallName);
                }
            }
            ILUtils.replaceAllCallName(instruction.tree, oldUnitName, diffUnitCallName);
            instructions = instructions.tail;
        }
    }

    protected void updateAllUsagesDiffUnitTree(Unit unit, String oldUnitName, Unit diffUnit, Tree diffUnitTree) {
        TapList<Block> diffBlocks = diffUnit.allBlocks();
        String diffFuncName = diffUnit.name;
        if (!unit.sameLanguage(diffUnit.language()) && this.diffCallGraph.getOtherLangFunctionDeclFromBindC(oldUnitName, 1) == null) {
            diffFuncName = (String)this.diffCallGraph.getMixedLanguageFunctionName((String)diffFuncName, (int)diffUnit.language(), (int)unit.language()).first;
            oldUnitName = (String)this.diffCallGraph.getMixedLanguageFunctionName((String)oldUnitName, (int)diffUnit.language(), (int)unit.language()).first;
        }
        while (diffBlocks != null) {
            Block block = (Block)diffBlocks.head;
            this.updateAllUsagesInBlockDiffUnitTree(block, oldUnitName, diffFuncName, diffUnitTree);
            diffBlocks = diffBlocks.tail;
        }
    }

    private void updateAllUsagesInBlockDiffUnitTree(Block block, String oldUnitName, String diffUnitCallName, Tree diffUnitTree) {
        TapList<Instruction> instructions = block.instructions;
        while (instructions != null) {
            Instruction instruction = (Instruction)instructions.head;
            ILUtils.replaceAllCallNameTree(instruction.tree, oldUnitName, diffUnitCallName, diffUnitTree);
            instructions = instructions.tail;
        }
    }

    private void updateAllAccessDecls(TapList<Instruction> instructions, String oldUnitName, Unit diffUnit) {
        while (instructions != null) {
            Instruction instr = (Instruction)instructions.head;
            if (instr.tree.opCode() == 1) {
                ILUtils.replaceAllIdentsNamed(instr.tree.down(2), oldUnitName, diffUnit.name);
            }
            instructions = instructions.tail;
        }
    }

    private void updateRenamedTypeDecl(Unit diffUnit) {
        if (diffUnit.privateSymbolTable() != null) {
            TapList<Instruction> useDecls = diffUnit.privateSymbolTable().declarationsBlock.instructions;
            while (useDecls != null && ((Instruction)useDecls.head).tree.opCode() == 192) {
                Tree[] onlyVisibleTrees;
                Tree useDeclTree = ((Instruction)useDecls.head).tree;
                Tree infoTree = useDeclTree.down(2);
                for (Tree visibleTree : onlyVisibleTrees = infoTree.children()) {
                    NewSymbolHolder sHolder;
                    SymbolDecl symbolDecl;
                    Tree onlyVisibleTree = visibleTree;
                    if (onlyVisibleTree.opCode() != 160 || (symbolDecl = diffUnit.publicSymbolTable().getSymbolDecl(ILUtils.baseName(onlyVisibleTree.down(1)))) == null || !symbolDecl.isA(4) || (sHolder = symbolDecl.getDiffSymbolHolder(0, null)) == null) continue;
                    TypeDecl fromTypeDecl = (TypeDecl)symbolDecl.renamedFromSymbolDecl;
                    TypeDecl diffTypeDecl = sHolder.newTypeDecl();
                    diffTypeDecl.renamedFromSymbolDecl = fromTypeDecl.getDiffSymbolHolder(0, null).newTypeDecl();
                }
                useDecls = useDecls.tail;
            }
        }
    }

    private void updateModulesAndCopiedUnitsInCopiedUnit(SymbolTable copiedSymbolTable) {
        if (copiedSymbolTable != null && copiedSymbolTable.declarationsBlock != null) {
            TapList<Instruction> declarationInstructions = copiedSymbolTable.declarationsBlock.instructions;
            while (declarationInstructions != null) {
                Tree declarationTree = ((Instruction)declarationInstructions.head).tree;
                if (declarationTree != null) {
                    if (declarationTree.opCode() == 192) {
                        Unit diffModule;
                        String moduleName = ILUtils.getIdentString(declarationTree.down(1));
                        FunctionDecl moduleDecl = copiedSymbolTable.getModuleDecl(moduleName);
                        if (moduleDecl != null && moduleDecl.unit().isDiffPackage().booleanValue() && (diffModule = this.getUnitDiffInfo(moduleDecl.unit()).getDiff()) != null) {
                            declarationTree.setChild(ILUtils.build(94, diffModule.name), 1);
                        }
                    } else if (declarationTree.opCode() == 104) {
                        this.blockDifferentiator().updateModulesAndCopiedUnitsInCopiedInterface(declarationTree, copiedSymbolTable);
                    }
                }
                declarationInstructions = declarationInstructions.tail;
            }
        }
    }

    private void updateAAInCopiedUnits() {
        for (int i = this.srcCallGraph.nbUnits() - 1; i >= 0; --i) {
            this.setCurUnitEtc(this.adEnv.srcCallGraph().sortedUnit(i));
            Unit origCopyUnit = this.adEnv.copiedUnits.retrieve(this.curUnit);
            if (this.curUnit.isExternal() || origCopyUnit == null) continue;
            TapEnv.printlnOnTrace(10, "@@ Update copied unit: " + this.curUnit);
            this.setCurDiffUnit(origCopyUnit);
            TapList<Block> allOrigBlocks = this.curUnit.allBlocks();
            TapList<Block> allCopyBlocks = origCopyUnit.allBlocks();
            while (allOrigBlocks != null) {
                this.updateAAInCopiedBlock((Block)allOrigBlocks.head, (Block)allCopyBlocks.head);
                allOrigBlocks = allOrigBlocks.tail;
                allCopyBlocks = allCopyBlocks.tail;
            }
        }
    }

    private void updateAAInCopiedBlock(Block origBlock, Block copyBlock) {
        TapList<Instruction> instructions = copyBlock.instructions;
        int rank = 0;
        while (instructions != null) {
            Instruction instruction = (Instruction)instructions.head;
            this.adEnv.setCurInstruction(instruction);
            this.blockDifferentiator().updateAACopiedInstruction(instruction, origBlock, copyBlock, rank);
            this.blockDifferentiator().updateAAInstructionMask(instruction, origBlock.symbolTable, copyBlock.symbolTable);
            instructions = instructions.tail;
            ++rank;
        }
        this.adEnv.setCurInstruction(null);
    }

    private void placeDebugMidPointIfNone(Unit unit) {
        Block middleBlock;
        boolean hasDebugPoint = false;
        TapList<Block> allBlocks = unit.allBlocks();
        while (!hasDebugPoint && allBlocks != null) {
            TapList<Instruction> instructions = ((Block)allBlocks.head).instructions;
            while (!hasDebugPoint && instructions != null) {
                hasDebugPoint = ((Instruction)instructions.head).hasDirective(18) != null;
                instructions = instructions.tail;
            }
            allBlocks = allBlocks.tail;
        }
        if (!hasDebugPoint && (middleBlock = unit.middleNormalBlock()) != null && middleBlock.instructions != null) {
            Instruction middleInstruction = middleBlock.headInstr();
            Directive debugADHereDir = new Directive(18);
            debugADHereDir.arguments = new Tree[3];
            debugADHereDir.arguments[0] = ILUtils.build(94, "middle");
            debugADHereDir.arguments[1] = ILUtils.build(94, ".FALSE.");
            debugADHereDir.arguments[2] = ILUtils.build(94, ".FALSE.");
            middleInstruction.directives = new TapList<Directive>(debugADHereDir, middleInstruction.directives);
        }
    }
}

