/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.differentiation;

import fr.inria.tapenade.analysis.ADTBRAnalyzer;
import fr.inria.tapenade.analysis.DataFlowAnalyzer;
import fr.inria.tapenade.differentiation.BlockDifferentiator;
import fr.inria.tapenade.differentiation.DifferentiationEnv;
import fr.inria.tapenade.differentiation.FlowGraphDifferentiator;
import fr.inria.tapenade.differentiation.VarRefDifferentiator;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.RefDescriptor;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VoidTypeSpec;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.Tree;

public class DynMemoryDifferentiator {
    private int numAlloc;
    private int numDealloc;
    private final DifferentiationEnv adEnv;
    private final Tree c_NULL = ILUtils.build(31, ILUtils.build(151, ILUtils.build(199)), ILUtils.build(101, 0));

    private FlowGraphDifferentiator flowGraphDifferentiator() {
        return this.adEnv.flowGraphDifferentiator;
    }

    private BlockDifferentiator blockDifferentiator() {
        return this.adEnv.blockDifferentiator;
    }

    private VarRefDifferentiator varRefDifferentiator() {
        return this.adEnv.varRefDifferentiator;
    }

    private Unit curDiffUnit() {
        return this.adEnv.curDiffUnit;
    }

    private Unit curFwdDiffUnit() {
        return this.adEnv.curFwdDiffUnit;
    }

    private Block curBlock() {
        return this.adEnv.curBlock;
    }

    private int[] curVectorMap() {
        return this.adEnv.curVectorMap;
    }

    private int[] curDiffVectorMap() {
        return this.adEnv.curDiffVectorMap;
    }

    private int[] curPtrVectorMap() {
        return this.adEnv.curPtrVectorMap;
    }

    protected DynMemoryDifferentiator(DifferentiationEnv adEnv) {
        this.adEnv = adEnv;
    }

    protected void buildDiffInstructionsOfAssignAllocate(Tree tree, int differentiationMode, SymbolTable fwdSymbolTable, SymbolTable bwdSymbolTable, BoolVector beforeActiv, BoolVector afterActiv, BoolVector afterReqX, BoolVector beforeAvlX) {
        Tree newTree;
        Tree lhsTree = tree.down(1);
        Tree mallocTree = tree.down(2);
        boolean mustDiffOperation = this.blockDifferentiator().pointerIsActiveHere(lhsTree, beforeActiv, afterActiv, beforeAvlX, afterReqX);
        boolean hasBwdSweep = differentiationMode == -1 || differentiationMode == -2;
        boolean tbrPrimal = false;
        boolean rebasePrimal = false;
        boolean rebaseOnDiffPtr = false;
        Tree diffVarRefFwd = null;
        Tree diffVarRefBwd = null;
        TapIntList allocatedZones = ZoneInfo.listAllZones((TapList)mallocTree.getAnnotation("allocatedZones"), false);
        if (hasBwdSweep && TapEnv.dbadMode() == -1) {
            ++this.numAlloc;
        }
        if (hasBwdSweep) {
            if (this.flowGraphDifferentiator().toChunklengthVariable.head == null) {
                this.flowGraphDifferentiator().toChunklengthVariable.head = new NewSymbolHolder("chunklength", this.curDiffUnit(), this.adEnv.integerTypeSpec, -1);
            }
            ((NewSymbolHolder)this.flowGraphDifferentiator().toChunklengthVariable.head).declarationLevelMustInclude(bwdSymbolTable);
        }
        if (mustDiffOperation) {
            diffVarRefFwd = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), lhsTree, fwdSymbolTable, false, lhsTree, false, true, null);
            if (hasBwdSweep && !this.adEnv.curUnitIsContext) {
                diffVarRefBwd = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), lhsTree, bwdSymbolTable, false, lhsTree, false, true, null);
            }
            if (hasBwdSweep && !this.adEnv.curUnitIsContext && ADTBRAnalyzer.isTBROnDiffPtr(this.adEnv.curActivity(), lhsTree)) {
                RefDescriptor fwdDiffRefDescriptor = new RefDescriptor(lhsTree, null, this.curBlock().symbolTable, fwdSymbolTable, null, ILUtils.baseTree(diffVarRefFwd), true, null, this.curDiffUnit());
                if (!this.curBlock().symbolTable.isAnAllocatablePointer(lhsTree, this.adEnv.curInstruction())) {
                    rebaseOnDiffPtr = DataFlowAnalyzer.mayPointToRelocated(lhsTree, true, this.adEnv.curInstruction(), this.adEnv.curSymbolTable(), differentiationMode == -1);
                    this.blockDifferentiator().prepareRestoreOperations(fwdDiffRefDescriptor, null, 0, fwdSymbolTable, bwdSymbolTable);
                    this.blockDifferentiator().addFuturePlainNodeFwd(fwdDiffRefDescriptor.makePush(), null, false, null, null, new TapList<Tree>(lhsTree, null), null, false, true, "Store TBR previous value of DIFF OF allocated var " + ILUtils.toString(lhsTree, this.adEnv.curActivity()), false);
                    fwdDiffRefDescriptor.toBranchVariable = this.flowGraphDifferentiator().toBranchVariable;
                    this.blockDifferentiator().addFuturePlainNodeBwd(fwdDiffRefDescriptor.makePop(), null, false, ILUtils.usedVarsInExp(lhsTree, null, false), null, null, new TapList<Tree>(lhsTree, null), false, true, "Restore TBR previous value of DIFF OF allocated var " + ILUtils.toString(lhsTree, this.adEnv.curActivity()), false);
                } else {
                    TapEnv.toolError("Not yet implemented: FWD+ and +BWD push/pop for allocatable " + lhsTree);
                }
            }
            Tree diffMalloc = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), mallocTree, fwdSymbolTable, false, mallocTree, false, true, null);
            newTree = ILUtils.build(13, diffVarRefFwd, diffMalloc);
            this.blockDifferentiator().addFuturePlainNodeFwd(newTree, null, false, null, null, null, new TapList<Tree>(lhsTree, null), false, false, "Allocate DIFF OF var " + ILUtils.toString(lhsTree, this.adEnv.curActivity()), true);
            TapIntList allocatedZonesDiffKind = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(allocatedZones, this.adEnv.diffKind, this.curDiffVectorMap(), this.adEnv.curSymbolTable(), null);
            if (this.adEnv.curUnitIsContext || !TapEnv.spareDiffReinitializations() || differentiationMode == -1 && !TapEnv.removeDeadPrimal() || hasBwdSweep || afterActiv != null && afterActiv.intersects(allocatedZonesDiffKind)) {
                Tree newlyAllocatedDiff;
                if (this.curDiffUnit().isC()) {
                    Tree iterationSpace = ILUtils.isNullOrNone(mallocTree.down(2)) ? ILUtils.build(136) : ILUtils.build(58, ILUtils.build(101, 0), ILUtils.build(177, ILUtils.copy(mallocTree.down(2).down(1)), ILUtils.build(101, 1)));
                    newlyAllocatedDiff = ILUtils.build(148, ILUtils.copy(tree.down(1)), iterationSpace);
                } else {
                    newlyAllocatedDiff = ILUtils.build(8, ILUtils.build(148, ILUtils.copy(tree.down(1)), ILUtils.build(101, 0)), this.buildFullDimColons(mallocTree.down(2), true));
                }
                Tree fwdDiffControlTree = this.blockDifferentiator().makeDiffInitialization(newlyAllocatedDiff, this.adEnv.curSymbolTable(), fwdSymbolTable, null, null, false, null, true);
                if (fwdDiffControlTree != null) {
                    this.blockDifferentiator().addFuturePlainNodeFwd(fwdDiffControlTree, null, false, null, null, null, new TapList<Tree>(lhsTree, null), false, false, "Initialize DIFF OF allocated var " + ILUtils.toString(lhsTree, this.adEnv.curActivity()), false);
                }
            }
            if (hasBwdSweep && !this.adEnv.curUnitIsContext) {
                newTree = ILUtils.build(51, ILUtils.copy(diffVarRefBwd), null);
                this.blockDifferentiator().addFuturePlainNodeBwd(newTree, null, false, null, null, null, new TapList<Tree>(lhsTree, null), false, false, "Deallocate DIFF OF var " + ILUtils.toString(lhsTree, this.adEnv.curActivity()), true);
            }
        }
        if (hasBwdSweep && !this.adEnv.curUnitIsContext && ADTBRAnalyzer.isTBR(this.adEnv.curActivity(), lhsTree)) {
            RefDescriptor fwdPrimalRefDescriptor = new RefDescriptor(lhsTree, null, this.curBlock().symbolTable, fwdSymbolTable, null, null, false, null, this.curDiffUnit());
            if (!this.curBlock().symbolTable.isAnAllocatablePointer(lhsTree, this.adEnv.curInstruction())) {
                tbrPrimal = true;
                rebasePrimal = DataFlowAnalyzer.mayPointToRelocated(lhsTree, false, this.adEnv.curInstruction(), this.adEnv.curSymbolTable(), differentiationMode == -1);
                this.blockDifferentiator().prepareRestoreOperations(fwdPrimalRefDescriptor, null, 0, fwdSymbolTable, bwdSymbolTable);
                this.blockDifferentiator().addFuturePlainNodeFwd(fwdPrimalRefDescriptor.makePush(), null, false, new TapList<Tree>(lhsTree, null), null, null, null, false, true, "Store TBR previous value of allocated var " + ILUtils.toString(lhsTree, this.adEnv.curActivity()), false);
            }
            if ((rebasePrimal || rebaseOnDiffPtr) && this.curDiffUnit().isC()) {
                ++this.blockDifferentiator().numRebase;
                newTree = fwdPrimalRefDescriptor.makeRebase(rebasePrimal ? null : new TapList<Boolean>(Boolean.TRUE, null), rebaseOnDiffPtr ? null : new TapList<Boolean>(Boolean.TRUE, null), rebaseOnDiffPtr ? diffVarRefBwd : null, TapEnv.dbadMode() == -1 ? this.blockDifferentiator().numRebase : -1);
                this.blockDifferentiator().addFuturePlainNodeBwd(newTree, null, false, new TapList<Tree>(lhsTree, null), new TapList<Tree>(lhsTree, null), null, rebaseOnDiffPtr ? new TapList<Tree>(lhsTree, null) : null, false, false, "Rebase TBR previous value " + (rebaseOnDiffPtr ? "and DIFF " : "") + "of allocated var " + ILUtils.toString(lhsTree, this.adEnv.curActivity()), false);
            }
            if (tbrPrimal) {
                fwdPrimalRefDescriptor.toBranchVariable = this.flowGraphDifferentiator().toBranchVariable;
                Tree popTree = fwdPrimalRefDescriptor.makePop();
                this.blockDifferentiator().addFuturePlainNodeBwd(popTree, null, false, ILUtils.usedVarsInExp(lhsTree, null, false), new TapList<Tree>(lhsTree, null), null, null, false, true, "Restore TBR previous value of allocated var " + ILUtils.toString(lhsTree, this.adEnv.curActivity()), false);
            }
        }
        this.blockDifferentiator().addFuturePlainNodeFwd(ILUtils.copy(tree), null, false, null, new TapList<Tree>(lhsTree, null), null, null, false, false, "Allocate source var " + ILUtils.toString(lhsTree, this.adEnv.curActivity()), false);
        if (hasBwdSweep) {
            if (!this.adEnv.curUnitIsContext) {
                newTree = ILUtils.build(51, ILUtils.copy(lhsTree), null);
                this.blockDifferentiator().addFuturePlainNodeBwd(newTree, null, false, null, new TapList<Tree>(lhsTree, null), null, null, false, false, "Deallocate source var " + ILUtils.toString(lhsTree, this.adEnv.curActivity()), false);
            }
            boolean mustRegister = false;
            boolean mustRegisterDiff = false;
            if (!TapEnv.get().refineADMM) {
                mustRegister = true;
                mustRegisterDiff = true;
            }
            while (!(mustRegister && mustRegisterDiff || allocatedZones == null)) {
                ZoneInfo zoneInfo = DataFlowAnalyzer.extendedDeclaredToZoneInfo(allocatedZones.head, this.adEnv.curSymbolTable(), null);
                if (zoneInfo != null) {
                    mustRegister = zoneInfo.relocated || zoneInfo.rebased;
                    mustRegisterDiff = zoneInfo.relocatedDiff || zoneInfo.rebasedDiff;
                }
                allocatedZones = allocatedZones.tail;
            }
            if ((mustRegister || mustRegisterDiff) && this.curDiffUnit().isC()) {
                this.adEnv.usesADMM = true;
                Tree dimensionsTree = mallocTree.down(2);
                if (!ILUtils.isNullOrNone(dimensionsTree)) {
                    if (dimensionsTree.length() > 1) {
                        TapEnv.toolWarning(-1, "(Differentiate allocation) ADMM_register of multi-dimensional array " + dimensionsTree + " not implemented yet");
                        dimensionsTree = ILUtils.build(101, "0");
                        dimensionsTree.setAnnotation("preComments", ILUtils.build(36, ILUtils.build(175, "UnknownSize")));
                    } else if (dimensionsTree.length() == 0) {
                        dimensionsTree = null;
                    } else if ((dimensionsTree = dimensionsTree.down(1)).opCode() == 11) {
                        if (dimensionsTree.down(1).opCode() != 101 || dimensionsTree.down(1).intValue() != 1 || !ILUtils.isNullOrNone(dimensionsTree.down(3))) {
                            TapEnv.toolWarning(-1, "(Differentiate allocation) cannot manage triplet dimension size: " + dimensionsTree);
                        }
                        dimensionsTree = dimensionsTree.down(2);
                    } else if (dimensionsTree.opCode() == 58) {
                        if (dimensionsTree.down(1).opCode() != 101 || dimensionsTree.down(1).intValue() != 1) {
                            TapEnv.toolWarning(-1, "(Differentiate allocation) cannot manage colon dimension size: " + dimensionsTree);
                        }
                        dimensionsTree = dimensionsTree.down(2);
                    }
                }
                if (!this.curBlock().symbolTable.isAnAllocatablePointer(lhsTree, this.adEnv.curInstruction()) || this.curBlock().symbolTable.isAllocatableAndTarget(lhsTree)) {
                    if (this.adEnv.curUnit().isFortran9x()) {
                        lhsTree = ILUtils.buildCLoc(ILUtils.copy(lhsTree), "C_LOC");
                        if (diffVarRefFwd != null) {
                            diffVarRefFwd = ILUtils.buildCLoc(ILUtils.copy(diffVarRefFwd), "C_LOC");
                        }
                        if (diffVarRefBwd != null) {
                            diffVarRefBwd = ILUtils.buildCLoc(ILUtils.copy(diffVarRefBwd), "C_LOC");
                        }
                        this.adEnv.curDiffUnitPushesPointers = true;
                    }
                    if (mustDiffOperation) {
                        Tree mallocDiffSize = ILUtils.copy(mallocTree.down(1));
                        Tree sizeofCall = ILUtils.findSizeofCall(mallocDiffSize);
                        if (sizeofCall != null) {
                            sizeofCall.setChild(this.varRefDifferentiator().differentiateTypeTree(sizeofCall.cutChild(1), fwdSymbolTable), 1);
                        }
                        newTree = ILUtils.buildCall(ILUtils.build(94, "ADMM_registerShadowed"), ILUtils.build(70, ILUtils.copy(lhsTree), ILUtils.copy(this.curDiffUnit().isC() ? this.c_NULL : lhsTree), ILUtils.isNullOrNone(mallocTree.down(1)) ? ILUtils.build(101, 1) : ILUtils.copy(mallocTree.down(1)), ILUtils.copy(diffVarRefFwd), ILUtils.copy(this.curDiffUnit().isC() ? this.c_NULL : diffVarRefFwd), ILUtils.isNullOrNone(mallocDiffSize) ? ILUtils.build(101, 1) : mallocDiffSize, ILUtils.isNullOrNone(dimensionsTree) ? ILUtils.build(101, 1) : ILUtils.copy(dimensionsTree)));
                    } else {
                        newTree = ILUtils.buildCall(ILUtils.build(94, "ADMM_register"), ILUtils.build(70, ILUtils.copy(lhsTree), ILUtils.copy(this.curDiffUnit().isC() ? this.c_NULL : lhsTree), ILUtils.isNullOrNone(mallocTree.down(1)) ? ILUtils.build(101, 1) : ILUtils.copy(mallocTree.down(1)), ILUtils.isNullOrNone(dimensionsTree) ? ILUtils.build(101, 1) : ILUtils.copy(dimensionsTree)));
                    }
                    if (TapEnv.dbadMode() == -1) {
                        newTree.down(2).addChild(BlockDifferentiator.debugLabel((this.adEnv.curUnitIsContext ? "Ctx" : "FW") + "Register", this.numAlloc), -1);
                    }
                    this.blockDifferentiator().addFuturePlainNodeFwd(newTree, null, false, new TapList<Tree>(lhsTree, null), null, mustDiffOperation ? new TapList<Tree>(lhsTree, null) : null, null, false, false, "Register allocated source " + (mustDiffOperation ? "and DIFF vars " : "var ") + ILUtils.toString(lhsTree, this.adEnv.curActivity()), true);
                }
                if (!this.adEnv.curUnitIsContext) {
                    Tree refChunklength = ((NewSymbolHolder)this.flowGraphDifferentiator().toChunklengthVariable.head).makeNewRef(bwdSymbolTable);
                    if (this.curDiffUnit().isC()) {
                        refChunklength = ILUtils.build(3, refChunklength);
                    }
                    newTree = mustDiffOperation ? ILUtils.buildCall(ILUtils.build(94, "ADMM_unregisterShadowed"), ILUtils.build(70, ILUtils.copy(lhsTree), ILUtils.copy(diffVarRefBwd), refChunklength)) : ILUtils.buildCall(ILUtils.build(94, "ADMM_unregister"), ILUtils.build(70, ILUtils.copy(lhsTree), refChunklength));
                    if (TapEnv.dbadMode() == -1) {
                        newTree.down(2).addChild(BlockDifferentiator.debugLabel("BWRegister", this.numAlloc), -1);
                    }
                    this.blockDifferentiator().addFuturePlainNodeBwd(newTree, null, false, new TapList<Tree>(lhsTree, null), null, mustDiffOperation ? new TapList<Tree>(lhsTree, null) : null, null, false, false, "Un-Register allocated source " + (mustDiffOperation ? "and DIFF vars " : "var ") + ILUtils.toString(lhsTree, this.adEnv.curActivity()), true);
                }
            }
        }
    }

    protected void buildDiffInstructionsOfDeallocate(Tree tree, int differentiationMode, boolean deallocateIsLive, SymbolTable fwdSymbolTable, SymbolTable bwdSymbolTable, BoolVector beforeActiv, BoolVector afterActiv, BoolVector afterReqX, BoolVector beforeAvlX, BoolVector beforeTBR, BoolVector beforeTBROnDiffPtr) {
        Tree popTree;
        Tree newTree;
        RefDescriptor refDescriptor;
        if (!deallocateIsLive) {
            return;
        }
        boolean mustDiffOperation = this.blockDifferentiator().pointerIsActiveHere(tree.down(1), beforeActiv, afterActiv, beforeAvlX, afterReqX);
        boolean hasBwdSweep = differentiationMode == -1 || differentiationMode == -2;
        Tree diffVarRefFwd = null;
        Tree diffVarRefBwd = null;
        Tree diffBaseFwd = null;
        Tree diffBaseBwd = null;
        Tree newMallocTree = null;
        Tree newMallocDiffTree = null;
        Tree rootForPush = null;
        Tree rootForPop = null;
        TapList<?> treeOfNonTBRPointers = null;
        TapList<?> treeOfNonTBRDiffPointers = null;
        TapList<?> treeOfNonTBRZones = null;
        Tree pushTreePrimal = null;
        Tree pushTreeOnDiffPtr = null;
        boolean tbrPrimal = false;
        boolean tbrOnDiffPtr = false;
        boolean rebasePrimal = false;
        boolean rebaseOnDiffPtr = false;
        boolean isAllocatable = this.adEnv.curSymbolTable().isAllocatable(tree.down(1), "allocatable");
        if (bwdSymbolTable != null && isAllocatable && !this.adEnv.curUnitIsContext) {
            TapEnv.toolWarning(-1, "(Differentiate de-allocation) cannot manage allocatable array " + ILUtils.toString(tree) + " not implemented yet");
        }
        Tree destinationTree = ILUtils.build(148, ILUtils.copy(tree.down(1)));
        if (!this.curDiffUnit().isC()) {
            destinationTree = ILUtils.build(8, destinationTree);
        }
        TapList<?> exprZonesTree = this.adEnv.curSymbolTable().treeOfZonesOfValue(destinationTree, null, this.adEnv.curInstruction(), null);
        TapIntList deallocatedZones = ZoneInfo.listAllZones(exprZonesTree, false);
        if (hasBwdSweep && TapEnv.dbadMode() == -1) {
            ++this.numDealloc;
        }
        if (hasBwdSweep) {
            if (this.flowGraphDifferentiator().toChunklengthVariable.head == null) {
                this.flowGraphDifferentiator().toChunklengthVariable.head = new NewSymbolHolder("chunklength", this.curDiffUnit(), this.adEnv.integerTypeSpec, -1);
            }
            ((NewSymbolHolder)this.flowGraphDifferentiator().toChunklengthVariable.head).declarationLevelMustInclude(bwdSymbolTable);
            if (this.flowGraphDifferentiator().toFwdChunklengthVariable.head == null) {
                this.flowGraphDifferentiator().toFwdChunklengthVariable.head = new NewSymbolHolder("chunklength", this.curFwdDiffUnit(), this.adEnv.integerTypeSpec, -1);
            }
            ((NewSymbolHolder)this.flowGraphDifferentiator().toFwdChunklengthVariable.head).declarationLevelMustInclude(fwdSymbolTable);
        }
        if (hasBwdSweep && !this.adEnv.curUnitIsContext) {
            int typeSize;
            WrapperTypeSpec allocType;
            if (this.flowGraphDifferentiator().toChunkoldVariable.head == null) {
                this.flowGraphDifferentiator().toChunkoldVariable.head = new NewSymbolHolder("chunkold", this.curDiffUnit(), new WrapperTypeSpec(new PointerTypeSpec(this.curDiffUnit().isC() ? new WrapperTypeSpec(new VoidTypeSpec()) : this.adEnv.realTypeSpec, null)), -1);
            }
            ((NewSymbolHolder)this.flowGraphDifferentiator().toChunkoldVariable.head).declarationLevelMustInclude(bwdSymbolTable);
            if (mustDiffOperation) {
                if (this.flowGraphDifferentiator().toDiffchunkoldVariable.head == null) {
                    this.flowGraphDifferentiator().toDiffchunkoldVariable.head = new NewSymbolHolder("diffchunkold", this.curDiffUnit(), new WrapperTypeSpec(new PointerTypeSpec(this.curDiffUnit().isC() ? new WrapperTypeSpec(new VoidTypeSpec()) : this.adEnv.realTypeSpec, null)), -1);
                }
                ((NewSymbolHolder)this.flowGraphDifferentiator().toDiffchunkoldVariable.head).declarationLevelMustInclude(bwdSymbolTable);
            }
            if (TypeSpec.isA(allocType = this.adEnv.curSymbolTable().typeOf(tree.down(1)), 6)) {
                allocType = ((PointerTypeSpec)allocType.wrappedType).destinationType;
            }
            if (TypeSpec.isA(allocType, 2)) {
                allocType = allocType.wrappedType.elementType();
            }
            Tree typeTree = allocType == null ? null : allocType.generateTree(bwdSymbolTable, null, null, true, null);
            int n = typeSize = allocType == null ? 0 : allocType.size();
            if (this.curDiffUnit().isC() && TypeSpec.isA(allocType, 21)) {
                typeSize = 0;
            }
            newMallocTree = ILUtils.build(4, ILUtils.build(131, typeSize == 0 ? ILUtils.build(171, ILUtils.copy(typeTree)) : ILUtils.build(101, typeSize), ((NewSymbolHolder)this.flowGraphDifferentiator().toChunklengthVariable.head).makeNewRef(bwdSymbolTable)), ILUtils.build(70, ((NewSymbolHolder)this.flowGraphDifferentiator().toChunklengthVariable.head).makeNewRef(bwdSymbolTable)), ILUtils.copy(typeTree), null);
            if (mustDiffOperation) {
                newMallocDiffTree = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), newMallocTree, bwdSymbolTable, false, newMallocTree, false, true, null);
            }
        }
        if (hasBwdSweep && !this.adEnv.curUnitIsContext) {
            if (this.curDiffUnit().isC()) {
                rootForPush = ILUtils.build(148, ILUtils.copy(tree.down(1)), ILUtils.build(58, ILUtils.build(101, 0), ILUtils.build(177, ((NewSymbolHolder)this.flowGraphDifferentiator().toFwdChunklengthVariable.head).makeNewRef(fwdSymbolTable), ILUtils.build(101, 1))));
                rootForPop = ILUtils.build(148, ILUtils.copy(tree.down(1)), ILUtils.build(58, ILUtils.build(101, 0), ILUtils.build(177, ((NewSymbolHolder)this.flowGraphDifferentiator().toChunklengthVariable.head).makeNewRef(bwdSymbolTable), ILUtils.build(101, 1))));
            } else {
                rootForPush = ILUtils.build(8, ILUtils.build(148, ILUtils.copy(tree.down(1)), ILUtils.build(101, 0)), this.buildFullDimColons(ILUtils.build(70, ((NewSymbolHolder)this.flowGraphDifferentiator().toFwdChunklengthVariable.head).makeNewRef(fwdSymbolTable)), true));
                rootForPop = ILUtils.build(8, ILUtils.build(148, ILUtils.copy(tree.down(1)), ILUtils.build(101, 0)), this.buildFullDimColons(ILUtils.build(70, ((NewSymbolHolder)this.flowGraphDifferentiator().toChunklengthVariable.head).makeNewRef(bwdSymbolTable)), true));
            }
        }
        if (mustDiffOperation) {
            diffVarRefFwd = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), tree.down(1), fwdSymbolTable, false, tree, false, true, null);
            diffBaseFwd = ILUtils.baseTree(diffVarRefFwd);
            if (hasBwdSweep && !this.adEnv.curUnitIsContext) {
                diffVarRefBwd = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), tree.down(1), bwdSymbolTable, false, tree, false, true, null);
                diffBaseBwd = ILUtils.baseTree(diffVarRefBwd);
            }
        }
        if (hasBwdSweep && !this.adEnv.curUnitIsContext) {
            treeOfNonTBRZones = DataFlowAnalyzer.buildInfoBoolTreeOfDeclaredZonesAll(exprZonesTree, beforeTBR.not(), this.curVectorMap(), null, 0, this.adEnv.curSymbolTable());
            refDescriptor = new RefDescriptor(rootForPush, null, this.adEnv.curSymbolTable(), fwdSymbolTable, null, null, false, null, this.curFwdDiffUnit());
            refDescriptor.prepareForStack(this.curFwdDiffUnit(), 0, treeOfNonTBRZones, true);
            refDescriptor.mayProtectAccesses = false;
            pushTreePrimal = refDescriptor.makePush();
            if (pushTreePrimal != null) {
                tbrPrimal = true;
                rebasePrimal = DataFlowAnalyzer.mayPointToRelocated(tree.down(1), false, this.adEnv.curInstruction(), this.adEnv.curSymbolTable(), differentiationMode == -1);
            }
            if (mustDiffOperation) {
                treeOfNonTBRDiffPointers = DataFlowAnalyzer.buildInfoBoolTreeOfDeclaredZonesAll(exprZonesTree, beforeTBROnDiffPtr.not(), this.curPtrVectorMap(), null, 3, this.adEnv.curSymbolTable());
                refDescriptor = new RefDescriptor(rootForPush, null, this.adEnv.curSymbolTable(), fwdSymbolTable, null, diffBaseFwd, true, null, this.curFwdDiffUnit());
                refDescriptor.prepareForStack(this.curFwdDiffUnit(), 0, treeOfNonTBRDiffPointers, true);
                refDescriptor.mayProtectAccesses = false;
                pushTreeOnDiffPtr = refDescriptor.makePush();
                if (pushTreeOnDiffPtr != null) {
                    tbrOnDiffPtr = true;
                    rebaseOnDiffPtr = DataFlowAnalyzer.mayPointToRelocated(tree.down(1), true, this.adEnv.curInstruction(), this.adEnv.curSymbolTable(), differentiationMode == -1);
                }
            }
            if (tbrPrimal || tbrOnDiffPtr) {
                BoolVector beforeTBRonPointers = DataFlowAnalyzer.changeKind(beforeTBR, this.curVectorMap(), 0, this.curPtrVectorMap(), 3, this.adEnv.curSymbolTable());
                treeOfNonTBRPointers = DataFlowAnalyzer.buildInfoBoolTreeOfDeclaredZonesAll(exprZonesTree, beforeTBRonPointers.not(), this.curPtrVectorMap(), null, 3, this.adEnv.curSymbolTable());
            }
        }
        TapIntList inDeallocatedZones = deallocatedZones;
        boolean mustRegister = false;
        boolean mustRegisterDiff = false;
        if (!TapEnv.get().refineADMM || differentiationMode == -1 && !TapEnv.removeDeadPrimal()) {
            mustRegister = true;
            mustRegisterDiff = true;
        }
        while (!(mustRegister && mustRegisterDiff || inDeallocatedZones == null)) {
            ZoneInfo zoneInfo = DataFlowAnalyzer.extendedDeclaredToZoneInfo(inDeallocatedZones.head, this.adEnv.curSymbolTable(), null);
            if (zoneInfo != null) {
                mustRegister = zoneInfo.relocated || zoneInfo.rebased;
                mustRegisterDiff = zoneInfo.relocatedDiff || zoneInfo.rebasedDiff;
            }
            inDeallocatedZones = inDeallocatedZones.tail;
        }
        if (hasBwdSweep && (mustRegister || mustRegisterDiff)) {
            Tree tree1 = tree.down(1);
            Tree refChunklength = ((NewSymbolHolder)this.flowGraphDifferentiator().toFwdChunklengthVariable.head).makeNewRef(fwdSymbolTable);
            if (this.curDiffUnit().isC()) {
                Tree diffVarRefBwdCp;
                this.adEnv.usesADMM = true;
                Tree diffVarRefFwdCp = diffVarRefFwd == null ? null : ILUtils.copy(diffVarRefFwd);
                Tree tree2 = diffVarRefBwdCp = diffVarRefBwd == null ? null : ILUtils.copy(diffVarRefBwd);
                if (this.adEnv.curUnit().isFortran9x() && (!this.curBlock().symbolTable.isAnAllocatablePointer(tree1, this.adEnv.curInstruction()) || this.curBlock().symbolTable.isAllocatableAndTarget(tree1))) {
                    tree1 = ILUtils.buildCLoc(ILUtils.copy(tree1), "C_LOC");
                    if (diffVarRefFwd != null) {
                        diffVarRefFwdCp = ILUtils.buildCLoc(diffVarRefFwd, "C_LOC");
                    }
                    if (diffVarRefBwd != null) {
                        diffVarRefBwdCp = ILUtils.buildCLoc(diffVarRefBwd, "C_LOC");
                    }
                }
                if (diffVarRefBwdCp == null) {
                    diffVarRefBwdCp = ILUtils.build(94, this.adEnv.curUnit().isFortran9x() ? "C_NULL_PTR" : "NULL");
                }
                if (this.curDiffUnit().isC()) {
                    refChunklength = ILUtils.build(3, refChunklength);
                }
                newTree = mustDiffOperation ? ILUtils.buildCall(ILUtils.build(94, "ADMM_unregisterShadowed"), ILUtils.build(70, ILUtils.copy(tree1), ILUtils.copy(diffVarRefFwdCp), refChunklength)) : ILUtils.buildCall(ILUtils.build(94, "ADMM_unregister"), ILUtils.build(70, ILUtils.copy(tree1), refChunklength));
                if (TapEnv.dbadMode() == -1) {
                    newTree.down(2).addChild(BlockDifferentiator.debugLabel((this.adEnv.curUnitIsContext ? "Ctx" : "FW") + "Unregister", this.numDealloc), -1);
                }
                this.blockDifferentiator().addFuturePlainNodeFwd(newTree, null, false, new TapList<Tree>(tree.down(1), null), null, mustDiffOperation ? new TapList<Tree>(tree.down(1), null) : null, null, false, false, "Un-Register allocated source " + (mustDiffOperation ? "and DIFF vars " : "var ") + ILUtils.toString(tree.down(1), this.adEnv.curActivity()), true);
                if (!this.adEnv.curUnitIsContext) {
                    this.adEnv.usesADMM = true;
                    Tree toChunkTree = ((NewSymbolHolder)this.flowGraphDifferentiator().toChunkoldVariable.head).makeNewRef(bwdSymbolTable);
                    boolean isAllocatableArray = this.adEnv.curSymbolTable().isAllocatable(tree, "allocatable");
                    if (this.adEnv.curUnit().isFortran9x() && !isAllocatableArray) {
                        toChunkTree = ILUtils.buildCLoc(toChunkTree, "C_LOC");
                    }
                    if (mustDiffOperation) {
                        Tree toDiffChunkTree = ((NewSymbolHolder)this.flowGraphDifferentiator().toDiffchunkoldVariable.head).makeNewRef(bwdSymbolTable);
                        if (this.adEnv.curUnit().isFortran9x() && !isAllocatableArray) {
                            toDiffChunkTree = ILUtils.buildCLoc(toDiffChunkTree, "C_LOC");
                        }
                        newTree = ILUtils.buildCall(ILUtils.build(94, "ADMM_registerShadowed"), ILUtils.build(70, ILUtils.copy(tree1), toChunkTree, ILUtils.isNullOrNone(newMallocTree.down(1)) ? ILUtils.build(101, 1) : ILUtils.copy(newMallocTree.down(1)), ILUtils.copy(diffVarRefBwdCp), toDiffChunkTree, ILUtils.isNullOrNone(newMallocDiffTree.down(1)) ? ILUtils.build(101, 1) : ILUtils.copy(newMallocDiffTree.down(1)), ((NewSymbolHolder)this.flowGraphDifferentiator().toChunklengthVariable.head).makeNewRef(bwdSymbolTable)));
                    } else {
                        newTree = ILUtils.buildCall(ILUtils.build(94, "ADMM_register"), ILUtils.build(70, ILUtils.copy(tree1), toChunkTree, ILUtils.isNullOrNone(newMallocTree.down(1)) ? ILUtils.build(101, 1) : ILUtils.copy(newMallocTree.down(1)), ((NewSymbolHolder)this.flowGraphDifferentiator().toChunklengthVariable.head).makeNewRef(bwdSymbolTable)));
                    }
                    if (TapEnv.dbadMode() == -1) {
                        newTree.down(2).addChild(BlockDifferentiator.debugLabel("BWReregister", this.numDealloc), -1);
                    }
                    this.blockDifferentiator().addFuturePlainNodeBwd(newTree, null, false, new TapList<Tree>(tree.down(1), null), null, mustDiffOperation ? new TapList<Tree>(tree.down(1), null) : null, null, false, false, "Re-Register allocated source " + (mustDiffOperation ? "and DIFF vars " : "var ") + ILUtils.toString(tree.down(1), this.adEnv.curActivity()), true);
                }
            } else {
                newTree = ILUtils.build(13, refChunklength, ILUtils.buildCall(ILUtils.build(94, "size"), ILUtils.build(70, ILUtils.copy(tree1))));
                this.blockDifferentiator().addFuturePlainNodeFwd(newTree, null, false, new TapList<Tree>(tree.down(1), null), null, null, null, false, false, "Query for length of variable " + ILUtils.toString(tree.down(1), this.adEnv.curActivity()), true);
            }
        }
        if (hasBwdSweep && mustDiffOperation && !this.adEnv.curUnitIsContext && tbrOnDiffPtr && this.curDiffUnit().isC()) {
            this.blockDifferentiator().addFuturePlainNodeFwd(pushTreeOnDiffPtr, null, false, null, null, new TapList<Tree>(rootForPush, null), null, false, true, "Push TBR DIFF pointers before deallocation", false);
        }
        if (hasBwdSweep && !this.adEnv.curUnitIsContext && (rebasePrimal || rebaseOnDiffPtr) && this.curDiffUnit().isC()) {
            BoolVector beforeTBRonPointers = DataFlowAnalyzer.changeKind(beforeTBR, this.curVectorMap(), 0, this.curPtrVectorMap(), 3, this.adEnv.curSymbolTable());
            TapList<?> excludableTree = DataFlowAnalyzer.buildInfoBoolTreeOfDeclaredZonesAll(exprZonesTree, beforeTBRonPointers.or(beforeTBROnDiffPtr).not(), this.curPtrVectorMap(), null, 3, this.adEnv.curSymbolTable());
            refDescriptor = new RefDescriptor(rootForPop, null, this.adEnv.curSymbolTable(), bwdSymbolTable, null, null, false, null, this.curDiffUnit());
            refDescriptor.prepareForStack(this.curDiffUnit(), 0, null, true);
            refDescriptor.mayProtectAccesses = false;
            ++this.blockDifferentiator().numRebase;
            Tree rebaseTree = refDescriptor.makeRebase(treeOfNonTBRPointers, treeOfNonTBRDiffPointers, rebaseOnDiffPtr ? diffVarRefBwd : null, TapEnv.dbadMode() == -1 ? this.blockDifferentiator().numRebase : -1);
            if (rebaseTree != null) {
                this.blockDifferentiator().addFuturePlainNodeBwd(rebaseTree, null, false, null, new TapList<Tree>(rootForPop, null), null, rebaseOnDiffPtr ? new TapList<Tree>(rootForPop, null) : null, false, false, "Rebase TBR pointers " + (rebaseOnDiffPtr ? "and their DIFFs " : " ") + "after Re-allocation", false);
            }
        }
        if (mustDiffOperation) {
            if (hasBwdSweep && !this.adEnv.curUnitIsContext) {
                if (this.curDiffUnit().isC()) {
                    refDescriptor = new RefDescriptor(rootForPop, null, this.adEnv.curSymbolTable(), bwdSymbolTable, null, diffBaseBwd, true, null, this.curDiffUnit());
                    refDescriptor.prepareForStack(this.curDiffUnit(), 0, treeOfNonTBRDiffPointers, true);
                    refDescriptor.mayProtectAccesses = false;
                    popTree = refDescriptor.makePop();
                    if (popTree != null) {
                        this.blockDifferentiator().addFuturePlainNodeBwd(popTree, null, false, null, null, null, new TapList<Tree>(rootForPop, null), false, true, "Pop TBR DIFF pointers after Re-allocation", false);
                    }
                }
                deallocatedZones = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(deallocatedZones, this.adEnv.diffKind, this.curDiffVectorMap(), this.adEnv.curSymbolTable(), null);
                TapList pointersToIgnore = DataFlowAnalyzer.buildInfoBoolTreeOfPointers(exprZonesTree, this.curPtrVectorMap(), this.adEnv.curSymbolTable());
                if ((!TapEnv.spareDiffReinitializations() || !TapEnv.removeDeadPrimal() || beforeActiv != null && beforeActiv.intersects(deallocatedZones)) && (newTree = this.blockDifferentiator().makeDiffInitialization(rootForPop, this.adEnv.curSymbolTable(), bwdSymbolTable, null, null, false, pointersToIgnore, true)) != null) {
                    this.blockDifferentiator().addFuturePlainNodeBwd(newTree, null, false, null, null, null, new TapList<Tree>(tree.down(1), null), false, false, "Initialize DIFF OF Re-allocated var " + ILUtils.toString(tree.down(1), this.adEnv.curActivity()), false);
                }
                if (this.curDiffUnit().isC()) {
                    RefDescriptor diffdeallocRefDescriptor = new RefDescriptor(tree.down(1), null, this.curBlock().symbolTable, fwdSymbolTable, null, diffBaseFwd, true, null, this.curDiffUnit());
                    this.blockDifferentiator().prepareRestoreOperations(diffdeallocRefDescriptor, null, 0, fwdSymbolTable, bwdSymbolTable);
                    diffdeallocRefDescriptor.mayProtectAccesses = false;
                    this.blockDifferentiator().addFuturePlainNodeFwd(diffdeallocRefDescriptor.makePush(), null, false, null, null, new TapList<Tree>(tree.down(1), null), null, false, true, "Store deallocated DIFF chunk address", false);
                    RefDescriptor diffchunkoldRefDescriptor = new RefDescriptor(((NewSymbolHolder)this.flowGraphDifferentiator().toDiffchunkoldVariable.head).makeNewRef(bwdSymbolTable), null, this.curBlock().symbolTable, bwdSymbolTable, null, null, false, null, this.curDiffUnit());
                    this.blockDifferentiator().prepareRestoreOperations(diffchunkoldRefDescriptor, null, 0, fwdSymbolTable, bwdSymbolTable);
                    diffchunkoldRefDescriptor.mayProtectAccesses = false;
                    this.blockDifferentiator().addFuturePlainNodeBwd(diffchunkoldRefDescriptor.makePop(), null, false, null, null, null, null, false, true, "Retrieve deallocated DIFF chunk address", true);
                }
            }
            newTree = ILUtils.build(51, ILUtils.copy(diffVarRefFwd), null);
            if (this.curDiffUnit().isFortran9x()) {
                newTree = ILUtils.build(96, ILUtils.buildCall(ILUtils.build(94, isAllocatable ? "ALLOCATED" : "ASSOCIATED"), ILUtils.build(70, ILUtils.copy(diffVarRefFwd))), newTree);
            }
            this.blockDifferentiator().addFuturePlainNodeFwd(newTree, null, false, null, null, null, new TapList<Tree>(tree.down(1), null), false, false, "Un-Allocate DIFF OF var " + ILUtils.toString(tree.down(1), this.adEnv.curActivity()), true);
            if (hasBwdSweep && !this.adEnv.curUnitIsContext) {
                newTree = ILUtils.build(13, diffVarRefBwd, newMallocDiffTree);
                this.blockDifferentiator().addFuturePlainNodeBwd(newTree, null, false, null, null, null, new TapList<Tree>(tree.down(1), null), false, false, "Re-Allocate DIFF OF var " + ILUtils.toString(tree.down(1), this.adEnv.curActivity()), true);
            }
        }
        if (hasBwdSweep && !this.adEnv.curUnitIsContext) {
            if (tbrPrimal) {
                this.blockDifferentiator().addFuturePlainNodeFwd(pushTreePrimal, null, false, new TapList<Tree>(rootForPush, null), null, null, null, false, true, "Push TBR before deallocation", false);
            }
            refDescriptor = new RefDescriptor(rootForPop, null, this.adEnv.curSymbolTable(), bwdSymbolTable, null, null, false, null, this.curDiffUnit());
            refDescriptor.prepareForStack(this.curDiffUnit(), 0, treeOfNonTBRZones, true);
            refDescriptor.mayProtectAccesses = false;
            popTree = refDescriptor.makePop();
            if (popTree != null) {
                this.blockDifferentiator().addFuturePlainNodeBwd(popTree, null, false, null, new TapList<Tree>(rootForPop, null), null, null, false, true, "Pop TBR after Re-allocation", false);
            }
        }
        if (hasBwdSweep && !this.adEnv.curUnitIsContext && this.curDiffUnit().isC()) {
            RefDescriptor deallocRefDescriptor = new RefDescriptor(tree.down(1), null, this.curBlock().symbolTable, fwdSymbolTable, null, null, false, null, this.curDiffUnit());
            this.blockDifferentiator().prepareRestoreOperations(deallocRefDescriptor, null, 0, fwdSymbolTable, bwdSymbolTable);
            deallocRefDescriptor.mayProtectAccesses = false;
            this.blockDifferentiator().addFuturePlainNodeFwd(deallocRefDescriptor.makePush(), null, false, new TapList<Tree>(tree.down(1), null), null, null, null, false, true, "Store deallocated source chunk address", false);
            RefDescriptor chunkoldRefDescriptor = new RefDescriptor(((NewSymbolHolder)this.flowGraphDifferentiator().toChunkoldVariable.head).makeNewRef(bwdSymbolTable), null, this.curBlock().symbolTable, bwdSymbolTable, null, null, false, null, this.curDiffUnit());
            this.blockDifferentiator().prepareRestoreOperations(chunkoldRefDescriptor, null, 0, fwdSymbolTable, bwdSymbolTable);
            chunkoldRefDescriptor.mayProtectAccesses = false;
            this.blockDifferentiator().addFuturePlainNodeBwd(chunkoldRefDescriptor.makePop(), null, false, null, null, null, null, false, true, "Retrieve deallocated source chunk address", true);
        }
        this.blockDifferentiator().addFuturePlainNodeFwd(ILUtils.copy(tree), null, false, ILUtils.usedVarsInExp(tree.down(1), null, true), new TapList<Tree>(tree.down(1), null), null, null, false, false, "Un-Allocate source var " + ILUtils.toString(tree.down(1), this.adEnv.curActivity()), true);
        if (hasBwdSweep && !this.adEnv.curUnitIsContext) {
            newTree = ILUtils.build(13, ILUtils.copy(tree.down(1)), newMallocTree);
            this.blockDifferentiator().addFuturePlainNodeBwd(newTree, null, false, null, new TapList<Tree>(tree.down(1), null), null, null, false, false, "Re-Allocate source var " + ILUtils.toString(tree.down(1), this.adEnv.curActivity()), true);
            RefDescriptor fwdLengthRefDescriptor = new RefDescriptor(((NewSymbolHolder)this.flowGraphDifferentiator().toFwdChunklengthVariable.head).makeNewRef(fwdSymbolTable), null, this.curBlock().symbolTable, fwdSymbolTable, null, null, false, null, this.curDiffUnit());
            RefDescriptor bwdLengthRefDescriptor = new RefDescriptor(((NewSymbolHolder)this.flowGraphDifferentiator().toChunklengthVariable.head).makeNewRef(bwdSymbolTable), null, this.curBlock().symbolTable, bwdSymbolTable, null, null, false, null, this.curDiffUnit());
            this.blockDifferentiator().prepareRestoreOperations(fwdLengthRefDescriptor, bwdLengthRefDescriptor, 0, fwdSymbolTable, bwdSymbolTable);
            fwdLengthRefDescriptor.mayProtectAccesses = false;
            this.blockDifferentiator().addFuturePlainNodeFwd(fwdLengthRefDescriptor.makePush(), null, false, null, null, null, null, false, true, "Store deallocated chunk length", false);
            bwdLengthRefDescriptor.mayProtectAccesses = false;
            this.blockDifferentiator().addFuturePlainNodeBwd(bwdLengthRefDescriptor.makePop(), null, false, null, null, null, null, false, true, "Retrieve deallocated chunk length", true);
        }
    }

    private Tree buildFullDimColons(Tree indices, boolean firstIndexOne) {
        Tree[] oldIndices = indices.children();
        TapList<Tree> newIndices = null;
        for (int i = oldIndices.length - 1; i >= 0; --i) {
            Tree newIndex;
            Tree oldIndex = oldIndices[i];
            if (oldIndex == null) {
                newIndex = null;
            } else {
                switch (oldIndex.opCode()) {
                    case 58: {
                        newIndex = ILUtils.copy(oldIndex);
                        break;
                    }
                    case 11: {
                        newIndex = ILUtils.build(58, ILUtils.copy(oldIndex.down(1)), ILUtils.copy(oldIndex.down(2)));
                        break;
                    }
                    default: {
                        newIndex = ILUtils.copy(oldIndex);
                        if (!firstIndexOne) {
                            newIndex = newIndex.opCode() == 101 ? ILUtils.build(101, newIndex.intValue() - 1) : ILUtils.build(177, newIndex, ILUtils.build(101, 1));
                        }
                        newIndex = ILUtils.build(58, ILUtils.build(101, firstIndexOne ? 1 : 0), newIndex);
                    }
                }
            }
            newIndices = new TapList<Tree>(newIndex, newIndices);
        }
        return ILUtils.build(70, newIndices);
    }
}

