/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.differentiation;

import fr.inria.tapenade.analysis.DataFlowAnalyzer;
import fr.inria.tapenade.differentiation.BlockDifferentiator;
import fr.inria.tapenade.differentiation.DifferentiationEnv;
import fr.inria.tapenade.differentiation.NewBlockGraph;
import fr.inria.tapenade.differentiation.NewBlockGraphArrow;
import fr.inria.tapenade.differentiation.VarRefDifferentiator;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.InstructionMask;
import fr.inria.tapenade.representation.IterDescriptor;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.RefDescriptor;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.Tree;

public final class NewBlockGraphNode {
    public String text = "unspecified text";
    public TapList<NewBlockGraphArrow> flow;
    public TapList<NewBlockGraphArrow> backFlow;
    public int rank;
    public int subOrder;
    public int nbDeps;
    protected Instruction srcInstruction;
    protected Instruction fromInclude;
    protected Instruction diffInstruction;
    protected TapList<Tree> plainTrees;
    protected Tree tree;
    protected InstructionMask whereMask;
    protected Tree assignedRef;
    protected Tree primRecv;
    protected int kind;
    protected boolean overwritesUsed = true;
    protected boolean multiDir;
    protected Tree diffValue;
    private Tree origTree;
    protected Tree preComments;
    protected Tree preCommentsBlock;

    protected NewBlockGraphNode(int kind, Tree tree, boolean multiDir, Instruction srcInstruction, InstructionMask whereMask) {
        this.kind = kind;
        this.tree = tree;
        if (tree != null) {
            this.plainTrees = new TapList<Tree>(tree, null);
        }
        this.multiDir = multiDir;
        this.srcInstruction = srcInstruction;
        this.whereMask = whereMask;
        this.origTree = srcInstruction == null ? null : srcInstruction.tree;
    }

    protected boolean interestingFuseWith(NewBlockGraphNode otherNode, NewBlockGraph thisGraph) {
        if (this.diffInstruction == null) {
            return (this.kind == 3 || this.kind == 2) && (otherNode.kind == 3 && !otherNode.overwritesUsed || otherNode.kind == 2) && this.assignedRef.equalsTree(otherNode.assignedRef) && NewSymbolHolder.sameNSH(this.assignedRef, otherNode.assignedRef) && this.multiDir == otherNode.multiDir && InstructionMask.equalMasks(this.whereMask, otherNode.whereMask) && (otherNode.kind != 2 || !thisGraph.adEnv.curDiffUnit.isFortran() || !ILUtils.isIfExpression(this.diffValue) || !ILUtils.isIfExpression(otherNode.diffValue)) || this.kind == 4 && otherNode.kind == 4 && this.whereMask == otherNode.whereMask && this.multiDir && otherNode.multiDir;
        }
        return this.diffInstruction.tree != null && otherNode.diffInstruction.tree != null && this.diffInstruction.whereMask() == otherNode.diffInstruction.whereMask() && this.multiDir == otherNode.multiDir;
    }

    protected boolean fuseWith(NewBlockGraphNode otherNode) {
        int i;
        if (this.diffInstruction == null) {
            if (otherNode.kind == 3) {
                return true;
            }
            if (otherNode.kind == 2) {
                this.diffValue = ILUtils.addProtectedExprs(this.diffValue, otherNode.diffValue);
                this.recomputeText();
                return false;
            }
            if (otherNode.kind == 4) {
                this.attachCommentsToTree();
                otherNode.attachCommentsToTree();
                this.plainTrees = TapList.append(this.plainTrees, otherNode.plainTrees);
                this.text = otherNode.text + ";" + this.text;
                return false;
            }
            return false;
        }
        Tree diffTree1 = this.diffInstruction.tree;
        Tree diffTree2 = otherNode.diffInstruction.tree;
        TapList<Tree> listTrees = null;
        if (diffTree2.opCode() != 26) {
            listTrees = new TapList<Tree>(diffTree2, null);
        } else {
            for (i = diffTree2.length(); i > 0; --i) {
                listTrees = new TapList<Tree>(diffTree2.cutChild(i), listTrees);
            }
        }
        if (diffTree1.opCode() != 26) {
            listTrees = new TapList<Tree>(diffTree1, listTrees);
        } else {
            for (i = diffTree1.length(); i > 0; --i) {
                listTrees = new TapList<Tree>(diffTree1.cutChild(i), listTrees);
            }
        }
        this.diffInstruction.tree = ILUtils.build(26, listTrees);
        return false;
    }

    protected boolean hasManyInstructions() {
        return this.plainTrees != null && this.plainTrees.tail != null;
    }

    protected void attachCommentsToTree() {
        if (this.plainTrees != null && this.plainTrees.tail == null) {
            Tree plainTree = (Tree)this.plainTrees.head;
            if (this.preComments != null) {
                plainTree.setAnnotation("preComments", this.preComments);
                this.preComments = null;
            }
            if (this.preCommentsBlock != null) {
                plainTree.setAnnotation("preCommentsBlock", this.preCommentsBlock);
                this.preCommentsBlock = null;
            }
        }
    }

    protected void gatherMultiInstructions(SymbolTable diffSymbolTable, Unit diffUnit, NewSymbolHolder dirIndexSymbolHolder, IterDescriptor multiDirIterDescriptor) {
        Tree gatheredTree = this.plainTrees == null ? null : (this.plainTrees.tail != null || this.multiDir ? ILUtils.build(26, this.plainTrees) : (Tree)this.plainTrees.head);
        if (this.multiDir && gatheredTree != null) {
            gatheredTree = ILUtils.build(119, ILUtils.build(136), ILUtils.build(136), multiDirIterDescriptor.buildDoHeaderTree(diffSymbolTable, diffUnit, true), gatheredTree);
        }
        Instruction newI = new Instruction(gatheredTree, null);
        if (this.multiDir && dirIndexSymbolHolder != null) {
            dirIndexSymbolHolder.declareUsageInstruction(newI);
        }
        this.tree = gatheredTree;
    }

    protected void buildInstruction(SymbolTable srcSymbolTable, SymbolTable bwdSymbolTable, DifferentiationEnv adEnv, Unit diffUnit) {
        if (this.kind == 3 || this.kind == 2) {
            VarRefDifferentiator varRefDifferentiator = adEnv.varRefDifferentiator;
            WrapperTypeSpec assignedType = srcSymbolTable.typeOf(this.primRecv);
            if (this.diffValue == null && this.kind == 2) {
                this.tree = null;
            } else if (this.diffValue == null) {
                if (this.multiDir) {
                    varRefDifferentiator.multiDirMaxIterDescriptor.setJustAnIndex(true);
                }
                this.tree = adEnv.blockDifferentiator.makeDiffInitialization(this.primRecv, srcSymbolTable, bwdSymbolTable, null, null, false, null, true);
                if (this.multiDir) {
                    varRefDifferentiator.multiDirMaxIterDescriptor.setJustAnIndex(false);
                }
            } else {
                boolean needOmpAtomic = false;
                if (TapEnv.doOpenMP() && this.kind != 3) {
                    SymbolDecl primalSymbolDecl;
                    Tree diffBaseTree = ILUtils.baseTree(this.assignedRef);
                    NewSymbolHolder lhsNewSymbolHolder = diffBaseTree == null ? null : NewSymbolHolder.getNewSymbolHolder(diffBaseTree);
                    SymbolDecl symbolDecl = primalSymbolDecl = lhsNewSymbolHolder == null ? null : lhsNewSymbolHolder.derivationFrom;
                    if (primalSymbolDecl instanceof VariableDecl) {
                        BoolVector reductionAdjointZones;
                        TapIntList primalZones = ZoneInfo.listAllZones(primalSymbolDecl.zones(), false);
                        BoolVector sharedZones = TapEnv.ompClauseAnalyzer().getSharedZonesOfBlock(adEnv.curBlock);
                        needOmpAtomic = DataFlowAnalyzer.intersectsExtendedDeclared(sharedZones, adEnv.curVectorMap, 0, primalZones, null, adEnv.curSymbolTable(), null);
                        if (needOmpAtomic && (reductionAdjointZones = BlockDifferentiator.getOnlyReadSmallActivePrimals(adEnv.curBlock)) != null && DataFlowAnalyzer.containsExtendedDeclared(reductionAdjointZones, adEnv.curVectorMap, 0, primalZones, null, adEnv.curSymbolTable(), null)) {
                            needOmpAtomic = false;
                            TapList<String> forcedScopingNames = BlockDifferentiator.getForcedScopingNames(adEnv.curBlock);
                            if (!TapList.containsString(forcedScopingNames, primalSymbolDecl.symbol, !adEnv.curUnit().isFortran())) {
                                lhsNewSymbolHolder.prepareSumReductionClause(adEnv.curBlock);
                            }
                        }
                    }
                }
                if (this.kind == 3) {
                    this.tree = ILUtils.setToProtectedExpr(adEnv.curDiffUnit.language(), this.assignedRef, this.diffValue, assignedType);
                } else if (TapEnv.associationByAddress()) {
                    this.tree = ILUtils.incrementByProtectedExpr(adEnv.curDiffUnit.language(), this.assignedRef, this.diffValue, needOmpAtomic);
                } else {
                    Tree rootIdent = ILUtils.baseTree(this.primRecv);
                    Tree diffRootIdent = varRefDifferentiator.diffSymbolTree(adEnv.curActivity(), rootIdent, bwdSymbolTable, true, false, false, null, false, 2, 2, 0, rootIdent);
                    RefDescriptor lhsRefDescriptor = new RefDescriptor(this.primRecv, null, srcSymbolTable, bwdSymbolTable, null, diffRootIdent, true, this.multiDir ? varRefDifferentiator.multiDirIterDescriptor : null, diffUnit);
                    RefDescriptor incrRefDescriptor = new RefDescriptor(this.diffValue, null, srcSymbolTable, bwdSymbolTable, null, null, true, null, diffUnit);
                    lhsRefDescriptor.setCompanionVarDescriptor(incrRefDescriptor);
                    if (this.multiDir) {
                        varRefDifferentiator.multiDirIterDescriptor.setJustAnIndex(true);
                    }
                    lhsRefDescriptor.prepareForAssignOrNormDiff(incrRefDescriptor, diffUnit, null, !diffUnit.isFortran());
                    if (this.multiDir) {
                        varRefDifferentiator.multiDirIterDescriptor.setJustAnIndex(false);
                    }
                    lhsRefDescriptor.mayProtectAccesses = false;
                    this.tree = lhsRefDescriptor.makeIncrement(incrRefDescriptor, needOmpAtomic);
                }
            }
        }
        if (this.whereMask != null && this.whereMask.isEmpty()) {
            this.whereMask = null;
        }
        this.diffInstruction = new Instruction(this.tree);
        this.diffInstruction.preComments = this.preComments;
        this.diffInstruction.preCommentsBlock = this.preCommentsBlock;
        this.diffInstruction.setPosition(this.srcInstruction);
        if (this.whereMask != null && !this.whereMask.isEmpty()) {
            this.diffInstruction.setWhereMask(this.whereMask);
        }
        if (this.fromInclude != null) {
            this.diffInstruction.setFromIncludeCopy(this.fromInclude, true);
        }
        if (this.origTree != null && this.tree != null) {
            TapEnv.setSourceCodeCorrespondence(this.origTree, this.tree, true, true);
        }
    }

    protected void recomputeText() {
        switch (this.kind) {
            case 4: {
                this.text = ILUtils.toString(this.tree);
                break;
            }
            case 2: {
                this.text = ILUtils.toString(this.assignedRef) + "+=" + ILUtils.toString(this.diffValue);
                break;
            }
            case 3: {
                this.text = ILUtils.toString(this.assignedRef) + ":=" + ILUtils.toString(this.diffValue);
                break;
            }
        }
        if (this.text.length() > 53) {
            this.text = this.text.substring(0, 50) + "...";
        }
    }

    public String toString() {
        String contents = this.diffInstruction != null ? "Diff Instruction:" + this.diffInstruction : (this.tree != null ? "Diff Tree:" + ILUtils.toString(this.tree) : (this.kind == 3 || this.kind == 2 ? (this.kind == 3 ? "Set" : "Incr") + " diff of " + ILUtils.toString(this.primRecv) + " to " + ILUtils.toString(this.diffValue) : "Empty!"));
        return "[" + this.subOrder + "], " + contents;
    }
}

