/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.differentiation;

import fr.inria.tapenade.analysis.ADActivityAnalyzer;
import fr.inria.tapenade.analysis.ADTBRAnalyzer;
import fr.inria.tapenade.analysis.ActivityPattern;
import fr.inria.tapenade.analysis.DataFlowAnalyzer;
import fr.inria.tapenade.analysis.ReqExplicit;
import fr.inria.tapenade.differentiation.BlockDifferentiator;
import fr.inria.tapenade.differentiation.CallGraphDifferentiator;
import fr.inria.tapenade.differentiation.DiffAssignmentNode;
import fr.inria.tapenade.differentiation.DifferentiationEnv;
import fr.inria.tapenade.differentiation.FlowGraphDifferentiator;
import fr.inria.tapenade.differentiation.SplitForSave;
import fr.inria.tapenade.differentiation.UnitDiffInfo;
import fr.inria.tapenade.differentiation.VarRefDifferentiator;
import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.ArrayTypeSpec;
import fr.inria.tapenade.representation.CallArrow;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.CompositeTypeSpec;
import fr.inria.tapenade.representation.Directive;
import fr.inria.tapenade.representation.FieldDecl;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.FunctionTypeSpec;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.IterDescriptor;
import fr.inria.tapenade.representation.MPIcallInfo;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.PrimitiveTypeSpec;
import fr.inria.tapenade.representation.RefDescriptor;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.ToObject;
import fr.inria.tapenade.utils.Tree;

public class ProcedureCallDifferentiator {
    private final DifferentiationEnv adEnv;

    private CallGraphDifferentiator callGraphDifferentiator() {
        return this.adEnv.callGraphDifferentiator;
    }

    private FlowGraphDifferentiator flowGraphDifferentiator() {
        return this.adEnv.flowGraphDifferentiator;
    }

    private BlockDifferentiator blockDifferentiator() {
        return this.adEnv.blockDifferentiator;
    }

    private VarRefDifferentiator varRefDifferentiator() {
        return this.adEnv.varRefDifferentiator;
    }

    private boolean multiDirMode() {
        return this.adEnv.multiDirMode;
    }

    private Unit curDiffUnit() {
        return this.adEnv.curDiffUnit;
    }

    private Unit curFwdDiffUnit() {
        return this.adEnv.curFwdDiffUnit;
    }

    private int curDiffUnitSort() {
        return this.adEnv.curDiffUnitSort;
    }

    private int curDiffVarSort() {
        return this.adEnv.curDiffVarSort;
    }

    private int curNSEZ() {
        return this.adEnv.curNSEZ;
    }

    private int[] curVectorMap() {
        return this.adEnv.curVectorMap;
    }

    private int[] curDiffVectorMap() {
        return this.adEnv.curDiffVectorMap;
    }

    private int[] curPtrVectorMap() {
        return this.adEnv.curPtrVectorMap;
    }

    protected ProcedureCallDifferentiator(DifferentiationEnv adEnv) {
        this.adEnv = adEnv;
    }

    protected void buildDiffInstructions(Tree callTree, Tree resultTree, int differentiationMode, Unit calledUnit, ActivityPattern calledActivity, boolean mustDiffCall, boolean callIsLive, boolean mustSaveTBRBeforeInstr, boolean normalCheckpointedCall, boolean splitAdjointCall, SymbolTable fwdSymbolTable, SymbolTable bwdSymbolTable, BoolVector beforeActiv, BoolVector afterActiv, BoolVector beforeUseful, BoolVector afterUseful, BoolVector beforeReqX, BoolVector afterReqX, BoolVector beforeAvlX) {
        Tree dbadTree;
        boolean callContextToContext;
        if (TapEnv.associationByAddress()) {
            this.blockDifferentiator().updateAAInstructionMask(this.adEnv.curInstruction(), this.adEnv.curSymbolTable(), this.adEnv.curFwdSymbolTable);
        }
        TapList<Tree> beforeActivTrees = null;
        TapList<Tree> afterActivTrees = null;
        Tree debugCallArgs = null;
        int[] srcBlockInfoMap = DataFlowAnalyzer.makeMap3(this.adEnv.curUnit(), this.adEnv.curBlock, this.adEnv.diffKind);
        boolean bl = callContextToContext = this.adEnv.curUnitIsContext && !this.adEnv.activeCalledFromContext;
        if (mustDiffCall && !callContextToContext && TapEnv.dbadMode() != 0 && calledUnit.isStandard()) {
            String calledName;
            Directive tracedCallInstructionDir = this.adEnv.curInstruction().hasDirective(19);
            TapList<Tree> args = null;
            if (TapEnv.dbadMode() == 1) {
                Tree forcedOkHere = null;
                if (tracedCallInstructionDir != null && tracedCallInstructionDir.arguments.length > 1) {
                    forcedOkHere = ILUtils.cleanBoolCopy(tracedCallInstructionDir.arguments[1], this.curDiffUnit());
                }
                if (forcedOkHere == null) {
                    forcedOkHere = ILUtils.build(101, 0);
                }
                args = new TapList<Tree>(forcedOkHere, args);
            }
            if (TapEnv.dbadMode() == 1 || this.curDiffUnitSort() == 2) {
                Tree okHere = null;
                if (tracedCallInstructionDir != null && tracedCallInstructionDir.arguments.length > 0) {
                    okHere = ILUtils.cleanBoolCopy(tracedCallInstructionDir.arguments[0], this.curDiffUnit());
                }
                if (okHere == null) {
                    okHere = ILUtils.build(101, 0);
                }
                args = new TapList<Tree>(okHere, args);
            }
            if ((calledName = ILUtils.getCalledNameString(callTree)).charAt(0) == '#') {
                calledName = calledName.substring(1, calledName.length() - 1);
            }
            Tree funcName = ILUtils.build(175, this.curDiffUnit().isFortran() ? calledName.toUpperCase() : calledName);
            if (this.curDiffUnit().isFortran()) {
                funcName = ILUtils.concatWithNull(funcName);
            }
            args = new TapList<Tree>(funcName, args);
            debugCallArgs = ILUtils.build(70, args);
            beforeActivTrees = this.blockDifferentiator().collectTrueTrees(beforeActiv, srcBlockInfoMap, this.adEnv.curSymbolTable());
            afterActivTrees = this.blockDifferentiator().collectTrueTrees(afterActiv, srcBlockInfoMap, this.adEnv.curSymbolTable());
            String utilityFunctionSuffix = TapEnv.dbadMode() == 1 ? "Tgt_call" : (differentiationMode == 1 ? "Fwd_call" : "Bwd_exit");
            dbadTree = ILUtils.buildCall(ILUtils.tapenadeUtilityFunctionName(this.curDiffUnit(), "adDebug" + utilityFunctionSuffix), TapEnv.dbadMode() == 1 || differentiationMode == 1 ? debugCallArgs : ILUtils.build(70));
            if (differentiationMode == 1) {
                this.blockDifferentiator().addFuturePlainNodeFwd(dbadTree, null, false, null, null, null, null, false, true, "Debug-instrument before calling tangent-diff procedure", false);
            } else {
                this.blockDifferentiator().addFuturePlainNodeBwd(dbadTree, null, false, null, null, null, null, false, true, "Debug-instrument after calling adjoint-diff procedure", false);
            }
            if (TapEnv.dbadMode() == -1) {
                dbadTree = this.flowGraphDifferentiator().placeDebugADTests(this.curDiffUnit(), callTree, beforeActiv, srcBlockInfoMap, -2, this.adEnv.curSymbolTable(), this.adEnv.curSymbolTable().declaredZonesNb(this.adEnv.diffKind), "beforeCall", null, ILUtils.build(27, this.curDiffUnit().isCorMore() ? "1" : "TRUE"), ILUtils.build(27, this.curDiffUnit().isCorMore() ? "0" : "FALSE"));
                if (differentiationMode == 1) {
                    this.blockDifferentiator().addFuturePlainNodeFwd(dbadTree, null, false, null, beforeActivTrees, null, beforeActivTrees, false, true, "Debug-instrument actives before calling tangent-diff procedure", false);
                } else {
                    this.blockDifferentiator().addFuturePlainNodeBwd(dbadTree, null, false, null, beforeActivTrees, null, beforeActivTrees, false, true, "Debug-instrument actives after calling adjoint-diff procedure", false);
                }
            }
        }
        if (differentiationMode == 1) {
            if (callContextToContext) {
                this.buildContextCallTangentNodes(callTree, resultTree, calledUnit, calledActivity, mustDiffCall, fwdSymbolTable);
            } else {
                this.buildCallTangentNodes(callTree, resultTree, calledUnit, calledActivity, mustDiffCall, fwdSymbolTable, beforeActiv, afterActiv, afterUseful, beforeReqX, afterReqX);
            }
        } else if (differentiationMode == -1 || differentiationMode == -2) {
            this.buildCallAdjointNodes(callTree, resultTree, calledUnit, calledActivity, mustDiffCall, callIsLive, mustSaveTBRBeforeInstr, normalCheckpointedCall, splitAdjointCall, differentiationMode == -1, fwdSymbolTable, bwdSymbolTable, beforeActiv, afterActiv);
        }
        if (mustDiffCall && !callContextToContext && TapEnv.dbadMode() != 0 && calledUnit.isStandard()) {
            if (TapEnv.dbadMode() == -1) {
                dbadTree = this.flowGraphDifferentiator().placeDebugADTests(this.curDiffUnit(), callTree, afterActiv, srcBlockInfoMap, 2, this.adEnv.curSymbolTable(), this.adEnv.curSymbolTable().declaredZonesNb(this.adEnv.diffKind), "afterCall", null, ILUtils.build(27, this.curDiffUnit().isCorMore() ? "1" : "TRUE"), ILUtils.build(27, this.curDiffUnit().isCorMore() ? "0" : "FALSE"));
                if (differentiationMode == 1) {
                    this.blockDifferentiator().addFuturePlainNodeFwd(dbadTree, null, false, null, afterActivTrees, null, afterActivTrees, false, true, "Debug-instrument actives after calling tangent-diff procedure", false);
                } else {
                    this.blockDifferentiator().addFuturePlainNodeBwd(dbadTree, null, false, null, afterActivTrees, null, afterActivTrees, false, true, "Debug-instrument actives before calling adjoint-diff procedure", false);
                }
            }
            String utilityFunctionSuffix = TapEnv.dbadMode() == 1 ? "Tgt_exit" : (differentiationMode == 1 ? "Fwd_exit" : "Bwd_call");
            dbadTree = ILUtils.buildCall(ILUtils.tapenadeUtilityFunctionName(this.curDiffUnit(), "adDebug" + utilityFunctionSuffix), TapEnv.dbadMode() == 1 || differentiationMode == 1 ? ILUtils.build(70) : debugCallArgs);
            if (differentiationMode == 1) {
                this.blockDifferentiator().addFuturePlainNodeFwd(dbadTree, null, false, null, null, null, null, false, true, "Debug-instrument after calling tangent-diff procedure", false);
            } else {
                this.blockDifferentiator().addFuturePlainNodeBwd(dbadTree, null, false, null, null, null, null, false, true, "Debug-instrument before calling adjoint-diff procedure", false);
            }
        }
    }

    private void buildCallTangentNodes(Tree callTree, Tree resultTree, Unit calledUnit, ActivityPattern calledActivity, boolean mustDiffCall, SymbolTable fwdSymbolTable, BoolVector beforeActiv, BoolVector afterActiv, BoolVector afterUseful, BoolVector beforeReqX, BoolVector afterReqX) {
        Tree initTree;
        Tree diffTree;
        boolean isActiveResult = false;
        boolean isActiveRecipient = false;
        UnitDiffInfo calledDiffInfo = this.callGraphDifferentiator().getUnitDiffInfo(calledUnit);
        if (resultTree != null) {
            BoolVector unitExitActivity;
            TapList<?> writtenZonesTree = this.adEnv.curSymbolTable().treeOfZonesOfValue(resultTree, null, this.adEnv.curInstruction(), null);
            BoolVector boolVector = unitExitActivity = calledActivity != null ? calledActivity.exitActivity() : null;
            if (unitExitActivity == null) {
                WrapperTypeSpec resultType = calledUnit.functionTypeSpec().returnType;
                isActiveResult = resultType == null || TypeSpec.isDifferentiableType(resultType.wrappedType, this.adEnv.diffKind);
            } else {
                TapIntList resultZones = calledUnit.publicRankOfResult();
                while (!isActiveResult && resultZones != null) {
                    isActiveResult = ADActivityAnalyzer.isActiveArg(resultZones.head, unitExitActivity, null, this.adEnv.diffKind);
                    resultZones = resultZones.tail;
                }
            }
            TapIntList writtenZones = ZoneInfo.listAllZones(writtenZonesTree, true);
            boolean writtenTmp = TapIntList.intersects(writtenZones, this.adEnv.toActiveTmpZones.tail);
            TapIntList writtenDiffKindVectorIndices = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(writtenZones, this.adEnv.diffKind, this.curDiffVectorMap(), this.adEnv.curSymbolTable(), calledUnit);
            isActiveRecipient = afterActiv != null && !this.adEnv.activeCalledFromContext && (writtenTmp || afterActiv.intersects(writtenDiffKindVectorIndices));
            DataFlowAnalyzer.buildInfoBoolTreeOfDeclaredZones(writtenZonesTree, afterReqX, this.curVectorMap(), null, 0, this.adEnv.curSymbolTable());
        }
        TapPair<Object, Object> refsRW = new TapPair<Object, Object>(null, null);
        TapPair<Object, Object> diffRefsRW = new TapPair<Object, Object>(null, null);
        TapList<Object> toNecessaryInitsUS = new TapList<Object>(null, null);
        TapList<Object> toNecessaryInitsDS = new TapList<Object>(null, null);
        TapList<Object> toNecessaryTmpResultAssigns = new TapList<Object>(null, null);
        if (this.adEnv.curUnitIsActiveUnit && TapEnv.spareDiffReinitializations() && resultTree != null) {
            this.blockDifferentiator().buildDiffPreInitsForTangent(resultTree, callTree, null, beforeActiv, afterActiv, beforeReqX, afterReqX);
        }
        if (mustDiffCall) {
            Tree newArg;
            FunctionTypeSpec calledFunctionTypeSpec = (FunctionTypeSpec)callTree.getAnnotation("functionTypeSpec");
            if (calledFunctionTypeSpec == null) {
                calledFunctionTypeSpec = calledUnit.functionTypeSpec();
            }
            CallArrow callArrow = CallGraph.getCallArrow(this.adEnv.curUnit(), calledUnit);
            int nDZ = this.adEnv.curSymbolTable().declaredZonesNb(0);
            int nDdZ = this.adEnv.curSymbolTable().declaredZonesNb(this.adEnv.diffKind);
            int nSEdZ = this.adEnv.curUnit().sideEffectZonesNb(this.adEnv.diffKind);
            Tree[] actualArgs = ILUtils.getArguments(callTree).children();
            int nbArgs = actualArgs.length;
            if (nbArgs > calledUnit.functionTypeSpec().argumentsTypes.length) {
                nbArgs = calledUnit.functionTypeSpec().argumentsTypes.length;
            }
            boolean[] formalArgsActivity = null;
            if (calledDiffInfo != null) {
                formalArgsActivity = calledDiffInfo.getUnitFormalArgsActivityS(calledActivity);
            }
            if (formalArgsActivity == null) {
                formalArgsActivity = ADActivityAnalyzer.formalArgsActivity(calledActivity);
            }
            TapTriplet<Unit, BoolVector, BoolVector>[] varFunctionInfos = calledActivity == null ? null : calledActivity.varFunctionADActivities();
            BoolVector formalCallActive = new BoolVector(nSEdZ + nDdZ);
            BoolVector formalExitActive = new BoolVector(nSEdZ + nDdZ);
            BoolVector callR = new BoolVector(this.curNSEZ() + nDZ);
            BoolVector callW = new BoolVector(this.curNSEZ() + nDZ);
            TapList[] formalArgsEntryActive = DataFlowAnalyzer.propagateDataToCaller(calledActivity.callActivity(), null, null, actualArgs.length, formalCallActive, this.curDiffVectorMap(), null, this.adEnv.curInstruction(), callArrow, true, true, this.adEnv.diffKind);
            TapList[] formalArgsExitActive = DataFlowAnalyzer.propagateDataToCaller(calledActivity.exitActivity(), null, null, actualArgs.length, formalExitActive, this.curDiffVectorMap(), null, this.adEnv.curInstruction(), callArrow, true, true, this.adEnv.diffKind);
            BoolVector actualAfterUseful = null;
            TapList<Boolean> actualResultUseful = null;
            TapList[] actualArgsAfterUseful = null;
            if (afterUseful != null) {
                actualAfterUseful = afterUseful.copy();
                actualResultUseful = new TapList<Boolean>(Boolean.FALSE, null);
                actualArgsAfterUseful = DataFlowAnalyzer.propagateDataToCallee(actualAfterUseful, this.curDiffVectorMap(), resultTree, actualArgs, actualResultUseful, this.adEnv.toActiveTmpZones.tail, this.adEnv.curInstruction(), callArrow, true, this.adEnv.diffKind);
            }
            TapList[] paramsR = DataFlowAnalyzer.propagateDataToCaller(calledUnit.unitInOutPossiblyR(), null, null, actualArgs.length, callR, this.curVectorMap(), null, this.adEnv.curInstruction(), callArrow, true, true, 0);
            TapList[] paramsW = DataFlowAnalyzer.propagateDataToCaller(calledUnit.unitInOutPossiblyW(), null, null, actualArgs.length, callW, this.curVectorMap(), null, this.adEnv.curInstruction(), callArrow, true, false, 0);
            TapList<Tree> newArgs = null;
            this.varRefDifferentiator().pushDiffContext(1);
            TapList<IterDescriptor> iterators = null;
            Unit diffCalledUnit = calledDiffInfo == null ? null : calledDiffInfo.getTangent(calledActivity);
            int firstOrderingProblem = ProcedureCallDifferentiator.findNameEqOrNone(callTree);
            if (this.multiDirMode()) {
                iterators = new TapList<IterDescriptor>(this.varRefDifferentiator().multiDirIterDescriptor, null);
                newArg = this.varRefDifferentiator().buildDirNumberReference(fwdSymbolTable);
                if (firstOrderingProblem > -1) {
                    Tree argName = this.varRefDifferentiator().buildDirNumberReference(fwdSymbolTable);
                    newArg = ILUtils.build(132, argName, newArg);
                }
                newArgs = new TapList<Tree>(newArg, newArgs);
            }
            if (!TapEnv.associationByAddress()) {
                Tree tmpResultTree = null;
                if (this.zonesOverlapCall(resultTree, callTree)) {
                    NewSymbolHolder tmpResultSymbolHolder = new NewSymbolHolder(TapEnv.disambigNewName("tmpresult"));
                    WrapperTypeSpec returnTypeSpecCallee = callTree.getAnnotation("arrayReturnTypeSpec") != null ? (WrapperTypeSpec)callTree.getAnnotation("arrayReturnTypeSpec") : calledFunctionTypeSpec.returnType;
                    WrapperTypeSpec returnTypeSpecCaller = this.adEnv.curSymbolTable().typeOf(resultTree);
                    tmpResultSymbolHolder.setHintRootTree(resultTree);
                    tmpResultSymbolHolder.setHintArrayTreeForCallSize(resultTree);
                    String hintNameInIdent = "tmpresult";
                    String hintNameInText = "tmpresult";
                    Tree hintTreeInSize = null;
                    if (tmpResultSymbolHolder.hintRootTree != null) {
                        hintNameInIdent = ILUtils.buildNameInIdent(tmpResultSymbolHolder.hintRootTree);
                        hintNameInText = ILUtils.buildNameInText(tmpResultSymbolHolder.hintRootTree);
                    }
                    if (tmpResultSymbolHolder.hintArrayTreeForCallSize != null) {
                        hintTreeInSize = ILUtils.buildSizeArgument1(tmpResultSymbolHolder.hintArrayTreeForCallSize, this.adEnv.curSymbolTable());
                    }
                    WrapperTypeSpec fusedReturnTypeSpec = WrapperTypeSpec.preciseDimensions(returnTypeSpecCaller, returnTypeSpecCallee, new TapList<Object>(null, null), this.adEnv.curSymbolTable());
                    fusedReturnTypeSpec = fusedReturnTypeSpec.checkNoneDimensionsOfNewSH(hintNameInText, hintNameInIdent, hintTreeInSize, fwdSymbolTable, tmpResultSymbolHolder);
                    tmpResultSymbolHolder.setAsVariable(fusedReturnTypeSpec, null);
                    tmpResultSymbolHolder.zone = this.adEnv.allocateTmpZone();
                    tmpResultSymbolHolder.declarationLevelMustInclude(fwdSymbolTable);
                    tmpResultTree = tmpResultSymbolHolder.makeNewRef(fwdSymbolTable);
                }
                if (resultTree != null && calledUnit.isAFunction()) {
                    if (formalArgsActivity[formalArgsActivity.length - 1] && !this.varRefDifferentiator().diffFunctionIsFunction(calledUnit)) {
                        if (tmpResultTree != null) {
                            this.varRefDifferentiator().pushDiffContext(0);
                            newArg = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), resultTree, fwdSymbolTable, false, resultTree, false, true, null);
                            Tree tmpDiffResultTree = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), tmpResultTree, fwdSymbolTable, false, tmpResultTree, false, true, null);
                            toNecessaryTmpResultAssigns.placdl(new TapPair<TapList<Tree>, Tree>(new TapList<Tree>(resultTree, null), ILUtils.build(13, newArg, tmpDiffResultTree)));
                            this.varRefDifferentiator().popDiffContext();
                            newArg = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), tmpResultTree, fwdSymbolTable, false, resultTree, false, true, null);
                        } else {
                            newArg = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), resultTree, fwdSymbolTable, false, resultTree, false, true, null);
                        }
                        if (firstOrderingProblem > -1) {
                            Tree argName = this.getNewParamName(-1, calledUnit, true, 1, diffCalledUnit);
                            newArg = ILUtils.build(132, argName, newArg);
                        }
                        newArgs = new TapList<Tree>(newArg, newArgs);
                        diffRefsRW.second = ILUtils.addTreeInList(resultTree, (TapList)diffRefsRW.second);
                    }
                    newArg = ILUtils.copy(resultTree);
                    if (tmpResultTree != null) {
                        toNecessaryTmpResultAssigns.placdl(new TapPair<Object, Tree>(null, ILUtils.build(13, newArg, tmpResultTree)));
                        newArg = ILUtils.copy(tmpResultTree);
                    }
                    if (this.curDiffUnit().isC()) {
                        if (diffCalledUnit != null && diffCalledUnit.functionTypeSpec() != null) {
                            int length = diffCalledUnit.functionTypeSpec().argumentsTypes.length;
                            if (this.multiDirMode()) {
                                --length;
                            }
                            if (TypeSpec.isA(diffCalledUnit.functionTypeSpec().argumentsTypes[length - 1], 6) || this.adEnv.curUnit().passesByValue(-1, this.adEnv.curUnit().language())) {
                                VariableDecl resultVar;
                                newArg = ILUtils.build(3, newArg);
                                String varName = ILUtils.baseName(resultTree);
                                if (varName != null && (resultVar = fwdSymbolTable.getVariableDecl(varName)) != null && resultVar.extraInfo() != null) {
                                    TapList<String> extraInfo = TapList.cleanExtraInfoValue(resultVar.extraInfo(), "register");
                                    resultVar.setExtraInfo(extraInfo);
                                    Instruction instr = fwdSymbolTable.declarationsBlock.getOperatorDeclarationInstruction(resultVar, 194, fwdSymbolTable);
                                    if (instr != null && instr.tree.down(2).opCode() == 127 && instr.containsModifiers("register")) {
                                        ILUtils.peelModifier(instr.tree, "register");
                                    }
                                }
                            }
                        } else if (calledUnit.functionTypeSpec().argumentsTypes.length != 0) {
                            newArg = ILUtils.build(3, newArg);
                        }
                    }
                    if (firstOrderingProblem > -1) {
                        Tree argName = this.getNewParamName(-1, calledUnit, false, -1, null);
                        newArg = ILUtils.build(132, argName, newArg);
                    }
                    newArgs = new TapList<Tree>(newArg, newArgs);
                    refsRW.first = ILUtils.usedVarsInExp(resultTree, (TapList)refsRW.first, false);
                    refsRW.second = ILUtils.addTreeInList(resultTree, (TapList)refsRW.second);
                } else if (resultTree == null && calledUnit.isAFunction()) {
                    NewSymbolHolder emptyResultSymbolHolder = new NewSymbolHolder(TapEnv.disambigNewName("result"));
                    emptyResultSymbolHolder.setAsVariable(calledFunctionTypeSpec.returnType, null);
                    emptyResultSymbolHolder.zone = this.adEnv.allocateTmpZone();
                    newArg = emptyResultSymbolHolder.makeNewRef(fwdSymbolTable);
                    Tree baseInitTree = emptyResultSymbolHolder.makeNewRef(fwdSymbolTable);
                    TapList<Tree> diffWrittenTrees = new TapList<Tree>(baseInitTree, null);
                    Tree diffInitTree = this.blockDifferentiator().makeDiffInitialization(baseInitTree, this.adEnv.curSymbolTable(), fwdSymbolTable, null, null, false, null, true);
                    if (diffInitTree != null) {
                        toNecessaryInitsUS.placdl(new TapPair<TapList<Tree>, Tree>(diffWrittenTrees, diffInitTree));
                    }
                    newArg = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), newArg, fwdSymbolTable, this.adEnv.curUnit().isFortran() && !this.multiDirMode(), newArg, false, true, null);
                    if (this.curDiffUnit().isC()) {
                        newArg = ILUtils.build(3, newArg);
                    }
                    newArgs = new TapList<Tree>(newArg, newArgs);
                }
            }
            TapList<ZoneInfo> zonesToDiffInitUS = null;
            TapList<Tree> treesToDiffInitDS = null;
            for (int i = nbArgs - 1; i >= 0; --i) {
                Tree actualArg = actualArgs[i];
                if (this.adEnv.curSymbolTable().identIsAFunction(actualArg)) {
                    if (!TapEnv.doActivity() || varFunctionInfos != null && varFunctionInfos[i] != null) {
                        TapList<ActivityPattern> functionActivities = null;
                        SymbolDecl funcDecl = this.adEnv.curSymbolTable().getSymbolDecl(ILUtils.getIdentString(actualArgs[i]));
                        if (funcDecl instanceof FunctionDecl) {
                            functionActivities = ((FunctionDecl)this.adEnv.curSymbolTable().getSymbolDecl((String)ILUtils.getIdentString((Tree)actualArgs[i]))).unit().specificInfoAD;
                        }
                        newArg = this.varRefDifferentiator().diffSymbolTree(functionActivities != null ? (ActivityPattern)functionActivities.head : null, actualArg, fwdSymbolTable, false, true, false, null, false, 1, 1, 0, null);
                        newArg.setAnnotation("isFunctionName", Boolean.TRUE);
                        newArgs = new TapList<Tree>(newArg, newArgs);
                    }
                } else if (i < formalArgsActivity.length - 1 && formalArgsActivity[i] && actualArg.opCode() != 136) {
                    WrapperTypeSpec formalArgType = calledFunctionTypeSpec.argumentsTypes[i];
                    Tree newActualArg = actualArg;
                    if (TypeSpec.isA(formalArgType, 6) || ILUtils.isAWritableIdentVarRef(actualArg, this.adEnv.curSymbolTable())) {
                        diffTree = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), actualArg, fwdSymbolTable, false, actualArg, false, true, null);
                    } else {
                        ToObject<Tree> toActualArg = new ToObject<Tree>(actualArg);
                        diffTree = this.blockDifferentiator().tangentDiffExpr(toActualArg, beforeActiv, refsRW, diffRefsRW);
                        newActualArg = toActualArg.obj();
                    }
                    boolean addDiffIntoRW = diffTree != null;
                    boolean diffTreeIsDummyVar = false;
                    if (diffTree == null) {
                        if (this.multiDirMode() || ILUtils.isAWritableVarRef(actualArg, this.adEnv.curSymbolTable()) || formalArgType != null && !formalArgType.isScalar()) {
                            if (TypeSpec.isA(formalArgType, 10)) {
                                formalArgType = this.adEnv.realTypeSpec;
                            }
                            if (formalArgType != null && formalArgType.wrappedType != null) {
                                NewSymbolHolder dummySymbolHolder = new NewSymbolHolder(TapEnv.disambigNewName("dummyzerodiff"));
                                WrapperTypeSpec differentiableTypeSpec = this.adEnv.curSymbolTable().typeOf(actualArg);
                                if (!formalArgType.isIntegerBase()) {
                                    differentiableTypeSpec = WrapperTypeSpec.intToReal(this.adEnv.curSymbolTable().typeOf(actualArg), new TapList<Object>(null, null), this.adEnv.curSymbolTable());
                                }
                                WrapperTypeSpec fusedArgType = WrapperTypeSpec.preciseDimensions(differentiableTypeSpec, formalArgType, new TapList<Object>(null, null), this.adEnv.curSymbolTable());
                                dummySymbolHolder.setAsVariable(fusedArgType, null);
                                dummySymbolHolder.setHintArrayTreeForCallSize(newActualArg);
                                dummySymbolHolder.zone = this.adEnv.allocateTmpZone();
                                actualArg = dummySymbolHolder.makeNewRef(fwdSymbolTable);
                                diffTree = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), actualArg, fwdSymbolTable, this.adEnv.curUnit().isFortran() && !this.multiDirMode(), actualArg, false, true, ILUtils.copy(actualArgs[i]));
                                diffRefsRW.first = ILUtils.addTreeInList(actualArg, (TapList)diffRefsRW.first);
                                Tree baseInitTree = dummySymbolHolder.makeNewRef(fwdSymbolTable);
                                TapList<Tree> diffWrittenTrees = new TapList<Tree>(baseInitTree, null);
                                Tree diffInitTree = this.makeDiffInitializationOfCallArgument(baseInitTree, actualArgs[i], fwdSymbolTable, fusedArgType, formalArgType, null, false, null, true);
                                if (diffInitTree != null) {
                                    toNecessaryInitsUS.placdl(new TapPair<TapList<Tree>, Tree>(diffWrittenTrees, diffInitTree));
                                }
                                diffTreeIsDummyVar = true;
                            }
                        } else if (formalArgType != null && formalArgType.wrappedType != null) {
                            diffTree = formalArgType.wrappedType.buildConstantZero();
                        }
                        if (diffTree == null) {
                            diffTree = PrimitiveTypeSpec.buildRealConstantZero();
                        }
                    }
                    if (firstOrderingProblem != -1 && (i >= firstOrderingProblem || actualArg.getAnnotation("sourcetree") != null)) {
                        Tree argName = this.getNewParamName(i, calledUnit, true, 1, diffCalledUnit);
                        diffTree = ILUtils.build(132, argName, diffTree);
                    }
                    if (addDiffIntoRW) {
                        refsRW.first = ILUtils.usedVarsInExp(actualArg, (TapList)refsRW.first, false);
                        if (TapList.oneTrue(paramsR[i])) {
                            diffRefsRW.first = ILUtils.addTreeInList(actualArg, (TapList)diffRefsRW.first);
                        }
                        if (TapList.oneTrue(paramsW[i])) {
                            diffRefsRW.second = ILUtils.addTreeInList(actualArg, (TapList)diffRefsRW.second);
                        }
                    }
                    if (!TapEnv.associationByAddress()) {
                        newArgs = new TapList<Tree>(diffTree, newArgs);
                    }
                    if (TapEnv.spareDiffReinitializations() && beforeActiv != null && !this.adEnv.activeCalledFromContext && !diffTreeIsDummyVar && ILUtils.isAWritableVarRef(actualArg, this.adEnv.curSymbolTable())) {
                        TapList<?> argZonesTree = this.adEnv.curSymbolTable().treeOfZonesOfValue(actualArg, null, this.adEnv.curInstruction(), null);
                        argZonesTree = TapList.copyTree(argZonesTree);
                        DataFlowAnalyzer.includePointedElementsInTree(argZonesTree, null, null, true, this.adEnv.curSymbolTable(), this.adEnv.curInstruction(), calledUnit, false, true);
                        TapList formalArgsEntryActiveI = formalArgsEntryActive == null ? null : formalArgsEntryActive[i];
                        TapList formalArgsExitActiveI = formalArgsExitActive == null ? null : formalArgsExitActive[i];
                        zonesToDiffInitUS = this.collectZonesFormalActiveAndActualPassive(argZonesTree, this.adEnv.toActiveTmpZones.tail, formalArgsEntryActiveI, beforeActiv, calledUnit, zonesToDiffInitUS);
                        if (paramsW != null && TapList.oneTrue(paramsW[i])) {
                            WrapperTypeSpec formalType = i < nbArgs ? calledFunctionTypeSpec.argumentsTypes[i] : null;
                            treesToDiffInitDS = this.collectTreesToDiffInitAfterDiffCall(actualArg, ProcedureCallDifferentiator.isAccessedThroughPointerOrIndex(actualArg, this.adEnv.curSymbolTable(), this.adEnv.curUnit().language(), calledUnit, i + 1), this.adEnv.curSymbolTable().typeOf(actualArg), formalType, argZonesTree, formalArgsEntryActiveI, formalArgsExitActiveI, paramsW[i], null, calledUnit, treesToDiffInitDS, null, null);
                        }
                    }
                }
                actualArg = actualArgs[i];
                newArg = ILUtils.copy(actualArg);
                if (actualArg.getAnnotation("sourcetree") != null) {
                    newArg = ILUtils.copy((Tree)actualArg.getAnnotation("sourcetree"));
                } else if (firstOrderingProblem != -1 && i >= firstOrderingProblem && actualArg.opCode() != 136) {
                    Tree argName;
                    if (newArg.opCode() == 132) {
                        argName = newArg.cutChild(1);
                        newArg = newArg.cutChild(2);
                    } else {
                        argName = this.getNewParamName(i, calledUnit, false, -1, null);
                    }
                    newArg = ILUtils.build(132, argName, newArg);
                }
                if (this.adEnv.curSymbolTable().identIsAFunction(actualArg)) {
                    newArg.setAnnotation("isFunctionName", Boolean.TRUE);
                }
                refsRW.first = ILUtils.usedVarsInExp(actualArg, (TapList)refsRW.first, false);
                if (TapList.oneTrue(paramsR[i])) {
                    refsRW.first = ILUtils.addTreeInList(actualArg, (TapList)refsRW.first);
                }
                if (TapList.oneTrue(paramsW[i])) {
                    refsRW.second = ILUtils.addTreeInList(actualArg, (TapList)refsRW.second);
                }
                if (!TapEnv.associationByAddress() || !formalArgsActivity[i]) {
                    newArgs = new TapList<Tree>(newArg, newArgs);
                    continue;
                }
                if (!TapEnv.associationByAddress()) continue;
                newArgs = new TapList<Tree>(newArg, newArgs);
            }
            if (!calledUnit.isIntrinsic()) {
                for (int i = this.adEnv.curSymbolTable().declaredZonesNb(0) - 1; i >= 0; --i) {
                    ZoneInfo zoneInfo = this.adEnv.curSymbolTable().declaredZoneInfo(i, 0);
                    if (zoneInfo == null || !zoneInfo.isCommon()) continue;
                    int iDiff = zoneInfo.zoneNb(this.adEnv.diffKind);
                    Tree zoneTree = zoneInfo.accessTree;
                    if (iDiff >= 0 && (formalCallActive.getDeclared(iDiff, this.curDiffVectorMap()) || formalExitActive.getDeclared(iDiff, this.curDiffVectorMap()))) {
                        if (callR.getDeclared(i, this.curVectorMap())) {
                            diffRefsRW.first = ILUtils.addTreeInList(zoneTree, (TapList)diffRefsRW.first);
                        }
                        if (callW.getDeclared(i, this.curVectorMap())) {
                            diffRefsRW.second = ILUtils.addTreeInList(zoneTree, (TapList)diffRefsRW.second);
                        }
                    }
                    if (callR.getDeclared(i, this.curVectorMap())) {
                        refsRW.first = ILUtils.addTreeInList(zoneTree, (TapList)refsRW.first);
                    }
                    if (!callW.getDeclared(i, this.curVectorMap())) continue;
                    refsRW.second = ILUtils.addTreeInList(zoneTree, (TapList)refsRW.second);
                }
            }
            if (TapEnv.spareDiffReinitializations() && !calledUnit.isIntrinsic() && beforeActiv != null && !this.adEnv.activeCalledFromContext) {
                int i;
                for (i = nDdZ - 1; i >= 0; --i) {
                    ZoneInfo zoneInfo;
                    if (beforeActiv.getDeclared(i, this.curDiffVectorMap()) || !formalCallActive.getDeclared(i, this.curDiffVectorMap()) || TapList.contains(zonesToDiffInitUS, zoneInfo = this.adEnv.curSymbolTable().declaredZoneInfo(i, this.adEnv.diffKind)) || zoneInfo.isConstant()) continue;
                    zonesToDiffInitUS = new TapList<ZoneInfo>(zoneInfo, zonesToDiffInitUS);
                }
                for (i = nSEdZ - 1; i >= 0; --i) {
                    if (beforeActiv.getSideEffect(i) || !formalCallActive.getSideEffect(i)) continue;
                    ZoneInfo zoneInfo = this.adEnv.curUnit().sideEffectZoneInfo(i, this.adEnv.diffKind);
                    String zoneInfoName = zoneInfo.sideEffectZoneName();
                    TapEnv.fileWarning(15, callTree, "(AD14) Differentiating this call to " + calledUnit.name + " needs to initialize derivative of undeclared side-effect variable: " + zoneInfoName);
                    this.adEnv.addInHiddenDiffInitVariables(zoneInfo);
                }
            }
            this.varRefDifferentiator().popDiffContext();
            while (zonesToDiffInitUS != null) {
                ZoneInfo zoneInfo = (ZoneInfo)zonesToDiffInitUS.head;
                Tree zoneReinitTree = this.blockDifferentiator().makeDiffInitialization(zoneInfo.accessTree, this.adEnv.curSymbolTable(), fwdSymbolTable, null, zoneInfo, true, null, true);
                if (zoneReinitTree != null) {
                    toNecessaryInitsUS.placdl(new TapPair<TapList<Tree>, Tree>(new TapList<Tree>(zoneInfo.accessTree, null), zoneReinitTree));
                }
                zonesToDiffInitUS = zonesToDiffInitUS.tail;
            }
            while (treesToDiffInitDS != null) {
                Tree zoneReinitTree;
                Tree treeToDiffReinit = (Tree)treesToDiffInitDS.head;
                if (!this.zonesOverlapArg(resultTree, treeToDiffReinit) && (zoneReinitTree = this.blockDifferentiator().makeDiffInitialization(treeToDiffReinit, this.adEnv.curSymbolTable(), fwdSymbolTable, null, null, false, null, true)) != null) {
                    toNecessaryInitsDS.placdl(new TapPair<TapList<Tree>, Tree>(new TapList<Tree>(treeToDiffReinit, null), zoneReinitTree));
                }
                treesToDiffInitDS = treesToDiffInitDS.tail;
            }
            if (diffCalledUnit != null) {
                CallGraph.addCallArrow(this.curFwdDiffUnit(), 1, diffCalledUnit);
            }
            Tree diffCallTree = ILUtils.buildCall(this.varRefDifferentiator().diffSymbolTree(calledActivity, ILUtils.build(94, calledUnit.name), fwdSymbolTable, false, true, false, callTree, false, 1, 1, 1, null), ILUtils.build(70, newArgs));
            toNecessaryInitsUS = toNecessaryInitsUS.tail;
            if (resultTree != null && this.varRefDifferentiator().diffFunctionIsFunction(calledUnit)) {
                WrapperTypeSpec resultTypeSpecDiff;
                Unit diffFunctionUnit = calledDiffInfo == null ? null : calledDiffInfo.getTangent(calledActivity);
                FunctionTypeSpec diffFunctionTypeSpec = diffFunctionUnit == null ? null : diffFunctionUnit.functionTypeSpec();
                WrapperTypeSpec wrapperTypeSpec = resultTypeSpecDiff = diffFunctionTypeSpec == null ? null : diffFunctionTypeSpec.returnType;
                if (diffFunctionUnit != null && WrapperTypeSpec.isNullOrVoid(resultTypeSpecDiff)) {
                    diffTree = diffCallTree;
                } else {
                    Tree diffResultTree;
                    if (!TapEnv.associationByAddress()) {
                        diffResultTree = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), resultTree, fwdSymbolTable, this.adEnv.curUnit().isFortran(), resultTree, false, true, null);
                        refsRW.first = ILUtils.usedVarsInExp(resultTree, (TapList)refsRW.first, false);
                        diffRefsRW.second = ILUtils.addTreeInList(resultTree, (TapList)diffRefsRW.second);
                    } else {
                        diffResultTree = ILUtils.copy(resultTree);
                    }
                    diffTree = ILUtils.build(13, diffResultTree, diffCallTree);
                }
            } else {
                diffTree = diffCallTree;
            }
            while (toNecessaryInitsUS != null) {
                initTree = (Tree)((TapPair)toNecessaryInitsUS.head).second;
                this.blockDifferentiator().addFuturePlainNodeFwd(initTree, null, false, null, null, null, (TapList)((TapPair)toNecessaryInitsUS.head).first, false, false, "Needed diff call pre-init", false);
                toNecessaryInitsUS = toNecessaryInitsUS.tail;
            }
        } else {
            Unit primalCalledUnit;
            diffTree = ILUtils.copy(callTree);
            if (resultTree != null) {
                diffTree = ILUtils.build(13, ILUtils.copy(resultTree), diffTree);
            }
            if (TapEnv.associationByAddress()) {
                diffTree = this.blockDifferentiator().turnAssociationByAddressPrimal(diffTree, this.adEnv.curSymbolTable(), this.adEnv.curFwdSymbolTable, null);
            }
            if ((primalCalledUnit = this.adEnv.getPrimalCopyOfOrigUnit(calledUnit)) == null) {
                primalCalledUnit = calledUnit;
            }
            if (primalCalledUnit != null) {
                CallGraph.addCallArrow(this.curFwdDiffUnit(), 1, primalCalledUnit);
            }
            this.fillCallRefsRW(callTree, null, calledUnit, refsRW);
            if (resultTree != null) {
                refsRW.first = ILUtils.usedVarsInExp(resultTree, (TapList)refsRW.first, false);
                refsRW.second = ILUtils.addTreeInList(resultTree, (TapList)refsRW.second);
            }
        }
        toNecessaryTmpResultAssigns = toNecessaryTmpResultAssigns.tail;
        this.blockDifferentiator().addFuturePlainNodeFwd(diffTree, this.adEnv.curInstruction().whereMask(), false, (TapList)refsRW.first, (TapList)refsRW.second, (TapList)diffRefsRW.first, (TapList)diffRefsRW.second, calledUnit.isExternal(), true, mustDiffCall ? "Differentiated call" : "Copy of primal call", true);
        if (mustDiffCall && toNecessaryTmpResultAssigns != null) {
            TapPair postAssign = (TapPair)toNecessaryTmpResultAssigns.head;
            this.blockDifferentiator().addFuturePlainNodeFwd((Tree)postAssign.second, this.adEnv.curInstruction().whereMask(), false, null, null, null, (TapList)postAssign.first, false, false, "Split aliased result", false);
            toNecessaryTmpResultAssigns = toNecessaryTmpResultAssigns.tail;
            if (toNecessaryTmpResultAssigns != null) {
                postAssign = (TapPair)toNecessaryTmpResultAssigns.head;
                this.blockDifferentiator().addFuturePlainNodeFwd((Tree)postAssign.second, this.adEnv.curInstruction().whereMask(), true, null, null, null, (TapList)postAssign.first, false, false, "Split aliased diff result", false);
                toNecessaryTmpResultAssigns = toNecessaryTmpResultAssigns.tail;
            }
        }
        if (resultTree != null && isActiveRecipient && !isActiveResult) {
            Tree resetTree;
            TapList<IterDescriptor> iterators = null;
            if (this.multiDirMode()) {
                iterators = new TapList<IterDescriptor>(this.varRefDifferentiator().multiDirIterDescriptor, null);
            }
            if ((resetTree = this.blockDifferentiator().makeDiffInitialization(resultTree, this.adEnv.curSymbolTable(), fwdSymbolTable, null, null, false, null, true)) != null) {
                this.blockDifferentiator().addFuturePlainNodeFwd(resetTree, this.adEnv.curInstruction().whereMask(), false, ILUtils.usedVarsInExp(resultTree, null, false), null, null, new TapList<Tree>(resetTree, null), false, false, "Reset diff result", false);
            }
        }
        if (mustDiffCall) {
            toNecessaryInitsDS = toNecessaryInitsDS.tail;
            while (toNecessaryInitsDS != null) {
                initTree = (Tree)((TapPair)toNecessaryInitsDS.head).second;
                this.blockDifferentiator().addFuturePlainNodeFwd(initTree, null, false, null, null, null, (TapList)((TapPair)toNecessaryInitsDS.head).first, false, false, "Needed diff call post-init", false);
                toNecessaryInitsDS = toNecessaryInitsDS.tail;
            }
        }
    }

    private void buildContextCallTangentNodes(Tree callTree, Tree resultTree, Unit calledUnit, ActivityPattern calledActivity, boolean mustDiffCall, SymbolTable fwdSymbolTable) {
        TapPair<Object, Object> refsRW = new TapPair<Object, Object>(null, null);
        this.fillCallRefsRW(callTree, resultTree, calledUnit, refsRW);
        if (mustDiffCall && (calledUnit.isStandard() || calledUnit.isExternal()) && this.adEnv.curUnitIsContext) {
            Tree fwdCallTree;
            Tree[] args;
            Tree tgtTree2 = null;
            if (this.adEnv.activeCalledFromContext) {
                tgtTree2 = this.differentiateProcedureHeader(ILUtils.copy(callTree), resultTree, calledActivity, fwdSymbolTable, this.curFwdDiffUnit().privateSymbolTable(), 1, null);
                args = ILUtils.getArguments(tgtTree2).children();
                for (int i = args.length - 1; i >= 0; --i) {
                    if (!this.adEnv.curSymbolTable().identIsAFunction(args[i])) continue;
                    args[i].setAnnotation("isFunctionName", Boolean.TRUE);
                }
                this.blockDifferentiator().addFuturePlainNodeBwd(tgtTree2, null, false, (TapList)refsRW.first, (TapList)refsRW.second, null, null, false, true, "TANGENT (in context) call", false);
            }
            int thisDiffMode = 1;
            if (this.adEnv.curUnitIsContext && !this.adEnv.activeCalledFromContext) {
                thisDiffMode = 1;
            }
            Tree fwdTree = fwdCallTree = this.differentiateProcedureHeader(ILUtils.copy(callTree), resultTree, calledActivity, fwdSymbolTable, this.curFwdDiffUnit().privateSymbolTable(), thisDiffMode, null);
            args = ILUtils.getArguments(fwdCallTree).children();
            for (int i = args.length - 1; i >= 0; --i) {
                if (!this.adEnv.curSymbolTable().identIsAFunction(args[i])) continue;
                args[i].setAnnotation("isFunctionName", Boolean.TRUE);
            }
            if (resultTree != null && !this.adEnv.activeCalledFromContext) {
                fwdTree = ILUtils.build(13, ILUtils.copy(resultTree), fwdTree);
            }
            if (this.adEnv.activeCalledFromContext) {
                this.blockDifferentiator().addFuturePlainNodeBwd(fwdTree, this.adEnv.curInstruction().whereMask(), false, (TapList)refsRW.first, (TapList)refsRW.second, null, null, false, true, "context tangent call", false);
            } else {
                this.blockDifferentiator().addFuturePlainNodeFwd(fwdTree, this.adEnv.curInstruction().whereMask(), false, (TapList)refsRW.first, (TapList)refsRW.second, null, null, false, true, "Tangent call", false);
            }
            Unit fwdDiffCalledUnit = this.adEnv.getDiffOfUnit(calledUnit, calledActivity, thisDiffMode);
            if (fwdDiffCalledUnit != null) {
                CallGraph.addCallArrow(this.curFwdDiffUnit(), 1, fwdDiffCalledUnit);
            }
        } else {
            Tree sourceTreeAnnotation = (Tree)callTree.getAnnotation("sourcetree");
            Tree fwdCallTree = sourceTreeAnnotation != null && sourceTreeAnnotation.opCode() == 30 ? ILUtils.copy(sourceTreeAnnotation) : ILUtils.copy(callTree);
            Tree[] args = ILUtils.getArguments(fwdCallTree).children();
            for (int i = args.length - 1; i >= 0; --i) {
                if (!this.adEnv.curSymbolTable().identIsAFunction(args[i])) continue;
                args[i].setAnnotation("isFunctionName", Boolean.TRUE);
            }
            Tree fwdTree = fwdCallTree;
            if (resultTree != null) {
                fwdTree = ILUtils.build(13, ILUtils.copy(resultTree), fwdTree);
            }
            this.blockDifferentiator().addFuturePlainNodeFwd(fwdTree, this.adEnv.curInstruction().whereMask(), false, (TapList)refsRW.first, (TapList)refsRW.second, null, null, true, true, "Copy of primal call", false);
            Unit primalCalledUnit = this.adEnv.getPrimalCopyOfOrigUnit(calledUnit);
            if (primalCalledUnit == null) {
                primalCalledUnit = calledUnit;
            }
            if (primalCalledUnit != null) {
                CallGraph.addCallArrow(this.curFwdDiffUnit(), 1, primalCalledUnit);
            }
        }
    }

    private void buildCallAdjointNodes(Tree callTree, Tree resultTree, Unit calledUnit, ActivityPattern calledActivity, boolean mustDiffCall, boolean callIsLive, boolean mustSaveTBRBeforeInstr, boolean normalCheckpointedCall, boolean splitAdjointCall, boolean isJoint, SymbolTable fwdSymbolTable, SymbolTable bwdSymbolTable, BoolVector beforeActiv, BoolVector afterActiv) {
        if (calledActivity == null && calledUnit == this.adEnv.curUnit()) {
            calledActivity = this.adEnv.curActivity();
        }
        if (!this.adEnv.curUnitIsContext) {
            RefDescriptor refDescriptorRestore;
            NewSymbolHolder indexSymbolHolder;
            RefDescriptor refDescriptorSave;
            WrapperTypeSpec formalArgType;
            WrapperTypeSpec actualArgType;
            Tree indexExpr;
            TapPair splitIndex;
            String zoneInfoName;
            ZoneInfo zoneInfo;
            BoolVector[] tbrOnGlobs;
            BoolVector sbkOnDiffPtr;
            BoolVector sbk;
            BoolVector snpOnDiffPtr;
            BoolVector snp;
            int i;
            TapList[] sbkArgsOnDiffPtr;
            TapList[] sbkArgs;
            TapList[] snpArgsOnDiffPtr;
            TapList[] snpArgs;
            UnitDiffInfo calledDiffInfo = this.callGraphDifferentiator().getUnitDiffInfo(calledUnit);
            int calledDiffSort = normalCheckpointedCall ? 2 : 4;
            Unit diffCalledUnit = this.adEnv.getDiffOfUnit(calledUnit, calledActivity, calledDiffSort);
            TapList<IterDescriptor> iterators = null;
            if (this.multiDirMode()) {
                iterators = new TapList<IterDescriptor>(new IterDescriptor(this.varRefDifferentiator().dirIndexSymbolHolder), null);
            }
            this.varRefDifferentiator().pushDiffContext(1);
            Tree adjCall = null;
            FunctionTypeSpec functionTypeSpec = (FunctionTypeSpec)callTree.getAnnotation("functionTypeSpec");
            if (functionTypeSpec == null) {
                functionTypeSpec = calledUnit.functionTypeSpec();
            }
            CallArrow callArrow = CallGraph.getCallArrow(this.adEnv.curUnit(), calledUnit);
            int nDZ = this.adEnv.curSymbolTable().declaredZonesNb(0);
            int nDdZ = this.adEnv.curSymbolTable().declaredZonesNb(this.adEnv.diffKind);
            int nSEdZ = this.adEnv.curUnit().sideEffectZonesNb(this.adEnv.diffKind);
            Tree[] args = ILUtils.getArguments(callTree).children();
            int nbArgs = args.length;
            if (nbArgs > calledUnit.functionTypeSpec().argumentsTypes.length) {
                nbArgs = calledUnit.functionTypeSpec().argumentsTypes.length;
            }
            BoolVector zonesWrittenByThisCall = new BoolVector(this.curNSEZ() + nDZ);
            TapList[] paramsW = null;
            TapList resultW = new TapList(null, null);
            if (calledUnit.unitInOutW() != null && callArrow != null) {
                DataFlowAnalyzer.propagateDataToCaller(calledUnit.unitInOutPossiblyW(), null, args, args.length, zonesWrittenByThisCall, this.curVectorMap(), null, this.adEnv.curInstruction(), callArrow, true, false, 0);
                paramsW = DataFlowAnalyzer.propagateDataToCaller(calledUnit.unitInOutPossiblyW(), null, null, args.length, null, this.curVectorMap(), resultW, this.adEnv.curInstruction(), callArrow, true, false, 0);
            }
            BoolVector callUseB = new BoolVector(this.curNSEZ() + nDZ);
            BoolVector unitDiffLiveness = null;
            if (TapEnv.diffLivenessAnalyzer() == null) {
                unitDiffLiveness = calledUnit.unitInOutPossiblyR();
            } else if (calledActivity != null) {
                unitDiffLiveness = TapEnv.diffLivenessAnalyzer().getPublicDiffLiveness(calledActivity).or(TapEnv.diffLivenessAnalyzer().getPublicDiffLivenessOnDiffPtr(calledActivity));
            }
            if (unitDiffLiveness != null && callArrow != null) {
                DataFlowAnalyzer.propagateDataToCaller(unitDiffLiveness, null, args, args.length, callUseB, this.curVectorMap(), null, this.adEnv.curInstruction(), callArrow, true, true, 0);
            }
            TapPair completeCallTBRInfo = null;
            if (mustSaveTBRBeforeInstr) {
                completeCallTBRInfo = (TapPair)ActivityPattern.getAnnotationForActivityPattern(callTree, this.adEnv.curActivity(), "TBR");
            }
            if (completeCallTBRInfo == null) {
                snpArgs = new TapList[nbArgs + 1];
                snpArgsOnDiffPtr = new TapList[nbArgs + 1];
                sbkArgs = new TapList[nbArgs + 1];
                sbkArgsOnDiffPtr = new TapList[nbArgs + 1];
                for (i = nbArgs - 1; i >= 0; --i) {
                    snpArgs[i] = null;
                    snpArgsOnDiffPtr[i] = null;
                    sbkArgs[i] = null;
                    sbkArgsOnDiffPtr[i] = null;
                }
                snp = new BoolVector(this.curNSEZ() + nDZ);
                snpOnDiffPtr = new BoolVector(this.curNSEZ() + nDZ);
                sbk = new BoolVector(this.curNSEZ() + nDZ);
                sbkOnDiffPtr = new BoolVector(this.curNSEZ() + nDZ);
            } else if (normalCheckpointedCall) {
                TapList[][] tbrOnArgs = (TapList[][])completeCallTBRInfo.first;
                tbrOnGlobs = (BoolVector[])completeCallTBRInfo.second;
                snpArgs = tbrOnArgs[0];
                snp = tbrOnGlobs[0];
                sbkArgs = tbrOnArgs[2];
                sbk = tbrOnGlobs[2];
                snpArgsOnDiffPtr = new TapList[nbArgs + 1];
                snpOnDiffPtr = new BoolVector(this.curNSEZ() + nDZ);
                sbkArgsOnDiffPtr = new TapList[nbArgs + 1];
                sbkOnDiffPtr = new BoolVector(this.curNSEZ() + nDZ);
                for (int i2 = nbArgs - 1; i2 >= 0; --i2) {
                    snpArgsOnDiffPtr[i2] = null;
                    sbkArgsOnDiffPtr[i2] = null;
                }
            } else {
                TapList[][] tbrOnArgs = (TapList[][])completeCallTBRInfo.first;
                tbrOnGlobs = (BoolVector[])completeCallTBRInfo.second;
                snpArgs = tbrOnArgs[0];
                snpArgsOnDiffPtr = tbrOnArgs[1];
                snp = tbrOnGlobs[0];
                snpOnDiffPtr = DataFlowAnalyzer.changeKind(tbrOnGlobs[1], this.curPtrVectorMap(), 3, this.curVectorMap(), 0, this.adEnv.curSymbolTable());
                sbkArgs = tbrOnArgs[2];
                sbkArgsOnDiffPtr = tbrOnArgs[3];
                sbk = tbrOnGlobs[2];
                sbkOnDiffPtr = DataFlowAnalyzer.changeKind(tbrOnGlobs[3], this.curPtrVectorMap(), 3, this.curVectorMap(), 0, this.adEnv.curSymbolTable());
            }
            if (this.adEnv.traceCurBlock != 0) {
                TapEnv.printOnTrace("          SNP sets: (");
                for (i = 0; i <= nbArgs; ++i) {
                    TapEnv.printOnTrace(snpArgs[i] + (i == nbArgs ? "" : (i == nbArgs - 1 ? "=>" : ",")));
                }
                TapEnv.printOnTrace(") Ptr:(");
                for (i = 0; i <= nbArgs; ++i) {
                    TapEnv.printOnTrace(snpArgsOnDiffPtr[i] + (i == nbArgs ? "" : (i == nbArgs - 1 ? "=>" : ",")));
                }
                TapEnv.printlnOnTrace(") GLOBS:" + DataFlowAnalyzer.infoToStringWithDiffPtr(snp, this.curVectorMap(), snpOnDiffPtr, this.curPtrVectorMap(), this.adEnv.curUnit(), this.adEnv.curSymbolTable()));
                TapEnv.printOnTrace("          SBK sets: (");
                for (i = 0; i <= nbArgs; ++i) {
                    TapEnv.printOnTrace(sbkArgs[i] + (i == nbArgs ? "" : (i == nbArgs - 1 ? "=>" : ",")));
                }
                TapEnv.printOnTrace(") Ptr:(");
                for (i = 0; i <= nbArgs; ++i) {
                    TapEnv.printOnTrace(sbkArgsOnDiffPtr[i] + (i == nbArgs ? "" : (i == nbArgs - 1 ? "=>" : ",")));
                }
                TapEnv.printlnOnTrace(") GLOBS:" + DataFlowAnalyzer.infoToStringWithDiffPtr(sbk, this.curVectorMap(), sbkOnDiffPtr, this.curPtrVectorMap(), this.adEnv.curUnit(), this.adEnv.curSymbolTable()));
            }
            for (i = nDZ - 1; i >= 0; --i) {
                if (!sbk.getDeclared(i, this.curVectorMap()) && !sbkOnDiffPtr.getDeclared(i, this.curVectorMap()) && !snp.getDeclared(i, this.curVectorMap()) && !snpOnDiffPtr.getDeclared(i, this.curVectorMap()) || (zoneInfo = this.adEnv.curUnit().publicSymbolTable().declaredZoneInfo(i, 0)) == null || zoneInfo.accessTree == null || zoneInfo.comesFromAllocate()) continue;
                if (zoneInfo.zoneNb == this.adEnv.srcCallGraph().zoneNbOfAllIOStreams) {
                    TapEnv.fileWarning(15, callTree, "(AD07) Data-Flow recovery (TBR) on this call to " + calledUnit.name + " needs to save the I-O state");
                    continue;
                }
                if (this.adEnv.srcCallGraph().isAMessagePassingChannelZone(zoneInfo.zoneNb) || !zoneInfo.isHiddenFrom(this.adEnv.curUnit().publicSymbolTable())) continue;
                zoneInfoName = zoneInfo.sideEffectZoneName();
                TapEnv.fileWarning(15, callTree, "(AD14) Checkpointing this call to " + calledUnit.name + " needs to save a hidden variable: " + zoneInfoName);
                this.adEnv.addInHiddenPushPopVariables(zoneInfo);
            }
            for (i = this.curNSEZ() - 1; i >= 0; --i) {
                if (!sbk.getSideEffect(i) && !sbkOnDiffPtr.getSideEffect(i) && !snp.getSideEffect(i) && !snpOnDiffPtr.getSideEffect(i) || (zoneInfo = this.adEnv.curUnit().sideEffectZoneInfo(i, 0)) == null || zoneInfo.accessTree == null || zoneInfo.comesFromAllocate()) continue;
                zoneInfoName = zoneInfo.sideEffectZoneName();
                TapEnv.fileWarning(15, callTree, "(AD14) Checkpointing this call to " + calledUnit.name + " needs to save an undeclared side-effect variable: " + zoneInfoName);
                this.adEnv.addInHiddenPushPopVariables(zoneInfo);
            }
            TapList[] interArgs = new TapList[nbArgs + 1];
            TapList[] interArgsOnDiffPtr = new TapList[nbArgs + 1];
            BoolVector inter = sbk.copy();
            BoolVector interOnDiffPtr = sbkOnDiffPtr.copy();
            inter.cumulAnd(snp);
            interOnDiffPtr.cumulAnd(snpOnDiffPtr);
            sbk.cumulAnd(inter.not());
            sbkOnDiffPtr.cumulAnd(interOnDiffPtr.not());
            snp.cumulAnd(inter.not());
            snpOnDiffPtr.cumulAnd(interOnDiffPtr.not());
            for (int i3 = nbArgs; i3 >= 0; --i3) {
                if (this.adEnv.traceCurBlock != 0) {
                    TapEnv.printlnOnTrace("for arg" + i3 + "? sbk:" + sbkArgs[i3] + " inter:" + interArgs[i3] + " snp:" + snpArgs[i3]);
                }
                interArgs[i3] = TapList.copyTree(sbkArgs[i3]);
                interArgsOnDiffPtr[i3] = TapList.copyTree(sbkArgsOnDiffPtr[i3]);
                interArgs[i3] = TapList.cumulWithOper(interArgs[i3], snpArgs[i3], 92);
                interArgsOnDiffPtr[i3] = TapList.cumulWithOper(interArgsOnDiffPtr[i3], snpArgsOnDiffPtr[i3], 92);
                if (sbkArgs[i3] != null) {
                    sbkArgs[i3] = TapList.cumulWithOper(sbkArgs[i3], interArgs[i3], 93);
                }
                if (sbkArgsOnDiffPtr[i3] != null) {
                    sbkArgsOnDiffPtr[i3] = TapList.cumulWithOper(sbkArgsOnDiffPtr[i3], interArgsOnDiffPtr[i3], 93);
                }
                if (snpArgs[i3] != null) {
                    snpArgs[i3] = TapList.cumulWithOper(snpArgs[i3], interArgs[i3], 93);
                }
                if (snpArgsOnDiffPtr[i3] != null) {
                    snpArgsOnDiffPtr[i3] = TapList.cumulWithOper(snpArgsOnDiffPtr[i3], interArgsOnDiffPtr[i3], 93);
                }
                if (this.adEnv.traceCurBlock == 0) continue;
                TapEnv.printlnOnTrace("for arg" + i3 + "> sbk:" + sbkArgs[i3] + " inter:" + interArgs[i3] + " snp:" + snpArgs[i3]);
            }
            TapList<Object> headSaveBeforeCall = new TapList<Object>(null, null);
            TapList<Object> headRestoreBeforeAdjoint = new TapList<Object>(null, null);
            TapList<Object> headLookBeforeAdjoint = new TapList<Object>(null, null);
            TapList<Object> headRestoreAfterAdjoint = new TapList<Object>(null, null);
            TapList<Object> toTailSaveBeforeCall = new TapList<Object>(null, headSaveBeforeCall);
            TapList<Object> toTailRestoreBeforeAdjoint = new TapList<Object>(null, headRestoreBeforeAdjoint);
            TapList<Object> toTailLookBeforeAdjoint = new TapList<Object>(null, headLookBeforeAdjoint);
            TapList<Object> toTailRestoreAfterAdjoint = new TapList<Object>(null, headRestoreAfterAdjoint);
            TapList<Object> toSpecialSubExpressions = new TapList<Object>(null, null);
            SplitForSave[] argsSplitForSave = new SplitForSave[nbArgs + 1];
            TapIntList toNextIndexRank = new TapIntList(0, null);
            for (int i4 = nbArgs; i4 >= 0; --i4) {
                argsSplitForSave[i4] = new SplitForSave(this.adEnv.curSymbolTable(), toNextIndexRank, toSpecialSubExpressions, this.adEnv.toIndexSymbolHolders, zonesWrittenByThisCall, this.curVectorMap(), this.blockDifferentiator());
            }
            this.collectRefDescriptorsToSave(sbk, sbkArgs, sbkOnDiffPtr, sbkArgsOnDiffPtr, toTailSaveBeforeCall, null, toTailRestoreAfterAdjoint, false, fwdSymbolTable, bwdSymbolTable, calledUnit, functionTypeSpec, args, nbArgs, resultTree, argsSplitForSave);
            this.collectRefDescriptorsToSave(inter, interArgs, interOnDiffPtr, interArgsOnDiffPtr, toTailSaveBeforeCall, toTailLookBeforeAdjoint, toTailRestoreAfterAdjoint, true, fwdSymbolTable, bwdSymbolTable, calledUnit, functionTypeSpec, args, nbArgs, resultTree, argsSplitForSave);
            while (toSpecialSubExpressions.tail != null) {
                Tree restoredIndexExpr;
                splitIndex = (TapPair)toSpecialSubExpressions.tail.head;
                indexExpr = (Tree)splitIndex.first;
                actualArgType = this.adEnv.curSymbolTable().typeOf(indexExpr);
                formalArgType = this.adEnv.integerTypeSpec;
                refDescriptorSave = new RefDescriptor(indexExpr, actualArgType, formalArgType, null, this.adEnv.curSymbolTable(), this.curFwdDiffUnit().privateSymbolTable(), null, null, false, null, this.curDiffUnit());
                refDescriptorSave.setHintArrayTreeForCallSize(indexExpr);
                toTailSaveBeforeCall.tail = toTailSaveBeforeCall.tail.placdl(new TapPair<RefDescriptor, Object>(refDescriptorSave, null));
                indexSymbolHolder = (NewSymbolHolder)splitIndex.second;
                if (indexSymbolHolder == null) {
                    restoredIndexExpr = ILUtils.copy(indexExpr);
                } else {
                    restoredIndexExpr = indexSymbolHolder.makeNewRef(bwdSymbolTable);
                    indexSymbolHolder.declarationLevelMustInclude(bwdSymbolTable);
                }
                refDescriptorRestore = new RefDescriptor(restoredIndexExpr, actualArgType, formalArgType, null, this.adEnv.curSymbolTable(), this.curDiffUnit().privateSymbolTable(), null, null, false, null, this.curDiffUnit());
                refDescriptorRestore.setHintArrayTreeForCallSize(restoredIndexExpr);
                toTailLookBeforeAdjoint.tail = toTailLookBeforeAdjoint.tail.placdl(new TapPair<RefDescriptor, Object>(refDescriptorRestore, null));
                toTailRestoreAfterAdjoint.tail = toTailRestoreAfterAdjoint.tail.placdl(new TapPair<RefDescriptor, Object>(refDescriptorRestore, null));
                this.blockDifferentiator().prepareRestoreOperations(refDescriptorSave, refDescriptorRestore, 0, fwdSymbolTable, bwdSymbolTable);
                toSpecialSubExpressions.tail = toSpecialSubExpressions.tail.tail;
            }
            this.collectRefDescriptorsToSave(snp, snpArgs, snpOnDiffPtr, snpArgsOnDiffPtr, toTailSaveBeforeCall, toTailRestoreBeforeAdjoint, null, true, fwdSymbolTable, bwdSymbolTable, calledUnit, functionTypeSpec, args, nbArgs, resultTree, argsSplitForSave);
            while (toSpecialSubExpressions.tail != null) {
                Tree restoredIndexExpr;
                splitIndex = (TapPair)toSpecialSubExpressions.tail.head;
                indexExpr = (Tree)splitIndex.first;
                actualArgType = this.adEnv.curSymbolTable().typeOf(indexExpr);
                formalArgType = this.adEnv.integerTypeSpec;
                refDescriptorSave = new RefDescriptor(indexExpr, actualArgType, formalArgType, null, this.adEnv.curSymbolTable(), this.curFwdDiffUnit().privateSymbolTable(), null, null, false, null, this.curFwdDiffUnit());
                refDescriptorSave.setHintArrayTreeForCallSize(indexExpr);
                toTailSaveBeforeCall.tail = toTailSaveBeforeCall.tail.placdl(new TapPair<RefDescriptor, Object>(refDescriptorSave, null));
                indexSymbolHolder = (NewSymbolHolder)splitIndex.second;
                if (indexSymbolHolder == null) {
                    restoredIndexExpr = ILUtils.copy(indexExpr);
                } else {
                    restoredIndexExpr = indexSymbolHolder.makeNewRef(bwdSymbolTable);
                    indexSymbolHolder.declarationLevelMustInclude(bwdSymbolTable);
                }
                refDescriptorRestore = new RefDescriptor(restoredIndexExpr, actualArgType, formalArgType, null, this.adEnv.curSymbolTable(), this.curDiffUnit().privateSymbolTable(), null, null, false, null, this.curDiffUnit());
                refDescriptorRestore.setHintArrayTreeForCallSize(restoredIndexExpr);
                toTailRestoreBeforeAdjoint.tail = toTailRestoreBeforeAdjoint.tail.placdl(new TapPair<RefDescriptor, Object>(refDescriptorRestore, null));
                this.blockDifferentiator().prepareRestoreOperations(refDescriptorSave, refDescriptorRestore, 0, fwdSymbolTable, bwdSymbolTable);
                toSpecialSubExpressions.tail = toSpecialSubExpressions.tail.tail;
            }
            TapList<Tree> readRefs = null;
            TapList<Tree> writtenRefs = null;
            TapList<Tree> readAdjRefs = null;
            TapList<Tree> writtenAdjRefs = null;
            TapList<Tree> treesToDiffInitUS = null;
            TapList<Object> treesToDiffInitDS = null;
            TapList<ZoneInfo> zonesToDiffInitDS = null;
            if (mustDiffCall) {
                int i5;
                int i6;
                TapList[] formalArgsExitActive;
                TapList[] formalArgsEntryActive;
                BoolVector actualBeforeActive = null;
                TapList[] actualArgsBeforeActive = null;
                if (beforeActiv != null && !this.adEnv.activeCalledFromContext) {
                    actualBeforeActive = beforeActiv.copy();
                    actualArgsBeforeActive = DataFlowAnalyzer.propagateDataToCallee(actualBeforeActive, this.curDiffVectorMap(), null, args, null, this.adEnv.toActiveTmpZones.tail, this.adEnv.curInstruction(), callArrow, true, this.adEnv.diffKind);
                }
                boolean[] formalArgsActivity = null;
                if (calledDiffInfo != null) {
                    formalArgsActivity = calledDiffInfo.getUnitFormalArgsActivityS(calledActivity);
                }
                if (formalArgsActivity == null) {
                    formalArgsActivity = ADActivityAnalyzer.formalArgsActivity(calledActivity);
                }
                TapTriplet<Unit, BoolVector, BoolVector>[] varFunctionInfos = calledActivity.varFunctionADActivities();
                TapList formalResultEntryActive = new TapList(null, null);
                TapList formalResultExitActive = new TapList(null, null);
                BoolVector formalExitActive = new BoolVector(nSEdZ + nDdZ);
                if (calledUnit.isIntrinsic()) {
                    formalArgsEntryActive = new TapList[nbArgs];
                    formalArgsExitActive = new TapList[nbArgs];
                    for (i6 = nbArgs - 1; i6 >= 0; --i6) {
                        formalArgsEntryActive[i6] = new TapList<Boolean>(Boolean.TRUE, null);
                        formalArgsExitActive[i6] = new TapList<Boolean>(Boolean.TRUE, null);
                    }
                    formalResultEntryActive.head = Boolean.FALSE;
                    formalResultExitActive.head = Boolean.TRUE;
                } else {
                    formalArgsEntryActive = DataFlowAnalyzer.propagateDataToCaller(calledActivity.callActivity(), null, null, args.length, null, null, formalResultEntryActive, this.adEnv.curInstruction(), callArrow, true, true, this.adEnv.diffKind);
                    formalArgsExitActive = DataFlowAnalyzer.propagateDataToCaller(calledActivity.exitActivity(), null, null, args.length, formalExitActive, this.curDiffVectorMap(), formalResultExitActive, this.adEnv.curInstruction(), callArrow, true, true, this.adEnv.diffKind);
                    for (i6 = 0; i6 < formalArgsEntryActive.length && i6 < formalArgsExitActive.length; ++i6) {
                        if (!calledUnit.passesByValue(i6 + 1, this.adEnv.curUnit().language())) continue;
                        TapList<?> argEntryActive = TapList.copyTreeNoPointed(formalArgsEntryActive[i6]);
                        formalArgsExitActive[i6] = TapList.cumulWithOper(formalArgsExitActive[i6], argEntryActive, 91);
                    }
                }
                String varName = null;
                for (int i7 = nDZ - 1; i7 >= 0; --i7) {
                    zoneInfo = this.adEnv.curSymbolTable().declaredZoneInfo(i7, 0);
                    if (zoneInfo != null) {
                        varName = zoneInfo.bestVarName();
                    }
                    if (varName == null) continue;
                    Tree ref = ILUtils.build(94, varName);
                    if (callUseB.getDeclared(i7, this.curVectorMap())) {
                        readRefs = new TapList<Tree>(ref, readRefs);
                    }
                    if (!zonesWrittenByThisCall.getDeclared(i7, this.curVectorMap())) continue;
                    writtenRefs = new TapList<Tree>(ref, writtenRefs);
                }
                TapList<Object> hdNewArgs = new TapList<Object>(null, null);
                Object annot = callTree.getAnnotation("sourcetree");
                TapList<Object> tlNewArgs = hdNewArgs;
                boolean mustBeNameEq = false;
                boolean bewareNameEq = annot != null && ((Tree)annot).opCode() == 30;
                boolean[] diffArgsByValueNeedOverwrite = null;
                diffArgsByValueNeedOverwrite = calledDiffInfo.getUnitDiffArgsByValueNeedOverwriteInfoS(calledActivity);
                for (i5 = 0; i5 <= nbArgs; ++i5) {
                    Tree argTreeBis;
                    Tree argTree;
                    TapList formalArgWritten;
                    Tree arg = i5 == nbArgs ? resultTree : args[i5];
                    TapList tapList = formalArgWritten = i5 == nbArgs ? resultW : paramsW[i5];
                    if (argsSplitForSave[i5].tree == null) {
                        argTree = ILUtils.copy(arg);
                        argTreeBis = ILUtils.copy(arg);
                    } else if (TapEnv.relatedLanguageIsFortran9x()) {
                        argTree = argsSplitForSave[i5].newSplitCopy(bwdSymbolTable);
                        argTreeBis = argsSplitForSave[i5].newSplitCopy(bwdSymbolTable);
                    } else {
                        argTree = argsSplitForSave[i5].newSplitNoColonCopy(bwdSymbolTable);
                        argTreeBis = argsSplitForSave[i5].newSplitNoColonCopy(bwdSymbolTable);
                    }
                    if (bewareNameEq && i5 < nbArgs && (ILUtils.isNullOrNone(arg) || arg.opCode() == 132 || argTree.getAnnotation("sourcetree") != null)) {
                        mustBeNameEq = true;
                    }
                    Tree argTreeCopy = null;
                    if (i5 != nbArgs && argTree.opCode() != 109) {
                        argTreeCopy = argTree;
                        if (this.adEnv.curSymbolTable().identIsAFunction(argTree)) {
                            argTreeCopy.setAnnotation("isFunctionName", Boolean.TRUE);
                        }
                        readRefs = ILUtils.usedVarsInExp(argTree, readRefs, false);
                    }
                    if (!ILUtils.isNullOrNone(argTreeCopy)) {
                        if (mustBeNameEq && argTreeCopy.opCode() != 132) {
                            Tree argName = this.getNewParamName(i5 == nbArgs ? -1 : i5, calledUnit, false, this.curDiffVarSort(), null);
                            argTreeCopy = ILUtils.build(132, argName, argTreeCopy);
                        }
                        tlNewArgs = tlNewArgs.placdl(argTreeCopy);
                    }
                    Tree argTreeCopyDiff = null;
                    if (arg != null && this.adEnv.curSymbolTable().identIsAFunction(arg)) {
                        if (!TapEnv.doActivity() || varFunctionInfos != null && i5 < nbArgs && varFunctionInfos[i5] != null) {
                            TapList<ActivityPattern> functionActivities = ((FunctionDecl)this.adEnv.curSymbolTable().getSymbolDecl((String)ILUtils.getIdentString((Tree)arg))).unit().specificInfoAD;
                            argTreeCopyDiff = this.varRefDifferentiator().diffSymbolTree(functionActivities != null ? (ActivityPattern)functionActivities.head : null, arg, bwdSymbolTable, false, true, false, null, false, this.curDiffVarSort(), 2, 0, null);
                            argTreeCopyDiff.setAnnotation("isFunctionName", Boolean.TRUE);
                        }
                    } else if ((i5 < formalArgsActivity.length - 1 && formalArgsActivity[i5] || i5 == nbArgs && formalArgsActivity[formalArgsActivity.length - 1]) && arg != null && arg.opCode() != 136) {
                        Tree argTreeInitBis = null;
                        TapList<?> argZonesTree = this.adEnv.curSymbolTable().treeOfZonesOfValue(arg, null, this.adEnv.curInstruction(), null);
                        argZonesTree = TapList.copyTree(argZonesTree);
                        DataFlowAnalyzer.includePointedElementsInTree(argZonesTree, null, null, true, this.adEnv.curSymbolTable(), this.adEnv.curInstruction(), calledUnit, false, true);
                        WrapperTypeSpec wrapperTypeSpec = formalArgType = i5 == nbArgs ? functionTypeSpec.returnType : functionTypeSpec.argumentsTypes[i5];
                        if (argTreeBis.opCode() != 3) {
                            if (!ILUtils.isAWritableVarRef(argTreeBis, this.adEnv.curSymbolTable())) {
                                NewSymbolHolder dummySymbolHolder = new NewSymbolHolder(TapEnv.disambigNewName("dummydiff"));
                                dummySymbolHolder.setAsVariable(formalArgType, null);
                                argTreeBis = dummySymbolHolder.makeNewRef(bwdSymbolTable);
                            } else if (!(ILUtils.isAWritableIdentVarRef(argTreeBis, this.adEnv.curSymbolTable()) || ADActivityAnalyzer.isAnnotatedActive(this.adEnv.curActivity(), arg, this.adEnv.curSymbolTable()) || ReqExplicit.isAnnotatedReqX(this.adEnv.curActivity(), arg))) {
                                NewSymbolHolder dummySymbolHolder = new NewSymbolHolder(TapEnv.disambigNewName("dummyzerodiff"));
                                WrapperTypeSpec differentiableTypeSpec = this.adEnv.curSymbolTable().typeOf(arg);
                                if (!formalArgType.isIntegerBase()) {
                                    differentiableTypeSpec = WrapperTypeSpec.intToReal(this.adEnv.curSymbolTable().typeOf(arg), new TapList<Object>(null, null), this.adEnv.curSymbolTable());
                                }
                                WrapperTypeSpec fusedArgType = WrapperTypeSpec.preciseDimensions(differentiableTypeSpec, formalArgType, new TapList<Object>(null, null), this.adEnv.curSymbolTable());
                                dummySymbolHolder.setAsVariable(fusedArgType, null);
                                dummySymbolHolder.setHintArrayTreeForCallSize(arg);
                                argTreeBis = dummySymbolHolder.makeNewRef(bwdSymbolTable);
                                argTreeInitBis = dummySymbolHolder.makeNewRef(bwdSymbolTable);
                                treesToDiffInitDS = new TapList<TapTriplet<Tree, WrapperTypeSpec, Tree>>(new TapTriplet<Tree, WrapperTypeSpec, Tree>(argTreeInitBis, dummySymbolHolder.newVariableDecl.type(), arg), treesToDiffInitDS);
                            }
                        }
                        if ((argTreeCopyDiff = this.varRefDifferentiator().diffVarRefNoCopy(this.adEnv.curActivity(), argTreeBis, bwdSymbolTable, false, arg)) != null && this.adEnv.curUnit().isC()) {
                            boolean mustPassAddress;
                            if (i5 < nbArgs) {
                                mustPassAddress = diffArgsByValueNeedOverwrite != null && diffArgsByValueNeedOverwrite[i5 + 1] && calledUnit.passesByValue(i5 + 1, this.adEnv.curUnit().language());
                            } else {
                                boolean bl = mustPassAddress = calledUnit.isFortran() && !calledUnit.isFortran2003();
                            }
                            if (mustPassAddress) {
                                argTreeCopyDiff = argTreeCopyDiff.opCode() == 148 && ILUtils.isNullOrNone(argTreeCopyDiff.down(2)) ? argTreeCopyDiff.cutChild(1) : ILUtils.build(3, argTreeCopyDiff);
                            }
                        }
                        writtenAdjRefs = new TapList<Tree>(argTree, writtenAdjRefs);
                        readAdjRefs = new TapList<Tree>(argTree, readAdjRefs);
                        if ((TapEnv.spareDiffReinitializations() || TapEnv.dbadMode() == -1) && ILUtils.isAWritableVarRef(arg, this.adEnv.curSymbolTable())) {
                            TapList formalActiveDS;
                            TapList tapList2 = formalActiveDS = i5 == nbArgs ? formalResultExitActive : formalArgsExitActive[i5];
                            if (argTreeInitBis == null) {
                                zonesToDiffInitDS = this.collectZonesFormalActiveAndActualPassive(argZonesTree, this.adEnv.toActiveTmpZones.tail, formalActiveDS, afterActiv, calledUnit, zonesToDiffInitDS);
                                TapIntList listZones = ZoneInfo.listAllZones(argZonesTree, false);
                                if (listZones != null && i5 < nbArgs && TapIntList.contains(this.adEnv.toActiveTmpZones.tail, listZones.head) && TapList.oneTrue(formalActiveDS)) {
                                    treesToDiffInitDS = new TapList<TapTriplet<Tree, WrapperTypeSpec, Tree>>(new TapTriplet<Tree, WrapperTypeSpec, Tree>(arg, formalArgType, arg), treesToDiffInitDS);
                                }
                            }
                            if (TapList.oneTrue(formalArgWritten)) {
                                TapList formalActiveUS = i5 == nbArgs ? formalResultEntryActive : formalArgsEntryActive[i5];
                                TapList actualArgBeforeActive = i5 == nbArgs || actualArgsBeforeActive == null ? null : actualArgsBeforeActive[i5];
                                WrapperTypeSpec formalType = i5 < nbArgs ? formalArgType : null;
                                treesToDiffInitUS = this.collectTreesToDiffInitAfterDiffCall(arg, ProcedureCallDifferentiator.isAccessedThroughPointerOrIndex(arg, this.adEnv.curSymbolTable(), this.adEnv.curUnit().language(), calledUnit, i5 + 1), this.adEnv.curSymbolTable().typeOf(arg), formalType, argZonesTree, formalActiveDS, formalActiveUS, formalArgWritten, actualArgBeforeActive, calledUnit, treesToDiffInitUS, null, null);
                            }
                        }
                    }
                    if (ILUtils.isNullOrNone(argTreeCopyDiff)) continue;
                    if (mustBeNameEq) {
                        Tree argName = this.getNewParamName(i5 == nbArgs ? -1 : i5, calledUnit, true, this.curDiffVarSort(), diffCalledUnit);
                        argTreeCopyDiff = ILUtils.build(132, argName, argTreeCopyDiff);
                    }
                    tlNewArgs = tlNewArgs.placdl(argTreeCopyDiff);
                }
                if (this.multiDirMode()) {
                    Tree nbDirsVar = this.varRefDifferentiator().buildDirNumberReference(bwdSymbolTable);
                    tlNewArgs = tlNewArgs.placdl(nbDirsVar);
                }
                if (!(!TapEnv.spareDiffReinitializations() && TapEnv.dbadMode() != -1 || calledUnit.isIntrinsic() || afterActiv == null || this.adEnv.activeCalledFromContext)) {
                    for (i5 = nDdZ - 1; i5 >= 0; --i5) {
                        if (afterActiv.getDeclared(i5, this.curDiffVectorMap()) || !formalExitActive.getDeclared(i5, this.curDiffVectorMap()) || TapList.contains(zonesToDiffInitDS, zoneInfo = this.adEnv.curSymbolTable().declaredZoneInfo(i5, this.adEnv.diffKind))) continue;
                        zonesToDiffInitDS = new TapList<ZoneInfo>(zoneInfo, zonesToDiffInitDS);
                    }
                    for (i5 = nSEdZ - 1; i5 >= 0; --i5) {
                        if (afterActiv.getSideEffect(i5) || !formalExitActive.getSideEffect(i5)) continue;
                        zoneInfo = this.adEnv.curUnit().sideEffectZoneInfo(i5, this.adEnv.diffKind);
                        zoneInfoName = zoneInfo.sideEffectZoneName();
                        TapEnv.fileWarning(15, callTree, "(AD14) Differentiating this call to " + calledUnit.name + " needs to initialize derivative of undeclared side-effect variable: " + zoneInfoName);
                        this.adEnv.addInHiddenDiffInitVariables(zoneInfo);
                    }
                }
                Tree diffCalledUnitName = this.varRefDifferentiator().diffSymbolTree(calledActivity, ILUtils.build(94, calledUnit.name), bwdSymbolTable, false, true, false, callTree, false, calledDiffSort, calledDiffSort, 1, null);
                if (diffCalledUnit != null) {
                    CallGraph.addCallArrow(this.curDiffUnit(), 1, diffCalledUnit);
                }
                adjCall = ILUtils.buildCall(diffCalledUnitName, ILUtils.build(70, hdNewArgs.tail));
                int lineNumber = ILUtils.getLineNumber(callTree);
                if (lineNumber != 0) {
                    ILUtils.getCalledName(adjCall).setAnnotation("line", ILUtils.build(101, lineNumber));
                }
            }
            this.varRefDifferentiator().popDiffContext();
            this.placePopRebases(headRestoreAfterAdjoint.tail, false, isJoint);
            if (mustDiffCall) {
                Tree diffInitTree;
                while (treesToDiffInitUS != null) {
                    Tree treeToDiffReinit = (Tree)treesToDiffInitUS.head;
                    diffInitTree = this.blockDifferentiator().makeDiffInitialization(treeToDiffReinit, this.adEnv.curSymbolTable(), bwdSymbolTable, fwdSymbolTable, null, false, null, true);
                    if (diffInitTree != null) {
                        this.blockDifferentiator().addFuturePlainNodeBwd(diffInitTree, null, false, ILUtils.usedVarsInExp(treeToDiffReinit, null, false), null, null, new TapList<Tree>(treeToDiffReinit, null), false, false, "Reinit tdiff after adj-call", false);
                    }
                    treesToDiffInitUS = treesToDiffInitUS.tail;
                }
                this.blockDifferentiator().addFuturePlainNodeBwd(adjCall, null, false, readRefs, writtenRefs, readAdjRefs, writtenAdjRefs, calledUnit.isExternal(), true, "Adjoint call", true);
                while (zonesToDiffInitDS != null) {
                    zoneInfo = (ZoneInfo)zonesToDiffInitDS.head;
                    diffInitTree = this.blockDifferentiator().makeDiffInitialization(zoneInfo.accessTree, this.adEnv.curSymbolTable(), bwdSymbolTable, fwdSymbolTable, zoneInfo, true, null, true);
                    if (diffInitTree != null) {
                        this.blockDifferentiator().addFuturePlainNodeBwd(diffInitTree, null, false, ILUtils.usedVarsInExp(zoneInfo.accessTree, null, false), null, null, new TapList<Tree>(zoneInfo.accessTree, null), false, false, "Reinit-zero diff before adj-call", false);
                    }
                    zonesToDiffInitDS = zonesToDiffInitDS.tail;
                }
                while (treesToDiffInitDS != null) {
                    TapTriplet toDiffInitDS = (TapTriplet)treesToDiffInitDS.head;
                    Tree treeToDiffReinit = (Tree)toDiffInitDS.first;
                    Tree srcArg = (Tree)toDiffInitDS.third;
                    diffInitTree = this.makeDiffInitializationOfCallArgument(treeToDiffReinit, srcArg, bwdSymbolTable, this.adEnv.curSymbolTable().typeOf(srcArg), (WrapperTypeSpec)toDiffInitDS.second, null, false, null, true);
                    if (diffInitTree != null) {
                        this.blockDifferentiator().addFuturePlainNodeBwd(diffInitTree, null, false, ILUtils.usedVarsInExp(treeToDiffReinit, null, false), null, null, new TapList<Tree>(treeToDiffReinit, null), false, false, "Reinit tdiff before adj-call", false);
                    }
                    treesToDiffInitDS = treesToDiffInitDS.tail;
                }
            } else if (resultTree != null && beforeActiv != null) {
                TapList<?> resZonesTree = this.adEnv.curSymbolTable().treeOfZonesOfValue(resultTree, null, this.adEnv.curInstruction(), null);
                resZonesTree = TapList.copyTree(resZonesTree);
                DataFlowAnalyzer.includePointedElementsInTree(resZonesTree, null, null, true, this.adEnv.curSymbolTable(), this.adEnv.curInstruction(), calledUnit, false, true);
                TapIntList resZones = ZoneInfo.listAllZones(resZonesTree, true);
                boolean resTmp = TapIntList.intersects(resZones, this.adEnv.toActiveTmpZones.tail);
                TapIntList resDiffKindVectorIndices = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(resZones, this.adEnv.diffKind, this.curDiffVectorMap(), this.adEnv.curSymbolTable(), calledUnit);
                if (resTmp || beforeActiv.intersects(resDiffKindVectorIndices)) {
                    Tree diffResultTree = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), resultTree, bwdSymbolTable, this.adEnv.curUnit().isFortran(), resultTree, false, true, null);
                    this.blockDifferentiator().addFutureSetDiffNodeBwd(new DiffAssignmentNode(diffResultTree, 3, null, null, resultTree, ILUtils.usedVarsInExp(resultTree, null, false), null, null, new TapList<Tree>(resultTree, null)), "Zero-reset diff of call result");
                }
            }
            if (normalCheckpointedCall) {
                if (headLookBeforeAdjoint.tail != null) {
                    Tree treeForLook;
                    boolean reallyNeedsToLook = this.usesTheStack(headLookBeforeAdjoint.tail);
                    if (reallyNeedsToLook) {
                        treeForLook = ILUtils.buildCall(ILUtils.build(94, "adStack_endRepeat"), ILUtils.build(70));
                        this.blockDifferentiator().addFuturePlainNodeBwd(treeForLook, null, false, null, null, null, null, false, true, "End repeated stack access", false);
                        treeForLook = ILUtils.buildCall(ILUtils.build(94, "adStack_resetRepeat"), ILUtils.build(70));
                        this.blockDifferentiator().addFuturePlainNodeBwd(treeForLook, null, false, null, null, null, null, false, true, "Reset repeated stack access", false);
                    }
                    this.placePopRebases(headLookBeforeAdjoint.tail, true, isJoint);
                    if (reallyNeedsToLook) {
                        treeForLook = ILUtils.buildCall(ILUtils.build(94, "adStack_startRepeat"), ILUtils.build(70));
                        this.blockDifferentiator().addFuturePlainNodeBwd(treeForLook, null, false, null, null, null, null, false, true, "Start repeated stack access", false);
                    }
                }
                this.placePopRebases(headRestoreBeforeAdjoint.tail, true, isJoint);
            }
            TapList<Object> tailSaveBeforeCall = headSaveBeforeCall;
            while (tailSaveBeforeCall.tail != null) {
                Tree rwrwTree;
                TapPair nextSaves = (TapPair)tailSaveBeforeCall.tail.head;
                tailSaveBeforeCall.tail = tailSaveBeforeCall.tail.tail;
                if (nextSaves.second != null) {
                    Tree saveDiff = ((RefDescriptor)nextSaves.second).makePush();
                    rwrwTree = null;
                    if (saveDiff.opCode() == 30) {
                        rwrwTree = ILUtils.getArguments(saveDiff).down(1);
                    } else if (saveDiff.opCode() == 13) {
                        rwrwTree = saveDiff.down(2);
                    } else if (saveDiff.opCode() == 96) {
                        rwrwTree = ILUtils.getArguments(saveDiff.down(2).down(1)).down(1);
                    }
                    this.blockDifferentiator().addFuturePlainNodeFwd(saveDiff, null, false, null, null, new TapList<Tree>(rwrwTree, null), null, false, true, "Take DIFF snapshot", false);
                }
                if (nextSaves.first == null) continue;
                Tree savePrimal = ((RefDescriptor)nextSaves.first).makePush();
                rwrwTree = null;
                if (savePrimal.opCode() == 30) {
                    rwrwTree = ILUtils.getArguments(savePrimal).down(1);
                } else if (savePrimal.opCode() == 13) {
                    rwrwTree = savePrimal.down(2);
                } else if (savePrimal.opCode() == 96) {
                    rwrwTree = ILUtils.getArguments(savePrimal.down(2).down(1)).down(1);
                }
                this.blockDifferentiator().addFuturePlainNodeFwd(savePrimal, null, false, new TapList<Tree>(rwrwTree, null), null, null, null, false, true, "Take snapshot", false);
            }
        }
        if (callIsLive) {
            Tree fwdTree;
            Tree[] args;
            TapPair<Object, Object> refsRW = new TapPair<Object, Object>(null, null);
            this.fillCallRefsRW(callTree, resultTree, calledUnit, refsRW);
            if (mustDiffCall && (calledUnit.isStandard() || calledUnit.isExternal()) && (this.adEnv.curUnitIsContext || splitAdjointCall)) {
                Tree fwdCallTree;
                Tree fwdTree2 = null;
                if (this.adEnv.activeCalledFromContext && splitAdjointCall) {
                    fwdTree2 = this.differentiateProcedureHeader(ILUtils.copy(callTree), resultTree, calledActivity, fwdSymbolTable, this.curFwdDiffUnit().privateSymbolTable(), 4, null);
                    args = ILUtils.getArguments(fwdTree2).children();
                    for (int i = args.length - 1; i >= 0; --i) {
                        if (!this.adEnv.curSymbolTable().identIsAFunction(args[i])) continue;
                        args[i].setAnnotation("isFunctionName", Boolean.TRUE);
                    }
                    this.blockDifferentiator().addFuturePlainNodeBwd(fwdTree2, null, false, (TapList)refsRW.first, (TapList)refsRW.second, null, null, true, true, "BWD split (in context) adjoint call", false);
                    Unit bwdDiffCalledUnit = this.adEnv.getDiffOfUnit(calledUnit, calledActivity, 4);
                    if (bwdDiffCalledUnit != null) {
                        CallGraph.addCallArrow(this.curFwdDiffUnit(), 1, bwdDiffCalledUnit);
                    }
                }
                int thisDiffMode = 3;
                if (!(!this.adEnv.curUnitIsContext || this.adEnv.activeCalledFromContext && splitAdjointCall)) {
                    thisDiffMode = 2;
                }
                fwdTree = fwdCallTree = this.differentiateProcedureHeader(ILUtils.copy(callTree), resultTree, calledActivity, fwdSymbolTable, this.curFwdDiffUnit().privateSymbolTable(), thisDiffMode, null);
                args = ILUtils.getArguments(fwdCallTree).children();
                for (int i = args.length - 1; i >= 0; --i) {
                    if (!this.adEnv.curSymbolTable().identIsAFunction(args[i])) continue;
                    args[i].setAnnotation("isFunctionName", Boolean.TRUE);
                }
                if (resultTree != null && !this.adEnv.activeCalledFromContext) {
                    fwdTree = ILUtils.build(13, ILUtils.copy(resultTree), fwdTree);
                }
                if (this.adEnv.activeCalledFromContext) {
                    this.blockDifferentiator().addFuturePlainNodeBwd(fwdTree, this.adEnv.curInstruction().whereMask(), false, (TapList)refsRW.first, (TapList)refsRW.second, null, null, true, true, "context adjoint call", false);
                } else {
                    this.blockDifferentiator().addFuturePlainNodeFwd(fwdTree, this.adEnv.curInstruction().whereMask(), false, (TapList)refsRW.first, (TapList)refsRW.second, null, null, calledUnit.isExternal(), true, "FWD split adjoint call", false);
                }
                Unit fwdDiffCalledUnit = this.adEnv.getDiffOfUnit(calledUnit, calledActivity, thisDiffMode);
                if (fwdDiffCalledUnit != null) {
                    CallGraph.addCallArrow(this.curFwdDiffUnit(), 1, fwdDiffCalledUnit);
                }
            } else {
                Tree sourceTreeAnnotation = (Tree)callTree.getAnnotation("sourcetree");
                Tree fwdCallTree = sourceTreeAnnotation != null && sourceTreeAnnotation.opCode() == 30 ? ILUtils.copy(sourceTreeAnnotation) : ILUtils.copy(callTree);
                args = ILUtils.getArguments(fwdCallTree).children();
                for (int i = args.length - 1; i >= 0; --i) {
                    if (!this.adEnv.curSymbolTable().identIsAFunction(args[i])) continue;
                    args[i].setAnnotation("isFunctionName", Boolean.TRUE);
                }
                fwdTree = fwdCallTree;
                if (resultTree != null) {
                    fwdTree = ILUtils.build(13, ILUtils.copy(resultTree), fwdTree);
                }
                this.blockDifferentiator().addFuturePlainNodeFwd(fwdTree, this.adEnv.curInstruction().whereMask(), false, (TapList)refsRW.first, (TapList)refsRW.second, null, null, calledUnit.isExternal(), true, "Copy of primal call", false);
                Unit primalCalledUnit = this.adEnv.getPrimalCopyOfOrigUnit(calledUnit);
                if (primalCalledUnit == null) {
                    primalCalledUnit = calledUnit;
                }
                if (primalCalledUnit != null) {
                    CallGraph.addCallArrow(this.curFwdDiffUnit(), 1, primalCalledUnit);
                }
            }
        }
    }

    private void placePopRebases(TapList<TapPair<RefDescriptor, RefDescriptor>> refsToPop, boolean beforeCall, boolean isJoint) {
        while (refsToPop != null) {
            Tree popTree;
            RefDescriptor nonNullRefDescriptor;
            RefDescriptor refDescriptor = (RefDescriptor)((TapPair)refsToPop.head).first;
            RefDescriptor refDescriptorDiff = (RefDescriptor)((TapPair)refsToPop.head).second;
            RefDescriptor refDescriptor2 = nonNullRefDescriptor = refDescriptor != null ? refDescriptor : refDescriptorDiff;
            if (TypeSpec.isA(nonNullRefDescriptor.elementType, 6)) {
                boolean rebaseOnDiffPtr;
                Tree refTree = nonNullRefDescriptor.refTree();
                boolean rebasePrimal = refDescriptor != null && DataFlowAnalyzer.mayPointToRelocated(refTree, false, this.adEnv.curInstruction(), this.adEnv.curSymbolTable(), isJoint);
                boolean bl = rebaseOnDiffPtr = refDescriptorDiff != null && DataFlowAnalyzer.mayPointToRelocated(refTree, true, this.adEnv.curInstruction(), this.adEnv.curSymbolTable(), isJoint);
                if (rebasePrimal || rebaseOnDiffPtr) {
                    ++this.blockDifferentiator().numRebase;
                    Tree rebaseTree = nonNullRefDescriptor.makeRebase(rebasePrimal ? null : new TapList<Boolean>(Boolean.TRUE, null), rebaseOnDiffPtr ? null : new TapList<Boolean>(Boolean.TRUE, null), rebaseOnDiffPtr ? refDescriptorDiff.altRootIdent : null, TapEnv.dbadMode() == -1 ? this.blockDifferentiator().numRebase : -1);
                    if (rebaseTree != null) {
                        this.adEnv.usesADMM = true;
                        TapList<Tree> writtenTrees = nonNullRefDescriptor.collectTrees(null);
                        this.blockDifferentiator().addFuturePlainNodeBwd(rebaseTree, null, false, ILUtils.usedVarsInTreeOfExps(writtenTrees, null, true), rebasePrimal ? writtenTrees : null, rebaseOnDiffPtr ? writtenTrees : null, rebaseOnDiffPtr ? writtenTrees : null, false, false, "Rebase pointer(s) after their restoration", false);
                    }
                }
            }
            if (refDescriptorDiff != null) {
                refDescriptorDiff.toBranchVariable = this.flowGraphDifferentiator().toBranchVariable;
                popTree = refDescriptorDiff.makePop();
                Tree refTree = refDescriptorDiff.refTree();
                this.blockDifferentiator().addFuturePlainNodeBwd(popTree, null, false, ILUtils.usedVarsInExp(refTree, null, false), null, null, new TapList<Tree>(refTree, null), false, true, "Restore DIFF snapshot " + (beforeCall ? "before" : "after") + " adjoint call", false);
            }
            if (refDescriptor != null) {
                refDescriptor.toBranchVariable = this.flowGraphDifferentiator().toBranchVariable;
                popTree = refDescriptor.makePop();
                Tree refTree = refDescriptor.refTree();
                this.blockDifferentiator().addFuturePlainNodeBwd(popTree, null, false, ILUtils.usedVarsInExp(refTree, null, false), new TapList<Tree>(refTree, null), null, null, false, true, "Restore snapshot " + (beforeCall ? "before" : "after") + " adjoint call", false);
            }
            refsToPop = refsToPop.tail;
        }
    }

    protected void buildDiffInstructionsOfMPICall(Tree callTree, Tree result, int differentiationMode, Unit calledUnit, ActivityPattern calledActivity, MPIcallInfo messagePassingInfo, boolean mustDiffOperation, SymbolTable fwdSymbolTable, SymbolTable bwdSymbolTable, BoolVector beforeActiv, BoolVector afterActiv, BoolVector beforeUseful, BoolVector afterUseful) {
        TapIntList channelZones = null;
        if (messagePassingInfo != null) {
            channelZones = messagePassingInfo.findMessagePassingChannelZones(this.adEnv.srcCallGraph());
        }
        if (mustDiffOperation) {
            TapList<Tree> readTrees;
            TapList writtenDiffTrees;
            Tree initTree;
            TapPair<Object, Object> refsRW = new TapPair<Object, Object>(null, null);
            TapPair<Object, Object> diffRefsRW = new TapPair<Object, Object>(null, null);
            TapList<Object> toNecessaryInitsUS = new TapList<Object>(null, null);
            TapList<Object> toNecessaryInitsDS = new TapList<Object>(null, null);
            Tree fwdCallTree = this.differentiateMessagePassingCall(callTree, calledUnit, calledActivity, differentiationMode == 1 ? 1 : 3, fwdSymbolTable, refsRW, diffRefsRW, beforeActiv, afterActiv, toNecessaryInitsUS, toNecessaryInitsDS, messagePassingInfo);
            toNecessaryInitsUS = toNecessaryInitsUS.tail;
            while (toNecessaryInitsUS != null) {
                initTree = (Tree)((TapPair)toNecessaryInitsUS.head).second;
                writtenDiffTrees = (TapList)((TapPair)toNecessaryInitsUS.head).first;
                readTrees = ILUtils.usedVarsInTreeOfExps(writtenDiffTrees, null, false);
                this.blockDifferentiator().addFuturePlainNodeFwd(initTree, null, false, readTrees, null, null, writtenDiffTrees, false, false, "Needed diff MP pre-init", false);
                toNecessaryInitsUS = toNecessaryInitsUS.tail;
            }
            if (fwdCallTree != null) {
                this.blockDifferentiator().addFuturePlainNodeFwd(fwdCallTree, null, false, (TapList)refsRW.first, (TapList)refsRW.second, (TapList)diffRefsRW.first, (TapList)diffRefsRW.second, false, true, (differentiationMode == 1 ? "Tangent" : "FWD Adjoint") + " MPI call", differentiationMode == 1);
            }
            toNecessaryInitsDS = toNecessaryInitsDS.tail;
            while (toNecessaryInitsDS != null) {
                initTree = (Tree)((TapPair)toNecessaryInitsDS.head).second;
                writtenDiffTrees = (TapList)((TapPair)toNecessaryInitsDS.head).first;
                readTrees = ILUtils.usedVarsInTreeOfExps(writtenDiffTrees, null, false);
                this.blockDifferentiator().addFuturePlainNodeFwd(initTree, null, false, readTrees, null, null, writtenDiffTrees, false, false, "Needed diff MP post-init", false);
                toNecessaryInitsDS = toNecessaryInitsDS.tail;
            }
            if (differentiationMode == -1 || differentiationMode == -2) {
                refsRW = new TapPair<Object, Object>(null, null);
                diffRefsRW = new TapPair<Object, Object>(null, null);
                toNecessaryInitsUS = new TapList<Object>(null, null);
                toNecessaryInitsDS = new TapList<Object>(null, null);
                this.varRefDifferentiator().pushDiffContext(1);
                Tree bwdCallTree = this.differentiateMessagePassingCall(callTree, calledUnit, calledActivity, 4, bwdSymbolTable, refsRW, diffRefsRW, beforeActiv, afterActiv, toNecessaryInitsUS, toNecessaryInitsDS, messagePassingInfo);
                this.varRefDifferentiator().popDiffContext();
                toNecessaryInitsUS = toNecessaryInitsUS.tail;
                while (toNecessaryInitsUS != null) {
                    initTree = (Tree)((TapPair)toNecessaryInitsUS.head).second;
                    writtenDiffTrees = (TapList)((TapPair)toNecessaryInitsUS.head).first;
                    readTrees = ILUtils.usedVarsInTreeOfExps(writtenDiffTrees, null, false);
                    this.blockDifferentiator().addFuturePlainNodeBwd(initTree, null, false, readTrees, null, null, writtenDiffTrees, false, false, "Needed diff MP post-init", false);
                    toNecessaryInitsUS = toNecessaryInitsUS.tail;
                }
                if (bwdCallTree != null) {
                    int lineNumber = ILUtils.getLineNumber(callTree);
                    if (lineNumber != 0) {
                        ILUtils.getCalledName(bwdCallTree).setAnnotation("line", ILUtils.build(101, lineNumber));
                    }
                    this.blockDifferentiator().addFuturePlainNodeBwd(bwdCallTree, null, false, (TapList)refsRW.first, (TapList)refsRW.second, (TapList)diffRefsRW.first, (TapList)diffRefsRW.second, false, true, "BWD Adjoint MPI call", true);
                }
                toNecessaryInitsDS = toNecessaryInitsDS.tail;
                while (toNecessaryInitsDS != null) {
                    initTree = (Tree)((TapPair)toNecessaryInitsDS.head).second;
                    writtenDiffTrees = (TapList)((TapPair)toNecessaryInitsDS.head).first;
                    readTrees = ILUtils.usedVarsInTreeOfExps(writtenDiffTrees, null, false);
                    this.blockDifferentiator().addFuturePlainNodeBwd(initTree, null, false, readTrees, null, null, writtenDiffTrees, false, false, "Needed diff MP pre-init", false);
                    toNecessaryInitsDS = toNecessaryInitsDS.tail;
                }
                if (ILUtils.isCallingString(bwdCallTree, "bw_ampi_irecv", false)) {
                    Tree passedRef = ILUtils.getArguments(callTree).down(1);
                    TapList<Object> passedZonesTree = this.adEnv.curSymbolTable().treeOfZonesOfValue(passedRef, null, this.adEnv.curInstruction(), null);
                    if (this.adEnv.curUnit().isCorMore() && passedZonesTree != null) {
                        passedZonesTree = TapList.copyTree(passedZonesTree);
                        DataFlowAnalyzer.includePointedElementsInTree(passedZonesTree, null, null, false, this.adEnv.curSymbolTable(), this.adEnv.curInstruction(), null, false, true);
                        passedZonesTree = passedZonesTree.tail;
                    }
                    TapIntList passedZonesList = ZoneInfo.listAllZones(passedZonesTree, false);
                    TapEnv.fileWarning(-1, callTree, "(Adjoint of AMPI_Irecv) an AMPI_Turn will be required on " + ILUtils.toString(passedRef) + " before its BW_AMPI_Wait");
                    DataFlowAnalyzer.setExtendedDeclared(this.adEnv.curActivity().zonesMPIiReceived(), this.curDiffVectorMap(), this.adEnv.diffKind, passedZonesList, true, this.adEnv.curSymbolTable());
                }
            }
        } else {
            this.blockDifferentiator().addFuturePlainNodeFwd(ILUtils.removeSourceCodeAnnot(ILUtils.copy(callTree)), null, false, null, null, null, null, false, true, "Copy of primal MPI call", true);
        }
    }

    private Tree differentiateMessagePassingCall(Tree callTree, Unit calledUnit, ActivityPattern calledActivity, int diffMode, SymbolTable diffSymbolTable, TapPair<TapList<Tree>, TapList<Tree>> refsRW, TapPair<TapList<Tree>, TapList<Tree>> diffRefsRW, BoolVector beforeActiv, BoolVector afterActiv, TapList<TapPair<TapList<Tree>, Tree>> toNecessaryInitsUS, TapList<TapPair<TapList<Tree>, Tree>> toNecessaryInitsDS, MPIcallInfo mpiCallInfo) {
        ZoneInfo zoneInfo;
        UnitDiffInfo calledDiffInfo = this.callGraphDifferentiator().getUnitDiffInfo(calledUnit);
        FunctionTypeSpec calledFunctionTypeSpec = (FunctionTypeSpec)callTree.getAnnotation("functionTypeSpec");
        if (calledFunctionTypeSpec == null) {
            calledFunctionTypeSpec = calledUnit.functionTypeSpec();
        }
        CallArrow callArrow = CallGraph.getCallArrow(this.adEnv.curUnit(), calledUnit);
        int nDZ = this.adEnv.curSymbolTable().declaredZonesNb(0);
        int nDdZ = this.adEnv.curSymbolTable().declaredZonesNb(this.adEnv.diffKind);
        int nSEdZ = this.adEnv.curUnit().sideEffectZonesNb(this.adEnv.diffKind);
        Tree[] actualArgs = ILUtils.getArguments(callTree).children();
        int nbArgs = actualArgs.length;
        if (nbArgs > calledUnit.functionTypeSpec().argumentsTypes.length) {
            nbArgs = calledUnit.functionTypeSpec().argumentsTypes.length;
        }
        boolean[] formalArgsActivity = null;
        BoolVector formalCallActive = new BoolVector(nSEdZ + nDdZ);
        BoolVector formalExitActive = new BoolVector(nSEdZ + nDdZ);
        BoolVector callR = new BoolVector(this.curNSEZ() + nDZ);
        BoolVector callW = new BoolVector(this.curNSEZ() + nDZ);
        TapList[] formalArgsCallActive = null;
        TapList[] formalArgsExitActive = null;
        if (calledDiffInfo != null && calledActivity != null) {
            formalArgsActivity = calledDiffInfo.getUnitFormalArgsActivityS(calledActivity);
            formalArgsCallActive = DataFlowAnalyzer.propagateDataToCaller(calledActivity.callActivity(), null, null, actualArgs.length, formalCallActive, this.curDiffVectorMap(), null, this.adEnv.curInstruction(), callArrow, true, true, this.adEnv.diffKind);
            formalArgsExitActive = DataFlowAnalyzer.propagateDataToCaller(calledActivity.exitActivity(), null, null, actualArgs.length, formalExitActive, this.curDiffVectorMap(), null, this.adEnv.curInstruction(), callArrow, true, true, this.adEnv.diffKind);
        }
        TapList[] paramsR = DataFlowAnalyzer.propagateDataToCaller(calledUnit.unitInOutPossiblyR(), null, null, actualArgs.length, callR, this.curVectorMap(), null, this.adEnv.curInstruction(), callArrow, true, true, 0);
        TapList[] paramsW = DataFlowAnalyzer.propagateDataToCaller(calledUnit.unitInOutPossiblyW(), null, null, actualArgs.length, callW, this.curVectorMap(), null, this.adEnv.curInstruction(), callArrow, true, false, 0);
        TapList<Tree> newArgs = null;
        Object iterators = null;
        Unit diffCalledUnit = calledDiffInfo.getTangent(calledActivity);
        int firstOrderingProblem = ProcedureCallDifferentiator.findNameEqOrNone(callTree);
        TapList<ZoneInfo> zonesToDiffInitUS = null;
        TapList<ZoneInfo> zonesToDiffInitDS = null;
        TapList tagsToDiffInit = null;
        for (int i = nbArgs - 1; i >= 0; --i) {
            Tree argName;
            Tree actualArg = actualArgs[i];
            Tree copiedArg = null;
            if (mpiCallInfo != null && (mpiCallInfo.argumentIsABuffer(i + 1) || mpiCallInfo.argumentIsAReduceOp(i + 1) || mpiCallInfo.argumentIsAType(i + 1))) {
                if (diffMode != 3) {
                    Tree diffTree;
                    if (mpiCallInfo.argumentIsABuffer(i + 1) && ILUtils.isIdent(actualArg, "mpi_in_place", !this.adEnv.curUnit().isFortran())) {
                        diffTree = ILUtils.copy(actualArg);
                        newArgs = new TapList<Tree>(diffTree, newArgs);
                    } else if (mpiCallInfo.argumentIsAType(i + 1) || mpiCallInfo.argumentIsAReduceOp(i + 1) || i < formalArgsActivity.length - 1 && formalArgsActivity[i]) {
                        if (diffMode == 1) {
                            ToObject<Tree> toActualArg = new ToObject<Tree>(actualArg);
                            diffTree = this.blockDifferentiator().tangentDiffExpr(toActualArg, beforeActiv, refsRW, diffRefsRW);
                            actualArg = toActualArg.obj();
                        } else {
                            diffTree = null;
                        }
                        if (diffTree == null) {
                            if (mpiCallInfo.argumentIsAType(i + 1)) {
                                diffTree = ILUtils.copy(actualArg);
                            } else if (mpiCallInfo.argumentIsAReduceOp(i + 1)) {
                                diffTree = ILUtils.build(101, 0);
                            } else if (ILUtils.isAWritableVarRef(actualArg, this.adEnv.curSymbolTable())) {
                                diffTree = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), actualArg, diffSymbolTable, false, actualArg, false, true, null);
                            } else {
                                WrapperTypeSpec argType = calledFunctionTypeSpec.argumentsTypes[i];
                                if (argType != null && argType.wrappedType != null) {
                                    diffTree = argType.wrappedType.buildConstantZero();
                                }
                            }
                            if (diffTree == null) {
                                diffTree = PrimitiveTypeSpec.buildRealConstantZero();
                            }
                        }
                        if (TapList.oneTrue(paramsR[i])) {
                            diffRefsRW.first = ILUtils.addTreeInList(actualArg, (TapList)diffRefsRW.first);
                        }
                        if (TapList.oneTrue(paramsW[i])) {
                            diffRefsRW.second = ILUtils.addTreeInList(actualArg, (TapList)diffRefsRW.second);
                        }
                        if (firstOrderingProblem != -1 && (i >= firstOrderingProblem || actualArg.getAnnotation("sourcetree") != null)) {
                            argName = this.getNewParamName(i, calledUnit, true, 1, diffCalledUnit);
                            diffTree = ILUtils.build(132, argName, diffTree);
                        }
                        newArgs = new TapList<Tree>(MPIcallInfo.replaceMPIconstantsIfPossible(diffTree), newArgs);
                        if (TapEnv.spareDiffReinitializations() && ILUtils.isAWritableVarRef(actualArg, this.adEnv.curSymbolTable()) && mpiCallInfo.argumentIsABuffer(i + 1) && mpiCallInfo.argumentIsRead(i + 1)) {
                            TapList<?> argZonesTree = this.adEnv.curSymbolTable().treeOfZonesOfValue(actualArg, null, this.adEnv.curInstruction(), null);
                            argZonesTree = TapList.copyTree(argZonesTree);
                            DataFlowAnalyzer.includePointedElementsInTree(argZonesTree, null, null, true, this.adEnv.curSymbolTable(), this.adEnv.curInstruction(), calledUnit, false, true);
                            zonesToDiffInitUS = this.collectZonesFormalActiveAndActualPassive(argZonesTree, this.adEnv.toActiveTmpZones.tail, formalArgsCallActive[i], beforeActiv, calledUnit, zonesToDiffInitUS);
                            zonesToDiffInitDS = this.collectZonesFormalActiveAndActualPassive(argZonesTree, this.adEnv.toActiveTmpZones.tail, formalArgsExitActive[i], afterActiv, calledUnit, zonesToDiffInitDS);
                        }
                    }
                }
                if (diffMode != 4 || mpiCallInfo.isReduceCall()) {
                    copiedArg = ILUtils.copy(actualArg);
                }
            } else {
                copiedArg = ILUtils.copy(actualArg);
            }
            if (copiedArg != null) {
                if (actualArg.getAnnotation("sourcetree") != null) {
                    copiedArg = ILUtils.copy((Tree)actualArg.getAnnotation("sourcetree"));
                } else if (firstOrderingProblem != -1 && i >= firstOrderingProblem && actualArg.opCode() != 136) {
                    if (copiedArg.opCode() == 132) {
                        argName = copiedArg.cutChild(1);
                        copiedArg = copiedArg.cutChild(2);
                    } else {
                        argName = this.getNewParamName(i, calledUnit, false, -1, null);
                    }
                    copiedArg = ILUtils.build(132, argName, copiedArg);
                }
                newArgs = new TapList<Tree>(MPIcallInfo.replaceMPIconstantsIfPossible(copiedArg), newArgs);
            }
            refsRW.first = ILUtils.usedVarsInExp(actualArg, (TapList)refsRW.first, false);
            if (TapList.oneTrue(paramsR[i])) {
                refsRW.first = ILUtils.addTreeInList(actualArg, (TapList)refsRW.first);
            }
            if (!TapList.oneTrue(paramsW[i])) continue;
            refsRW.second = ILUtils.addTreeInList(actualArg, (TapList)refsRW.second);
        }
        while (zonesToDiffInitUS != null) {
            zoneInfo = (ZoneInfo)zonesToDiffInitUS.head;
            Tree zoneReinitTree = this.blockDifferentiator().makeDiffInitialization(zoneInfo.accessTree, this.adEnv.curSymbolTable(), diffSymbolTable, null, zoneInfo, true, null, true);
            if (zoneReinitTree != null) {
                toNecessaryInitsUS.placdl(new TapPair<TapList<Tree>, Tree>(new TapList<Tree>(zoneInfo.accessTree, null), zoneReinitTree));
            }
            zonesToDiffInitUS = zonesToDiffInitUS.tail;
        }
        while (tagsToDiffInit != null) {
            zoneInfo = (ZoneInfo)tagsToDiffInit.head;
            Tree zoneReinitTree = this.makeDiffTagInitialization(zoneInfo.accessTree, diffSymbolTable);
            toNecessaryInitsUS.placdl(new TapPair<TapList<Tree>, Tree>(new TapList<Tree>(zoneInfo.accessTree, null), zoneReinitTree));
            tagsToDiffInit = tagsToDiffInit.tail;
        }
        while (zonesToDiffInitDS != null) {
            zoneInfo = (ZoneInfo)zonesToDiffInitDS.head;
            Tree zoneReinitTree = this.blockDifferentiator().makeDiffInitialization(zoneInfo.accessTree, this.adEnv.curSymbolTable(), diffSymbolTable, null, zoneInfo, true, null, true);
            if (zoneReinitTree != null) {
                toNecessaryInitsDS.placdl(new TapPair<TapList<Tree>, Tree>(new TapList<Tree>(zoneInfo.accessTree, null), zoneReinitTree));
            }
            zonesToDiffInitDS = zonesToDiffInitDS.tail;
        }
        String modePrefix = "";
        if (mpiCallInfo != null) {
            if (diffMode == 1) {
                modePrefix = "TLS_";
            } else if (diffMode == 3) {
                modePrefix = mpiCallInfo.isCommCreation() ? "" : "FW_";
            } else {
                String string = modePrefix = mpiCallInfo.isReduceCall() ? "BWS_" : "BW_";
            }
        }
        if (mpiCallInfo == null && diffMode == 4) {
            return null;
        }
        if (mpiCallInfo != null && mpiCallInfo.isCommFree() && (diffMode == 3 || diffMode == 4)) {
            return null;
        }
        if (mpiCallInfo != null && diffMode == 4 && mpiCallInfo.isCommCreation()) {
            String lcFuncName = mpiCallInfo.funcName().toLowerCase();
            if (lcFuncName.endsWith("mpi_comm_split")) {
                newArgs = newArgs.tail.tail.tail;
            } else if (lcFuncName.endsWith("mpi_comm_create")) {
                newArgs = newArgs.tail.tail;
            } else if (lcFuncName.endsWith("mpi_comm_dup")) {
                newArgs = newArgs.tail;
            }
            return ILUtils.buildCall(ILUtils.build(94, "AMPI_Comm_free"), ILUtils.build(70, newArgs));
        }
        return ILUtils.buildCall(ILUtils.build(94, modePrefix + ILUtils.getCalledNameString(callTree)), ILUtils.build(70, newArgs));
    }

    private void fillCallRefsRW(Tree callTree, Tree resultTree, Unit calledUnit, TapPair<TapList<Tree>, TapList<Tree>> refsRW) {
        boolean hasRWinfo;
        CallArrow callArrow = CallGraph.getCallArrow(this.adEnv.curUnit(), calledUnit);
        int nDZ = this.adEnv.curSymbolTable().declaredZonesNb(0);
        Tree[] actualArgs = ILUtils.getArguments(callTree).children();
        int nbArgs = actualArgs.length;
        boolean conservativeWriteIfNoRWinfo = true;
        BoolVector zonesReadByThisCall = new BoolVector(this.curNSEZ() + nDZ);
        BoolVector zonesWrittenByThisCall = new BoolVector(this.curNSEZ() + nDZ);
        boolean bl = hasRWinfo = calledUnit.unitInOutR() != null;
        if (hasRWinfo) {
            DataFlowAnalyzer.propagateDataToCaller(calledUnit.unitInOutPossiblyR(), null, actualArgs, nbArgs, zonesReadByThisCall, this.curVectorMap(), null, this.adEnv.curInstruction(), callArrow, true, true, 0);
            DataFlowAnalyzer.propagateDataToCaller(calledUnit.unitInOutPossiblyW(), null, actualArgs, nbArgs, zonesWrittenByThisCall, this.curVectorMap(), null, this.adEnv.curInstruction(), callArrow, true, false, 0);
        }
        if (!calledUnit.isIntrinsic()) {
            Tree zoneTree = null;
            for (int i = nDZ - 1; i >= 0; --i) {
                ZoneInfo zoneInfo = this.adEnv.curSymbolTable().declaredZoneInfo(i, 0);
                if (zoneInfo == null || (zoneTree = zoneInfo.accessTree) == null) continue;
                if (!hasRWinfo || zonesReadByThisCall.getDeclared(i, this.curVectorMap())) {
                    refsRW.first = ILUtils.addTreeInList(zoneTree, (TapList)refsRW.first);
                }
                if (!(hasRWinfo ? zonesWrittenByThisCall.getDeclared(i, this.curVectorMap()) : conservativeWriteIfNoRWinfo)) continue;
                refsRW.second = ILUtils.addTreeInList(zoneTree, (TapList)refsRW.second);
            }
        }
        if (resultTree != null) {
            refsRW.first = ILUtils.usedVarsInExp(resultTree, (TapList)refsRW.first, false);
            refsRW.second = ILUtils.addTreeInList(resultTree, (TapList)refsRW.second);
        }
        for (int i = nbArgs - 1; i >= 0; --i) {
            refsRW.first = ILUtils.usedVarsInExp(actualArgs[i], (TapList)refsRW.first, false);
        }
    }

    private void collectRefDescriptorsToSave(BoolVector toSave, TapList[] toSaveArgs, BoolVector toSaveOnDiffPtr, TapList[] toSaveArgsOnDiffPtr, TapList<TapPair<RefDescriptor, RefDescriptor>> toVarsToPush, TapList<TapPair<RefDescriptor, RefDescriptor>> toVarsToPop1, TapList<TapPair<RefDescriptor, RefDescriptor>> toVarsToPop2, boolean isSbk, SymbolTable fwdSymbolTable, SymbolTable bwdSymbolTable, Unit calledUnit, FunctionTypeSpec functionTypeSpec, Tree[] args, int nbArgs, Tree resultTree, SplitForSave[] argsSplitForSave) {
        Tree baseVarTree;
        int nDZ = this.adEnv.curSymbolTable().declaredZonesNb(0);
        for (int i = nDZ - 1; i >= 0; --i) {
            RefDescriptor refDescriptor;
            RefDescriptor refDescriptorDiffPtr;
            ZoneInfo zoneInfo = this.adEnv.curSymbolTable().declaredZoneInfo(i, 0);
            if (zoneInfo == null || zoneInfo.accessTree == null || zoneInfo.zoneNb == this.adEnv.srcCallGraph().zoneNbOfAllIOStreams || this.adEnv.srcCallGraph().isAMessagePassingChannelZone(zoneInfo.zoneNb) || zoneInfo.isAllocatable || zoneInfo.comesFromAllocate()) continue;
            Tree zoneInfoVisibleAccessTree = this.adEnv.curSymbolTable().buildZoneVisibleAccessTree(zoneInfo);
            int rkOnDiffPtr = DataFlowAnalyzer.zoneInfoToVectorIndex(zoneInfo, 3, 3, this.curPtrVectorMap(), null);
            if (zoneInfoVisibleAccessTree != null && rkOnDiffPtr >= 0 && toSaveOnDiffPtr.get(rkOnDiffPtr)) {
                baseVarTree = ILUtils.baseTree(zoneInfoVisibleAccessTree);
                Tree diffBaseVar = null;
                if (baseVarTree != null) {
                    diffBaseVar = this.varRefDifferentiator().diffSymbolTree(this.adEnv.curActivity(), baseVarTree, fwdSymbolTable, true, false, false, null, false, this.curDiffVarSort(), this.curDiffUnitSort(), 0, baseVarTree);
                }
                refDescriptorDiffPtr = new RefDescriptor(zoneInfo, zoneInfoVisibleAccessTree, this.adEnv.curSymbolTable(), this.curFwdDiffUnit().privateSymbolTable(), null, diffBaseVar, true, null, this.curDiffUnit());
                this.blockDifferentiator().prepareRestoreOperations(refDescriptorDiffPtr, null, 0, fwdSymbolTable, bwdSymbolTable);
            } else {
                refDescriptorDiffPtr = null;
            }
            int rk = DataFlowAnalyzer.zoneInfoToVectorIndex(zoneInfo, 3, 0, this.curVectorMap(), null);
            if (zoneInfoVisibleAccessTree != null && toSave.get(rk)) {
                refDescriptor = new RefDescriptor(zoneInfo, zoneInfoVisibleAccessTree, this.adEnv.curSymbolTable(), this.curFwdDiffUnit().privateSymbolTable(), null, null, false, null, this.curDiffUnit());
                this.blockDifferentiator().prepareRestoreOperations(refDescriptor, null, 0, fwdSymbolTable, bwdSymbolTable);
            } else {
                refDescriptor = null;
            }
            if (refDescriptor == null && refDescriptorDiffPtr == null) continue;
            TapPair<Object, Object> twoRefDescriptors = new TapPair<Object, Object>(refDescriptor, refDescriptorDiffPtr);
            if (toVarsToPush != null) {
                toVarsToPush.tail = toVarsToPush.tail.placdl(twoRefDescriptors);
            }
            if (toVarsToPop1 != null) {
                toVarsToPop1.tail = toVarsToPop1.tail.placdl(twoRefDescriptors);
            }
            if (toVarsToPop2 == null) continue;
            toVarsToPop2.tail = toVarsToPop2.tail.placdl(twoRefDescriptors);
        }
        WrapperTypeSpec actualArgType = null;
        WrapperTypeSpec formalArgType = null;
        for (int i = nbArgs; i >= 0; --i) {
            Tree diffBaseVarBwd;
            boolean diffptrAlreadySaved;
            boolean primalAlreadySaved;
            boolean argZonesAreSpecial;
            boolean saveInDiff;
            Tree arg = i == nbArgs ? resultTree : args[i];
            baseVarTree = arg == null || arg.opCode() == 109 || arg.opCode() == 9 ? null : ILUtils.baseTree(arg);
            boolean saveInPrimal = TapList.oneTrue(toSaveArgs[i]) || !isSbk && i == nbArgs && arg != null && ADTBRAnalyzer.isTBR(this.adEnv.curActivity(), arg);
            boolean bl = saveInDiff = TapList.oneTrue(toSaveArgsOnDiffPtr[i]) || !isSbk && i == nbArgs && arg != null && ADTBRAnalyzer.isTBROnDiffPtr(this.adEnv.curActivity(), arg);
            if (saveInPrimal || saveInDiff) {
                TapList<?> argZonesTree = this.adEnv.curSymbolTable().treeOfZonesOfValue(arg, null, this.adEnv.curInstruction(), null);
                argZonesTree = TapList.copyTree(argZonesTree);
                DataFlowAnalyzer.includePointedElementsInTree(argZonesTree, null, null, true, this.adEnv.curSymbolTable(), this.adEnv.curInstruction(), calledUnit, false, true);
                TapIntList argZones = ZoneInfo.listAllZones(argZonesTree, true);
                argZonesAreSpecial = argZones == null || argZones.head >= this.adEnv.curSymbolTable().freeDeclaredZone(0);
                primalAlreadySaved = DataFlowAnalyzer.containsExtendedDeclared(toSave, this.curVectorMap(), 0, argZones, null, this.adEnv.curSymbolTable(), calledUnit);
                diffptrAlreadySaved = DataFlowAnalyzer.containsExtendedDeclared(toSaveOnDiffPtr, this.curPtrVectorMap(), 3, argZones, null, this.adEnv.curSymbolTable(), calledUnit);
                actualArgType = this.adEnv.curSymbolTable().typeOf(arg);
                WrapperTypeSpec wrapperTypeSpec = formalArgType = i == nbArgs ? functionTypeSpec.returnType : functionTypeSpec.argumentsTypes[i];
                if (this.adEnv.curUnit().isFortran() && calledUnit.isCorMore()) {
                    if (!TypeSpec.isA(actualArgType, 6) && TypeSpec.isA(formalArgType, 6)) {
                        formalArgType = ((PointerTypeSpec)formalArgType.wrappedType).destinationType;
                    }
                } else if (this.adEnv.curUnit().isCorMore() && calledUnit.isFortran() && TypeSpec.isA(actualArgType, 6) && !TypeSpec.isA(formalArgType, 6)) {
                    formalArgType = new WrapperTypeSpec(new PointerTypeSpec(formalArgType, null));
                }
                Tree arg2 = RefDescriptor.explicitWhenImplicitArray(arg, actualArgType, formalArgType, this.adEnv.curSymbolTable());
                argsSplitForSave[i].initIndexes(arg2, arg2 != arg, this.adEnv);
            } else {
                argZonesAreSpecial = false;
                primalAlreadySaved = false;
                diffptrAlreadySaved = false;
            }
            if (!argZonesAreSpecial && (!saveInDiff || diffptrAlreadySaved) && (!saveInPrimal || primalAlreadySaved)) continue;
            TapList<Object> subArgsSaveRestore = this.collectSubTreesToRestore(ILUtils.copy(argsSplitForSave[i].tree), argsSplitForSave[i].newSplitCopy(bwdSymbolTable), formalArgType, actualArgType, toSaveArgs[i], toSaveArgsOnDiffPtr[i], null, null);
            Tree diffBaseVarFwd = baseVarTree == null || !saveInDiff ? null : this.varRefDifferentiator().diffSymbolTree(this.adEnv.curActivity(), baseVarTree, fwdSymbolTable, true, false, false, null, false, this.curDiffVarSort(), this.curDiffUnitSort(), 0, baseVarTree);
            Tree tree = diffBaseVarBwd = baseVarTree == null || !saveInDiff ? null : this.varRefDifferentiator().diffSymbolTree(this.adEnv.curActivity(), baseVarTree, bwdSymbolTable, true, false, false, null, false, this.curDiffVarSort(), this.curDiffUnitSort(), 0, baseVarTree);
            while (subArgsSaveRestore != null) {
                RefDescriptor refDescriptorRestore;
                RefDescriptor refDescriptorSave;
                RefDescriptor refDescriptorRestoreDiffPtr;
                RefDescriptor refDescriptorSaveDiffPtr;
                Tree subArgSave = ((Tree[])subArgsSaveRestore.head)[0];
                Tree subArgRestore = ((Tree[])subArgsSaveRestore.head)[1];
                Tree subArgSaveDiff = ((Tree[])subArgsSaveRestore.head)[2];
                Tree subArgRestoreDiff = ((Tree[])subArgsSaveRestore.head)[3];
                if (subArgSaveDiff != null) {
                    refDescriptorSaveDiffPtr = new RefDescriptor(subArgSaveDiff, null, this.adEnv.curSymbolTable(), this.curDiffUnit().privateSymbolTable(), this.curFwdDiffUnit().privateSymbolTable(), diffBaseVarFwd, true, null, this.curDiffUnit());
                    refDescriptorRestoreDiffPtr = new RefDescriptor(subArgRestoreDiff, null, this.adEnv.curSymbolTable(), this.curDiffUnit().privateSymbolTable(), null, diffBaseVarBwd, true, null, this.curDiffUnit());
                    if (i != nbArgs) {
                        this.allowForUnsureWarningMessage(subArgSaveDiff, refDescriptorSaveDiffPtr, refDescriptorRestoreDiffPtr);
                    }
                    this.blockDifferentiator().prepareRestoreOperations(refDescriptorSaveDiffPtr, refDescriptorRestoreDiffPtr, 0, fwdSymbolTable, bwdSymbolTable);
                } else {
                    refDescriptorSaveDiffPtr = null;
                    refDescriptorRestoreDiffPtr = null;
                }
                if (subArgSave != null) {
                    refDescriptorSave = new RefDescriptor(subArgSave, null, this.adEnv.curSymbolTable(), this.curDiffUnit().privateSymbolTable(), this.curFwdDiffUnit().privateSymbolTable(), null, false, null, this.curDiffUnit());
                    refDescriptorRestore = new RefDescriptor(subArgRestore, null, this.adEnv.curSymbolTable(), this.curDiffUnit().privateSymbolTable(), null, null, false, null, this.curDiffUnit());
                    if (i != nbArgs) {
                        this.allowForUnsureWarningMessage(subArgSave, refDescriptorSave, refDescriptorRestore);
                    }
                    if (calledUnit.language() != this.curDiffUnit().language() && !calledUnit.passesByValue(i + 1, this.curDiffUnit().language()) && TypeSpec.isA(refDescriptorSave.completeType, 6) && TypeSpec.isA(refDescriptorSave.elementType, 6)) {
                        refDescriptorSave.completeType = ((PointerTypeSpec)refDescriptorSave.completeType.wrappedType).destinationType;
                        refDescriptorSave.elementType = ((PointerTypeSpec)refDescriptorSave.elementType.wrappedType).destinationType;
                        refDescriptorSave.addDeref();
                        refDescriptorSave.mayProtectAccesses = true;
                        refDescriptorRestore.completeType = ((PointerTypeSpec)refDescriptorRestore.completeType.wrappedType).destinationType;
                        refDescriptorRestore.elementType = ((PointerTypeSpec)refDescriptorRestore.elementType.wrappedType).destinationType;
                        refDescriptorRestore.addDeref();
                        refDescriptorRestore.mayProtectAccesses = true;
                    }
                    this.blockDifferentiator().prepareRestoreOperations(refDescriptorSave, refDescriptorRestore, 0, fwdSymbolTable, bwdSymbolTable);
                } else {
                    refDescriptorSave = null;
                    refDescriptorRestore = null;
                }
                if (toVarsToPush != null) {
                    toVarsToPush.tail = toVarsToPush.tail.placdl(new TapPair<Object, RefDescriptor>(refDescriptorSave, refDescriptorSaveDiffPtr));
                }
                if (toVarsToPop1 != null) {
                    toVarsToPop1.tail = toVarsToPop1.tail.placdl(new TapPair<Object, Object>(refDescriptorRestore, refDescriptorRestoreDiffPtr));
                }
                if (toVarsToPop2 != null) {
                    toVarsToPop2.tail = toVarsToPop2.tail.placdl(new TapPair<Object, Object>(refDescriptorRestore, refDescriptorRestoreDiffPtr));
                }
                subArgsSaveRestore = subArgsSaveRestore.tail;
            }
        }
    }

    private TapList<Tree[]> collectSubTreesToRestore(Tree treeForSave, Tree treeForRestore, WrapperTypeSpec type, WrapperTypeSpec actualType, TapList tbr, TapList tbrOnDiffPtr, TapList<Tree[]> collection, TapList<WrapperTypeSpec> dejaVu) {
        if (type == null || type.wrappedType == null) {
            collection = ProcedureCallDifferentiator.collectOneSubTreeToRestore(collection, treeForSave, treeForRestore, tbr, tbrOnDiffPtr);
        } else {
            switch (type.wrappedType.kind()) {
                case 2: {
                    WrapperTypeSpec actualElementType = TypeSpec.isA(actualType, 2) ? actualType.wrappedType.elementType() : null;
                    collection = this.collectSubTreesToRestore(treeForSave, treeForRestore, type.wrappedType.elementType(), actualElementType, tbr, tbrOnDiffPtr, collection, dejaVu);
                    break;
                }
                case 5: {
                    WrapperTypeSpec actualElementType = TypeSpec.isA(actualType, 5) ? actualType.wrappedType.elementType() : null;
                    collection = this.collectSubTreesToRestore(treeForSave, treeForRestore, type.wrappedType.elementType(), actualElementType, tbr, tbrOnDiffPtr, collection, dejaVu);
                    break;
                }
                case 21: {
                    int i;
                    Boolean fallback;
                    if (TapList.contains(dejaVu, type)) {
                        collection = ProcedureCallDifferentiator.collectOneSubTreeToRestore(collection, treeForSave, treeForRestore, tbr, tbrOnDiffPtr);
                        break;
                    }
                    dejaVu = new TapList<WrapperTypeSpec>(type, dejaVu);
                    CompositeTypeSpec compositeType = TypeSpec.isA(actualType, 21) ? (CompositeTypeSpec)actualType.wrappedType : (CompositeTypeSpec)type.wrappedType;
                    FieldDecl[] fields = compositeType.fields;
                    int maxi = fields.length;
                    if (tbr == null || !(tbr.head instanceof TapList)) {
                        fallback = TapList.oneTrue(tbr) ? Boolean.TRUE : Boolean.FALSE;
                        for (i = maxi; i > 0; --i) {
                            tbr = new TapList(new TapList<Boolean>(fallback, null), tbr);
                        }
                    }
                    if (tbrOnDiffPtr == null || !(tbrOnDiffPtr.head instanceof TapList)) {
                        fallback = TapList.oneTrue(tbrOnDiffPtr) ? Boolean.TRUE : Boolean.FALSE;
                        for (i = maxi; i > 0; --i) {
                            tbrOnDiffPtr = new TapList(new TapList<Boolean>(fallback, null), tbrOnDiffPtr);
                        }
                    }
                    for (int i2 = maxi - 1; i2 >= 0; --i2) {
                        Object nthTmp = TapList.nth(tbr, i2);
                        TapList nthTbr = nthTmp instanceof TapList ? (TapList)nthTmp : tbr;
                        nthTmp = TapList.nth(tbrOnDiffPtr, i2);
                        TapList nthTbrOnDiffPtr = nthTmp instanceof TapList ? (TapList)nthTmp : tbrOnDiffPtr;
                        if (fields[i2] != null && (nthTbr != null || nthTbrOnDiffPtr != null)) {
                            Tree buildTreeSave = ILUtils.build(73, ILUtils.copy(treeForSave), ILUtils.build(94, fields[i2].symbol));
                            ILUtils.setFieldRank(buildTreeSave.down(2), i2);
                            Tree buildTreeRestore = ILUtils.build(73, ILUtils.copy(treeForRestore), ILUtils.build(94, fields[i2].symbol));
                            ILUtils.setFieldRank(buildTreeRestore.down(2), i2);
                            collection = this.collectSubTreesToRestore(buildTreeSave, buildTreeRestore, fields[i2].type(), null, nthTbr, nthTbrOnDiffPtr, collection, dejaVu);
                            continue;
                        }
                        TapEnv.fileWarning(5, treeForSave, "(PUSH/POP of a structured object) problem for field " + (i2 + 1) + " of ref " + treeForSave + " of type " + compositeType.showType());
                    }
                    break;
                }
                case 6: {
                    TapList pointerTbrOnDiffPtr;
                    TapList pointerTbr;
                    boolean cleanTree;
                    WrapperTypeSpec actualDestinationType = TypeSpec.isA(actualType, 6) ? ((PointerTypeSpec)actualType.wrappedType).destinationType : null;
                    PointerTypeSpec pointerTypeSpec = (PointerTypeSpec)type.wrappedType;
                    int dimSize = -1;
                    if (pointerTypeSpec.offsetLength != null) {
                        dimSize = pointerTypeSpec.offsetLength.size();
                    }
                    if (dimSize == -1 && TypeSpec.isA(actualType, 6) && ((PointerTypeSpec)actualType.wrappedType).offsetLength != null) {
                        dimSize = ((PointerTypeSpec)actualType.wrappedType).offsetLength.size();
                    }
                    Tree arrayDimension = dimSize != -1 ? ILUtils.build(11, ILUtils.build(101, 0), dimSize == -1 ? ILUtils.build(136) : ILUtils.build(101, dimSize - 1), ILUtils.build(136)) : ILUtils.build(136);
                    boolean bl = cleanTree = tbr != null && tbr.head instanceof Boolean;
                    TapList tapList = cleanTree ? new TapList(tbr.head, null) : (pointerTbr = new TapList<Boolean>(TapList.oneTrue(tbr) ? Boolean.TRUE : Boolean.FALSE, null));
                    TapList<Boolean> pointedTbr = cleanTree ? tbr.tail : new TapList<Boolean>(TapList.oneTrue(tbr) ? Boolean.TRUE : Boolean.FALSE, null);
                    boolean bl2 = cleanTree = tbrOnDiffPtr != null && tbrOnDiffPtr.head instanceof Boolean;
                    TapList tapList2 = cleanTree ? new TapList(tbrOnDiffPtr.head, null) : (pointerTbrOnDiffPtr = new TapList<Boolean>(TapList.oneTrue(tbrOnDiffPtr) ? Boolean.TRUE : Boolean.FALSE, null));
                    TapList<Boolean> pointedTbrOnDiffPtr = cleanTree ? tbrOnDiffPtr.tail : new TapList<Boolean>(TapList.oneTrue(tbrOnDiffPtr) ? Boolean.TRUE : Boolean.FALSE, null);
                    collection = ProcedureCallDifferentiator.collectOneSubTreeToRestore(collection, treeForSave, treeForRestore, pointerTbr, pointerTbrOnDiffPtr);
                    collection = this.collectSubTreesToRestore(ILUtils.build(148, treeForSave, ILUtils.copy(arrayDimension)), ILUtils.build(148, treeForRestore, arrayDimension), pointerTypeSpec.destinationType, actualDestinationType, pointedTbr, pointedTbrOnDiffPtr, collection, dejaVu);
                    break;
                }
                default: {
                    collection = ProcedureCallDifferentiator.collectOneSubTreeToRestore(collection, treeForSave, treeForRestore, tbr, tbrOnDiffPtr);
                }
            }
        }
        return collection;
    }

    private static TapList<Tree[]> collectOneSubTreeToRestore(TapList<Tree[]> collection, Tree treeForSave, Tree treeForRestore, TapList tbr, TapList tbrOnDiffPtr) {
        boolean isTbr = TapList.oneTrue(tbr);
        boolean isTbrOnDiffPtr = TapList.oneTrue(tbrOnDiffPtr);
        if (isTbr || isTbrOnDiffPtr) {
            Tree[] component = new Tree[]{isTbr ? treeForSave : null, isTbr ? treeForRestore : null, isTbrOnDiffPtr ? treeForSave : null, isTbrOnDiffPtr ? treeForRestore : null};
            return new TapList<Tree[]>(component, collection);
        }
        return collection;
    }

    private void allowForUnsureWarningMessage(Tree subArgTree, RefDescriptor savedDescriptor, RefDescriptor restoredDescriptor) {
        TapIntList lz = this.adEnv.curSymbolTable().listOfZonesOfValue(subArgTree, null, this.adEnv.curInstruction());
        if (lz != null) {
            ZoneInfo zoneInfoOfSubArg;
            savedDescriptor.zoneInfo = zoneInfoOfSubArg = DataFlowAnalyzer.extendedDeclaredToZoneInfo(lz.head, this.adEnv.curSymbolTable(), null);
            restoredDescriptor.zoneInfo = zoneInfoOfSubArg;
        }
    }

    protected Tree differentiateProcedureHeader(Tree headerTree, Tree lhs, ActivityPattern calledActivity, SymbolTable diffSymbolTable, SymbolTable interfaceSymbolTable, int diffHeaderMode, TapList<TapPair<Tree, Tree>> toDuplicateVars) {
        int nbArgs;
        Tree[] args;
        Tree diffHeader;
        Unit sourceCalledUnit;
        if (calledActivity == null) {
            calledActivity = this.adEnv.curActivity();
        }
        if (this.adEnv.traceCurBlock != 0) {
            TapEnv.printlnOnTrace("          (Differentiate Header) :" + headerTree + " for activity:" + calledActivity);
        }
        if ((sourceCalledUnit = calledActivity.unit()) == null) {
            sourceCalledUnit = this.adEnv.curUnit();
        }
        FunctionTypeSpec functionTypeSpec = sourceCalledUnit.functionTypeSpec();
        WrapperTypeSpec[] argumentsTypes = functionTypeSpec.argumentsTypes;
        boolean isActive = calledActivity.isActive();
        boolean isMainProcedure = sourceCalledUnit == this.adEnv.srcCallGraph().getMainUnit();
        UnitDiffInfo calledDiffInfo = this.callGraphDifferentiator().getUnitDiffInfo(sourceCalledUnit);
        Unit diffCalledUnit = diffHeaderMode == 0 ? this.adEnv.getPrimalCopyOfOrigUnit(sourceCalledUnit) : this.adEnv.getDiffOfUnit(sourceCalledUnit, calledActivity, diffHeaderMode);
        SymbolTable symbolTable = this.adEnv.curUnit().publicSymbolTable();
        Tree explicitDiffReturnVar = null;
        boolean[] formalArgsActivity = null;
        if (isMainProcedure) {
            diffHeader = ILUtils.copy(headerTree);
            if (!sourceCalledUnit.isC()) {
                Tree unitName = this.varRefDifferentiator().diffSymbolTree(calledActivity, ILUtils.getCalledName(headerTree), diffSymbolTable, false, true, false, headerTree, false, diffHeaderMode, diffHeaderMode, 1, null);
                diffHeader.setChild(unitName, 1);
            }
        } else {
            String funName;
            VariableDecl funVar;
            String otherName;
            args = ILUtils.getArguments(headerTree).children();
            nbArgs = args.length;
            boolean[] diffArgsByValueNeedOverwrite = null;
            boolean[] diffArgsByValueNeedOnlyIncrement = null;
            if (diffHeaderMode != 1) {
                diffArgsByValueNeedOverwrite = calledDiffInfo.getUnitDiffArgsByValueNeedOverwriteInfoS(calledActivity);
                diffArgsByValueNeedOnlyIncrement = calledDiffInfo.getUnitDiffArgsByValueNeedOnlyIncrementInfoS(calledActivity);
            }
            if (calledDiffInfo != null) {
                formalArgsActivity = calledDiffInfo.getUnitFormalArgsActivityS(calledActivity);
            }
            if (formalArgsActivity == null) {
                formalArgsActivity = ADActivityAnalyzer.formalArgsActivity(calledActivity);
            }
            nbArgs = Math.min(nbArgs, formalArgsActivity.length - 1);
            boolean[] formalArgsPointerActivity = ReqExplicit.formalArgsPointerActivity(calledActivity, nbArgs);
            if (isActive && this.adEnv.traceCurBlock != 0) {
                boolean[] formalArgsInfo;
                if (diffHeaderMode == 3) {
                    TapEnv.printOnTrace("          formalArgsPointerActivity: [");
                    formalArgsInfo = formalArgsPointerActivity;
                } else {
                    TapEnv.printOnTrace("          formalArgsActivity: [");
                    formalArgsInfo = formalArgsActivity;
                }
                for (int j = 0; j < formalArgsInfo.length; ++j) {
                    TapEnv.printOnTrace("" + formalArgsInfo[j]);
                    if (j + 1 >= formalArgsInfo.length) continue;
                    TapEnv.printOnTrace(j + 1 == nbArgs ? "->" : ", ");
                }
                TapEnv.printlnOnTrace("]");
            }
            int firstOrderingProblem = ProcedureCallDifferentiator.findNameEqOrNone(headerTree);
            TapTriplet<Unit, BoolVector, BoolVector>[] varFunctionInfos = calledActivity.varFunctionADActivities();
            TapList<Tree> newArgs = null;
            if (isActive && this.multiDirMode()) {
                Tree newArg = this.varRefDifferentiator().buildDirNumberReference(diffSymbolTable);
                if (firstOrderingProblem > -1) {
                    Tree argName = this.varRefDifferentiator().buildDirNumberReference(diffSymbolTable);
                    newArg = ILUtils.build(132, argName, newArg);
                }
                newArgs = new TapList<Tree>(newArg, newArgs);
            }
            if (sourceCalledUnit.isAFunction() && !TapEnv.associationByAddress()) {
                Tree returnTree = lhs != null ? ILUtils.copy(lhs) : (sourceCalledUnit.otherReturnVar() != null ? ILUtils.build(94, sourceCalledUnit.otherReturnVar().symbol) : ILUtils.copy(ILUtils.getCalledName(headerTree)));
                if (formalArgsActivity[nbArgs] && (diffHeaderMode == 2 || diffHeaderMode == 4 || diffHeaderMode == 1 && !this.varRefDifferentiator().diffFunctionIsFunction(this.adEnv.curUnit())) || formalArgsPointerActivity[nbArgs] && diffHeaderMode == 3) {
                    NewSymbolHolder newSH;
                    Tree diffReturnTree = returnTree.opCode() == 94 ? this.varRefDifferentiator().diffSymbolTree(this.adEnv.curActivity(), returnTree, diffSymbolTable, true, false, false, headerTree, true, this.curDiffVarSort(), lhs != null ? 2 : diffHeaderMode, 0, null) : this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), returnTree, diffSymbolTable, false, returnTree, false, false, returnTree);
                    if (diffHeaderMode == 1) {
                        newSH = NewSymbolHolder.getNewSymbolHolder(diffReturnTree);
                        if (newSH != null && newSH.newVariableDecl() != null && sourceCalledUnit.otherReturnVar() != null && !sourceCalledUnit.isC()) {
                            newSH.setExtraInfo(SymbolDecl.addInfosInList(newSH.extraInfo(), new TapList<String>("out", null), null));
                            newSH.newVariableDecl().formalArgRank = 999;
                            newSH.newVariableDecl().addExtraInfo(newSH.extraInfo());
                            newSH.derivationFrom.addExtraInfo(new TapList<String>("out", null));
                        }
                    } else if (sourceCalledUnit.isFortran2003() && (newSH = NewSymbolHolder.getNewSymbolHolder(diffReturnTree)) != null && newSH.newVariableDecl() != null) {
                        newSH.setExtraInfo(SymbolDecl.addInfosInList(newSH.extraInfo(), new TapList<String>("value", null), null));
                        newSH.newVariableDecl().addExtraInfo(newSH.extraInfo());
                    }
                    if (this.curDiffUnit().isC()) {
                        if (lhs != null) {
                            if (TypeSpec.isA(this.adEnv.curSymbolTable().typeOf(lhs), 6)) {
                                diffReturnTree = ILUtils.build(3, diffReturnTree);
                            }
                        } else if (diffHeaderMode == 3 || this.adEnv.curUnitIsContext) {
                            NewSymbolHolder diffReturnSH = NewSymbolHolder.getNewSymbolHolder(diffReturnTree);
                            VariableDecl diffReturnVarDecl = diffReturnSH.newVariableDecl();
                            if (diffReturnVarDecl != null) {
                                diffReturnVarDecl.formalArgRank = 999;
                            }
                            if (diffReturnVarDecl != null) {
                                diffReturnVarDecl.setType(new WrapperTypeSpec(new PointerTypeSpec(diffReturnVarDecl.type(), null)));
                                diffReturnTree = ILUtils.build(150, diffReturnTree);
                            } else {
                                diffReturnTree = sourceCalledUnit.functionTypeSpec().returnType.wrappedType.buildConstantZero();
                            }
                        }
                    }
                    if (firstOrderingProblem > -1 && lhs != null) {
                        Tree diffResultArgName = this.getNewParamName(-1, sourceCalledUnit, true, diffHeaderMode, diffCalledUnit);
                        diffReturnTree = ILUtils.build(132, diffResultArgName, diffReturnTree);
                    }
                    newArgs = new TapList<Tree>(diffReturnTree, newArgs);
                    if (sourceCalledUnit.otherReturnVar() != null && this.adEnv.curUnit().isFortran() && this.varRefDifferentiator().diffFunctionIsFunction(this.adEnv.curUnit()) && diffHeaderMode == 3) {
                        explicitDiffReturnVar = ILUtils.copy(returnTree);
                    }
                }
                if (diffHeaderMode == 1 && !this.adEnv.curActivity().isContext()) {
                    String returnName = ILUtils.baseName(returnTree);
                    VariableDecl returnVarDecl = diffSymbolTable.getTopVariableDecl(returnName);
                    if (returnVarDecl == null) {
                        returnVarDecl = interfaceSymbolTable.getTopVariableDecl(returnName);
                    }
                    if (returnVarDecl != null) {
                        returnVarDecl.formalArgRank = 999;
                    }
                    if (this.curDiffUnit().isC()) {
                        if (returnVarDecl != null) {
                            returnVarDecl.setType(new WrapperTypeSpec(new PointerTypeSpec(returnVarDecl.type(), null)));
                        }
                        returnTree = ILUtils.build(150, returnTree);
                    }
                    if (firstOrderingProblem > -1 && lhs != null) {
                        Tree resultArgName = this.getNewParamName(-1, sourceCalledUnit, false, -1, null);
                        returnTree = ILUtils.build(132, resultArgName, returnTree);
                    }
                    newArgs = new TapList<Tree>(returnTree, newArgs);
                    if (sourceCalledUnit.otherReturnVar() != null && this.adEnv.curUnit().isFortran() && this.curDiffUnit().isAFunction() && this.varRefDifferentiator().diffFunctionIsFunction(this.adEnv.curUnit())) {
                        explicitDiffReturnVar = this.varRefDifferentiator().diffSymbolTree(this.adEnv.curActivity(), returnTree, diffSymbolTable, true, false, false, headerTree, true, this.curDiffVarSort(), diffHeaderMode, 0, null);
                    }
                }
            }
            this.varRefDifferentiator().pushDiffContext(2);
            for (int i = nbArgs - 1; i >= 0; --i) {
                Tree diffArg = null;
                if (symbolTable.identIsAFunction(args[i])) {
                    if (diffHeaderMode != 3 && (!TapEnv.doActivity() || varFunctionInfos != null && varFunctionInfos[i] != null)) {
                        int subDiffSort = diffHeaderMode == 4 ? 2 : diffHeaderMode;
                        TapList<ActivityPattern> functionActivities = ((FunctionDecl)symbolTable.getSymbolDecl((String)ILUtils.getIdentString((Tree)args[i]))).unit().specificInfoAD;
                        diffArg = this.varRefDifferentiator().diffSymbolTree(functionActivities != null ? (ActivityPattern)functionActivities.head : null, args[i], diffSymbolTable, false, true, false, null, false, this.curDiffUnitSort(), subDiffSort, 0, null);
                    }
                } else if (diffHeaderMode == 3 ? formalArgsPointerActivity[i] : formalArgsActivity[i]) {
                    if (!TapEnv.associationByAddress() && !ILUtils.isNullOrNone(args[i]) && diffArgsByValueNeedOverwrite != null && diffArgsByValueNeedOverwrite[i + 1] && sourceCalledUnit.passesByValue(i + 1, this.adEnv.curUnit().language())) {
                        if (diffArgsByValueNeedOnlyIncrement[i + 1] || this.adEnv.curUnitIsContext) {
                            diffArg = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), args[i], diffSymbolTable, false, args[i], false, true, args[i]);
                            if (this.adEnv.curUnit().isFortran2003()) {
                                this.cleanExtraInfoValue(diffArg);
                            }
                            if (this.adEnv.curUnitIsContext) {
                                diffArg = ILUtils.build(3, diffArg);
                            }
                        } else {
                            SymbolTable diffPrivateSymbolTable = this.curDiffUnit().privateSymbolTable();
                            Tree diffArgLocal = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), args[i], diffPrivateSymbolTable, false, args[i], false, true, args[i]);
                            Tree newDeclTree = ILUtils.baseTree(diffArgLocal);
                            Instruction instrDecl = new Instruction();
                            instrDecl.setPosition(this.adEnv.curInstruction());
                            WrapperTypeSpec typeSpec = diffPrivateSymbolTable.typeOf(newDeclTree);
                            Tree typeSpecTree = null;
                            if (typeSpec != null) {
                                typeSpecTree = typeSpec.wrappedType.generateTree(diffSymbolTable, null, null, true, null);
                            }
                            instrDecl.tree = ILUtils.build(194, ILUtils.build(128), typeSpecTree, ILUtils.build(53, ILUtils.copy(newDeclTree)));
                            if (diffSymbolTable == interfaceSymbolTable) {
                                NewSymbolHolder sHolder = NewSymbolHolder.getNewSymbolHolder(newDeclTree);
                                sHolder.setInstruction(instrDecl);
                                sHolder.setVarDeclTreeAlreadyPlacedFor(this.adEnv.curUnit().publicSymbolTable());
                            }
                            diffArgLocal = ILUtils.variableDeclaratorToVariableRef(diffArgLocal);
                            diffArgsByValueNeedOnlyIncrement[i + 1] = true;
                            this.adEnv.pushCurDiffSorts(-1, 3);
                            diffArg = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), args[i], diffSymbolTable, false, args[i], false, true, args[i]);
                            Tree diffArgForLastUpdate = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), args[i], diffPrivateSymbolTable, false, args[i], false, true, args[i]);
                            if (this.adEnv.curUnit().isFortran2003()) {
                                this.cleanExtraInfoValue(diffArgLocal);
                                this.cleanExtraInfoValue(diffArgForLastUpdate);
                            }
                            this.adEnv.popCurDiffSorts();
                            diffArgForLastUpdate = ILUtils.variableDeclaratorToVariableRef(diffArgForLastUpdate);
                            if (toDuplicateVars != null) {
                                toDuplicateVars.placdl(new TapPair<Tree, Tree>(diffArgForLastUpdate, diffArgLocal));
                            }
                            diffArgsByValueNeedOnlyIncrement[i + 1] = false;
                        }
                    } else if (ILUtils.isNullOrNone(args[i])) {
                        diffArg = ILUtils.build(136);
                    } else if (TapEnv.associationByAddress()) {
                        diffArg = ILUtils.copy(args[i]);
                    } else {
                        diffArg = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), args[i], diffSymbolTable, false, args[i], false, true, args[i]);
                        if (diffHeaderMode != 1 && this.adEnv.curUnit().isFortran2003() && sourceCalledUnit.passesByValue(i + 1, this.adEnv.curUnit().language())) {
                            this.cleanExtraInfoValue(diffArg);
                        }
                    }
                }
                if (!ILUtils.isNullOrNone(diffArg)) {
                    if (firstOrderingProblem != -1 && (i >= firstOrderingProblem || args[i].getAnnotation("sourcetree") != null)) {
                        Tree argName = this.getNewParamName(i, sourceCalledUnit, true, diffHeaderMode, diffCalledUnit);
                        diffArg = ILUtils.build(132, argName, diffArg);
                    }
                    newArgs = new TapList<Tree>(diffArg, newArgs);
                }
                if (diffHeaderMode != 3 && (TapEnv.associationByAddress() && formalArgsActivity[i] || (diffHeaderMode == 2 || diffHeaderMode == 4) && args[i].opCode() == 172)) continue;
                Tree copyArg = ILUtils.copy(args[i]);
                if (this.adEnv.curUnit().isC() && !ILUtils.isNullOrNone(copyArg) && diffArgsByValueNeedOverwrite != null && diffArgsByValueNeedOverwrite[i + 1] && TypeSpec.isA(argumentsTypes[i], 6)) {
                    copyArg = ILUtils.build(150, copyArg);
                }
                if (args[i].getAnnotation("sourcetree") != null) {
                    copyArg = ILUtils.copy((Tree)args[i].getAnnotation("sourcetree"));
                } else if (firstOrderingProblem != -1 && i >= firstOrderingProblem && args[i].opCode() != 136) {
                    Tree argName;
                    if (copyArg.opCode() == 132) {
                        argName = copyArg.cutChild(1);
                        copyArg = copyArg.cutChild(2);
                    } else {
                        argName = this.getNewParamName(i, sourceCalledUnit, false, -1, null);
                    }
                    copyArg = ILUtils.build(132, argName, copyArg);
                }
                newArgs = new TapList<Tree>(copyArg, newArgs);
            }
            this.varRefDifferentiator().popDiffContext();
            Tree unitName = this.varRefDifferentiator().diffSymbolTree(calledActivity, ILUtils.getCalledName(headerTree), diffSymbolTable, false, true, false, headerTree, false, diffHeaderMode, diffHeaderMode, 1, null);
            NewSymbolHolder newSH = NewSymbolHolder.getNewSymbolHolder(unitName);
            if (newSH != null) {
                if (diffCalledUnit != null) {
                    newSH.declarationLevelMustInclude(diffCalledUnit.publicSymbolTable());
                } else {
                    newSH.declarationLevelMustInclude(diffSymbolTable);
                }
            }
            if (explicitDiffReturnVar != null) {
                unitName.setAnnotation("explicitReturnVar", explicitDiffReturnVar);
            }
            if (sourceCalledUnit.isFortran2003() && sourceCalledUnit.modifiers != null && sourceCalledUnit.modifiers.opCode() == 1 && (otherName = sourceCalledUnit.getNameFromBindC()) != null && diffCalledUnit.modifiers.opCode() == 1 && diffCalledUnit.modifiers.down(2).length() == 2 && diffCalledUnit.modifiers.down(2).down(2).opCode() == 132) {
                diffCalledUnit.modifiers.down(2).removeChild(2);
            }
            if ((funVar = diffSymbolTable.getTopVariableDecl(funName = ILUtils.getCalledNameString(headerTree))) != null && funVar.formalArgRank == -1) {
                funVar.formalArgRank = 99;
            }
            this.updateFormalArgRankS(newArgs, this.curDiffUnit());
            diffHeader = ILUtils.buildCall(unitName, ILUtils.build(70, newArgs));
        }
        if (TapEnv.associationByAddress()) {
            args = ILUtils.getArguments(headerTree).children();
            nbArgs = args.length;
            for (int i = 0; i < nbArgs; ++i) {
                String diffArgName;
                Tree diffArgTree = diffHeader.down(3).down(i + 1);
                if (diffArgTree == null || ILUtils.isNullOrNoneOrStar(args[i]) || (diffArgName = ILUtils.baseName(diffArgTree)) == null) continue;
                SymbolDecl diffSymbolDecl = diffSymbolTable.getSymbolDecl(diffArgName);
                if (diffSymbolDecl instanceof VariableDecl) {
                    VariableDecl diffVarDecl = (VariableDecl)diffSymbolDecl;
                    VariableDecl srcVarDecl = null;
                    WrapperTypeSpec diffTypeSpec = null;
                    if (formalArgsActivity != null && formalArgsActivity[i]) {
                        srcVarDecl = (VariableDecl)interfaceSymbolTable.getSymbolDecl(diffArgName);
                        diffTypeSpec = srcVarDecl.type().checkDiffTypeSpec(diffSymbolTable, interfaceSymbolTable, this.curDiffUnitSort(), this.adEnv.suffixes[1][3], false, this.multiDirMode(), this.varRefDifferentiator().getMultiDirDimensionMax(), null, this.adEnv.curUnit().name + "'s arg" + (i + 1), this.adEnv.curUnit().name + "_arg" + (i + 1), null, null);
                        if (diffTypeSpec == null) continue;
                        diffVarDecl.setType(diffTypeSpec);
                        continue;
                    }
                    diffVarDecl.setType(diffCalledUnit.functionTypeSpec().argumentsTypes[i]);
                    continue;
                }
                if (!(diffSymbolDecl instanceof FunctionDecl)) continue;
                FunctionDecl functionDecl = (FunctionDecl)diffSymbolDecl;
            }
        }
        if (this.adEnv.traceCurBlock != 0) {
            TapEnv.printlnOnTrace("          -> (Differentiated Header) :" + diffHeader);
        }
        return diffHeader;
    }

    private Tree getNewParamName(int i, Unit calledUnit, boolean diff, int diffSort, Unit diffCalledUnit) {
        Tree diffHeadTree;
        Tree headTree;
        String paramName = "UndefinedArgumentName";
        Tree tree = headTree = calledUnit.entryBlock() == null ? null : calledUnit.entryBlock().headTree();
        if (i == -1) {
            if (!diff || this.curDiffUnitSort() == 1 && !this.multiDirMode()) {
                paramName = calledUnit.otherReturnVar() != null ? calledUnit.otherReturnVar().symbol : (headTree != null ? ILUtils.getCalledNameString(headTree) : calledUnit.name);
            } else if (this.curDiffUnitSort() == 2 || this.multiDirMode()) {
                if (diffCalledUnit == null) {
                    paramName = "UndefinedArgumentName";
                } else if (diffCalledUnit.entryBlock() != null) {
                    diffHeadTree = diffCalledUnit.entryBlock().headTree();
                    int rank = ILUtils.getArguments(diffHeadTree).length();
                    if (this.multiDirMode()) {
                        --rank;
                    }
                    paramName = ILUtils.getIdentString(ILUtils.getArguments(diffHeadTree).down(rank));
                } else {
                    paramName = diffCalledUnit.name;
                }
            }
        } else {
            paramName = headTree != null ? ILUtils.getIdentString(ILUtils.getArguments(headTree).down(i + 1)) : "UndefinedArgumentName";
        }
        Tree nameTree = ILUtils.build(94, paramName);
        if (diff && diffCalledUnit != null && i != -1) {
            if (diffCalledUnit.entryBlock() != null) {
                diffHeadTree = diffCalledUnit.entryBlock().headTree();
                VariableDecl paramDecl = diffCalledUnit.publicSymbolTable().getTopVariableDecl(paramName);
                if (paramDecl.hasDiffSymbolHolders()) {
                    if (!TapEnv.associationByAddress()) {
                        boolean found = false;
                        int rank = 1;
                        while (!found && rank <= ILUtils.getArguments(diffHeadTree).length()) {
                            found = paramName.equals(ILUtils.getArguments(diffHeadTree).down(rank).stringValue());
                            if (found) continue;
                            ++rank;
                        }
                        if (found) {
                            nameTree = ILUtils.getArguments(diffHeadTree).down(rank + 1);
                        }
                    } else {
                        NewSymbolHolder nSH = paramDecl.getDiffSymbolHolder(diffSort, null);
                        if (nSH != null && nSH.newVariableDecl() != null) {
                            nameTree = ILUtils.build(94, nSH.newVariableDecl().symbol);
                        }
                    }
                }
            } else {
                nameTree = this.varRefDifferentiator().diffSymbolTree(this.adEnv.curActivity(), nameTree, diffCalledUnit.publicSymbolTable(), true, false, false, null, false, diffSort, this.curDiffUnitSort(), 0, null);
            }
            if (ILUtils.isNullOrNone(nameTree)) {
                nameTree = ILUtils.build(94, "UndefinedArgumentName");
            }
        }
        if (nameTree.parent() != null) {
            nameTree = ILUtils.copy(nameTree);
        }
        return nameTree;
    }

    private TapList<ZoneInfo> collectZonesFormalActiveAndActualPassive(TapList argZonesTree, TapIntList tmpZones, TapList formalArgActivityTree, BoolVector actualActivity, Unit calledUnit, TapList<ZoneInfo> zonesToReinit) {
        while (argZonesTree != null && formalArgActivityTree != null) {
            if (formalArgActivityTree.head instanceof TapList) {
                if (argZonesTree.head instanceof TapList) {
                    zonesToReinit = this.collectZonesFormalActiveAndActualPassive((TapList)argZonesTree.head, tmpZones, (TapList)formalArgActivityTree.head, actualActivity, calledUnit, zonesToReinit);
                } else {
                    boolean formalActive = TapList.oneTrueInHead(formalArgActivityTree);
                    if (formalActive) {
                        zonesToReinit = this.collectPassiveZones((TapIntList)argZonesTree.head, zonesToReinit, tmpZones, actualActivity, calledUnit);
                    }
                }
            } else if (formalArgActivityTree.head != null) {
                TapIntList zones = argZonesTree.head instanceof TapList ? ZoneInfo.listAllZones((TapList)argZonesTree.head, true) : (TapIntList)argZonesTree.head;
                boolean formalActive = (Boolean)formalArgActivityTree.head;
                if (formalActive) {
                    zonesToReinit = this.collectPassiveZones(zones, zonesToReinit, tmpZones, actualActivity, calledUnit);
                }
            }
            argZonesTree = argZonesTree.tail;
            formalArgActivityTree = formalArgActivityTree.tail;
        }
        return zonesToReinit;
    }

    private TapList<ZoneInfo> collectPassiveZones(TapIntList zones, TapList<ZoneInfo> zonesToReinit, TapIntList tmpZones, BoolVector actualActivity, Unit calledUnit) {
        while (zones != null) {
            ZoneInfo zoneInfo;
            int zone = zones.head;
            if (!(TapIntList.contains(tmpZones, zone) || (zoneInfo = DataFlowAnalyzer.extendedDeclaredToZoneInfo(zone, this.adEnv.curSymbolTable(), null)) == null || TapList.contains(zonesToReinit, zoneInfo) || (zone = DataFlowAnalyzer.zoneInfoToVectorIndex(zoneInfo, DataFlowAnalyzer.extendedDeclaredToClass(zone, this.adEnv.curSymbolTable()), this.adEnv.diffKind, this.curDiffVectorMap(), calledUnit)) < 0 || actualActivity.get(zone))) {
                zonesToReinit = new TapList<ZoneInfo>(zoneInfo, zonesToReinit);
            }
            zones = zones.tail;
        }
        return zonesToReinit;
    }

    private TapList<Tree> collectTreesToDiffInitAfterDiffCall(Tree argTree, boolean argThroughPointer, WrapperTypeSpec argType, WrapperTypeSpec formalType, TapList argZonesTree, TapList active1, TapList active2, TapList modified, TapList actualArgAfterActiv, Unit calledUnit, TapList<Tree> treesToReinit, TapList<TypeSpec> dejaVu, String message) {
        TypeSpec actualTypeSpec;
        if (argType != null && TypeSpec.isA(formalType, 2) && argTree.opCode() == 8 && !TypeSpec.isA(argType, 2)) {
            message = "(AD17) Type mismatch in argument " + argTree.rankInParent() + " of procedure " + calledUnit.name + ", was " + formalType.showType() + ", is here " + argType.showType() + ", please check initialization after diff call";
        }
        TypeSpec typeSpec = actualTypeSpec = argType == null ? null : argType.wrappedType;
        if (actualTypeSpec == null || TapList.contains(dejaVu, actualTypeSpec)) {
            return treesToReinit;
        }
        switch (actualTypeSpec.kind()) {
            case 2: {
                WrapperTypeSpec elementType = actualTypeSpec.elementType();
                return this.collectTreesToDiffInitAfterDiffCall(argTree, argThroughPointer, elementType, null, argZonesTree, active1, active2, modified, actualArgAfterActiv, calledUnit, treesToReinit, new TapList<TypeSpec>(actualTypeSpec, dejaVu), message);
            }
            case 5: {
                WrapperTypeSpec elementType = actualTypeSpec.elementType();
                return this.collectTreesToDiffInitAfterDiffCall(argTree, argThroughPointer, elementType, null, argZonesTree, active1, active2, modified, actualArgAfterActiv, calledUnit, treesToReinit, new TapList<TypeSpec>(actualTypeSpec, dejaVu), message);
            }
            case 21: {
                CompositeTypeSpec compositeTypeSpec = (CompositeTypeSpec)actualTypeSpec;
                FieldDecl[] fieldDecls = compositeTypeSpec.fields;
                for (int i = 0; i < fieldDecls.length - 1; ++i) {
                    Tree fieldTree = ILUtils.build(73, ILUtils.copy(argTree), ILUtils.build(94, fieldDecls[i].symbol));
                    ILUtils.setFieldRank(fieldTree.down(2), i);
                    TapList fieldActive1 = active1;
                    if (active1 != null && active1.head instanceof TapList) {
                        fieldActive1 = (TapList)active1.head;
                        active1 = active1.tail;
                    }
                    TapList fieldActive2 = active2;
                    if (active2 != null && active2.head instanceof TapList) {
                        fieldActive2 = (TapList)active2.head;
                        active2 = active2.tail;
                    }
                    TapList fieldModified = modified;
                    if (modified != null && modified.head instanceof TapList) {
                        fieldModified = (TapList)modified.head;
                        modified = modified.tail;
                    }
                    TapList fieldAfterActiv = actualArgAfterActiv;
                    if (actualArgAfterActiv != null && actualArgAfterActiv.head instanceof TapList) {
                        fieldAfterActiv = (TapList)actualArgAfterActiv.head;
                        actualArgAfterActiv = actualArgAfterActiv.tail;
                    }
                    TapList fieldZonesTree = argZonesTree;
                    if (argZonesTree != null && argZonesTree.head instanceof TapList) {
                        fieldZonesTree = (TapList)argZonesTree.head;
                        argZonesTree = argZonesTree.tail;
                    }
                    treesToReinit = this.collectTreesToDiffInitAfterDiffCall(fieldTree, argThroughPointer, fieldDecls[i].type(), null, fieldZonesTree, fieldActive1, fieldActive2, fieldModified, fieldAfterActiv, calledUnit, treesToReinit, new TapList<TypeSpec>(actualTypeSpec, dejaVu), message);
                }
                return treesToReinit;
            }
            case 6: {
                PointerTypeSpec pointerTypeSpec = (PointerTypeSpec)actualTypeSpec;
                Tree pointedTree = ILUtils.build(148, ILUtils.copy(argTree), ILUtils.build(136));
                TapList destActive1 = active1 == null ? null : active1.tail;
                TapList destActive2 = active2 == null ? null : active2.tail;
                TapList destModified = modified == null ? null : modified.tail;
                TapList destAfterActiv = actualArgAfterActiv == null ? null : actualArgAfterActiv.tail;
                TapList destZonesTree = argZonesTree == null ? null : argZonesTree.tail;
                treesToReinit = this.collectTreesToDiffInitAfterDiffCall(pointedTree, false, pointerTypeSpec.destinationType, null, destZonesTree, destActive1, destActive2, destModified, destAfterActiv, calledUnit, treesToReinit, new TapList<TypeSpec>(actualTypeSpec, dejaVu), message);
                return treesToReinit;
            }
            case 7: {
                if (TapList.oneTrueInHead(active1) && !TapList.oneTrueInHead(active2) && TapList.oneTrueInHead(modified) && (argThroughPointer || TapList.oneTrueInHead(actualArgAfterActiv))) {
                    if (message != null) {
                        TapEnv.fileWarning(15, argTree, message);
                    }
                    treesToReinit = new TapList<Tree>(argTree, treesToReinit);
                }
                return treesToReinit;
            }
        }
        return treesToReinit;
    }

    private static int findNameEqOrNone(Tree callTree) {
        Tree[] sons = ILUtils.getArguments(callTree).children();
        Tree[] sourceSons = new Tree[]{};
        Tree sourceTree = (Tree)callTree.getAnnotation("sourcetree");
        if (sourceTree != null && sourceTree.opCode() == 30) {
            sourceSons = ILUtils.getArguments(sourceTree).children();
        }
        int found = -1;
        for (int i = 0; found == -1 && i < sons.length; ++i) {
            if (sons[i].opCode() != 136 && (i >= sourceSons.length || sourceSons[i].opCode() != 132)) continue;
            found = i;
        }
        return found;
    }

    private void updateFormalArgRankS(TapList<Tree> args, Unit unit) {
        int rank = 1;
        while (args != null) {
            String name;
            Tree arg = (Tree)args.head;
            if (arg.opCode() != 172 && (name = ILUtils.baseName(arg)) != null) {
                NewSymbolHolder sHolder;
                VariableDecl varDecl = unit.publicSymbolTable().getVariableDecl(name);
                FunctionDecl funcDecl = null;
                TapList<FunctionDecl> funcDecls = null;
                if (varDecl == null) {
                    funcDecls = unit.publicSymbolTable().getFunctionDecl(name, null, null, false);
                    FunctionDecl functionDecl = funcDecl = funcDecls == null ? null : (FunctionDecl)funcDecls.head;
                }
                if (varDecl == null && funcDecl == null && (sHolder = NewSymbolHolder.getNewSymbolHolder(arg)) != null && (varDecl = sHolder.newVariableDecl()) == null) {
                    funcDecl = sHolder.newFunctionDecl();
                }
                if (varDecl != null) {
                    if (varDecl.formalArgRank != 999) {
                        if (varDecl.formalArgRankInOrigUnit == -9) {
                            varDecl.formalArgRankInOrigUnit = varDecl.formalArgRank;
                        }
                        varDecl.formalArgRank = rank;
                    }
                } else if (funcDecl != null) {
                    funcDecl.formalArgRank = rank;
                }
            }
            args = args.tail;
            ++rank;
        }
    }

    private void cleanExtraInfoValue(Tree diffArg) {
        NewSymbolHolder sHolder = NewSymbolHolder.getNewSymbolHolder(diffArg);
        if (sHolder != null) {
            TapList<String> modifiers = sHolder.extraInfo();
            modifiers = TapList.cleanExtraInfoValue(modifiers, "value");
            sHolder.setExtraInfo(modifiers);
            VariableDecl varDecl = sHolder.newVariableDecl;
            modifiers = varDecl.extraInfo();
            modifiers = TapList.cleanExtraInfoValue(modifiers, "value");
            varDecl.setExtraInfo(modifiers);
        }
    }

    private Tree makeDiffInitializationOfCallArgument(Tree exprToInitialize, Tree hintRootTree, SymbolTable usageSymbolTable, WrapperTypeSpec actualArgType, WrapperTypeSpec formalArgType, ZoneInfo fromZoneInfo, boolean protectAccesses, TapList ignoreStructure, boolean ignorePointed) {
        exprToInitialize = ILUtils.copy(exprToInitialize);
        exprToInitialize = BlockDifferentiator.replaceAllocateInExprToInitialize(exprToInitialize);
        String baseVarName = ILUtils.baseName(exprToInitialize);
        Tree baseVarTree = ILUtils.baseTree(exprToInitialize);
        if (baseVarName == null || baseVarTree == null) {
            TapEnv.toolWarning(-1, "(Build diff initialization) Unexpected expression: " + exprToInitialize);
            return null;
        }
        boolean isCurUnitName = baseVarName.equals(this.adEnv.curUnit().name);
        Tree diffBaseVar = this.varRefDifferentiator().diffSymbolTree(this.adEnv.curActivity(), baseVarTree, usageSymbolTable, true, this.curDiffUnitSort() == 1 && !this.multiDirMode() && isCurUnitName, false, null, false, this.curDiffVarSort(), this.curDiffUnitSort(), 0, hintRootTree);
        if (TapEnv.associationByAddress()) {
            diffBaseVar = ILUtils.build(73, ILUtils.copy(diffBaseVar), ILUtils.build(94, "d"));
        }
        return RefDescriptor.makeInitialize(this.curDiffUnit(), exprToInitialize, actualArgType, formalArgType, hintRootTree, this.adEnv.curSymbolTable(), usageSymbolTable, null, diffBaseVar, true, this.multiDirMode() ? this.varRefDifferentiator().multiDirMaxIterDescriptor : null, fromZoneInfo, protectAccesses, ignoreStructure, ignorePointed);
    }

    private Tree makeDiffTagInitialization(Tree exprToInitialize, SymbolTable usageSymbolTable) {
        exprToInitialize = ILUtils.copy(exprToInitialize);
        exprToInitialize = BlockDifferentiator.replaceAllocateInExprToInitialize(exprToInitialize);
        String baseVarName = ILUtils.baseName(exprToInitialize);
        Tree baseVarTree = ILUtils.baseTree(exprToInitialize);
        if (baseVarName == null || baseVarTree == null) {
            TapEnv.toolWarning(-1, "(Build diff initialization) Unexpected expression: " + exprToInitialize);
            return null;
        }
        boolean isCurUnitName = baseVarName.equals(this.adEnv.curUnit().name);
        Tree diffBaseVar = this.varRefDifferentiator().diffSymbolTree(this.adEnv.curActivity(), baseVarTree, usageSymbolTable, true, this.curDiffUnitSort() == 1 && !this.multiDirMode() && isCurUnitName, false, null, false, this.curDiffVarSort(), this.curDiffUnitSort(), 0, null);
        NewSymbolHolder tagMessagePassingSymbolHolder = this.curDiffUnit().tagMessagePassingSymbolHolder;
        if (tagMessagePassingSymbolHolder == null) {
            tagMessagePassingSymbolHolder = new NewSymbolHolder("UNDEFINED_TAG");
            tagMessagePassingSymbolHolder.setAsConstantVariable(this.adEnv.integerTypeSpec, null, ILUtils.build(101, 1000));
            tagMessagePassingSymbolHolder.declarationLevelMustInclude(usageSymbolTable);
            this.curDiffUnit().tagMessagePassingSymbolHolder = tagMessagePassingSymbolHolder;
        }
        Tree undefTagTree = tagMessagePassingSymbolHolder.makeNewRef(usageSymbolTable);
        return ILUtils.build(13, diffBaseVar, ILUtils.build(2, ILUtils.copy(exprToInitialize), undefTagTree));
    }

    private boolean zonesOverlapCall(Tree resultTree, Tree callTree) {
        TapIntList resultZones = this.adEnv.curSymbolTable().listOfZonesOfValue(resultTree, null, this.adEnv.curInstruction());
        Unit calledUnit = DataFlowAnalyzer.getCalledUnit(callTree, this.adEnv.curSymbolTable());
        CallArrow callArrow = CallGraph.getCallArrow(this.adEnv.curUnit(), calledUnit);
        BoolVector unitRW = calledUnit.unitInOutPossiblyRorW();
        BoolVector privateRW = new BoolVector(DataFlowAnalyzer.mapSize(this.curVectorMap()));
        DataFlowAnalyzer.propagateDataToCaller(unitRW, null, ILUtils.getArguments(callTree).children(), ILUtils.getArguments(callTree).length(), privateRW, this.curVectorMap(), null, this.adEnv.curInstruction(), callArrow, true, true, 0);
        return DataFlowAnalyzer.intersectsExtendedDeclared(privateRW, this.curVectorMap(), 0, resultZones, null, this.adEnv.curSymbolTable(), calledUnit);
    }

    private boolean zonesOverlapArg(Tree resultTree, Tree argTree) {
        TapIntList resultZones = this.adEnv.curSymbolTable().listOfZonesOfValue(resultTree, null, this.adEnv.curInstruction());
        TapIntList argZones = this.adEnv.curSymbolTable().listOfZonesOfValue(argTree, null, this.adEnv.curInstruction());
        return TapIntList.intersects(resultZones, argZones);
    }

    private static boolean isAccessedThroughPointerOrIndex(Tree expr, SymbolTable symbolTable, int language, Unit calledUnit, int rank) {
        switch (expr.opCode()) {
            case 73: {
                return ProcedureCallDifferentiator.isAccessedThroughPointerOrIndex(expr.down(1), symbolTable, language, calledUnit, rank);
            }
            case 8: {
                return ProcedureCallDifferentiator.isAccessedThroughPointerOrIndex(expr.down(1), symbolTable, language, calledUnit, rank) || !ProcedureCallDifferentiator.fullArray(expr, symbolTable);
            }
            case 148: {
                return true;
            }
        }
        if (calledUnit.isFortran2003()) {
            return calledUnit.passesByValue(rank, language);
        }
        return false;
    }

    private static boolean fullArray(Tree arrayAccess, SymbolTable symbolTable) {
        Tree[] sons;
        ArrayDim[] dims;
        boolean isFull = false;
        WrapperTypeSpec typeSpec = symbolTable.typeOf(arrayAccess.down(1));
        if (TypeSpec.isA(typeSpec, 2) && (dims = ((ArrayTypeSpec)typeSpec.wrappedType).dimensions()).length == (sons = arrayAccess.down(2).children()).length) {
            isFull = true;
            for (int i = sons.length - 1; isFull && i >= 0; --i) {
                isFull = dims[i].fullArrayTriplet(sons[i]);
            }
        }
        return isFull;
    }

    private boolean usesTheStack(TapList<TapPair<RefDescriptor, RefDescriptor>> refsToPop) {
        boolean reallyUsesTheStack = false;
        while (refsToPop != null) {
            RefDescriptor refDescriptor = (RefDescriptor)((TapPair)refsToPop.head).first;
            RefDescriptor refDescriptorDiff = (RefDescriptor)((TapPair)refsToPop.head).second;
            if (refDescriptorDiff != null && !refDescriptorDiff.usesStaticSave()) {
                reallyUsesTheStack = true;
            }
            if (refDescriptor != null && !refDescriptor.usesStaticSave()) {
                reallyUsesTheStack = true;
            }
            refsToPop = refsToPop.tail;
        }
        return reallyUsesTheStack;
    }
}

