/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.differentiation;

import fr.inria.tapenade.analysis.DataFlowAnalyzer;
import fr.inria.tapenade.differentiation.BlockDifferentiator;
import fr.inria.tapenade.differentiation.DifferentiationEnv;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.Tree;

public final class SplitForSave {
    private final DifferentiationEnv adEnv;
    protected Tree tree;
    private boolean wasImplicitArray;
    private final SymbolTable origSymbolTable;
    private final TapIntList toNextIndexRank;
    private final TapList<TapPair<Tree, NewSymbolHolder>> toSpecialSubExpressions;
    private final TapList<NewSymbolHolder> toIndexSymbolHolders;
    private final BoolVector zonesWrittenByThisCall;
    private final int[] writtenZonesMap;
    private TapList<TapPair<Tree, NewSymbolHolder>> indexesForTree;
    private TapList<Tree> toTreesToRestore;
    private TapList<Tree> toTreesToSplitValue;

    protected SplitForSave(SymbolTable origSymbolTable, TapIntList toNextIndexRank, TapList<TapPair<Tree, NewSymbolHolder>> toSpecialSubExpressions, TapList<NewSymbolHolder> toIndexSymbolHolders, BoolVector zonesWrittenByThisCall, int[] writtenZonesMap, BlockDifferentiator blockDifferentiator) {
        this.origSymbolTable = origSymbolTable;
        this.toNextIndexRank = toNextIndexRank;
        this.toSpecialSubExpressions = toSpecialSubExpressions;
        this.toIndexSymbolHolders = toIndexSymbolHolders;
        this.zonesWrittenByThisCall = zonesWrittenByThisCall;
        this.writtenZonesMap = writtenZonesMap;
        this.adEnv = blockDifferentiator.adEnv;
    }

    protected void initIndexes(Tree tree, boolean wasImplicitArray, DifferentiationEnv adEnv) {
        this.tree = tree;
        this.wasImplicitArray = wasImplicitArray;
        if (tree != null) {
            this.toTreesToRestore = new TapList<Object>(null, null);
            this.toTreesToSplitValue = new TapList<Object>(null, null);
            this.analyzePushPopOfExpression(tree, true, true, true);
            this.toTreesToRestore = this.toTreesToRestore.tail;
            while (this.toTreesToRestore != null) {
                Tree treeToRestore = (Tree)this.toTreesToRestore.head;
                this.addToBeRestored(treeToRestore);
                this.toTreesToRestore = this.toTreesToRestore.tail;
            }
            this.toTreesToSplitValue = this.toTreesToSplitValue.tail;
            while (this.toTreesToSplitValue != null) {
                Tree treeToSplitValue = (Tree)this.toTreesToSplitValue.head;
                NewSymbolHolder indexSymbolHolder = this.allocateAnIndexVarForSubTree(treeToSplitValue, adEnv);
                this.indexesForTree = new TapList<TapPair<Tree, NewSymbolHolder>>(new TapPair<Tree, NewSymbolHolder>(treeToSplitValue, indexSymbolHolder), this.indexesForTree);
                this.toTreesToSplitValue = this.toTreesToSplitValue.tail;
            }
        }
    }

    private void addToBeRestored(Tree treeToRestore) {
        TapList<TapPair<Tree, NewSymbolHolder>> inSpecialSubExpressions = this.toSpecialSubExpressions;
        while (inSpecialSubExpressions.tail != null && !((Tree)((TapPair)inSpecialSubExpressions.tail.head).first).equalsTree(treeToRestore)) {
            inSpecialSubExpressions = inSpecialSubExpressions.tail;
        }
        if (inSpecialSubExpressions.tail == null) {
            inSpecialSubExpressions.tail = new TapList<TapPair<Tree, Object>>(new TapPair<Tree, Object>(treeToRestore, null), null);
        }
    }

    private NewSymbolHolder allocateAnIndexVarForSubTree(Tree treeToSplitValue, DifferentiationEnv adEnv) {
        NewSymbolHolder indexSymbolHolder;
        TapList<TapPair<Tree, NewSymbolHolder>> inSpecialSubExpressions = this.toSpecialSubExpressions;
        while (inSpecialSubExpressions.tail != null && !((Tree)((TapPair)inSpecialSubExpressions.tail.head).first).equalsTree(treeToSplitValue)) {
            inSpecialSubExpressions = inSpecialSubExpressions.tail;
        }
        if (inSpecialSubExpressions.tail != null) {
            indexSymbolHolder = (NewSymbolHolder)((TapPair)inSpecialSubExpressions.tail.head).second;
        } else {
            ++this.toNextIndexRank.head;
            TapList<NewSymbolHolder> inIndexSymbolHolders = this.toIndexSymbolHolders;
            for (int times = this.toNextIndexRank.head - 1; inIndexSymbolHolders.tail != null && times > 0; --times) {
                inIndexSymbolHolders = inIndexSymbolHolders.tail;
            }
            if (inIndexSymbolHolders.tail == null) {
                indexSymbolHolder = new NewSymbolHolder("index" + this.toNextIndexRank.head);
                indexSymbolHolder.setAsVariable(adEnv.integerTypeSpec, null);
                indexSymbolHolder.zone = adEnv.allocateTmpZone();
                inIndexSymbolHolders.placdl(indexSymbolHolder);
            } else {
                indexSymbolHolder = (NewSymbolHolder)inIndexSymbolHolders.tail.head;
            }
            inSpecialSubExpressions.tail = new TapList<TapPair<Tree, NewSymbolHolder>>(new TapPair<Tree, NewSymbolHolder>(treeToSplitValue, indexSymbolHolder), null);
        }
        return indexSymbolHolder;
    }

    private int analyzePushPopOfExpression(Tree tree, boolean usedAsRef, boolean allUsed, boolean rootArg) {
        int cost;
        TapList<Tree> needRestoreBefore = this.toTreesToRestore.tail;
        TapList<Tree> saveValueBefore = this.toTreesToSplitValue.tail;
        if (tree == null) {
            tree = ILUtils.build(136);
        }
        switch (tree.opCode()) {
            case 8: {
                cost = this.analyzePushPopOfExpression(tree.down(1), usedAsRef, false, false);
                Tree[] indexes = tree.down(2).children();
                for (int i = indexes.length - 1; i >= 0; --i) {
                    int cost2 = this.analyzePushPopOfExpression(indexes[i], false, true, false);
                    cost = cost + cost2 + 1;
                }
                if (!allUsed || rootArg || !this.possiblyChangedByThisCall(tree)) break;
                this.addTreeUnique(tree, this.toTreesToRestore);
                break;
            }
            case 73: {
                cost = this.analyzePushPopOfExpression(tree.down(1), usedAsRef, false, false);
                if (allUsed && !rootArg && this.possiblyChangedByThisCall(tree)) {
                    this.addTreeUnique(tree, this.toTreesToRestore);
                }
                ++cost;
                break;
            }
            case 94: {
                if (allUsed && !rootArg && this.possiblyChangedByThisCall(tree)) {
                    this.addTreeUnique(tree, this.toTreesToRestore);
                }
                cost = 1;
                break;
            }
            case 11: {
                cost = this.analyzePushPopOfExpression(tree.down(1), false, true, false);
                int cost2 = this.analyzePushPopOfExpression(tree.down(2), false, true, false);
                int cost3 = this.analyzePushPopOfExpression(tree.down(3), false, true, false);
                cost = cost + cost2 + cost3 + 3;
                break;
            }
            case 2: 
            case 61: 
            case 131: 
            case 152: 
            case 177: {
                cost = this.analyzePushPopOfExpression(tree.down(1), false, true, false);
                int cost2 = this.analyzePushPopOfExpression(tree.down(2), false, true, false);
                cost = cost + cost2 + 1;
                break;
            }
            case 122: {
                cost = this.analyzePushPopOfExpression(tree.down(1), false, true, false);
                break;
            }
            default: {
                cost = 0;
            }
        }
        WrapperTypeSpec treeType = this.origSymbolTable.typeOf(tree);
        if (!rootArg && !usedAsRef && treeType != null && treeType.getAllDimensions() == null && cost + 3 * this.additionalElems(this.toTreesToRestore.tail, needRestoreBefore) + 5 * this.additionalElems(this.toTreesToSplitValue.tail, saveValueBefore) > 15) {
            this.toTreesToSplitValue.tail = new TapList<Tree>(tree, saveValueBefore);
            this.toTreesToRestore.tail = needRestoreBefore;
            cost = 1;
        }
        return cost;
    }

    private boolean possiblyChangedByThisCall(Tree tree) {
        TapIntList valueZonesList = ZoneInfo.listAllZones(this.origSymbolTable.treeOfZonesOfValue(tree, null, this.adEnv.curInstruction(), null), true);
        return DataFlowAnalyzer.intersectsExtendedDeclared(this.zonesWrittenByThisCall, this.writtenZonesMap, 0, valueZonesList, null, this.origSymbolTable, null);
    }

    private void addTreeUnique(Tree newTree, TapList<Tree> trees) {
        if (!TapList.containsTreeEquals(trees.tail, newTree)) {
            trees.tail = new TapList<Tree>(newTree, trees.tail);
        }
    }

    private int additionalElems(TapList<Tree> list, TapList<Tree> refList) {
        int result = 0;
        while (list != null && list != refList) {
            ++result;
            list = list.tail;
        }
        return result;
    }

    protected Tree newSplitNoColonCopy(SymbolTable usageSymbolTable) {
        Tree copyTree = this.newSplitCopy(usageSymbolTable);
        if (this.wasImplicitArray && copyTree.opCode() == 8) {
            int rankOfArrayTriplet = 1;
            while (copyTree.down((int)2).down((int)rankOfArrayTriplet).operator().code != 11) {
                ++rankOfArrayTriplet;
            }
            copyTree.down(2).setChild(copyTree.down(2).down(rankOfArrayTriplet).cutChild(1), rankOfArrayTriplet);
        }
        return copyTree;
    }

    protected Tree newSplitCopy(SymbolTable usageSymbolTable) {
        TapList<Object> hdCopied;
        TapList<Object> inCopied = hdCopied = new TapList<Object>(null, null);
        TapList<TapPair<Tree, NewSymbolHolder>> inReplacedSubTrees = this.indexesForTree;
        while (inReplacedSubTrees != null) {
            TapPair origPair = (TapPair)inReplacedSubTrees.head;
            NewSymbolHolder symbolHolder = (NewSymbolHolder)origPair.second;
            if (symbolHolder != null) {
                Tree splitIndexTree = symbolHolder.makeNewRef(usageSymbolTable);
                symbolHolder.declarationLevelMustInclude(usageSymbolTable);
                TapPair copiedPair = new TapPair(origPair.first, splitIndexTree);
                inCopied = inCopied.placdl(copiedPair);
            }
            inReplacedSubTrees = inReplacedSubTrees.tail;
        }
        Tree copyTree = ILUtils.copyWatchingEqualsSubtrees(this.tree, hdCopied.tail);
        NewSymbolHolder.copySymbolHolderAnnotation(this.tree, copyTree, usageSymbolTable);
        return copyTree;
    }
}

