/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.differentiation;

import fr.inria.tapenade.analysis.ActivityPattern;
import fr.inria.tapenade.differentiation.DifferentiationEnv;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.TapPair;

public final class UnitDiffInfo {
    private final DifferentiationEnv adEnv;
    private final Unit unit;
    private Unit diffUnit;
    private final TapList<TapPair<ActivityPattern, Unit>> adjointUnits;
    private final TapList<TapPair<ActivityPattern, Unit>> bwdUnits;
    private final TapList<TapPair<ActivityPattern, Unit>> fwdUnits;
    private final TapList<TapPair<ActivityPattern, Unit>> tangentUnits;
    private final TapList<TapPair<ActivityPattern, boolean[]>> unitFormalArgsActivityS;
    private final TapList<TapPair<ActivityPattern, boolean[]>> unitDiffArgsByValueNeedOverwriteInfoS;
    private final TapList<TapPair<ActivityPattern, boolean[]>> unitDiffArgsByValueNeedOnlyIncrementInfoS;

    protected UnitDiffInfo(Unit unit, DifferentiationEnv adEnv) {
        this.unit = unit;
        this.adEnv = adEnv;
        this.adjointUnits = new TapList<Object>(null, null);
        this.bwdUnits = new TapList<Object>(null, null);
        this.fwdUnits = new TapList<Object>(null, null);
        this.tangentUnits = new TapList<Object>(null, null);
        this.unitFormalArgsActivityS = new TapList<Object>(null, null);
        this.unitDiffArgsByValueNeedOverwriteInfoS = new TapList<Object>(null, null);
        this.unitDiffArgsByValueNeedOnlyIncrementInfoS = new TapList<Object>(null, null);
    }

    protected TapList<Unit> getAllDiffs(ActivityPattern pattern) {
        TapList<Unit> result = null;
        Unit tempUnit = this.getSplitBackward(pattern);
        if (tempUnit != null) {
            result = new TapList<Unit>(tempUnit, result);
        }
        if ((tempUnit = this.getSplitForward(pattern)) != null) {
            result = new TapList<Unit>(tempUnit, result);
        }
        if ((tempUnit = this.getAdjoint(pattern)) != null) {
            result = new TapList<Unit>(tempUnit, result);
        }
        if ((tempUnit = this.getTangent(pattern)) != null) {
            result = new TapList<Unit>(tempUnit, result);
        }
        if (this.diffUnit != null && this.diffUnit.isDiffPackage().booleanValue() && !TapList.contains(result, this.diffUnit)) {
            result = new TapList<Unit>(this.diffUnit, result);
        }
        return result;
    }

    protected TapList<Unit> getAllDiffs(int diffKind) {
        TapList<Object> hdResult = new TapList<Object>(null, null);
        TapList<Object> tlResult = hdResult;
        switch (diffKind) {
            case 1: {
                tlResult = this.addUnitsAtTail(this.tangentUnits.tail, tlResult, hdResult.tail);
                break;
            }
            case 2: {
                tlResult = this.addUnitsAtTail(this.adjointUnits.tail, tlResult, hdResult.tail);
                break;
            }
            case 3: {
                tlResult = this.addUnitsAtTail(this.fwdUnits.tail, tlResult, hdResult.tail);
                break;
            }
            case 4: {
                tlResult = this.addUnitsAtTail(this.bwdUnits.tail, tlResult, hdResult.tail);
                break;
            }
            case 0: {
                Unit copyUnit = this.adEnv.getPrimalCopyOfOrigUnit(this.unit);
                if (copyUnit == null) break;
                tlResult = tlResult.placdl(copyUnit);
                break;
            }
        }
        return hdResult.tail;
    }

    protected TapList<Unit> getAllDiffs() {
        TapList<Object> hdResult;
        TapList<Object> tlResult = hdResult = new TapList<Object>(null, null);
        tlResult = this.addUnitsAtTail(this.tangentUnits.tail, tlResult, hdResult.tail);
        tlResult = this.addUnitsAtTail(this.adjointUnits.tail, tlResult, hdResult.tail);
        tlResult = this.addUnitsAtTail(this.fwdUnits.tail, tlResult, hdResult.tail);
        tlResult = this.addUnitsAtTail(this.bwdUnits.tail, tlResult, hdResult.tail);
        hdResult = hdResult.tail;
        if (this.diffUnit != null && !TapList.contains(hdResult, this.diffUnit)) {
            hdResult = new TapList<Object>(this.diffUnit, hdResult);
        }
        return hdResult;
    }

    protected TapList<Unit>[] getAllDiffsAndMode() {
        TapList[] result = new TapList[5];
        result[1] = this.getAllDiffs(1);
        result[2] = this.getAllDiffs(2);
        result[3] = this.getAllDiffs(3);
        result[4] = this.getAllDiffs(4);
        return result;
    }

    protected TapList<Unit> getAllDiffsPlusCopy() {
        TapList<Unit> result = this.getAllDiffs();
        Unit copyUnit = this.adEnv.getPrimalCopyOfOrigUnit(this.unit);
        if (copyUnit != null && !TapList.contains(result, copyUnit)) {
            result = new TapList<Unit>(copyUnit, result);
        }
        return result;
    }

    private TapList<Unit> addUnitsAtTail(TapList<TapPair<ActivityPattern, Unit>> newPatternUnits, TapList<Unit> tlIntoList, TapList<Unit> intoList) {
        while (newPatternUnits != null) {
            if (newPatternUnits.head != null) {
                TapPair patternUnit = (TapPair)newPatternUnits.head;
                if (!TapList.contains(intoList, patternUnit.second)) {
                    tlIntoList = tlIntoList.placdl((Unit)patternUnit.second);
                }
            }
            newPatternUnits = newPatternUnits.tail;
        }
        return tlIntoList;
    }

    protected Unit getDiffForModeAndActivity(int diffMode, ActivityPattern pattern) {
        switch (diffMode) {
            case 1: {
                return this.getTangent(pattern);
            }
            case 2: {
                return this.getAdjoint(pattern);
            }
            case 3: {
                return this.getSplitForward(pattern);
            }
            case 4: {
                return this.getSplitBackward(pattern);
            }
        }
        TapEnv.toolError("Error: getDiffForModeAndActivity called for illegal mode:" + diffMode);
        return null;
    }

    protected TapList<ActivityPattern> getAllDiffPatterns(int diffMode) {
        TapList<Object> hdResult;
        TapList aList;
        switch (diffMode) {
            case 1: {
                aList = this.tangentUnits.tail;
                break;
            }
            case 2: {
                aList = this.adjointUnits.tail;
                break;
            }
            case 3: {
                aList = this.fwdUnits.tail;
                break;
            }
            case 4: {
                aList = this.bwdUnits.tail;
                break;
            }
            default: {
                TapEnv.toolError("Error: getAllDiffPatterns called for illegal mode:" + diffMode);
                aList = null;
            }
        }
        TapList<Object> tlResult = hdResult = new TapList<Object>(null, null);
        while (aList != null) {
            tlResult = tlResult.placdl(((TapPair)aList.head).first);
            aList = aList.tail;
        }
        return hdResult.tail;
    }

    protected Unit getAdjoint(ActivityPattern pattern) {
        return (Unit)this.retrieveForActivity(this.adjointUnits, pattern);
    }

    protected void setAdjoint(ActivityPattern pattern, Unit adjointUnit) {
        this.storeForActivity(this.adjointUnits, pattern, adjointUnit);
    }

    protected Unit getSplitBackward(ActivityPattern pattern) {
        return (Unit)this.retrieveForActivity(this.bwdUnits, pattern);
    }

    protected void setSplitBackward(ActivityPattern pattern, Unit bwdUnit) {
        this.storeForActivity(this.bwdUnits, pattern, bwdUnit);
    }

    protected Unit getSplitForward(ActivityPattern pattern) {
        return (Unit)this.retrieveForActivity(this.fwdUnits, pattern);
    }

    protected void setSplitForward(ActivityPattern pattern, Unit fwdUnit) {
        this.storeForActivity(this.fwdUnits, pattern, fwdUnit);
    }

    protected Unit getTangent(ActivityPattern pattern) {
        return (Unit)this.retrieveForActivity(this.tangentUnits, pattern);
    }

    protected void setTangent(ActivityPattern pattern, Unit tangentUnit) {
        this.storeForActivity(this.tangentUnits, pattern, tangentUnit);
    }

    protected Unit getDiff() {
        return this.diffUnit;
    }

    protected void setDiff(Unit diffU) {
        this.diffUnit = diffU;
    }

    protected Unit getCopyForDiff() {
        return this.unit.isPackage() ? this.diffUnit : this.adEnv.getPrimalCopyOfOrigUnit(this.unit);
    }

    protected WrapperTypeSpec getDiffReturnType(int diffKind) {
        WrapperTypeSpec returnType = null;
        TapList<Unit> allDiffs = this.getAllDiffs(diffKind);
        while (returnType == null && allDiffs != null) {
            Unit oneDiffUnit = (Unit)allDiffs.head;
            if (oneDiffUnit.functionTypeSpec() != null && !TypeSpec.isA(oneDiffUnit.functionTypeSpec().returnType, 9)) {
                returnType = oneDiffUnit.functionTypeSpec().returnType;
            }
            allDiffs = allDiffs.tail;
        }
        return returnType;
    }

    protected Unit getAnyContainingDiffUnit(Unit unit, Unit container) {
        Unit principalDiffContainer = null;
        UnitDiffInfo containerInfos = this.adEnv.callGraphDifferentiator.getUnitDiffInfo(container);
        if (container.isModule()) {
            principalDiffContainer = containerInfos.getDiff();
        } else {
            TapList<ActivityPattern> itCallingContainerPatterns = this.getCallingContainerPatterns(unit, container);
            if (itCallingContainerPatterns == null) {
                itCallingContainerPatterns = container.specificInfoAD;
            }
            while (principalDiffContainer == null && itCallingContainerPatterns != null) {
                TapList<Unit> allDiffs;
                ActivityPattern curContainerActivity = (ActivityPattern)itCallingContainerPatterns.head;
                if (curContainerActivity != null && (allDiffs = containerInfos.getAllDiffs(curContainerActivity)) != null) {
                    principalDiffContainer = (Unit)allDiffs.head;
                }
                itCallingContainerPatterns = itCallingContainerPatterns.tail;
            }
            if (principalDiffContainer == null) {
                principalDiffContainer = this.adEnv.getPrimalCopyOfOrigUnit(containerInfos.unit);
            }
        }
        return principalDiffContainer;
    }

    private TapList<ActivityPattern> getCallingContainerPatterns(Unit contained, Unit container) {
        TapList<ActivityPattern> patternsOfContained = contained.specificInfoAD;
        TapList<Object> patternsOfContainer = new TapList<Object>(null, null);
        TapList<Object> dejaVu = new TapList<Object>(null, null);
        while (patternsOfContained != null) {
            ActivityPattern.walkUpToPatternOf((ActivityPattern)patternsOfContained.head, container, patternsOfContainer, dejaVu);
            patternsOfContained = patternsOfContained.tail;
        }
        return patternsOfContainer.tail;
    }

    protected boolean[] getUnitFormalArgsActivityS(ActivityPattern pattern) {
        return (boolean[])this.retrieveForActivity(this.unitFormalArgsActivityS, pattern);
    }

    protected void setUnitFormalArgsActivityS(ActivityPattern pattern, boolean[] args) {
        this.storeForActivity(this.unitFormalArgsActivityS, pattern, args);
    }

    protected boolean[] getUnitDiffArgsByValueNeedOverwriteInfoS(ActivityPattern pattern) {
        return (boolean[])this.retrieveForActivity(this.unitDiffArgsByValueNeedOverwriteInfoS, pattern);
    }

    protected void setUnitDiffArgsByValueNeedOverwriteInfoS(ActivityPattern pattern, boolean[] val) {
        this.storeForActivity(this.unitDiffArgsByValueNeedOverwriteInfoS, pattern, val);
    }

    protected boolean[] getUnitDiffArgsByValueNeedOnlyIncrementInfoS(ActivityPattern pattern) {
        return (boolean[])this.retrieveForActivity(this.unitDiffArgsByValueNeedOnlyIncrementInfoS, pattern);
    }

    protected void setUnitDiffArgsByValueNeedOnlyIncrementInfoS(ActivityPattern pattern, boolean[] val) {
        this.storeForActivity(this.unitDiffArgsByValueNeedOnlyIncrementInfoS, pattern, val);
    }

    private <T> T retrieveForActivity(TapList<TapPair<ActivityPattern, T>> haystack, ActivityPattern needle) {
        if (haystack != null && haystack.head == null) {
            haystack = haystack.tail;
        }
        while (haystack != null) {
            if (((TapPair)haystack.head).first == needle || needle == null || needle.isDisconnected()) {
                return (T)((TapPair)haystack.head).second;
            }
            haystack = haystack.tail;
        }
        return null;
    }

    private <T> void storeForActivity(TapList<TapPair<ActivityPattern, T>> haystack, ActivityPattern needle, T val) {
        TapList itHaystack = haystack.tail;
        while (itHaystack != null && ((TapPair)itHaystack.head).first != needle) {
            itHaystack = itHaystack.tail;
        }
        if (itHaystack == null) {
            haystack.tail = new TapList<TapPair<ActivityPattern, T>>(new TapPair<ActivityPattern, T>(needle, val), haystack.tail);
        } else {
            ((TapPair)itHaystack.head).second = val;
        }
    }

    public String toString() {
        return "UnitDiffInfo@" + Integer.toHexString(this.hashCode()) + " of " + this.unit + " diff(Module)Unit:" + this.diffUnit + " ORIGCOPY:" + this.adEnv.getPrimalCopyOfOrigUnit(this.unit) + " TANGENTs:" + this.tangentUnits + " ADJOINTs:" + this.adjointUnits;
    }
}

