/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.differentiation;

import fr.inria.tapenade.analysis.ActivityPattern;
import fr.inria.tapenade.differentiation.BlockDifferentiator;
import fr.inria.tapenade.differentiation.CallGraphDifferentiator;
import fr.inria.tapenade.differentiation.DifferentiationEnv;
import fr.inria.tapenade.differentiation.UnitDiffInfo;
import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.ArrayTypeSpec;
import fr.inria.tapenade.representation.CallArrow;
import fr.inria.tapenade.representation.CompositeTypeSpec;
import fr.inria.tapenade.representation.FieldDecl;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.InterfaceDecl;
import fr.inria.tapenade.representation.IterDescriptor;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeDecl;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.Tree;

public class VarRefDifferentiator {
    private final DifferentiationEnv adEnv;
    protected ArrayDim multiDirDimension;
    protected IterDescriptor multiDirIterDescriptor;
    protected IterDescriptor multiDirMaxIterDescriptor;
    protected NewSymbolHolder dirIndexSymbolHolder;
    protected NewSymbolHolder dirNumberSymbolHolder;
    protected NewSymbolHolder dirNumberMaxSymbolHolder;
    protected ArrayDim multiDirDimensionMax;
    private TapIntList diffContexts = new TapIntList(0, null);

    private CallGraphDifferentiator callGraphDifferentiator() {
        return this.adEnv.callGraphDifferentiator;
    }

    private BlockDifferentiator blockDifferentiator() {
        return this.adEnv.blockDifferentiator;
    }

    private boolean multiDirMode() {
        return this.adEnv.multiDirMode;
    }

    private String[][] suffixes() {
        return this.adEnv.suffixes;
    }

    private Unit curDiffUnit() {
        return this.adEnv.curDiffUnit;
    }

    private int curDiffUnitSort() {
        return this.adEnv.curDiffUnitSort;
    }

    private int curDiffVarSort() {
        return this.adEnv.curDiffVarSort;
    }

    protected ArrayDim getMultiDirDimensionMax() {
        return this.curDiffUnit() == null ? this.multiDirDimensionMax : this.curDiffUnit().multiDirDimensionMax;
    }

    protected Tree buildDirNumberReference(SymbolTable usageSymbolTable) {
        return this.dirNumberSymbolHolder.makeNewRef(usageSymbolTable);
    }

    protected VarRefDifferentiator(DifferentiationEnv adEnv) {
        this.adEnv = adEnv;
    }

    protected void pushDiffContext(int newContext) {
        this.diffContexts = new TapIntList(newContext, this.diffContexts);
    }

    protected void popDiffContext() {
        this.diffContexts = this.diffContexts.tail;
    }

    protected TapList<Tree> mapDiffVarRef(ActivityPattern pattern, TapList<Tree> expressions, SymbolTable diffSymbolTable) {
        TapList<Object> hdResult;
        TapList<Object> tlResult = hdResult = new TapList<Object>(null, null);
        while (expressions != null) {
            Tree expression = (Tree)expressions.head;
            tlResult = tlResult.placdl(this.diffVarRef(pattern, expression, diffSymbolTable, false, expression, false, false, expression));
            expressions = expressions.tail;
        }
        return hdResult.tail;
    }

    protected Tree diffVarRef(ActivityPattern pattern, Tree expression, SymbolTable diffSymbolTable, boolean identifyFunctionResult, Tree contextExpression, boolean needMultiDirDim, boolean addNbDirsDimContext, Tree hintRootTree) {
        Tree diffVarRef;
        block43: {
            NewSymbolHolder dirNumberMaxSH;
            Tree origDiffAllocate;
            block45: {
                boolean addNbDirsDimExpr;
                WrapperTypeSpec typeSpec;
                block44: {
                    Tree multiDirDimension;
                    WrapperTypeSpec diffElemTypeSpec;
                    int arrayDimMin;
                    if (TapEnv.associationByAddress()) {
                        diffVarRef = identifyFunctionResult ? this.diffVarRefRec(pattern, expression, diffSymbolTable, identifyFunctionResult, contextExpression, hintRootTree) : ILUtils.copy(expression);
                        String name = ILUtils.baseName(expression);
                        if (name != null) {
                            this.buildAAInstructionVORD(expression, diffSymbolTable, diffVarRef, TapEnv.assocAddressValueSuffix());
                            VariableDecl varDecl = diffSymbolTable.getVariableDecl(name);
                            if (varDecl != null) {
                                diffVarRef = ILUtils.build(73, ILUtils.copy(diffVarRef), ILUtils.build(94, "d"));
                            }
                        }
                    } else {
                        diffVarRef = this.diffVarRefRec(pattern, expression, diffSymbolTable, identifyFunctionResult, contextExpression, hintRootTree);
                    }
                    typeSpec = diffSymbolTable.typeOf(expression);
                    if (!this.multiDirMode() || diffVarRef == null) break block43;
                    addNbDirsDimExpr = true;
                    origDiffAllocate = null;
                    if (expression.opCode() == 4) {
                        origDiffAllocate = diffVarRef;
                        diffVarRef = ILUtils.build(94, "diffallocvar");
                        if (!ILUtils.isNullOrNone(origDiffAllocate.down(2))) {
                            diffVarRef = ILUtils.build(8, diffVarRef, origDiffAllocate.cutChild(2));
                        }
                    } else if (expression.opCode() == 51) {
                        typeSpec = diffSymbolTable.typeOf(expression.down(1));
                        addNbDirsDimExpr = VarRefDifferentiator.mustAddNbDirsDim(typeSpec);
                    } else {
                        addNbDirsDimExpr = !VarRefDifferentiator.mayAddSimplyColon(typeSpec);
                    }
                    addNbDirsDimExpr = addNbDirsDimExpr && addNbDirsDimContext;
                    dirNumberMaxSH = this.curDiffUnit() == null ? this.dirNumberMaxSymbolHolder : this.curDiffUnit().dirNumberMaxSymbolHolder;
                    int n = arrayDimMin = this.curDiffUnit() == null ? 0 : this.curDiffUnit().arrayDimMin;
                    if (contextExpression.opCode() != 194 && contextExpression.opCode() != 197 && contextExpression.opCode() != 196 && contextExpression.opCode() != 150 && contextExpression.opCode() != 10) break block44;
                    if (this.diffContexts.head != 0) break block45;
                    VariableDecl varDecl = diffSymbolTable.getVariableDecl(ILUtils.baseName(expression));
                    boolean insertMultiDirDimension = true;
                    if (typeSpec != null && typeSpec.wrappedType != null && typeSpec.wrappedType.diffTypeSpec != null) {
                        insertMultiDirDimension = false;
                    } else if (TypeSpec.isA(typeSpec, 2) && (diffElemTypeSpec = typeSpec.wrappedType.elementType().wrappedType.diffTypeSpec) != null) {
                        insertMultiDirDimension = false;
                    }
                    if (!insertMultiDirDimension || contextExpression.opCode() != 197 && contextExpression.opCode() != 196 && contextExpression.opCode() != 10 && varDecl.hasInstructionWithRootOperator(197, null)) break block45;
                    Tree dimColonsTree = ILUtils.findDimColons(contextExpression);
                    if (TapEnv.relatedLanguageIsFortran() && TypeSpec.isA(typeSpec, 6)) {
                        multiDirDimension = ILUtils.build(58, ILUtils.build(136), ILUtils.build(136));
                    } else {
                        Tree nbDirsMaxExpr = TapEnv.get().nbdirsmaxString != null ? ILUtils.build(94, TapEnv.get().nbdirsmaxString) : dirNumberMaxSH.makeNewRef(diffSymbolTable);
                        multiDirDimension = ILUtils.buildDimColon(arrayDimMin, nbDirsMaxExpr);
                    }
                    if (contextExpression.opCode() != 194 || dimColonsTree == null || dimColonsTree.opCode() != 59) {
                        if (diffVarRef.opCode() == 10) {
                            diffVarRef.down(2).addChild(multiDirDimension, -1);
                        } else if (needMultiDirDim) {
                            diffVarRef = ILUtils.build(10, diffVarRef, ILUtils.build(59, multiDirDimension));
                        }
                    }
                    if (contextExpression.opCode() != 197) break block45;
                    diffVarRef.down(2).addChild(multiDirDimension, -1);
                    break block45;
                }
                if (contextExpression.opCode() != 166) {
                    Tree newVectIndex = null;
                    if (expression.opCode() == 4) {
                        newVectIndex = TapEnv.get().nbdirsmaxString != null ? ILUtils.build(94, TapEnv.get().nbdirsmaxString) : dirNumberMaxSH.makeNewRef(diffSymbolTable);
                    } else if (!VarRefDifferentiator.mustAddNbDirsDim(typeSpec)) {
                        newVectIndex = null;
                    } else if (this.diffContexts.head == 0) {
                        newVectIndex = addNbDirsDimExpr ? this.dirIndexSymbolHolder.makeNewRef(diffSymbolTable) : ILUtils.build(11);
                    } else if (diffVarRef.opCode() == 8) {
                        if (this.adEnv.curUnit().language() == 1) {
                            newVectIndex = ILUtils.build(101, 1);
                        } else if (this.adEnv.curUnit().language() == 2 || this.adEnv.curUnit().language() == 3) {
                            newVectIndex = ILUtils.build(11);
                        }
                    } else if (diffVarRef.opCode() == 150) {
                        newVectIndex = this.dirIndexSymbolHolder.makeNewRef(diffSymbolTable);
                    }
                    if (newVectIndex != null) {
                        int addressOfs = 0;
                        while (diffVarRef.opCode() == 3) {
                            ++addressOfs;
                            diffVarRef = diffVarRef.down(1);
                        }
                        if (TypeSpec.isA(typeSpec, 2) && diffVarRef.opCode() != 8) {
                            ArrayTypeSpec arrayTypeSpec = TypeSpec.isA(typeSpec, 2) ? (ArrayTypeSpec)typeSpec.wrappedType : (ArrayTypeSpec)((PointerTypeSpec)typeSpec.wrappedType).destinationType.wrappedType;
                            Tree diffDimensions = ILUtils.build(70);
                            for (int dim = arrayTypeSpec.dimensions().length; dim > 0; --dim) {
                                diffDimensions.addChild(ILUtils.build(11), 1);
                            }
                            diffVarRef = ILUtils.build(8, diffVarRef, diffDimensions);
                        }
                        if (diffVarRef.opCode() == 8) {
                            diffVarRef.down(2).addChild(newVectIndex, -1);
                        } else if (this.curDiffUnit().isC()) {
                            diffVarRef = expression.opCode() == 148 && expression.down(2).opCode() == 136 ? ILUtils.build(148, diffVarRef, newVectIndex) : (expression.opCode() == 150 ? ILUtils.build(8, ILUtils.copy(diffVarRef.down(1)), ILUtils.build(70, newVectIndex)) : ILUtils.build(148, diffVarRef, newVectIndex));
                        } else if (!TypeSpec.isA(typeSpec, 6)) {
                            diffVarRef = ILUtils.build(8, diffVarRef, ILUtils.build(70, newVectIndex));
                        }
                        while (addressOfs > 0) {
                            diffVarRef = ILUtils.build(3, diffVarRef);
                            --addressOfs;
                        }
                    }
                }
            }
            if (origDiffAllocate != null) {
                if (!ILUtils.isNullOrNone(origDiffAllocate.down(1))) {
                    Tree nbDirsMaxExpr = TapEnv.get().nbdirsmaxString != null ? ILUtils.build(94, TapEnv.get().nbdirsmaxString) : dirNumberMaxSH.makeNewRef(diffSymbolTable);
                    origDiffAllocate.setChild(ILUtils.build(131, origDiffAllocate.cutChild(1), nbDirsMaxExpr), 1);
                }
                origDiffAllocate.setChild(diffVarRef.cutChild(2), 2);
                diffVarRef = origDiffAllocate;
            }
        }
        return diffVarRef;
    }

    private Tree diffVarRefRec(ActivityPattern pattern, Tree expression, SymbolTable diffSymbolTable, boolean identifyFunctionResult, Tree contextExpression, Tree hintRootTree) {
        switch (expression.opCode()) {
            case 4: {
                Tree diffTypeTree = this.differentiateTypeTree(expression.down(3), diffSymbolTable);
                Tree treeSIZEOF = ILUtils.copy(expression.down(1));
                Tree sizeofCall = ILUtils.findSizeofCall(treeSIZEOF);
                if (sizeofCall != null) {
                    sizeofCall.setChild(this.differentiateTypeTree(sizeofCall.cutChild(1), diffSymbolTable), 1);
                }
                return ILUtils.build(4, treeSIZEOF, ILUtils.copy(expression.down(2)), diffTypeTree, ILUtils.copy(expression.down(4)), ILUtils.build(136));
            }
            case 3: 
            case 51: 
            case 150: {
                return ILUtils.build(expression.opCode(), this.diffVarRefRec(pattern, expression.down(1), diffSymbolTable, identifyFunctionResult, contextExpression, hintRootTree));
            }
            case 8: 
            case 73: 
            case 148: 
            case 170: {
                return ILUtils.build(expression.opCode(), this.diffVarRefRec(pattern, expression.down(1), diffSymbolTable, identifyFunctionResult, contextExpression, hintRootTree), ILUtils.copy(expression.down(2)));
            }
            case 10: {
                Tree[] oldDims = expression.down(2).children();
                TapList<Tree> newDims = null;
                if (TapEnv.relatedLanguageIsFortran9x() && !WrapperTypeSpec.hasPointerOnTop(this.adEnv.curSymbolTable().typeOf(expression.down(1))) && this.paramHasOnlyLocalDiff(pattern, expression.down(1), null)) {
                    String hintNameInIdent;
                    String hintNameInText = hintNameInIdent = ILUtils.baseName(expression.down(1));
                    Tree hintTreeSize = ILUtils.baseTree(expression.down(1));
                    if (NewSymbolHolder.isANewSymbolRef(expression.down(1))) {
                        NewSymbolHolder exprSymbolHolder = NewSymbolHolder.getNewSymbolHolder(expression.down(1));
                        Tree origHintRootTree = exprSymbolHolder.hintRootTree;
                        hintNameInIdent = ILUtils.buildNameInText(origHintRootTree);
                        hintNameInText = ILUtils.buildNameInText(origHintRootTree);
                        hintTreeSize = exprSymbolHolder.hintArrayTreeForCallSize;
                    }
                    for (int i = oldDims.length - 1; i >= 0; --i) {
                        Tree newDim;
                        if (ILUtils.isNullOrNoneOrStar(oldDims[i]) || oldDims[i].opCode() == 58 && ILUtils.isNullOrNoneOrStar(oldDims[i].down(2))) {
                            Tree newInit = ILUtils.build(136);
                            if (oldDims[i] != null && oldDims[i].opCode() == 58) {
                                newInit = ILUtils.copy(oldDims[i].down(1));
                            }
                            IterDescriptor dimIterDescriptor = new IterDescriptor(0, diffSymbolTable, null, null, expression, hintNameInText, hintNameInIdent, hintTreeSize, i + 1, oldDims.length);
                            dimIterDescriptor.preciseDefaultLengthTree(this.curDiffUnit(), diffSymbolTable);
                            newDim = ILUtils.build(58, newInit, dimIterDescriptor.getLengthTree());
                        } else {
                            newDim = ILUtils.copy(oldDims[i]);
                        }
                        newDims = new TapList<Tree>(newDim, newDims);
                    }
                }
                Tree result = ILUtils.build(expression.opCode(), this.diffVarRefRec(pattern, expression.down(1), diffSymbolTable, identifyFunctionResult, contextExpression, hintRootTree), newDims == null ? ILUtils.copy(expression.down(2)) : ILUtils.build(59, newDims));
                return result;
            }
            case 126: {
                return ILUtils.build(expression.opCode(), ILUtils.copy(expression.down(1)), this.diffVarRefRec(pattern, expression.down(2), diffSymbolTable, identifyFunctionResult, contextExpression, hintRootTree));
            }
            case 13: {
                return this.diffVarRefRec(pattern, expression.down(1), diffSymbolTable, identifyFunctionResult, contextExpression, hintRootTree);
            }
            case 94: {
                Tree result = this.diffSymbolTree(pattern, expression, diffSymbolTable, true, identifyFunctionResult, false, contextExpression, false, this.curDiffVarSort(), this.curDiffUnitSort(), 0, hintRootTree);
                return result;
            }
            case 2: 
            case 177: {
                boolean argIsPointer = TypeSpec.isA(this.adEnv.curSymbolTable().typeOf(expression.down(1)), 6);
                Tree diffRef1 = null;
                if (argIsPointer) {
                    diffRef1 = this.diffVarRefRec(pattern, expression.down(1), diffSymbolTable, identifyFunctionResult, contextExpression, hintRootTree);
                }
                if (diffRef1 == null) {
                    diffRef1 = ILUtils.copy(expression.down(1));
                }
                argIsPointer = TypeSpec.isA(this.adEnv.curSymbolTable().typeOf(expression.down(2)), 6);
                Tree diffRef2 = null;
                if (argIsPointer) {
                    diffRef2 = this.diffVarRefRec(pattern, expression.down(2), diffSymbolTable, identifyFunctionResult, contextExpression, hintRootTree);
                }
                if (diffRef2 == null) {
                    diffRef2 = ILUtils.copy(expression.down(2));
                }
                return ILUtils.build(expression.opCode(), diffRef1, diffRef2);
            }
            case 101: {
                return null;
            }
            case 136: {
                return null;
            }
            case 31: {
                Tree diffRef2 = this.diffVarRefRec(pattern, expression.down(2), diffSymbolTable, identifyFunctionResult, contextExpression, hintRootTree);
                if (diffRef2 == null) {
                    diffRef2 = ILUtils.copy(expression.down(2));
                }
                return ILUtils.build(31, ILUtils.copy(expression.down(1)), diffRef2);
            }
            case 88: {
                TapEnv.toolWarning(-1, "(Differentiate reference) Unexpected operator: " + expression.opName());
                return ILUtils.copy(expression);
            }
            case 30: {
                TapEnv.toolWarning(-1, "(Differentiate reference) Unexpected operator: " + expression.opName());
                return null;
            }
            case 9: {
                TapEnv.toolWarning(-1, "(Differentiate reference) Unexpected operator: " + expression.opName());
                return null;
            }
        }
        TapEnv.toolWarning(-1, "(Differentiate reference) Unexpected operator: " + expression.opName());
        return null;
    }

    protected Tree buildAAInstructionVORD(Tree expression, SymbolTable diffSymbolTable, Tree diffVarRef, String vORd) {
        String varName = ILUtils.baseName(expression);
        VariableDecl varDecl = diffSymbolTable.getVariableDecl(varName);
        Unit copyUnit = this.adEnv.getPrimalCopyOfOrigUnit(this.adEnv.curUnit());
        if (varDecl != null && (varDecl.isActive() || !TapEnv.doActivity())) {
            WrapperTypeSpec baseTypeSpec;
            WrapperTypeSpec diffTypeSpec = varDecl.type().wrappedType.diffTypeSpec;
            if (diffTypeSpec == null) {
                diffTypeSpec = varDecl.type().checkDiffTypeSpec(diffSymbolTable, this.adEnv.curUnit().privateSymbolTable(), this.curDiffUnitSort(), this.suffixes()[1][3], false, this.multiDirMode(), this.multiDirDimensionMax, null, "", "", null, null);
            }
            WrapperTypeSpec rootDiffTypeSpec = diffTypeSpec;
            if (copyUnit != this.curDiffUnit() && diffTypeSpec != null) {
                baseTypeSpec = diffTypeSpec.baseTypeSpec(false);
            } else {
                baseTypeSpec = varDecl.type().baseTypeSpec(false);
                diffTypeSpec = baseTypeSpec.wrappedType.diffTypeSpec;
                if (diffTypeSpec == null) {
                    diffTypeSpec = baseTypeSpec.checkDiffTypeSpec(diffSymbolTable, this.adEnv.curUnit().privateSymbolTable(), this.curDiffUnitSort(), this.suffixes()[1][3], false, this.multiDirMode(), this.multiDirDimensionMax, null, "", "", null, null);
                }
                if (copyUnit != this.curDiffUnit() && diffTypeSpec != null) {
                    baseTypeSpec = diffTypeSpec;
                }
            }
            if (!TypeSpec.isA(baseTypeSpec, 21)) {
                WrapperTypeSpec modifiedBaseTypeSpec = varDecl.type().modifiedBaseTypeSpec();
                if (copyUnit != this.curDiffUnit() && modifiedBaseTypeSpec != null) {
                    baseTypeSpec = modifiedBaseTypeSpec.wrappedType.diffTypeSpec;
                }
            }
            if (TypeSpec.isA(baseTypeSpec, 21) && ((CompositeTypeSpec)baseTypeSpec.wrappedType).namedFieldDecl(vORd) != null) {
                if (varDecl.type() != rootDiffTypeSpec && rootDiffTypeSpec != null) {
                    varDecl.setType(rootDiffTypeSpec);
                }
                return ILUtils.build(73, ILUtils.copy(diffVarRef), ILUtils.build(94, vORd));
            }
            return ILUtils.copy(expression);
        }
        return ILUtils.copy(expression);
    }

    protected Tree differentiateTypeTree(Tree typeTree, SymbolTable diffSymbolTable) {
        WrapperTypeSpec diffTypeSpec = null;
        if (!ILUtils.isNullOrNone(typeTree)) {
            ToBool isPointer = new ToBool(false);
            WrapperTypeSpec typeSpec = TypeSpec.build(typeTree, diffSymbolTable, this.adEnv.curInstruction(), new TapList<Object>(null, null), new TapList<Object>(null, null), new TapList<Object>(null, null), isPointer, null);
            diffTypeSpec = typeSpec.checkDiffTypeSpec(diffSymbolTable, this.adEnv.curSymbolTable(), this.curDiffUnitSort(), this.suffixes()[this.curDiffUnitSort()][3], false, this.multiDirMode(), this.getMultiDirDimensionMax(), null, null, null, null, null);
            if (diffTypeSpec != null && isPointer.get()) {
                diffTypeSpec = new WrapperTypeSpec(new PointerTypeSpec(diffTypeSpec, null));
            }
        }
        return diffTypeSpec == null ? ILUtils.copy(typeTree) : diffTypeSpec.generateTree(diffSymbolTable, null, null, true, null);
    }

    protected Tree diffVarRefNoCopy(ActivityPattern pattern, Tree expression, SymbolTable diffSymbolTable, boolean identifyFunctionResult, Tree hintRootTree) {
        switch (expression.opCode()) {
            case 3: 
            case 73: 
            case 148: {
                this.diffVarRefNoCopy(pattern, expression.down(1), diffSymbolTable, identifyFunctionResult, hintRootTree);
                break;
            }
            case 8: {
                boolean wasIdent = expression.down(1).opCode() == 94;
                this.diffVarRefNoCopy(pattern, expression.down(1), diffSymbolTable, identifyFunctionResult, hintRootTree);
                if (!this.multiDirMode() || !wasIdent) break;
                if (this.diffContexts.head == 0) {
                    Tree diffName = expression.down(1).cutChild(1);
                    Tree index = expression.down(1).down(2).cutChild(1);
                    Tree indexes = expression.cutChild(2);
                    indexes.addChild(index, indexes.length() + 1);
                    expression.setChild(diffName, 1);
                    expression.setChild(indexes, 2);
                    break;
                }
                if (this.adEnv.curUnit().isC()) {
                    expression.down(2).addChild(ILUtils.build(101, 0), expression.down(2).length() + 1);
                    break;
                }
                expression.down(2).addChild(ILUtils.build(101, 1), expression.down(2).length() + 1);
                break;
            }
            case 94: {
                Tree father = expression.parent();
                Tree diffSymbolTree = this.diffSymbolTree(pattern, expression, diffSymbolTable, true, identifyFunctionResult, false, father, false, this.curDiffVarSort(), this.curDiffUnitSort(), 0, hintRootTree);
                WrapperTypeSpec type = diffSymbolTable.typeOf(expression);
                if (this.multiDirMode() && this.diffContexts.head == 0 && !TypeSpec.isA(type, 6)) {
                    diffSymbolTree = ILUtils.build(8, diffSymbolTree, ILUtils.build(70, this.dirIndexSymbolHolder.makeNewRef(diffSymbolTable)));
                }
                if (father == null) {
                    expression = diffSymbolTree;
                    break;
                }
                int rank = expression.rankInParent();
                father.setChild(diffSymbolTree, rank);
                break;
            }
            default: {
                TapEnv.toolWarning(-1, "(Differentiate reference 2) Unexpected operator: " + expression.opName());
            }
        }
        return expression;
    }

    protected Tree diffSymbolTree(ActivityPattern pattern, Tree symbolTree, SymbolTable diffSymbolTable, boolean searchAsVariable, boolean searchAsFunction, boolean searchAsModule, Tree callTree, boolean skipImportedSymbolTables, int diffSort, int diffSuffixSort, int symbolSort, Tree hintRootTree) {
        Tree diffTree;
        if (TapEnv.associationByAddress() && searchAsVariable && !searchAsFunction) {
            VariableDecl varDecl;
            Tree diffTree2 = ILUtils.copy(symbolTree);
            NewSymbolHolder sHolder = NewSymbolHolder.getNewSymbolHolder(symbolTree);
            if (sHolder != null) {
                varDecl = sHolder.newVariableDecl();
            } else {
                String symbolName = ILUtils.getIdentString(symbolTree);
                varDecl = diffSymbolTable.getVariableDecl(symbolName);
            }
            if (varDecl != null) {
                varDecl.setActive();
                WrapperTypeSpec diffTypeSpec = varDecl.type().wrappedType.diffTypeSpec;
                if (diffTypeSpec != null) {
                    varDecl.setType(diffTypeSpec);
                }
            }
            return diffTree2;
        }
        NewSymbolHolder sHolder = NewSymbolHolder.getNewSymbolHolder(symbolTree);
        if (sHolder != null) {
            VariableDecl varDecl = sHolder.newVariableDecl();
            NewSymbolHolder diffSymbolHolder = varDecl.getDiffSymbolHolder(diffSort, null);
            if (diffSymbolHolder == null) {
                Tree origHintRootTree = sHolder.hintRootTree;
                if (origHintRootTree == null) {
                    origHintRootTree = hintRootTree;
                }
                diffSymbolHolder = new NewSymbolHolder(TapEnv.extendStringWithSuffix(sHolder.probableName, this.suffixes()[diffSuffixSort][symbolSort]), diffSort);
                diffSymbolHolder.isDerivationFrom(varDecl, this.suffixes()[diffSuffixSort][symbolSort]);
                diffSymbolHolder.accumulateSymbolDecl(this.prepareDifferentiatedSymbolDecl(pattern, varDecl, sHolder, diffSymbolTable, diffSort, origHintRootTree), diffSymbolTable);
                varDecl.setDiffSymbolHolder(diffSort, null, diffSymbolHolder, 5);
                varDecl.setActive();
            } else {
                diffSymbolHolder.accumulateTargetForSymbolDecl(varDecl, diffSymbolTable);
            }
            diffTree = diffSymbolHolder.makeNewRef(diffSymbolTable);
            if (this.isOnlyIncrementedDiff(pattern, varDecl)) {
                diffSymbolHolder.setUsesRefTo();
            }
            if (diffSymbolHolder.usesRefTo() && this.adEnv.curUnit().isC()) {
                diffTree = this.diffContexts.head == 2 || callTree != null && callTree.opCode() == 10 ? ILUtils.build(150, diffTree) : ILUtils.build(148, diffTree, ILUtils.build(136));
            }
        } else {
            String symbolName = ILUtils.getIdentString(symbolTree);
            WrapperTypeSpec[] actualTypes = null;
            if (callTree != null && callTree.opCode() == 30) {
                String calledAliasName = ILUtils.getCallFunctionNameString(callTree);
                if (searchAsFunction && !calledAliasName.equals(symbolName)) {
                    symbolName = calledAliasName;
                }
                Tree[] sons = ILUtils.getArguments(callTree).children();
                actualTypes = new WrapperTypeSpec[sons.length];
                for (int i = sons.length - 1; i >= 0; --i) {
                    actualTypes[i] = diffSymbolTable.typeOf(sons[i]);
                }
            }
            diffTree = this.diffSymbolName(pattern, symbolName, diffSymbolTable, searchAsVariable, searchAsFunction, searchAsModule, callTree, actualTypes, skipImportedSymbolTables, diffSort, diffSuffixSort, symbolSort, hintRootTree);
        }
        return diffTree;
    }

    protected Tree diffSymbolName(ActivityPattern pattern, String symbolName, SymbolTable diffSymbolTable, boolean searchAsVariable, boolean searchAsFunction, boolean searchAsModule, Tree callTree, WrapperTypeSpec[] actualTypes, boolean skipImportedSymbolTables, int diffSort, int diffSuffixSort, int symbolSort, Tree hintRootTree) {
        Tree diffTree;
        Unit destinUnit;
        String origName = symbolName;
        CallArrow callArrow = null;
        if (searchAsFunction && callTree != null && callTree.opCode() == 30 && (callArrow = (CallArrow)callTree.getAnnotation("callArrow")) != null && callArrow.origin() != null && callArrow.origin().language() != callArrow.destination().language()) {
            destinUnit = callArrow.destination();
            symbolName = destinUnit.name;
        }
        TapList<TapPair<SymbolTable, TapList<SymbolDecl>>> brotherDecls = this.collectBrotherDecls(pattern, symbolName, diffSymbolTable, searchAsVariable, searchAsFunction, searchAsModule, callTree, actualTypes, skipImportedSymbolTables, diffSort, diffSuffixSort, symbolSort, hintRootTree);
        NewSymbolHolder diffSymbolHolder = this.uniqueDiffSymbolHolder(pattern, brotherDecls, symbolName, diffSymbolTable, diffSort, diffSuffixSort, symbolSort, hintRootTree, callTree, searchAsFunction);
        if (searchAsFunction && callTree != null) {
            int originLanguage = -1;
            int destinLanguage = -1;
            String name = null;
            if (callTree.opCode() == 30) {
                if (callArrow != null) {
                    Unit originUnit = callArrow.origin();
                    originLanguage = originUnit == null ? this.adEnv.curUnit().language() : originUnit.language();
                    destinUnit = callArrow.destination();
                    destinLanguage = destinUnit.language();
                    name = callArrow.destination().name;
                } else if (this.adEnv.curUnit() != null && symbolName.equals(this.adEnv.curUnit().name) && this.adEnv.curUnit().isC() && this.adEnv.curUnit().isCalledFromOtherLanguage()) {
                    name = (String)this.adEnv.srcCallGraph().getMixedLanguageFunctionName((String)symbolName, (int)4, (int)1).first;
                    if (name == null) {
                        name = symbolName;
                    }
                    originLanguage = 4;
                    destinLanguage = 1;
                }
            } else if (callTree.opCode() == 194) {
                FunctionDecl funcDecl;
                TapList<FunctionDecl> funcDecls = diffSymbolTable.getFunctionDecl(symbolName, null, null, false);
                FunctionDecl functionDecl = funcDecl = funcDecls == null ? null : (FunctionDecl)funcDecls.head;
                if (funcDecl == null && TapEnv.inputLanguage() == 100) {
                    funcDecls = this.adEnv.diffCallGraph().fortranRootSymbolTable().getFunctionDecl(symbolName, null, null, false);
                    FunctionDecl functionDecl2 = funcDecl = funcDecls == null ? null : (FunctionDecl)funcDecls.head;
                    if (funcDecl == null) {
                        funcDecls = this.adEnv.diffCallGraph().cRootSymbolTable().getFunctionDecl(symbolName, null, null, false);
                        FunctionDecl functionDecl3 = funcDecl = funcDecls == null ? null : (FunctionDecl)funcDecls.head;
                    }
                }
                if (this.blockDifferentiator().mixedLanguage(funcDecl)) {
                    originLanguage = this.adEnv.curUnit() == null ? 4 : this.adEnv.curUnit().language();
                    destinUnit = funcDecl.unit();
                    destinLanguage = destinUnit.language();
                    name = symbolName;
                }
            }
            String oldDiffSymbolName = diffSymbolHolder.probableName;
            if (originLanguage != -1 && originLanguage != destinLanguage) {
                String suffix = this.suffixes()[diffSuffixSort][symbolSort];
                if (this.adEnv.curUnit() != null && this.adEnv.curUnit().isFortran()) {
                    String otherName = (String)this.adEnv.srcCallGraph().getMixedLanguageFunctionName((String)name, (int)destinLanguage, (int)originLanguage).first;
                    if (otherName != null) {
                        name = otherName;
                    }
                    if (callTree.opCode() == 30 && this.adEnv.diffCallGraph().getOtherLangFunctionDeclFromBindC(name, 1) == null) {
                        name = origName;
                    }
                }
                String diffFuncName = name + suffix;
                if (this.adEnv.curUnit() == null || this.adEnv.curUnit().isC()) {
                    String diffUnitName;
                    if (this.adEnv.diffCallGraph().getOtherLangFunctionDeclFromBindC(name, 1) == null) {
                        diffFuncName = (String)this.adEnv.diffCallGraph().getMixedLanguageFunctionName((String)diffFuncName, (int)destinLanguage, (int)originLanguage).first;
                    } else if (diffSymbolHolder.newFunctionDecl() != null && (diffUnitName = diffSymbolHolder.newFunctionDecl().unit().name).startsWith("#")) {
                        diffFuncName = diffUnitName.substring(1, diffUnitName.length() - 1);
                    }
                }
                diffSymbolHolder.probableName = diffFuncName;
            }
            diffTree = diffSymbolHolder.makeNewRef(diffSymbolTable);
            diffSymbolHolder.probableName = oldDiffSymbolName;
        } else if (searchAsVariable) {
            VariableDecl cVarDecl = this.adEnv.srcCallGraph().cRootSymbolTable().getVariableDecl(symbolName);
            if (cVarDecl != null && cVarDecl.renamedFromSymbolDecl != null && cVarDecl.renamedFromSymbolDecl.kind == 11) {
                String suffix = this.suffixes()[diffSuffixSort][1];
                String diffVarName = cVarDecl.renamedFromSymbolDecl.symbol + suffix;
                diffSymbolHolder.probableName = diffVarName = this.adEnv.diffCallGraph().getOtherLanguageName(diffVarName, 1, 4);
            }
            diffTree = diffSymbolHolder.makeNewRef(diffSymbolTable);
        } else {
            diffTree = diffSymbolHolder.makeNewRef(diffSymbolTable);
        }
        if (diffSymbolHolder.usesRefTo() && this.adEnv.curUnit().isC()) {
            diffTree = this.diffContexts.head == 2 || callTree != null && callTree.opCode() == 10 ? ILUtils.build(150, diffTree) : ILUtils.build(148, diffTree, ILUtils.build(136));
        }
        return diffTree;
    }

    private TapList<TapPair<SymbolTable, TapList<SymbolDecl>>> collectBrotherDecls(ActivityPattern pattern, String symbolName, SymbolTable diffSymbolTable, boolean searchAsVariable, boolean searchAsFunction, boolean searchAsModule, Tree callTree, WrapperTypeSpec[] actualTypes, boolean skipImportedSymbolTables, int diffSort, int diffSuffixSort, int symbolSort, Tree hintRootTree) {
        boolean searchInOtherRootLanguageST;
        TapList<Object> brotherDecls = new TapList<Object>(null, null);
        SymbolTable curST = diffSymbolTable;
        SymbolTable nextST = null;
        boolean bl = searchInOtherRootLanguageST = TapEnv.inputLanguage() == 100;
        while (curST != null && (searchAsVariable || searchAsFunction || searchAsModule)) {
            Unit diffMod;
            VariableDecl variableDecl = null;
            FunctionDecl functionDecl = null;
            InterfaceDecl interfaceDecl = null;
            FunctionDecl moduleDecl = null;
            if (searchAsVariable) {
                variableDecl = curST.getTopVariableOrConstantDecl(symbolName);
            }
            if (searchAsFunction) {
                TapList<FunctionDecl> functionDecls = curST.getTopFunctionDecl(symbolName, null, actualTypes, null, true);
                if (functionDecls == null) {
                    functionDecls = curST.getTopFunctionDecl(symbolName, null, null, null, false);
                }
                FunctionDecl functionDecl2 = functionDecl = functionDecls == null ? null : (FunctionDecl)functionDecls.head;
                if (functionDecl != null && functionDecl.isVarFunction()) {
                    searchAsFunction = false;
                }
                interfaceDecl = curST.getTopInterfaceDecl(symbolName);
            }
            if (searchAsModule) {
                moduleDecl = curST.getTopModuleDecl(symbolName);
            }
            if (variableDecl != null) {
                this.addIntoBrotherDecls(brotherDecls, variableDecl, curST);
                if (curST.usedModule != null) {
                    diffMod = curST.usedModule;
                    if (variableDecl.renamedFromSymbolDecl != null) {
                        this.diffSymbolName(pattern, variableDecl.renamedFromSymbolDecl.symbol, diffMod.publicSymbolTable(), searchAsVariable, searchAsFunction, searchAsModule, callTree, actualTypes, false, diffSort, diffSuffixSort, symbolSort, hintRootTree);
                        searchAsVariable = false;
                    } else {
                        nextST = diffMod.publicSymbolTable();
                    }
                } else if (this.adEnv.curUnit() != null && this.adEnv.curUnit().isFortran() && symbolName.equals(this.adEnv.curUnit().name) && (this.curDiffUnitSort() == 1 || pattern != null && pattern.isContext() && this.adEnv.curUnit().isAContext()) && this.diffFunctionIsFunction(this.adEnv.curUnit())) {
                    searchAsFunction = true;
                    searchAsVariable = false;
                } else if (!variableDecl.isShared()) {
                    searchAsFunction = false;
                    searchAsVariable = false;
                }
            }
            if (interfaceDecl != null) {
                FunctionDecl cfuncDecl;
                TapTriplet<String, String, FunctionDecl> otherFun;
                this.addIntoBrotherDecls(brotherDecls, interfaceDecl, curST);
                if (curST.usedModule == null) {
                    FunctionDecl funcDeclI;
                    if (callTree != null && actualTypes != null && (funcDeclI = interfaceDecl.findFunctionDecl(actualTypes, null, callTree)) != null && !funcDeclI.symbol.equals(symbolName) && !funcDeclI.symbol.equals(interfaceDecl.symbol)) {
                        this.diffSymbolName(pattern, funcDeclI.symbol, curST, false, true, false, callTree, actualTypes, false, diffSort, diffSuffixSort, symbolSort, hintRootTree);
                        searchAsFunction = false;
                    }
                } else {
                    diffMod = curST.usedModule;
                    if (interfaceDecl.renamedFromSymbolDecl != null) {
                        this.diffSymbolName(pattern, interfaceDecl.renamedFromSymbolDecl.symbol, diffMod.publicSymbolTable(), searchAsVariable, searchAsFunction, searchAsModule, callTree, actualTypes, false, diffSort, diffSuffixSort, symbolSort, hintRootTree);
                        searchAsFunction = false;
                    } else {
                        nextST = diffMod.publicSymbolTable();
                    }
                }
                if (TapEnv.inputLanguage() != 100 || (otherFun = this.adEnv.diffCallGraph().getOtherLangFunctionDeclFromBindC(symbolName, 4)) == null || (cfuncDecl = (FunctionDecl)otherFun.third) != null) {
                    // empty if block
                }
            }
            if (functionDecl != null) {
                FunctionDecl otherFuncDecl = null;
                this.addIntoBrotherDecls(brotherDecls, functionDecl, curST);
                if (curST.usedModule == null) {
                    if (functionDecl.unit() != null && this.adEnv.curUnit() != null && functionDecl.unit().language() != this.adEnv.curUnit().language() && functionDecl.renamedFromSymbolDecl != null && !functionDecl.renamedFromSymbolDecl.symbol.equals(symbolName)) {
                        this.diffSymbolName(pattern, functionDecl.renamedFromSymbolDecl.symbol, curST, searchAsVariable, searchAsFunction, searchAsModule, callTree, actualTypes, false, diffSort, diffSuffixSort, symbolSort, hintRootTree);
                    }
                    if (this.isTopDeclarationLevel(curST, functionDecl) || curST.basisSymbolTable() == this.adEnv.diffCallGraph().globalRootSymbolTable()) {
                        searchAsFunction = false;
                    }
                } else {
                    Unit diffMod2 = curST.usedModule;
                    if (functionDecl.renamedFromSymbolDecl != null) {
                        this.diffSymbolName(pattern, functionDecl.renamedFromSymbolDecl.symbol, diffMod2.publicSymbolTable(), searchAsVariable, searchAsFunction, searchAsModule, callTree, actualTypes, false, diffSort, diffSuffixSort, symbolSort, hintRootTree);
                        searchAsFunction = false;
                    } else {
                        nextST = diffMod2.publicSymbolTable();
                    }
                }
                if (TapEnv.inputLanguage() == 100) {
                    TapTriplet<String, String, FunctionDecl> otherFun;
                    int otherLang = 1;
                    if (functionDecl.unit().isFortran()) {
                        otherLang = 4;
                    }
                    if ((otherFun = this.adEnv.diffCallGraph().getOtherLangFunctionDeclFromBindC(symbolName, otherLang)) != null && (otherFuncDecl = (FunctionDecl)otherFun.third) != null && otherFuncDecl.unit().isFortran2003() && !otherFuncDecl.unit().isInterface()) {
                        this.addIntoBrotherDecls(brotherDecls, otherFuncDecl, this.adEnv.diffCallGraph().languageRootSymbolTable(otherLang));
                    }
                }
                if (!searchAsFunction && otherFuncDecl == null && callTree != null && callTree.opCode() == 103) {
                    searchAsFunction = true;
                }
            }
            if (moduleDecl != null) {
                this.addIntoBrotherDecls(brotherDecls, moduleDecl, curST);
                if (curST != this.adEnv.diffCallGraph().languageRootSymbolTable(TapEnv.relatedLanguage())) {
                    nextST = this.adEnv.diffCallGraph().languageRootSymbolTable(TapEnv.relatedLanguage());
                }
            }
            if (nextST != null) {
                curST = nextST;
                nextST = null;
                continue;
            }
            if (skipImportedSymbolTables) {
                for (curST = curST.basisSymbolTable(); curST != null && curST.usedModule != null; curST = curST.basisSymbolTable()) {
                }
            }
            if (curST != null || !searchInOtherRootLanguageST) continue;
            int lang = TapEnv.relatedLanguage();
            lang = lang == 4 ? 1 : 4;
            curST = this.adEnv.diffCallGraph().languageRootSymbolTable(lang);
            searchInOtherRootLanguageST = false;
        }
        return brotherDecls.tail;
    }

    private void addIntoBrotherDecls(TapList<TapPair<SymbolTable, TapList<SymbolDecl>>> brotherDecls, SymbolDecl symbolDecl, SymbolTable origDeclSymbolTable) {
        TapList<TapPair<SymbolTable, TapList<SymbolDecl>>> inBrotherDecls = brotherDecls;
        TapPair place = null;
        while (place == null && inBrotherDecls.tail != null) {
            if (((TapPair)inBrotherDecls.tail.head).first == origDeclSymbolTable) {
                place = (TapPair)inBrotherDecls.tail.head;
                continue;
            }
            inBrotherDecls = inBrotherDecls.tail;
        }
        if (place == null) {
            place = new TapPair(origDeclSymbolTable, null);
            inBrotherDecls.tail = new TapList<TapPair<SymbolTable, Object>>(place, null);
        }
        place.second = new TapList<SymbolDecl>(symbolDecl, (TapList)place.second);
    }

    private NewSymbolHolder uniqueDiffSymbolHolder(ActivityPattern pattern, TapList<TapPair<SymbolTable, TapList<SymbolDecl>>> brotherDecls, String sName, SymbolTable origUseSymbolTable, int diffSort, int diffSuffixSort, int symbolSort, Tree hintRootTree, Tree callTree, boolean searchAsFunction) {
        TapTriplet<Object, Object, Object> results = new TapTriplet<Object, Object, Object>(null, null, null);
        NewSymbolHolder diffSymbolHolder = this.getCommonNewSymbolHolder(brotherDecls, diffSort, diffSuffixSort, symbolSort, pattern, results);
        SymbolDecl mainDecl = (SymbolDecl)results.first;
        String symbolName = (String)results.second;
        String suffix = (String)results.third;
        if (diffSymbolHolder == null) {
            String diffSymbolName;
            if (symbolName == null) {
                symbolName = sName;
            }
            if (TapEnv.inputLanguage() != 100) {
                diffSymbolName = TapEnv.extendStringWithSuffix(symbolName, suffix);
            } else {
                Unit calledUnit = null;
                boolean cCalledFromFortran = false;
                if (searchAsFunction && callTree != null && this.adEnv.curSymbolTable() != null) {
                    FunctionDecl funcDecl;
                    TapList<FunctionDecl> funcDecls = this.adEnv.curSymbolTable().getFunctionDecl(symbolName, null, null, false);
                    FunctionDecl functionDecl = funcDecl = funcDecls == null ? null : (FunctionDecl)funcDecls.head;
                    if (funcDecl != null) {
                        calledUnit = funcDecl.unit();
                        if (this.adEnv.curUnit() != null && this.adEnv.curUnit().isFortran() && calledUnit != null && calledUnit.isC()) {
                            cCalledFromFortran = true;
                        }
                    }
                }
                if (searchAsFunction && callTree != null && this.adEnv.curUnit() != null && (symbolName.equals(this.adEnv.curUnit().name) && this.adEnv.curUnit().isCalledFromOtherLanguage() || this.adEnv.curUnit().isFortran() && calledUnit != null && calledUnit.language() != this.adEnv.curUnit().language())) {
                    CallArrow callArrow = (CallArrow)callTree.getAnnotation("callArrow");
                    if (this.adEnv.curUnit().isC()) {
                        symbolName = (String)this.adEnv.srcCallGraph().getMixedLanguageFunctionName((String)symbolName, (int)this.adEnv.curUnit().language(), (int)1).first;
                        if (symbolName == null) {
                            symbolName = this.adEnv.curUnit().name;
                        }
                    } else if (this.adEnv.curUnit().isFortran() && callArrow != null && callArrow.destination().isC() && !cCalledFromFortran) {
                        symbolName = (String)this.adEnv.srcCallGraph().getMixedLanguageFunctionName((String)symbolName, (int)this.adEnv.curUnit().language(), (int)4).first;
                    }
                    diffSymbolName = TapEnv.extendStringWithSuffix(symbolName, suffix);
                    if (this.adEnv.curUnit().isC()) {
                        if (this.adEnv.diffCallGraph().getOtherLangFunctionDeclFromBindC(symbolName, 1) == null) {
                            diffSymbolName = (String)this.adEnv.diffCallGraph().getMixedLanguageFunctionName((String)diffSymbolName, (int)1, (int)this.adEnv.curUnit().language()).first;
                        }
                    } else if (this.adEnv.curUnit().isFortran() && callArrow != null && callArrow.destination().isC()) {
                        diffSymbolName = cCalledFromFortran ? (String)this.adEnv.diffCallGraph().getMixedLanguageFunctionName((String)diffSymbolName, (int)1, (int)4).first : (String)this.adEnv.diffCallGraph().getMixedLanguageFunctionName((String)diffSymbolName, (int)4, (int)this.adEnv.curUnit().language()).first;
                    }
                } else {
                    diffSymbolName = TapEnv.extendStringWithSuffix(symbolName, suffix);
                }
            }
            if (mainDecl != null && mainDecl.isA(3) && pattern != null && pattern.diffP() != null && pattern.diffP().casN() != null) {
                diffSymbolName = diffSymbolName + pattern.diffP().casN();
            }
            diffSymbolHolder = new NewSymbolHolder(diffSymbolName, diffSort);
            diffSymbolHolder.isDerivationFrom(mainDecl, suffix);
        }
        TapList<TapPair<SymbolTable, TapList<SymbolDecl>>> inBrotherDecls = brotherDecls;
        while (inBrotherDecls != null) {
            TapPair oneSTSymbolDecls = (TapPair)inBrotherDecls.head;
            SymbolTable origDeclSymbolTable = (SymbolTable)oneSTSymbolDecls.first;
            TapList symbolDecls = (TapList)oneSTSymbolDecls.second;
            while (symbolDecls != null) {
                SymbolDecl oneSymbolDecl = (SymbolDecl)symbolDecls.head;
                boolean differentiatedSymbolDeclAlreadyExists = oneSymbolDecl.getDiffSymbolHolder(diffSort, pattern) == diffSymbolHolder;
                SymbolTable diffSeeingSymbolTable = origDeclSymbolTable;
                if (origDeclSymbolTable.isFormalParamsLevel() && oneSymbolDecl.isA(1) && ((VariableDecl)oneSymbolDecl).formalArgRank >= 0 && ((VariableDecl)oneSymbolDecl).formalArgRank != 999) {
                    diffSeeingSymbolTable = origUseSymbolTable;
                    while (diffSeeingSymbolTable.basisSymbolTable() != null && diffSeeingSymbolTable.unit != origDeclSymbolTable.unit) {
                        diffSeeingSymbolTable = diffSeeingSymbolTable.basisSymbolTable();
                    }
                }
                if (diffSeeingSymbolTable.unit != null && diffSeeingSymbolTable.unit.isModule() && diffSeeingSymbolTable.unit.publicSymbolTable() == diffSeeingSymbolTable) {
                    diffSymbolHolder.definitionModule = diffSeeingSymbolTable.unit;
                    if ((diffSeeingSymbolTable = diffSeeingSymbolTable.basisNotImportedSymbolTable()).isTranslationUnitSymbolTable()) {
                        diffSeeingSymbolTable = diffSeeingSymbolTable.basisSymbolTable();
                    }
                }
                if (differentiatedSymbolDeclAlreadyExists) {
                    diffSymbolHolder.accumulateTargetForSymbolDecl(oneSymbolDecl, diffSeeingSymbolTable);
                } else {
                    diffSymbolHolder.accumulateSymbolDecl(this.prepareDifferentiatedSymbolDecl(pattern, oneSymbolDecl, null, origDeclSymbolTable, diffSort, hintRootTree), diffSeeingSymbolTable);
                }
                oneSymbolDecl.setDiffSymbolHolder(diffSort, pattern, diffSymbolHolder, 5);
                oneSymbolDecl.setActive();
                if (oneSymbolDecl.isA(1) && this.isOnlyIncrementedDiff(pattern, (VariableDecl)oneSymbolDecl)) {
                    diffSymbolHolder.setUsesRefTo();
                }
                symbolDecls = symbolDecls.tail;
            }
            inBrotherDecls = inBrotherDecls.tail;
        }
        return diffSymbolHolder;
    }

    private NewSymbolHolder getCommonNewSymbolHolder(TapList<TapPair<SymbolTable, TapList<SymbolDecl>>> inBrotherDecls, int diffSort, int diffSuffixSort, int symbolSort, ActivityPattern pattern, TapTriplet<SymbolDecl, String, String> results) {
        NewSymbolHolder diffSymbolHolder = null;
        String symbolName = null;
        String suffix = this.suffixes()[diffSuffixSort][symbolSort];
        SymbolDecl mainDecl = null;
        while (inBrotherDecls != null) {
            TapPair oneSTSymbolDecls = (TapPair)inBrotherDecls.head;
            TapList symbolDecls = (TapList)oneSTSymbolDecls.second;
            while (symbolDecls != null) {
                SymbolDecl oneSymbolDecl = (SymbolDecl)symbolDecls.head;
                String oneSymbolName = oneSymbolDecl.symbol;
                if (symbolName == null) {
                    symbolName = oneSymbolName;
                } else if (!symbolName.equals(oneSymbolName)) {
                    TapEnv.toolWarning(-1, "(Differentiate variable reference): Incoherent symbols collected");
                }
                NewSymbolHolder oneDiffSymbolHolder = oneSymbolDecl.getDiffSymbolHolder(diffSort, pattern);
                if (oneDiffSymbolHolder != null) {
                    if (diffSymbolHolder == null) {
                        diffSymbolHolder = oneDiffSymbolHolder;
                    } else if (oneDiffSymbolHolder != diffSymbolHolder) {
                        diffSymbolHolder.absorb(oneDiffSymbolHolder);
                    }
                }
                if (oneSymbolDecl.isA(3)) {
                    mainDecl = oneSymbolDecl;
                } else if (oneSymbolDecl.isA(16)) {
                    if (mainDecl == null) {
                        mainDecl = oneSymbolDecl;
                    }
                } else if (oneSymbolDecl.isA(4)) {
                    mainDecl = oneSymbolDecl;
                } else if (mainDecl == null) {
                    mainDecl = oneSymbolDecl;
                }
                if (symbolSort == 0 && this.curDiffUnit() != null && this.curDiffUnit().isFortran() && !oneSymbolDecl.isA(1) && !oneSymbolDecl.isA(5)) {
                    suffix = this.suffixes()[diffSuffixSort][1];
                }
                symbolDecls = symbolDecls.tail;
            }
            inBrotherDecls = inBrotherDecls.tail;
        }
        results.first = mainDecl;
        results.second = symbolName;
        results.third = suffix;
        return diffSymbolHolder;
    }

    private SymbolDecl prepareDifferentiatedSymbolDecl(ActivityPattern pattern, SymbolDecl nonDiffSymbolDecl, NewSymbolHolder nonDiffSymbolHolder, SymbolTable declSymbolTable, int diffSort, Tree hintRootTree) {
        SymbolDecl diffSymbolDecl;
        TapList<SymbolDecl> diffDependsOn = nonDiffSymbolDecl.dependsOn;
        TapList<String> diffExtraInfo = TapList.append(nonDiffSymbolDecl.extraInfo(), null);
        TapList<String> diffAccessInfo = TapList.append(nonDiffSymbolDecl.accessInfo, null);
        if (nonDiffSymbolDecl.isA(1) || nonDiffSymbolDecl.isA(5)) {
            VariableDecl nonDiffVarDecl = (VariableDecl)nonDiffSymbolDecl;
            WrapperTypeSpec nonDiffTypeSpec = nonDiffVarDecl.type();
            Tree nonDiffTree = ILUtils.build(94, nonDiffVarDecl.symbol);
            boolean localDecl = !declSymbolTable.isFormalParamsLevel() || this.paramHasOnlyLocalDiff(pattern, nonDiffTree, (VariableDecl)nonDiffSymbolDecl);
            Tree newSHTree = null;
            if (nonDiffSymbolHolder != null) {
                newSHTree = nonDiffSymbolHolder.makeNewRef(declSymbolTable);
            }
            String nameInText = nonDiffVarDecl.symbol;
            String nameInIdent = nonDiffVarDecl.symbol;
            if (hintRootTree != null) {
                nameInText = ILUtils.buildNameInText(hintRootTree);
                nameInIdent = ILUtils.buildNameInIdent(hintRootTree);
            }
            boolean isPassiveReturnVariable = false;
            if (((VariableDecl)nonDiffSymbolDecl).isReturnVarFromFunction != null) {
                UnitDiffInfo curDiffInfo = this.callGraphDifferentiator().getUnitDiffInfo(this.adEnv.curUnit());
                boolean[] formalArgsActivity = curDiffInfo == null ? null : curDiffInfo.getUnitFormalArgsActivityS(pattern);
                isPassiveReturnVariable = formalArgsActivity != null && !formalArgsActivity[formalArgsActivity.length - 1];
            }
            WrapperTypeSpec diffTypeSpec = nonDiffTypeSpec;
            if (!isPassiveReturnVariable) {
                diffTypeSpec = nonDiffTypeSpec.checkDiffTypeSpec(declSymbolTable, this.adEnv.curSymbolTable(), this.curDiffUnitSort(), this.suffixes()[this.curDiffUnitSort()][3], localDecl, this.multiDirMode(), this.getMultiDirDimensionMax(), null, nameInText, nameInIdent, hintRootTree, newSHTree);
            }
            if (diffTypeSpec != null) {
                this.updateDiffTypeSpec(declSymbolTable, nonDiffTypeSpec.wrappedType, new TapList<Object>(null, null));
            } else {
                diffTypeSpec = nonDiffTypeSpec;
            }
            if (this.multiDirMode() && TapEnv.get().nbdirsmaxString == null) {
                NewSymbolHolder dirNumberMaxSH;
                NewSymbolHolder newSymbolHolder = dirNumberMaxSH = this.curDiffUnit() == null ? this.dirNumberMaxSymbolHolder : this.curDiffUnit().dirNumberMaxSymbolHolder;
                if (dirNumberMaxSH != null) {
                    diffDependsOn = new TapList<SymbolDecl>(dirNumberMaxSH.newVariableDecl(), diffDependsOn);
                }
            }
            if (this.isOnlyIncrementedDiff(pattern, nonDiffVarDecl) && this.adEnv.curUnit().isC()) {
                diffTypeSpec = new WrapperTypeSpec(new PointerTypeSpec(diffTypeSpec, null));
            }
            diffSymbolDecl = new VariableDecl(null, diffTypeSpec);
            if (localDecl) {
                diffExtraInfo = TapList.cleanExtraInfoValue(diffExtraInfo, "optional");
            }
        } else if (nonDiffSymbolDecl.isA(6)) {
            TapEnv.toolWarning(-1, "Not yet implemented: prepareDifferentiatedSymbolDecl() for a FUNCNAME decl");
            diffSymbolDecl = null;
        } else if (nonDiffSymbolDecl.isA(3)) {
            Unit origUnit;
            Unit unitOfFunc = ((FunctionDecl)nonDiffSymbolDecl).unit();
            Unit diffUnitOfFunc = null;
            Unit unit = origUnit = unitOfFunc.origUnit != null ? unitOfFunc.origUnit : unitOfFunc;
            if (unitOfFunc.isModule()) {
                diffUnitOfFunc = this.adEnv.getDiffOfModule(origUnit);
            } else if (diffSort == 0) {
                diffUnitOfFunc = this.adEnv.getPrimalCopyOfOrigUnit(origUnit);
            } else if (pattern != null && (pattern.unit().rank() != -1 || pattern.unit().isIntrinsic() && !pattern.unit().hasPredefinedDerivatives())) {
                diffUnitOfFunc = this.adEnv.getDiffOfUnit(origUnit, pattern, diffSort);
            }
            diffSymbolDecl = new FunctionDecl(null, diffUnitOfFunc);
        } else if (nonDiffSymbolDecl.isA(16)) {
            TapList<Object> hdInterfaceUnits;
            Unit diffUnitOfInterface;
            TapList<Object> hdFunctionDecls;
            InterfaceDecl nonDiffInterfDecl = (InterfaceDecl)nonDiffSymbolDecl;
            InterfaceDecl diffInterfDecl = new InterfaceDecl(null);
            diffInterfDecl.nameTree = ILUtils.copy(nonDiffInterfDecl.nameTree);
            diffInterfDecl.functionNames = nonDiffInterfDecl.functionNames;
            TapList<FunctionDecl> inFunctionDecls = nonDiffInterfDecl.functionDecls;
            TapList<Object> tlFunctionDecls = hdFunctionDecls = new TapList<Object>(null, null);
            while (inFunctionDecls != null) {
                Unit interfacedUnit = ((FunctionDecl)inFunctionDecls.head).unit();
                Unit primalInterfacedUnit = this.adEnv.getOrigUnitOfPrimalCopy(interfacedUnit);
                if (primalInterfacedUnit != null) {
                    interfacedUnit = primalInterfacedUnit;
                }
                TapList<Unit> diffUnits = this.callGraphDifferentiator().getUnitDiffInfo(interfacedUnit).getAllDiffs(diffSort);
                while (diffUnits != null) {
                    diffUnitOfInterface = (Unit)diffUnits.head;
                    tlFunctionDecls = tlFunctionDecls.placdl(new FunctionDecl(null, diffUnitOfInterface));
                    diffUnits = diffUnits.tail;
                }
                inFunctionDecls = inFunctionDecls.tail;
            }
            diffInterfDecl.functionDecls = hdFunctionDecls.tail;
            TapList<Unit> inInterfaceUnits = nonDiffInterfDecl.interfaceUnits();
            TapList<Object> tlInterfaceUnits = hdInterfaceUnits = new TapList<Object>(null, null);
            while (inInterfaceUnits != null) {
                Unit interfacedUnit = (Unit)inInterfaceUnits.head;
                Unit primalInterfacedUnit = this.adEnv.getOrigUnitOfPrimalCopy(interfacedUnit);
                if (primalInterfacedUnit != null) {
                    interfacedUnit = primalInterfacedUnit;
                }
                TapList<Unit> diffUnits = this.callGraphDifferentiator().getUnitDiffInfo(interfacedUnit).getAllDiffs(diffSort);
                while (diffUnits != null) {
                    diffUnitOfInterface = (Unit)diffUnits.head;
                    if (diffUnitOfInterface.rank() != -1) {
                        tlInterfaceUnits = tlInterfaceUnits.placdl(diffUnitOfInterface);
                    }
                    diffUnits = diffUnits.tail;
                }
                inInterfaceUnits = inInterfaceUnits.tail;
            }
            diffInterfDecl.setInterfaceUnits(hdInterfaceUnits.tail);
            diffInterfDecl.contents = nonDiffInterfDecl.contents;
            this.differentiateInterfaceDeclContents(pattern, diffInterfDecl, declSymbolTable);
            diffSymbolDecl = diffInterfDecl;
        } else if (nonDiffSymbolDecl.isA(4)) {
            TapEnv.toolWarning(-1, "Not yet implemented: prepareDifferentiatedSymbolDecl() for a TYPE decl");
            diffSymbolDecl = null;
        } else {
            TapEnv.toolWarning(-1, "Not yet implemented: prepareDifferentiatedSymbolDecl() for " + nonDiffSymbolDecl);
            diffSymbolDecl = null;
        }
        if (this.curDiffUnitSort() == 2) {
            diffAccessInfo = null;
            if (this.curDiffUnit() != null && this.curDiffUnit().isElemental()) {
                if (nonDiffSymbolDecl.isA(1)) {
                    if (this.adEnv.curUnit().otherReturnVar() != null && this.adEnv.curUnit().otherReturnVar().symbol.equals(nonDiffSymbolDecl.symbol)) {
                        diffExtraInfo = new TapList<String>("in", diffExtraInfo);
                        ((VariableDecl)nonDiffSymbolDecl).isReturnVar = false;
                    } else {
                        diffExtraInfo = TapList.exchangeExtraInfoValue(diffExtraInfo, "in", "out");
                    }
                }
            } else {
                diffExtraInfo = TapList.cleanExtraInfoValue(diffExtraInfo, "in");
                diffExtraInfo = TapList.cleanExtraInfoValue(diffExtraInfo, "out");
                diffExtraInfo = TapList.cleanExtraInfoValue(diffExtraInfo, "constant");
                if (nonDiffSymbolDecl.isA(1)) {
                    TapList<String> extraInfo = nonDiffSymbolDecl.extraInfo();
                    extraInfo = TapList.cleanExtraInfoValue(extraInfo, "out");
                    nonDiffSymbolDecl.setExtraInfo(extraInfo);
                }
                if (diffSymbolDecl instanceof VariableDecl) {
                    TapList<String> accessInfo = diffSymbolDecl.accessInfo;
                    diffSymbolDecl.accessInfo = accessInfo = TapList.cleanExtraInfoValue(accessInfo, "const");
                }
            }
        }
        diffExtraInfo = TapList.cleanExtraInfoValue(diffExtraInfo, "pure");
        diffExtraInfo = TapList.cleanExtraInfoValue(diffExtraInfo, "constant");
        if (diffSymbolDecl != null) {
            diffSymbolDecl.setExtraInfo(diffExtraInfo);
            diffSymbolDecl.accessInfo = diffAccessInfo;
            diffSymbolDecl.dependsOn = diffDependsOn;
        }
        return diffSymbolDecl;
    }

    private void updateDiffTypeSpec(SymbolTable diffSymbolTable, TypeSpec actualTypeSpec, TapList<TypeSpec> alreadySeenTypeSpec) {
        if (TypeSpec.isA(actualTypeSpec, 21)) {
            this.updateRecordDiffTypeSpec(diffSymbolTable, (CompositeTypeSpec)actualTypeSpec, alreadySeenTypeSpec);
        } else if (TypeSpec.isA(actualTypeSpec, 2)) {
            this.updateDiffTypeSpec(diffSymbolTable, actualTypeSpec.elementType().wrappedType, alreadySeenTypeSpec);
        } else if (TypeSpec.isA(actualTypeSpec, 5)) {
            this.updateDiffTypeSpec(diffSymbolTable, actualTypeSpec.elementType().wrappedType, alreadySeenTypeSpec);
        } else if (TypeSpec.isA(actualTypeSpec, 6) && !TapList.contains(alreadySeenTypeSpec, actualTypeSpec)) {
            alreadySeenTypeSpec.placdl(actualTypeSpec);
            this.updateDiffTypeSpec(diffSymbolTable, ((PointerTypeSpec)actualTypeSpec).destinationType.wrappedType, alreadySeenTypeSpec);
        }
    }

    private void updateRecordDiffTypeSpec(SymbolTable diffSymbolTable, CompositeTypeSpec actualTypeSpec, TapList<TypeSpec> alreadySeenTypeSpec) {
        String typeDeclName = actualTypeSpec.typeDeclName();
        String actualName = actualTypeSpec.getRenamedTypeDeclName(diffSymbolTable.origUnit());
        if (actualName != null) {
            typeDeclName = actualName;
        }
        if (typeDeclName != null) {
            TypeDecl typeDecl;
            TypeDecl mainTypeDecl = typeDecl = diffSymbolTable.getTypeDecl(typeDeclName);
            if (typeDecl != null) {
                NewSymbolHolder typeDeclSymbolHolder;
                if (typeDecl.renamedFromSymbolDecl != null) {
                    mainTypeDecl = (TypeDecl)typeDecl.renamedFromSymbolDecl;
                }
                if ((typeDeclSymbolHolder = mainTypeDecl.getDiffSymbolHolder(0, null)) != null && actualTypeSpec.diffTypeSpec != null) {
                    actualTypeSpec.diffTypeSpec.wrappedType.diffTypeDeclSymbolHolder = typeDeclSymbolHolder;
                    TapList<Object> toDefinitionST = new TapList<Object>(null, null);
                    diffSymbolTable.getDecl(typeDecl.symbol, 4, false, toDefinitionST);
                    SymbolTable definitionST = (SymbolTable)toDefinitionST.head;
                    assert (definitionST != null);
                    if (definitionST.usedModule != null) {
                        definitionST = definitionST.usedModule.publicSymbolTable();
                    }
                    if (definitionST.basisSymbolTable() != null) {
                        Unit tmpMod = this.adEnv.getDiffOfModule(definitionST.origUnit());
                        if (tmpMod != null) {
                            definitionST = tmpMod.publicSymbolTable();
                        }
                        toDefinitionST.head = null;
                        diffSymbolTable.getDecl(typeDeclName, 4, false, toDefinitionST);
                        SymbolTable importST = (SymbolTable)toDefinitionST.head;
                        if (importST != null && importST.usedModule != null) {
                            typeDeclSymbolHolder.addTypeDeclSymbolTable(importST);
                        }
                    }
                    typeDeclSymbolHolder.addTypeDeclSymbolTable(definitionST);
                    typeDeclSymbolHolder.makeNewRef(diffSymbolTable);
                }
            }
        }
        CompositeTypeSpec recordType = actualTypeSpec;
        FieldDecl[] fields = recordType.fields;
        if (recordType.isRecordType() && !TapList.contains(alreadySeenTypeSpec, actualTypeSpec) || recordType.isUnionType()) {
            for (int i = fields.length - 1; i >= 0; --i) {
                if (fields[i] == null) continue;
                alreadySeenTypeSpec.placdl(fields[i].type().wrappedType);
                this.updateDiffTypeSpec(diffSymbolTable, fields[i].type().wrappedType, alreadySeenTypeSpec);
            }
        }
    }

    private static boolean mayAddSimplyColon(WrapperTypeSpec typeSpec) {
        return typeSpec != null && (TypeSpec.isA(typeSpec, 21) || TypeSpec.isA(typeSpec, 6) && !TypeSpec.isA(((PointerTypeSpec)typeSpec.wrappedType).destinationType, 7));
    }

    protected static boolean mustAddNbDirsDim(WrapperTypeSpec typeSpec) {
        WrapperTypeSpec baseTypeSpec = typeSpec == null ? null : typeSpec.baseTypeSpec(false);
        return baseTypeSpec != null && baseTypeSpec.isDifferentiablePlainType();
    }

    private void differentiateInterfaceDeclContents(ActivityPattern pattern, InterfaceDecl interfaceDecl, SymbolTable symbolTable) {
        TapList<Tree> contents = interfaceDecl.contents;
        TapList<Tree> diffContents = null;
        while (contents != null) {
            if (((Tree)contents.head).opCode() == 130) {
                Tree[] sons = ((Tree)contents.head).children();
                Tree diffContentTree = ILUtils.build(130);
                for (Tree son : sons) {
                    Unit fDeclUnit;
                    Unit origUnit;
                    FunctionDecl fDecl;
                    if (son.opCode() != 94) continue;
                    String procName = ILUtils.getIdentString(son);
                    TapList<FunctionDecl> fDecls = symbolTable.getFunctionDecl(procName, null, null, false);
                    FunctionDecl functionDecl = fDecl = fDecls == null ? null : (FunctionDecl)fDecls.head;
                    if (fDecl == null && (origUnit = symbolTable.origUnit()) != null) {
                        fDecls = origUnit.privateSymbolTable().getFunctionDecl(procName, null, null, false);
                        fDecl = fDecls == null ? null : (FunctionDecl)fDecls.head;
                    }
                    Unit unit = fDeclUnit = fDecl == null ? null : fDecl.unit();
                    if (fDeclUnit != null && fDeclUnit.origUnit != null) {
                        fDeclUnit = fDeclUnit.origUnit;
                    }
                    if (fDecl == null || fDeclUnit == null) continue;
                    TapList<ActivityPattern> calledPatterns = BlockDifferentiator.patternsCalledByPattern(fDeclUnit, pattern);
                    while (calledPatterns != null) {
                        ActivityPattern calledPattern = (ActivityPattern)calledPatterns.head;
                        Tree diffUnitNameTree = null;
                        NewSymbolHolder diffFuncNameSH = fDecl.getDiffSymbolHolder(this.curDiffUnitSort(), calledPattern);
                        if (diffFuncNameSH != null && diffFuncNameSH.hasNewFunctionDecl()) {
                            diffUnitNameTree = diffFuncNameSH.makeNewRef(symbolTable);
                        } else {
                            this.adEnv.pushCurDiffUnit(this.adEnv.getDiffOfUnit(fDeclUnit, calledPattern, this.curDiffUnitSort()));
                            if (this.curDiffUnit() != null) {
                                diffUnitNameTree = this.findDiffFuncName(calledPattern, fDecl, this.curDiffUnitSort(), this.curDiffUnit().publicSymbolTable(), null, true, false);
                            }
                            this.adEnv.popCurDiffUnit();
                        }
                        if (diffUnitNameTree != null) {
                            diffContentTree.addChild(diffUnitNameTree, diffContentTree.length() + 1);
                        }
                        calledPatterns = calledPatterns.tail;
                    }
                }
                if (diffContentTree.length() != 0) {
                    diffContents = TapList.append(diffContents, new TapList<Tree>(diffContentTree, null));
                }
            }
            contents = contents.tail;
        }
        interfaceDecl.contents = diffContents;
    }

    protected Tree findDiffFuncName(ActivityPattern pattern, SymbolDecl symbolDecl, int diffSort, SymbolTable diffSymbolTable, Tree declTree, boolean asAFunction, boolean asAnInterface) {
        NewSymbolHolder diffSymbolHolder = symbolDecl.getDiffSymbolHolder(diffSort, pattern);
        if (diffSymbolHolder != null) {
            String oldDiffSymbolName = diffSymbolHolder.probableName;
            String name = symbolDecl.symbol;
            int originLanguage = this.adEnv.curUnit().language();
            int destinLanguage = ((FunctionDecl)symbolDecl).unit().language();
            if (originLanguage != -1 && originLanguage != destinLanguage) {
                String suffix = this.suffixes()[diffSort][3];
                if (this.adEnv.curUnit() != null && this.adEnv.curUnit().isFortran()) {
                    name = (String)this.adEnv.srcCallGraph().getMixedLanguageFunctionName((String)name, (int)destinLanguage, (int)originLanguage).first;
                }
                String diffFuncName = name + suffix;
                if (this.adEnv.curUnit() == null || this.adEnv.curUnit().isC()) {
                    diffFuncName = (String)this.adEnv.diffCallGraph().getMixedLanguageFunctionName((String)diffFuncName, (int)destinLanguage, (int)originLanguage).first;
                }
                diffSymbolHolder.probableName = diffFuncName;
            }
            Tree result = diffSymbolHolder.makeNewRef(diffSymbolTable);
            diffSymbolHolder.probableName = oldDiffSymbolName;
            return result;
        }
        return this.diffSymbolTree(pattern, ILUtils.build(94, symbolDecl.symbol), diffSymbolTable, false, asAFunction || asAnInterface, false, declTree, false, diffSort, diffSort, 0, null);
    }

    private boolean isTopDeclarationLevel(SymbolTable symbolTable, FunctionDecl functionDecl) {
        boolean ok = false;
        if (symbolTable.usedModule != null) {
            if (functionDecl.renamedFromSymbolDecl != null) {
                FunctionDecl impFuncDecl = (FunctionDecl)functionDecl.renamedFromSymbolDecl;
                ok = impFuncDecl.unit() == functionDecl.unit();
            } else {
                Unit usedModule = symbolTable.usedModule;
                Unit diffUsedModule = this.adEnv.getDiffOfModule(usedModule);
                TapList<FunctionDecl> impFuncDecls = diffUsedModule.publicSymbolTable().getTopFunctionDecl(functionDecl.symbol, null, null, false);
                FunctionDecl impFuncDecl = impFuncDecls == null ? null : (FunctionDecl)impFuncDecls.head;
                ok = impFuncDecl == functionDecl;
            }
        }
        return functionDecl != null && (symbolTable == functionDecl.definitionSymbolTable || symbolTable.usedModule != null && ok || functionDecl.definitionSymbolTable == null && symbolTable.basisSymbolTable() == null);
    }

    private boolean isOnlyIncrementedDiff(ActivityPattern pattern, VariableDecl varDecl) {
        boolean isByRefOnlyRead = false;
        if (this.curDiffUnitSort() == 2 && pattern != null && varDecl.passesByValue(pattern.unit())) {
            TapIntList zonesList = ZoneInfo.listAllZones(varDecl.zones(), true);
            SymbolTable symbolTable = null;
            if (this.adEnv.curInstruction() != null) {
                symbolTable = this.adEnv.curInstruction().block.symbolTable;
            }
            if (symbolTable == null && this.adEnv.curUnit() != null) {
                symbolTable = this.adEnv.curUnit().privateSymbolTable();
            }
            if (symbolTable == null) {
                symbolTable = this.adEnv.srcCallGraph().languageRootSymbolTable(TapEnv.relatedLanguage());
            }
            while (!isByRefOnlyRead && zonesList != null) {
                if (0 <= zonesList.head && zonesList.head < symbolTable.declaredZonesNb(0) && this.isOnlyIncrementedDiff(pattern, symbolTable.declaredZoneInfo(zonesList.head, 0))) {
                    isByRefOnlyRead = true;
                }
                zonesList = zonesList.tail;
            }
        }
        return isByRefOnlyRead;
    }

    protected boolean isOnlyIncrementedDiff(ActivityPattern pattern, ZoneInfo zoneInfo) {
        boolean isByRefOnlyRead = false;
        if (this.curDiffUnitSort() == 2 && zoneInfo != null && zoneInfo.kind() == 7 && zoneInfo.passesByValue(this.adEnv.curUnit(), this.adEnv.curUnit().language())) {
            int paramRank = zoneInfo.index;
            Unit paramUnit = zoneInfo.declarationUnit;
            if (paramUnit != null) {
                UnitDiffInfo diffInfo = this.callGraphDifferentiator().getUnitDiffInfo(paramUnit);
                boolean[] diffArgsByValueNeedOverwrite = diffInfo.getUnitDiffArgsByValueNeedOverwriteInfoS(pattern);
                boolean[] diffArgsByValueNeedOnlyIncrement = diffInfo.getUnitDiffArgsByValueNeedOnlyIncrementInfoS(pattern);
                if (diffArgsByValueNeedOverwrite != null && diffArgsByValueNeedOverwrite[paramRank] && diffArgsByValueNeedOnlyIncrement[paramRank]) {
                    isByRefOnlyRead = true;
                }
            }
        }
        return isByRefOnlyRead;
    }

    protected boolean paramHasOnlyLocalDiff(ActivityPattern pattern, Tree varBaseTree, VariableDecl variableDecl) {
        boolean result = false;
        if (this.adEnv.curUnit() != null && this.adEnv.curUnit().functionTypeSpec() != null && this.adEnv.curUnit().functionTypeSpec().argumentsTypes != null) {
            int nbArgs = this.adEnv.curUnit().functionTypeSpec().argumentsTypes.length;
            Unit origUnit = this.adEnv.curUnit();
            if (this.adEnv.curUnit().isInterface()) {
                origUnit = this.adEnv.srcCallGraph().getUnit(this.adEnv.curUnit().name, this.adEnv.curUnit().functionTypeSpec());
            }
            if (origUnit == null) {
                origUnit = this.adEnv.curUnit();
            }
            if (origUnit.publicSymbolTable() != null) {
                UnitDiffInfo diffInfo = this.callGraphDifferentiator().getUnitDiffInfo(origUnit);
                VariableDecl varDecl = variableDecl != null ? variableDecl : origUnit.publicSymbolTable().getVariableOrConstantDecl(ILUtils.baseName(varBaseTree));
                if (varDecl != null) {
                    int rank = varDecl.formalArgRank;
                    if (varDecl.formalArgRankInOrigUnit != -9) {
                        rank = varDecl.formalArgRankInOrigUnit;
                    }
                    if (1 <= rank && rank <= nbArgs) {
                        boolean[] formalArgsActivity = diffInfo.getUnitFormalArgsActivityS(pattern);
                        result = formalArgsActivity != null && !formalArgsActivity[rank - 1];
                    }
                }
            }
        }
        return result;
    }

    protected boolean isCurFunctionName(String varName) {
        return this.adEnv.curUnit().isFortran() && this.diffFunctionIsFunction(this.adEnv.curUnit()) && varName.equals(this.adEnv.curUnit().name);
    }

    protected boolean diffFunctionIsFunction(Unit unit) {
        return !this.multiDirMode() && !unit.usedAsElementalResult;
    }

    private void dumpSiblingDecls(String symbolName, TapList<TapPair<SymbolTable, TapList<SymbolDecl>>> brotherDecls) {
        TapEnv.printOnTrace(" DIFF SYMBOLNAME:" + symbolName + " => sibling decls:");
        while (brotherDecls != null) {
            TapPair oneb = (TapPair)brotherDecls.head;
            TapEnv.printOnTrace("     " + ((SymbolTable)oneb.first).addressChain() + " : " + oneb.second);
            brotherDecls = brotherDecls.tail;
        }
    }
}

