/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.frontend;

import java.io.BufferedReader;
import java.io.IOException;

final class LibReader {
    protected static final int COLON = 1;
    protected static final int OPENPARENTH = 2;
    protected static final int COMMA = 3;
    protected static final int CLOSEPARENTH = 4;
    protected static final int TOKEN = 5;
    protected static final int OPENBRACKET = 6;
    protected static final int SLASH = 7;
    protected final BufferedReader reader;
    protected String sval;
    private boolean hasLineCommentChar;
    private char lineCommentChar = (char)35;
    private int status = -1;

    protected LibReader(BufferedReader reader) {
        this.reader = reader;
    }

    protected void setLineCommentChar(char lineCommentChar) {
        this.hasLineCommentChar = true;
        this.lineCommentChar = lineCommentChar;
    }

    private int popNextToken() throws IOException {
        int c = this.reader.read();
        char nextChar = (char)c;
        StringBuilder sbuf = new StringBuilder(256);
        boolean inComment = false;
        while (inComment || this.hasLineCommentChar && nextChar == this.lineCommentChar || nextChar == ' ' || nextChar == '\t' || nextChar == '\n' || nextChar == '\r') {
            if (this.hasLineCommentChar && nextChar == this.lineCommentChar) {
                inComment = true;
            } else if (nextChar == '\n' || nextChar == '\r') {
                inComment = false;
            }
            c = this.reader.read();
            nextChar = (char)c;
        }
        switch (nextChar) {
            case ':': {
                this.sval = ":";
                return 1;
            }
            case '(': {
                this.sval = "(";
                return 2;
            }
            case ',': {
                this.sval = ",";
                return 3;
            }
            case ')': {
                this.sval = ")";
                return 4;
            }
            case '[': {
                this.sval = "[";
                return 6;
            }
            case '/': {
                this.sval = "/";
                return 7;
            }
        }
        if (c == -1) {
            this.sval = "";
            return -1;
        }
        sbuf.setLength(0);
        sbuf.append(nextChar);
        this.reader.mark(2);
        c = this.reader.read();
        nextChar = (char)c;
        while (!(c == -1 || nextChar == ' ' || nextChar == '(' || nextChar == ')' || nextChar == ',' || nextChar == ':' || nextChar == '[' || nextChar == '/' || nextChar == '\t' || nextChar == '\n' || nextChar == '\r' || this.hasLineCommentChar && nextChar == this.lineCommentChar)) {
            sbuf.append(nextChar);
            this.reader.mark(2);
            c = this.reader.read();
            nextChar = (char)c;
        }
        this.reader.reset();
        this.sval = sbuf.toString();
        return 5;
    }

    protected int seeNextToken() throws IOException {
        if (this.status == -1) {
            this.status = this.popNextToken();
        }
        return this.status;
    }

    protected int readNextToken() throws IOException {
        if (this.status != -1) {
            int result = this.status;
            this.status = -1;
            return result;
        }
        return this.popNextToken();
    }

    protected void eliminateSpaces() throws IOException {
        this.reader.mark(2);
        char nextChar = (char)this.reader.read();
        boolean inComment = false;
        while (inComment || this.hasLineCommentChar && nextChar == this.lineCommentChar || nextChar == ' ' || nextChar == '\t' || nextChar == '\n' || nextChar == '\r') {
            if (this.hasLineCommentChar && nextChar == this.lineCommentChar) {
                inComment = true;
            } else if (nextChar == '\n' || nextChar == '\r') {
                inComment = false;
            }
            this.reader.mark(2);
            nextChar = (char)this.reader.read();
        }
        this.reader.reset();
    }
}

