/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.frontend;

import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapEnvForThread;
import fr.inria.tapenade.representation.TapList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;

public final class Parser {
    private Parser() {
    }

    public static synchronized BufferedReader parse(String[] cppCommands, String[] commands, String file) throws IOException {
        File inputFile = new File(file);
        if (!inputFile.exists()) {
            throw new FileNotFoundException((TapEnv.forServlet ? inputFile.getName() : file) + " (No such file or directory)");
        }
        TapEnv.printlnOnTrace(10, "@@ Parsing " + file);
        TapEnv.setCurrentParsedFile(file);
        Runtime rt = Runtime.getRuntime();
        TapEnvForThread tapEnvForThread = TapEnv.get();
        if (tapEnvForThread.traceParser) {
            TapEnv.printOnTrace("PARSING COMMAND=");
            for (String command : commands) {
                TapEnv.printOnTrace(" " + command);
            }
            TapEnv.printlnOnTrace();
        }
        if (cppCommands != null) {
            if (tapEnvForThread.traceParser) {
                TapEnv.printOnTrace("CPP PREPROCESSING COMMAND=");
                for (String cppCommand : cppCommands) {
                    TapEnv.printOnTrace(" " + cppCommand);
                }
                TapEnv.printlnOnTrace();
            }
            try {
                Process cpp = rt.exec(cppCommands);
                BufferedReader errorCpp = new BufferedReader(new InputStreamReader(cpp.getErrorStream()));
                new Thread(() -> {
                    try {
                        String line;
                        while ((line = errorCpp.readLine()) != null) {
                            tapEnvForThread.parserError(line);
                            tapEnvForThread.flushOutputStream();
                        }
                    }
                    catch (IOException exc) {
                        tapEnvForThread.parserError("Parsing interrupted " + file);
                    }
                }).start();
                try {
                    int returnValue = cpp.waitFor();
                    if (returnValue != 0) {
                        TapEnv.parserError(cppCommands[0] + " preprocessor error, return value " + returnValue);
                    }
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
                cpp.getOutputStream().close();
            }
            catch (IOException e) {
                TapEnv.parserError(cppCommands[0] + " command not found");
            }
            if (TapEnv.relatedLanguageIsC()) {
                int indexOfCppFileName = 4;
                File cppFile = new File(commands[indexOfCppFileName]);
                if (!cppFile.exists()) {
                    TapEnv.parserError(cppCommands[0] + " preprocessor error, file not found: " + cppFile);
                    commands[indexOfCppFileName] = file;
                }
            } else if (TapEnv.relatedLanguageIsCPLUSPLUS()) {
                File jsonFile = new File("o.json");
                File cppParserFile = new File(commands[0]);
                if (!cppParserFile.exists()) {
                    TapEnv.toolError("No parser for C++");
                    return null;
                }
                if (!jsonFile.exists()) {
                    TapEnv.parserError(cppCommands[0] + " parser warning, compile_commands.json not found");
                } else {
                    try (BufferedReader input = new BufferedReader(new FileReader(jsonFile));){
                        Parser.modifyJsonFile(cppCommands, input);
                    }
                }
            }
        }
        Process p = rt.exec(commands);
        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        BufferedReader errorReader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        new Thread(() -> {
            try {
                String line;
                while ((line = errorReader.readLine()) != null) {
                    tapEnvForThread.parserError(line);
                    tapEnvForThread.flushOutputStream();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }).start();
        new Thread(() -> {
            try {
                p.waitFor();
            }
            catch (InterruptedException e) {
                tapEnvForThread.parserError("Parsing interrupted " + file);
                Thread.currentThread().interrupt();
            }
        }).start();
        p.getOutputStream().close();
        return reader;
    }

    private static void modifyJsonFile(String[] cppCommands, BufferedReader input) {
        File compileJsonFile = new File("compile_commands.json");
        if (compileJsonFile.exists() && !compileJsonFile.renameTo(new File("compile_commands.json~"))) {
            TapEnv.parserError("Parsing interrupted compile_commands.json~");
        }
        try (FileWriter toFile = new FileWriter("compile_commands.json");){
            int nbLine = cppCommands.length - 6;
            String firstLine = input.readLine();
            if (nbLine == 1) {
                firstLine = firstLine.replace("{", "[{");
                firstLine = firstLine.replace("},", "}]");
                toFile.write(firstLine);
            } else if (nbLine == 2) {
                firstLine = firstLine.replace("{", "[{");
                toFile.write(firstLine);
                toFile.write(System.lineSeparator());
                String lastLine = input.readLine();
                lastLine = lastLine.replace("},", "}]");
                toFile.write(lastLine);
            } else {
                firstLine = firstLine.replace("{", "[{");
                toFile.write(firstLine);
                toFile.write(System.lineSeparator());
                for (int i = 2; i < nbLine; ++i) {
                    String line = input.readLine();
                    toFile.write(line);
                    toFile.write(System.lineSeparator());
                }
                String lastLine = input.readLine();
                lastLine = lastLine.replace("},", "}]");
                toFile.write(lastLine);
            }
            toFile.write(System.lineSeparator());
        }
        catch (IOException e) {
            TapEnv.parserError("Parsing interrupted compile_commands.json");
        }
    }

    public static void cleanJsonFiles(TapList<String> fileNames) {
        File jsonFile = new File("o.json");
        if (jsonFile.exists() && !jsonFile.delete()) {
            TapEnv.parserError("Cannot remove o.json");
        }
        if ((jsonFile = new File("compile_commands.json")).exists() && !jsonFile.delete()) {
            TapEnv.parserError("Cannot remove compile_commands.json");
        }
        if ((jsonFile = new File("compile_commands.json~")).exists() && !jsonFile.renameTo(new File("compile_commands.json"))) {
            TapEnv.parserError("Cannot rename compile_commands.json");
        }
        while (fileNames != null) {
            String fileName = TapEnv.stripLanguageExtension(TapEnv.stripPath((String)fileNames.head)) + ".o";
            jsonFile = new File(fileName);
            if (jsonFile.exists() && !jsonFile.delete()) {
                TapEnv.parserError("Cannot remove " + fileName);
            }
            fileNames = fileNames.tail;
        }
    }
}

