/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.frontend;

import fr.inria.tapenade.frontend.LibReader;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.utils.ILLangOps;
import fr.inria.tapenade.utils.Operator;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.Tree;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class TreeProtocol {
    private final LibReader libReader;
    private final int maxILCode = ILLangOps.opsLength() - 1;
    private boolean traceOn;
    private Operator topOperator;
    private int position;
    private TapList<Operator> debugStackOps;
    private TapIntList debugStackRks;
    private TapList<TreeReader> treeReaders;

    public void setTraceOn(boolean traceOn) {
        this.traceOn = traceOn;
    }

    public TreeProtocol(InputStream is) {
        this.libReader = new LibReader(new BufferedReader(new InputStreamReader(is)));
    }

    public TreeProtocol(BufferedReader reader) {
        this.libReader = new LibReader(reader);
    }

    public TreeProtocol(LibReader reader) {
        this.libReader = reader;
    }

    public int position() {
        return this.position;
    }

    public void setPosition(int pos) {
        this.position = pos;
    }

    public Operator seeOperator() throws IOException {
        if (this.topOperator == null) {
            this.topOperator = this.popOperator();
        }
        return this.topOperator;
    }

    public Operator readOperator() throws IOException {
        ++this.position;
        Operator oper = this.topOperator;
        if (oper != null) {
            this.topOperator = null;
        } else {
            oper = this.popOperator();
        }
        if (this.treeReaders != null) {
            TapList<TreeReader> inTreeReaders = this.treeReaders;
            while (inTreeReaders != null) {
                ((TreeReader)inTreeReaders.head).acceptReadOperator(oper, this.position);
                inTreeReaders = inTreeReaders.tail;
            }
        }
        return oper;
    }

    private Operator popOperator() throws IOException {
        Operator operator;
        String line = this.libReader.reader.readLine();
        while (line != null && line.isEmpty()) {
            line = this.libReader.reader.readLine();
        }
        if (line == null) {
            throw new IOException("Parsing error");
        }
        try {
            int code = Integer.parseInt(line);
            operator = code <= 0 || code > this.maxILCode ? null : ILLangOps.ops(code);
        }
        catch (NumberFormatException e) {
            if ("modifiedTypeName".equals(line)) {
                line = "modifiedTypeSpec";
            }
            operator = ILUtils.operator(line);
        }
        if (this.traceOn) {
            TapEnv.printlnOnTrace();
            for (int trd = this.treeReaderDepth(); trd > 0; --trd) {
                TapEnv.printOnTrace(" |");
            }
            TapEnv.printOnTrace(operator == null ? "null" : (operator.code == 64 ? "End_of_List" : operator.code + ":" + operator.name + (operator.arity >= 0 ? "[" + operator.arity + "]" : (operator.arity == -1 ? "[*]" : ""))));
        }
        if (operator == null) {
            throw new IOException("Not a tree operator: " + line);
        }
        if (operator.code == 146) {
            String message = this.readString();
            throw new IOException(message);
        }
        return operator;
    }

    private int readInt() throws IOException {
        int number;
        try {
            number = Integer.parseInt(this.libReader.reader.readLine());
        }
        catch (NumberFormatException e) {
            TapEnv.printlnOnTrace(" Problem with long integers in IL");
            number = -9999;
        }
        if (this.traceOn) {
            TapEnv.printOnTrace("->" + number);
        }
        if (this.treeReaders != null) {
            TapList<TreeReader> inTreeReaders = this.treeReaders;
            while (inTreeReaders != null) {
                ((TreeReader)inTreeReaders.head).acceptReadInt(number);
                inTreeReaders = inTreeReaders.tail;
            }
        }
        return number;
    }

    public String readString() throws IOException {
        String str = this.libReader.reader.readLine();
        if (this.traceOn) {
            TapEnv.printOnTrace("->" + str);
        }
        if (this.treeReaders != null) {
            TapList<TreeReader> inTreeReaders = this.treeReaders;
            while (inTreeReaders != null) {
                ((TreeReader)inTreeReaders.head).acceptReadString(str);
                inTreeReaders = inTreeReaders.tail;
            }
        }
        return str;
    }

    public Tree readTree() throws IOException {
        int nextOperPosition = this.position + 1;
        Tree resultTree = this.readTreeRec();
        ILUtils.setPosition(resultTree, nextOperPosition);
        return resultTree;
    }

    private Tree readTreeRec() throws IOException {
        TapList<String> commentNames = null;
        TapList<Tree> commentTrees = null;
        while (this.seeOperator().code == 6) {
            this.readOperator();
            commentNames = new TapList<String>(this.readString(), commentNames);
            commentTrees = new TapList<Tree>(this.readTree(), commentTrees);
        }
        Operator oper = this.seeOperator();
        if (oper.code == 64) {
            throw new IOException("Parsing error");
        }
        if (oper.code == 65) {
            TapEnv.printlnOnTrace("End: operator = endOfProtocol");
            oper = this.readOperator();
        } else {
            oper = this.readOperator();
        }
        Tree resultTree = oper.tree();
        while (commentNames != null) {
            resultTree.setAnnotation((String)commentNames.head, commentTrees.head);
            commentNames = commentNames.tail;
            commentTrees = commentTrees.tail;
        }
        if (oper.code != 65) {
            switch (oper.arity) {
                case -2: {
                    resultTree.setValue(this.readInt());
                    break;
                }
                case -3: {
                    resultTree.setValue(this.readString());
                    break;
                }
                case -1: {
                    int i = 1;
                    while (this.seeOperator().code != 64) {
                        resultTree.addChild(this.readTreeRec(), i);
                        ++i;
                    }
                    this.readOperator();
                    break;
                }
                default: {
                    for (int i = 1; i <= oper.arity; ++i) {
                        resultTree.setChild(this.readTreeRec(), i);
                    }
                }
            }
        }
        return resultTree;
    }

    public void pushTreeReader() {
        this.treeReaders = new TapList<TreeReader>(new TreeReader(), this.treeReaders);
    }

    public Tree popTreeReader() {
        Tree finalTree = ((TreeReader)this.treeReaders.head).getFinalTree();
        this.treeReaders = this.treeReaders.tail;
        return finalTree;
    }

    private int treeReaderDepth() {
        if (this.treeReaders == null) {
            return 0;
        }
        while (this.treeReaders.tail != null) {
            this.treeReaders = this.treeReaders.tail;
        }
        TapList treeReaderLevels = ((TreeReader)this.treeReaders.head).treeReaderLevels;
        int depth = 0;
        while (treeReaderLevels != null) {
            if (((TreeReaderLevel)treeReaderLevels.head).tree != null && !((TreeReaderLevel)treeReaderLevels.head).isComplete()) {
                ++depth;
            }
            treeReaderLevels = treeReaderLevels.tail;
        }
        return depth;
    }

    public Tree readPrefixTree() throws IOException {
        int nextToken = this.libReader.readNextToken();
        String nextValue = this.libReader.sval;
        if ("modifiedTypeName".equals(nextValue)) {
            nextValue = "modifiedTypeSpec";
        }
        Operator oper = ILUtils.operator(nextValue);
        assert (oper != null);
        if (this.traceOn) {
            TapEnv.println();
            TapEnv.printOnTrace(oper.code + 58 + oper.name + (oper.arity >= 0 ? Integer.valueOf(91 + oper.arity + 93) : (oper.arity == -1 ? "[*]" : "")));
        }
        int arity = oper.arity;
        Tree resultTree = oper.tree();
        if (arity >= -1) {
            this.libReader.readNextToken();
            nextToken = this.libReader.seeNextToken();
            int i = 0;
            while (nextToken != 4) {
                while (nextToken == 3) {
                    this.libReader.readNextToken();
                    nextToken = this.libReader.seeNextToken();
                }
                if (nextToken == 4) continue;
                ++i;
                if (arity >= 0) {
                    resultTree.setChild(this.readPrefixTree(), i);
                } else {
                    resultTree.addChild(this.readPrefixTree(), i);
                }
                nextToken = this.libReader.seeNextToken();
            }
            this.libReader.readNextToken();
        } else {
            this.libReader.readNextToken();
            nextValue = this.libReader.sval;
            if (nextToken == 1) {
                this.libReader.readNextToken();
                nextValue = this.libReader.sval;
            }
            if (this.traceOn) {
                TapEnv.printOnTrace("->" + nextValue);
            }
            if (arity == -2) {
                resultTree.setValue(Integer.parseInt(nextValue));
            } else {
                resultTree.setValue(nextValue);
            }
        }
        this.libReader.eliminateSpaces();
        return resultTree;
    }

    private static class TreeReader {
        private TapList<TreeReaderLevel> treeReaderLevels = new TapList<TreeReaderLevel>(new TreeReaderLevel(null, "finalTree", 0), null);

        private TreeReader() {
        }

        private Tree getFinalTree() {
            return ((TreeReaderLevel)this.treeReaderLevels.head).tree;
        }

        private void pushReaderLevel(TreeReaderLevel newLevel) {
            this.treeReaderLevels = new TapList<TreeReaderLevel>(newLevel, this.treeReaderLevels);
        }

        private void acceptReadOperator(Operator oper, int position) {
            if (oper.code == 6) {
                this.pushReaderLevel(new TreeReaderLevel(null, null, 0));
            } else if (oper.code == 64) {
                ((TreeReaderLevel)this.treeReaderLevels.head).freeRank = -1;
                this.foldTreeReaderLevels();
            } else {
                Tree newTree = oper.tree();
                while (this.treeReaderLevels != null && ((TreeReaderLevel)this.treeReaderLevels.head).annot != null && ((TreeReaderLevel)this.treeReaderLevels.head).isComplete()) {
                    newTree.setAnnotation(((TreeReaderLevel)this.treeReaderLevels.head).annot, ((TreeReaderLevel)this.treeReaderLevels.head).tree);
                    this.treeReaderLevels = this.treeReaderLevels.tail;
                }
                int newFreeRank = 0;
                if (oper.arity == 0) {
                    newFreeRank = -1;
                }
                if (this.treeReaderLevels != null && ((TreeReaderLevel)this.treeReaderLevels.head).tree == null) {
                    ((TreeReaderLevel)this.treeReaderLevels.head).tree = newTree;
                    ((TreeReaderLevel)this.treeReaderLevels.head).freeRank = newFreeRank;
                    ILUtils.setPosition(newTree, position);
                } else {
                    this.pushReaderLevel(new TreeReaderLevel(newTree, null, newFreeRank));
                    if (newFreeRank == -1) {
                        this.foldTreeReaderLevels();
                    }
                }
            }
        }

        private void acceptReadString(String text) {
            TreeReaderLevel firstLevel = (TreeReaderLevel)this.treeReaderLevels.head;
            if (firstLevel.tree == null) {
                firstLevel.annot = text;
            } else {
                firstLevel.tree.setValue(text);
                firstLevel.freeRank = -1;
                this.foldTreeReaderLevels();
            }
        }

        private void acceptReadInt(int number) {
            TreeReaderLevel firstLevel = (TreeReaderLevel)this.treeReaderLevels.head;
            firstLevel.tree.setValue(number);
            firstLevel.freeRank = -1;
            this.foldTreeReaderLevels();
        }

        private void foldTreeReaderLevels() {
            while (this.treeReaderLevels != null && this.treeReaderLevels.tail != null && ((TreeReaderLevel)this.treeReaderLevels.head).annot == null && ((TreeReaderLevel)this.treeReaderLevels.head).isComplete()) {
                Tree newSon = ((TreeReaderLevel)this.treeReaderLevels.head).tree;
                this.treeReaderLevels = this.treeReaderLevels.tail;
                if (((TreeReaderLevel)this.treeReaderLevels.head).tree.isFixed()) {
                    ((TreeReaderLevel)this.treeReaderLevels.head).tree.setChild(newSon, 1 + ((TreeReaderLevel)this.treeReaderLevels.head).freeRank);
                } else {
                    ((TreeReaderLevel)this.treeReaderLevels.head).tree.addChild(newSon, 1 + ((TreeReaderLevel)this.treeReaderLevels.head).freeRank);
                }
                ((TreeReaderLevel)this.treeReaderLevels.head).freeRank++;
            }
        }
    }

    private static class TreeReaderLevel {
        private Tree tree;
        private String annot;
        private int freeRank;

        private TreeReaderLevel(Tree tree, String annot, int freeRank) {
            this.tree = tree;
            this.annot = annot;
            this.freeRank = freeRank;
        }

        private boolean isComplete() {
            if (this.freeRank == -1) {
                return true;
            }
            if (this.tree == null) {
                return false;
            }
            return this.tree.isFixed() && this.freeRank >= this.tree.operator().arity;
        }

        public String toString() {
            return "(" + this.annot + "|" + this.freeRank + "|" + this.tree + ')';
        }
    }
}

