/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.graphicsutils;

import fr.inria.tapenade.graphicsutils.Node;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.EntryBlock;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.LoopBlock;
import fr.inria.tapenade.representation.MemoryMap;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class BlockNode
extends Node {
    private static final Logger LOGGER = LogManager.getLogger();
    private String[] lines;
    protected Color bg = new Color(255, 230, 170);
    protected Color fg = Color.black;
    protected boolean doubleBorder;
    private String[] decls;
    private static final Color declFg = Color.blue;
    protected boolean declsAfter;

    protected BlockNode(Block block, ByteArrayOutputStream byteStream, boolean withDecls) {
        TapList<String> listTexts = null;
        TapList<Instruction> instructions = block.instructions;
        while (instructions != null) {
            listTexts = new TapList<String>(ILUtils.toString(((Instruction)instructions.head).tree), listTexts);
            instructions = instructions.tail;
        }
        this.lines = new String[TapList.length(listTexts)];
        for (int i = this.lines.length - 1; i >= 0; --i) {
            this.lines[i] = (String)listTexts.head;
            listTexts = listTexts.tail;
        }
        if (withDecls) {
            String text;
            TapList<SymbolDecl> symbolDecls = block.symbolTable.getAllTopSymbolDecls();
            listTexts = null;
            while (symbolDecls != null) {
                try {
                    byteStream.reset();
                    TapEnv.print("  ");
                    ((SymbolDecl)symbolDecls.head).dump(0);
                    text = byteStream.toString();
                }
                catch (IOException e) {
                    LOGGER.error("OutputStream for node labels broken ", (Throwable)e);
                    text = "SymbolDecl";
                }
                listTexts = new TapList<String>(text, listTexts);
                symbolDecls = symbolDecls.tail;
            }
            if (block instanceof EntryBlock) {
                MemoryMap memoryMap = block.unit().declaredMemoryMap;
                TapList inMaps = memoryMap.maps.tail;
                while (inMaps != null) {
                    try {
                        byteStream.reset();
                        TapEnv.print("  ");
                        MemoryMap.dumpMap((TapList)inMaps.head);
                        text = byteStream.toString();
                    }
                    catch (IOException e) {
                        LOGGER.error("OutputStream for node labels broken ", (Throwable)e);
                        text = "map";
                    }
                    listTexts = new TapList<String>(text, listTexts);
                    inMaps = inMaps.tail;
                }
            }
            this.decls = new String[TapList.length(listTexts)];
            for (int i = this.decls.length - 1; i >= 0; --i) {
                this.decls[i] = (String)listTexts.head;
                listTexts = listTexts.tail;
            }
        }
        int level = 0;
        for (LoopBlock enclosing = block.enclosingLoop(); enclosing != null; enclosing = enclosing.enclosingLoop()) {
            ++level;
        }
        if (level > 0) {
            this.bg = new Color(255, 230 - level * 30, 170 - level * 30);
        }
    }

    @Override
    protected void draw(Graphics graphics) {
        int line1y;
        int i;
        FontMetrics fm = graphics.getFontMetrics();
        int dh = fm.getHeight() + 1;
        int w = 0;
        int h = 1;
        double epsilon = 1.0E-8;
        if (Math.abs(this.w2 + 1.0) < epsilon || Math.abs(this.h2 + 1.0) < epsilon) {
            int nw;
            if (this.lines != null) {
                h += dh * this.lines.length;
                for (i = this.lines.length - 1; i >= 0; --i) {
                    nw = fm.stringWidth(this.lines[i]);
                    if (nw <= w) continue;
                    w = nw;
                }
            }
            if (this.decls != null) {
                h += dh * this.decls.length;
                for (i = this.decls.length - 1; i >= 0; --i) {
                    nw = fm.stringWidth(this.decls[i]);
                    if (nw <= w) continue;
                    w = nw;
                }
            }
            this.w2 = (double)(w += 10) / 2.0;
            this.h2 = (double)h / 2.0;
        }
        graphics.setColor(this.bg);
        if (this.doubleBorder) {
            graphics.fillRect((int)(this.x - this.w2 - 3.0), (int)(this.y - this.h2 - 3.0), (int)(2.0 * this.w2 + 6.0), (int)(2.0 * this.h2 + 6.0));
            graphics.setColor(this.fg);
            graphics.drawRect((int)(this.x - this.w2 - 3.0), (int)(this.y - this.h2 - 3.0), (int)(2.0 * this.w2 + 6.0), (int)(2.0 * this.h2 + 6.0));
        } else {
            graphics.fillRect((int)(this.x - this.w2), (int)(this.y - this.h2), (int)(2.0 * this.w2), (int)(2.0 * this.h2));
            graphics.setColor(this.fg);
        }
        graphics.drawRect((int)(this.x - this.w2), (int)(this.y - this.h2), (int)(2.0 * this.w2), (int)(2.0 * this.h2));
        int tx = (int)(this.x - this.w2 + 5.0);
        int thisLine1y = line1y = (int)(this.y + 0.5 - this.h2) + fm.getAscent();
        if (this.decls != null && !this.declsAfter) {
            thisLine1y += this.decls.length * dh;
        }
        assert (this.lines != null);
        for (i = this.lines.length - 1; i >= 0; --i) {
            graphics.drawString(this.lines[i], tx, thisLine1y + i * dh);
        }
        if (this.decls != null) {
            graphics.setColor(this.fg);
            thisLine1y = (int)(this.y - this.h2) + (this.declsAfter ? this.lines.length : this.decls.length) * dh;
            graphics.drawLine((int)(this.x - this.w2), thisLine1y, (int)(this.x + this.w2), thisLine1y);
            graphics.setColor(declFg);
            thisLine1y = line1y;
            if (this.declsAfter) {
                thisLine1y += this.lines.length * dh;
            }
            for (i = this.decls.length - 1; i >= 0; --i) {
                graphics.drawString(this.decls[i], tx, thisLine1y + i * dh);
            }
        }
    }
}

