/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.graphicsutils;

import fr.inria.tapenade.graphicsutils.Node;
import java.awt.Color;
import java.awt.Graphics;

class Edge {
    protected Node from;
    protected Node to;
    protected int[] x3 = new int[3];
    protected int[] y3 = new int[3];
    protected int idealX;
    protected int idealY;

    protected Edge() {
    }

    protected void draw(Graphics graphics) {
        double x1 = this.from.x;
        double y1 = this.from.y + this.from.h2;
        double x2 = this.to.x;
        double y2 = this.to.y - this.to.h2;
        graphics.setColor(Color.black);
        graphics.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
        double len = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        double dx = (x1 - x2) / len;
        double dy = (y1 - y2) / len;
        this.x3[0] = (int)((x1 + x2) / 2.0);
        this.y3[0] = (int)((y1 + y2) / 2.0);
        this.x3[1] = (int)((double)this.x3[0] + 12.0 * dx - 4.0 * dy);
        this.y3[1] = (int)((double)this.y3[0] + 12.0 * dy + 4.0 * dx);
        this.x3[2] = (int)((double)this.x3[0] + 12.0 * dx + 4.0 * dy);
        this.y3[2] = (int)((double)this.y3[0] + 12.0 * dy - 4.0 * dx);
        graphics.fillPolygon(this.x3, this.y3, 3);
    }
}

