/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.gui;

import fr.inria.tapenade.gui.TapenadeFrame;
import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

class ControlPanel
extends JPanel {
    private static final long serialVersionUID = 44937299994054L;
    private JCheckBox htmlBox;
    private JButton changeModeButton;
    private JButton differentiateButton;
    private boolean advancedMode;

    protected ControlPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setOpaque(false);
        this.setLayout(new FlowLayout(2));
        this.add(this.getHtmlCheckBox());
        this.add(this.getDifferentiateButton());
        this.add(this.getChangeModeButton());
    }

    protected JCheckBox getHtmlCheckBox() {
        if (this.htmlBox == null) {
            this.htmlBox = new JCheckBox();
            this.htmlBox.setText("HTML view");
            TapenadeFrame.setFont(this.htmlBox);
            TapenadeFrame.setBackground(this.htmlBox);
            this.htmlBox.setSelected(true);
        }
        return this.htmlBox;
    }

    protected JButton getDifferentiateButton() {
        if (this.differentiateButton == null) {
            this.differentiateButton = new JButton();
            this.differentiateButton.setText("Differentiate");
            TapenadeFrame.setFont(this.differentiateButton);
            this.differentiateButton.setOpaque(false);
            this.differentiateButton.addActionListener(e -> TapenadeFrame.getInstance().runTapenade());
        }
        return this.differentiateButton;
    }

    private JButton getChangeModeButton() {
        if (this.changeModeButton == null) {
            this.changeModeButton = new JButton();
            this.changeModeButton.setText("Advanced Mode");
            TapenadeFrame.setFont(this.changeModeButton);
            this.changeModeButton.setOpaque(false);
            this.changeModeButton.addActionListener(e -> {
                if (this.advancedMode) {
                    this.advancedMode = false;
                    this.changeModeButton.setText("Advanced Mode");
                } else {
                    this.advancedMode = true;
                    this.changeModeButton.setText("Standard Mode");
                }
                TapenadeFrame.getInstance().changeMode(this.advancedMode);
            });
        }
        return this.changeModeButton;
    }
}

