/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.gui;

import fr.inria.tapenade.gui.TapenadeFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

final class ExtFilesPanel
extends JPanel {
    private static final long serialVersionUID = 4448889994054L;
    protected static final int EXT = 0;
    protected static final int EXTAD = 1;
    private final int mode;
    private JList<File> filesList;
    private JScrollPane scrollFiles;
    private JButton addButton;
    private JButton removeButton;
    private JCheckBox noLib;
    private JSplitPane splitPanel;

    protected ExtFilesPanel(int mode) {
        this.mode = mode;
        this.setPreferredSize(new Dimension(230, 120));
        this.initialize();
    }

    private void initialize() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        String title = this.mode == 0 ? "Ext Files :" : "Ext AD Files :";
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints constraintsSplitPanel = new GridBagConstraints();
        constraintsSplitPanel.gridx = 0;
        constraintsSplitPanel.gridy = 0;
        constraintsSplitPanel.gridheight = 4;
        constraintsSplitPanel.fill = 1;
        constraintsSplitPanel.weightx = 1.0;
        constraintsSplitPanel.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.getSplitPanel(), constraintsSplitPanel);
    }

    protected JList<File> getFilesList() {
        if (this.filesList == null) {
            this.filesList = new JList(new DefaultListModel());
            TapenadeFrame.setFont(this.getFilesList());
            this.filesList.setVisibleRowCount(3);
        }
        return this.filesList;
    }

    private JScrollPane getScrollFiles() {
        if (this.scrollFiles == null) {
            this.scrollFiles = new JScrollPane(this.getFilesList());
        }
        return this.scrollFiles;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("add");
            TapenadeFrame.setFont(this.addButton);
            this.addButton.setOpaque(false);
            this.addButton.addActionListener(new ActionListener(){
                private final JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.chooser.setMultiSelectionEnabled(true);
                    int result = this.chooser.showDialog(TapenadeFrame.getInstance(), "Add Files");
                    if (result == 0) {
                        File[] files = this.chooser.getSelectedFiles();
                        DefaultListModel model = (DefaultListModel)ExtFilesPanel.this.filesList.getModel();
                        for (File file : files) {
                            boolean presence = false;
                            Enumeration enumeration = model.elements();
                            while (enumeration.hasMoreElements()) {
                                if (!enumeration.nextElement().toString().equals(file.toString())) continue;
                                presence = true;
                            }
                            if (presence) continue;
                            model.addElement(file);
                        }
                    }
                }
            });
        }
        return this.addButton;
    }

    private JButton getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = new JButton();
            this.removeButton.setText("remove");
            TapenadeFrame.setFont(this.removeButton);
            this.removeButton.setOpaque(false);
            this.removeButton.addActionListener(e -> {
                Object[] files = this.getFilesList().getSelectedValuesList().toArray();
                DefaultListModel model = (DefaultListModel)this.getFilesList().getModel();
                for (Object file : files) {
                    model.removeElement(file);
                }
            });
        }
        return this.removeButton;
    }

    protected JCheckBox getNoLibCheckBox() {
        if (this.noLib == null) {
            String title = this.mode != 0 ? "noADlib" : "nolib";
            this.noLib = new JCheckBox(title);
            this.noLib.setOpaque(false);
            this.noLib.setSelected(false);
            TapenadeFrame.setFont(this.noLib);
            this.noLib.addActionListener(e -> {
                if (!this.noLib.isSelected()) {
                    this.filesList.setEnabled(true);
                    this.scrollFiles.setEnabled(true);
                    this.addButton.setEnabled(true);
                    this.removeButton.setEnabled(true);
                } else {
                    this.filesList.setEnabled(false);
                    this.scrollFiles.setEnabled(false);
                    this.addButton.setEnabled(false);
                    this.removeButton.setEnabled(false);
                }
            });
        }
        return this.noLib;
    }

    private JSplitPane getSplitPanel() {
        if (this.splitPanel == null) {
            this.splitPanel = new JSplitPane(0);
            this.splitPanel.setOpaque(false);
            this.splitPanel.setBorder(null);
            this.splitPanel.setDividerSize(0);
            JPanel top = new JPanel();
            top.setOpaque(false);
            top.setLayout(new GridBagLayout());
            GridBagConstraints constraintsAddButton = new GridBagConstraints();
            constraintsAddButton.gridx = 1;
            constraintsAddButton.gridy = 0;
            constraintsAddButton.anchor = 15;
            constraintsAddButton.fill = 2;
            constraintsAddButton.insets = new Insets(4, 4, 4, 4);
            top.add((Component)this.getAddButton(), constraintsAddButton);
            GridBagConstraints constraintsRemoveButton = new GridBagConstraints();
            constraintsRemoveButton.gridx = 1;
            constraintsRemoveButton.gridy = 1;
            constraintsRemoveButton.anchor = 11;
            constraintsRemoveButton.fill = 2;
            constraintsRemoveButton.insets = new Insets(4, 4, 4, 4);
            top.add((Component)this.getRemoveButton(), constraintsRemoveButton);
            GridBagConstraints constraintsList = new GridBagConstraints();
            constraintsList.gridx = 0;
            constraintsList.gridy = 0;
            constraintsList.gridheight = 3;
            constraintsList.fill = 1;
            constraintsList.weightx = 1.0;
            constraintsList.weighty = 1.0;
            constraintsList.insets = new Insets(4, 4, 4, 4);
            top.add((Component)this.getScrollFiles(), constraintsList);
            JPanel bottom = new JPanel();
            bottom.setOpaque(false);
            bottom.setLayout(new GridBagLayout());
            GridBagConstraints constraintsNoLib = new GridBagConstraints();
            constraintsNoLib.gridx = 0;
            constraintsNoLib.gridy = 0;
            constraintsNoLib.gridheight = 1;
            constraintsNoLib.fill = 1;
            constraintsNoLib.insets = new Insets(4, 4, 4, 4);
            bottom.add((Component)this.getNoLibCheckBox(), constraintsNoLib);
            this.splitPanel.setOrientation(0);
            this.splitPanel.setTopComponent(top);
            this.splitPanel.setBottomComponent(bottom);
        }
        return this.splitPanel;
    }
}

