/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.gui;

import fr.inria.tapenade.gui.FileFilter;
import fr.inria.tapenade.gui.TapenadeFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class FilesPanel
extends JPanel {
    private static final long serialVersionUID = 42624299994054L;
    private JList<File> filesList;
    private DefaultListModel<File> model;
    private JScrollPane scrollFiles;
    private JButton addButton;
    private JButton removeButton;
    private JButton parseButton;

    protected FilesPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Select Files :"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        GridBagConstraints constraintsAddButton = new GridBagConstraints();
        constraintsAddButton.gridx = 1;
        constraintsAddButton.gridy = 0;
        constraintsAddButton.fill = 2;
        constraintsAddButton.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.getAddButton(), constraintsAddButton);
        GridBagConstraints constraintsRemoveButton = new GridBagConstraints();
        constraintsRemoveButton.gridx = 1;
        constraintsRemoveButton.gridy = 1;
        constraintsRemoveButton.fill = 2;
        constraintsRemoveButton.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.getRemoveButton(), constraintsRemoveButton);
        GridBagConstraints constraintsValidateButton = new GridBagConstraints();
        constraintsValidateButton.gridx = 1;
        constraintsValidateButton.gridy = 2;
        constraintsValidateButton.fill = 2;
        constraintsValidateButton.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.getParseButton(), constraintsValidateButton);
        GridBagConstraints constraintsList = new GridBagConstraints();
        constraintsList.gridx = 0;
        constraintsList.gridy = 0;
        constraintsList.gridheight = 3;
        constraintsList.gridwidth = 1;
        constraintsList.fill = 1;
        constraintsList.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.getScrollFiles(), constraintsList);
        this.desactivateOptions();
    }

    protected JList<File> getFilesList() {
        if (this.filesList == null) {
            this.model = new DefaultListModel();
            this.filesList = new JList<File>(this.model);
            this.filesList.setVisibleRowCount(3);
            this.filesList.setPreferredSize(null);
            TapenadeFrame.setFont(this.filesList);
        }
        return this.filesList;
    }

    private JScrollPane getScrollFiles() {
        if (this.scrollFiles == null) {
            this.scrollFiles = new JScrollPane(this.getFilesList());
        }
        return this.scrollFiles;
    }

    private JButton getParseButton() {
        if (this.parseButton == null) {
            this.parseButton = new JButton();
            this.parseButton.setText("parse");
            TapenadeFrame.setFont(this.parseButton);
            this.parseButton.setOpaque(false);
            this.parseButton.setEnabled(false);
            this.parseButton.setMargin(new Insets(4, 4, 4, 4));
            this.parseButton.addActionListener(e -> {
                TapenadeFrame.getInstance().getTopUnitPanel().getUnits().removeAllItems();
                if (this.model.size() < 0) {
                    TapenadeFrame.getInstance().setTopUnitName("");
                    ((DefaultListModel)TapenadeFrame.getInstance().getInputVariablesPanel().getVariablesList().getModel()).removeAllElements();
                    ((DefaultListModel)TapenadeFrame.getInstance().getOutputVariablesPanel().getVariablesList().getModel()).removeAllElements();
                }
                TapenadeFrame.getInstance().getTopUnitPanel().setRecompute(true);
                TapenadeFrame.getInstance().preprocess();
                TapenadeFrame.getInstance().getTopUnitPanel().setRecompute(false);
                if (!this.model.isEmpty()) {
                    this.activateOptions();
                }
                TapenadeFrame.getInstance().pack();
            });
        }
        return this.parseButton;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("add");
            TapenadeFrame.setFont(this.addButton);
            this.addButton.setOpaque(false);
            this.addButton.setMargin(new Insets(4, 4, 4, 4));
            this.addButton.addActionListener(new ActionListener(){
                private JFileChooser chooser;

                public ActionListener initialyse() {
                    this.chooser = new JFileChooser(System.getProperty("user.dir"));
                    this.chooser.setMultiSelectionEnabled(true);
                    TapenadeFrame.setFont(this.chooser);
                    FileFilter fortran77Filter = new FileFilter();
                    fortran77Filter.setDescription("Fortran77");
                    fortran77Filter.addExtension("f");
                    fortran77Filter.addExtension("fortran");
                    fortran77Filter.addExtension("for");
                    FileFilter fortran95Filter = new FileFilter();
                    fortran95Filter.setDescription("Fortran95");
                    fortran95Filter.addExtension("f95");
                    fortran95Filter.addExtension("f90");
                    FileFilter cFilter = new FileFilter();
                    cFilter.setDescription("C");
                    cFilter.addExtension("c");
                    FileFilter fortranCFilter = new FileFilter();
                    fortranCFilter.setDescription("*.*");
                    fortranCFilter.addExtension("f");
                    fortranCFilter.addExtension("fortran");
                    fortranCFilter.addExtension("for");
                    fortranCFilter.addExtension("f95");
                    fortranCFilter.addExtension("f90");
                    fortranCFilter.addExtension("c");
                    this.chooser.addChoosableFileFilter(fortran77Filter);
                    this.chooser.addChoosableFileFilter(fortran95Filter);
                    this.chooser.addChoosableFileFilter(cFilter);
                    this.chooser.setFileFilter(fortranCFilter);
                    return this;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    int result = this.chooser.showDialog(TapenadeFrame.getInstance(), "Add Files");
                    if (result == 0) {
                        File[] files;
                        for (File file : files = this.chooser.getSelectedFiles()) {
                            boolean presence = false;
                            Enumeration enumeration = FilesPanel.this.model.elements();
                            while (enumeration.hasMoreElements()) {
                                if (!((File)enumeration.nextElement()).toString().equals(file.toString())) continue;
                                presence = true;
                            }
                            if (presence) continue;
                            FilesPanel.this.model.addElement(file);
                        }
                        if (!FilesPanel.this.model.isEmpty()) {
                            FilesPanel.this.getParseButton().setEnabled(true);
                        }
                    }
                }
            }.initialyse());
        }
        return this.addButton;
    }

    private JButton getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = new JButton();
            this.removeButton.setText("remove");
            TapenadeFrame.setFont(this.removeButton);
            this.removeButton.setOpaque(false);
            this.addButton.setMargin(new Insets(4, 4, 4, 4));
            this.removeButton.addActionListener(e -> {
                for (int i = 0; i < this.model.getSize(); ++i) {
                    this.model.removeElement(this.model.getElementAt(i));
                }
                if (this.model.getSize() == 0) {
                    this.getParseButton().setEnabled(false);
                }
            });
        }
        return this.removeButton;
    }

    private void activateOptions() {
        TapenadeFrame.getInstance().getTopUnitPanel().getUnits().setEnabled(true);
        TapenadeFrame.getInstance().getInputVariablesPanel().getAddButton().setEnabled(true);
        TapenadeFrame.getInstance().getInputVariablesPanel().getRemoveButton().setEnabled(true);
        TapenadeFrame.getInstance().getOutputVariablesPanel().getAddButton().setEnabled(true);
        TapenadeFrame.getInstance().getOutputVariablesPanel().getRemoveButton().setEnabled(true);
        TapenadeFrame.getInstance().getAnalyseModePanel().getTangentModeButton().setEnabled(true);
        TapenadeFrame.getInstance().getAnalyseModePanel().getReverseModeButton().setEnabled(true);
        TapenadeFrame.getInstance().getAnalyseModePanel().getTangentVectorModeButton().setEnabled(true);
        TapenadeFrame.getInstance().getAnalyseModePanel().getReverseVectorModeButton().setEnabled(true);
        TapenadeFrame.getInstance().getControlPanel().getDifferentiateButton().setEnabled(true);
        TapenadeFrame.getInstance().getControlPanel().getHtmlCheckBox().setEnabled(true);
    }

    private void desactivateOptions() {
        TapenadeFrame.getInstance().getTopUnitPanel().getUnits().setEnabled(false);
        TapenadeFrame.getInstance().getInputVariablesPanel().getAddButton().setEnabled(false);
        TapenadeFrame.getInstance().getInputVariablesPanel().getRemoveButton().setEnabled(false);
        TapenadeFrame.getInstance().getOutputVariablesPanel().getAddButton().setEnabled(false);
        TapenadeFrame.getInstance().getOutputVariablesPanel().getRemoveButton().setEnabled(false);
        TapenadeFrame.getInstance().getAnalyseModePanel().getTangentModeButton().setEnabled(false);
        TapenadeFrame.getInstance().getAnalyseModePanel().getReverseModeButton().setEnabled(false);
        TapenadeFrame.getInstance().getAnalyseModePanel().getTangentVectorModeButton().setEnabled(false);
        TapenadeFrame.getInstance().getAnalyseModePanel().getReverseVectorModeButton().setEnabled(false);
        TapenadeFrame.getInstance().getControlPanel().getDifferentiateButton().setEnabled(false);
        TapenadeFrame.getInstance().getControlPanel().getHtmlCheckBox().setEnabled(false);
    }
}

