/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.gui;

import fr.inria.tapenade.gui.TapenadeFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class VariablesChooser
extends JDialog {
    private static final long serialVersionUID = 1234099994876L;
    private JList<String> varsList;
    private JScrollPane scroll;
    private JPanel buttonPane;
    private JButton okButton;
    private JButton cancelButton;
    private boolean ok;

    protected VariablesChooser(JFrame owner) {
        super(owner, "Add Variables", true);
        this.initialize();
    }

    private final void initialize() {
        this.setBackground(this);
        JPanel pane = new JPanel();
        pane.setLayout(new GridBagLayout());
        this.setBackground(pane);
        GridBagConstraints constraintsScrollPane = new GridBagConstraints();
        constraintsScrollPane.gridx = 0;
        constraintsScrollPane.gridy = 0;
        constraintsScrollPane.anchor = 11;
        constraintsScrollPane.fill = 1;
        constraintsScrollPane.insets = new Insets(4, 4, 4, 4);
        pane.add((Component)this.getJScrollPane(), constraintsScrollPane);
        GridBagConstraints constraintsJButtonPane = new GridBagConstraints();
        constraintsJButtonPane.gridx = 0;
        constraintsJButtonPane.gridy = 1;
        constraintsJButtonPane.fill = 2;
        constraintsJButtonPane.insets = new Insets(4, 4, 4, 4);
        pane.add((Component)this.getJButtonPane(), constraintsJButtonPane);
        this.setContentPane(pane);
        this.setSize(277, 300);
        int[] center = TapenadeFrame.center(this);
        this.setLocation(center[0], center[1]);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
                VariablesChooser.this.setVisible(false);
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }
        });
    }

    private void setBackground(Component c) {
        c.setBackground(new Color(204, 204, 255));
    }

    private JScrollPane getJScrollPane() {
        if (this.scroll == null) {
            this.scroll = new JScrollPane(this.getJList());
            this.scroll.setOpaque(false);
        }
        return this.scroll;
    }

    private JPanel getJButtonPane() {
        if (this.buttonPane == null) {
            this.buttonPane = new JPanel();
            this.buttonPane.setOpaque(false);
            FlowLayout buttonPaneLayout = new FlowLayout(2);
            this.buttonPane.setLayout(buttonPaneLayout);
            this.buttonPane.add(this.getOkButton());
            this.buttonPane.add(this.getCancelButton());
        }
        return this.buttonPane;
    }

    private JList<String> getJList() {
        if (this.varsList == null) {
            this.varsList = new JList();
            this.varsList.setFont(new Font("dialog", 1, 12));
            this.varsList.setModel(new DefaultListModel());
            this.varsList.setVisibleRowCount(8);
        }
        return this.varsList;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("add Variables");
            this.okButton.setFont(new Font("dialog", 0, 11));
            this.okButton.setOpaque(false);
            this.okButton.addActionListener(e -> {
                this.setVisible(false);
                this.ok = true;
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("cancel");
            this.cancelButton.setFont(new Font("dialog", 0, 11));
            this.cancelButton.setOpaque(false);
            this.cancelButton.addActionListener(e -> this.setVisible(false));
        }
        return this.cancelButton;
    }

    protected void showDialog(Iterable<String> vars) {
        this.update(this.getGraphics());
        DefaultListModel model = (DefaultListModel)this.getJList().getModel();
        model.removeAllElements();
        for (String var : vars) {
            model.addElement(var);
        }
        this.setVisible(true);
    }

    protected Iterable<String> getVariables() {
        ArrayList<String> vars = new ArrayList<String>();
        if (this.ok) {
            Object[] values = this.getJList().getSelectedValuesList().toArray();
            Collections.addAll(vars, values);
            this.ok = false;
        }
        return vars;
    }
}

