/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.gui;

import fr.inria.tapenade.gui.TapenadeFrame;
import fr.inria.tapenade.gui.VariablesChooser;
import fr.inria.tapenade.representation.Unit;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

final class VariablesPanel
extends JPanel {
    private static final long serialVersionUID = 4554299994054L;
    protected static final int OUTPUT = 0;
    protected static final int INPUT = 1;
    private final int mode;
    private JList<String> variablesList;
    private JScrollPane scrollFiles;
    private JButton addButton;
    private JButton removeButton;

    protected VariablesPanel(int mode) {
        this.mode = mode;
        this.setPreferredSize(new Dimension(230, 120));
        this.initialize();
    }

    private final void initialize() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        String title = this.mode == 0 ? "Output Variables :" : "Input Variables :";
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints constraintsAddButton = new GridBagConstraints();
        constraintsAddButton.gridx = 1;
        constraintsAddButton.gridy = 0;
        constraintsAddButton.anchor = 15;
        constraintsAddButton.fill = 2;
        constraintsAddButton.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.getAddButton(), constraintsAddButton);
        GridBagConstraints constraintsRemoveButton = new GridBagConstraints();
        constraintsRemoveButton.gridx = 1;
        constraintsRemoveButton.gridy = 1;
        constraintsRemoveButton.anchor = 11;
        constraintsRemoveButton.fill = 2;
        constraintsRemoveButton.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.getRemoveButton(), constraintsRemoveButton);
        GridBagConstraints constraintsList = new GridBagConstraints();
        constraintsList.gridx = 0;
        constraintsList.gridy = 0;
        constraintsList.gridheight = 3;
        constraintsList.fill = 1;
        constraintsList.weightx = 1.0;
        constraintsList.weighty = 1.0;
        constraintsList.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.getScrollFiles(), constraintsList);
    }

    protected JList<String> getVariablesList() {
        if (this.variablesList == null) {
            this.variablesList = new JList(new DefaultListModel());
            TapenadeFrame.setFont(this.getVariablesList());
            this.variablesList.setVisibleRowCount(3);
        }
        return this.variablesList;
    }

    protected JScrollPane getScrollFiles() {
        if (this.scrollFiles == null) {
            this.scrollFiles = new JScrollPane(this.getVariablesList());
        }
        return this.scrollFiles;
    }

    protected JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("add");
            TapenadeFrame.setFont(this.addButton);
            this.addButton.setOpaque(false);
            this.addButton.addActionListener(new ActionListener(){
                private VariablesChooser chooser;

                public ActionListener initialyse() {
                    this.chooser = new VariablesChooser(TapenadeFrame.getInstance());
                    return this;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    String unitName = (String)TapenadeFrame.getInstance().getTopUnitPanel().getUnits().getSelectedItem();
                    Unit unit = TapenadeFrame.getInstance().getCallGraph().getAnyUnit(unitName);
                    TapenadeFrame.getInstance().buildExternalContext(unit);
                    DefaultListModel model = VariablesPanel.this.mode == 0 ? (DefaultListModel)TapenadeFrame.getInstance().getOutputVariablesPanel().getVariablesList().getModel() : (DefaultListModel)TapenadeFrame.getInstance().getInputVariablesPanel().getVariablesList().getModel();
                    Enumeration enumeration = model.elements();
                    while (enumeration.hasMoreElements()) {
                        TapenadeFrame.getInstance().getVariables().remove(enumeration.nextElement());
                    }
                    this.chooser.showDialog(TapenadeFrame.getInstance().getVariables());
                    for (String o : this.chooser.getVariables()) {
                        model.addElement(o);
                    }
                }
            }.initialyse());
        }
        return this.addButton;
    }

    protected JButton getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = new JButton();
            this.removeButton.setText("remove");
            TapenadeFrame.setFont(this.removeButton);
            this.removeButton.setOpaque(false);
            this.removeButton.addActionListener(e -> {
                Object[] vars = this.mode == 0 ? TapenadeFrame.getInstance().getOutputVariablesPanel().getVariablesList().getSelectedValuesList().toArray() : TapenadeFrame.getInstance().getInputVariablesPanel().getVariablesList().getSelectedValuesList().toArray();
                DefaultListModel model = this.mode == 0 ? (DefaultListModel)TapenadeFrame.getInstance().getOutputVariablesPanel().getVariablesList().getModel() : (DefaultListModel)TapenadeFrame.getInstance().getInputVariablesPanel().getVariablesList().getModel();
                for (Object var : vars) {
                    model.removeElement(var);
                }
            });
        }
        return this.removeButton;
    }
}

