/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.ir2tree;

import fr.inria.tapenade.ir2tree.DeclStruct;
import fr.inria.tapenade.representation.AlignmentBoundary;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.utils.Tree;

final class EquivalenceDeclStruct
extends DeclStruct {
    private TapList<OneEquiv> oneEquivs;

    protected EquivalenceDeclStruct() {
        this.usedNames = null;
        this.kind = 5;
        this.symbolDecl = null;
        this.alphabeticalIdent = "";
    }

    protected void appendEquivalence(VariableDecl v1, AlignmentBoundary b1, VariableDecl v2, AlignmentBoundary b2) {
        if (!TapList.contains(this.usedNames, v1)) {
            this.usedNames = new TapList<VariableDecl>(v1, this.usedNames);
        }
        if (!TapList.contains(this.usedNames, v2)) {
            this.usedNames = new TapList<VariableDecl>(v2, this.usedNames);
        }
        this.oneEquivs = new TapList<OneEquiv>(new OneEquiv(v1, b1, v2, b2), this.oneEquivs);
    }

    protected boolean isEmpty() {
        return this.oneEquivs == null;
    }

    @Override
    protected Tree generateTree(TapList<SymbolDecl> declaredTypes, SymbolTable symbolTable) {
        TapList<Tree> equivs = null;
        while (this.oneEquivs != null) {
            OneEquiv oneEquiv = (OneEquiv)this.oneEquivs.head;
            Tree equiv = ILUtils.build(70);
            for (int i = oneEquiv.refs.length - 1; i >= 0; --i) {
                equiv.addChild(oneEquiv.refs[i], 1);
            }
            equivs = new TapList<Tree>(equiv, equivs);
            this.oneEquivs = this.oneEquivs.tail;
        }
        return ILUtils.build(68, equivs);
    }

    @Override
    public String toString() {
        StringBuilder equivsStrings = new StringBuilder();
        TapList<OneEquiv> inEquivs = this.oneEquivs;
        while (inEquivs != null) {
            equivsStrings.append(' ').append(inEquivs.head);
            inEquivs = inEquivs.tail;
        }
        return "Declaration of equivalence " + equivsStrings;
    }

    private static class OneEquiv {
        private final Tree[] refs = new Tree[2];

        private OneEquiv(VariableDecl v1, AlignmentBoundary b1, VariableDecl v2, AlignmentBoundary b2) {
            this.refs[0] = SymbolTable.offsetRef(ILUtils.build(94, v1.symbol), v1.type(), b2.offset - b1.offset);
            this.refs[1] = SymbolTable.offsetRef(ILUtils.build(94, v2.symbol), v2.type(), 0);
        }

        public String toString() {
            StringBuilder equivsString = new StringBuilder();
            for (int i = this.refs.length - 1; i >= 0; --i) {
                equivsString.insert(0, ILUtils.toString(this.refs[i]) + ",");
            }
            return "(" + equivsString + ')';
        }
    }
}

