/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.ir2tree;

import fr.inria.tapenade.ir2tree.DeclStruct;
import fr.inria.tapenade.ir2tree.TreeGen;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.Tree;

final class FunctionDeclStruct
extends DeclStruct {
    protected TapList<FunctionDecl> functionDecls;

    protected FunctionDeclStruct(FunctionDecl functionDecl) {
        this.functionDecls = new TapList<FunctionDecl>(functionDecl, null);
        this.usedNames = functionDecl.dependsOn();
        this.kind = functionDecl.isModule() ? 0 : 6;
        this.symbolDecl = functionDecl;
        this.alphabeticalIdent = functionDecl.symbol;
    }

    @Override
    protected Tree generateTree(TapList<SymbolDecl> declaredTypes, SymbolTable symbolTable) {
        Tree result;
        TapList<Tree> nameTrees = null;
        TapList<FunctionDecl> inFunctionDecls = this.functionDecls;
        FunctionDecl funcDecl = null;
        while (inFunctionDecls != null) {
            funcDecl = (FunctionDecl)inFunctionDecls.head;
            Tree funcNameTree = ILUtils.build(94, funcDecl.symbol);
            nameTrees = new TapList<Tree>(funcNameTree, nameTrees);
            inFunctionDecls = inFunctionDecls.tail;
        }
        if (funcDecl == null) {
            result = null;
        } else if (funcDecl.unit() == null) {
            result = TapEnv.relatedLanguageIsC() ? funcDecl.declarator : ILUtils.build(72, nameTrees);
        } else if (funcDecl.isIntrinsic()) {
            result = ILUtils.build(106, nameTrees);
        } else if (funcDecl.isInterface()) {
            if (funcDecl.unit().enclosingUnitOfInterface == null) {
                Tree unitTree = TreeGen.generate(funcDecl.unit(), false, true, false, new TapList<Object>(null, null), new TapList<Object>(null, null));
                if (unitTree != null) {
                    unitTree = unitTree.cutChild(1);
                }
                result = ILUtils.build(104, ILUtils.build(136), ILUtils.build(105, ILUtils.build(103, unitTree)));
            } else {
                result = null;
            }
        } else if (funcDecl.isRenamed()) {
            result = null;
        } else if (funcDecl.isModule()) {
            TapList<String> extraInfoLL = funcDecl.extraInfo();
            if (extraInfoLL == null) {
                Tree extraInfo = ILUtils.build(161);
                result = ILUtils.build(192, (Tree)nameTrees.head, extraInfo);
            } else {
                TapList<TapPair<Unit, Tree>> tmpInfo = extraInfoLL.findExtraInfos(TapEnv.relatedUnit());
                if (tmpInfo == null) {
                    Tree extraInfo = ILUtils.build(161);
                    result = ILUtils.build(192, (Tree)nameTrees.head, extraInfo);
                } else {
                    result = ILUtils.build(26);
                    while (tmpInfo != null) {
                        Tree extraInfo = ILUtils.build(192, (Tree)nameTrees.head, ILUtils.copy((Tree)((TapPair)tmpInfo.head).second));
                        result.addChild(extraInfo, result.length() + 1);
                        tmpInfo = tmpInfo.tail;
                    }
                }
            }
        } else {
            result = funcDecl.unit().hasSource() ? null : (TapEnv.relatedLanguageIsC() ? funcDecl.declarator : ILUtils.build(72, nameTrees));
        }
        return result;
    }

    @Override
    public String toString() {
        return "declaration of Function " + ((FunctionDecl)this.functionDecls.head).symbol;
    }
}

