/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.ir2tree;

import fr.inria.tapenade.ir2tree.ControlStruct;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

final class IfThenElseStruct
extends ControlStruct {
    private FGArrow thenArrow;
    private TapList<ControlStruct> thenBody;
    private FGArrow elseArrow;
    private TapList<ControlStruct> elseBody;
    private TapList<FGArrow> uniqueFollow;

    protected IfThenElseStruct(Block block) {
        this.controlStructBlock = block;
        TapList<FGArrow> arrows = block.flow();
        while (arrows != null) {
            FGArrow arrow = (FGArrow)arrows.head;
            if (arrow.test == 20) {
                if (arrow.cases.head == 2) {
                    this.thenArrow = arrow;
                } else if (arrow.cases.head == 5) {
                    this.elseArrow = arrow;
                }
            }
            arrows = arrows.tail;
        }
    }

    @Override
    protected ControlStruct getBlock(Block block) {
        ControlStruct result = null;
        if (this.controlStructBlock == block) {
            result = this;
        } else {
            TapList<ControlStruct> inBody = this.thenBody;
            while (inBody != null && result == null) {
                result = ((ControlStruct)inBody.head).getBlock(block);
                inBody = inBody.tail;
            }
            inBody = this.elseBody;
            while (inBody != null && result == null) {
                result = ((ControlStruct)inBody.head).getBlock(block);
                inBody = inBody.tail;
            }
        }
        return result;
    }

    @Override
    protected void addControlStruct(ControlStruct struct, FGArrow arrow) {
        if (arrow.cases.head == 2) {
            this.thenBody = new TapList<ControlStruct>(struct, this.thenBody);
        } else {
            this.elseBody = new TapList<ControlStruct>(struct, this.elseBody);
        }
    }

    @Override
    protected void insertLetStructure() {
        this.thenBody = IfThenElseStruct.insertLetStructureChained(this.thenBody, this.controlStructBlock.symbolTable);
        this.elseBody = IfThenElseStruct.insertLetStructureChained(this.elseBody, this.controlStructBlock.symbolTable);
    }

    @Override
    protected void reorderBody() {
        this.thenBody = IfThenElseStruct.reorderBodyChained(this.thenBody);
        this.elseBody = IfThenElseStruct.reorderBodyChained(this.elseBody);
    }

    @Override
    protected void propagateNaturalNext(Block naturalNext) {
        this.naturalNext = naturalNext;
        IfThenElseStruct.propagateNaturalNextChained(this.thenBody, naturalNext);
        IfThenElseStruct.propagateNaturalNextChained(this.elseBody, naturalNext);
    }

    @Override
    protected TapList<FGArrow> propagateNaturalFlow() {
        TapList<FGArrow> afterThen = IfThenElseStruct.propagateNaturalFlowChained(this.thenBody);
        TapList<FGArrow> afterElse = IfThenElseStruct.propagateNaturalFlowChained(this.elseBody);
        this.naturalFlow = TapList.append(afterThen, afterElse);
        return this.naturalFlow;
    }

    @Override
    protected TapList<FGArrow> preGenerateTree(TapList<FGArrow> naturalArrows, TapList<TapTriplet<Tree, Tree, Integer>> includesNameTree, TapList<Tree> fileUserHelpStrings, TapList<ControlStruct> enclosingStructs, boolean skipSubUnits) {
        TapList<FGArrow> arrows;
        this.structuredTree = this.preGenerateBody(this.controlStructBlock.instructions, naturalArrows, includesNameTree, fileUserHelpStrings, skipSubUnits);
        if (this.structuredTree.opCode() == 110) {
            this.structuredTree = this.structuredTree.down(2);
        }
        TapList<FGArrow> afterThen = null;
        TapList<FGArrow> afterElse = null;
        if (this.thenArrow != null) {
            afterThen = IfThenElseStruct.preGenerateTreeChained(this.thenBody, includesNameTree, fileUserHelpStrings, new TapList<FGArrow>(this.thenArrow, null), new TapList<ControlStruct>(this, enclosingStructs), skipSubUnits);
        }
        if (this.elseArrow != null) {
            afterElse = IfThenElseStruct.preGenerateTreeChained(this.elseBody, includesNameTree, fileUserHelpStrings, new TapList<FGArrow>(this.elseArrow, null), new TapList<ControlStruct>(this, enclosingStructs), skipSubUnits);
        }
        TapList<FGArrow> result = TapList.append(afterThen, afterElse);
        if (this.thenArrow == null && this.elseArrow == null) {
            arrows = this.controlStructBlock.flow();
            while (arrows != null) {
                FGArrow arrow = (FGArrow)arrows.head;
                if (arrow.mayBeNatural()) {
                    result = new TapList<FGArrow>(arrow, result);
                }
                arrows = arrows.tail;
            }
        }
        Block destination = null;
        boolean cycle = false;
        boolean sameDestination = true;
        arrows = result;
        while (arrows != null && sameDestination) {
            Block arrowDestination = ((FGArrow)arrows.head).destination;
            boolean arrowCycle = ((FGArrow)arrows.head).inACycle;
            sameDestination = destination == null || arrowDestination == destination && cycle == arrowCycle;
            destination = arrowDestination;
            cycle = arrowCycle;
            arrows = arrows.tail;
        }
        if (result != null && sameDestination) {
            this.uniqueFollow = result;
        }
        return result;
    }

    @Override
    protected void generateTree(boolean delayGoto, TapList<TapTriplet<Tree, Tree, Integer>> includesNameTree, TapList<Tree> fileUserHelpStrings) {
        Tree elseTree;
        Tree thenTree;
        if (this.thenArrow != null && this.thenArrow.carry != null) {
            thenTree = this.uniqueFollow == null ? this.turnCarryIntoJump(this.thenArrow) : ILUtils.build(136);
        } else {
            TapList<Tree> thenSons = IfThenElseStruct.generateTreeChained(this.thenBody, this.uniqueFollow != null, null, includesNameTree, fileUserHelpStrings);
            thenTree = thenSons != null && thenSons.tail == null ? (Tree)thenSons.head : ILUtils.build(26, thenSons);
        }
        if (this.elseArrow != null && this.elseArrow.carry != null) {
            elseTree = this.uniqueFollow == null ? this.turnCarryIntoJump(this.elseArrow) : ILUtils.build(136);
        } else {
            TapList<Tree> elseSons = IfThenElseStruct.generateTreeChained(this.elseBody, this.uniqueFollow != null, null, includesNameTree, fileUserHelpStrings);
            elseTree = elseSons != null && elseSons.tail == null ? (Tree)elseSons.head : ILUtils.build(26, elseSons);
        }
        if (ILUtils.isNotNoneNorEmpty(thenTree)) {
            this.structuredTree.setChild(thenTree, 2);
            this.structuredTree.setChild(elseTree, 3);
        } else if (ILUtils.isNotNoneNorEmpty(elseTree)) {
            Tree testTreeOpposite;
            Tree testTree = this.structuredTree.cutChild(1);
            int negOp = -99;
            switch (testTree.opCode()) {
                case 67: {
                    negOp = 135;
                    break;
                }
                case 135: {
                    negOp = 67;
                    break;
                }
                case 93: {
                    negOp = 113;
                    break;
                }
                case 90: {
                    negOp = 120;
                    break;
                }
                case 120: {
                    negOp = 90;
                    break;
                }
                case 113: {
                    negOp = 93;
                    break;
                }
            }
            if (negOp == -99) {
                testTreeOpposite = ILUtils.build(137, testTree);
            } else {
                testTreeOpposite = ILUtils.build(negOp, testTree.cutChild(1), testTree.cutChild(2));
                if (testTree.getAnnotation("boolean") != null) {
                    testTreeOpposite.setAnnotation("boolean", "boolean");
                }
            }
            this.structuredTree.setChild(testTreeOpposite, 1);
            this.structuredTree.setChild(elseTree, 2);
            this.structuredTree.setChild(thenTree, 3);
        } else if (this.structuredTree.length() >= 3) {
            this.structuredTree.setChild(thenTree, 2);
            this.structuredTree.setChild(elseTree, 3);
        }
        if (this.uniqueFollow != null && !delayGoto) {
            Tree followJump = null;
            while (this.uniqueFollow != null) {
                FGArrow followArrow = (FGArrow)this.uniqueFollow.head;
                if (followJump == null) {
                    followJump = this.turnCarryIntoJump(followArrow);
                }
                followArrow.carry = null;
                this.uniqueFollow = this.uniqueFollow.tail;
            }
            if (followJump != null) {
                this.insertInstructionTree(followJump, true);
            }
        }
    }

    @Override
    public void dump(int indent) throws IOException {
        TapEnv.print("IfThenElse ");
        super.dump(indent);
        TapEnv.print(" Then:{");
        TapEnv.println();
        TapList<ControlStruct> inBody = this.thenBody;
        while (inBody != null) {
            TapEnv.indent(indent + 2);
            ((ControlStruct)inBody.head).dump(indent + 2);
            TapEnv.println();
            inBody = inBody.tail;
        }
        TapEnv.indent(indent);
        TapEnv.print("} Else:{");
        TapEnv.println();
        inBody = this.elseBody;
        while (inBody != null) {
            TapEnv.indent(indent + 2);
            ((ControlStruct)inBody.head).dump(indent + 2);
            TapEnv.println();
            inBody = inBody.tail;
        }
        TapEnv.indent(indent);
        TapEnv.print("}");
    }

    @Override
    public String toString() {
        return "IF:" + this.controlStructBlock + (this.controlStructBlock == null ? "" : " @" + Integer.toHexString(this.controlStructBlock.hashCode()) + " INSTRS:" + this.controlStructBlock.instructions) + ":(" + this.thenBody + ")(" + this.elseBody + ')';
    }
}

