/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.ir2tree;

import fr.inria.tapenade.ir2tree.ControlStruct;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

final class LetStruct
extends ControlStruct {
    protected TapList<ControlStruct> body;
    private SymbolTable symbolTable;

    protected LetStruct(SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
    }

    @Override
    protected void addControlStruct(ControlStruct struct, FGArrow arrow) {
        this.body = new TapList<ControlStruct>(struct, this.body);
    }

    protected void addControlStructAtTail(ControlStruct struct) {
        if (this.body == null) {
            this.body = new TapList<ControlStruct>(struct, null);
        } else {
            this.body.newR(struct);
        }
    }

    @Override
    protected void insertLetStructure() {
        this.body = LetStruct.insertLetStructureChained(this.body, this.symbolTable);
    }

    @Override
    protected void reorderBody() {
        this.body = LetStruct.reorderBodyChained(this.body);
        this.controlStructBlock = ((ControlStruct)this.body.head).controlStructBlock;
    }

    @Override
    protected void propagateNaturalNext(Block naturalNext) {
        this.naturalNext = naturalNext;
        LetStruct.propagateNaturalNextChained(this.body, naturalNext);
    }

    @Override
    protected TapList<FGArrow> propagateNaturalFlow() {
        this.naturalFlow = LetStruct.propagateNaturalFlowChained(this.body);
        return this.naturalFlow;
    }

    @Override
    protected TapList<FGArrow> preGenerateTree(TapList<FGArrow> naturalArrows, TapList<TapTriplet<Tree, Tree, Integer>> includesNameTree, TapList<Tree> fileUserHelpStrings, TapList<ControlStruct> enclosingStructs, boolean skipSubUnits) {
        TapList<FGArrow> arrows = this.controlStructBlock.backFlow();
        TapList<FGArrow> ignoredArrows = null;
        SymbolTable letST = this.controlStructBlock.symbolTable;
        while (arrows != null) {
            FGArrow arrow = (FGArrow)arrows.head;
            SymbolTable origST = arrow.origin.symbolTable;
            if (origST.nestedIn(letST) && arrow.mayBeNatural()) {
                ignoredArrows = new TapList<FGArrow>(arrow, ignoredArrows);
            }
            arrows = arrows.tail;
        }
        this.structuredTree = this.checkLabels(ILUtils.build(26), naturalArrows, null, ignoredArrows);
        this.structuredTree = ILUtils.build(26);
        this.insertInstructionTree(this.structuredTree, true);
        return LetStruct.preGenerateTreeChained(this.body, includesNameTree, fileUserHelpStrings, naturalArrows, new TapList<ControlStruct>(this, enclosingStructs), skipSubUnits);
    }

    @Override
    protected void generateTree(boolean delayGoto, TapList<TapTriplet<Tree, Tree, Integer>> includesNameTree, TapList<Tree> fileUserHelpStrings) {
        int i = 1;
        TapList<Tree> sons = LetStruct.generateTreeChained(this.body, delayGoto, null, includesNameTree, fileUserHelpStrings);
        while (sons != null) {
            this.structuredTree.addChild((Tree)sons.head, i);
            ++i;
            sons = sons.tail;
        }
    }

    @Override
    public void dump(int indent) throws IOException {
        TapEnv.print("Let ");
        super.dump(indent);
        TapEnv.print(" Contents:{");
        TapEnv.println();
        TapList<ControlStruct> inBody = this.body;
        while (inBody != null) {
            TapEnv.indent(indent + 2);
            ((ControlStruct)inBody.head).dump(indent + 2);
            TapEnv.println();
            inBody = inBody.tail;
        }
        TapEnv.indent(indent);
        TapEnv.print("}");
    }

    @Override
    public String toString() {
        return "LET:" + this.controlStructBlock + (this.controlStructBlock == null ? "" : " @" + Integer.toHexString(this.controlStructBlock.hashCode()) + " INSTRS:" + this.controlStructBlock.instructions) + " :(" + this.body + ')';
    }
}

