/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.ir2tree;

import fr.inria.tapenade.ir2tree.ControlStruct;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.HeaderBlock;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

final class LoopStruct
extends ControlStruct {
    private final String cycleLabel;
    private TapList<ControlStruct> body;
    private FGArrow loopArrow;
    private FGArrow exitArrow;

    protected LoopStruct(Block block) {
        this.cycleLabel = null;
        this.controlStructBlock = block;
        TapList<FGArrow> arrows = block.flow();
        while (arrows != null) {
            FGArrow arrow = (FGArrow)arrows.head;
            if (arrow.test == 30) {
                TapIntList cases = arrow.cases;
                while (cases != null) {
                    if (cases.head == 0) {
                        this.exitArrow = arrow;
                    } else if (cases.head == 1) {
                        this.loopArrow = arrow;
                    }
                    cases = cases.tail;
                }
            }
            arrows = arrows.tail;
        }
    }

    @Override
    protected void addControlStruct(ControlStruct struct, FGArrow arrow) {
        this.body = new TapList<ControlStruct>(struct, this.body);
    }

    @Override
    protected void insertLetStructure() {
        this.body = LoopStruct.insertLetStructureChained(this.body, this.controlStructBlock.symbolTable);
    }

    @Override
    protected void reorderBody() {
        this.body = LoopStruct.reorderBodyChained(this.body);
    }

    @Override
    protected void propagateNaturalNext(Block naturalNext) {
        if (this.controlStructBlock instanceof HeaderBlock && this.controlStructBlock.enclosingLoop() != null && this.allGoToDestination(this.controlStructBlock.enclosingLoop().exitArrows, naturalNext)) {
            this.naturalNext = naturalNext;
        }
        LoopStruct.propagateNaturalNextChained(this.body, this.controlStructBlock);
    }

    private boolean allGoToDestination(TapList<FGArrow> arrows, Block destination) {
        boolean ok = true;
        while (ok && arrows != null) {
            ok = ((FGArrow)arrows.head).destination == destination;
            arrows = arrows.tail;
        }
        return ok;
    }

    @Override
    protected TapList<FGArrow> propagateNaturalFlow() {
        LoopStruct.propagateNaturalFlowChained(this.body);
        this.naturalFlow = new TapList<FGArrow>(this.exitArrow, null);
        return this.naturalFlow;
    }

    @Override
    protected TapList<FGArrow> preGenerateTree(TapList<FGArrow> naturalArrows, TapList<TapTriplet<Tree, Tree, Integer>> includesNameTree, TapList<Tree> fileUserHelpStrings, TapList<ControlStruct> enclosingStructs, boolean skipSubUnits) {
        VariableDecl indexDecl;
        TapList<FGArrow> afterIteration = LoopStruct.preGenerateTreeChained(this.body, includesNameTree, fileUserHelpStrings, new TapList<FGArrow>(this.loopArrow, null), new TapList<ControlStruct>(this, enclosingStructs), skipSubUnits);
        this.structuredTree = this.checkLabels(((Instruction)this.controlStructBlock.instructions.head).copyTreePlusComments(), naturalArrows, afterIteration, null);
        this.insertInstructionTree(this.structuredTree, true);
        if (this.structuredTree.opCode() == 110) {
            this.structuredTree = this.structuredTree.down(2);
        }
        if (this.structuredTree.opCode() == 119 && this.structuredTree.down(3).opCode() == 63 && this.controlStructBlock instanceof HeaderBlock && ((HeaderBlock)this.controlStructBlock).declaresItsIterator && (indexDecl = this.controlStructBlock.symbolTable.getVariableDecl(ILUtils.baseName(this.structuredTree.down(3).down(1)))) != null && indexDecl.type().wrappedType != null) {
            Tree typeTree = indexDecl.type().wrappedType.generateTree(this.controlStructBlock.symbolTable, null, null, true, null);
            Tree indexTree = this.structuredTree.down(3).cutChild(1);
            this.structuredTree.down(3).setChild(ILUtils.build(194, ILUtils.build(128), typeTree, ILUtils.build(53, indexTree)), 1);
        }
        if (this.exitArrow == null) {
            return null;
        }
        return new TapList<FGArrow>(this.exitArrow, null);
    }

    @Override
    protected void generateTree(boolean delayGoto, TapList<TapTriplet<Tree, Tree, Integer>> includesNameTree, TapList<Tree> fileUserHelpStrings) {
        TapList<Tree> treeList = LoopStruct.generateTreeChained(this.body, false, this.cycleLabel, includesNameTree, fileUserHelpStrings);
        if (TapList.length(treeList) == 1) {
            this.structuredTree.setChild((Tree)treeList.head, 4);
        } else {
            this.structuredTree.setChild(ILUtils.build(26, treeList), 4);
        }
        if (this.loopArrow != null) {
            this.loopArrow.carry = null;
        }
        if (this.exitArrow != null && this.exitArrow.carry != null && !delayGoto) {
            this.insertInstructionTree(this.turnCarryIntoJump(this.exitArrow), false);
        }
    }

    @Override
    public void dump(int indent) throws IOException {
        TapEnv.print("Loop ");
        super.dump(indent);
        TapEnv.print(" Body:{");
        TapEnv.println();
        TapList<ControlStruct> inBody = this.body;
        while (inBody != null) {
            TapEnv.indent(indent + 2);
            ((ControlStruct)inBody.head).dump(indent + 2);
            TapEnv.println();
            inBody = inBody.tail;
        }
        TapEnv.indent(indent);
        TapEnv.print("}");
    }

    @Override
    public String toString() {
        return "LOOP:" + this.controlStructBlock + (this.controlStructBlock == null ? "" : " @" + Integer.toHexString(this.controlStructBlock.hashCode()) + " INSTRS:" + this.controlStructBlock.instructions) + ":(" + this.body + ')';
    }
}

