/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.ir2tree;

import fr.inria.tapenade.ir2tree.ControlStruct;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

final class ParallelControlStruct
extends ControlStruct {
    private final FGArrow arrowIntoBody;
    private TapList<ControlStruct> body;

    protected ParallelControlStruct(Block block) {
        this.controlStructBlock = block;
        this.arrowIntoBody = (FGArrow)block.flow().head;
    }

    @Override
    protected ControlStruct getBlock(Block block) {
        ControlStruct result = null;
        if (this.controlStructBlock == block) {
            result = this;
        } else {
            TapList<ControlStruct> inBody = this.body;
            while (inBody != null && result == null) {
                result = ((ControlStruct)inBody.head).getBlock(block);
                inBody = inBody.tail;
            }
        }
        return result;
    }

    @Override
    protected void addControlStruct(ControlStruct struct, FGArrow arrow) {
        this.body = new TapList<ControlStruct>(struct, this.body);
    }

    @Override
    protected void insertLetStructure() {
        if (this.body != null) {
            this.body = ParallelControlStruct.insertLetStructureChained(this.body, ((ControlStruct)this.body.head).controlStructBlock.symbolTable);
        }
    }

    @Override
    protected void reorderBody() {
        this.body = ParallelControlStruct.reorderBodyChained(this.body);
    }

    @Override
    protected void propagateNaturalNext(Block naturalNext) {
        this.naturalNext = naturalNext;
        ParallelControlStruct.propagateNaturalNextChained(this.body, naturalNext);
    }

    @Override
    protected TapList<FGArrow> propagateNaturalFlow() {
        return ParallelControlStruct.propagateNaturalFlowChained(this.body);
    }

    @Override
    protected TapList<FGArrow> preGenerateTree(TapList<FGArrow> naturalArrows, TapList<TapTriplet<Tree, Tree, Integer>> includesNameTree, TapList<Tree> fileUserHelpStrings, TapList<ControlStruct> enclosingStructs, boolean skipSubUnits) {
        this.structuredTree = this.preGenerateBody(this.controlStructBlock.instructions, naturalArrows, includesNameTree, fileUserHelpStrings, skipSubUnits);
        if (this.structuredTree.opCode() == 110) {
            this.structuredTree = this.structuredTree.down(2);
        }
        return ParallelControlStruct.preGenerateTreeChained(this.body, includesNameTree, fileUserHelpStrings, new TapList<FGArrow>(this.arrowIntoBody, null), new TapList<ControlStruct>(this, enclosingStructs), skipSubUnits);
    }

    @Override
    protected void generateTree(boolean delayGoto, TapList<TapTriplet<Tree, Tree, Integer>> includesNameTree, TapList<Tree> fileUserHelpStrings) {
        TapList<Tree> bodySons = ParallelControlStruct.generateTreeChained(this.body, true, null, includesNameTree, fileUserHelpStrings);
        Tree bodyTree = bodySons == null || this.structuredTree.opCode() != 142 ? ILUtils.build(26, bodySons) : (Tree)bodySons.head;
        this.structuredTree.setChild(bodyTree, 3);
    }

    @Override
    public void dump(int indent) throws IOException {
        TapEnv.print("ParallelControl ");
        super.dump(indent);
        TapEnv.print(" Contents:{");
        TapEnv.println();
        TapList<ControlStruct> inBody = this.body;
        while (inBody != null) {
            TapEnv.indent(indent + 2);
            ((ControlStruct)inBody.head).dump(indent + 2);
            TapEnv.println();
            inBody = inBody.tail;
        }
        TapEnv.indent(indent);
        TapEnv.print("}");
    }

    @Override
    public String toString() {
        return "PARALLEL:" + this.controlStructBlock + (this.controlStructBlock == null ? "" : " @" + Integer.toHexString(this.controlStructBlock.hashCode()) + " INSTRS:" + this.controlStructBlock.instructions) + ":(" + this.body + ')';
    }
}

