/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.ir2tree;

import fr.inria.tapenade.ir2tree.ControlStruct;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

final class SwitchStruct
extends ControlStruct {
    private final int casesArrowNumber;
    protected TapList<FGArrow> naturalArrowsAfterSwitch;
    private FGArrow[] casesArrow;
    private TapList<ControlStruct>[] casesBody;
    private TapList<FGArrow> uniqueFollow;

    protected SwitchStruct(Block block) {
        this.controlStructBlock = block;
        this.casesArrowNumber = TapList.length(block.flow());
        if (this.casesArrowNumber != -1) {
            this.casesArrow = new FGArrow[this.casesArrowNumber];
            this.casesBody = new TapList[this.casesArrowNumber];
        }
        TapList<FGArrow> sortedArrows = this.sortArrowsByCases(block.flow());
        int index = 0;
        while (sortedArrows != null) {
            FGArrow arrow = (FGArrow)sortedArrows.head;
            if (arrow.test == 21) {
                if (arrow.cases.head == -1 || arrow.cases.head == -2) {
                    this.casesArrow[this.casesArrowNumber - 1] = arrow;
                } else {
                    this.casesArrow[index] = arrow;
                    ++index;
                }
            }
            sortedArrows = sortedArrows.tail;
        }
    }

    @Override
    protected void addControlStruct(ControlStruct struct, FGArrow arrow) {
        if (arrow.cases.head != -2) {
            int rank;
            if (arrow.cases.head == -1) {
                rank = this.casesArrowNumber - 1;
            } else {
                rank = -1;
                for (int j = 0; rank == -1 && j < this.casesArrowNumber; ++j) {
                    if (arrow.cases.head != this.casesArrow[j].cases.head) continue;
                    rank = j;
                }
            }
            this.casesBody[rank] = new TapList<ControlStruct>(struct, this.casesBody[rank]);
        }
    }

    @Override
    protected void insertLetStructure() {
        for (int i = 0; i < this.casesArrowNumber; ++i) {
            this.casesBody[i] = SwitchStruct.insertLetStructureChained(this.casesBody[i], this.controlStructBlock.symbolTable);
        }
    }

    @Override
    protected void reorderBody() {
        for (int i = this.casesBody.length - 1; i >= 0; --i) {
            this.casesBody[i] = SwitchStruct.reorderBodyChained(this.casesBody[i]);
        }
    }

    @Override
    protected void propagateNaturalNext(Block naturalNext) {
        this.naturalNext = naturalNext;
        for (int i = this.casesBody.length - 1; i >= 0; --i) {
            if (this.casesBody[i] == null) continue;
            SwitchStruct.propagateNaturalNextChained(this.casesBody[i], naturalNext);
            naturalNext = ((ControlStruct)this.casesBody[i].head).controlStructBlock;
        }
    }

    @Override
    protected TapList<FGArrow> propagateNaturalFlow() {
        TapList<FGArrow> curNaturalFlow = null;
        for (int i = 0; i < this.casesBody.length; ++i) {
            curNaturalFlow = new TapList<FGArrow>(this.casesArrow[i], curNaturalFlow);
            if (this.casesBody[i] == null) continue;
            curNaturalFlow = SwitchStruct.propagateNaturalFlowChained(this.casesBody[i]);
        }
        this.naturalFlow = curNaturalFlow;
        return this.naturalFlow;
    }

    @Override
    protected TapList<FGArrow> preGenerateTree(TapList<FGArrow> naturalArrows, TapList<TapTriplet<Tree, Tree, Integer>> includesNameTree, TapList<Tree> fileUserHelpStrings, TapList<ControlStruct> enclosingStructs, boolean skipSubUnits) {
        this.structuredTree = this.preGenerateBody(this.controlStructBlock.instructions, naturalArrows, includesNameTree, fileUserHelpStrings, skipSubUnits);
        if (this.structuredTree.opCode() == 110) {
            this.structuredTree = this.structuredTree.down(2);
        }
        TapList<FGArrow> afterCase = null;
        for (int i = 0; i < this.casesArrowNumber; ++i) {
            if (this.casesArrow[i] == null) continue;
            if (this.casesArrow[i].cases.head == -2) {
                this.naturalArrowsAfterSwitch = new TapList<FGArrow>(this.casesArrow[i], this.naturalArrowsAfterSwitch);
                continue;
            }
            afterCase = new TapList<FGArrow>(this.casesArrow[i], afterCase);
            if (this.casesBody[i] != null) {
                afterCase = SwitchStruct.preGenerateTreeChained(this.casesBody[i], includesNameTree, fileUserHelpStrings, afterCase, new TapList<ControlStruct>(this, enclosingStructs), skipSubUnits);
            }
            if (!TapEnv.relatedUnit().isFortran()) continue;
            this.naturalArrowsAfterSwitch = TapList.append(this.naturalArrowsAfterSwitch, afterCase);
            afterCase = null;
        }
        TapList<FGArrow> result = TapList.append(this.naturalArrowsAfterSwitch, afterCase);
        Block destination = null;
        boolean cycle = false;
        boolean sameDestination = true;
        TapList<FGArrow> arrows = result;
        while (arrows != null && sameDestination) {
            Block arrowDestination = ((FGArrow)arrows.head).destination;
            boolean arrowCycle = ((FGArrow)arrows.head).inACycle;
            sameDestination = destination == null || arrowDestination == destination && cycle == arrowCycle;
            destination = arrowDestination;
            cycle = arrowCycle;
            arrows = arrows.tail;
        }
        if (result != null && sameDestination) {
            this.uniqueFollow = result;
        }
        return result;
    }

    @Override
    protected void generateTree(boolean delayGoto, TapList<TapTriplet<Tree, Tree, Integer>> includesNameTree, TapList<Tree> fileUserHelpStrings) {
        if (TapEnv.relatedUnit().isFortran()) {
            for (int i = 0; i < this.casesArrowNumber; ++i) {
                if (this.casesArrow[i] == null || TapIntList.length(this.casesArrow[i].cases) <= 1) continue;
                TapIntList casesList = this.casesArrow[i].cases;
                int firstCase = casesList.head == -2 ? -2 : (casesList.head == -1 ? this.structuredTree.down(2).length() : casesList.head + 1);
                casesList = casesList.tail;
                while (casesList != null) {
                    int mergeCase = casesList.head + 1;
                    if (firstCase != -2) {
                        Tree mergeTree = this.mergeExprSwitchCase(this.structuredTree.down(2).down(firstCase).down(1), this.structuredTree.down(2).down(mergeCase).down(1));
                        this.structuredTree.down(2).down(firstCase).setChild(mergeTree, 1);
                    }
                    this.structuredTree.down(2).down(mergeCase).setChild(ILUtils.build(136), 1);
                    casesList = casesList.tail;
                }
            }
        }
        int numberOfCases = this.structuredTree.down(2).length();
        for (int i = 1; i <= numberOfCases; ++i) {
            if (!ILUtils.isNullOrNone(this.structuredTree.down(2).down(i).down(1))) continue;
            this.structuredTree.down(2).removeChild(i);
            --i;
            --numberOfCases;
        }
        Tree[] sons = this.structuredTree.down(2).children();
        int swIndex = 0;
        for (int i = 0; i < this.casesArrowNumber; ++i) {
            int nbMergedCases;
            Tree caseTree;
            if (this.casesArrow[i].cases.head == -2) continue;
            if (this.casesArrow[i] != null && this.casesArrow[i].carry != null) {
                caseTree = ILUtils.build(26, this.turnCarryIntoJump(this.casesArrow[i]));
                TapList<FGArrow> allCaseArrows = this.casesArrow[i].destination.backFlow();
                while (allCaseArrows != null) {
                    ((FGArrow)allCaseArrows.head).carry = null;
                    allCaseArrows = allCaseArrows.tail;
                }
            } else {
                TapList<Tree> caseSons = SwitchStruct.generateTreeChained(this.casesBody[i], false, null, includesNameTree, fileUserHelpStrings);
                caseTree = ILUtils.build(26, caseSons);
            }
            if (!TapEnv.relatedUnit().isFortran() && (nbMergedCases = TapIntList.length(this.casesArrow[i].cases)) > 1) {
                swIndex += nbMergedCases - 1;
            }
            if (ILUtils.isNotNoneNorEmpty(caseTree)) {
                sons[swIndex].setChild(caseTree, 2);
            } else if (TapEnv.relatedUnit().isC()) {
                sons[swIndex].setChild(ILUtils.build(26, ILUtils.build(29)), 2);
            }
            ++swIndex;
        }
        if (this.uniqueFollow != null && !delayGoto) {
            Tree followJump = null;
            while (this.uniqueFollow != null) {
                FGArrow followArrow = (FGArrow)this.uniqueFollow.head;
                if (followJump == null) {
                    followJump = this.turnCarryIntoJump(followArrow);
                }
                followArrow.carry = null;
                this.uniqueFollow = this.uniqueFollow.tail;
            }
            if (followJump != null) {
                this.insertInstructionTree(followJump, true);
            }
        }
    }

    private Tree mergeExprSwitchCase(Tree expr1, Tree expr2) {
        Tree result;
        if (expr1.children().length != 0 && expr2.children().length != 0) {
            expr2.addChildren(ILUtils.copiedSonsList(expr1), -1);
            result = expr2;
        } else {
            result = ILUtils.build(70);
        }
        return result;
    }

    private TapList<FGArrow> sortArrowsByCases(TapList<FGArrow> arrows) {
        TapList<Object> sortedArrows = new TapList<Object>(null, null);
        while (arrows != null) {
            if (((FGArrow)arrows.head).cases != null) {
                int rank = ((FGArrow)arrows.head).cases.head;
                TapList<Object> inSortedArrows = sortedArrows;
                while (inSortedArrows.tail != null && ((FGArrow)inSortedArrows.tail.head).cases.head < rank) {
                    inSortedArrows = inSortedArrows.tail;
                }
                inSortedArrows.placdl(arrows.head);
            }
            arrows = arrows.tail;
        }
        return sortedArrows.tail;
    }

    @Override
    public void dump(int indent) throws IOException {
        TapEnv.print("Switch ");
        super.dump(indent);
        for (int i = 0; i < this.casesArrowNumber; ++i) {
            TapEnv.print(" Case #" + i + this.casesArrow[i].cases + ":{");
            TapEnv.println();
            TapList<ControlStruct> inBody = this.casesBody[i];
            while (inBody != null) {
                TapEnv.indent(indent + 2);
                ((ControlStruct)inBody.head).dump(indent + 2);
                TapEnv.println();
                inBody = inBody.tail;
            }
            TapEnv.indent(indent);
            TapEnv.print("}");
        }
    }

    @Override
    public String toString() {
        StringBuilder contents = new StringBuilder();
        for (int i = 0; i < this.casesArrowNumber; ++i) {
            contents.append("(#").append(i).append('[').append(this.casesArrow[i].cases).append("] ").append(this.casesBody[i]).append(')');
        }
        return "SWITCH:" + this.controlStructBlock + (this.controlStructBlock == null ? "" : " @" + Integer.toHexString(this.controlStructBlock.hashCode()) + " INSTRS:" + this.controlStructBlock.instructions) + ':' + contents;
    }
}

